/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.ConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.RemoteConsumerKey;
import com.ibm.ws.sib.processor.impl.RemoteConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.AIMessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.matching.MatchingConsumerPoint;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class RemoteConsumerDispatcher
extends ConsumerDispatcher {
    private static final TraceComponent tc = SibTr.register((Class)RemoteConsumerDispatcher.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final String _destName;
    private final AnycastInputHandler _aih;
    private boolean _cardinalityOne;
    private boolean _cardinalityChange;
    private boolean _forceFlushInProgress;
    private final SIMPTransactionManager _tranManager;
    private boolean _currentReachability;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteConsumerDispatcher(BaseDestinationHandler baseDestinationHandler, String string, PtoPMessageItemStream ptoPMessageItemStream, ConsumerDispatcherState consumerDispatcherState, AnycastInputHandler anycastInputHandler, SIMPTransactionManager sIMPTransactionManager, boolean bl) {
        super(baseDestinationHandler, ptoPMessageItemStream, consumerDispatcherState);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteConsumerDispatcher", (Object)new Object[]{baseDestinationHandler, string, ptoPMessageItemStream, consumerDispatcherState, anycastInputHandler, sIMPTransactionManager, new Boolean(bl)});
        }
        this._destName = string;
        this._aih = anycastInputHandler;
        this._tranManager = sIMPTransactionManager;
        this._currentReachability = true;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._forceFlushInProgress = false;
            this._cardinalityOne = bl;
            this._cardinalityChange = false;
            if (this._cardinalityOne) {
                anycastInputHandler.rejectAll();
            }
        }
        anycastInputHandler.initRCD(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteConsumerDispatcher", (Object)this);
        }
    }

    public final String getDestName() {
        return this._destName;
    }

    public final MessagingEngine getLocalisationME() {
        return this._aih.getLocalisationME();
    }

    public final void notifyReceiveExclusiveChange(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveExclusiveChange", (Object)new Boolean(bl));
        }
        final boolean bl2 = bl;
        AnycastInputHandler.FlushWorkItem flushWorkItem = new AnycastInputHandler.FlushWorkItem(){

            public void performWorkItem() {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                }
                try {
                    RemoteConsumerDispatcher.this.notifyReceiveExclusiveChangeInternal(bl2);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", (String)"1:243:1.68", (Object)this);
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", "1:251:1.68", sIException}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", "1:259:1.68", sIException});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"performWorkItem", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"performWorkItem");
                }
            }
        };
        this._aih.performFlushWork(flushWorkItem, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveExclusiveChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void notifyReceiveExclusiveChangeInternal(boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveExclusiveChangeInternal", (Object)new Boolean(bl));
        }
        boolean bl2 = true;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._cardinalityOne = bl;
            this._cardinalityChange = true;
            if (this.consumerPoints.size() == 0) {
                bl2 = false;
            }
        }
        if (bl2) {
            super.closeAllConsumersForReceiveExclusive();
        } else {
            this.cardinalityChangeConsumersDetached();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveExclusiveChangeInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerKey attachConsumerPoint(ConsumerPoint consumerPoint, SelectionCriteria selectionCriteria, SIBUuid12 sIBUuid12, boolean bl, boolean bl2) throws SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachConsumerPoint", (Object)new Object[]{consumerPoint, selectionCriteria, sIBUuid12, new Boolean(bl), new Boolean(bl2)});
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            if (!this._currentReachability || this._cardinalityChange || this._forceFlushInProgress) {
                SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationME().toString())}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
            if (this._cardinalityOne && this.consumerPoints.size() != 0) {
                SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("CONSUMERCARDINALITY_LIMIT_REACHED_CWSIP0472", new Object[]{this.getDestName(), this.getLocalisationME().toString()}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
            this._aih.consumerAttaching();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint");
            }
            return super.attachConsumerPoint(consumerPoint, selectionCriteria, sIBUuid12, bl, bl2);
        }
    }

    void detachConsumerPoint(ConsumerKey consumerKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachConsumerPoint", (Object)consumerKey);
        }
        final ConsumerKey consumerKey2 = consumerKey;
        AnycastInputHandler.FlushWorkItem flushWorkItem = new AnycastInputHandler.FlushWorkItem(){

            public void performWorkItem() {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"performWorkItem");
                }
                try {
                    RemoteConsumerDispatcher.this.detachConsumerPointInternal(consumerKey2);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.performWorkItem", (String)"1:373:1.68", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    SIErrorException sIErrorException = new SIErrorException((Throwable)sIException);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"performWorkItem", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"performWorkItem");
                }
            }
        };
        this._aih.performFlushWork(flushWorkItem, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachConsumerPoint");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachConsumerPointInternal(ConsumerKey consumerKey) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        LinkedList linkedList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachConsumerPointInternal", (Object)consumerKey);
        }
        SIErrorException sIErrorException = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            linkedList = this.consumerPoints;
            synchronized (linkedList) {
                if (this._cardinalityOne && !this._cardinalityChange) {
                    bl = true;
                }
            }
            if (bl) {
                this._aih.rejectAll();
                this.removeAllMessagesItemStream();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.detachConsumerPointInternal", (String)"1:422:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            sIErrorException = new SIErrorException((Throwable)exception);
        }
        super.detachConsumerPoint(consumerKey);
        linkedList = this.consumerPoints;
        synchronized (linkedList) {
            boolean bl4;
            boolean bl5 = bl4 = this.consumerPoints.size() == 0;
            if (bl4) {
                if (!(this._cardinalityOne || this._cardinalityChange || this._forceFlushInProgress)) {
                    this._aih.lastCardNConsumerDetached();
                }
                if (this._cardinalityChange) {
                    bl2 = true;
                }
                if (this._forceFlushInProgress) {
                    bl3 = true;
                }
            }
        }
        if (bl2) {
            try {
                this.cardinalityChangeConsumersDetached();
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.detachConsumerPointInternal", (String)"1:463:1.68", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"detachConsumerPointInternal", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (bl3) {
            try {
                this.forceFlushConsumersDetached();
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.detachConsumerPointInternal", (String)"1:478:1.68", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"detachConsumerPointInternal", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (sIErrorException != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"detachConsumerPointInternal", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachConsumerPointInternal");
        }
    }

    public NonLockingCursor getBrowseCursor(Filter filter) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)filter);
            SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor");
        }
        return this._aih.newBrowseCursor(filter);
    }

    public void readyToIssueGet() {
    }

    public void put(AIMessageItem aIMessageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)aIMessageItem);
        }
        RemoteDispatchableKey remoteDispatchableKey = aIMessageItem.getAIStreamKey().getRemoteDispatchableKey();
        RemoteConsumerKey remoteConsumerKey = null;
        if (remoteDispatchableKey instanceof RemoteConsumerKey) {
            remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
        }
        ExternalLocalTransaction externalLocalTransaction = null;
        try {
            externalLocalTransaction = this._tranManager.createLocalTransaction();
            this.itemStream.addItem(aIMessageItem, externalLocalTransaction);
            this.registerForEvents(aIMessageItem);
            externalLocalTransaction.commit();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.put", (String)"1:544:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (externalLocalTransaction != null) {
                try {
                    externalLocalTransaction.rollback();
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.put", (String)"1:557:1.68", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception2);
                }
            }
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("PUTEXCEPTION_DISCONNECT_CONSUMER_CWSIP0473", new Object[]{this.getDestName(), this.getLocalisationME().toString(), exception}, null));
            this.dispatchExceptionToConsumers(sIIncorrectCallException);
            AIStreamKey aIStreamKey = aIMessageItem.getAIStreamKey();
            this._aih.reject(aIStreamKey);
            this.resolve(1, aIStreamKey);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"put");
            }
            return;
        }
        if (remoteConsumerKey != null) {
            remoteConsumerKey.messageReceived(aIMessageItem.getAIStreamKey());
        }
        this.dispatchInternalAndHandleException(aIMessageItem);
    }

    public void put(List list) throws SIResourceException {
        AIMessageItem aIMessageItem;
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)list);
        }
        int n2 = list.size();
        RemoteConsumerKey[] remoteConsumerKeyArray = new RemoteConsumerKey[n2];
        ExternalLocalTransaction externalLocalTransaction = null;
        try {
            externalLocalTransaction = this._tranManager.createLocalTransaction();
            for (n = 0; n < n2; ++n) {
                aIMessageItem = (AIMessageItem)list.get(n);
                RemoteDispatchableKey remoteDispatchableKey = aIMessageItem.getAIStreamKey().getRemoteDispatchableKey();
                if (remoteDispatchableKey instanceof RemoteConsumerKey) {
                    remoteConsumerKeyArray[n] = (RemoteConsumerKey)remoteDispatchableKey;
                }
                this.itemStream.addItem(aIMessageItem, externalLocalTransaction);
                this.registerForEvents(aIMessageItem);
            }
            externalLocalTransaction.commit();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.put", (String)"1:624:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (externalLocalTransaction != null) {
                try {
                    externalLocalTransaction.rollback();
                }
                catch (Exception exception2) {
                    FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.put", (String)"1:637:1.68", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)exception2);
                }
            }
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("PUTEXCEPTION_DISCONNECT_CONSUMER_CWSIP0473", new Object[]{this.getDestName(), this.getLocalisationME().toString(), exception}, null));
            this.dispatchExceptionToConsumers(sIIncorrectCallException);
            for (int i = 0; i < n2; ++i) {
                AIMessageItem aIMessageItem2 = (AIMessageItem)list.get(i);
                AIStreamKey aIStreamKey = aIMessageItem2.getAIStreamKey();
                this._aih.reject(aIStreamKey);
                this.resolve(1, aIStreamKey);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"put");
            }
            return;
        }
        for (n = 0; n < n2; ++n) {
            aIMessageItem = (AIMessageItem)list.get(n);
            if (remoteConsumerKeyArray[n] != null) {
                remoteConsumerKeyArray[n].messageReceived(aIMessageItem.getAIStreamKey());
            }
            this.dispatchInternalAndHandleException(aIMessageItem);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchExceptionToConsumers(SIIncorrectCallException sIIncorrectCallException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchExceptionToConsumers", (Object)((Object)sIIncorrectCallException));
        }
        Object[] objectArray = null;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            objectArray = this.consumerPoints.toArray();
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ConsumerKey consumerKey = (ConsumerKey)objectArray[i];
                consumerKey.notifyConsumerPointAboutException((SIException)((Object)sIIncorrectCallException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchExceptionToConsumers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(int n, AIStreamKey aIStreamKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolve", (Object)new Object[]{new Integer(n), aIStreamKey});
        }
        RemoteDispatchableKey remoteDispatchableKey = aIStreamKey.getRemoteDispatchableKey();
        RemoteConsumerKey remoteConsumerKey = null;
        if (remoteDispatchableKey instanceof RemoteConsumerKey) {
            remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
        }
        boolean bl = false;
        SelectionCriteria[] selectionCriteriaArray = this.readyConsumerPointLock;
        synchronized (this.readyConsumerPointLock) {
            if (remoteDispatchableKey.isKeyReady()) {
                bl = true;
            } else if (remoteConsumerKey != null) {
                remoteConsumerKey.completedReceivedNoPrefetch(aIStreamKey);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (!bl) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"resolve");
                }
                return;
            }
            if (aIStreamKey.getOriginalTimeout() == SIMPConstants.INFINITE_TIMEOUT) {
                selectionCriteriaArray = remoteDispatchableKey.getSelectionCriteria();
                AIStreamKey aIStreamKey2 = this._aih.issueGet(selectionCriteriaArray, aIStreamKey.getOriginalTimeout(), remoteDispatchableKey);
                if (aIStreamKey2 == null) {
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationME().toString())}, null));
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.resolve", (String)"1:755:1.68", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    remoteDispatchableKey.notifyException((SIException)((Object)sIResourceException));
                    if (remoteConsumerKey != null) {
                        remoteConsumerKey.completedReceived(aIStreamKey);
                    }
                }
            } else {
                long l;
                long l2 = System.currentTimeMillis();
                long l3 = l2 + this._aih.getRoundTripTime();
                if (l3 < (l = aIStreamKey.getIssueTime() + aIStreamKey.getOriginalTimeout())) {
                    SelectionCriteria[] selectionCriteriaArray2 = remoteDispatchableKey.getSelectionCriteria();
                    AIStreamKey aIStreamKey3 = this._aih.issueGet(selectionCriteriaArray2, l - l2, remoteDispatchableKey);
                    if (aIStreamKey3 == null) {
                        SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationME().toString())}, null));
                        FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.resolve", (String)"1:782:1.68", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                        remoteDispatchableKey.notifyException((SIException)((Object)sIResourceException));
                        if (remoteConsumerKey != null) {
                            remoteConsumerKey.completedReceived(aIStreamKey);
                        }
                    }
                } else if (remoteConsumerKey != null) {
                    remoteConsumerKey.completedReceived(aIStreamKey);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resolve");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reachabilityChange(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reachabilityChange", (Object)new Boolean(bl));
        }
        Object[] objectArray = null;
        Object object = this.consumerPoints;
        synchronized (object) {
            this._currentReachability = bl;
            if (!this._currentReachability) {
                objectArray = this.consumerPoints.toArray();
            }
        }
        if (objectArray != null) {
            object = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationME().toString())}, null));
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)object);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                ConsumerKey consumerKey = (ConsumerKey)objectArray[i];
                consumerKey.closeLocalisationUnreachable();
                consumerKey.notifyConsumerPointAboutException((SIException)((Object)object));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reachabilityChange");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectCardOneConsumer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"disconnectCardOneConsumer");
        }
        Object[] objectArray = null;
        Object object = this.consumerPoints;
        synchronized (object) {
            objectArray = this.consumerPoints.toArray();
        }
        object = new SILimitExceededException(nls.getFormattedMessage("CONSUMERCARDINALITY_LIMIT_REACHED_CWSIP0472", new Object[]{this.getDestName(), this.getLocalisationME().toString()}, null));
        FFDCFilter.processException((Throwable)object, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.disconnectCardOneConsumer", (String)"1:859:1.68", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)object);
        for (int i = 0; i < objectArray.length; ++i) {
            ConsumerKey consumerKey = (ConsumerKey)objectArray[i];
            consumerKey.notifyConsumerPointAboutException((SIException)((Object)object));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"disconnectCardOneConsumer");
        }
    }

    protected ConsumerKey createConsumerKey(ConsumerPoint consumerPoint, SelectionCriteria selectionCriteria, SIBUuid12 sIBUuid12, boolean bl, boolean bl2) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKey");
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKey");
        }
        return new RemoteConsumerKey(consumerPoint, this, selectionCriteria, sIBUuid12, bl, bl2);
    }

    protected ConsumerKeyGroup createConsumerKeyGroup() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKeyGroup");
        }
        RemoteConsumerKeyGroup remoteConsumerKeyGroup = new RemoteConsumerKeyGroup(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)remoteConsumerKeyGroup);
        }
        return remoteConsumerKeyGroup;
    }

    public final void accept(AIStreamKey aIStreamKey, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"accept", (Object)new Object[]{aIStreamKey, transaction});
        }
        this._aih.accept(aIStreamKey, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"accept");
        }
    }

    public void acceptCommitted(SIMPMessage sIMPMessage) {
        Reliability reliability;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"acceptCommitted", (Object)new Object[]{sIMPMessage});
        }
        if ((reliability = sIMPMessage.getReliability()).compareTo((Object)Reliability.RELIABLE_PERSISTENT) < 0) {
            AIMessageItem aIMessageItem = (AIMessageItem)sIMPMessage;
            this._aih.committed(aIMessageItem.getAIStreamKey());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"acceptCommitted");
        }
    }

    protected void eventPostCommitAdd(SIMPMessage sIMPMessage, Transaction transaction) {
    }

    protected void eventUnlocked(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked", (Object)sIMPMessage);
        }
        AIMessageItem aIMessageItem = (AIMessageItem)sIMPMessage;
        this.dispatchInternalAndHandleException(aIMessageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    private final void dispatchInternalAndHandleException(AIMessageItem aIMessageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchInternalAndHandleException", (Object)aIMessageItem);
        }
        try {
            this.dispatchInternal(aIMessageItem);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.dispatchInternalAndHandleException", (String)"1:965:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.dispatchInternalAndHandleException", (String)"1:974:1.68", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchInternalAndHandleException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchInternal(AIMessageItem aIMessageItem) throws SIException, MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchInternal", (Object)aIMessageItem);
        }
        RemoteDispatchableKey remoteDispatchableKey = aIMessageItem.getAIStreamKey().getRemoteDispatchableKey();
        RemoteConsumerKey remoteConsumerKey = null;
        if (remoteDispatchableKey instanceof RemoteConsumerKey) {
            remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey;
        }
        if (remoteConsumerKey != null) {
            Object object = this.readyConsumerPointLock;
            synchronized (object) {
                if (!remoteConsumerKey.isKeyReady()) {
                    remoteConsumerKey = null;
                } else {
                    remoteConsumerKey.markNotReady();
                    remoteDispatchableKey = (RemoteDispatchableKey)remoteConsumerKey.getParent();
                    this.removeReadyConsumer(remoteDispatchableKey, !remoteDispatchableKey.hasNonSpecificConsumers());
                }
            }
        }
        boolean bl = false;
        if (remoteConsumerKey != null) {
            if (this.dispatcherState.isNoLocal() && remoteConsumerKey.getConnectionUuid().equals((Object)aIMessageItem.getProducerConnectionUuid())) {
                bl = true;
                ExternalLocalTransaction externalLocalTransaction = null;
                externalLocalTransaction = this._tranManager.createLocalTransaction();
                aIMessageItem.remove(externalLocalTransaction, aIMessageItem.getLockID());
                externalLocalTransaction.commit();
                ((LocalConsumerPoint)remoteConsumerKey.consumerPoint).waitingNotify();
            } else {
                remoteConsumerKey.updateLastNotReadyTime();
                bl = remoteConsumerKey.consumerPoint.put(aIMessageItem, true);
            }
        }
        if (!bl) {
            remoteConsumerKey = null;
            boolean bl2 = true;
            boolean bl3 = false;
            MatchingConsumerPoint[] matchingConsumerPointArray = null;
            int n = 0;
            int n2 = 0;
            boolean bl4 = true;
            long l = 0L;
            while (bl2) {
                Object[] objectArray;
                Object object;
                if (bl3) {
                    object = (MessageProcessorSearchResults)this.messageProcessor.getSearchResultsObjectPool().remove();
                    object = this.messageProcessor.getMessageProcessorMatching().retrieveMatchingConsumerPoints(this.baseDestination.getUuid(), aIMessageItem.getMessage(), (MessageProcessorSearchResults)object);
                    objectArray = ((MessageProcessorSearchResults)object).getResults(this.baseDestination.getName());
                    Set set = (Set)objectArray[2];
                    matchingConsumerPointArray = set.toArray(new MatchingConsumerPoint[0]);
                    int n3 = matchingConsumerPointArray.length;
                    if (n3 <= 0) break;
                    n = n2 = aIMessageItem.getProducerSeed() % n3;
                    bl3 = false;
                }
                object = this.readyConsumerPointLock;
                synchronized (object) {
                    if (bl4) {
                        l = this.readyConsumerVersion;
                        bl4 = false;
                    }
                    if (matchingConsumerPointArray == null) {
                        remoteDispatchableKey = (RemoteDispatchableKey)((Object)this.nonSpecificReadyCPs.getFirst());
                        remoteConsumerKey = null;
                        if (remoteDispatchableKey != null && remoteDispatchableKey.getVersion() > l) {
                            remoteDispatchableKey = null;
                        }
                        if (remoteDispatchableKey == null) {
                            bl3 = true;
                        } else {
                            remoteConsumerKey = (RemoteConsumerKey)remoteDispatchableKey.resolvedKey();
                        }
                    } else {
                        remoteConsumerKey = null;
                        while (remoteConsumerKey == null) {
                            objectArray = matchingConsumerPointArray[n].getConsumerPointData();
                            if (objectArray.isKeyReady() && objectArray.getVersion() <= l) {
                                remoteConsumerKey = (RemoteConsumerKey)objectArray;
                                continue;
                            }
                            if ((n = (n + 1) % matchingConsumerPointArray.length) != n2) continue;
                        }
                        if (remoteConsumerKey == null) {
                            bl2 = false;
                        }
                    }
                    if (remoteConsumerKey != null) {
                        remoteConsumerKey.markNotReady();
                        remoteDispatchableKey = (RemoteDispatchableKey)remoteConsumerKey.getParent();
                        this.removeReadyConsumer(remoteDispatchableKey, !remoteDispatchableKey.hasNonSpecificConsumers());
                    }
                }
                if (remoteConsumerKey == null) continue;
                remoteConsumerKey.updateLastNotReadyTime();
                bl = remoteConsumerKey.consumerPoint.put(aIMessageItem, true);
                bl2 = !bl;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchInternal");
        }
    }

    public final long getRoundTripTime() {
        return this._aih.getRoundTripTime();
    }

    public final AIStreamKey issueGet(SelectionCriteria[] selectionCriteriaArray, long l, RemoteDispatchableKey remoteDispatchableKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueGet");
            SibTr.exit((TraceComponent)tc, (String)"issueGet");
        }
        return this._aih.issueGet(selectionCriteriaArray, l, remoteDispatchableKey);
    }

    public final AIStreamKey[] issueGet(SelectionCriteria[] selectionCriteriaArray, int n, RemoteDispatchableKey remoteDispatchableKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueGet");
            SibTr.exit((TraceComponent)tc, (String)"issueGet");
        }
        return this._aih.issueGet(selectionCriteriaArray, n, remoteDispatchableKey);
    }

    public void expiryCallback(AIMessageItem aIMessageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiryCallback", (Object)aIMessageItem);
        }
        AIStreamKey aIStreamKey = aIMessageItem.getAIStreamKey();
        this._aih.reject(aIStreamKey);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiryCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRejectTimeout() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRejectTimeout");
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            bl = this._cardinalityOne;
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRejectTimeout", (Object)new Long(-2L));
            }
            return -2L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRejectTimeout", (Object)new Long(SIMPConstants.UNLOCKED_REJECT_INTERVAL));
        }
        return SIMPConstants.UNLOCKED_REJECT_INTERVAL;
    }

    public AnycastInputHandler getAnycastInputHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAnycastInputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getAnycastInputHandler", (Object)new Object[]{this._aih});
        }
        return this._aih;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cardinalityChangeConsumersDetached() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cardinalityChangeConsumersDetached");
        }
        this._aih.rejectAll();
        this.removeAllMessagesItemStream();
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._cardinalityChange = false;
            this._aih.changeReceiveExclusive(this._cardinalityOne);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cardinalityChangeConsumersDetached");
        }
    }

    private void removeAllMessagesItemStream() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAllMessagesItemStream");
        }
        try {
            ExternalLocalTransaction externalLocalTransaction = this._tranManager.createLocalTransaction();
            LockingCursor lockingCursor = this.itemStream.newLockingItemCursor(null);
            AbstractItem abstractItem = null;
            PersistentTranId persistentTranId = externalLocalTransaction.getPersistentTranId();
            while ((abstractItem = lockingCursor.next()) != null) {
                ((AIMessageItem)abstractItem).setRejectTransactionID(persistentTranId);
                abstractItem.remove(externalLocalTransaction, abstractItem.getLockID());
            }
            externalLocalTransaction.commit();
            lockingCursor.finished();
        }
        catch (MessageStoreException messageStoreException) {
            SIResourceException sIResourceException = new SIResourceException((Throwable)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            SIResourceException sIResourceException = new SIResourceException((Throwable)sIIncorrectCallException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        catch (SIConnectionLostException sIConnectionLostException) {
            SIResourceException sIResourceException = new SIResourceException((Throwable)sIConnectionLostException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllMessagesItemStream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForFlush() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForFlush");
        }
        boolean bl = true;
        Object[] objectArray = null;
        Object object = this.consumerPoints;
        synchronized (object) {
            this._forceFlushInProgress = true;
            if (this.consumerPoints.size() == 0) {
                bl = false;
            } else {
                objectArray = this.consumerPoints.toArray();
            }
        }
        if (bl) {
            object = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0471", new Object[]{this.getDestName(), SIMPUtils.getMENameFromUuid(this.getLocalisationME().toString())}, null));
            for (int i = 0; i < objectArray.length; ++i) {
                ConsumerKey consumerKey = (ConsumerKey)objectArray[i];
                consumerKey.closeLocalisationUnreachable();
                consumerKey.notifyConsumerPointAboutException((SIException)((Object)object));
            }
        } else {
            try {
                this.forceFlushConsumersDetached();
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher.closeAllConsumersForFlush", (String)"1:1388:1.68", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                SIErrorException sIErrorException = new SIErrorException((Throwable)sIResourceException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForFlush", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceFlushConsumersDetached() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushConsumersDetached");
        }
        this._aih.rejectAll();
        this.removeAllMessagesItemStream();
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            this._forceFlushInProgress = false;
        }
        this._aih.closeAllConsumersForFlushDone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushConsumersDetached");
        }
    }

    public final int getRedeliveredCount(long l) {
        return this._aih.getRedeliveredCount(l);
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/RemoteConsumerDispatcher.java, SIB.processor, WAS602.SIB, o0610.11 1.68");
        }
    }
}

