/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.InternalOutputStreamManager;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.CellulePair;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PubSubOutputHandler
implements OutputHandler,
ControlHandler,
DownstreamControl,
UpstreamControl,
MessageEventListener,
ControllableResource {
    private static final TraceComponent tc = SibTr.register((Class)PubSubOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerDispatcherState _subscriptionState;
    private InternalOutputStreamManager _internalOutputStreamManager;
    private ControlHandler _parentInputHandler;
    private Cellule _localCellule;
    private Cellule _targetCellule;
    private MPIO _mpio;
    private Neighbour _neighbour;
    private ControlMessageFactory _cmf;
    private SIBUuid12 _destUuid;
    private String _destName;
    private String _busName;
    private BaseDestinationHandler _destinationHandler;
    private String _foreignTSName = null;
    private boolean _isLink = false;
    private String _linkName = null;
    private boolean _linkSetOutboundUserId = false;
    private String _linkOutboundUserid = null;
    private JsDestinationAddress _routingDestination = null;
    private boolean _isGuess = false;
    private MessageProcessor _messageProcessor;
    private ControlAdapter _controlAdapter;

    public PubSubOutputHandler(MessageProcessor messageProcessor, ControlHandler controlHandler, ProtocolItemStream protocolItemStream, SIBUuid12 sIBUuid12, String string, String string2, Neighbour neighbour, BaseDestinationHandler baseDestinationHandler) {
        VirtualLinkDefinition virtualLinkDefinition;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubOutputHandler", (Object)new Object[]{messageProcessor, controlHandler, protocolItemStream, sIBUuid12, string, string2, neighbour, baseDestinationHandler});
        }
        this._messageProcessor = messageProcessor;
        this._destUuid = sIBUuid12;
        this._destName = string;
        this._busName = string2;
        this._neighbour = neighbour;
        this._parentInputHandler = controlHandler;
        this._mpio = messageProcessor.getMPIO();
        this._localCellule = messageProcessor.getMECellule();
        this._targetCellule = new MessagingEngine(neighbour.getUUID());
        this._cmf = MessageProcessor.getControlMessageFactory();
        this._destinationHandler = baseDestinationHandler;
        if (!neighbour.getBusId().equals(messageProcessor.getMessagingEngineBus()) && (virtualLinkDefinition = messageProcessor.getDestinationManager().getLinkDefinition(neighbour.getBusId())) != null && virtualLinkDefinition.getType().equals("SIBVirtualGatewayLink")) {
            this._linkName = virtualLinkDefinition.getName();
            this._linkOutboundUserid = virtualLinkDefinition.getOutboundUserid();
            this._isLink = true;
            if (this._linkOutboundUserid != null) {
                this._linkSetOutboundUserId = true;
            }
        }
        this._internalOutputStreamManager = new InternalOutputStreamManager(this, this, this._targetCellule);
        this.createControlAdapter();
        this.registerControlAdapterAsMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubOutputHandler", (Object)this);
        }
    }

    public void addTopic(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopic", (Object)string);
        }
        if (this._subscriptionState == null) {
            SelectionCriteria selectionCriteria = null;
            selectionCriteria = this._messageProcessor.getSelectionCriteriaFactory().createSelectionCriteria(string, null, SelectorDomain.SIMESSAGE);
            this._subscriptionState = new ConsumerDispatcherState(this._destUuid, selectionCriteria, this._destName, this._busName);
        } else {
            this._subscriptionState.addTopic(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopic");
        }
    }

    public void removeTopic(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTopic", (Object)string);
        }
        if (this._subscriptionState == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"removeTopic", (Object)"Topic not found");
            }
        } else {
            this._subscriptionState.removeTopic(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTopic");
        }
    }

    public String[] getTopics() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopics");
        }
        String[] stringArray = null;
        if (this._subscriptionState != null) {
            stringArray = this._subscriptionState.getTopics();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopics", (Object)stringArray);
        }
        return stringArray;
    }

    public SIBUuid12 getTopicSpaceUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceUuid", (Object)this._destUuid);
        }
        return this._destUuid;
    }

    public boolean put(SIMPMessage sIMPMessage, Transaction transaction, InputHandlerStore inputHandlerStore, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{sIMPMessage, transaction, inputHandlerStore, new Boolean(bl)});
        }
        this._internalOutputStreamManager.addMessage(sIMPMessage, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void putInsert(SIMPMessage sIMPMessage, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putInsert", (Object)new Object[]{sIMPMessage, new Boolean(bl)});
        }
        this._internalOutputStreamManager.addMessage(sIMPMessage, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putInsert");
        }
    }

    public void putSilence(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putSilence", (Object)new Object[]{sIMPMessage});
        }
        this._internalOutputStreamManager.addSilence(sIMPMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putSilence");
        }
    }

    public boolean okToForward(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"okToForward", (Object)messageItem);
        }
        boolean bl = false;
        if (this.isLink()) {
            bl = this.neighbourOnDifferentBus(messageItem.getOriginatingBus());
        } else if (messageItem.isFromRemoteBus()) {
            bl = true;
        } else {
            boolean bl2 = bl = !messageItem.isFromRemoteME();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"okToForward", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean neighbourOnDifferentBus(String string) {
        return this._neighbour.okToForward(string);
    }

    public void registerForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)sIMPMessage);
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:567:1.142"}, null));
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.registerForEvents", (String)"1:574:1.142", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:580:1.142"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) throws SIConnectionLostException, SIRollbackException, SIIncorrectCallException, SIResourceException {
        ControlMessageType controlMessageType;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        if ((controlMessageType = controlMessage.getControlMessageType()) == ControlMessageType.REQUESTFLUSH) {
            this._parentInputHandler.handleControlMessage(this._targetCellule, controlMessage);
        } else if (controlMessageType == ControlMessageType.AREYOUFLUSHED) {
            this._internalOutputStreamManager.processFlushQuery((ControlAreYouFlushed)controlMessage);
        } else if (controlMessageType == ControlMessageType.ACK) {
            this._internalOutputStreamManager.processAck((ControlAck)controlMessage);
        } else if (controlMessageType == ControlMessageType.NACK) {
            this._internalOutputStreamManager.processNack((ControlNack)controlMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    void processAckExpected(long l, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Long(l));
        }
        this._internalOutputStreamManager.processAckExpected(l, n, reliability, sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    public void messageEventOccurred(int n, SIMPMessage sIMPMessage, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(n), sIMPMessage, transaction});
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:675:1.142"}, null));
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.messageEventOccurred", (String)"1:682:1.142", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:688:1.142"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public String toString() {
        return "PubSubOutputHandler: " + this._busName + ":" + this._destName + ":" + this._destUuid.toString() + " on " + this._neighbour.toString();
    }

    public SIBUuid8 getTargetMEUuid() {
        return this._neighbour.getUUID();
    }

    public void sendAckExpectedMessage(long l, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlAckExpected controlAckExpected;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)new Object[]{new Long(l), this._targetCellule, new Integer(n), reliability});
        }
        try {
            controlAckExpected = this._cmf.createNewControlAckExpected();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendAckExpectedMessage", (String)"1:748:1.142", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:755:1.142", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:766:1.142", exception}, null), (Throwable)exception);
        }
        controlAckExpected.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlAckExpected.setGuaranteedTargetMessagingEngineUUID(null);
        controlAckExpected.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlAckExpected.setGuaranteedStreamUUID(sIBUuid12);
        controlAckExpected.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlAckExpected.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlAckExpected.setTick(l);
        controlAckExpected.setPriority(n);
        controlAckExpected.setReliability(reliability);
        if (this._isLink) {
            controlAckExpected = (ControlAckExpected)this.addLinkProps((ControlMessage)controlAckExpected);
        }
        CellulePair[] cellulePairArray = new CellulePair[]{new CellulePair(this._localCellule, this._targetCellule)};
        this._mpio.sendDownTree(cellulePairArray, 1, n, (ControlMessage)controlAckExpected);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage");
        }
    }

    public void sendSilenceMessage(long l, long l2, long l3, boolean bl, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlSilence controlSilence;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSilenceMessage", (Object)new Object[]{new Long(l), new Long(l2), new Long(l3), new Integer(n), reliability});
        }
        try {
            controlSilence = this._cmf.createNewControlSilence();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendSilenceMessage", (String)"1:845:1.142", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:852:1.142", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage", (Object)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:863:1.142", exception}, null), (Throwable)exception);
        }
        controlSilence.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlSilence.setGuaranteedTargetMessagingEngineUUID(null);
        controlSilence.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlSilence.setGuaranteedStreamUUID(sIBUuid12);
        controlSilence.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlSilence.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlSilence.setStartTick(l);
        controlSilence.setEndTick(l2);
        controlSilence.setPriority(n);
        controlSilence.setReliability(reliability);
        controlSilence.setCompletedPrefix(l3);
        controlSilence.setRequestedOnly(bl);
        if (this._isLink) {
            controlSilence = (ControlSilence)this.addLinkProps((ControlMessage)controlSilence);
        }
        CellulePair[] cellulePairArray = new CellulePair[]{new CellulePair(this._localCellule, this._targetCellule)};
        if (bl) {
            this._mpio.sendDownTree(cellulePairArray, 1, n + 1, (ControlMessage)controlSilence);
        } else {
            this._mpio.sendDownTree(cellulePairArray, 1, n, (ControlMessage)controlSilence);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage");
        }
    }

    public MessageItem getValueMessage(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getValueMessage", (Object)new Long(l));
        }
        MessageItem messageItem = (MessageItem)this._destinationHandler._pubsubMessageItemStream.findById(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getValueMessage", (Object)messageItem);
        }
        return messageItem;
    }

    public List sendValueMessages(List list, long l, boolean bl, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendValueMessages", (Object)new Object[]{list, new Long(l), new Boolean(bl)});
        }
        CellulePair[] cellulePairArray = new CellulePair[]{new CellulePair(this._localCellule, this._targetCellule)};
        JsMessage jsMessage = null;
        TickRange tickRange = null;
        MessageItem messageItem = null;
        long l2 = -1L;
        ArrayList<TickRange> arrayList = null;
        for (int i = 0; i < list.size(); ++i) {
            tickRange = (TickRange)list.get(i);
            l2 = tickRange.itemStreamIndex;
            messageItem = (MessageItem)this._destinationHandler._pubsubMessageItemStream.findById(l2);
            if (messageItem == null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<TickRange>();
                }
                arrayList.add(tickRange);
                ControlSilence controlSilence = this.createSilenceMessage(tickRange.valuestamp, l, n, reliability, sIBUuid12);
                controlSilence.setRequestedOnly(bl);
                if (this._isLink) {
                    controlSilence = this.addLinkProps((ControlMessage)controlSilence);
                    controlSilence.setRoutingDestination(this._routingDestination);
                }
                if (bl) {
                    this._mpio.sendDownTree(cellulePairArray, 1, n + 1, (ControlMessage)controlSilence);
                    continue;
                }
                this._mpio.sendDownTree(cellulePairArray, 1, n, (ControlMessage)controlSilence);
                continue;
            }
            jsMessage = messageItem.getMessage();
            if (jsMessage.getGuaranteedStreamUUID() != sIBUuid12) {
                jsMessage.setGuaranteedStreamUUID(sIBUuid12);
            }
            if (tickRange.endstamp > tickRange.valuestamp) {
                jsMessage.setGuaranteedValueEndTick(tickRange.endstamp);
            }
            jsMessage.setGuaranteedValueCompletedPrefix(l);
            jsMessage.setGuaranteedValueRequestedOnly(bl);
            if (this._isLink) {
                jsMessage = this.addLinkProps(jsMessage);
                jsMessage.setRoutingDestination(this._routingDestination);
            }
            if (UserTrace.tc_mt.isDebugEnabled()) {
                UserTrace.traceOutboundSend(jsMessage, this._neighbour.getUUID(), this._destUuid.toString());
            }
            if (bl) {
                this._mpio.sendDownTree(cellulePairArray, 1, n + 1, jsMessage);
                continue;
            }
            this._mpio.sendDownTree(cellulePairArray, 1, n, jsMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendValueMessages", arrayList);
        }
        return arrayList;
    }

    public void sendFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushedMessage", (Object)new Object[]{cellule, sIBUuid12});
        }
        ControlFlushed controlFlushed = this.createControlFlushed(this._targetCellule, sIBUuid12);
        if (this._isLink) {
            controlFlushed = (ControlFlushed)this.addLinkProps((ControlMessage)controlFlushed);
        }
        this._mpio.sendToMe((MessagingEngine)this._targetCellule, 1, 9, (ControlMessage)controlFlushed);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushedMessage");
        }
    }

    public void sendNotFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12, long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushedMessage", (Object)new Object[]{cellule, sIBUuid12, new Long(l)});
        }
        ControlNotFlushed controlNotFlushed = this.createControlNotFlushed(this._targetCellule, sIBUuid12, l);
        controlNotFlushed = this._internalOutputStreamManager.stampNotFlushed(controlNotFlushed, sIBUuid12);
        if (this._isLink) {
            controlNotFlushed = (ControlNotFlushed)this.addLinkProps((ControlMessage)controlNotFlushed);
        }
        this._mpio.sendToMe((MessagingEngine)this._targetCellule, 1, 9, (ControlMessage)controlNotFlushed);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushedMessage");
        }
    }

    public void sendLinkMessage(MessageItem messageItem, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendLinkMessage", (Object)messageItem);
        }
        JsMessage jsMessage = null;
        try {
            jsMessage = messageItem.getMessage().getReceived();
        }
        catch (MessageCopyFailedException messageCopyFailedException) {
            FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendLinkMessage", (String)"1:1112:1.142", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendLinkMessage", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)messageCopyFailedException);
        }
        CellulePair[] cellulePairArray = new CellulePair[]{new CellulePair(this._localCellule, this._targetCellule)};
        if (bl) {
            ControlSilence controlSilence = this.createSilenceMessage(jsMessage.getGuaranteedValueValueTick(), jsMessage.getGuaranteedValueCompletedPrefix(), messageItem.getPriority(), messageItem.getReliability(), jsMessage.getGuaranteedStreamUUID());
            controlSilence = this.addLinkProps((ControlMessage)controlSilence);
            controlSilence.setRoutingDestination(this._routingDestination);
            this._mpio.sendDownTree(cellulePairArray, 1, messageItem.getPriority(), (ControlMessage)controlSilence);
        } else {
            jsMessage = this.addLinkProps(jsMessage);
            jsMessage.setRoutingDestination(this._routingDestination);
            jsMessage.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
            this._mpio.sendDownTree(cellulePairArray, 1, messageItem.getPriority(), jsMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendLinkMessage");
        }
    }

    public boolean commitInsert(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInsert", (Object)messageItem);
        }
        this._internalOutputStreamManager.commitInsert(messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInsert");
        }
        return true;
    }

    public boolean rollbackInsert(MessageItem messageItem) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackInsert", (Object)messageItem);
        }
        this._internalOutputStreamManager.rollbackInsert(messageItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackInsert");
        }
        return true;
    }

    private ControlNack createControlNackMessage(int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlNack controlNack;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNackMessage");
        }
        try {
            controlNack = this._cmf.createNewControlNack();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlNackMessage", (String)"1:1221:1.142", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1233:1.142", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1241:1.142", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlNack.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlNack.setGuaranteedTargetMessagingEngineUUID(null);
        controlNack.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlNack.setGuaranteedStreamUUID(sIBUuid12);
        controlNack.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlNack.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlNack.setPriority(n);
        controlNack.setReliability(reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage");
        }
        return controlNack;
    }

    private ControlAck createControlAckMessage(int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlAck controlAck;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAckMessage");
        }
        try {
            controlAck = this._cmf.createNewControlAck();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlAckMessage", (String)"1:1294:1.142", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1306:1.142", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1314:1.142", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlAck.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlAck.setGuaranteedTargetMessagingEngineUUID(null);
        controlAck.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlAck.setGuaranteedStreamUUID(sIBUuid12);
        controlAck.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlAck.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlAck.setPriority(n);
        controlAck.setReliability(reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage");
        }
        return controlAck;
    }

    private ControlSilence createSilenceMessage(long l, long l2, int n, Reliability reliability, SIBUuid12 sIBUuid12) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSilenceMessage", (Object)new Object[]{new Long(l), new Long(l2), new Integer(n), reliability, sIBUuid12});
        }
        ControlSilence controlSilence = null;
        try {
            controlSilence = this._cmf.createNewControlSilence();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createSilenceMessage", (String)"1:1366:1.142", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1372:1.142", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)exception);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1382:1.142", exception}, null), (Throwable)exception);
        }
        controlSilence.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlSilence.setGuaranteedTargetMessagingEngineUUID(null);
        controlSilence.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlSilence.setGuaranteedStreamUUID(sIBUuid12);
        controlSilence.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlSilence.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlSilence.setStartTick(l);
        controlSilence.setEndTick(l);
        controlSilence.setPriority(n);
        controlSilence.setReliability(reliability);
        controlSilence.setCompletedPrefix(l2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)controlSilence);
        }
        return controlSilence;
    }

    private ControlFlushed createControlFlushed(Cellule cellule, SIBUuid12 sIBUuid12) throws SIResourceException {
        ControlFlushed controlFlushed;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlFlushed", (Object)sIBUuid12);
        }
        try {
            controlFlushed = this._cmf.createNewControlFlushed();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlFlushed", (String)"1:1435:1.142", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlFlushed", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1447:1.142", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1455:1.142", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlFlushed.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlFlushed.setGuaranteedTargetMessagingEngineUUID(null);
        controlFlushed.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlFlushed.setGuaranteedStreamUUID(sIBUuid12);
        controlFlushed.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlFlushed.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlFlushed.setPriority(11);
        controlFlushed.setReliability(Reliability.ASSURED_PERSISTENT);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlFlushed");
        }
        return controlFlushed;
    }

    private ControlNotFlushed createControlNotFlushed(Cellule cellule, SIBUuid12 sIBUuid12, long l) throws SIResourceException {
        ControlNotFlushed controlNotFlushed;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNotFlushed", (Object)new Object[]{cellule, sIBUuid12, new Long(l)});
        }
        try {
            controlNotFlushed = this._cmf.createNewControlNotFlushed();
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.createControlNotFlushed", (String)"1:1507:1.142", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
                SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed", (Object)((Object)messageCreateFailedException));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1519:1.142", messageCreateFailedException});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1527:1.142", messageCreateFailedException}, null), (Throwable)messageCreateFailedException);
        }
        controlNotFlushed.setGuaranteedSourceMessagingEngineUUID(this._messageProcessor.getMessagingEngineUuid());
        controlNotFlushed.setGuaranteedTargetMessagingEngineUUID(null);
        controlNotFlushed.setGuaranteedTargetDestinationDefinitionUUID(this._destUuid);
        controlNotFlushed.setGuaranteedStreamUUID(sIBUuid12);
        controlNotFlushed.setGuaranteedProtocolType(ProtocolType.PUBSUBINPUT);
        controlNotFlushed.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        controlNotFlushed.setPriority(11);
        controlNotFlushed.setReliability(Reliability.ASSURED_PERSISTENT);
        controlNotFlushed.setRequestID(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed");
        }
        return controlNotFlushed;
    }

    private JsMessage addLinkProps(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps", (Object)jsMessage);
        }
        jsMessage.setGuaranteedCrossBusLinkName(this._linkName);
        jsMessage.setGuaranteedCrossBusSourceBusUUID(this._messageProcessor.getMessagingEngineBusUuid());
        if (this._linkSetOutboundUserId && !this._messageProcessor.getAuthorisationUtils().sentBySIBServer(jsMessage)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Set outbound userid: " + this._linkOutboundUserid + ", in message"));
            }
            this._messageProcessor.getAccessChecker().setSecurityIDInMessage(this._linkOutboundUserid, jsMessage);
            jsMessage.setApiUserId(this._linkOutboundUserid);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return jsMessage;
    }

    private ControlMessage addLinkProps(ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps", (Object)controlMessage);
        }
        controlMessage.setGuaranteedCrossBusLinkName(this._linkName);
        controlMessage.setGuaranteedCrossBusSourceBusUUID(this._messageProcessor.getMessagingEngineBusUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return controlMessage;
    }

    public Cellule getTargetCellule() {
        return this._targetCellule;
    }

    public void sendNackMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, long l2, int n, Reliability reliability, SIBUuid12 sIBUuid122) throws SIResourceException {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendNackMessage", (Object)new Object[]{cellule, new Long(l), new Long(l2), new Integer(n), reliability, sIBUuid122});
            }
            ControlNack controlNack = this.createControlNackMessage(n, reliability, sIBUuid122);
            controlNack.setStartTick(l);
            controlNack.setEndTick(l2);
            try {
                this._parentInputHandler.handleControlMessage(null, (ControlMessage)controlNack);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendNackMessage", (String)"1:1660:1.142", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                SibTr.exit((TraceComponent)tc, (String)"sendNackMessage", (Object)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNackMessage");
        }
    }

    public void sendAckMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, int n, Reliability reliability, SIBUuid12 sIBUuid122, boolean bl) throws SIResourceException {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"sendAckMessage", (Object)new Object[]{cellule, new Long(l), new Integer(n), reliability, sIBUuid122});
            }
            ControlAck controlAck = this.createControlAckMessage(n, reliability, sIBUuid122);
            controlAck.setAckPrefix(l);
            try {
                this._parentInputHandler.handleControlMessage(null, (ControlMessage)controlAck);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendAckMessage", (String)"1:1716:1.142", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (!tc.isEntryEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                SibTr.exit((TraceComponent)tc, (String)"sendAckMessage", (Object)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckMessage");
        }
    }

    public void sendAreYouFlushedMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, SIBUuid12 sIBUuid122) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)new Object[]{cellule, new Long(l), sIBUuid122});
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1751:1.142"}, null));
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendAreYouFlushedMessage", (String)"1:1758:1.142", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1764:1.142"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public void sendRequestFlushMessage(Cellule cellule, SIBUuid12 sIBUuid12, SIBUuid8 sIBUuid8, long l, SIBUuid12 sIBUuid122, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)new Object[]{cellule, new Long(l), sIBUuid122});
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1789:1.142"}, null));
        FFDCFilter.processException((Throwable)((Object)invalidOperationException), (String)"com.ibm.ws.sib.processor.impl.PubSubOutputHandler.sendRequestFlushMessage", (String)"1:1796:1.142", (Object)this);
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubOutputHandler", "1:1802:1.142"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public long checkAck(ControlAck controlAck, long l) {
        return this._internalOutputStreamManager.checkAck(controlAck, l);
    }

    public void registerForEventsPostAddItem(SIMPMessage sIMPMessage) {
    }

    public void removeStream(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeStream", (Object)sIBUuid12);
        }
        this._internalOutputStreamManager.remove(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeStream");
        }
    }

    public boolean isWLMGuess() {
        return this._isGuess;
    }

    public void setWLMGuess(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWLMGuess", (Object)new Boolean(bl));
        }
        this._isGuess = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWLMGuess");
        }
    }

    public boolean isLink() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLink");
            SibTr.exit((TraceComponent)tc, (String)"isLink", (Object)new Boolean(this._isLink));
        }
        return this._isLink;
    }

    public String getTopicSpaceMapping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceMapping");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceMapping", (Object)this._foreignTSName);
        }
        return this._foreignTSName;
    }

    public void setTopicSpaceMapping(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTopicSpaceMapping", (Object)string);
        }
        this._routingDestination = SIMPUtils.createJsDestinationAddress(string, null, this._neighbour.getBusId());
        this._foreignTSName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTopicSpaceMapping");
        }
    }

    public boolean isQHighLimit() {
        return false;
    }

    public ConsumerDispatcherState getConsumerDispatcherState() {
        return this._subscriptionState;
    }

    public String getBusName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusName");
            SibTr.exit((TraceComponent)tc, (String)"getBusName", (Object)this._busName);
        }
        return this._busName;
    }

    public InternalOutputStreamManager getInternalOutputStreamManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInternalOutputStreamManager");
            SibTr.exit((TraceComponent)tc, (String)"getInternalOutputStreamManager", (Object)this._internalOutputStreamManager);
        }
        return this._internalOutputStreamManager;
    }

    public String getDestinationName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationName");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationName", (Object)this._destName);
        }
        return this._destName;
    }

    public ControlAdapter getControlAdapter() {
        return this._controlAdapter;
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        if (this._controlAdapter == null) {
            Map map = this._destinationHandler.getPseudoDurableAIHMap();
            Iterator iterator = map.values().iterator();
            SIBUuid8 sIBUuid8 = this.getTargetMEUuid();
            while (iterator.hasNext()) {
                AnycastInputHandler anycastInputHandler = (AnycastInputHandler)iterator.next();
                SIBUuid8 sIBUuid82 = anycastInputHandler.getLocalisationME().getUuid();
                if (!sIBUuid82.equals((Object)sIBUuid8)) continue;
                this._controlAdapter = anycastInputHandler.getControlAdapter();
                break;
            }
            if (this._controlAdapter == null) {
                this._controlAdapter = new RemoteTopicSpaceControl(this, null, this._messageProcessor);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void dereferenceControlAdapter() {
    }

    public void registerControlAdapterAsMBean() {
        this._controlAdapter.registerControlAdapterAsMBean();
    }

    public void deregisterControlAdapterMBean() {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/PubSubOutputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.142");
        }
    }
}

