/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.processor.MessageProducer;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPNoLocalisationsException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPSessionUnavailableException;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIProducerSession;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.DestinationSessionUtils;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public final class ProducerSessionImpl
implements ProducerSession,
MessageProducer {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register((Class)ProducerSessionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int _seed = 0;
    private MessageProcessor _messageProcessor;
    private boolean _closed;
    private ProducerInputHandler _inputHandler;
    private ConnectionImpl _conn;
    private DestinationHandler _destination;
    private JsDestinationAddress _address;
    private JsDestinationAddress _routingDestinationAddr;
    private boolean _putByMediation = false;
    private SIBPmiRm _rmImpl;
    private Transaction _autoCommitTransaction;
    private boolean _checkDiscriminatorAccessAtSend = true;
    private String _discriminatorAtCreate = null;
    private SecurityContext _securityContext = null;
    private boolean _keepSecurityUserid = false;

    ProducerSessionImpl(SIDestinationAddress sIDestinationAddress, JsDestinationAddress jsDestinationAddress, DestinationHandler destinationHandler, ConnectionImpl connectionImpl, SecurityContext securityContext, boolean bl) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ProducerSessionImpl", (Object)new Object[]{sIDestinationAddress, jsDestinationAddress, destinationHandler, connectionImpl, securityContext, new Boolean(bl)});
        }
        this._destination = destinationHandler;
        this._conn = connectionImpl;
        this._securityContext = securityContext;
        this._keepSecurityUserid = bl;
        this._messageProcessor = connectionImpl.getMessageProcessor();
        this._routingDestinationAddr = jsDestinationAddress;
        ProtocolType protocolType = ProtocolType.UNICASTINPUT;
        if (destinationHandler.isPubSub()) {
            protocolType = ProtocolType.PUBSUBINPUT;
        }
        if (sIDestinationAddress != null && ((JsDestinationAddress)sIDestinationAddress).isFromMediation()) {
            this._address = null;
            this._putByMediation = true;
            this._inputHandler = (ProducerInputHandler)this._destination.getInputHandler();
        } else {
            this._address = (JsDestinationAddress)sIDestinationAddress;
            this._inputHandler = (ProducerInputHandler)this._destination.getInputHandler(protocolType, this._messageProcessor.getMECellule(), null);
        }
        this._inputHandler.attachProducer(this);
        this._closed = false;
        this._rmImpl = this._messageProcessor.getRmImpl();
        this._autoCommitTransaction = this._destination.getTxManager().createAutoCommitTransaction();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ProducerSessionImpl", (Object)this);
        }
    }

    static final void setRFH2Allowed(JsMessage jsMessage, DestinationHandler destinationHandler) {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRFH2Allowed", (Object)new Object[]{jsMessage, destinationHandler});
        }
        Object object = destinationHandler.getContextValue("_MQRFH2Allowed");
        boolean bl = false;
        if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            bl = bl2;
        } else if (object instanceof String && (string = (String)object).compareToIgnoreCase("YES") == 0) {
            bl = true;
        }
        if (bl) {
            jsMessage.setMQRFH2Allowed(true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRFH2Allowed", (Object)bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void send(SIBusMessage sIBusMessage, SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)new Object[]{this, sIBusMessage, sITransaction});
        }
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_16", new Object[]{this._destination}, null));
            sIMPIncorrectCallException.setExceptionReason(16);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{this._destination.getName()});
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPIncorrectCallException));
            }
            if (!CoreSPIProducerSession.tc.isEntryEnabled()) throw sIMPIncorrectCallException;
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)((Object)sIMPIncorrectCallException));
            throw sIMPIncorrectCallException;
        }
        ProducerSessionImpl producerSessionImpl = this;
        // MONITORENTER : producerSessionImpl
        this.checkNotClosed();
        if (!this._destination.isSendAllowed()) {
            if (CoreSPIProducerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"Destination is send disabled");
            }
            SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_17", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(17);
            sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
            throw sIMPNotPossibleInCurrentConfigurationException;
        }
        JsMessage jsMessage = null;
        if (this._conn.getMessageCopiedWhenSent()) {
            try {
                jsMessage = ((JsMessage)sIBusMessage).getSent();
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.send", (String)"1:429:1.183", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl", "1:436:1.183", messageCopyFailedException});
                if (CoreSPIProducerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"Could not make a safe copy of message");
                }
                SIMPErrorException sIMPErrorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl", "1:447:1.183", messageCopyFailedException}, null), messageCopyFailedException);
                sIMPErrorException.setExceptionReason(901);
                sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl", "1:455:1.183", SIMPUtils.getStackTrace(messageCopyFailedException)});
                throw sIMPErrorException;
            }
        } else {
            jsMessage = (JsMessage)sIBusMessage;
        }
        if (this._destination.isAlias() || this._destination.isForeign() || this._destination.isForeignBus()) {
            ProducerSessionImpl.setRFH2Allowed(jsMessage, this._destination);
        }
        if (this._conn.isBusSecure()) {
            if (this._checkDiscriminatorAccessAtSend) {
                this._securityContext.setDiscriminator(jsMessage.getDiscriminator());
                if (!this._destination.checkDiscriminatorAccess(this._securityContext, OperationType.SEND)) {
                    if (CoreSPIProducerSession.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"not authorized to produce to this destination's discriminator");
                    }
                    SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), jsMessage.getDiscriminator(), this._conn.getResolvedUserid()}, null));
                    SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), jsMessage.getDiscriminator(), this._conn.getResolvedUserid()}, null));
                    sIMPNotAuthorizedException.setExceptionReason(20);
                    sIMPNotAuthorizedException.setExceptionInserts(new String[]{this._destination.getName(), jsMessage.getDiscriminator(), this._conn.getResolvedUserid()});
                    throw sIMPNotAuthorizedException;
                }
            } else {
                jsMessage.setDiscriminator(this._discriminatorAtCreate);
            }
        }
        this._rmImpl.attachCurrentContextCorrelators((SIBusMessage)jsMessage, false);
        if (this._securityContext != null && this._securityContext.isAlternateUserBased()) {
            if (!this._keepSecurityUserid) {
                this._messageProcessor.getAccessChecker().setSecurityIDInMessage(this._securityContext.getAlternateUser(), jsMessage);
            }
        } else if (!this._keepSecurityUserid) {
            this._messageProcessor.getAccessChecker().setSecurityIDInMessage(this._conn.getSecuritySubject(), jsMessage);
        }
        MessageItem messageItem = null;
        messageItem = this.isMediationsSession() ? new MessageItem(jsMessage) : new MessageItem(jsMessage, 0L);
        if (this._routingDestinationAddr != null) {
            jsMessage.setRoutingDestination(this._routingDestinationAddr);
        }
        if (this._destination.isPubSub()) {
            messageItem.setProducerConnectionUuid(this._conn.getUuid());
        }
        messageItem.setProducerSeed(++this._seed);
        if (messageItem.getPriority() == -1) {
            messageItem.setPriority(this._destination.getDefaultPriority());
        }
        if (!this._destination.isOverrideOfQOSByProducerAllowed()) {
            messageItem.setReliability(this._destination.getDefaultReliability());
        }
        if (this._putByMediation) {
            jsMessage.setMediated(true);
        } else {
            messageItem.setRequiresNewId(true);
        }
        Transaction transaction = null;
        if (sITransaction != null) {
            transaction = (Transaction)sITransaction;
            messageItem.setTransacted(true);
        } else {
            transaction = this._autoCommitTransaction;
        }
        boolean bl = false;
        Object object = null;
        try {
            try {
                if (this._rmImpl.isActiveOnThread()) {
                    String string = null;
                    if (this._address != null) {
                        string = this._address.getDestinationName();
                    }
                    object = this._rmImpl.produceMessageBlock(jsMessage.getBus(), string);
                }
                if (UserTrace.tc_mt.isDebugEnabled()) {
                    this.traceSend(messageItem, sITransaction);
                }
                this._inputHandler.handleMessage(messageItem, transaction, this._address, this._messageProcessor.getMECellule());
                bl = true;
            }
            catch (SIMPNoLocalisationsException sIMPNoLocalisationsException) {
                if (CoreSPIProducerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send", (Object)"SIDestinationNotFoundException");
                }
                SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException((Throwable)((Object)sIMPNoLocalisationsException));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(26);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{this._destination.getName()});
                throw sIMPNotPossibleInCurrentConfigurationException;
            }
            Object var12_16 = null;
            if (this._rmImpl.isActiveOnThread()) {
                this._rmImpl.produceMessageUnblock(object, bl ? 0 : 1);
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (!this._rmImpl.isActiveOnThread()) throw throwable;
            this._rmImpl.produceMessageUnblock(object, bl ? 0 : 1);
            throw throwable;
        }
        // MONITOREXIT : producerSessionImpl
        if (!CoreSPIProducerSession.tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"send");
    }

    public void close() {
        boolean bl;
        if (CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"close", (Object)this);
        }
        if (bl = this._close()) {
            this._conn.removeProducerSession(this);
        }
        if (CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"close", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close");
        }
        boolean bl = false;
        ProducerSessionImpl producerSessionImpl = this;
        synchronized (producerSessionImpl) {
            if (!this._closed) {
                this._closed = true;
                bl = true;
            }
        }
        if (bl) {
            this._inputHandler.detachProducer(this);
            this._inputHandler = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close", (Object)new Boolean(bl));
        }
        return bl;
    }

    public SICoreConnection getConnection() throws SISessionUnavailableException {
        if (CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"getConnection", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getConnection", (Object)this._conn);
        }
        this.checkNotClosed();
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeProducerDestinationDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_closeProducerDestinationDeleted");
        }
        ProducerSessionImpl producerSessionImpl = this;
        synchronized (producerSessionImpl) {
            if (!this._closed) {
                this._conn.removeProducerSession(this);
                this._closed = true;
                this._inputHandler = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_closeProducerDestinationDeleted");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)this);
        }
        if (this._routingDestinationAddr != null) {
            if (CoreSPIProducerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)this._routingDestinationAddr);
            }
            return this._routingDestinationAddr;
        }
        if (this._address == null) {
            JsDestinationAddress jsDestinationAddress = DestinationSessionUtils.createJsDestinationAddress(this._destination);
            if (CoreSPIProducerSession.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)jsDestinationAddress);
            }
            return jsDestinationAddress;
        }
        if (CoreSPIProducerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIProducerSession.tc, (String)"getDestinationAddress", (Object)this._address);
        }
        return this._address;
    }

    protected boolean isMediationsSession() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMediationsSession");
            SibTr.exit((TraceComponent)tc, (String)"isMediationsSession", (Object)new Boolean(this._putByMediation));
        }
        return this._putByMediation;
    }

    void disableDiscriminatorAccessCheckAtSend(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"disableDiscriminatorAccessCheckAtSend");
        }
        this._checkDiscriminatorAccessAtSend = false;
        this._discriminatorAtCreate = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"disableDiscriminatorAccessCheckAtSend");
        }
    }

    private void traceSend(MessageItem messageItem, SITransaction sITransaction) {
        boolean bl = (this._destination.isMediatedLocally() || this._destination.isMediatedRemotely()) && !messageItem.getMessage().isMediated();
        String string = null;
        String string2 = null;
        if (messageItem.getMessage() instanceof JsApiMessage) {
            string = ((JsApiMessage)messageItem.getMessage()).getApiMessageId();
            string2 = ((JsApiMessage)messageItem.getMessage()).getCorrelationId();
        } else {
            if (messageItem.getMessage().getApiMessageIdAsBytes() != null) {
                string = new String(messageItem.getMessage().getApiMessageIdAsBytes());
            }
            if (messageItem.getMessage().getCorrelationIdAsBytes() != null) {
                string2 = new String(messageItem.getMessage().getCorrelationIdAsBytes());
            }
        }
        if (sITransaction != null) {
            String string3 = "PRODUCER_SEND_CWSJU0001";
            if (bl) {
                string3 = "PRODUCER_SEND_CWSJU0051";
            }
            if (UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(string3, new Object[]{this._conn.getUuid(), string, string2, this._destination.getName(), ((Transaction)sITransaction).getPersistentTranId()}, null));
            }
        } else {
            String string4 = "PRODUCER_SEND_NO_TRAN_CWSJU0002";
            if (bl) {
                string4 = "PRODUCER_SEND_NO_TRAN_CWSJU0052";
            }
            if (UserTrace.tc_mt.isDebugEnabled()) {
                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(string4, new Object[]{this._conn.getUuid(), string, string2, this._destination.getName()}, null));
            }
        }
    }

    private void checkNotClosed() throws SISessionUnavailableException {
        if (this._closed) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"ProducerSession closed");
            }
            SIMPSessionUnavailableException sIMPSessionUnavailableException = new SIMPSessionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_21", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            sIMPSessionUnavailableException.setExceptionReason(21);
            sIMPSessionUnavailableException.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()});
            throw sIMPSessionUnavailableException;
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ProducerSessionImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.183");
        }
    }
}

