/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsConfigConstants;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsHealthMonitor;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.MediationLocalizationDefinition;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBExceptionMediationNotFound;
import com.ibm.ws.sib.comms.MEConnectionListener;
import com.ibm.ws.sib.matchspace.Matching;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.JsMessageHandleFactory;
import com.ibm.ws.sib.mfp.SchemaStoreNotifier;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.SIMPFactory;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageProcessorCorruptException;
import com.ibm.ws.sib.processor.impl.AccessChecker;
import com.ibm.ws.sib.processor.impl.AdministratorImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerList;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.DestinationChangeListener;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DynamicConfigManager;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.LinkChangeListener;
import com.ibm.ws.sib.processor.impl.MulticastPropertiesImpl;
import com.ibm.ws.sib.processor.impl.RemoteMessageReceiver;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIConnFactory;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.MPCallsToUnitTestHandler;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.MessageProcessorStore;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.MessageProcessorControl;
import com.ibm.ws.sib.processor.stats.MessageProcessorInstrumentation;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.SearchResultsObjectPool;
import com.ibm.ws.sib.processor.utils.StoppableThreadCache;
import com.ibm.ws.sib.processor.utils.ThreadPoolListenerImpl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.AuthUtilsFactory;
import com.ibm.ws.sib.security.auth.SIBAccessControl;
import com.ibm.ws.sib.security.auth.SIBAccessControlFactory;
import com.ibm.ws.sib.security.auth.SibLogin;
import com.ibm.ws.sib.security.auth.SibLoginFactory;
import com.ibm.ws.sib.trm.TrmMeMain;
import com.ibm.ws.sib.trm.contact.CommsErrorListener;
import com.ibm.ws.sib.trm.dlm.DestinationLocationManager;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.mql.MQLinkManager;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.trm.topology.RoutingManager;
import com.ibm.ws.sib.trm.topology.TopologyListener;
import com.ibm.ws.sib.utils.Runtime;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SelectionCriteriaFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.mediation.runtime.DestinationMediationManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;

public final class MessageProcessor
implements JsEngineComponentWithEventListener,
SICoreConnectionFactory,
SIMPAdmin,
SIMPFactory,
ControllableResource {
    private static final TraceComponent tc = SibTr.register((Class)MessageProcessor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private static JsMessageFactory _jsMessageFactory;
    private SearchResultsObjectPool _searchResultsPool;
    private int _searchResultsPoolSize = 20;
    private ControlAdapter _controlAdapter;
    private long _highMessageThreshold = 1000L;
    private MessagingEngine _trmME;
    private SIMPTransactionManager _txManager;
    private ThreadPool _consumerThreadPool;
    private ThreadPool _systemThreadPool;
    private JsMessagingEngine _engine;
    private MessageStore _msgStore;
    private volatile boolean _started;
    private boolean _starting = false;
    private static HashMap _factories;
    private HashMap _meFactories = null;
    private boolean _discardMsgsAfterQueueDeletion;
    private boolean _isSingleServer = false;
    private boolean _singleServerSet = false;
    private Set _messagingEnginesOnBus;
    private HashMap _connections;
    private LockManager _connectionsLockManager = new LockManager();
    private ConsumerList _consumerList = null;
    private DestinationChangeListener _destinationChangeListener;
    private LinkChangeListener _linkChangeListener;
    private AdministratorImpl _administrator;
    private DestinationManager _destinationManager;
    private DynamicConfigManager _dynamicConfigManager;
    private MessageProcessorMatching _messageProcessorMatching;
    private MultiMEProxyHandler _multiMEProxyHandler;
    private MessageProcessorInstrumentation _stats;
    private MPCoreConnection _connectionToMP;
    private JsDestinationAddress _proxyHandlerDestAddr;
    private JsDestinationAddress _tdReceiverAddr;
    private MPIO _mpio;
    private DestinationLocationManager _destinationLocationManager = null;
    private LinkManager _linkManager = null;
    private MQLinkManager _mqLinkManager = null;
    private static ControlMessageFactory _controlMessageFactory;
    private MessageProcessorStore _persistentStore;
    private MPAlarmManager _mpAlarmManager;
    private ObjectPool _batchedTimeoutManagerEntryPool;
    private BatchHandler _publicationBatchHandler;
    private BatchHandler _targetBatchHandler;
    private BatchHandler _sourceBatchHandler;
    private int _definedSendWindow = 1000;
    private AccessChecker _accessChecker;
    private AuthUtils _authorisationUtils;
    private TopicAuthorization _topicAuthorization;
    private boolean _isBusSecure = false;
    private static MPCallsToUnitTestHandler _mpCallsToUnitTestHandler;
    private SIBPmiRm _rmImpl;
    private boolean _busReloaded = false;
    private SelectionCriteriaFactory _selectionCriteriaFactory;
    private static JsMessageHandleFactory _jsMessageHandleFactory;
    private boolean _multicastEnabled = false;
    private String _multicastGroupAddress = "234.6.17.92";
    private String _multicastInterfaceAddress = "none";
    private int _multicastPort = 34343;
    private int _multicastPacketSize = 7000;
    private int _multicastTTL = 1;
    private boolean _multicastUseReliableRMM = true;
    private MulticastPropertiesImpl _multicastProperties = null;
    private RuntimeEventListener _runtimeEventListener;
    private StoppableThreadCache _stoppableThreadCache;
    private volatile boolean _isWASOpenForEBusiness = false;

    public MessageProcessor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessor");
        }
        this._started = false;
        this._consumerList = new ConsumerList(this);
        this._stoppableThreadCache = new StoppableThreadCache();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessor", (Object)this);
        }
    }

    public boolean isStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted");
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)new Boolean(this._started));
        }
        return this._started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SICoreConnection createConnection() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection");
        }
        ConnectionImpl connectionImpl = new ConnectionImpl(this, null);
        this._connectionsLockManager.lock();
        try {
            this.checkStarted();
            HashMap hashMap = this._connections;
            synchronized (hashMap) {
                this._connections.put(connectionImpl, connectionImpl);
            }
        }
        finally {
            this._connectionsLockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection", (Object)connectionImpl);
        }
        return connectionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeConnection(ConnectionImpl connectionImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConnection", (Object)connectionImpl);
        }
        HashMap hashMap = this._connections;
        synchronized (hashMap) {
            this._connections.remove(connectionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConnection");
        }
    }

    public MPCoreConnection createMediationConnection(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMediationConnection", (Object)new Object[]{string, string2});
        }
        Subject subject = this._authorisationUtils.getSIBServerSubject();
        MPCoreConnection mPCoreConnection = null;
        try {
            mPCoreConnection = (MPCoreConnection)this.createConnection(subject, true);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.createMediationConnection", (String)"1:697:1.365", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createMediationConnection", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)sIResourceException);
        }
        mPCoreConnection.setMessageCopiedWhenSent(false);
        mPCoreConnection.setMessageCopiedWhenReceived(false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMediationConnection", (Object)mPCoreConnection);
        }
        return mPCoreConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SICoreConnection createConnection(Subject subject, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConnection");
        }
        ConnectionImpl connectionImpl = new ConnectionImpl(this, subject);
        this._connectionsLockManager.lock();
        try {
            if (!bl) {
                this.checkStarted();
            }
            HashMap hashMap = this._connections;
            synchronized (hashMap) {
                this._connections.put(connectionImpl, connectionImpl);
            }
        }
        finally {
            this._connectionsLockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConnection", (Object)connectionImpl);
        }
        return connectionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getConnections() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnections");
        }
        HashMap hashMap = null;
        HashMap hashMap2 = this._connections;
        synchronized (hashMap2) {
            hashMap = (HashMap)this._connections.clone();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnections", (Object)hashMap);
        }
        return hashMap;
    }

    void addConsumer(ConsumerSessionImpl consumerSessionImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addConsumer", (Object)consumerSessionImpl);
        }
        this._consumerList.add(consumerSessionImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addConsumer");
        }
    }

    ConsumerSessionImpl getConsumer(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumer", (Object)new Long(l));
        }
        ConsumerSessionImpl consumerSessionImpl = this._consumerList.get(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumer", (Object)consumerSessionImpl);
        }
        return consumerSessionImpl;
    }

    void removeConsumer(ConsumerSessionImpl consumerSessionImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumer", (Object)consumerSessionImpl);
        }
        this._consumerList.remove(consumerSessionImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumer");
        }
    }

    public MessageStore getMessageStore() {
        return this._msgStore;
    }

    public JsMessagingEngine getMessagingEngine() {
        return this._engine;
    }

    public String getMessagingEngineName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineName");
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineName", (Object)this._engine.getName());
        }
        return this._engine.getName();
    }

    public String getMessagingEngineBus() {
        return this._engine.getBusName();
    }

    public SIBUuid8 getMessagingEngineBusUuid() {
        JsBus jsBus = (JsBus)this._engine.getBus();
        return jsBus.getUuid();
    }

    public DestinationManager getDestinationManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationManager");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationManager", (Object)this._destinationManager);
        }
        return this._destinationManager;
    }

    public Administrator getAdministrator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAdministrator");
            SibTr.exit((TraceComponent)tc, (String)"getAdministrator", (Object)this._administrator);
        }
        return this._administrator;
    }

    public MultiMEProxyHandler getProxyHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProxyHandler");
            SibTr.exit((TraceComponent)tc, (String)"getProxyHandler", (Object)this._multiMEProxyHandler);
        }
        return this._multiMEProxyHandler;
    }

    public SICoreConnection createConnection(String string, String string2, Map map) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        if (CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)new Object[]{string, map});
        }
        this.checkStarted();
        String string3 = this._engine.getBusName();
        Subject subject = null;
        SibLoginFactory sibLoginFactory = SibLoginFactory.getInstance();
        SibLogin sibLogin = sibLoginFactory.createNewSibLogin();
        subject = sibLogin.login(string3, string, string2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"subject from SibLoginFactory", (Object)string);
        }
        if (subject == null) {
            if (this._engine.isEventNotificationEnabled()) {
                this.fireNotAuthenticatedEvent(string);
            }
            if (CoreSPIConnFactory.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)"SIAuthenticationException - failed to authenticate");
            }
            throw new SIAuthenticationException(nls.getFormattedMessage("USER_NOT_AUTHORIZED_ERROR_CWSIP0301", new Object[]{string, this.getMessagingEngineName(), this.getMessagingEngineBus()}, null));
        }
        if (!this._accessChecker.checkBusAccess(subject)) {
            if (string == null || string.equals("")) {
                if (this._engine.isEventNotificationEnabled()) {
                    this.fireNullUserEvent();
                }
                if (CoreSPIConnFactory.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)"SINotAuthorizedException");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("NULL_USER_NOT_AUTHORIZED_ERROR_CWSIP0303", new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()}, null));
            }
            String string4 = nls.getFormattedMessage("USER_NOT_AUTHORIZED_ERROR_CWSIP0302", new Object[]{string, this.getMessagingEngineName(), this.getMessagingEngineBus()}, null);
            this._accessChecker.fireBusAccessNotAuthorizedEvent(this.getMessagingEngineBus(), string, string4);
            if (CoreSPIConnFactory.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)"SINotAuthorizedException");
            }
            throw new SINotAuthorizedException(string4);
        }
        SICoreConnection sICoreConnection = this.createConnection(subject, false);
        if (CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)sICoreConnection);
        }
        return sICoreConnection;
    }

    public SICoreConnection createConnection(Subject subject, Map map) throws SIResourceException, SINotAuthorizedException, SIAuthenticationException {
        String string;
        String string2 = this.getAuthorisationUtils().getUserName(subject);
        if (CoreSPIConnFactory.tc.isEntryEnabled()) {
            string = "<null>";
            if (subject != null) {
                string = "subject(" + string2 + ")";
            }
            SibTr.entry((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)new Object[]{string, map});
        }
        this.checkStarted();
        string = this._engine.getBusName();
        SibLoginFactory sibLoginFactory = SibLoginFactory.getInstance();
        SibLogin sibLogin = sibLoginFactory.createNewSibLogin();
        subject = sibLogin.login(string, subject);
        if (this._isBusSecure) {
            if (subject == null) {
                if (this._engine.isEventNotificationEnabled()) {
                    this.fireNotAuthenticatedEvent(string2);
                }
                if (CoreSPIConnFactory.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)"SIAuthenticationException - failed to authenticate");
                }
                throw new SIAuthenticationException(nls.getFormattedMessage("USER_NOT_AUTHORIZED_ERROR_CWSIP0301", new Object[]{string2, this.getMessagingEngineName(), this.getMessagingEngineBus()}, null));
            }
            if (!this._accessChecker.checkBusAccess(subject)) {
                if (string2 == null || string2.equals("")) {
                    if (this._engine.isEventNotificationEnabled()) {
                        this.fireNullUserEvent();
                    }
                    if (CoreSPIConnFactory.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)"SIAuthenticationException - null user");
                    }
                    throw new SINotAuthorizedException(nls.getFormattedMessage("NULL_USER_NOT_AUTHORIZED_ERROR_CWSIP0303", new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()}, null));
                }
                String string3 = nls.getFormattedMessage("USER_NOT_AUTHORIZED_ERROR_CWSIP0302", new Object[]{string2, this.getMessagingEngineName(), this.getMessagingEngineBus()}, null);
                this._accessChecker.fireBusAccessNotAuthorizedEvent(this.getMessagingEngineBus(), string2, string3);
                if (CoreSPIConnFactory.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)"SINotAuthorizedException");
                }
                throw new SINotAuthorizedException(string3);
            }
        }
        SICoreConnection sICoreConnection = this.createConnection(subject, false);
        if (CoreSPIConnFactory.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnFactory.tc, (String)"createConnection", (Object)sICoreConnection);
        }
        return sICoreConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStarted");
        }
        MessageProcessor messageProcessor = this;
        synchronized (messageProcessor) {
            if (!this.isStarted()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkStarted", (Object)"ME not started");
                }
                throw new SIResourceException(nls.getFormattedMessage("MESSAGE_PROCESSOR_NOT_STARTED_ERROR_CWSIP0211", new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStarted");
        }
    }

    public MediationDefinition createMediationDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMediationDefinition");
        }
        JsAdminFactory jsAdminFactory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        MediationDefinition mediationDefinition = jsAdminFactory.createMediationDefinition();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMediationDefinition", (Object)mediationDefinition);
        }
        return mediationDefinition;
    }

    public DestinationDefinition createDestinationDefinition(DestinationType destinationType, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationDefinition", (Object)new Object[]{destinationType, string});
        }
        JsAdminFactory jsAdminFactory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        DestinationDefinition destinationDefinition = jsAdminFactory.createDestinationDefinition(destinationType, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationDefinition", (Object)destinationDefinition);
        }
        return destinationDefinition;
    }

    public LocalizationDefinition createLocalizationDefinition(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLocalizationDefinition", (Object)string);
        }
        JsAdminFactory jsAdminFactory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        LocalizationDefinition localizationDefinition = jsAdminFactory.createLocalizationDefinition(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLocalizationDefinition", (Object)localizationDefinition);
        }
        return localizationDefinition;
    }

    public MediationLocalizationDefinition createMediationLocalizationDefinition(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMediationLocalizationDefinition", (Object)string);
        }
        JsAdminFactory jsAdminFactory = (JsAdminFactory)MessageProcessor.getSingletonInstance("JsAdminFactory");
        MediationLocalizationDefinition mediationLocalizationDefinition = jsAdminFactory.createMediationLocalizationDefinition(string);
        mediationLocalizationDefinition.setInitialState(JsConfigConstants.MEDIATION_INITIAL_STATE_STARTED);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMediationLocalizationDefinition", (Object)mediationLocalizationDefinition);
        }
        return mediationLocalizationDefinition;
    }

    public ExceptionDestinationHandler createExceptionDestinationHandler(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createExceptionDestinationHandler", (Object)string);
        }
        ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = new ExceptionDestinationHandlerImpl(string, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createExceptionDestinationHandler", (Object)exceptionDestinationHandlerImpl);
        }
        return exceptionDestinationHandlerImpl;
    }

    public static Object getSingletonInstance(String string) {
        return _factories.get(string);
    }

    public Object getMEInstance(String string) {
        return this._meFactories.get(string);
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize", (Object)jsMessagingEngine);
        }
        this._engine = jsMessagingEngine;
        this._mpio = new MPIO(this);
        this._meFactories = new HashMap();
        try {
            object2 = (DestinationMediationManager)this.getMessagingEngine().getEngineComponent("com.ibm.ws.sib.mediation.runtime.MediationFramework");
            object = object2.getDestinationMediationFactory();
            this._meFactories.put("MediationFactory", object);
            this._meFactories.put("JsMBeanFactory", jsMessagingEngine.getMBeanFactory());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.initialize", (String)"1:1311:1.365", (Object)this);
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1318:1.365", exception}, null), (Throwable)exception);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1324:1.365", SIMPUtils.getStackTrace(exception)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initialize", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (_factories == null) {
            _factories = new HashMap();
            try {
                _factories.put("JsDestinationAddressFactory", SIDestinationAddressFactory.getInstance());
                _factories.put("SIDestinationAddressFactory", SIDestinationAddressFactory.getInstance());
                _factories.put("ControlMessageFactory", ControlMessageFactory.getInstance());
                _factories.put("JsAdminService", JsAdminService.getInstance());
                _factories.put("JsAdminFactory", JsAdminFactory.getInstance());
                _factories.put("JsMessageFactory", JsMessageFactory.getInstance());
                _factories.put("SIBAccessControlFactory", SIBAccessControlFactory.getInstance());
                _factories.put("Matching", Matching.getInstance());
                _factories.put("AuthUtilsFactory", AuthUtilsFactory.getInstance());
                _factories.put("AuthUtilsInstance", AuthUtilsFactory.getInstance().createNewAuthUtils());
                _factories.put("SelectionCriteriaFactory", SelectionCriteriaFactory.getInstance());
                _factories.put("JsMessageHandleFactory", JsMessageHandleFactory.getInstance());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.initialize", (String)"1:1370:1.365", (Object)this);
                object = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1377:1.365", exception}, null), (Throwable)exception);
                SibTr.exception((TraceComponent)tc, (Exception)object);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1383:1.365", SIMPUtils.getStackTrace(exception)});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"initialize", (Object)object);
                }
                throw object;
            }
        }
        if (!((String)(object2 = jsMessagingEngine.getBus().getAttribute("discardMsgsAfterQueueDeletion"))).equals("")) {
            this._discardMsgsAfterQueueDeletion = ((String)object2).equals("true");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void start(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            try {
                MessageProcessor messageProcessor2 = this;
                // MONITORENTER : messageProcessor2
                this._starting = true;
                // MONITOREXIT : messageProcessor2
                this.startInternal(n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.start", (String)"1:1426:1.365", (Object)this);
                this._stoppableThreadCache.stopAllThreads();
                JsHealthMonitor jsHealthMonitor = (JsHealthMonitor)this._engine;
                jsHealthMonitor.reportGlobalError();
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.prWsWsocessor.impl.MessageProcessor", "1:1461:1.365", exception}, null), (Throwable)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1469:1.365", SIMPUtils.getStackTrace(exception)});
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                MessageProcessor messageProcessor = this;
                // MONITORENTER : messageProcessor
                this._started = false;
                // MONITOREXIT : messageProcessor
                if (!tc.isEntryEnabled()) throw sIErrorException;
                SibTr.exit((TraceComponent)tc, (String)"start", (Object)((Object)sIErrorException));
                throw sIErrorException;
            }
            Object var8_4 = null;
            MessageProcessor messageProcessor = this;
            // MONITORENTER : messageProcessor
            this._starting = false;
            this.notify();
            // MONITOREXIT : messageProcessor
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            MessageProcessor messageProcessor = this;
            // MONITORENTER : messageProcessor
            this._starting = false;
            this.notify();
            // MONITOREXIT : messageProcessor
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInternal(int n) throws MessageStoreException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startInternal", (Object)new Integer(n));
        }
        try {
            object2 = Class.forName("com.ibm.ws.pmi.preprocess.sib_processor_impl_StatsTemplateLookup");
            StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((StatsTemplateLookup)((Class)object2).newInstance()));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startInternal", (String)"1:1532:1.365", (Object)this);
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1539:1.365", exception}, null), (Throwable)exception);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1545:1.365", SIMPUtils.getStackTrace(exception)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startInternal", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        this._stats = new MessageProcessorInstrumentation(this);
        this._msgStore = (MessageStore)this._engine.getMessageStore();
        this._txManager = new SIMPTransactionManager(this._msgStore);
        this._mpAlarmManager = new MPAlarmManager(this, 20, 200);
        this._publicationBatchHandler = new BatchHandler(100, 1000L, this._txManager, this._mpAlarmManager);
        this._sourceBatchHandler = new BatchHandler(100, 1000L, this._txManager, this._mpAlarmManager);
        this._targetBatchHandler = new BatchHandler(10, SIMPConstants.TARGET_BATCH_TIMEOUT, this._txManager, this._mpAlarmManager);
        object2 = this._engine.getBusName();
        SIBAccessControlFactory sIBAccessControlFactory = (SIBAccessControlFactory)MessageProcessor.getSingletonInstance("SIBAccessControlFactory");
        SIBAccessControl sIBAccessControl = sIBAccessControlFactory.createNewSIBAccessControl((String)object2);
        this._accessChecker = new AccessChecker(this, sIBAccessControl);
        this._authorisationUtils = (AuthUtils)MessageProcessor.getSingletonInstance("AuthUtilsInstance");
        this._isBusSecure = this._authorisationUtils.isBusSecure(this.getMessagingEngineBus());
        this._searchResultsPool = new SearchResultsObjectPool("MatchingSearchResults", this._searchResultsPoolSize);
        this._selectionCriteriaFactory = (SelectionCriteriaFactory)MessageProcessor.getSingletonInstance("SelectionCriteriaFactory");
        this._connections = new HashMap();
        boolean bl = this.reconstitute(n);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Warm start state : " + bl));
        }
        if (!bl) {
            this.coldStart();
        } else {
            this._destinationManager.prepareToReconcile();
        }
        if (this._linkManager == null) {
            object = (TrmMeMain)this._engine.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl");
            this._linkManager = object.getLinkManager();
        }
        if (this._linkManager != null) {
            this._linkManager.setChangeListener(this._linkChangeListener);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Link Manager is null");
        }
        this._engine.loadLocalizations();
        this.initializeTickGenerator();
        try {
            this._tdReceiverAddr = SIMPUtils.createJsSystemDestinationAddress("SIMP.TDRECEIVER", this.getMessagingEngineUuid());
            this._tdReceiverAddr.setBusName(this.getMessagingEngineBus());
            if (!this._destinationManager.destinationExists(this._tdReceiverAddr)) {
                this._tdReceiverAddr = this._destinationManager.createSystemDestination("SIMP.TDRECEIVER");
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startInternal", (String)"1:1674:1.365", (Object)this);
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1685:1.365", sIException}, null), (Throwable)sIException);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:1695:1.365", SIMPUtils.getStackTrace(sIException)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startInternal", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        this.createDynamicConfigManager();
        if (bl) {
            SibTr.info((TraceComponent)tc, (String)"RECONCILE_STARTED_INFO_CWSIP00212", (Object)new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()});
            this._destinationManager.validateUnreconciled();
            this._destinationManager.reconcileLocal();
            this._destinationManager.reconcileMQLinks();
            this._destinationManager.reconcileLocalLinks();
            this._destinationManager.reconcileMQLinkPubSubBridgeQs();
            this._destinationManager.reconcileRemote();
            this._destinationManager.reconcileRemoteTemporary();
            this._destinationManager.reconcileRemoteLinks();
            SibTr.info((TraceComponent)tc, (String)"RECONCILE_COMPLETED_INFO_CWSIP00213", (Object)new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()});
            this._destinationManager.start();
        }
        try {
            this._multiMEProxyHandler.initalised();
        }
        catch (SIResourceException sIResourceException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startInternal", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)sIResourceException);
        }
        this._msgStore.expirerStart();
        object = this;
        synchronized (object) {
            this._started = true;
        }
        this._destinationManager.announceMPStarted();
        if (this._isBusSecure) {
            this._accessChecker.listTopicAuthorisations();
        }
        if (this._multicastEnabled) {
            this._multicastProperties = new MulticastPropertiesImpl(this._multicastInterfaceAddress, this._multicastPort, this._multicastPacketSize, this._multicastTTL, this._multicastGroupAddress, this._multicastUseReliableRMM);
        }
        object = this;
        synchronized (object) {
            if (this.isWASOpenForEBusiness()) {
                this.serverStarted();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startInternal");
        }
    }

    private void announceMPStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStopping");
        }
        if (this._destinationManager != null) {
            this._destinationManager.announceMPStopping();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStopping");
        }
    }

    public boolean isWASOpenForEBusiness() {
        return this._isWASOpenForEBusiness;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (this._consumerThreadPool != null) {
            this._consumerThreadPool.shutdownNow();
            this._consumerThreadPool = null;
        }
        if (this._systemThreadPool != null) {
            this._systemThreadPool.shutdownNow();
            this._systemThreadPool = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void stop(int n) {
        block28: {
            Iterator iterator;
            block27: {
                block26: {
                    block25: {
                        if (tc.isEntryEnabled()) {
                            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)new Integer(n));
                        }
                        this.announceMPStopping();
                        this._connectionsLockManager.lockExclusive();
                        MessageProcessor messageProcessor = this;
                        // MONITORENTER : messageProcessor
                        if (this._starting) {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Stop waiting until start complete");
                            }
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                if (!tc.isDebugEnabled()) break block25;
                                SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                            }
                        }
                    }
                    if (!this._started) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"stop", (Object)"Returning as not started.");
                        }
                        // MONITOREXIT : messageProcessor
                        this._connectionsLockManager.unlockExclusive();
                        return;
                    }
                    this._started = false;
                    this._mpio.stop();
                    this._stoppableThreadCache.stopAllThreads();
                    this._msgStore.expirerStop();
                    if (this._destinationManager != null) break block26;
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"stop", (Object)"Null DM");
                    }
                    // MONITOREXIT : messageProcessor
                    this._connectionsLockManager.unlockExclusive();
                    return;
                }
                this._destinationManager.stop(n);
                this._multiMEProxyHandler.stop();
                if (n == 0) {
                    iterator = this.getConnections().keySet().iterator();
                    break block27;
                }
                Iterator iterator2 = this.getConnections().keySet().iterator();
                while (iterator2.hasNext()) {
                    SICoreConnection sICoreConnection = (SICoreConnection)iterator2.next();
                    try {
                        sICoreConnection.close();
                    }
                    catch (SIException sIException) {
                        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.stop", (String)"1:1981:1.365", (Object)this);
                    }
                }
                break block28;
            }
            while (iterator.hasNext()) {
                ConnectionImpl connectionImpl = (ConnectionImpl)iterator.next();
                try {
                    int n2;
                    SICoreConnectionListener[] sICoreConnectionListenerArray = connectionImpl.getConnectionListeners();
                    for (n2 = 0; n2 < sICoreConnectionListenerArray.length; ++n2) {
                        sICoreConnectionListenerArray[n2].meQuiescing((SICoreConnection)connectionImpl);
                    }
                    connectionImpl._close(false);
                    sICoreConnectionListenerArray = connectionImpl.getConnectionListeners();
                    for (n2 = 0; n2 < sICoreConnectionListenerArray.length; ++n2) {
                        sICoreConnectionListenerArray[n2].meTerminated((SICoreConnection)connectionImpl);
                        connectionImpl.removeConnectionListener(sICoreConnectionListenerArray[n2]);
                    }
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.stop", (String)"1:1957:1.365", (Object)this);
                }
            }
            break block28;
            finally {
                this._connectionsLockManager.unlockExclusive();
            }
        }
        this._administrator.stop();
        this._stats.terminate();
        SchemaStoreNotifier.messageStoreStoppingNotify((MessageStore)this._msgStore);
        // MONITOREXIT : messageProcessor
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"stop");
    }

    private void coldStart() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"coldStart");
        }
        this.createPersistentStore();
        this.createDestinationManager();
        this._proxyHandlerDestAddr = SIMPUtils.createJsSystemDestinationAddress("SIMP.PROXY.QUEUE", this.getMessagingEngineUuid());
        this.createProxyHandler();
        this.createSystemConnection();
        this.initializeNonPersistent();
        this._destinationChangeListener = new DestinationChangeListener(this);
        this._linkChangeListener = new LinkChangeListener(this);
        this._destinationLocationManager.setChangeListener(this._destinationChangeListener);
        this.createControlAdapter();
        this.createProxySystemDestination();
        this.configureNeighbours();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"coldStart");
        }
    }

    private void initializeNonPersistent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent");
        }
        this._messageProcessorMatching = new MessageProcessorMatching(this);
        this._topicAuthorization = new TopicAuthorization(this, this._messageProcessorMatching, this._authorisationUtils);
        this._searchResultsPool.setTopicAuthorization(this._topicAuthorization);
        this._accessChecker.setTopicAuthorization(this._topicAuthorization);
        this._administrator = new AdministratorImpl(this);
        TrmMeMain trmMeMain = (TrmMeMain)this._engine.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl");
        if (trmMeMain == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent", (Object)"WsRuntimeException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2097:1.365"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2102:1.365"}, null));
        }
        this._destinationLocationManager = trmMeMain.getDestinationLocationManager();
        this._linkManager = trmMeMain.getLinkManager();
        this._mqLinkManager = trmMeMain.getMQLinkManager();
        RoutingManager routingManager = trmMeMain.getRoutingManager();
        CommsErrorListener commsErrorListener = trmMeMain.getCommsErrorListener();
        RemoteMessageReceiver remoteMessageReceiver = new RemoteMessageReceiver(this, routingManager);
        this._mpio.init(commsErrorListener, routingManager, remoteMessageReceiver);
        try {
            this._rmImpl = SIBPmiRm.getInstance();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.initializeNonPersistent", (String)"1:2123:1.365", (Object)this);
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2131:1.365", exception}, null), (Throwable)exception);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    private void configureNeighbours() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"configureNeighbours");
        }
        try {
            JsAdminService jsAdminService = (JsAdminService)MessageProcessor.getSingletonInstance("JsAdminService");
            this._messagingEnginesOnBus = new HashSet();
            Set set = null;
            if (jsAdminService.isInitialized()) {
                set = jsAdminService.getMessagingEngineSet(this._engine.getBusName());
            }
            if (set != null) {
                Iterator iterator = set.iterator();
                ExternalLocalTransaction externalLocalTransaction = this._txManager.createLocalTransaction();
                while (iterator.hasNext()) {
                    SIBUuid8 sIBUuid8 = new SIBUuid8((String)iterator.next());
                    if (!sIBUuid8.equals((Object)this._engine.getUuid())) {
                        this._multiMEProxyHandler.createNeighbour(sIBUuid8, this._engine.getBusName(), externalLocalTransaction);
                    }
                    this._messagingEnginesOnBus.add(sIBUuid8);
                }
                externalLocalTransaction.commit();
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.configureNeighbours", (String)"1:2204:1.365", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("MESSAGE_PROCESSOR_CONFIGURE_NEIGHBOURS_ERROR_CWSIP0391", new Object[]{this.getMessagingEngineName(), sIException}, null), (Throwable)sIException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"configureNeighbours", (Object)((Object)sIErrorException));
            }
            SibTr.error((TraceComponent)tc, (String)"MESSAGE_PROCESSOR_CONFIGURE_NEIGHBOURS_ERROR_CWSIP0391", (Object)new Object[]{this.getMessagingEngineName(), SIMPUtils.getStackTrace(sIException)});
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configureNeighbours");
        }
    }

    private boolean reconstitute(int n) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Integer(n));
        }
        boolean bl = false;
        this._persistentStore = (MessageProcessorStore)this._msgStore.findFirstMatching(new ClassEqualsFilter(MessageProcessorStore.class));
        if (this._persistentStore != null) {
            this._destinationManager = (DestinationManager)this._persistentStore.findFirstMatchingItemStream(new ClassEqualsFilter(DestinationManager.class));
            if (null == this._destinationManager) {
                SIMPMessageProcessorCorruptException sIMPMessageProcessorCorruptException = new SIMPMessageProcessorCorruptException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2289:1.365"}, null));
                FFDCFilter.processException((Throwable)sIMPMessageProcessorCorruptException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.reconstitute", (String)"1:2295:1.365", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)sIMPMessageProcessorCorruptException);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2302:1.365"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)sIMPMessageProcessorCorruptException);
                }
                throw sIMPMessageProcessorCorruptException;
            }
            this.initializeNonPersistent();
            this._destinationChangeListener = new DestinationChangeListener(this);
            this._linkChangeListener = new LinkChangeListener(this);
            this._destinationLocationManager.setChangeListener(this._destinationChangeListener);
            this._destinationManager.initializeNonPersistent(this);
            this.createControlAdapter();
            this._multiMEProxyHandler = (MultiMEProxyHandler)this._persistentStore.findFirstMatchingItemStream(new ClassEqualsFilter(MultiMEProxyHandler.class));
            if (null == this._multiMEProxyHandler) {
                SIMPMessageProcessorCorruptException sIMPMessageProcessorCorruptException = new SIMPMessageProcessorCorruptException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2344:1.365"}, null));
                FFDCFilter.processException((Throwable)sIMPMessageProcessorCorruptException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.reconstitute", (String)"1:2350:1.365", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)sIMPMessageProcessorCorruptException);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2357:1.365"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)SIMPUtils.getStackTrace(sIMPMessageProcessorCorruptException));
                }
                throw sIMPMessageProcessorCorruptException;
            }
            this._multiMEProxyHandler.initialiseNonPersistent(this, this._txManager);
            this.createSystemConnection();
            this._proxyHandlerDestAddr = SIMPUtils.createJsSystemDestinationAddress("SIMP.PROXY.QUEUE", this.getMessagingEngineUuid());
            try {
                this._multiMEProxyHandler.recoverNeighbours();
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.reconstitute", (String)"1:2383:1.365", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)"SIErrorException");
                }
                throw new SIErrorException((Throwable)sIResourceException);
            }
            this.configureNeighbours();
            try {
                this._destinationManager.reconstitute(n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.reconstitute", (String)"1:2403:1.365", (Object)this);
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2412:1.365", exception}, null), (Throwable)exception);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void createProxyHandler() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxyHandler");
        }
        this._multiMEProxyHandler = new MultiMEProxyHandler(this, this._txManager);
        this._persistentStore.addItemStream(this._multiMEProxyHandler, this._txManager.createAutoCommitTransaction());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxyHandler");
        }
    }

    private void createDestinationManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationManager");
        }
        this._destinationManager = new DestinationManager(this, this._persistentStore);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationManager");
        }
    }

    private void createDynamicConfigManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDynamicConfigManager");
        }
        this._dynamicConfigManager = new DynamicConfigManager(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDynamicConfigManager");
        }
    }

    private void createPersistentStore() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPersistentStore");
        }
        this._persistentStore = new MessageProcessorStore(this._engine.getUuid(), this._msgStore, this._txManager);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPersistentStore");
        }
    }

    private void createSystemConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemConnection");
        }
        Subject subject = this._authorisationUtils.getSIBServerSubject();
        try {
            this._connectionToMP = (MPCoreConnection)this.createConnection(subject, true);
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.createSystemConnection", (String)"1:2510:1.365", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemConnection", (Object)("SIErrorException " + (Object)((Object)sIResourceException)));
            }
            throw new SIErrorException((Throwable)sIResourceException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemConnection");
        }
    }

    public DestinationDefinition createSystemDefaultExceptionDestination() throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemDefaultExceptionDestination");
        }
        DestinationDefinition destinationDefinition = this.createDestinationDefinition(DestinationType.QUEUE, "_SYSTEM.Exception.Destination." + this.getMessagingEngineName());
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setUUID(SIMPUtils.createSIBUuid12("_SYSTEM.Exception.Destination." + this.getMessagingEngineName()));
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.getMessagingEngineUuid().toString());
        this._destinationManager.createDestinationLocalization(this.createLocalizationDefinition(destinationDefinition.getName()), null, destinationDefinition, hashSet, null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemDefaultExceptionDestination", (Object)destinationDefinition);
        }
        return destinationDefinition;
    }

    private void createProxySystemDestination() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxySystemDestination");
        }
        try {
            this._proxyHandlerDestAddr = this._connectionToMP.createSystemDestination("SIMP.PROXY.QUEUE");
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.createProxySystemDestination", (String)"1:2592:1.365", (Object)this);
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2607:1.365", sIException}, null), (Throwable)sIException);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MessageProcessor", "1:2613:1.365", SIMPUtils.getStackTrace(sIException)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createProxySystemDestination", (Object)"SIErrorException");
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxySystemDestination");
        }
    }

    private void initializeTickGenerator() {
        long l;
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"initializeTickGenerator");
            }
            l = -1L;
            try {
                l = this._msgStore.getUniqueTickCount();
            }
            catch (PersistenceException persistenceException) {
                if (!tc.isEventEnabled()) break block4;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)persistenceException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeTickGenerator", (Object)new Long(l));
        }
    }

    public void startNewThread(Runnable runnable) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewThread");
        }
        if (this._consumerThreadPool == null) {
            this.createConsumerThreadPool();
        }
        try {
            this._consumerThreadPool.execute(runnable, 3);
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException((Throwable)threadPoolQueueIsFullException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startNewThread", (String)"1:2683:1.365", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewThread");
        }
    }

    private synchronized void createConsumerThreadPool() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerThreadPool");
        }
        if (this._consumerThreadPool == null) {
            this._consumerThreadPool = new ThreadPool("Consumer " + this.getMessagingEngineName(), 0, SIMPConstants.MAX_CONSUMER_THREADPOOL_SIZE, new ThreadPoolListener[]{new ThreadPoolListenerImpl(this)});
            this._consumerThreadPool.setGrowAsNeeded(true);
            this._consumerThreadPool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerThreadPool");
        }
    }

    public void startNewSystemThread(Runnable runnable) throws InterruptedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startNewSystemThread", (Object)runnable);
        }
        if (this._systemThreadPool == null) {
            this.createSystemThreadPool();
        }
        try {
            this._systemThreadPool.execute(runnable, 3);
        }
        catch (ThreadPool.ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException((Throwable)threadPoolQueueIsFullException, (String)"com.ibm.ws.sib.processor.impl.MessageProcessor.startNewSystemThread", (String)"1:2738:1.365", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startNewSystemThread");
        }
    }

    private synchronized void createSystemThreadPool() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemThreadPool");
        }
        if (this._systemThreadPool == null) {
            this._systemThreadPool = new ThreadPool("System " + this.getMessagingEngineName(), 1, SIMPConstants.MAX_SYSTEM_THREADPOOL_SIZE, new ThreadPoolListener[]{new ThreadPoolListenerImpl(this)});
            this._systemThreadPool.setGrowAsNeeded(true);
            this._systemThreadPool.setRequestBufferExpansionLimit(Integer.MAX_VALUE);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemThreadPool");
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAttribute", (Object)new Object[]{string, string2});
        }
        if (string.equals("highMessageThreshold")) {
            this._highMessageThreshold = Long.parseLong(string2);
        } else if (string.equals("definedSendWindow")) {
            this._definedSendWindow = Integer.parseInt(string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void setCustomProperty(String string, String string2) {
        double d;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty", (Object)new Object[]{string, string2});
        }
        if (string.equals("sib.processor.searchResultsPoolSize")) {
            this._searchResultsPoolSize = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.anycastLockBatchTimeout")) {
            SIMPConstants.ANYCAST_LOCK_BATCH_TIMEOUT = Long.parseLong(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.anycastLockBatchSize")) {
            SIMPConstants.ANYCAST_LOCK_BATCH_SIZE = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.maxThreadPoolSize")) {
            SIMPConstants.MAX_CONSUMER_THREADPOOL_SIZE = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.maxSystemThreadPoolSize")) {
            SIMPConstants.MAX_SYSTEM_THREADPOOL_SIZE = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.browseExpiryTimeout")) {
            SIMPConstants.BROWSE_EXPIRY_TIMEOUT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.browseLivenessTimeout")) {
            SIMPConstants.BROWSE_LIVENESS_TIMEOUT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.browseGetTimeout")) {
            SIMPConstants.BROWSE_GET_TIMEOUT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.initRepetitionInterval")) {
            SIMPConstants.INIT_REPETITION_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.resetRepetitionInterval")) {
            SIMPConstants.RESET_REPETITION_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.decisionExpectedRepetitionInterval")) {
            SIMPConstants.DECISION_EXPECTED_REPETITION_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.senderInactivityTimeout")) {
            SIMPConstants.SENDER_INACTIVITY_TIMEOUT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.eagerGetRequestInterval")) {
            SIMPConstants.EAGER_GET_REQUEST_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.acceptInitialThreshold")) {
            SIMPConstants.ACCEPT_INITIAL_THRESHOLD = Long.parseLong(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.acceptRepetitionInterval")) {
            SIMPConstants.ACCEPT_REPETITION_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.rejectRepetitionInterval")) {
            SIMPConstants.REJECT_REPETITION_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.createStreamRepetitionInterval")) {
            SIMPConstants.CREATE_STREAM_REPETITION_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.initRoundTripTime")) {
            SIMPConstants.INIT_ROUND_TRIP_TIME = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.unlockedRejectInterval")) {
            SIMPConstants.UNLOCKED_REJECT_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.maxPrefetchWindow")) {
            SIMPConstants.MAX_PREFETCH_WINDOW = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.idleTimeout")) {
            SIMPConstants.CK_IDLE_TIMEOUT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.messageWaitTimeGranularity")) {
            SIMPConstants.MESSAGE_WAIT_TIME_GRANULARITY = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastEnabled")) {
            this._multicastEnabled = Boolean.valueOf(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastInterface")) {
            this._multicastInterfaceAddress = string2;
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastPort")) {
            this._multicastPort = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastPacketSize")) {
            this._multicastPacketSize = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastTTL")) {
            this._multicastTTL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastGroupAddress")) {
            this._multicastGroupAddress = string2;
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("multicastUseReliableRMM")) {
            this._multicastUseReliableRMM = Boolean.valueOf(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.targetBatchTimeout")) {
            SIMPConstants.TARGET_BATCH_TIMEOUT = Long.parseLong(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.roundTripTimeLowLimit")) {
            SIMPConstants.ROUND_TRIP_TIME_LOW_LIMIT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.remoteConsumerInactivityTimeout")) {
            SIMPConstants.REMOTE_CONSUMER_CARDINALITY_INACTIVITY_INTERVAL = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.remoteConsumerTransmitterInactivityTimeout")) {
            SIMPConstants.SENDER_INACTIVITY_TIMEOUT = Integer.parseInt(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.blockedRetryTimeout")) {
            SIMPConstants.BLOCKED_RETRY_TIMEOUT = Long.parseLong(string2);
            Runtime.changedPropertyValue((String)string, (String)string2);
        } else if (string.equals("sib.processor.remoteTopicSpaceHighExcess")) {
            double d2 = Double.parseDouble(string2);
            if (d2 >= 0.0) {
                SIMPConstants.REMOTE_QUEUE_HIGH_PERCENTAGE_EXCESS = d2;
                Runtime.changedPropertyValue((String)string, (String)string2);
            }
        } else if (string.equals("sib.processor.destLowUnsetPercentageDecrease") && (d = Double.parseDouble(string2)) >= 0.0 && d < 1.0) {
            SIMPConstants.DEST_LOW_UNSET_PERCENTAGE_DECREASE = d;
            Runtime.changedPropertyValue((String)string, (String)string2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    public MessageProcessorMatching getMessageProcessorMatching() {
        return this._messageProcessorMatching;
    }

    public AccessChecker getAccessChecker() {
        return this._accessChecker;
    }

    public AuthUtils getAuthorisationUtils() {
        return this._authorisationUtils;
    }

    public TopicAuthorization getDiscriminatorAccessChecker() {
        return this._topicAuthorization;
    }

    public JsDestinationAddress getProxyHandlerDestAddr() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProxyHandlerDestAddr");
            SibTr.exit((TraceComponent)tc, (String)"getProxyHandlerDestAddr", (Object)this._proxyHandlerDestAddr);
        }
        return this._proxyHandlerDestAddr;
    }

    public SearchResultsObjectPool getSearchResultsObjectPool() {
        return this._searchResultsPool;
    }

    public MPCoreConnection getSystemConnection() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSystemConnection");
            SibTr.exit((TraceComponent)tc, (String)"getSystemConnection", (Object)this._connectionToMP);
        }
        return this._connectionToMP;
    }

    public MessageProcessorInstrumentation getStats() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStats");
            SibTr.exit((TraceComponent)tc, (String)"getStats", (Object)this._stats);
        }
        return this._stats;
    }

    long getApiMajorVersion() {
        return 6L;
    }

    long getApiMinorVersion() {
        return 0L;
    }

    String getApiLevelDescription() {
        return "6.0";
    }

    public SIBUuid8 getMessagingEngineUuid() {
        return this._persistentStore.getMessagingEngineUuid();
    }

    public long nextTick() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"nextTick");
        }
        long l = -1L;
        try {
            l = this._msgStore.getUniqueTickCount();
        }
        catch (PersistenceException persistenceException) {
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)persistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"nextTick", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)persistenceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"nextTick", (Object)new Long(l));
        }
        return l;
    }

    public MEConnectionListener getMEConnectionListener() {
        return this._mpio;
    }

    protected MPIO getMPIO() {
        return this._mpio;
    }

    public TopologyListener getTopologyListener() {
        return this._mpio;
    }

    public static ControlMessageFactory getControlMessageFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlMessageFactory");
        }
        if (_controlMessageFactory == null) {
            _controlMessageFactory = (ControlMessageFactory)MessageProcessor.getSingletonInstance("ControlMessageFactory");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlMessageFactory", (Object)_controlMessageFactory);
        }
        return _controlMessageFactory;
    }

    public static JsMessageFactory getJsMessageFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessageFactory");
        }
        if (_jsMessageFactory == null) {
            _jsMessageFactory = (JsMessageFactory)MessageProcessor.getSingletonInstance("JsMessageFactory");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessageFactory", (Object)_jsMessageFactory);
        }
        return _jsMessageFactory;
    }

    public static JsMessageHandleFactory getJsMessageHandleFactory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessageHandleFactory");
        }
        if (_jsMessageHandleFactory == null) {
            _jsMessageHandleFactory = (JsMessageHandleFactory)MessageProcessor.getSingletonInstance("JsMessageHandleFactory");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessageHandleFactory", (Object)_jsMessageFactory);
        }
        return _jsMessageHandleFactory;
    }

    public void add(Item item, Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{item, transaction});
        }
        this._persistentStore.addItem(item, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add");
        }
    }

    public SIMPTransactionManager getTXManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTXManager");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTXManager", (Object)this._txManager);
        }
        return this._txManager;
    }

    public BatchHandler getTargetBatchHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetBatchHandler");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTargetBatchHandler", (Object)this._targetBatchHandler);
        }
        return this._targetBatchHandler;
    }

    public BatchHandler getSourceBatchHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceBatchHandler");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSourceBatchHandler", (Object)this._sourceBatchHandler);
        }
        return this._sourceBatchHandler;
    }

    public BatchHandler getPublicationBatchHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPublicationBatchHandler");
            SibTr.exit((TraceComponent)tc, (String)"getPublicationBatchHandler", (Object)this._sourceBatchHandler);
        }
        return this._publicationBatchHandler;
    }

    public StoppableThreadCache getStoppableThreadCache() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStoppableThreadCache");
            SibTr.exit((TraceComponent)tc, (String)"getStoppableThreadCache", (Object)this._stoppableThreadCache);
        }
        return this._stoppableThreadCache;
    }

    public SIBPmiRm getRmImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRmImpl");
            SibTr.exit((TraceComponent)tc, (String)"getRmImpl", (Object)this._rmImpl);
        }
        return this._rmImpl;
    }

    public MPAlarmManager getAlarmManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAlarmManager");
            SibTr.exit((TraceComponent)tc, (String)"getAlarmManager", (Object)this._mpAlarmManager);
        }
        return this._mpAlarmManager;
    }

    public ObjectPool getBatchedTimeoutManagerEntryPool() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchedTimeoutManagerEntryPool");
        }
        if (this._batchedTimeoutManagerEntryPool == null) {
            this._batchedTimeoutManagerEntryPool = new ObjectPool("BTMEntryPool", 200);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBatchedTimeoutManagerEntryPool");
        }
        return this._batchedTimeoutManagerEntryPool;
    }

    public MessagingEngine getMECellule() {
        if (this._trmME == null) {
            this._trmME = new MessagingEngine(this.getMessagingEngineUuid());
        }
        return this._trmME;
    }

    public DestinationLocationManager getDestinationLocationManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLocationManager");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLocationManager", (Object)this._destinationLocationManager);
        }
        return this._destinationLocationManager;
    }

    public LinkManager getLinkManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkManager");
            SibTr.exit((TraceComponent)tc, (String)"getLinkManager");
        }
        return this._linkManager;
    }

    MQLinkManager getMQLinkManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkManager");
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkManager");
        }
        return this._mqLinkManager;
    }

    public Set getSIBDestinationLocalitySet(String string, String string2, boolean bl) throws SIBExceptionDestinationNotFound, SIBExceptionBase {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)new Object[]{string, string2, new Boolean(bl)});
        }
        Set set = this._engine.getSIBDestinationLocalitySet(string, string2, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationLocalitySet", (Object)set);
        }
        return set;
    }

    public Set getSIBMediationLocalitySet(String string, String string2, boolean bl) throws SIBExceptionBase, SIBExceptionMediationNotFound {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBMediationLocalitySet", (Object)new Object[]{string, string2, new Boolean(bl)});
        }
        Set set = this._engine.getSIBMediationLocalitySet(string, string2, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBMediationLocalitySet", (Object)set);
        }
        return set;
    }

    public JsDestinationAddress getTDReceiverAddr() {
        return this._tdReceiverAddr;
    }

    public boolean discardMsgsAfterQueueDeletion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"discardMsgsAfterQueueDeletion");
            SibTr.exit((TraceComponent)tc, (String)"discardMsgsAfterQueueDeletion", (Object)new Boolean(this._discardMsgsAfterQueueDeletion));
        }
        return this._discardMsgsAfterQueueDeletion;
    }

    public long getHighMessageThreshold() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHighMessageThreshold");
            SibTr.exit((TraceComponent)tc, (String)"getHighMessageThreshold", (Object)new Long(this._highMessageThreshold));
        }
        return this._highMessageThreshold;
    }

    public int getDefinedSendWindow() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefinedSendWindow");
            SibTr.exit((TraceComponent)tc, (String)"getDefinedSendWindow", (Object)new Integer(this._definedSendWindow));
        }
        return this._definedSendWindow;
    }

    public DestinationChangeListener getDestinationChangeListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationChangeListener");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationChangeListener", (Object)this._destinationChangeListener);
        }
        return this._destinationChangeListener;
    }

    public ForeignBusDefinition getForeignBus(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBus", (Object)string);
        }
        JsBus jsBus = (JsBus)this._engine.getBus();
        ForeignBusDefinition foreignBusDefinition = jsBus.getForeignBus(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBus", (Object)foreignBusDefinition);
        }
        return foreignBusDefinition;
    }

    public SIBUuid8 mapMeNameToUuid(String string) {
        SIBUuid8 sIBUuid8 = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mapMeNameToUuid", (Object)string);
        }
        if (string != null) {
            sIBUuid8 = string.equals(this.getMessagingEngineName()) ? this.getMessagingEngineUuid() : ((TrmMeMain)this._engine.getEngineComponent("com.ibm.ws.sib.trm.TrmMeMainImpl")).getMeUuid(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"mapMeNameToUuid", sIBUuid8);
        }
        return sIBUuid8;
    }

    public ControlAdapter getControlAdapter() {
        return this._controlAdapter;
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        this._controlAdapter = new MessageProcessorControl(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public static void setMPCallsToUnitTestHandler(MPCallsToUnitTestHandler mPCallsToUnitTestHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMPCallsToUnitTestHandler");
            SibTr.exit((TraceComponent)tc, (String)"setMPCallsToUnitTestHandler");
        }
        _mpCallsToUnitTestHandler = mPCallsToUnitTestHandler;
    }

    public static MPCallsToUnitTestHandler getMPCallsToUnitTestHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPCallsToUnitTestHandler");
            SibTr.exit((TraceComponent)tc, (String)"getMPCallsToUnitTestHandler", (Object)_mpCallsToUnitTestHandler);
        }
        return _mpCallsToUnitTestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStarted");
        }
        MessageProcessor messageProcessor = this;
        synchronized (messageProcessor) {
            if (!this._started || this._isWASOpenForEBusiness) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"serverStarted", (Object)("Returning as ME not started " + this._started + " or already announced " + this._isWASOpenForEBusiness));
                }
                return;
            }
            this._isWASOpenForEBusiness = true;
        }
        this._destinationManager.announceWASOpenForEBusiness();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStarted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopping() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"serverStopping");
        }
        MessageProcessor messageProcessor = this;
        synchronized (messageProcessor) {
            this._isWASOpenForEBusiness = false;
        }
        if (this._destinationManager != null) {
            this._destinationManager.announceWASClosedForEBusiness();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"serverStopping");
        }
    }

    public void dereferenceControlAdapter() {
        this._controlAdapter.dereferenceControllable();
        this._controlAdapter = null;
    }

    public DynamicConfigManager getDynamicConfigManager() {
        return this._dynamicConfigManager;
    }

    public boolean isBusSecure() {
        return this._isBusSecure;
    }

    public void setBusSecure(boolean bl) {
        this._isBusSecure = bl;
    }

    boolean isMulticastEnabled() {
        return this._multicastEnabled;
    }

    MulticastPropertiesImpl getMulticastProperties() {
        return this._multicastProperties;
    }

    public long getID() {
        return this._persistentStore.getID();
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"busReloaded", (Object)new Object[]{sIBus, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        }
        this._busReloaded = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"busReloaded");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"engineReloaded", (Object)jsMessagingEngine);
        }
        this._engine = jsMessagingEngine;
        if (this._busReloaded) {
            this._dynamicConfigManager.refreshDestinations();
        }
        this._busReloaded = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"engineReloaded");
        }
    }

    public SelectionCriteriaFactory getSelectionCriteriaFactory() {
        return this._selectionCriteriaFactory;
    }

    public final boolean isSingleServer() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSingleServer");
        }
        if (!this._singleServerSet) {
            JsAdminService jsAdminService = (JsAdminService)MessageProcessor.getSingletonInstance("JsAdminService");
            this._isSingleServer = jsAdminService.isInitialized() ? jsAdminService.isStandaloneServer() : true;
            this._singleServerSet = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSingleServer", (Object)new Boolean(this._isSingleServer));
        }
        return this._isSingleServer;
    }

    public void setSingleServer(boolean bl) {
        this._singleServerSet = true;
        this._isSingleServer = bl;
    }

    final LockManager getConnectionLockManager() {
        return this._connectionsLockManager;
    }

    public LinkChangeListener getLinkChangeListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkChangeListener");
            SibTr.exit((TraceComponent)tc, (String)"getLinkChangeListener", (Object)this._linkChangeListener);
        }
        return this._linkChangeListener;
    }

    public void setRuntimeEventListener(RuntimeEventListener runtimeEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setRuntimeEventListener", (Object)runtimeEventListener);
        }
        this._runtimeEventListener = runtimeEventListener;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setRuntimeEventListener");
        }
    }

    public RuntimeEventListener getRuntimeEventListener() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRuntimeEventListener");
            SibTr.exit((TraceComponent)tc, (String)"getRuntimeEventListener", (Object)this._runtimeEventListener);
        }
        return this._runtimeEventListener;
    }

    private void fireNotAuthenticatedEvent(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireNotAuthenticatedEvent", (Object)string);
        }
        if (this._runtimeEventListener != null) {
            String string2 = nls.getFormattedMessage("USER_NOT_AUTHORIZED_ERROR_CWSIP0301", new Object[]{string, this.getMessagingEngineName(), this.getMessagingEngineBus()}, null);
            Properties properties = new Properties();
            properties.put("operation", "operation.connect");
            properties.put("security.userid", string);
            properties.put("security.reason", "security.reason.not.authenticated");
            this._runtimeEventListener.runtimeEventOccurred(this._engine, "SIB.security.not.authenticated", string2, properties);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireNotAuthenticatedEvent");
        }
    }

    private void fireNullUserEvent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireNullUserEvent");
        }
        if (this._runtimeEventListener != null) {
            String string = nls.getFormattedMessage("NULL_USER_NOT_AUTHORIZED_ERROR_CWSIP0303", new Object[]{this.getMessagingEngineName(), this.getMessagingEngineBus()}, null);
            Properties properties = new Properties();
            properties.put("operation", "operation.connect");
            properties.put("security.userid", "");
            properties.put("security.reason", "security.reason.no.userid");
            this._runtimeEventListener.runtimeEventOccurred(this._engine, "SIB.security.not.authenticated", string, properties);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireNullUserEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/MessageProcessor.java, SIB.processor, WAS602.SIB, o0610.11 1.365");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
        _factories = null;
        _mpCallsToUnitTestHandler = null;
    }
}

