/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkPubSubBridgeItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.mql.MQLinkManager;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class MQLinkHandler
extends LinkHandler {
    private static final TraceComponent tc = SibTr.register((Class)MQLinkHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SIBUuid8 _mqLinkUuid;
    private ItemStream _mqLinkStateItemStream;
    private long _mqLinkStateItemStreamId;
    private MQLinkPubSubBridgeItemStream _mqLinkPubSubBridgeItemStream;
    private MQLinkManager _mqLinkManager;
    private boolean _registeredInWLM = false;
    private LinkManager _linkManager;

    public MQLinkHandler() {
    }

    public MQLinkHandler(String string, VirtualLinkDefinition virtualLinkDefinition, MessageProcessor messageProcessor, SIMPItemStream sIMPItemStream, Transaction transaction, HashMap hashMap) throws SIResourceException, MessageStoreException {
        super(virtualLinkDefinition, messageProcessor, sIMPItemStream, transaction, hashMap);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MQLinkHandler", (Object)new Object[]{string, virtualLinkDefinition, messageProcessor, sIMPItemStream, transaction, hashMap});
        }
        this._mqLinkUuid = new SIBUuid8(string);
        DestinationDefinition destinationDefinition = messageProcessor.createDestinationDefinition(DestinationType.QUEUE, virtualLinkDefinition.getName());
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        this.updateDefinition((BaseDestinationDefinition)destinationDefinition);
        this._mqLinkStateItemStream = null;
        this._mqLinkPubSubBridgeItemStream = new MQLinkPubSubBridgeItemStream(this, transaction);
        try {
            this._mqLinkManager.define(this.getUuid());
        }
        catch (LinkException linkException) {
            FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.MQLinkHandler", (String)"1:209:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)linkException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"MQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)linkException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MQLinkHandler", (Object)this);
        }
    }

    public void reconstitute(MessageProcessor messageProcessor, HashMap hashMap, int n) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Object[]{messageProcessor, hashMap, new Integer(n)});
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reconstituting MQLink " + this.getName()));
        }
        try {
            super.reconstitute(messageProcessor, hashMap, n);
            if (!this.isToBeDeleted()) {
                if (this._mqLinkStateItemStreamId != 0L) {
                    this._mqLinkStateItemStream = (ItemStream)this.findById(this._mqLinkStateItemStreamId);
                    if (this._mqLinkStateItemStream == null) {
                        SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", new Object[]{this.getName()}, null));
                        SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", (Object)new Object[]{this.getName()});
                        FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.reconstitute", (String)"1:273:1.52.1.3", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)sIResourceException));
                        }
                        throw sIResourceException;
                    }
                }
                NonLockingCursor nonLockingCursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(MQLinkPubSubBridgeItemStream.class));
                this._mqLinkPubSubBridgeItemStream = (MQLinkPubSubBridgeItemStream)nonLockingCursor.next();
                if (this._mqLinkPubSubBridgeItemStream == null) {
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", new Object[]{this.getName()}, null));
                    SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_RECOVERY_ERROR_CWSIP0049", (Object)new Object[]{this.getName()});
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.reconstitute", (String)"1:303:1.52.1.3", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)sIResourceException));
                    }
                    throw sIResourceException;
                }
                nonLockingCursor.finished();
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"MQLink marked to be deleted, bypass state stream integrity checks");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.reconstitute", (String)"1:324:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            this._isCorrupt = true;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)exception);
            }
            throw new SIResourceException((Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public MQLinkPubSubBridgeItemStream getMqLinkPubSubBridgeItemStream() {
        return this._mqLinkPubSubBridgeItemStream;
    }

    public ItemStream getMqLinkStateItemStream() {
        return this._mqLinkStateItemStream;
    }

    public void setMqLinkStateItemStream(ItemStream itemStream, ExternalAutoCommitTransaction externalAutoCommitTransaction) throws OutOfCacheSpace, MessageStoreException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMqLinkStateItemStream", (Object)new Object[]{itemStream, externalAutoCommitTransaction});
        }
        if (this._mqLinkStateItemStream != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMqLinkStateItemStream", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("MQLINK_STATE_ITEMSTREAM_ALREADY_EXISTS", null, null));
        }
        this._mqLinkStateItemStream = itemStream;
        this.addItemStream(itemStream, externalAutoCommitTransaction);
        this._mqLinkStateItemStreamId = itemStream.getID();
        this.requestUpdate(externalAutoCommitTransaction);
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.addPersistentDestinationData(hashMap);
            this.addPersistentLinkData(hashMap);
            hashMap.put("mqlinkuuid", this._mqLinkUuid.toByteArray());
            hashMap.put("mqlinkstateid", new Long(this._mqLinkStateItemStreamId));
            objectOutputStream.writeObject(hashMap);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.getPersistentData", (String)"1:433:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler.getPersistentData", "1:440:1.52.1.3", iOException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler.getPersistentData", "1:449:1.52.1.3", iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            this.restorePersistentDestinationData(hashMap);
            this.restorePersistentLinkData(hashMap);
            this._mqLinkUuid = new SIBUuid8((byte[])hashMap.get("mqlinkuuid"));
            this._mqLinkStateItemStreamId = (Long)hashMap.get("mqlinkstateid");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.restore", (String)"1:489:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler", "1:496:1.52.1.3", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.MQLinkHandler", "1:505:1.52.1.3", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanupDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination");
        }
        boolean bl = false;
        MQLinkHandler mQLinkHandler = this;
        synchronized (mQLinkHandler) {
            if (this.isToBeDeleted()) {
                ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
                this.removeStateItemStreams(externalLocalTransaction);
                externalLocalTransaction.commit();
            }
        }
        bl = this.cleanupBaseDestination();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination", (Object)new Boolean(bl));
        }
        return bl;
    }

    void initializeNonPersistent(MessageProcessor messageProcessor, HashMap hashMap, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)new Object[]{messageProcessor, hashMap, transaction});
        }
        this._mqLinkManager = messageProcessor.getMQLinkManager();
        this._linkManager = messageProcessor.getLinkManager();
        super.initializeNonPersistent(messageProcessor, hashMap, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public SIBUuid8 getMqLinkUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMqLinkUuid");
            SibTr.exit((TraceComponent)tc, (String)"getMqLinkUuid", (Object)this._mqLinkUuid);
        }
        return this._mqLinkUuid;
    }

    public boolean isMQLink() {
        return true;
    }

    void registerDestination() {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"registerDestination");
            }
            if (this._mqLinkManager.isDefined(this.getUuid()) && this.hasLocal() && !this._registeredInWLM) {
                try {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Register MQLink: " + this.getUuid() + ", with linkManager"));
                    }
                    this._linkManager.register(this.getUuid());
                    this._registeredInWLM = true;
                }
                catch (LinkException linkException) {
                    FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.registerDestination", (String)"1:648:1.52.1.3", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)linkException);
                    if (!tc.isEntryEnabled()) break block6;
                    SibTr.exit((TraceComponent)tc, (String)"registerDestination", (Object)linkException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerDestination");
        }
    }

    void deregisterDestination() {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deregisterDestination");
            }
            try {
                if (this._registeredInWLM) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Deregister MQLink: " + this.getUuid() + ", from LinkManager"));
                    }
                    this._linkManager.deregister(this.getUuid());
                }
                this._registeredInWLM = false;
            }
            catch (LinkException linkException) {
                FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.deregisterDestination", (String)"1:692:1.52.1.3", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)linkException);
                if (!tc.isEntryEnabled()) break block6;
                SibTr.exit((TraceComponent)tc, (String)"deregisterDestination", (Object)linkException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterDestination");
        }
    }

    public void registerLink() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerLink");
        }
        try {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Register MQLink: " + this.getUuid() + ", with mqLinkManager"));
            }
            this._mqLinkManager.define(this.getUuid());
        }
        catch (LinkException linkException) {
            FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.registerLink", (String)"1:726:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)linkException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerLink", (Object)linkException);
            }
            throw new SIResourceException((Throwable)linkException);
        }
        this.registerDestination();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerLink");
        }
    }

    public void updatePostRegistration(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updatePostRegistration", (Object)new Boolean(bl));
        }
        if (bl) {
            this.registerDestination();
        } else {
            this.deregisterDestination();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updatePostRegistration");
        }
    }

    private void removeStateItemStreams(Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeStateItemStreams", (Object)transaction);
        }
        try {
            if (this._mqLinkStateItemStream != null) {
                Item item = null;
                while (null != (item = this._mqLinkStateItemStream.findFirstMatchingItem(null))) {
                    item.remove(transaction, -2L);
                }
                this._mqLinkStateItemStream.remove(transaction, -2L);
            }
            if (this._mqLinkPubSubBridgeItemStream != null && this._mqLinkPubSubBridgeItemStream.isInStore()) {
                this._mqLinkPubSubBridgeItemStream.removeAll(transaction);
            }
            this._mqLinkStateItemStream = null;
            this._mqLinkPubSubBridgeItemStream = null;
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.removeStateItemStreams", (String)"1:810:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeStateItemStreams", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeStateItemStreams");
        }
    }

    protected MQLinkMessageItemStream addNewMQLinkLocalisation(Transaction transaction, SIBUuid8 sIBUuid8, LocalizationDefinition localizationDefinition) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)new Object[]{transaction, localizationDefinition});
        }
        MQLinkMessageItemStream mQLinkMessageItemStream = null;
        try {
            mQLinkMessageItemStream = new MQLinkMessageItemStream(this, sIBUuid8);
            transaction.registerCallback(new BaseDestinationHandler.LocalizationAddTransactionCallback(mQLinkMessageItemStream));
            this.addItemStream(mQLinkMessageItemStream, transaction);
            mQLinkMessageItemStream.setDefaultDestLimits();
            mQLinkMessageItemStream.updateLocalizationDefinition(localizationDefinition);
            this.attachPtoPLocalisation(mQLinkMessageItemStream, false);
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.MQLinkHandler.addNewMQLinkLocalisation", (String)"1:893:1.52.1.3", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewMQLinkLocalisation", (Object)mQLinkMessageItemStream);
        }
        return mQLinkMessageItemStream;
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        super.stop(n);
        this._mqLinkManager.undefine(this.getUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/MQLinkHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.52.1.3");
        }
    }
}

