/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageHandle;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.processor.MPLockedMessageEnumeration;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPILockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

final class LockedMessageEnumerationImpl
implements MPLockedMessageEnumeration,
AlarmListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static final TraceComponent tc = SibTr.register((Class)LockedMessageEnumerationImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private LocalConsumerPoint localConsumerPoint;
    private ConsumerSessionImpl consumerSession;
    private boolean messageAvailable = false;
    private LockingCursor getCursor;
    private boolean remoteME;
    private boolean validState = false;
    protected LMEMessage firstMsg;
    protected LMEMessage lastMsg;
    private LMEMessage callbackEntryMsg;
    private LMEMessage currentMsg;
    private LMEMessage pooledMsg;
    private LMEMessage currentUnlockedMessage;
    private LMEMessage nextMsgToExpire;
    private int pooledCount;
    private boolean endReached;
    private boolean isPubsub;
    private boolean copyMsg;
    private boolean setWaitTime;
    private boolean isMediation;
    private long messageLockExpiry = 0L;
    private MPAlarmManager alarmManager = null;
    private boolean alarmRegistered = false;
    private final int poolSize = 20;
    private SIMPTransactionManager txManager;

    LockedMessageEnumerationImpl(LocalConsumerPoint localConsumerPoint, LockingCursor lockingCursor, SIMPTransactionManager sIMPTransactionManager, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LockedMessageEnumerationImpl", (Object)new Object[]{localConsumerPoint, lockingCursor, sIMPTransactionManager, new Boolean(bl)});
        }
        this.firstMsg = null;
        this.lastMsg = null;
        this.callbackEntryMsg = null;
        this.currentMsg = null;
        this.pooledMsg = null;
        this.currentUnlockedMessage = null;
        this.pooledCount = 0;
        this.endReached = false;
        this.nextMsgToExpire = null;
        this.localConsumerPoint = localConsumerPoint;
        this.consumerSession = localConsumerPoint.getConsumerSession();
        this.getCursor = lockingCursor;
        this.isPubsub = localConsumerPoint.getConsumerDispatcher().isPubSub();
        this.copyMsg = ((ConnectionImpl)this.consumerSession.getConnection()).getMessageCopiedWhenReceived();
        this.setWaitTime = ((ConnectionImpl)this.consumerSession.getConnection()).getSetWaitTimeInMessage();
        this.isMediation = localConsumerPoint.isConsumerAMediation();
        this.txManager = sIMPTransactionManager;
        this.remoteME = bl;
        this.alarmManager = localConsumerPoint.getConsumerDispatcher().getMessageProcessor().getAlarmManager();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LockedMessageEnumerationImpl", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCallbackCursor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetCallbackCursor", (Object)new Integer(this.hashCode()));
        }
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            this.callbackEntryMsg = this.lastMsg;
            this.currentMsg = this.lastMsg;
            this.messageAvailable = false;
            this.endReached = false;
            this.validState = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetCallbackCursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewMessage(SIMPMessage sIMPMessage, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewMessage", (Object)new Object[]{new Integer(this.hashCode()), new Long(sIMPMessage.getMessage().getSystemMessageValue()), sIMPMessage.getMessage().getSystemMessageSourceUuid(), sIMPMessage, new Boolean(bl), new Boolean(bl2)});
        }
        long l = sIMPMessage.getMessage().getSystemMessageValue();
        SIBUuid8 sIBUuid8 = sIMPMessage.getMessage().getSystemMessageSourceUuid();
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            LMEMessage lMEMessage = null;
            if (this.pooledMsg == null) {
                lMEMessage = new LMEMessage(l, sIBUuid8, sIMPMessage, bl, bl2, this.messageLockExpiry);
            } else {
                lMEMessage = this.pooledMsg;
                this.pooledMsg = this.pooledMsg.next;
                lMEMessage.next = null;
                --this.pooledCount;
                lMEMessage.reuseMessage(l, sIBUuid8, sIMPMessage, bl, bl2, this.messageLockExpiry);
            }
            lMEMessage.previous = this.lastMsg;
            if (this.lastMsg != null) {
                this.lastMsg.next = lMEMessage;
            } else {
                this.firstMsg = lMEMessage;
            }
            this.lastMsg = lMEMessage;
            if (this.messageLockExpiry != 0L) {
                if (this.nextMsgToExpire == null) {
                    this.nextMsgToExpire = lMEMessage;
                }
                if (!this.alarmRegistered) {
                    this.alarmManager.create(this.messageLockExpiry, this);
                    this.alarmRegistered = true;
                }
            }
            this.validState = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewMessage", (Object)this);
        }
    }

    private void removeMessage(LMEMessage lMEMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{new Integer(this.hashCode()), lMEMessage, this});
        }
        if (lMEMessage == this.callbackEntryMsg) {
            this.callbackEntryMsg = lMEMessage.previous;
        }
        if (lMEMessage == this.currentMsg) {
            this.currentMsg = lMEMessage.previous;
        }
        if (lMEMessage == this.nextMsgToExpire) {
            do {
                this.nextMsgToExpire = this.nextMsgToExpire.next;
            } while (this.nextMsgToExpire != null && this.nextMsgToExpire.expiryTime == 0L);
        }
        if (lMEMessage.previous != null) {
            lMEMessage.previous.next = lMEMessage.next;
        } else {
            this.firstMsg = lMEMessage.next;
        }
        if (lMEMessage.next != null) {
            lMEMessage.next.previous = lMEMessage.previous;
        } else {
            this.lastMsg = lMEMessage.previous;
        }
        if (this.pooledCount < 20) {
            lMEMessage.messageItem = null;
            lMEMessage.next = this.pooledMsg;
            lMEMessage.previous = null;
            lMEMessage.owner = null;
            lMEMessage.jsMessage = null;
            lMEMessage.expiryTime = 0L;
            this.pooledMsg = lMEMessage;
            ++this.pooledCount;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage nextLocked() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        JsMessage jsMessage = null;
        SIMPMessage sIMPMessage = null;
        LMEMessage lMEMessage = null;
        boolean bl = false;
        boolean bl2 = false;
        this.checkValidState("nextLocked");
        this.localConsumerPoint.checkNotClosed();
        Object object = this;
        synchronized (object) {
            if (this.currentUnlockedMessage != null) {
                this.removeMessage(this.currentUnlockedMessage);
                this.currentUnlockedMessage = null;
            }
            if (this.currentMsg != null) {
                this.currentMsg = this.currentMsg.next;
            } else if (!this.endReached) {
                this.currentMsg = this.firstMsg;
            }
            if (this.currentMsg != null) {
                sIMPMessage = this.currentMsg.messageItem;
                jsMessage = this.currentMsg.jsMessage;
                if (jsMessage != null && !this.currentMsg.wasRead) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:469:1.133.1.1"}, null));
                    if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
                if (this.currentMsg.isStored && !this.currentMsg.isRecoverable) {
                    bl2 = true;
                    this.currentMsg.isStored = false;
                } else {
                    bl = this.currentMsg.isStored;
                }
                lMEMessage = this.currentMsg;
                this.currentMsg.wasRead = true;
                this.messageAvailable = true;
            } else {
                this.messageAvailable = false;
                this.endReached = true;
            }
        }
        if (sIMPMessage != null && jsMessage == null) {
            block36: {
                if (bl2) {
                    object = null;
                    Object object2 = null;
                    if (!sIMPMessage.isItemReference() && sIMPMessage.getReportCOD() != null || this.remoteME) {
                        object = this.txManager.createLocalTransaction();
                        object.registerCallback((MessageItem)sIMPMessage);
                        object2 = object;
                    } else {
                        object2 = this.localConsumerPoint.getAutoCommitTransaction();
                    }
                    try {
                        sIMPMessage.remove((Transaction)object2, sIMPMessage.getLockID());
                        if (object == null) break block36;
                        try {
                            object.commit();
                        }
                        catch (SIException sIException) {
                            if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)("SIResourceException " + (Object)((Object)sIException)));
                            }
                            throw new SIResourceException((Throwable)sIException);
                        }
                    }
                    catch (MessageStoreException messageStoreException) {
                        if (object != null) {
                            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.nextLocked", (String)"1:571:1.133.1.1", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:577:1.133.1.1", messageStoreException});
                        }
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)((Object)messageStoreException));
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:591:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                    }
                }
            }
            try {
                jsMessage = sIMPMessage.getMessage();
                boolean bl3 = false;
                if (sIMPMessage.guessRedeliveredCount() != 0) {
                    if (this.isPubsub) {
                        jsMessage = sIMPMessage.getMessage().getReceived();
                        bl3 = true;
                    }
                    jsMessage.setRedeliveredCount(sIMPMessage.guessRedeliveredCount());
                }
                long l = sIMPMessage.updateStatisticsMessageWaitTime();
                if (this.setWaitTime || this.isMediation) {
                    boolean bl4;
                    boolean bl5 = bl4 = l > SIMPConstants.MESSAGE_WAIT_TIME_GRANULARITY;
                    if (bl4) {
                        if (this.isPubsub && !bl3) {
                            jsMessage = sIMPMessage.getMessage().getReceived();
                            bl3 = true;
                        }
                        jsMessage.setMessageWaitTime(l);
                    }
                }
                if (!bl3 && (bl && this.copyMsg || this.isPubsub)) {
                    jsMessage = jsMessage.getReceived();
                }
                lMEMessage.jsMessage = jsMessage;
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.nextLocked", (String)"1:665:1.133.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:672:1.133.1.1", messageCopyFailedException});
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)((Object)messageCopyFailedException));
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:683:1.133.1.1", messageCopyFailedException}, null), (Throwable)messageCopyFailedException);
            }
        }
        if (UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(null, jsMessage, this.consumerSession.getDestinationAddress(), this.consumerSession.getIdInternal());
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)new Object[]{jsMessage, this});
        }
        return jsMessage;
    }

    public void unlockCurrent() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        this.unlockCurrent(false);
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockCurrent(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)new Object[]{new Integer(this.hashCode()), this, new Boolean(bl)});
        }
        this.checkValidState("unlockCurrent");
        this.localConsumerPoint.checkNotClosed();
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            if (!this.messageAvailable) {
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)"Invalid current Message");
                }
                throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_MESSAGE_ERROR_CWSIP0191", new Object[]{this.localConsumerPoint.getConsumerDispatcher().getDestination().getName(), this.localConsumerPoint.getConsumerDispatcher().messageProcessor.getMessagingEngineName()}, null));
            }
            if (this.currentMsg.lockExpired) {
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)"Message lock expired");
                }
                SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[]{MessageProcessor.getJsMessageHandleFactory().createJsMessageHandle(this.currentMsg.uuid, this.currentMsg.id)};
                throw new SIMPMessageNotLockedException(nls.getFormattedMessage("MESSAGE_LOCK_EXPIRED_ERROR_CWSIP0193", new Object[]{sIMessageHandleArray[0].toString(), this.localConsumerPoint.getConsumerDispatcher().getMessageProcessor().getMessagingEngineName()}, null), sIMessageHandleArray);
            }
            this.messageAvailable = false;
            if (this.currentMsg != null) {
                this.currentUnlockedMessage = this.currentMsg;
                if (this.currentMsg.isStored) {
                    try {
                        SIMPMessage sIMPMessage = this.currentMsg.messageItem;
                        if (sIMPMessage != null) {
                            sIMPMessage.unlock(sIMPMessage.getLockID(), null, !bl);
                        }
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.unlockCurrent", (String)"1:797:1.133.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:804:1.133.1.1", messageStoreException});
                        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)((Object)messageStoreException));
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:815:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                    }
                }
            }
        }
        this.localConsumerPoint.removeActiveMessages(1);
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCurrent(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException, SIMPMessageNotLockedException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)new Object[]{new Integer(this.hashCode()), sITransaction, this});
        }
        this.checkValidState("deleteCurrent");
        this.localConsumerPoint.checkNotClosed();
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778", new Object[]{this.consumerSession.getDestinationAddress()}, null));
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
            }
            if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIMPMessage sIMPMessage = null;
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (!this.messageAvailable) {
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)"Invalid Current Message");
                }
                throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_MESSAGE_ERROR_CWSIP0192", new Object[]{this.localConsumerPoint.getConsumerDispatcher().getDestination().getName(), this.localConsumerPoint.getConsumerDispatcher().messageProcessor.getMessagingEngineName()}, null));
            }
            if (this.currentMsg.lockExpired) {
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)"Message lock expired");
                }
                SIMessageHandle[] sIMessageHandleArray = new SIMessageHandle[]{MessageProcessor.getJsMessageHandleFactory().createJsMessageHandle(this.currentMsg.uuid, this.currentMsg.id)};
                throw new SIMPMessageNotLockedException(nls.getFormattedMessage("MESSAGE_LOCK_EXPIRED_ERROR_CWSIP0193", new Object[]{sIMessageHandleArray[0].toString(), this.localConsumerPoint.getConsumerDispatcher().getMessageProcessor().getMessagingEngineName()}, null), sIMessageHandleArray);
            }
            sIMPMessage = this.currentMsg.messageItem;
            bl = this.currentMsg.isStored;
            this.removeMessage(this.currentMsg);
            this.messageAvailable = false;
        }
        if (sIMPMessage != null && bl) {
            try {
                object = (Transaction)sITransaction;
                ExternalLocalTransaction externalLocalTransaction = null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!sIMPMessage.isItemReference() && sIMPMessage.getReportCOD() != null || this.remoteME) {
                    bl2 = true;
                    bl3 = true;
                }
                if (sITransaction == null) {
                    if (bl2) {
                        externalLocalTransaction = this.txManager.createLocalTransaction();
                        object = externalLocalTransaction;
                    } else {
                        object = this.localConsumerPoint.getAutoCommitTransaction();
                    }
                } else if (this.remoteME && object.isAutoCommit()) {
                    externalLocalTransaction = this.txManager.createLocalTransaction();
                    object = externalLocalTransaction;
                }
                if (bl3) {
                    object.registerCallback((MessageItem)sIMPMessage);
                } else if (this.localConsumerPoint.isCountingActiveMessages() && sITransaction != null) {
                    object.registerCallback(this.localConsumerPoint);
                }
                sIMPMessage.remove((Transaction)object, sIMPMessage.getLockID());
                if (externalLocalTransaction != null) {
                    externalLocalTransaction.commit();
                } else if (sITransaction == null) {
                    this.localConsumerPoint.removeActiveMessages(1);
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.deleteCurrent", (String)"1:985:1.133.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:992:1.133.1.1", messageStoreException});
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)((Object)messageStoreException));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1003:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            }
        }
        this.localConsumerPoint.removeActiveMessages(1);
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSeen(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIErrorException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)new Object[]{new Integer(this.hashCode()), sITransaction, this});
        }
        this.checkValidState("deleteSeen");
        this.localConsumerPoint.checkNotClosed();
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778", new Object[]{this.consumerSession.getDestinationAddress()}, null));
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
            }
            if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        ExternalLocalTransaction externalLocalTransaction = null;
        int n = 0;
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            if (this.currentUnlockedMessage != null) {
                this.removeMessage(this.currentUnlockedMessage);
                this.currentUnlockedMessage = null;
            }
            this.messageAvailable = false;
            if (this.firstMsg != null) {
                try {
                    LMEMessage lMEMessage = this.firstMsg;
                    LMEMessage lMEMessage2 = this.currentMsg == null && this.endReached ? this.lastMsg : this.currentMsg;
                    if (lMEMessage2 != null) {
                        Transaction transaction = (Transaction)sITransaction;
                        boolean bl = true;
                        if (transaction != null) {
                            transaction.registerCallback((MessageItem)lMEMessage.messageItem);
                        }
                        while (bl) {
                            if (lMEMessage == lMEMessage2) {
                                bl = false;
                            }
                            if (lMEMessage.isStored) {
                                if (transaction == null) {
                                    externalLocalTransaction = this.txManager.createLocalTransaction();
                                    transaction = externalLocalTransaction;
                                    transaction.registerCallback((MessageItem)lMEMessage.messageItem);
                                }
                                transaction.registerCallback(this.localConsumerPoint);
                                lMEMessage.messageItem.remove(transaction, lMEMessage.messageItem.getLockID());
                            } else {
                                ++n;
                            }
                            LMEMessage lMEMessage3 = lMEMessage;
                            lMEMessage = lMEMessage.next;
                            this.removeMessage(lMEMessage3);
                        }
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.deleteSeen", (String)"1:1125:1.133.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1132:1.133.1.1", messageStoreException});
                    if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)((Object)messageStoreException));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1143:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                }
            }
        }
        if (n != 0) {
            this.localConsumerPoint.removeActiveMessages(n);
        }
        if (externalLocalTransaction != null) {
            externalLocalTransaction.commit();
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCursor() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor", (Object)new Object[]{this, new Integer(this.hashCode())});
        }
        this.checkValidState("resetCursor");
        this.localConsumerPoint.checkNotClosed();
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            if (this.currentUnlockedMessage != null) {
                this.removeMessage(this.currentUnlockedMessage);
                this.currentUnlockedMessage = null;
            }
            this.currentMsg = this.callbackEntryMsg;
            this.endReached = false;
            this.messageAvailable = false;
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor", (Object)this);
        }
    }

    public ConsumerSession getConsumerSession() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)new Integer(this.hashCode()));
        }
        this.checkValidState("getConsumerSession");
        this.localConsumerPoint.checkNotClosed();
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)this.consumerSession);
        }
        return this.consumerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemainingMessageCount() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        int n = 0;
        this.checkValidState("getRemainingMessageCount");
        this.localConsumerPoint.checkNotClosed();
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            if (!this.endReached) {
                LMEMessage lMEMessage = this.currentMsg == null ? this.firstMsg : this.currentMsg.next;
                while (lMEMessage != null) {
                    ++n;
                    lMEMessage = lMEMessage.next;
                }
            }
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIBusMessage relockSavedMsg() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"relockSavedMsg", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        JsMessage jsMessage = null;
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            SIMPMessage sIMPMessage;
            if (this.currentUnlockedMessage != null && (sIMPMessage = this.currentUnlockedMessage.messageItem) != null) {
                if (sIMPMessage.lockItemIfAvailable(this.getCursor.getLockID())) {
                    sIMPMessage.eventLocked();
                    jsMessage = this.currentUnlockedMessage.jsMessage;
                    this.messageAvailable = true;
                    this.currentUnlockedMessage = null;
                } else {
                    sIMPMessage = null;
                    this.removeMessage(this.currentUnlockedMessage);
                    this.currentUnlockedMessage = null;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"relockSavedMsg", jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockAll() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockAll", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        int n = 0;
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            this.messageAvailable = false;
            if (this.firstMsg != null) {
                try {
                    LMEMessage lMEMessage = this.firstMsg;
                    boolean bl = true;
                    while (bl) {
                        if (lMEMessage == this.lastMsg) {
                            bl = false;
                        }
                        if (lMEMessage != this.currentUnlockedMessage) {
                            if (lMEMessage.isStored) {
                                lMEMessage.messageItem.unlock(lMEMessage.messageItem.getLockID());
                            }
                            ++n;
                        }
                        LMEMessage lMEMessage2 = lMEMessage;
                        lMEMessage = lMEMessage.next;
                        this.removeMessage(lMEMessage2);
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.unlockAll", (String)"1:1363:1.133.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1370:1.133.1.1", messageStoreException});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)((Object)messageStoreException));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1381:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                }
                this.currentUnlockedMessage = null;
            }
        }
        if (n != 0) {
            this.localConsumerPoint.removeActiveMessages(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockAll", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIBusMessage[] processMsgSet(SIMessageHandle[] sIMessageHandleArray, Transaction transaction, BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl, boolean bl, boolean bl2, boolean bl3) throws SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException, SIMPMessageNotLockedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMsgSet", (Object)new Object[]{new Integer(this.hashCode()), SIMPUtils.messageHandleArrayToString(sIMessageHandleArray), transaction, bifurcatedConsumerSessionImpl, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), this});
        }
        int n = sIMessageHandleArray.length;
        ExternalLocalTransaction externalLocalTransaction = null;
        if (transaction != null && !transaction.isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778", new Object[]{this.consumerSession.getDestinationAddress()}, null));
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBusMessage[] sIBusMessageArray = null;
        if (bl3) {
            sIBusMessageArray = new SIBusMessage[n];
        }
        SIMessageHandle[] sIMessageHandleArray2 = null;
        int n2 = 0;
        int n3 = 0;
        SIMPMessage[] sIMPMessageArray = null;
        int n4 = 0;
        SIMPMessage sIMPMessage = null;
        try {
            Object object = this;
            synchronized (object) {
                int n5 = 0;
                for (n5 = 0; n5 < n; ++n5) {
                    if (sIMessageHandleArray[n5] != null) {
                        LMEMessage lMEMessage = this.firstMsg;
                        boolean bl4 = false;
                        while (lMEMessage != null) {
                            if (lMEMessage.id == ((JsMessageHandle)sIMessageHandleArray[n5]).getSystemMessageValue() && lMEMessage.uuid.equals((Object)((JsMessageHandle)sIMessageHandleArray[n5]).getSystemMessageSourceUuid()) && lMEMessage != this.currentUnlockedMessage) {
                                if (!lMEMessage.lockExpired) {
                                    if (lMEMessage.owner != null && lMEMessage.owner != bifurcatedConsumerSessionImpl) break;
                                    if (bl3) {
                                        sIBusMessageArray[n5] = lMEMessage.jsMessage;
                                        lMEMessage.expiryTime = 0L;
                                        if (bifurcatedConsumerSessionImpl != null && !bl2) {
                                            lMEMessage.owner = bifurcatedConsumerSessionImpl;
                                        }
                                    }
                                    if (bl2) {
                                        if (lMEMessage.isStored) {
                                            if (transaction == null) {
                                                if (n > 1 || !lMEMessage.messageItem.isItemReference() && lMEMessage.messageItem.getReportCOD() != null || this.remoteME) {
                                                    externalLocalTransaction = this.txManager.createLocalTransaction();
                                                    transaction = externalLocalTransaction;
                                                } else {
                                                    sIMPMessage = lMEMessage.messageItem;
                                                }
                                            } else if (this.remoteME && transaction.isAutoCommit()) {
                                                externalLocalTransaction = this.txManager.createLocalTransaction();
                                                transaction = externalLocalTransaction;
                                            }
                                            if (sIMPMessage == null) {
                                                transaction.registerCallback((TransactionCallback)((Object)lMEMessage.messageItem));
                                                if (this.localConsumerPoint.isCountingActiveMessages()) {
                                                    transaction.registerCallback(this.localConsumerPoint);
                                                }
                                                lMEMessage.messageItem.remove(transaction, lMEMessage.messageItem.getLockID());
                                            }
                                        } else {
                                            ++n3;
                                        }
                                        this.removeMessage(lMEMessage);
                                    } else if (bl) {
                                        if (lMEMessage.isStored) {
                                            if (sIMPMessageArray == null) {
                                                sIMPMessageArray = new SIMPMessage[n];
                                            }
                                            sIMPMessageArray[n4++] = lMEMessage.messageItem;
                                        }
                                        this.removeMessage(lMEMessage);
                                        ++n3;
                                    }
                                    bl4 = true;
                                    break;
                                }
                                this.removeMessage(lMEMessage);
                                break;
                            }
                            lMEMessage = lMEMessage.next;
                        }
                        if (bl4) continue;
                        if (sIMessageHandleArray2 == null) {
                            sIMessageHandleArray2 = new SIMessageHandle[n];
                        }
                        sIMessageHandleArray2[n2] = sIMessageHandleArray[n5];
                        ++n2;
                        continue;
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)"SIIncorrectCallException one or more null SIMessageHandles");
                    }
                    throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("LME_ERROR_CWSIR0132", null, null));
                }
            }
            if (sIMPMessage != null) {
                object = this.txManager.createAutoCommitTransaction();
                sIMPMessage.remove((Transaction)object, sIMPMessage.getLockID());
                ++n3;
            } else if (externalLocalTransaction != null) {
                externalLocalTransaction.commit();
            }
            if (n3 != 0) {
                this.localConsumerPoint.removeActiveMessages(n3);
            }
            if (n4 != 0) {
                for (int i = 0; i < n4; ++i) {
                    sIMPMessageArray[i].unlock(sIMPMessageArray[i].getLockID());
                }
            }
            if (sIMessageHandleArray2 != null) {
                SIMessageHandle[] sIMessageHandleArray3 = new SIMessageHandle[n2];
                System.arraycopy(sIMessageHandleArray2, 0, sIMessageHandleArray3, 0, n2);
                SIMPMessageNotLockedException sIMPMessageNotLockedException = new SIMPMessageNotLockedException(nls.getFormattedMessage("CORE_MESSAGE_NOT_FOUND_ERROR_CWSIP0173", new Object[]{SIMPUtils.messageHandleArrayToString(sIMessageHandleArray3), this.localConsumerPoint.getConsumerDispatcher().getDestination().getName(), this.localConsumerPoint.getConsumerDispatcher().getMessageProcessor().getMessagingEngineName()}, null), sIMessageHandleArray3);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)((Object)sIMPMessageNotLockedException));
                }
                throw sIMPMessageNotLockedException;
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.processMsgSet", (String)"1:1689:1.133.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1696:1.133.1.1", messageStoreException});
            if (externalLocalTransaction != null) {
                externalLocalTransaction.rollback();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1714:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMsgSet", (Object)new Object[]{sIBusMessageArray, this});
        }
        return sIBusMessageArray;
    }

    private void checkValidState(String string) throws SIIncorrectCallException {
        if (!this.validState) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkValidState");
            }
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("LME_ERROR_CWSIR0131", new Object[]{string}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkValidState", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        LMEMessage lMEMessage;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "endReached:" + this.endReached + "\n");
        stringBuffer.append(string + "msgAvailable:" + this.messageAvailable + "\n");
        if (this.currentMsg == null) {
            stringBuffer.append(string + "No current message\n");
        }
        if ((lMEMessage = this.firstMsg) != null) {
            while (lMEMessage != null) {
                if (lMEMessage == this.firstMsg) {
                    stringBuffer.append(string + "firstMsg:\n");
                }
                if (lMEMessage == this.callbackEntryMsg) {
                    stringBuffer.append(string + "callbackEntryMsg:\n");
                }
                if (lMEMessage == this.currentUnlockedMessage) {
                    stringBuffer.append(string + "currentUnlockedMessage:\n");
                }
                if (lMEMessage == this.currentMsg) {
                    stringBuffer.append(string + "currentMsg:\n");
                }
                if (lMEMessage == this.nextMsgToExpire) {
                    stringBuffer.append(string + "nextMsgToExpire:\n");
                }
                if (lMEMessage == this.lastMsg) {
                    stringBuffer.append(string + "lastMsg:\n");
                }
                stringBuffer.append(string + "  " + lMEMessage.toString());
                lMEMessage = lMEMessage.next;
            }
        } else {
            stringBuffer.append(string + "No messages in the enumeration\n");
        }
        stringBuffer.append(string + "pooledCount: " + this.pooledCount + "\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        boolean bl = false;
        this.checkValidState("hasNext");
        this.localConsumerPoint.checkNotClosed();
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            if (!this.endReached) {
                if (this.currentMsg == null) {
                    if (this.firstMsg != null) {
                        bl = true;
                    }
                } else if (this.currentMsg.next != null) {
                    bl = true;
                }
            }
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setMessageLockExpiry(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageLockExpiry", (Object)new Long(l));
            SibTr.exit((TraceComponent)tc, (String)"setMessageLockExpiry");
        }
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            this.messageLockExpiry = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)new Object[]{this, this.nextMsgToExpire, object});
        }
        int n = 0;
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            long l = System.currentTimeMillis();
            while (this.nextMsgToExpire != null && this.nextMsgToExpire.expiryTime <= l) {
                if (this.nextMsgToExpire.expiryTime != 0L) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Expiring lock on: " + this.nextMsgToExpire));
                    }
                    try {
                        SIMPMessage sIMPMessage = this.nextMsgToExpire.messageItem;
                        if (sIMPMessage != null) {
                            sIMPMessage.unlock(sIMPMessage.getLockID());
                        }
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.alarm", (String)"1:1967:1.133.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1974:1.133.1.1", messageStoreException});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)((Object)messageStoreException));
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:1985:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                    }
                    this.nextMsgToExpire.lockExpired = true;
                    this.nextMsgToExpire.isStored = false;
                    this.nextMsgToExpire.messageItem = null;
                    this.nextMsgToExpire.jsMessage = null;
                    ++n;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("No expiry for: " + this.nextMsgToExpire));
                }
                do {
                    this.nextMsgToExpire = this.nextMsgToExpire.next;
                } while (this.nextMsgToExpire != null && this.nextMsgToExpire.expiryTime == 0L);
            }
            if (this.nextMsgToExpire != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Registering alarm for: " + this.nextMsgToExpire));
                }
                this.alarmManager.create(this.nextMsgToExpire.expiryTime - l, this);
            }
        }
        if (n != 0) {
            this.localConsumerPoint.removeActiveMessages(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanOutBifurcatedMessages(BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanOutBifurcatedMessages", (Object)new Object[]{new Integer(this.hashCode()), this});
        }
        int n = 0;
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            if (this.firstMsg != null) {
                try {
                    LMEMessage lMEMessage = this.firstMsg;
                    LMEMessage lMEMessage2 = null;
                    while (lMEMessage != null) {
                        lMEMessage2 = lMEMessage;
                        lMEMessage = lMEMessage.next;
                        if (lMEMessage2.owner != bifurcatedConsumerSessionImpl) continue;
                        if (lMEMessage2.isStored) {
                            lMEMessage2.messageItem.unlock(lMEMessage2.messageItem.getLockID());
                        }
                        this.removeMessage(lMEMessage2);
                        ++n;
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl.cleanOutBifurcatedMessages", (String)"1:2089:1.133.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:2096:1.133.1.1", messageStoreException});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"cleanOutBifurcatedMessages", (Object)((Object)messageStoreException));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.LockedMessageEnumerationImpl", "1:2107:1.133.1.1", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                }
            }
        }
        if (n != 0) {
            this.localConsumerPoint.removeActiveMessages(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanOutBifurcatedMessages", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumberOfLockedMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfLockedMessages");
        }
        int n = 0;
        LockedMessageEnumerationImpl lockedMessageEnumerationImpl = this;
        synchronized (lockedMessageEnumerationImpl) {
            LMEMessage lMEMessage = this.firstMsg;
            while (lMEMessage != null) {
                ++n;
                lMEMessage = lMEMessage.next;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfLockedMessages", (Object)new Integer(n));
        }
        return n;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/LockedMessageEnumerationImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.133.1.1");
        }
    }

    final class LMEMessage {
        protected long id;
        protected SIBUuid8 uuid;
        protected boolean isStored;
        protected boolean isRecoverable;
        protected SIMPMessage messageItem;
        protected JsMessage jsMessage = null;
        protected boolean wasRead = false;
        protected long expiryTime = 0L;
        protected boolean lockExpired;
        protected BifurcatedConsumerSessionImpl owner = null;
        protected LMEMessage next;
        protected LMEMessage previous;

        LMEMessage(long l, SIBUuid8 sIBUuid8, SIMPMessage sIMPMessage, boolean bl, boolean bl2, long l2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"LMEMessage", (Object)new Object[]{new Long(l), sIBUuid8, sIMPMessage, new Boolean(bl), new Boolean(bl2), new Long(l2)});
            }
            this.messageItem = sIMPMessage;
            this.id = l;
            this.uuid = sIBUuid8;
            this.isStored = bl;
            this.isRecoverable = bl2;
            this.lockExpired = false;
            if (l2 != 0L && bl2) {
                this.expiryTime = System.currentTimeMillis() + l2;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"LMEMessage", (Object)this);
            }
        }

        public void reuseMessage(long l, SIBUuid8 sIBUuid8, SIMPMessage sIMPMessage, boolean bl, boolean bl2, long l2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"reuseMessage", (Object)new Object[]{new Long(l), sIBUuid8, sIMPMessage, new Boolean(bl), new Boolean(bl2), new Long(l2)});
            }
            this.messageItem = sIMPMessage;
            this.wasRead = false;
            this.jsMessage = null;
            this.id = l;
            this.uuid = sIBUuid8;
            this.isStored = bl;
            this.isRecoverable = bl2;
            this.lockExpired = false;
            if (l2 != 0L && bl2) {
                this.expiryTime = System.currentTimeMillis() + l2;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reuseMessage", (Object)this);
            }
        }

        public String toString() {
            return "Key:" + this.id + "," + this.uuid + " Str:" + this.isStored + " Rec:" + this.isRecoverable + " ExpTime:" + this.expiryTime + " LckExp:" + this.lockExpired + " Owner:" + (this.owner != null ? this.owner.hashCode() : 0) + " Msg:" + this.messageItem + "\n";
        }
    }
}

