/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.Set;

public class DynamicConfigManager {
    private static final TraceComponent tc = SibTr.register((Class)DynamicConfigManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private DestinationIndex _destinationIndex;

    DynamicConfigManager(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DynamicConfigManager", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        this._destinationIndex = this._destinationManager.getDestinationIndex();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DynamicConfigManager", (Object)this);
        }
    }

    public void refreshDestinations() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"refreshDestinations");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.VISIBLE = Boolean.TRUE;
        destinationTypeFilter.CORRUPT = Boolean.FALSE;
        destinationTypeFilter.RESET_ON_RESTART = Boolean.FALSE;
        SIMPIterator sIMPIterator = this._destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            DestinationHandler destinationHandler = (DestinationHandler)sIMPIterator.next();
            try {
                if (destinationHandler.isSystem() || destinationHandler.isTemporary() || destinationHandler.isToBeDeleted() || destinationHandler.isDeleted()) continue;
                this.reloadDestinationFromAdmin(destinationHandler);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.refreshDestinations", (String)"1:146:1.23", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"refreshDestinations");
        }
    }

    private void reloadDestinationFromAdmin(DestinationHandler destinationHandler) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reloadDestinationFromAdmin");
        }
        try {
            BaseDestinationDefinition baseDestinationDefinition = this._messageProcessor.getMessagingEngine().getSIBDestination(destinationHandler.getBus(), destinationHandler.getName());
            if (!baseDestinationDefinition.isAlias() && !baseDestinationDefinition.isForeign() && destinationHandler.getDestinationType() != DestinationType.SERVICE) {
                Object object;
                destinationHandler.updateDefinition(baseDestinationDefinition);
                Set set = this._messageProcessor.getMessagingEngine().getSIBDestinationLocalitySet(destinationHandler.getBus(), destinationHandler.getUuid().toString());
                if (set == null || set.size() == 0) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"reloadDestinationFromAdmin", (Object)"SIErrorException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DynamicConfigManager", "1:204:1.23", destinationHandler.getName()}, null));
                }
                Set set2 = this._messageProcessor.getMessagingEngine().getSIBMediationLocalitySet(destinationHandler.getBus(), destinationHandler.getUuid().toString());
                if (baseDestinationDefinition.isLocal()) {
                    object = (DestinationDefinition)baseDestinationDefinition;
                    if (set2 != null && object.getMediationDefinition() == null && set2.size() != 0) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"reloadDestinationFromAdmin", (Object)"Create destination invalid");
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DynamicConfigManager", "1:232:1.23", destinationHandler.getName()}, null));
                    }
                    if (object.getMediationDefinition() != null && (set2 == null || set2.size() == 0)) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"reloadDestinationFromAdmin", (Object)"Alter destination invalid");
                        }
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DynamicConfigManager", "1:249:1.23", destinationHandler.getName()}, null));
                    }
                }
                object = (BaseDestinationHandler)destinationHandler;
                ((BaseDestinationHandler)object).updateLocalisationSet(set, set2);
            } else {
                destinationHandler.updateDefinition(baseDestinationDefinition);
            }
        }
        catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
            if (destinationHandler.isAlias() || destinationHandler.isForeign() || !destinationHandler.hasLocal()) {
                this.deleteDestination(destinationHandler);
            }
        }
        catch (SIBExceptionBase sIBExceptionBase) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reloadDestinationFromAdmin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDestination(DestinationHandler destinationHandler) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestination", (Object)destinationHandler);
        }
        DestinationManager destinationManager = this._destinationManager;
        synchronized (destinationManager) {
            DestinationHandler destinationHandler2 = destinationHandler;
            synchronized (destinationHandler2) {
                Object object;
                if (destinationHandler.isToBeDeleted() || destinationHandler.isDeleted()) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteDestination", (Object)"Destination to be deleted");
                    }
                    throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (!destinationHandler.isAlias() && !destinationHandler.isForeign()) {
                    object = this._messageProcessor.getTXManager().createAutoCommitTransaction();
                    BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
                    baseDestinationHandler.setToBeDeleted(true);
                    this._destinationIndex.delete(destinationHandler);
                    try {
                        baseDestinationHandler.requestUpdate((Transaction)object);
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DynamicConfigManager.deleteDestination", (String)"1:346:1.23", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteDestination", (Object)"SIResourceException");
                        }
                        throw new SIResourceException((Throwable)((Object)messageStoreException));
                    }
                } else {
                    destinationHandler.setDeleted();
                }
                destinationHandler.closeProducers();
                destinationHandler.closeConsumers();
                destinationHandler.deleteTargettingAliases();
                if (!destinationHandler.isAlias() && !destinationHandler.isForeign()) {
                    object = (BaseDestinationHandler)destinationHandler;
                    ((BaseDestinationHandler)object).addAllLocalisationsForCleanUp();
                    ((BaseDestinationHandler)object).clearLocalisingUuidsSet();
                    this._destinationManager.startAsynchDeletion();
                } else {
                    object = (AbstractAliasDestinationHandler)destinationHandler;
                    this.deleteAbstractAliasDestinationHandler((AbstractAliasDestinationHandler)object);
                    ((AbstractAliasDestinationHandler)object).delete();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestination");
        }
    }

    public void deleteAbstractAliasDestinationHandler(AbstractAliasDestinationHandler abstractAliasDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAbstractAliasDestinationHandler");
        }
        this._destinationIndex.remove(abstractAliasDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAbstractAliasDestinationHandler");
        }
    }

    public void deleteDestination(String string) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        DestinationTypeFilter destinationTypeFilter;
        SIBUuid12 sIBUuid12;
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestination", (Object)string);
        }
        if ((destinationHandler = this._destinationIndex.findByUuid(sIBUuid12 = new SIBUuid12(string), destinationTypeFilter = new DestinationTypeFilter())) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteDestination", (Object)"Null Destination Handler");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_NOT_FOUND_ERROR_CWSP0042", new Object[]{string}, null));
        }
        this.deleteDestination(destinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestination");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/DynamicConfigManager.java, SIB.processor, WAS602.SIB, o0610.11 1.23");
        }
    }
}

