/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationAliasDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.DestinationForeignDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MediationLocalizationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.comms.mq.MQLinkManager;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.DestinationAvailability;
import com.ibm.ws.sib.processor.DestinationListener;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationCorruptException;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPMQLinkCorruptException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPNullParameterException;
import com.ibm.ws.sib.processor.exceptions.SIMPResourceException;
import com.ibm.ws.sib.processor.impl.AbstractBaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.AbstractDestinationHandler;
import com.ibm.ws.sib.processor.impl.AliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.AsynchDeletionThread;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.DestinationListenerDataObject;
import com.ibm.ws.sib.processor.impl.ForeignDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.AbstractDestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.AbstractDestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.impl.indexes.DestinationTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusIndex;
import com.ibm.ws.sib.processor.impl.indexes.ForeignBusTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.LinkIndex;
import com.ibm.ws.sib.processor.impl.indexes.LinkTypeFilter;
import com.ibm.ws.sib.processor.impl.indexes.statemodel.State;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.MessageProcessorStore;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.AliasChainValidator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.psb.PSBFactory;
import com.ibm.ws.sib.psb.PSBFactoryPoint;
import com.ibm.ws.sib.psb.config.ItemStreamManager;
import com.ibm.ws.sib.trm.links.LinkException;
import com.ibm.ws.sib.trm.links.LinkManager;
import com.ibm.ws.sib.trm.links.LinkSelection;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public final class DestinationManager
extends SIMPItemStream {
    private static final TraceComponent tc = SibTr.register((Class)DestinationManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private SIMPTransactionManager txManager;
    private MessageProcessor messageProcessor;
    private DestinationIndex destinationIndex;
    private ForeignBusIndex foreignBusIndex;
    private LinkIndex linkIndex;
    private HashMap durableSubscriptions;
    private boolean reconciling = false;
    protected Object deletionThreadLock = new Object();
    private AsynchDeletionThread asynchDeletionThread = null;
    private AsyncUpdateThread asyncUpdateThread = null;
    private AsyncUpdateThread persistLockThread = null;
    private List destinationListeners = new LinkedList();
    private List deletableSubscriptions = new ArrayList();
    private MQLinkManager _mqlinkManager = null;
    private volatile boolean _isAsyncDeletionThreadStartable = false;

    public DestinationManager() {
    }

    protected DestinationManager(MessageProcessor messageProcessor, MessageProcessorStore messageProcessorStore) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationManager", (Object)new Object[]{messageProcessor, messageProcessorStore});
        }
        ExternalLocalTransaction externalLocalTransaction = messageProcessor.getTXManager().createLocalTransaction();
        try {
            messageProcessorStore.addItemStream(this, externalLocalTransaction);
            this.initializeNonPersistent(messageProcessor);
            externalLocalTransaction.commit();
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.DestinationManager", (String)"1:555:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            this.handleRollback(externalLocalTransaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"DestinationManager", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)((Object)messageStoreException));
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.DestinationManager", (String)"1:573:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            this.handleRollback(externalLocalTransaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"DestinationManager", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationManager", (Object)this);
        }
    }

    private void handleRollback(ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)externalLocalTransaction);
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.rollback();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.handleRollback", (String)"1:613:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    protected void initializeNonPersistent(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)messageProcessor);
        }
        this.messageProcessor = messageProcessor;
        this.txManager = messageProcessor.getTXManager();
        this.destinationIndex = new DestinationIndex(messageProcessor.getMessagingEngineBus());
        this.foreignBusIndex = new ForeignBusIndex();
        this.linkIndex = new LinkIndex();
        this.durableSubscriptions = new HashMap();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    private void putDestinationIntoIndoubtState(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putDestinationIntoIndoubtState");
        }
        DestinationHandler destinationHandler = this.destinationIndex.findByUuid(sIBUuid12, null);
        this.destinationIndex.putInDoubt(destinationHandler);
        destinationHandler.setCorrupt(true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putDestinationIntoIndoubtState");
        }
    }

    public void moveAllInDoubtToUnreconciled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveAllInDoubtToUnreconciled");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.LOCAL = Boolean.TRUE;
        destinationTypeFilter.INDOUBT = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next();
            this.destinationIndex.putUnreconciled(baseDestinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveAllInDoubtToUnreconciled");
        }
    }

    public void validateUnreconciled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"validateUnreconciled");
        }
        JsMessagingEngine jsMessagingEngine = this.messageProcessor.getMessagingEngine();
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.LOCAL = Boolean.TRUE;
        destinationTypeFilter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next();
            try {
                BaseDestinationDefinition baseDestinationDefinition = jsMessagingEngine.getSIBDestination(jsMessagingEngine.getBusName(), baseDestinationHandler.getName());
                if (!baseDestinationDefinition.getUUID().equals((Object)baseDestinationHandler.getUuid())) continue;
                Set set = jsMessagingEngine.getSIBDestinationLocalitySet(jsMessagingEngine.getBusName(), baseDestinationDefinition.getUUID().toString());
                Set set2 = jsMessagingEngine.getSIBMediationLocalitySet(jsMessagingEngine.getBusName(), baseDestinationDefinition.getUUID().toString());
                boolean bl = set.contains(jsMessagingEngine.getUuid().toString());
                boolean bl2 = set2.contains(jsMessagingEngine.getUuid().toString());
                DestinationDefinition destinationDefinition = (DestinationDefinition)baseDestinationDefinition;
                SIBUuid12 sIBUuid12 = destinationDefinition.getUUID();
                if (bl || bl2) {
                    try {
                        this.putDestinationIntoIndoubtState(sIBUuid12);
                        SibTr.error((TraceComponent)tc, (String)"DESTINATION_INDOUBT_ERROR_CWSIP0062", (Object)new Object[]{destinationDefinition.getName(), sIBUuid12});
                        throw new SIErrorException(nls.getFormattedMessage("DESTINATION_INDOUBT_ERROR_CWSIP0062", new Object[]{destinationDefinition.getName(), sIBUuid12}, null));
                    }
                    catch (SIErrorException sIErrorException) {
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.validateUnreconciled", (String)"1:770:1.428.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                        continue;
                    }
                }
                try {
                    this.deleteDestinationLocalization(baseDestinationHandler.getDefinition().getUUID().toString(), destinationDefinition, set, set2);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.validateUnreconciled", (String)"1:795:1.428.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    this.putDestinationIntoIndoubtState(sIBUuid12);
                }
            }
            catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionDestinationNotFound));
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                FFDCFilter.processException((Throwable)sIBExceptionBase, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.validateUnreconciled", (String)"1:822:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionBase));
                this.putDestinationIntoIndoubtState(baseDestinationHandler.getUuid());
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"validateUnreconciled");
        }
    }

    protected void reconstitute(int n) throws MessageStoreException {
        AbstractDestinationIndex.AbstractDestinationType abstractDestinationType;
        BaseDestinationHandler baseDestinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Integer(n));
        }
        NonLockingCursor nonLockingCursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(BaseDestinationHandler.class));
        AbstractItem abstractItem = null;
        if ((n & 1) == 1 && (n & 2) == 0) {
            SibTr.info((TraceComponent)tc, (String)"FLUSH_REQUESTED_MESSAGE_CWSIP0780", (Object)this.messageProcessor.getMessagingEngineName());
        }
        while (null != (abstractItem = nonLockingCursor.next())) {
            baseDestinationHandler = (BaseDestinationHandler)abstractItem;
            if (baseDestinationHandler.isToBeIgnored()) {
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Ignoring old corrupt destination " + baseDestinationHandler.getName()));
                continue;
            }
            if (baseDestinationHandler.isTemporary()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Deleting temporary destination " + baseDestinationHandler.getName()));
                }
                try {
                    baseDestinationHandler.deleteDirtyTemporary(this.messageProcessor, this.durableSubscriptions);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:907:1.428.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:918:1.428.1.1", SIMPUtils.getStackTrace(sIException), baseDestinationHandler.getName()});
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Deleted temporary destination " + baseDestinationHandler.getName()));
                continue;
            }
            try {
                baseDestinationHandler.reconstitute(this.messageProcessor, this.durableSubscriptions, n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:936:1.428.1.1", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0048", (Object)new Object[]{baseDestinationHandler.getName(), SIMPUtils.getStackTrace(exception)});
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            abstractDestinationType = new DestinationIndex.Type();
            abstractDestinationType.state = baseDestinationHandler.isCorrupt() ? State.CORRUPT : (baseDestinationHandler.isSystem() ? State.ACTIVE : State.UNRECONCILED);
            abstractDestinationType.alias = new Boolean(baseDestinationHandler.isAlias());
            abstractDestinationType.foreignDestination = new Boolean(baseDestinationHandler.isForeign());
            abstractDestinationType.queue = new Boolean(!baseDestinationHandler.isPubSub());
            abstractDestinationType.local = new Boolean(baseDestinationHandler.hasLocal());
            abstractDestinationType.remote = new Boolean(baseDestinationHandler.hasRemote());
            this.destinationIndex.put(baseDestinationHandler, abstractDestinationType);
            baseDestinationHandler.registerControlAdapters();
            Object[] objectArray = baseDestinationHandler.getPostReconstitutePseudoIds();
            if (objectArray == null) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                SIBUuid12 sIBUuid12 = (SIBUuid12)objectArray[i];
                this.destinationIndex.addPseudoUuid(baseDestinationHandler, sIBUuid12);
            }
        }
        nonLockingCursor.finished();
        nonLockingCursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(LinkHandler.class));
        abstractItem = null;
        while (null != (abstractItem = nonLockingCursor.next())) {
            baseDestinationHandler = null;
            baseDestinationHandler = (LinkHandler)abstractItem;
            if (baseDestinationHandler.isToBeIgnored()) {
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Ignoring old corrupt link " + ((LinkHandler)baseDestinationHandler).getName()));
                continue;
            }
            try {
                baseDestinationHandler.reconstitute(this.messageProcessor, this.durableSubscriptions, n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:1029:1.428.1.1", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_WARM_START_ERROR_CWSIP0056", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1044:1.428.1.1", SIMPUtils.getStackTrace(exception)});
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            abstractDestinationType = new LinkIndex.Type();
            ((LinkIndex.Type)abstractDestinationType).state = baseDestinationHandler.isCorrupt() ? State.CORRUPT : (baseDestinationHandler.isSystem() ? State.ACTIVE : State.UNRECONCILED);
            ((LinkIndex.Type)abstractDestinationType).mqLink = Boolean.FALSE;
            ((LinkIndex.Type)abstractDestinationType).local = new Boolean(baseDestinationHandler.hasLocal());
            ((LinkIndex.Type)abstractDestinationType).remote = new Boolean(!baseDestinationHandler.hasLocal());
            this.linkIndex.put(baseDestinationHandler, abstractDestinationType);
            baseDestinationHandler.registerControlAdapters();
        }
        nonLockingCursor.finished();
        nonLockingCursor = this.newNonLockingItemStreamCursor(new ClassEqualsFilter(MQLinkHandler.class));
        abstractItem = null;
        while (null != (abstractItem = nonLockingCursor.next())) {
            baseDestinationHandler = null;
            baseDestinationHandler = (MQLinkHandler)abstractItem;
            if (baseDestinationHandler.isToBeIgnored()) {
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Ignoring old corrupt MQlink " + ((LinkHandler)baseDestinationHandler).getName()));
                continue;
            }
            try {
                ((MQLinkHandler)baseDestinationHandler).reconstitute(this.messageProcessor, this.durableSubscriptions, n);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconstitute", (String)"1:1108:1.428.1.1", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"LINK_HANDLER_WARM_START_ERROR_CWSIP0056", (Object)new Object[]{((LinkHandler)baseDestinationHandler).getName(), ((LinkHandler)baseDestinationHandler).getUuid(), SIMPUtils.getStackTrace(exception)});
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            abstractDestinationType = new LinkIndex.Type();
            ((LinkIndex.Type)abstractDestinationType).state = baseDestinationHandler.isCorrupt() ? State.CORRUPT : (baseDestinationHandler.isSystem() ? State.ACTIVE : State.UNRECONCILED);
            ((LinkIndex.Type)abstractDestinationType).mqLink = Boolean.TRUE;
            ((LinkIndex.Type)abstractDestinationType).local = Boolean.TRUE;
            ((LinkIndex.Type)abstractDestinationType).remote = Boolean.FALSE;
            this.linkIndex.put(baseDestinationHandler, abstractDestinationType);
            baseDestinationHandler.registerControlAdapters();
        }
        nonLockingCursor.finished();
        if ((n & 1) == 1 && (n & 2) == 0) {
            SibTr.info((TraceComponent)tc, (String)"FLUSH_COMPLETED_MESSAGE_CWSIP0783", (Object)this.messageProcessor.getMessagingEngineName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public final LinkHandler getLink(String string) {
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        return (LinkHandler)this.linkIndex.findByName(string, linkTypeFilter);
    }

    public DestinationHandler getDestination(JsDestinationAddress jsDestinationAddress, boolean bl) throws SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination", (Object)new Object[]{jsDestinationAddress, new Boolean(bl)});
        }
        DestinationHandler destinationHandler = this.getDestination(jsDestinationAddress.getDestinationName(), jsDestinationAddress.getBusName(), bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public DestinationHandler getDestination(String string, boolean bl) throws SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination", (Object)new Object[]{string, new Boolean(bl)});
        }
        DestinationHandler destinationHandler = this.getDestination(string, null, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public DestinationHandler getDestination(String string, String string2, boolean bl) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination", (Object)new Object[]{string, string2, new Boolean(bl)});
        }
        this.checkDestinationHandlerExists((destinationHandler = this.getDestinationInternal(string, string2, null, bl)) != null, string, this.messageProcessor.getMessagingEngineName(), null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    private DestinationHandler getDestinationInternal(String string, String string2, AliasChainValidator aliasChainValidator, boolean bl) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        Object object;
        boolean bl2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationInternal", (Object)new Object[]{string, string2, aliasChainValidator, new Boolean(bl)});
        }
        this.checkDestinationHandlerExists(string != null, string, this.messageProcessor.getMessagingEngineName(), null);
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl2 = string.startsWith("_Q") || string.startsWith("_T");
        if (!bl2) {
            bl4 = string.startsWith("_P");
        }
        SIBUuid8 sIBUuid8 = null;
        DestinationHandler destinationHandler = null;
        if ((bl2 || bl4) && (string2 == null || string2.equals(this.messageProcessor.getMessagingEngineBus()))) {
            sIBUuid8 = SIMPUtils.parseME(string);
            if (sIBUuid8 != null) {
                boolean bl6 = bl3 = !sIBUuid8.equals((Object)this.messageProcessor.getMessagingEngineUuid());
                if (bl3 && bl2) {
                    object = SIMPUtils.createJsSystemDestinationAddress("SIMP.TDRECEIVER", sIBUuid8);
                    string = object.getDestinationName();
                    string2 = object.getBusName();
                }
            } else {
                SIMPErrorException sIMPErrorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1336:1.428.1.1"}, null));
                sIMPErrorException.setExceptionReason(900);
                sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1341:1.428.1.1"});
                FFDCFilter.processException((Throwable)((Object)sIMPErrorException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.getDestinationInternal", (String)"1:1347:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1353:1.428.1.1"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)((Object)sIMPErrorException));
                }
                throw sIMPErrorException;
            }
        }
        if (string2 == null || string2.equals("")) {
            string2 = this.messageProcessor.getMessagingEngineBus();
        }
        if ((destinationHandler = this.getDestinationInternal(string, string2, bl)) == null && !bl2 && !bl4) {
            destinationHandler = this.loadDestination(string, string2, aliasChainValidator);
        }
        if (destinationHandler == null && !string2.equals(this.messageProcessor.getMessagingEngineBus())) {
            destinationHandler = this.findBus(string2);
        }
        if (destinationHandler != null && destinationHandler.isCorrupt()) {
            object = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_27", new Object[]{string}, null);
            SIMPDestinationCorruptException sIMPDestinationCorruptException = new SIMPDestinationCorruptException((String)object);
            sIMPDestinationCorruptException.setExceptionReason(27);
            sIMPDestinationCorruptException.setExceptionInserts(new String[]{string});
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPDestinationCorruptException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)((Object)sIMPDestinationCorruptException));
            }
            throw sIMPDestinationCorruptException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    DestinationHandler getOrCreateRemoteSystemDestination(String string, boolean bl, boolean bl2) throws SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOrCreateRemoteSystemDestination", (Object)new Object[]{string, new Boolean(bl), new Boolean(bl2)});
        }
        String string2 = string;
        SIBUuid8 sIBUuid8 = null;
        DestinationHandler destinationHandler = null;
        sIBUuid8 = SIMPUtils.parseME(string2);
        if (bl2) {
            JsDestinationAddress jsDestinationAddress = SIMPUtils.createJsSystemDestinationAddress("SIMP.TDRECEIVER", sIBUuid8);
            string2 = jsDestinationAddress.getDestinationName();
        }
        if ((destinationHandler = this.getDestinationInternal(string2, null, null, false)) == null) {
            destinationHandler = this.createRemoteSystemDestination(string2, sIBUuid8);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getOrCreateRemoteSystemDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    private DestinationHandler loadDestination(String string, String string2, AliasChainValidator aliasChainValidator) throws SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        DestinationHandler destinationHandler;
        block14: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"loadDestination", (Object)new Object[]{string, string2, aliasChainValidator});
            }
            destinationHandler = null;
            try {
                BaseDestinationDefinition baseDestinationDefinition = this.messageProcessor.getMessagingEngine().getSIBDestination(string2, string);
                if (baseDestinationDefinition.isAlias()) {
                    DestinationAliasDefinition destinationAliasDefinition = (DestinationAliasDefinition)baseDestinationDefinition;
                    destinationHandler = this.createAliasDestination(destinationAliasDefinition, aliasChainValidator);
                    break block14;
                }
                if (baseDestinationDefinition.isForeign()) {
                    DestinationForeignDefinition destinationForeignDefinition = (DestinationForeignDefinition)baseDestinationDefinition;
                    destinationHandler = this.createForeignDestination(destinationForeignDefinition, string2);
                    break block14;
                }
                try {
                    DestinationDefinition destinationDefinition = (DestinationDefinition)baseDestinationDefinition;
                    Set set = this.messageProcessor.getSIBDestinationLocalitySet(string2, destinationDefinition.getUUID().toString(), false);
                    Set set2 = this.messageProcessor.getSIBMediationLocalitySet(string2, destinationDefinition.getUUID().toString(), false);
                    if (set.contains(this.messageProcessor.getMessagingEngineUuid().toString()) || set2.contains(this.messageProcessor.getMessagingEngineUuid().toString()) || destinationDefinition.getDestinationType() == DestinationType.QUEUE && set.size() == 0 || destinationDefinition.getDestinationType() == DestinationType.PORT && set.size() == 0) {
                        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestintionManager", "1:1546:1.428.1.1", destinationDefinition.getName()}, null));
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.loadDestination", (String)"1:1551:1.428.1.1", (Object)this);
                        break block14;
                    }
                    destinationHandler = this.createRemoteDestination(destinationDefinition, set, set2);
                }
                catch (SIException sIException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionDestinationNotFound));
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionBase));
            }
            catch (SIResourceException sIResourceException) {
                if (!(sIResourceException instanceof SIMPResourceException)) {
                    SIMPResourceException sIMPResourceException = new SIMPResourceException(sIResourceException);
                    sIMPResourceException.setExceptionReason(901);
                    sIMPResourceException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager.loadDestination", "1:1599:1.428.1.1", SIMPUtils.getStackTrace(sIResourceException)});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"loadDestination", (Object)((Object)sIMPResourceException));
                    }
                    throw sIMPResourceException;
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"loadDestination", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"loadDestination", destinationHandler);
        }
        return destinationHandler;
    }

    private final DestinationHandler getDestinationInternal(String string, String string2, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationInternal", (Object)new Object[]{string, string2, new Boolean(bl)});
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        if (!bl) {
            destinationTypeFilter.VISIBLE = Boolean.TRUE;
        }
        DestinationHandler destinationHandler = this.destinationIndex.findByName(string, string2, destinationTypeFilter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public final DestinationHandler getDestinationInternal(SIBUuid12 sIBUuid12, boolean bl) {
        AbstractDestinationTypeFilter abstractDestinationTypeFilter;
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationInternal", (Object)new Object[]{sIBUuid12, new Boolean(bl)});
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        if (!bl) {
            destinationTypeFilter.VISIBLE = Boolean.TRUE;
        }
        if ((destinationHandler = this.destinationIndex.findByUuid(sIBUuid12, destinationTypeFilter)) == null) {
            abstractDestinationTypeFilter = new LinkTypeFilter();
            if (!bl) {
                abstractDestinationTypeFilter.VISIBLE = Boolean.TRUE;
            }
            destinationHandler = this.linkIndex.findByUuid(sIBUuid12, abstractDestinationTypeFilter);
        }
        if (destinationHandler == null) {
            abstractDestinationTypeFilter = new ForeignBusTypeFilter();
            if (!bl) {
                ((ForeignBusTypeFilter)abstractDestinationTypeFilter).VISIBLE = Boolean.TRUE;
            }
            destinationHandler = this.foreignBusIndex.findByUuid(sIBUuid12, abstractDestinationTypeFilter);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationInternal", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public final void addPseudoDestination(SIBUuid12 sIBUuid12, BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPseudoDestination", (Object)new Object[]{sIBUuid12, baseDestinationHandler});
        }
        this.destinationIndex.addPseudoUuid(baseDestinationHandler, sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPseudoDestination");
        }
    }

    public final void removePseudoDestination(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removePseudoDestination", (Object)sIBUuid12);
        }
        this.destinationIndex.removePseudoUuid(sIBUuid12);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removePseudoDestination");
        }
    }

    public void resetDestination(String string) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDestination", (Object)string);
        }
        this.checkDestinationHandlerExists((destinationHandler = this.destinationIndex.findByName(string, this.messageProcessor.getMessagingEngineBus(), null)) != null, string, this.messageProcessor.getMessagingEngineBus(), null);
        destinationHandler.reset();
        this.destinationIndex.reset(destinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDestination");
        }
    }

    public void resetLink(String string) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetLink", (Object)string);
        }
        this.checkDestinationHandlerExists((destinationHandler = this.linkIndex.findByName(string, null)) != null, string, this.messageProcessor.getMessagingEngineBus(), null);
        destinationHandler.reset();
        this.linkIndex.reset(destinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetLink");
        }
    }

    public VirtualLinkDefinition getLinkDefinition(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkDefinition", (Object)string);
        }
        ForeignBusDefinition foreignBusDefinition = this.messageProcessor.getForeignBus(string);
        VirtualLinkDefinition virtualLinkDefinition = null;
        if (foreignBusDefinition != null && foreignBusDefinition.hasLink()) {
            try {
                virtualLinkDefinition = foreignBusDefinition.getLink();
            }
            catch (SIBExceptionNoLinkExists sIBExceptionNoLinkExists) {
                FFDCFilter.processException((Throwable)sIBExceptionNoLinkExists, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.getLinkDefinition", (String)"1:1813:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionNoLinkExists));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLinkDefinition", (Object)virtualLinkDefinition);
        }
        return virtualLinkDefinition;
    }

    public String getTopicSpaceMapping(String string, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceMapping", (Object)new Object[]{string, sIBUuid12});
        }
        VirtualLinkDefinition virtualLinkDefinition = this.getLinkDefinition(string);
        String string2 = this.getDestinationInternal(sIBUuid12, true).getName();
        String string3 = null;
        string3 = virtualLinkDefinition != null && virtualLinkDefinition.getTopicSpaceMappings() != null ? (String)virtualLinkDefinition.getTopicSpaceMappings().get(string2) : string2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceMapping", (Object)string3);
        }
        return string3;
    }

    public HashMap getDurableSubscriptionsTable() {
        return this.durableSubscriptions;
    }

    public boolean destinationExists(JsDestinationAddress jsDestinationAddress) throws SIMPNullParameterException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationExists", (Object)new Object[]{jsDestinationAddress});
        }
        boolean bl = this.destinationExists(jsDestinationAddress.getDestinationName(), jsDestinationAddress.getBusName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean destinationExists(String string, String string2) throws SIMPNullParameterException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationExists", (Object)new Object[]{string, string2});
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)"Destination name null");
            }
            throw new SIMPNullParameterException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{null, this.messageProcessor.getMessagingEngineName()}, null));
        }
        boolean bl = this.destinationIndex.containsKey(string2, string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected SIDestinationAddress createTemporaryDestination(Distribution distribution, String string) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createTemporaryDestination", (Object)new Object[]{string, distribution});
        }
        String string2 = this.createNewTemporaryDestinationName(string, this.messageProcessor.getMessagingEngineUuid(), distribution);
        DestinationType destinationType = DestinationType.QUEUE;
        if (distribution == Distribution.ALL) {
            destinationType = DestinationType.TOPICSPACE;
        }
        DestinationDefinition destinationDefinition = this.messageProcessor.createDestinationDefinition(destinationType, string2);
        destinationDefinition.setMaxReliability(Reliability.RELIABLE_NONPERSISTENT);
        destinationDefinition.setDefaultReliability(Reliability.RELIABLE_NONPERSISTENT);
        destinationDefinition.setUUID(new SIBUuid12());
        if (this.destinationExists(string2, this.messageProcessor.getMessagingEngineBus())) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createTemporaryDestination", (Object)("Destination with name " + string2 + " already exists"));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1982:1.428.1.1"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:1987:1.428.1.1"}, null));
        }
        SIDestinationAddress sIDestinationAddress = ((SIDestinationAddressFactory)MessageProcessor.getSingletonInstance("SIDestinationAddressFactory")).createSIDestinationAddress(string2, true);
        ((JsDestinationAddress)sIDestinationAddress).setBusName(this.messageProcessor.getMessagingEngineBus());
        ((JsDestinationAddress)sIDestinationAddress).setME(this.messageProcessor.getMessagingEngineUuid());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
        LocalizationDefinition localizationDefinition = this.messageProcessor.createLocalizationDefinition(destinationDefinition.getName());
        localizationDefinition.setDestinationHighMsgs(this.messageProcessor.getHighMessageThreshold());
        this.createDestinationLocalization(localizationDefinition, null, destinationDefinition, hashSet, null, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTemporaryDestination", (Object)sIDestinationAddress);
        }
        return sIDestinationAddress;
    }

    String createNewTemporaryDestinationName(String string, SIBUuid8 sIBUuid8, Distribution distribution) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNewTemporaryDestinationName", (Object)new Object[]{string, sIBUuid8, distribution});
        }
        if (string != null) {
            if (string.length() > 12) {
                string = string.substring(0, 12);
            }
        } else {
            string = "";
        }
        long l = this.messageProcessor.nextTick();
        StringBuffer stringBuffer = new StringBuffer("0000000000000000" + Long.toHexString(l).toUpperCase());
        String string2 = stringBuffer.substring(stringBuffer.length() - 16).toString();
        String string3 = null;
        string3 = distribution == Distribution.ONE ? "_Q" : "_T";
        String string4 = string3 + string + '_' + sIBUuid8 + string2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNewTemporaryDestinationName", (Object)string4);
        }
        return string4;
    }

    protected void deleteTemporaryDestination(JsDestinationAddress jsDestinationAddress) throws SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)jsDestinationAddress);
        }
        try {
            destinationHandler = this.getDestination(jsDestinationAddress, false);
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)"SITemporaryDestinationNotFoundException");
            }
            throw new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{jsDestinationAddress.getDestinationName()}, null));
        }
        if (destinationHandler.isTemporary()) {
            if (destinationHandler.isPubSub()) {
                if (destinationHandler.getSubscriptionIndex().getNonDurableSubscriptions() > 0) {
                    SIDestinationLockedException sIDestinationLockedException = new SIDestinationLockedException(nls.getFormattedMessage("TEMPORARY_DESTINATION_IN_USE_ERROR_CWSIP0052", new Object[]{jsDestinationAddress.getDestinationName()}, null));
                    if (tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDestinationLockedException));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)((Object)sIDestinationLockedException));
                    }
                    throw sIDestinationLockedException;
                }
            } else {
                PtoPMessageItemStream ptoPMessageItemStream = destinationHandler.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)ptoPMessageItemStream.getOutputHandler();
                if (consumerDispatcher.hasConsumersAttached()) {
                    SIDestinationLockedException sIDestinationLockedException = new SIDestinationLockedException(nls.getFormattedMessage("TEMPORARY_DESTINATION_IN_USE_ERROR_CWSIP0052", new Object[]{jsDestinationAddress.getDestinationName()}, null));
                    if (tc.isDebugEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDestinationLockedException));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)((Object)sIDestinationLockedException));
                    }
                    throw sIDestinationLockedException;
                }
            }
        }
        try {
            this.deleteDestinationLocalization(destinationHandler.getUuid().toString(), null, null, null);
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)"SITemporaryDestinationNotFoundException");
            }
            throw new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{jsDestinationAddress}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination");
        }
    }

    protected void removeDestination(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDestination", (Object)destinationHandler);
        }
        if (destinationHandler.isLink()) {
            if (this.linkIndex.containsKey(destinationHandler)) {
                this.linkIndex.remove(destinationHandler);
            }
        } else if (this.destinationIndex.containsKey(destinationHandler)) {
            this.destinationIndex.remove(destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDestination");
        }
    }

    protected void createTransmissionDestination(SIBUuid8 sIBUuid8) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createTransmissionDestination", (Object)sIBUuid8);
        }
        String string = sIBUuid8.toString();
        DestinationDefinition destinationDefinition = this.messageProcessor.createDestinationDefinition(DestinationType.QUEUE, string);
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
        this.createDestinationLocalization(this.messageProcessor.createLocalizationDefinition(destinationDefinition.getName()), null, destinationDefinition, hashSet, null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTransmissionDestination");
        }
    }

    public MessageProcessor getLocalME() {
        return this.messageProcessor;
    }

    public void prepareToReconcile() {
        this.moveAllInDoubtToUnreconciled();
        this.reconciling = true;
    }

    public void reconcileLocal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileLocal");
        }
        this.reconciling = false;
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.LOCAL = Boolean.TRUE;
        destinationTypeFilter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next();
            try {
                ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
                baseDestinationHandler.setToBeDeleted(true);
                this.destinationIndex.delete(baseDestinationHandler);
                baseDestinationHandler.requestUpdate(externalLocalTransaction);
                externalLocalTransaction.commit();
                if (baseDestinationHandler.isTemporary() || baseDestinationHandler.isSystem()) continue;
                SibTr.info((TraceComponent)tc, (String)"LOCAL_DEST_DELETE_INFO_CWSIP0063", (Object)new Object[]{baseDestinationHandler.getName(), baseDestinationHandler.getUuid()});
            }
            catch (MessageStoreException messageStoreException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
            catch (SIException sIException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileLocal");
        }
    }

    public void reconcileMQLinks() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileMQLinks");
        }
        this.reconciling = false;
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        linkTypeFilter.MQLINK = Boolean.TRUE;
        linkTypeFilter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.linkIndex.iterator(linkTypeFilter);
        PSBFactory pSBFactory = PSBFactoryPoint.getInstance();
        ItemStreamManager itemStreamManager = pSBFactory.getItemStreamManager();
        MQLinkManager mQLinkManager = this.getMQLinkManager();
        while (sIMPIterator.hasNext()) {
            Object object;
            MQLinkHandler mQLinkHandler = (MQLinkHandler)sIMPIterator.next();
            boolean bl = mQLinkManager.isMQLinkDeletable(mQLinkHandler.getUuid().toString(), mQLinkHandler.getMqLinkStateItemStream());
            if (bl && (object = mQLinkHandler.getMqLinkPubSubBridgeItemStream()) != null) {
                try {
                    itemStreamManager.deleteMQLinkLocalization(mQLinkHandler.getUuid(), (ItemStream)object);
                }
                catch (MessageStoreException messageStoreException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
            }
            if (!bl) {
                this.linkIndex.cleanup(mQLinkHandler);
                this.linkIndex.defer(mQLinkHandler);
                continue;
            }
            try {
                object = this.txManager.createLocalTransaction();
                mQLinkHandler.setToBeDeleted(true);
                this.linkIndex.delete(mQLinkHandler);
                mQLinkHandler.requestUpdate((Transaction)object);
                object.commit();
                SibTr.info((TraceComponent)tc, (String)"MQLINK_DEST_DELETE_INFO_CWSIP0064", (Object)new Object[]{mQLinkHandler.getName(), mQLinkHandler.getUuid()});
            }
            catch (MessageStoreException messageStoreException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
            catch (SIException sIException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileMQLinks");
        }
    }

    public void reconcileLocalLinks() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileLocalLinks");
        }
        this.reconciling = false;
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        linkTypeFilter.LOCAL = Boolean.TRUE;
        linkTypeFilter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.linkIndex.iterator(linkTypeFilter);
        while (sIMPIterator.hasNext()) {
            LinkHandler linkHandler = (LinkHandler)sIMPIterator.next();
            try {
                ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
                linkHandler.setToBeDeleted(true);
                this.linkIndex.delete(linkHandler);
                linkHandler.requestUpdate(externalLocalTransaction);
                externalLocalTransaction.commit();
                SibTr.info((TraceComponent)tc, (String)"LOCAL_LINK_DELETE_INFO_CWSIP0065", (Object)new Object[]{linkHandler.getName(), linkHandler.getUuid()});
            }
            catch (MessageStoreException messageStoreException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
            catch (SIException sIException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileLocalLinks");
        }
    }

    public void reconcileRemote() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileRemote");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            Object object;
            BaseDestinationHandler baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next();
            if (baseDestinationHandler.isToBeDeleted()) continue;
            String string = baseDestinationHandler.getName();
            SIBUuid12 sIBUuid12 = baseDestinationHandler.getUuid();
            try {
                DestinationDefinition destinationDefinition = (DestinationDefinition)this.messageProcessor.getMessagingEngine().getSIBDestination(null, string);
                if (!destinationDefinition.getUUID().equals((Object)baseDestinationHandler.getUuid())) {
                    try {
                        object = this.txManager.createLocalTransaction();
                        baseDestinationHandler.setToBeDeleted(true);
                        this.destinationIndex.delete(baseDestinationHandler);
                        baseDestinationHandler.requestUpdate((Transaction)object);
                        object.commit();
                        SibTr.info((TraceComponent)tc, (String)"REMOTE_DEST_DELETE_INFO_CWSIP0066", (Object)new Object[]{baseDestinationHandler.getName(), baseDestinationHandler.getUuid()});
                    }
                    catch (MessageStoreException messageStoreException) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    }
                    catch (SIException sIException) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    }
                    continue;
                }
                object = this.messageProcessor.getMessagingEngine().getSIBDestinationLocalitySet(null, sIBUuid12.toString());
                Set set = this.messageProcessor.getMessagingEngine().getSIBMediationLocalitySet(null, sIBUuid12.toString());
                baseDestinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                baseDestinationHandler.updateLocalisationSet((Set)object, set);
                DestinationIndex.Type type = (DestinationIndex.Type)this.destinationIndex.getType(baseDestinationHandler);
                type.local = new Boolean(baseDestinationHandler.hasLocal());
                type.remote = new Boolean(baseDestinationHandler.hasRemote());
                this.destinationIndex.setType(baseDestinationHandler, (Index.Type)type);
                this.destinationIndex.create(baseDestinationHandler);
                if (!baseDestinationHandler.getHasReconciledStreamsToBeDeleted()) continue;
                this.destinationIndex.cleanup(baseDestinationHandler);
            }
            catch (SIBExceptionDestinationNotFound sIBExceptionDestinationNotFound) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionDestinationNotFound));
                try {
                    object = this.txManager.createLocalTransaction();
                    baseDestinationHandler.setToBeDeleted(true);
                    this.destinationIndex.delete(baseDestinationHandler);
                    baseDestinationHandler.requestUpdate((Transaction)object);
                    object.commit();
                    SibTr.info((TraceComponent)tc, (String)"REMOTE_DEST_DELETE_INFO_CWSIP0066", (Object)new Object[]{baseDestinationHandler.getName(), baseDestinationHandler.getUuid()});
                }
                catch (MessageStoreException messageStoreException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionDestinationNotFound));
                }
                catch (SIException sIException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionDestinationNotFound));
                }
            }
            catch (SIBExceptionBase sIBExceptionBase) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionBase));
            }
            catch (SIException sIException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileRemote");
        }
    }

    public void reconcileRemoteTemporary() {
    }

    public void reconcileRemoteLinks() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileRemoteLinks");
        }
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        linkTypeFilter.REMOTE = Boolean.TRUE;
        linkTypeFilter.UNRECONCILED = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.linkIndex.iterator(linkTypeFilter);
        while (sIMPIterator.hasNext()) {
            ForeignBusDefinition foreignBusDefinition;
            Object object;
            LinkHandler linkHandler = (LinkHandler)sIMPIterator.next();
            SIBUuid12 sIBUuid12 = linkHandler.getUuid();
            try {
                object = (JsBus)this.messageProcessor.getMessagingEngine().getBus();
                foreignBusDefinition = object.getForeignBusForLink(sIBUuid12.toString());
                if (foreignBusDefinition != null) {
                    foreignBusDefinition.getLinkForNextHop();
                }
            }
            catch (SIBExceptionNoLinkExists sIBExceptionNoLinkExists) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionNoLinkExists));
                foreignBusDefinition = null;
            }
            catch (SIBExceptionBusNotFound sIBExceptionBusNotFound) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIBExceptionBusNotFound));
                foreignBusDefinition = null;
            }
            if (foreignBusDefinition == null) {
                object = this.txManager.createLocalTransaction();
                try {
                    linkHandler.setToBeDeleted(true);
                    linkHandler.requestUpdate((Transaction)object);
                    object.commit();
                    SibTr.info((TraceComponent)tc, (String)"REMOTE_LINK_DELETE_INFO_CWSIP0067", (Object)new Object[]{linkHandler.getName(), linkHandler.getUuid()});
                    this.linkIndex.delete(linkHandler);
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconcileRemoteLinks", (String)"1:2726:1.428.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconcileRemoteLinks", (String)"1:2736:1.428.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    this.handleRollback((ExternalLocalTransaction)object);
                }
                continue;
            }
            try {
                object = null;
                LinkManager linkManager = this.messageProcessor.getLinkManager();
                try {
                    object = linkManager.select(linkHandler.getUuid());
                }
                catch (LinkException linkException) {
                    SibTr.exception((TraceComponent)tc, (Exception)linkException);
                    throw new SIResourceException((Throwable)linkException);
                }
                SIBUuid8 sIBUuid8 = null;
                SIBUuid8 sIBUuid82 = null;
                if (object != null) {
                    sIBUuid8 = ((LinkSelection)object).getInboundMeUuid();
                    sIBUuid82 = ((LinkSelection)object).getOutboundMeUuid();
                    if (sIBUuid8 == null) {
                        sIBUuid8 = sIBUuid82;
                    }
                } else {
                    sIBUuid8 = new SIBUuid8("0000000000000001");
                    sIBUuid82 = null;
                }
                linkHandler.updateLocalisationSet(sIBUuid8, sIBUuid82);
                this.linkIndex.create(linkHandler);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.reconcileRemoteLinks", (String)"1:2796:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                this.linkIndex.corrupt(linkHandler);
            }
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileRemoteLinks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDestinationLocalization(String string, DestinationDefinition destinationDefinition, Set set, Set set2) throws SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)new Object[]{string, destinationDefinition, set, set2});
        }
        BaseDestinationHandler baseDestinationHandler = null;
        String string2 = this.messageProcessor.getMessagingEngineName();
        SIBUuid12 sIBUuid12 = new SIBUuid12(string);
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.ALIAS = Boolean.FALSE;
        destinationTypeFilter.FOREIGN_DESTINATION = Boolean.FALSE;
        DestinationHandler destinationHandler = this.destinationIndex.findByUuid(sIBUuid12, destinationTypeFilter);
        this.checkDestinationHandlerExists(destinationHandler != null, string, this.messageProcessor.getMessagingEngineName(), null);
        baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            BaseDestinationHandler baseDestinationHandler2 = baseDestinationHandler;
            synchronized (baseDestinationHandler2) {
                this.checkDestinationHandlerExists(!baseDestinationHandler.isToBeDeleted() && !baseDestinationHandler.isSystem(), baseDestinationHandler.getName(), this.messageProcessor.getMessagingEngineName(), null);
                if (!baseDestinationHandler.hasLocal() && !baseDestinationHandler.isMediatedLocally() && baseDestinationHandler.getDestinationType() != DestinationType.SERVICE) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)("Destination not known " + baseDestinationHandler.getName()));
                    }
                    if (baseDestinationHandler.isTemporary()) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)"SITemporaryDestinationNotFoundException");
                        }
                        throw new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("DESTINATION_INSTANCE_NOT_FOUND_ERROR_CWSIP0042", new Object[]{baseDestinationHandler.getName(), string2}, null));
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)"SINotPossibleInCurrentConfigurationException");
                    }
                    throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_INSTANCE_NOT_FOUND_ERROR_CWSIP0042", new Object[]{baseDestinationHandler.getName(), string2}, null));
                }
                if (destinationDefinition == null || set == null || set.size() == 0) {
                    ExternalAutoCommitTransaction externalAutoCommitTransaction = this.txManager.createAutoCommitTransaction();
                    baseDestinationHandler.setToBeDeleted(true);
                    if (!destinationHandler.isTemporary() && !destinationHandler.isSystem()) {
                        SibTr.info((TraceComponent)tc, (String)"LOCAL_DEST_DELETE_INFO_CWSIP0063", (Object)new Object[]{destinationHandler.getName(), destinationHandler.getUuid()});
                    }
                    this.destinationIndex.delete(baseDestinationHandler);
                    try {
                        baseDestinationHandler.requestUpdate(externalAutoCommitTransaction);
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteDestinationLocalization", (String)"1:2945:1.428.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)"SIResourceException");
                        }
                        throw new SIResourceException((Throwable)((Object)messageStoreException));
                    }
                    baseDestinationHandler.closeProducers();
                    baseDestinationHandler.closeConsumers();
                    baseDestinationHandler.deleteTargettingAliases();
                    baseDestinationHandler.addAllLocalisationsForCleanUp();
                    baseDestinationHandler.clearLocalisingUuidsSet();
                } else {
                    this.checkMediationLocalitySetNotEmpty(destinationDefinition, set2);
                    this.checkMediationPointsDefinition(set2, destinationDefinition);
                    baseDestinationHandler.updateLocalisationSet(set, set2);
                    DestinationIndex.Type type = (DestinationIndex.Type)this.destinationIndex.getType(baseDestinationHandler);
                    type.local = new Boolean(baseDestinationHandler.hasLocal());
                    type.remote = new Boolean(baseDestinationHandler.hasRemote());
                    this.destinationIndex.setType(baseDestinationHandler, (Index.Type)type);
                    baseDestinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                    this.destinationIndex.cleanup(baseDestinationHandler);
                }
                this.startAsynchDeletion();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization");
        }
    }

    private void checkMediationPointsDefinition(Set set, DestinationDefinition destinationDefinition) {
        if (set != null && destinationDefinition.getMediationDefinition() == null && set.size() != 0) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3023:1.428.1.1", destinationDefinition.getName()}, null));
        }
    }

    public void createDestinationLocalization(LocalizationDefinition localizationDefinition, MediationLocalizationDefinition mediationLocalizationDefinition, DestinationDefinition destinationDefinition, Set set, Set set2, boolean bl) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)new Object[]{localizationDefinition, destinationDefinition, set, new Boolean(bl)});
        }
        ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
        try {
            this.createDestinationLocalization(localizationDefinition, mediationLocalizationDefinition, destinationDefinition, set, set2, bl, externalLocalTransaction);
            externalLocalTransaction.commit();
            this.callDestinationListener(destinationDefinition.getName());
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)((Object)sIIncorrectCallException));
            }
            this.handleRollback(externalLocalTransaction);
            throw new SIResourceException((Throwable)sIIncorrectCallException);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createDestinationLocalization", (String)"1:3098:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)runtimeException);
            }
            this.handleRollback(externalLocalTransaction);
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDestinationLocalization(LocalizationDefinition localizationDefinition, MediationLocalizationDefinition mediationLocalizationDefinition, DestinationDefinition destinationDefinition, Set set, Set set2, boolean bl, ExternalLocalTransaction externalLocalTransaction) throws SIResourceException, SIMPDestinationAlreadyExistsException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)new Object[]{destinationDefinition.getName(), destinationDefinition.getUUID().toString(), destinationDefinition, localizationDefinition, mediationLocalizationDefinition, set, set2, destinationDefinition.getMediationDefinition(), new Boolean(bl), externalLocalTransaction});
        }
        boolean bl2 = false;
        BaseDestinationHandler baseDestinationHandler = null;
        SIBUuid8 sIBUuid8 = this.messageProcessor.getMessagingEngineUuid();
        this.checkQueuePointContainsLocalME(set, sIBUuid8, destinationDefinition, localizationDefinition);
        this.checkQueuePointLocalizationExists(destinationDefinition, set, localizationDefinition, sIBUuid8);
        this.checkMediationLocalizationExists(mediationLocalizationDefinition, set2, sIBUuid8, destinationDefinition);
        this.checkQueuePointLocalizingSize(set, destinationDefinition);
        this.checkMediationPointsDefinition(set2, destinationDefinition);
        SIMPItemStream sIMPItemStream = this;
        synchronized (sIMPItemStream) {
            Object object2;
            object = new DestinationTypeFilter();
            DestinationHandler destinationHandler = this.destinationIndex.findByUuid(destinationDefinition.getUUID(), (IndexFilter)object);
            if (destinationHandler == null) {
                ((DestinationTypeFilter)object).VISIBLE = Boolean.TRUE;
                destinationHandler = this.destinationIndex.findByName(destinationDefinition.getName(), this.messageProcessor.getMessagingEngineBus(), (IndexFilter)object);
                if (destinationHandler != null && destinationHandler instanceof BaseDestinationHandler && (((AbstractBaseDestinationHandler)(object2 = (BaseDestinationHandler)destinationHandler)).getDestinationType() != destinationDefinition.getDestinationType() || !destinationDefinition.getUUID().equals((Object)((AbstractDestinationHandler)object2).getUuid()))) {
                    ((BaseDestinationHandler)object2).setToBeDeleted(true);
                    try {
                        ((AbstractItem)object2).requestUpdate(externalLocalTransaction);
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createDestinationLocalization", (String)"1:3222:1.428.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)"SIResourceException");
                        }
                        throw new SIResourceException((Throwable)((Object)messageStoreException));
                    }
                    this.destinationIndex.delete((DestinationHandler)object2);
                    destinationHandler = null;
                }
            }
            if (destinationHandler == null) {
                baseDestinationHandler = new BaseDestinationHandler(destinationDefinition, this.messageProcessor, this, externalLocalTransaction, this.durableSubscriptions, this.messageProcessor.getMessagingEngineBus());
                bl2 = true;
                object2 = new DestinationIndex.Type();
                ((DestinationIndex.Type)object2).alias = new Boolean(baseDestinationHandler.isAlias());
                ((DestinationIndex.Type)object2).foreignDestination = new Boolean(baseDestinationHandler.isForeign());
                ((DestinationIndex.Type)object2).local = new Boolean(baseDestinationHandler.hasLocal());
                ((DestinationIndex.Type)object2).queue = new Boolean(!baseDestinationHandler.isPubSub());
                ((DestinationIndex.Type)object2).remote = new Boolean(baseDestinationHandler.hasRemote());
                ((DestinationIndex.Type)object2).state = State.CREATE_IN_PROGRESS;
                this.destinationIndex.put(baseDestinationHandler, (AbstractDestinationIndex.AbstractDestinationType)object2);
            } else if (destinationHandler instanceof BaseDestinationHandler) {
                baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
            } else {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                }
                throw new SIMPDestinationAlreadyExistsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
            }
        }
        sIMPItemStream = baseDestinationHandler;
        synchronized (sIMPItemStream) {
            if (!bl2) {
                if (baseDestinationHandler.isReconciled() && (baseDestinationHandler.hasLocal() && baseDestinationHandler.isMediatedLocally() || baseDestinationHandler.hasLocal() && mediationLocalizationDefinition == null || baseDestinationHandler.isMediatedLocally() && localizationDefinition == null)) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization", (Object)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                    }
                    throw new SIMPDestinationAlreadyExistsException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_31", new Object[]{destinationDefinition.getName()}, null));
                }
                if (!baseDestinationHandler.isCorrupt()) {
                    baseDestinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                    if (this.isQueue(baseDestinationHandler.getDestinationType())) {
                        if (localizationDefinition != null) {
                            baseDestinationHandler.updateLocalisationDefinition(localizationDefinition, externalLocalTransaction);
                        }
                    } else if (baseDestinationHandler.getDestinationType() == DestinationType.TOPICSPACE) {
                        baseDestinationHandler.updateLocalisationDefinition(localizationDefinition, externalLocalTransaction);
                    }
                    if (null != mediationLocalizationDefinition) {
                        baseDestinationHandler.updateMediationPointLocalization(externalLocalTransaction, mediationLocalizationDefinition);
                    }
                    baseDestinationHandler.updateLocalisationSet(set, set2);
                    object = new DestinationIndex.Type();
                    ((DestinationIndex.Type)object).alias = new Boolean(baseDestinationHandler.isAlias());
                    ((DestinationIndex.Type)object).foreignDestination = new Boolean(baseDestinationHandler.isForeign());
                    ((DestinationIndex.Type)object).local = new Boolean(baseDestinationHandler.hasLocal());
                    ((DestinationIndex.Type)object).queue = new Boolean(!baseDestinationHandler.isPubSub());
                    ((DestinationIndex.Type)object).remote = new Boolean(baseDestinationHandler.hasRemote());
                    ((DestinationIndex.Type)object).state = this.destinationIndex.getState(baseDestinationHandler);
                    this.destinationIndex.setType(baseDestinationHandler, (Index.Type)object);
                    this.destinationIndex.create(baseDestinationHandler);
                    baseDestinationHandler.setReconciled();
                    if (baseDestinationHandler.getHasReconciledStreamsToBeDeleted()) {
                        this.destinationIndex.cleanup(baseDestinationHandler);
                    }
                }
            } else {
                if (localizationDefinition != null && this.isQueue(baseDestinationHandler.getDestinationType())) {
                    baseDestinationHandler.addNewPtoPLocalisation(false, externalLocalTransaction, sIBUuid8, localizationDefinition, true);
                } else if (baseDestinationHandler.getDestinationType() == DestinationType.TOPICSPACE) {
                    baseDestinationHandler.addPubSubLocalisation(localizationDefinition);
                }
                if (mediationLocalizationDefinition != null) {
                    baseDestinationHandler.addNewMediationLocalisation(externalLocalTransaction, mediationLocalizationDefinition);
                }
                baseDestinationHandler.updateLocalisationSet(set, set2);
                object = (DestinationIndex.Type)this.destinationIndex.getType(baseDestinationHandler);
                ((DestinationIndex.Type)object).local = new Boolean(baseDestinationHandler.hasLocal());
                ((DestinationIndex.Type)object).remote = new Boolean(baseDestinationHandler.hasRemote());
                this.destinationIndex.setType(baseDestinationHandler, (Index.Type)object);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    private void checkMediationLocalizationExists(MediationLocalizationDefinition mediationLocalizationDefinition, Set set, SIBUuid8 sIBUuid8, DestinationDefinition destinationDefinition) {
        if (!(mediationLocalizationDefinition == null || set != null && set.contains(sIBUuid8.toString()) && destinationDefinition.getMediationDefinition() != null)) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3468:1.428.1.1", destinationDefinition.getName()}, null));
        }
    }

    private boolean isQueue(DestinationType destinationType) {
        boolean bl = false;
        if (destinationType == DestinationType.QUEUE || destinationType == DestinationType.PORT) {
            bl = true;
        }
        return bl;
    }

    public void alterDestinationLocalization(LocalizationDefinition localizationDefinition, MediationLocalizationDefinition mediationLocalizationDefinition, DestinationDefinition destinationDefinition, Set set, Set set2) throws SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)new Object[]{destinationDefinition.getName(), destinationDefinition.getUUID().toString(), localizationDefinition, mediationLocalizationDefinition, destinationDefinition, set, set2});
        }
        ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
        try {
            this.alterDestinationLocalization(localizationDefinition, mediationLocalizationDefinition, destinationDefinition, set, set2, externalLocalTransaction);
            externalLocalTransaction.commit();
        }
        catch (SIResourceException sIResourceException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)((Object)sIResourceException));
            }
            this.handleRollback(externalLocalTransaction);
            throw sIResourceException;
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)((Object)sITemporaryDestinationNotFoundException));
            }
            this.handleRollback(externalLocalTransaction);
            throw new SIErrorException((Throwable)sITemporaryDestinationNotFoundException);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.alterDestinationLocalization", (String)"1:3564:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)runtimeException);
            }
            this.handleRollback(externalLocalTransaction);
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alterDestinationLocalization(LocalizationDefinition localizationDefinition, MediationLocalizationDefinition mediationLocalizationDefinition, DestinationDefinition destinationDefinition, Set set, Set set2, ExternalLocalTransaction externalLocalTransaction) throws SIResourceException, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)new Object[]{destinationDefinition.getName(), destinationDefinition.getUUID().toString(), localizationDefinition, mediationLocalizationDefinition, destinationDefinition, set, set2, externalLocalTransaction});
        }
        BaseDestinationHandler baseDestinationHandler = null;
        SIBUuid8 sIBUuid8 = this.messageProcessor.getMessagingEngineUuid();
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.VISIBLE = Boolean.TRUE;
        destinationTypeFilter.ALIAS = Boolean.FALSE;
        destinationTypeFilter.FOREIGN_DESTINATION = Boolean.FALSE;
        DestinationHandler destinationHandler = this.destinationIndex.findByUuid(destinationDefinition.getUUID(), destinationTypeFilter);
        this.checkDestinationHandlerExists(destinationHandler != null, destinationDefinition.getName(), this.messageProcessor.getMessagingEngineName(), null);
        baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
        if (!baseDestinationHandler.isPubSub() && (!baseDestinationHandler.hasLocal() && null == baseDestinationHandler.getMediatedInputItemStream() || destinationHandler.isTemporary() || destinationHandler.isSystem())) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)"Destination not found");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{destinationDefinition.getName(), this.messageProcessor.getMessagingEngineName()}, null));
        }
        this.checkQueuePointContainsLocalME(set, sIBUuid8, destinationDefinition, localizationDefinition);
        this.checkQueuePointLocalizationExists(destinationDefinition, set, localizationDefinition, sIBUuid8);
        this.checkQueuePointLocalizingSize(set, destinationDefinition);
        this.checkMediationLocalizationExists(mediationLocalizationDefinition, set2, sIBUuid8, destinationDefinition);
        this.checkMediationLocalitySetNotEmpty(destinationDefinition, set2);
        this.checkMediationPointsDefinition(set2, destinationDefinition);
        BaseDestinationHandler baseDestinationHandler2 = baseDestinationHandler;
        synchronized (baseDestinationHandler2) {
            this.checkDestinationHandlerExists(!baseDestinationHandler.isToBeDeleted(), destinationDefinition.getName(), this.messageProcessor.getMessagingEngineName(), null);
            if (baseDestinationHandler.getDestinationType() != destinationDefinition.getDestinationType()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3701:1.428.1.1", baseDestinationHandler.getName()}, null));
            }
            if (!baseDestinationHandler.isCorrupt()) {
                if (this.isQueue(baseDestinationHandler.getDestinationType())) {
                    if (localizationDefinition != null) {
                        baseDestinationHandler.updateLocalisationDefinition(localizationDefinition, externalLocalTransaction);
                    }
                } else if (baseDestinationHandler.getDestinationType() == DestinationType.TOPICSPACE) {
                    baseDestinationHandler.updateLocalisationDefinition(localizationDefinition, externalLocalTransaction);
                }
                if (null != mediationLocalizationDefinition) {
                    baseDestinationHandler.updateMediationPointLocalization(externalLocalTransaction, mediationLocalizationDefinition);
                }
                baseDestinationHandler.updateDefinition((BaseDestinationDefinition)destinationDefinition);
                baseDestinationHandler.updateLocalisationSet(set, set2);
                DestinationIndex.Type type = (DestinationIndex.Type)this.destinationIndex.getType(baseDestinationHandler);
                type.local = new Boolean(baseDestinationHandler.hasLocal());
                type.remote = new Boolean(baseDestinationHandler.hasRemote());
                this.destinationIndex.setType(baseDestinationHandler, (Index.Type)type);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization");
        }
    }

    private void checkQueuePointLocalizationExists(DestinationDefinition destinationDefinition, Set set, LocalizationDefinition localizationDefinition, SIBUuid8 sIBUuid8) {
        if (this.isQueue(destinationDefinition.getDestinationType()) && set != null && set.contains(sIBUuid8.toString()) && localizationDefinition == null) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3772:1.428.1.1", destinationDefinition.getName()}, null));
        }
    }

    private void checkDestinationHandlerExists(boolean bl, String string, String string2, Throwable throwable) throws SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationHandlerExists", (Object)new Object[]{new Boolean(bl), string, string2, throwable});
        }
        if (!bl) {
            if (string.startsWith("_Q") || string.startsWith("_T")) {
                SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException = new SITemporaryDestinationNotFoundException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{string, string2}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkDestinationHandlerExists", (Object)((Object)sITemporaryDestinationNotFoundException));
                }
                throw new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{string}, null));
            }
            SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException = new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{string, string2}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sINotPossibleInCurrentConfigurationException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationHandlerExists", (Object)((Object)sINotPossibleInCurrentConfigurationException));
            }
            throw sINotPossibleInCurrentConfigurationException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationHandlerExists");
        }
    }

    private void checkMediationLocalitySetNotEmpty(DestinationDefinition destinationDefinition, Set set) {
        if (destinationDefinition.getMediationDefinition() != null && (set == null || set.size() == 0)) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3856:1.428.1.1", destinationDefinition.getName()}, null));
        }
    }

    private void checkQueuePointContainsLocalME(Set set, SIBUuid8 sIBUuid8, DestinationDefinition destinationDefinition, LocalizationDefinition localizationDefinition) {
        if (this.isQueue(destinationDefinition.getDestinationType()) && localizationDefinition != null && (set == null || !set.contains(sIBUuid8.toString()))) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3881:1.428.1.1", destinationDefinition.getName()}, null));
        }
    }

    private void checkQueuePointLocalizingSize(Set set, DestinationDefinition destinationDefinition) {
        if (destinationDefinition.getDestinationType() != DestinationType.SERVICE && set.size() == 0 || destinationDefinition.getDestinationType() == DestinationType.SERVICE && set.size() != 0) {
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_CONFIGURATION_ERROR_CWSIP0006", new Object[]{"DestinationManager", "1:3903:1.428.1.1", destinationDefinition.getName()}, null));
        }
    }

    public void createDestination(DestinationDefinition destinationDefinition, Set set, Set set2) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestination", (Object)new Object[]{destinationDefinition, set, set2});
        }
        try {
            this.createRemoteDestination(destinationDefinition, set, set2);
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createDestination", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createDestination", (String)"1:3946:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                SibTr.exit((TraceComponent)tc, (String)"createDestination", (Object)runtimeException);
            }
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationHandler createRemoteDestination(DestinationDefinition destinationDefinition, Set set, Set set2) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteDestination", (Object)new Object[]{destinationDefinition, set, set2});
        }
        BaseDestinationHandler baseDestinationHandler = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
            destinationTypeFilter.VISIBLE = Boolean.TRUE;
            DestinationHandler destinationHandler = this.destinationIndex.findByName(destinationDefinition.getName(), this.messageProcessor.getMessagingEngineBus(), destinationTypeFilter);
            if (destinationHandler != null) {
                baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
            } else {
                ExternalLocalTransaction externalLocalTransaction = null;
                externalLocalTransaction = this.txManager.createLocalTransaction();
                baseDestinationHandler = new BaseDestinationHandler(destinationDefinition, this.messageProcessor, this, externalLocalTransaction, this.durableSubscriptions, this.messageProcessor.getMessagingEngineBus());
                baseDestinationHandler.updateLocalisationSet(set, set2);
                DestinationIndex.Type type = new DestinationIndex.Type();
                type.alias = new Boolean(baseDestinationHandler.isAlias());
                type.foreignDestination = new Boolean(baseDestinationHandler.isForeign());
                type.local = new Boolean(baseDestinationHandler.hasLocal());
                type.queue = new Boolean(!baseDestinationHandler.isPubSub());
                type.remote = new Boolean(baseDestinationHandler.hasRemote());
                type.state = State.CREATE_IN_PROGRESS;
                this.destinationIndex.put(baseDestinationHandler, type);
                externalLocalTransaction.commit();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteDestination", (Object)baseDestinationHandler);
        }
        return baseDestinationHandler;
    }

    public void markDestinationAsCleanUpPending(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markDestinationAsCleanUpPending", (Object)destinationHandler);
        }
        if (destinationHandler.isLink()) {
            this.linkIndex.cleanup(destinationHandler);
        } else {
            this.destinationIndex.cleanup(destinationHandler);
        }
        this.startAsynchDeletion();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markDestinationAsCleanUpPending");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsynchDeletion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startAsynchDeletion");
        }
        Object object = this.deletionThreadLock;
        synchronized (object) {
            if (this.asynchDeletionThread == null) {
                this.asynchDeletionThread = new AsynchDeletionThread(this.messageProcessor);
            }
            if (this._isAsyncDeletionThreadStartable && !this.asynchDeletionThread.isRunning() && !this.asynchDeletionThread.isStopping()) {
                try {
                    this.messageProcessor.startNewSystemThread(this.asynchDeletionThread);
                    this.asynchDeletionThread.setRunning(true);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.startAsynchDeletion", (String)"1:4110:1.428.1.1", (Object)this);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"startAsynchDeletion", (Object)interruptedException);
                    }
                    SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
                    throw new WsRuntimeException((Throwable)interruptedException);
                }
            } else {
                this.asynchDeletionThread.rerun();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"startAsynchDeletion");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.setIsAsyncDeletionThreadStartable(false);
        Object object2 = this.deletionThreadLock;
        synchronized (object2) {
            if (this.asynchDeletionThread != null) {
                this.asynchDeletionThread.stopThread(this.messageProcessor.getStoppableThreadCache());
            }
        }
        this.asynchDeletionThread = null;
        object2 = new DestinationTypeFilter();
        ((DestinationTypeFilter)object2).LOCAL = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator((IndexFilter)object2);
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.stop(n);
        }
        sIMPIterator.finished();
        sIMPIterator = this.foreignBusIndex.iterator();
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.stop(n);
        }
        sIMPIterator.finished();
        object = new LinkTypeFilter();
        ((LinkTypeFilter)object).LOCAL = Boolean.TRUE;
        sIMPIterator = this.linkIndex.iterator((IndexFilter)object);
        while (sIMPIterator.hasNext()) {
            DestinationHandler destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.stop(n);
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void start() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.LOCAL = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.start();
        }
        sIMPIterator.finished();
        sIMPIterator = this.foreignBusIndex.iterator();
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.start();
        }
        sIMPIterator.finished();
        object = new LinkTypeFilter();
        ((LinkTypeFilter)object).LOCAL = Boolean.TRUE;
        sIMPIterator = this.linkIndex.iterator((IndexFilter)object);
        while (sIMPIterator.hasNext()) {
            DestinationHandler destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.start();
        }
        sIMPIterator.finished();
        this.startAsynchDeletion();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIsAsyncDeletionThreadStartable(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsAsyncDeletionThreadStartable", (Object)new Boolean(bl));
        }
        Object object = this.deletionThreadLock;
        synchronized (object) {
            this._isAsyncDeletionThreadStartable = bl;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsAsyncDeletionThreadStartable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAsynchDeletionEnd(AsynchDeletionThread asynchDeletionThread) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyAsynchDeletionEnd", (Object)asynchDeletionThread);
        }
        Object object = this.deletionThreadLock;
        synchronized (object) {
            asynchDeletionThread.setRunning(false);
            this.deletionThreadLock.notifyAll();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyAsynchDeletionEnd");
        }
    }

    public JsDestinationAddress createSystemDestination(String string) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        return this.createSystemDestination(string, Reliability.ASSURED_PERSISTENT);
    }

    public JsDestinationAddress createSystemDestination(String string, Reliability reliability) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemDestination", (Object)new Object[]{string, reliability});
        }
        if (string == null || string.length() > 24) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemDestination", (Object)"SIInvalidDestinationPrefixException");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:4314:1.428.1.1", string});
            throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:4319:1.428.1.1", string}, null));
        }
        JsDestinationAddress jsDestinationAddress = SIMPUtils.createJsSystemDestinationAddress(string, this.messageProcessor.getMessagingEngineUuid());
        jsDestinationAddress.setBusName(this.messageProcessor.getMessagingEngineBus());
        DestinationHandler destinationHandler = this.getDestinationInternal(jsDestinationAddress.getDestinationName(), jsDestinationAddress.getBusName(), false);
        if (destinationHandler != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemDestination", (Object)jsDestinationAddress);
            }
            return jsDestinationAddress;
        }
        DestinationDefinition destinationDefinition = this.messageProcessor.createDestinationDefinition(DestinationType.QUEUE, jsDestinationAddress.getDestinationName());
        destinationDefinition.setMaxReliability(reliability);
        destinationDefinition.setDefaultReliability(reliability);
        destinationDefinition.setUUID(new SIBUuid12());
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
        this.createDestinationLocalization(this.messageProcessor.createLocalizationDefinition(destinationDefinition.getName()), null, destinationDefinition, hashSet, null, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemDestination", (Object)jsDestinationAddress);
        }
        return jsDestinationAddress;
    }

    public void deleteSystemDestination(JsDestinationAddress jsDestinationAddress) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)new Object[]{jsDestinationAddress});
        }
        BaseDestinationHandler baseDestinationHandler = null;
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.VISIBLE = Boolean.TRUE;
        destinationTypeFilter.ALIAS = Boolean.FALSE;
        destinationTypeFilter.FOREIGN_DESTINATION = Boolean.FALSE;
        DestinationHandler destinationHandler = this.destinationIndex.findByName(jsDestinationAddress.getDestinationName(), this.messageProcessor.getMessagingEngineBus(), destinationTypeFilter);
        try {
            this.checkDestinationHandlerExists(destinationHandler != null, jsDestinationAddress.getDestinationName(), this.messageProcessor.getMessagingEngineName(), null);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteSystemDestination", (String)"1:4396:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:4409:1.428.1.1", sITemporaryDestinationNotFoundException, jsDestinationAddress.getDestinationName()}, null), (Throwable)sITemporaryDestinationNotFoundException);
        }
        baseDestinationHandler = (BaseDestinationHandler)destinationHandler;
        this.deleteSystemDestination(baseDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSystemDestination(BaseDestinationHandler baseDestinationHandler) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)new Object[]{baseDestinationHandler});
        }
        BaseDestinationHandler baseDestinationHandler2 = baseDestinationHandler;
        synchronized (baseDestinationHandler2) {
            if (baseDestinationHandler.isToBeDeleted() || !baseDestinationHandler.isSystem()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"Destination not found as destination is to be deleted, or is system");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{baseDestinationHandler.getName(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            ExternalAutoCommitTransaction externalAutoCommitTransaction = this.txManager.createAutoCommitTransaction();
            baseDestinationHandler.setToBeDeleted(true);
            this.destinationIndex.delete(baseDestinationHandler);
            try {
                baseDestinationHandler.requestUpdate(externalAutoCommitTransaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteSystemDestination", (String)"1:4464:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
            baseDestinationHandler.closeProducers();
            baseDestinationHandler.closeConsumers();
            baseDestinationHandler.addAllLocalisationsForCleanUp();
            baseDestinationHandler.clearLocalisingUuidsSet();
            this.startAsynchDeletion();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    protected synchronized AsyncUpdateThread getAsyncUpdateThread() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAsyncUpdateThread");
        }
        if (this.asyncUpdateThread == null) {
            this.asyncUpdateThread = new AsyncUpdateThread(this.messageProcessor, this.messageProcessor.getTXManager(), 100, 200L);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAsyncUpdateThread", (Object)this.asyncUpdateThread);
        }
        return this.asyncUpdateThread;
    }

    protected synchronized AsyncUpdateThread getPersistLockThread() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistLockThread");
        }
        if (this.persistLockThread == null) {
            this.persistLockThread = new AsyncUpdateThread(this.messageProcessor, this.messageProcessor.getTXManager(), SIMPConstants.ANYCAST_LOCK_BATCH_SIZE, SIMPConstants.ANYCAST_LOCK_BATCH_TIMEOUT);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistLockThread", (Object)this.persistLockThread);
        }
        return this.persistLockThread;
    }

    public synchronized AsynchDeletionThread getAsynchDeletionThread() {
        return this.asynchDeletionThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriptionToDelete(SubscriptionItemStream subscriptionItemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscriptionToDelete", (Object)subscriptionItemStream);
        }
        List list = this.deletableSubscriptions;
        synchronized (list) {
            this.deletableSubscriptions.add(subscriptionItemStream);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscriptionToDelete");
        }
    }

    public List getSubscriptionsToDelete() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionsToDelete");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionsToDelete", (Object)this.deletableSubscriptions);
        }
        return this.deletableSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriptionAsDeleted(SubscriptionItemStream subscriptionItemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeSubscriptionAsDeleted", (Object)subscriptionItemStream);
        }
        List list = this.deletableSubscriptions;
        synchronized (list) {
            this.deletableSubscriptions.remove(subscriptionItemStream);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeSubscriptionAsDeleted");
        }
    }

    public void addRemoteDestination(String string, Set set, Set set2, DestinationDefinition destinationDefinition) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRemoteDestination", (Object)new Object[]{string, destinationDefinition});
        }
        try {
            this.createRemoteDestination(destinationDefinition, set, set2);
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addRemoteDestination", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        catch (SIResourceException sIResourceException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addRemoteDestination", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRemoteDestination");
        }
    }

    private DestinationHandler createRemoteSystemDestination(String string, SIBUuid8 sIBUuid8) throws SIResourceException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteSystemDestination", (Object)new Object[]{string, sIBUuid8});
        }
        DestinationHandler destinationHandler = null;
        DestinationDefinition destinationDefinition = this.messageProcessor.createDestinationDefinition(DestinationType.QUEUE, string);
        destinationDefinition.setDefaultReliability(Reliability.ASSURED_PERSISTENT);
        destinationDefinition.setMaxReliability(Reliability.ASSURED_PERSISTENT);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(sIBUuid8.toString());
        HashSet hashSet2 = new HashSet();
        try {
            destinationHandler = this.createRemoteDestination(destinationDefinition, hashSet, hashSet2);
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createRemoteSystemDestination", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteSystemDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public DestinationHandler getDestination(SIBUuid12 sIBUuid12, boolean bl) throws SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination", (Object)sIBUuid12);
        }
        this.checkDestinationHandlerExists((destinationHandler = this.getDestinationInternal(sIBUuid12, bl)) != null, sIBUuid12.toString(), this.messageProcessor.getMessagingEngineName(), null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public MQLinkHandler getMQLinkLocalization(SIBUuid8 sIBUuid8, boolean bl) throws SIMPMQLinkCorruptException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)sIBUuid8);
        }
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        linkTypeFilter.MQLINK = Boolean.TRUE;
        if (!bl) {
            linkTypeFilter.VISIBLE = Boolean.TRUE;
        }
        MQLinkHandler mQLinkHandler = (MQLinkHandler)this.linkIndex.findByMQLinkUuid(sIBUuid8, linkTypeFilter);
        try {
            this.checkDestinationHandlerExists(mQLinkHandler != null, sIBUuid8.toString(), this.messageProcessor.getMessagingEngineName(), null);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.getMQLinkLocalization", (String)"1:4730:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:4739:1.428.1.1", sITemporaryDestinationNotFoundException, sIBUuid8}, null), (Throwable)sITemporaryDestinationNotFoundException);
        }
        if (mQLinkHandler.isCorrupt()) {
            String string = nls.getFormattedMessage("LINK_HANDLER_CORRUPT_ERROR_CWSIP0054", new Object[]{mQLinkHandler.getName(), sIBUuid8.toString()}, null);
            SIMPMQLinkCorruptException sIMPMQLinkCorruptException = new SIMPMQLinkCorruptException(string);
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPMQLinkCorruptException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)((Object)sIMPMQLinkCorruptException));
            }
            throw sIMPMQLinkCorruptException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkLocalization", (Object)mQLinkHandler);
        }
        return mQLinkHandler;
    }

    void announceWASOpenForEBusiness() {
        DestinationHandler destinationHandler;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceWASOpenForEBusiness");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.announceWasOpenForEBusiness();
        }
        sIMPIterator.finished();
        object = new LinkTypeFilter();
        ((LinkTypeFilter)object).LOCAL = Boolean.TRUE;
        sIMPIterator = this.linkIndex.iterator((IndexFilter)object);
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceWasOpenForEBusiness();
        }
        sIMPIterator.finished();
        sIMPIterator = this.foreignBusIndex.iterator();
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceWasOpenForEBusiness();
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceWASOpenForEBusiness");
        }
    }

    void announceWASClosedForEBusiness() {
        DestinationHandler destinationHandler;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceWASClosedForEBusiness");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.announceWasClosedForEBusiness();
        }
        sIMPIterator.finished();
        object = new LinkTypeFilter();
        ((LinkTypeFilter)object).LOCAL = Boolean.TRUE;
        sIMPIterator = this.linkIndex.iterator((IndexFilter)object);
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceWasClosedForEBusiness();
        }
        sIMPIterator.finished();
        sIMPIterator = this.foreignBusIndex.iterator();
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceWasClosedForEBusiness();
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceWASClosedForEBusiness");
        }
    }

    void announceMPStopping() {
        DestinationHandler destinationHandler;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStopping");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.announceMPStopping();
        }
        sIMPIterator.finished();
        object = new LinkTypeFilter();
        ((LinkTypeFilter)object).LOCAL = Boolean.TRUE;
        sIMPIterator = this.linkIndex.iterator((IndexFilter)object);
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceMPStopping();
        }
        sIMPIterator.finished();
        sIMPIterator = this.foreignBusIndex.iterator();
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceMPStopping();
        }
        sIMPIterator.finished();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStopping");
        }
    }

    void announceMPStarted() {
        DestinationHandler destinationHandler;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"announceMPStarted");
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            object = (DestinationHandler)sIMPIterator.next();
            object.announceMPStarted();
        }
        sIMPIterator.finished();
        object = new LinkTypeFilter();
        ((LinkTypeFilter)object).LOCAL = Boolean.TRUE;
        sIMPIterator = this.linkIndex.iterator((IndexFilter)object);
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceMPStarted();
        }
        sIMPIterator.finished();
        sIMPIterator = this.foreignBusIndex.iterator();
        while (sIMPIterator.hasNext()) {
            destinationHandler = (DestinationHandler)sIMPIterator.next();
            destinationHandler.announceMPStarted();
        }
        sIMPIterator.finished();
        this.setIsAsyncDeletionThreadStartable(true);
        this.startAsynchDeletion();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"announceMPStarted");
        }
    }

    public void createLinkLocalization(VirtualLinkDefinition virtualLinkDefinition) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLinkLocalization", (Object)new Object[]{virtualLinkDefinition});
        }
        ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
        try {
            this.createLinkLocalization(virtualLinkDefinition, externalLocalTransaction);
            externalLocalTransaction.commit();
        }
        catch (SIIncorrectCallException sIIncorrectCallException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)((Object)sIIncorrectCallException));
            }
            this.handleRollback(externalLocalTransaction);
            throw sIIncorrectCallException;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createLinkLocalization", (String)"1:4979:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)runtimeException);
            }
            this.handleRollback(externalLocalTransaction);
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkLocalization(VirtualLinkDefinition virtualLinkDefinition, ExternalLocalTransaction externalLocalTransaction) throws SIMPDestinationAlreadyExistsException, SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLinkLocalization", (Object)new Object[]{virtualLinkDefinition, externalLocalTransaction});
        }
        boolean bl = false;
        LinkHandler linkHandler = null;
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        DestinationHandler destinationHandler = this.linkIndex.findByName(virtualLinkDefinition.getName(), linkTypeFilter);
        if (destinationHandler == null) {
            linkHandler = new LinkHandler(virtualLinkDefinition, this.messageProcessor, this, externalLocalTransaction, this.durableSubscriptions);
            bl = true;
            linkHandler.setLocal();
            object = new LinkIndex.Type();
            ((LinkIndex.Type)object).local = Boolean.TRUE;
            ((LinkIndex.Type)object).mqLink = Boolean.FALSE;
            ((LinkIndex.Type)object).remote = Boolean.FALSE;
            ((LinkIndex.Type)object).state = State.CREATE_IN_PROGRESS;
            this.linkIndex.put(linkHandler, (AbstractDestinationIndex.AbstractDestinationType)object);
            linkHandler.registerControlAdapters();
        } else {
            linkHandler = (LinkHandler)destinationHandler;
        }
        if (!linkHandler.isCorrupt()) {
            object = linkHandler;
            synchronized (object) {
                if (!bl) {
                    if (linkHandler.isToBeDeleted()) {
                        this.recreateLinkHandler(linkHandler, virtualLinkDefinition, externalLocalTransaction);
                    } else {
                        if (linkHandler.isReconciled()) {
                            if (tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)"Link already exists.");
                            }
                            throw new SIMPDestinationAlreadyExistsException(nls.getFormattedMessage("LINK_ALREADY_EXISTS_ERROR_CWSIP0043", new Object[]{virtualLinkDefinition.getName(), this.messageProcessor.getMessagingEngineName()}, null));
                        }
                        if (!virtualLinkDefinition.getUuid().equals((Object)linkHandler.getUuid())) {
                            this.recreateLinkHandler(linkHandler, virtualLinkDefinition, externalLocalTransaction);
                        } else {
                            linkHandler.updateLinkDefinition(virtualLinkDefinition, externalLocalTransaction);
                            LinkIndex.Type type = new LinkIndex.Type();
                            type.local = Boolean.TRUE;
                            type.remote = Boolean.FALSE;
                            type.mqLink = Boolean.FALSE;
                            type.state = State.ACTIVE;
                            this.linkIndex.setType(linkHandler, (Index.Type)type);
                        }
                    }
                } else {
                    LinkSelection linkSelection = null;
                    LinkManager linkManager = this.messageProcessor.getLinkManager();
                    try {
                        linkSelection = linkManager.select(linkHandler.getUuid());
                    }
                    catch (LinkException linkException) {
                        FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createLinkLocalization", (String)"1:5133:1.428.1.1", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)linkException);
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization", (Object)linkException);
                        }
                        throw new SIResourceException((Throwable)linkException);
                    }
                    SIBUuid8 sIBUuid8 = null;
                    sIBUuid8 = linkSelection != null ? linkSelection.getInboundMeUuid() : new SIBUuid8("0000000000000001");
                    linkHandler.addNewPtoPLocalisation(true, externalLocalTransaction, sIBUuid8, null, true);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLinkLocalization");
        }
    }

    private void recreateLinkHandler(LinkHandler linkHandler, VirtualLinkDefinition virtualLinkDefinition, ExternalLocalTransaction externalLocalTransaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recreateLinkHandler", (Object)new Object[]{linkHandler, virtualLinkDefinition, externalLocalTransaction});
        }
        LinkIndex.Type type = (LinkIndex.Type)this.linkIndex.getType(linkHandler);
        this.linkIndex.remove(linkHandler);
        linkHandler.updateUuid(virtualLinkDefinition.getUuid());
        linkHandler.setToBeDeleted(false);
        type.local = Boolean.TRUE;
        type.remote = Boolean.FALSE;
        type.state = State.ACTIVE;
        this.linkIndex.put(linkHandler, type);
        this.linkIndex.cleanup(linkHandler);
        try {
            linkHandler.requestUpdate(externalLocalTransaction);
            linkHandler.registerControlAdapters();
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.recreateLinkHandler", (String)"1:5213:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"recreateLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recreateLinkHandler", (Object)linkHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkHandler createRemoteLink(VirtualLinkDefinition virtualLinkDefinition, ExternalLocalTransaction externalLocalTransaction) throws SIResourceException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteLink", (Object)new Object[]{virtualLinkDefinition, externalLocalTransaction});
        }
        LinkHandler linkHandler = null;
        boolean bl = false;
        Object object3 = this.linkIndex;
        synchronized (object3) {
            object2 = this.linkIndex.findByUuid(virtualLinkDefinition.getUuid(), null);
            if (object2 != null) {
                linkHandler = (LinkHandler)object2;
            } else {
                linkHandler = new LinkHandler(virtualLinkDefinition, this.messageProcessor, this, externalLocalTransaction, this.durableSubscriptions);
                object = new LinkIndex.Type();
                ((LinkIndex.Type)object).local = Boolean.FALSE;
                ((LinkIndex.Type)object).mqLink = Boolean.FALSE;
                ((LinkIndex.Type)object).remote = Boolean.TRUE;
                ((LinkIndex.Type)object).state = State.ACTIVE;
                this.linkIndex.put(linkHandler, (AbstractDestinationIndex.AbstractDestinationType)object);
                bl = true;
            }
        }
        if (bl) {
            object3 = linkHandler;
            synchronized (object3) {
                object2 = null;
                object = this.messageProcessor.getLinkManager();
                try {
                    object2 = object.select(linkHandler.getUuid());
                }
                catch (LinkException linkException) {
                    FFDCFilter.processException((Throwable)linkException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createRemoteLink", (String)"1:5291:1.428.1.1", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)linkException);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createRemoteLink", (Object)linkException);
                    }
                    throw new SIResourceException((Throwable)linkException);
                }
                SIBUuid8 sIBUuid8 = null;
                if (object2 != null) {
                    sIBUuid8 = ((LinkSelection)object2).getInboundMeUuid();
                    if (sIBUuid8 == null) {
                        sIBUuid8 = ((LinkSelection)object2).getOutboundMeUuid();
                    }
                } else {
                    sIBUuid8 = new SIBUuid8("0000000000000001");
                }
                linkHandler.addNewPtoPLocalisation(true, externalLocalTransaction, sIBUuid8, null, true);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteLink", (Object)linkHandler);
        }
        return linkHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusHandler createForeignBus(String string, String string2, ForeignBusDefinition foreignBusDefinition) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createForeignBus", (Object)new Object[]{string, string2, foreignBusDefinition});
        }
        SIBUuid12 sIBUuid12 = new SIBUuid12(string2);
        BusHandler busHandler = null;
        LinkIndex linkIndex = this.linkIndex;
        synchronized (linkIndex) {
            LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
            linkTypeFilter.VISIBLE = Boolean.TRUE;
            DestinationHandler destinationHandler = this.linkIndex.findByUuid(sIBUuid12, linkTypeFilter);
            if (destinationHandler == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createForeignBus", (Object)"Link not found");
                }
                SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_30", new Object[]{string, string2, foreignBusDefinition.getName()}, null));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(30);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{string, string2, foreignBusDefinition.getName()});
                throw sIMPNotPossibleInCurrentConfigurationException;
            }
            busHandler = new BusHandler(foreignBusDefinition, this.messageProcessor, (SIMPItemStream)this, this.durableSubscriptions, (LinkHandler)destinationHandler);
            ForeignBusIndex.Type type = new ForeignBusIndex.Type();
            type.state = State.ACTIVE;
            this.foreignBusIndex.put(busHandler, type);
            busHandler.registerControlAdapters();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createForeignBus", (Object)busHandler);
        }
        return busHandler;
    }

    public BusHandler findBus(String string) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findBus", (Object)new Object[]{string});
        }
        ForeignBusTypeFilter foreignBusTypeFilter = new ForeignBusTypeFilter();
        foreignBusTypeFilter.VISIBLE = Boolean.TRUE;
        BusHandler busHandler = (BusHandler)this.foreignBusIndex.findByName(string, foreignBusTypeFilter);
        if (busHandler == null) {
            busHandler = this.findBusInternal(string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findBus", (Object)busHandler);
        }
        return busHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BusHandler findBusInternal(String string) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findBusInternal", (Object)new Object[]{string});
        }
        BusHandler busHandler = null;
        ForeignBusDefinition foreignBusDefinition = this.messageProcessor.getForeignBus(string);
        try {
            this.checkDestinationHandlerExists(foreignBusDefinition != null, string, this.messageProcessor.getMessagingEngineName(), null);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.findBusInternal", (String)"1:5463:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)"SIErrorException");
            }
            SIMPErrorException sIMPErrorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5472:1.428.1.1", sITemporaryDestinationNotFoundException, string}, null), sITemporaryDestinationNotFoundException);
            sIMPErrorException.setExceptionReason(901);
            sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5478:1.428.1.1", SIMPUtils.getStackTrace(sITemporaryDestinationNotFoundException)});
            throw sIMPErrorException;
        }
        VirtualLinkDefinition virtualLinkDefinition = null;
        LinkIndex linkIndex = this.linkIndex;
        synchronized (linkIndex) {
            try {
                virtualLinkDefinition = foreignBusDefinition.getLinkForNextHop();
            }
            catch (SIBExceptionBusNotFound sIBExceptionBusNotFound) {
                try {
                    this.checkDestinationHandlerExists(false, string, this.messageProcessor.getMessagingEngineName(), sIBExceptionBusNotFound);
                }
                catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                    FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.findBusInternal", (String)"1:5508:1.428.1.1", (Object)this);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)"SIErrorException");
                    }
                    SIMPErrorException sIMPErrorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5517:1.428.1.1", sITemporaryDestinationNotFoundException, string}, null), sITemporaryDestinationNotFoundException);
                    sIMPErrorException.setExceptionReason(901);
                    sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5523:1.428.1.1", SIMPUtils.getStackTrace(sITemporaryDestinationNotFoundException)});
                    throw sIMPErrorException;
                }
            }
            catch (SIBExceptionNoLinkExists sIBExceptionNoLinkExists) {
                try {
                    this.checkDestinationHandlerExists(false, string, this.messageProcessor.getMessagingEngineName(), sIBExceptionNoLinkExists);
                }
                catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                    FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.findBusInternal", (String)"1:5543:1.428.1.1", (Object)this);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)"SIErrorException");
                    }
                    SIMPErrorException sIMPErrorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5552:1.428.1.1", sITemporaryDestinationNotFoundException, string}, null), sITemporaryDestinationNotFoundException);
                    sIMPErrorException.setExceptionReason(901);
                    sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5558:1.428.1.1", SIMPUtils.getStackTrace(sITemporaryDestinationNotFoundException)});
                    throw sIMPErrorException;
                }
            }
            Set set = virtualLinkDefinition.getLinkLocalitySet();
            if (set == null || set.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Empty/null localizing ME set");
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)"null");
                }
                return null;
            }
            LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
            linkTypeFilter.VISIBLE = Boolean.TRUE;
            LinkHandler linkHandler = (LinkHandler)this.linkIndex.findByName(virtualLinkDefinition.getName(), linkTypeFilter);
            if (linkHandler == null) {
                ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
                try {
                    linkHandler = this.createRemoteLink(virtualLinkDefinition, externalLocalTransaction);
                    externalLocalTransaction.commit();
                }
                catch (SIException sIException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)((Object)sIException));
                    }
                    this.handleRollback(externalLocalTransaction);
                    SIMPResourceException sIMPResourceException = new SIMPResourceException(sIException);
                    sIMPResourceException.setExceptionReason(901);
                    sIMPResourceException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5608:1.428.1.1", SIMPUtils.getStackTrace(sIException)});
                    throw sIMPResourceException;
                }
            }
            try {
                busHandler = this.createForeignBus(linkHandler.getName(), linkHandler.getUuid().toString(), foreignBusDefinition);
            }
            catch (SIException sIException) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findBusInternal", (Object)busHandler);
        }
        return busHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationHandler createAliasDestination(DestinationAliasDefinition destinationAliasDefinition, AliasChainValidator aliasChainValidator) throws SINotPossibleInCurrentConfigurationException, SIMPDestinationCorruptException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createAliasDestination", (Object)new Object[]{destinationAliasDefinition, aliasChainValidator});
        }
        String string = destinationAliasDefinition.getName();
        String string2 = destinationAliasDefinition.getBus();
        if (string2 == null || string2.equals("")) {
            string2 = this.messageProcessor.getMessagingEngineBus();
        }
        if (null == aliasChainValidator) {
            aliasChainValidator = new AliasChainValidator();
        }
        aliasChainValidator.validate(string, string2);
        AliasDestinationHandler aliasDestinationHandler = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            DestinationHandler destinationHandler = null;
            try {
                destinationHandler = this.getDestinationInternal(destinationAliasDefinition.getTargetName(), destinationAliasDefinition.getTargetBus(), aliasChainValidator, false);
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createAliasDestination", (String)"1:5692:1.428.1.1", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)"SIErrorException");
                }
                SIMPErrorException sIMPErrorException = new SIMPErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5701:1.428.1.1", sITemporaryDestinationNotFoundException, string}, null), sITemporaryDestinationNotFoundException);
                sIMPErrorException.setExceptionReason(901);
                sIMPErrorException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.DestinationManager", "1:5707:1.428.1.1", SIMPUtils.getStackTrace(sITemporaryDestinationNotFoundException)});
                throw sIMPErrorException;
            }
            if (destinationHandler == null) {
                String string3 = aliasChainValidator.toStringPlus(destinationAliasDefinition.getTargetName(), string2);
                String string4 = destinationAliasDefinition.getTargetName();
                AliasChainValidator.CompoundName compoundName = aliasChainValidator.getFirstInChain();
                SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_28", new Object[]{compoundName.getDestName(), string4, string3}, null));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(28);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{compoundName.getDestName(), string4, string3});
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPNotPossibleInCurrentConfigurationException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)((Object)sIMPNotPossibleInCurrentConfigurationException));
                }
                throw sIMPNotPossibleInCurrentConfigurationException;
            }
            if (destinationHandler.getDestinationType().equals(DestinationType.SERVICE)) {
                String string5 = aliasChainValidator.toStringPlus(destinationHandler.getName(), destinationHandler.getBus());
                AliasChainValidator.CompoundName compoundName = aliasChainValidator.getFirstInChain();
                String string6 = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_29", new Object[]{compoundName.getDestName(), destinationHandler.getName(), string5, string2}, null);
                SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(string6);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(29);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{compoundName.getDestName(), destinationHandler.getName(), string5, string2});
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPNotPossibleInCurrentConfigurationException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)((Object)sIMPNotPossibleInCurrentConfigurationException));
                }
                throw sIMPNotPossibleInCurrentConfigurationException;
            }
            aliasDestinationHandler = new AliasDestinationHandler(destinationAliasDefinition, this.messageProcessor, this, destinationHandler, string2);
            DestinationIndex.Type type = new DestinationIndex.Type();
            type.alias = Boolean.TRUE;
            type.foreignDestination = Boolean.FALSE;
            type.local = Boolean.FALSE;
            type.remote = Boolean.FALSE;
            type.queue = new Boolean(!aliasDestinationHandler.isPubSub());
            type.state = State.ACTIVE;
            this.destinationIndex.put(aliasDestinationHandler, type);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createAliasDestination", (Object)aliasDestinationHandler);
        }
        return aliasDestinationHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationHandler createForeignDestination(DestinationForeignDefinition destinationForeignDefinition, String string) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createForeignDestination", (Object)new Object[]{destinationForeignDefinition, string});
        }
        ForeignDestinationHandler foreignDestinationHandler = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            foreignDestinationHandler = new ForeignDestinationHandler(destinationForeignDefinition, this.messageProcessor, this, this.findBus(destinationForeignDefinition.getBus()), string);
            DestinationIndex.Type type = new DestinationIndex.Type();
            type.foreignDestination = Boolean.TRUE;
            type.alias = Boolean.FALSE;
            type.local = Boolean.FALSE;
            type.remote = Boolean.FALSE;
            type.queue = new Boolean(!foreignDestinationHandler.isPubSub());
            type.state = State.ACTIVE;
            this.destinationIndex.put(foreignDestinationHandler, type);
            foreignDestinationHandler.registerControlAdapters();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createForeignDestination", (Object)foreignDestinationHandler);
        }
        return foreignDestinationHandler;
    }

    protected boolean isReconciling() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReconciling");
            SibTr.exit((TraceComponent)tc, (String)"isReconciling", (Object)new Boolean(this.reconciling));
        }
        return this.reconciling;
    }

    public void createMQLinkLocalization(String string, LocalizationDefinition localizationDefinition, VirtualLinkDefinition virtualLinkDefinition, Set set) throws SIIncorrectCallException, SIMPDestinationAlreadyExistsException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)new Object[]{string, localizationDefinition, virtualLinkDefinition, set});
        }
        ExternalLocalTransaction externalLocalTransaction = this.txManager.createLocalTransaction();
        try {
            this.createMQLinkLocalization(string, localizationDefinition, virtualLinkDefinition, set, externalLocalTransaction);
            externalLocalTransaction.commit();
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createMQLinkLocalization", (String)"1:5889:1.428.1.1", (Object)this);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)runtimeException);
                SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)runtimeException);
            }
            this.handleRollback(externalLocalTransaction);
            throw runtimeException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMQLinkLocalization(String string, LocalizationDefinition localizationDefinition, VirtualLinkDefinition virtualLinkDefinition, Set hashSet, ExternalLocalTransaction externalLocalTransaction) throws SIMPDestinationAlreadyExistsException, SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)new Object[]{string, localizationDefinition, virtualLinkDefinition, hashSet, externalLocalTransaction});
        }
        boolean bl = false;
        MQLinkHandler mQLinkHandler = null;
        DestinationHandler destinationHandler = this.linkIndex.findByName(virtualLinkDefinition.getName(), null);
        if (destinationHandler == null) {
            try {
                mQLinkHandler = new MQLinkHandler(string, virtualLinkDefinition, this.messageProcessor, this, externalLocalTransaction, this.durableSubscriptions);
            }
            catch (OutOfCacheSpace outOfCacheSpace) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.createMQLinkLocalization", (String)"1:5956:1.428.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)((Object)messageStoreException));
            }
            bl = true;
            mQLinkHandler.setLocal();
            object = new LinkIndex.Type();
            ((LinkIndex.Type)object).local = Boolean.TRUE;
            ((LinkIndex.Type)object).mqLink = Boolean.TRUE;
            ((LinkIndex.Type)object).remote = Boolean.FALSE;
            ((LinkIndex.Type)object).state = State.ACTIVE;
            this.linkIndex.put(mQLinkHandler, (AbstractDestinationIndex.AbstractDestinationType)object);
        } else {
            mQLinkHandler = (MQLinkHandler)destinationHandler;
        }
        if (!mQLinkHandler.isCorrupt()) {
            localizationDefinition.setDestinationHighMsgs(this.messageProcessor.getHighMessageThreshold());
            localizationDefinition.setDestinationLowMsgs(this.messageProcessor.getHighMessageThreshold() * 8L / 10L);
            object = mQLinkHandler;
            synchronized (object) {
                if (!bl) {
                    if (mQLinkHandler.isReconciled()) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization", (Object)"Link already exists");
                        }
                        throw new SIMPDestinationAlreadyExistsException(nls.getFormattedMessage("LINK_ALREADY_EXISTS_ERROR_CWSIP0043", new Object[]{virtualLinkDefinition.getName(), this.messageProcessor.getMessagingEngineName()}, null));
                    }
                    if (!string.equals(mQLinkHandler.getMqLinkUuid().toString())) {
                        this.deleteRecreateMQLinkHandler(string, mQLinkHandler, virtualLinkDefinition, localizationDefinition, externalLocalTransaction);
                    } else {
                        mQLinkHandler.registerLink();
                        if (hashSet == null) {
                            hashSet = new HashSet<String>();
                            hashSet.add(this.messageProcessor.getMessagingEngineUuid().toString());
                        }
                        mQLinkHandler.updateLocalisationSet(hashSet, null);
                        LinkIndex.Type type = (LinkIndex.Type)this.linkIndex.getType(mQLinkHandler);
                        type.local = Boolean.TRUE;
                        type.remote = Boolean.FALSE;
                        this.linkIndex.setType(mQLinkHandler, (Index.Type)type);
                        mQLinkHandler.updateLocalisationDefinition(localizationDefinition, externalLocalTransaction);
                        this.linkIndex.create(mQLinkHandler);
                    }
                } else {
                    mQLinkHandler.addNewMQLinkLocalisation(externalLocalTransaction, this.messageProcessor.getMessagingEngineUuid(), localizationDefinition);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLinkLocalization");
        }
    }

    private void deleteRecreateMQLinkHandler(String string, LinkHandler linkHandler, VirtualLinkDefinition virtualLinkDefinition, LocalizationDefinition localizationDefinition, ExternalLocalTransaction externalLocalTransaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)new Object[]{string, linkHandler, virtualLinkDefinition, localizationDefinition, externalLocalTransaction});
        }
        MQLinkHandler mQLinkHandler = null;
        linkHandler.setToBeDeleted(true);
        this.linkIndex.delete(linkHandler);
        try {
            linkHandler.requestUpdate(externalLocalTransaction);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteRecreateMQLinkHandler", (String)"1:6114:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        try {
            mQLinkHandler = new MQLinkHandler(string, virtualLinkDefinition, this.messageProcessor, this, externalLocalTransaction, this.durableSubscriptions);
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.deleteRecreateMQLinkHandler", (String)"1:6148:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)messageStoreException));
        }
        LinkIndex.Type type = new LinkIndex.Type();
        type.local = Boolean.TRUE;
        type.mqLink = Boolean.TRUE;
        type.remote = Boolean.FALSE;
        type.state = State.ACTIVE;
        this.linkIndex.put(mQLinkHandler, type);
        mQLinkHandler.addNewPtoPLocalisation(false, externalLocalTransaction, this.messageProcessor.getMessagingEngineUuid(), localizationDefinition, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRecreateMQLinkHandler", (Object)mQLinkHandler);
        }
    }

    public DestinationIndex getDestinationIndex() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationIndex");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationIndex");
        }
        return this.destinationIndex;
    }

    public LinkIndex getLinkIndex() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLinkIndex");
            SibTr.exit((TraceComponent)tc, (String)"getLinkIndex");
        }
        return this.linkIndex;
    }

    public ForeignBusIndex getForeignBusIndex() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusIndex");
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusIndex");
        }
        return this.foreignBusIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SIDestinationAddress[] addDestinationListener(DestinationListener destinationListener, DestinationType destinationType, DestinationAvailability destinationAvailability, MPCoreConnection mPCoreConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationListener, destinationType, destinationAvailability, mPCoreConnection});
        }
        SIDestinationAddress[] sIDestinationAddressArray = null;
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            DestinationListenerDataObject destinationListenerDataObject = new DestinationListenerDataObject(destinationListener, destinationType, destinationAvailability, mPCoreConnection);
            this.destinationListeners.add(destinationListenerDataObject);
            if (destinationType != DestinationType.TOPICSPACE) {
                sIDestinationAddressArray = this.getDestinationAddresses(destinationType, destinationAvailability);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{sIDestinationAddressArray});
        }
        return sIDestinationAddressArray;
    }

    private SIDestinationAddress[] getDestinationAddresses(DestinationType destinationType, DestinationAvailability destinationAvailability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationAddresses", (Object)new Object[]{destinationType, destinationAvailability});
        }
        BaseDestinationHandler baseDestinationHandler = null;
        SIDestinationAddress[] sIDestinationAddressArray = null;
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.LOCAL = Boolean.TRUE;
        destinationTypeFilter.FOREIGN_DESTINATION = Boolean.FALSE;
        destinationTypeFilter.ALIAS = Boolean.FALSE;
        destinationTypeFilter.QUEUE = Boolean.TRUE;
        destinationTypeFilter.VISIBLE = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.destinationIndex.iterator(destinationTypeFilter);
        int n = 0;
        Vector<String> vector = new Vector<String>();
        while (sIMPIterator.hasNext()) {
            baseDestinationHandler = (BaseDestinationHandler)sIMPIterator.next();
            if (!this.isAvailable(baseDestinationHandler, destinationAvailability) || baseDestinationHandler.isSystem() || baseDestinationHandler.getDestinationType() != destinationType) continue;
            vector.add(n, baseDestinationHandler.getName());
            ++n;
        }
        sIDestinationAddressArray = new SIDestinationAddress[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            sIDestinationAddressArray[i] = ((SIDestinationAddressFactory)MessageProcessor.getSingletonInstance("SIDestinationAddressFactory")).createSIDestinationAddress((String)vector.get(i), true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationAddresses", (Object)new Object[]{sIDestinationAddressArray});
        }
        return sIDestinationAddressArray;
    }

    private boolean isAvailable(BaseDestinationHandler baseDestinationHandler, DestinationAvailability destinationAvailability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAvailable", (Object)new Object[]{baseDestinationHandler, destinationAvailability});
        }
        boolean bl = false;
        boolean bl2 = false;
        if (destinationAvailability == DestinationAvailability.SEND || destinationAvailability == DestinationAvailability.SEND_AND_RECEIVE) {
            if (!baseDestinationHandler.isMediated() && baseDestinationHandler.hasLocal()) {
                bl = true;
            } else if (baseDestinationHandler.isMediatedLocally()) {
                bl = true;
            }
            if (bl) {
                bl = baseDestinationHandler.definition.isSendAllowed() && this.isLocalizationAvailable(baseDestinationHandler, destinationAvailability);
            }
        }
        if (destinationAvailability == DestinationAvailability.RECEIVE || destinationAvailability == DestinationAvailability.SEND_AND_RECEIVE) {
            if (baseDestinationHandler.hasLocal()) {
                bl2 = true;
            }
            if (bl2) {
                bl2 = baseDestinationHandler.definition.isReceiveAllowed() && this.isLocalizationAvailable(baseDestinationHandler, destinationAvailability);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAvailable", (Object)new Object[]{new Boolean(bl || bl2)});
        }
        return bl || bl2;
    }

    private boolean isLocalizationAvailable(BaseDestinationHandler baseDestinationHandler, DestinationAvailability destinationAvailability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocalizationAvailable", (Object)new Object[]{baseDestinationHandler, destinationAvailability});
        }
        boolean bl = false;
        if (baseDestinationHandler.hasLocal()) {
            PtoPMessageItemStream ptoPMessageItemStream = baseDestinationHandler.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
            bl = destinationAvailability == DestinationAvailability.SEND ? ((PtoPLocalMsgsItemStream)ptoPMessageItemStream).isSendAllowed() : true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocalizationAvailable", (Object)new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDestinationListener(DestinationListener destinationListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDestinationListener", (Object)new Object[]{destinationListener});
        }
        DestinationManager destinationManager = this;
        synchronized (destinationManager) {
            for (int i = 0; i < this.destinationListeners.size(); ++i) {
                DestinationListenerDataObject destinationListenerDataObject = (DestinationListenerDataObject)this.destinationListeners.get(i);
                if (!destinationListener.equals(destinationListenerDataObject.getDestinationLister())) continue;
                this.destinationListeners.remove(destinationListenerDataObject);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDestinationListener");
        }
    }

    private void callDestinationListener(String string) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"callDestinationListener", (Object)new Object[]{string});
        }
        DestinationListenerDataObject destinationListenerDataObject = null;
        DestinationListener destinationListener = null;
        DestinationAvailability destinationAvailability = null;
        MPCoreConnection mPCoreConnection = null;
        BaseDestinationHandler baseDestinationHandler = null;
        try {
            baseDestinationHandler = (BaseDestinationHandler)this.getDestination(string, false);
        }
        catch (SIMPDestinationCorruptException sIMPDestinationCorruptException) {
            FFDCFilter.processException((Throwable)((Object)sIMPDestinationCorruptException), (String)"com.ibm.ws.sib.processor.impl.DestinationManager.callDestinationListener", (String)"1:6464:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIMPDestinationCorruptException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"callDestinationListener", (Object)"Destination corrupt");
            }
            return;
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.DestinationManager.callDestinationListener", (String)"1:6483:1.428.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"callDestinationListener", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)sIException);
        }
        if (baseDestinationHandler.definition.getDestinationType() != DestinationType.TOPICSPACE) {
            for (int i = 0; i < this.destinationListeners.size(); ++i) {
                destinationListenerDataObject = (DestinationListenerDataObject)this.destinationListeners.get(i);
                destinationListener = destinationListenerDataObject.getDestinationLister();
                destinationAvailability = destinationListenerDataObject.getDestinationAvailability();
                mPCoreConnection = destinationListenerDataObject.getConnection();
                SIDestinationAddress sIDestinationAddress = null;
                if (!this.isAvailable(baseDestinationHandler, destinationAvailability) || baseDestinationHandler.isSystem() || destinationListenerDataObject.getDestinationType() != baseDestinationHandler.definition.getDestinationType()) continue;
                sIDestinationAddress = ((SIDestinationAddressFactory)MessageProcessor.getSingletonInstance("SIDestinationAddressFactory")).createSIDestinationAddress(baseDestinationHandler.getName(), true);
                destinationListener.destinationAvailable(mPCoreConnection, sIDestinationAddress, destinationAvailability);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"callDestinationListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcileMQLinkPubSubBridgeQs() {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconcileMQLinkPubSubBridgeQs");
        }
        LinkTypeFilter linkTypeFilter = new LinkTypeFilter();
        linkTypeFilter.MQLINK = Boolean.TRUE;
        SIMPIterator sIMPIterator = this.linkIndex.iterator(linkTypeFilter);
        PSBFactory pSBFactory = PSBFactoryPoint.getInstance();
        ItemStreamManager itemStreamManager = pSBFactory.getItemStreamManager();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        boolean bl = false;
        while (sIMPIterator.hasNext()) {
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
            }
            if ((object2 = ((MQLinkHandler)(object = (MQLinkHandler)sIMPIterator.next())).getMqLinkPubSubBridgeItemStream()) != null) {
                try {
                    arrayList.addAll(itemStreamManager.getSIBDestinationList((ItemStream)object2));
                    arrayList2.addAll(itemStreamManager.getSIBDurableSubscriptionList((ItemStream)object2));
                }
                catch (MessageStoreException messageStoreException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
                continue;
            }
            bl = true;
        }
        sIMPIterator.finished();
        if (!bl) {
            Object object3;
            object = this.durableSubscriptions;
            synchronized (object) {
                object2 = this.durableSubscriptions.keySet().iterator();
                while (object2.hasNext()) {
                    object3 = (String)object2.next();
                    if (!((String)object3).startsWith("_P_PSB") || arrayList2.contains(object3)) continue;
                    try {
                        this.messageProcessor.getAdministrator().deleteSubscription((String)object3, true, null);
                    }
                    catch (SIException sIException) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    }
                }
            }
            object = new DestinationTypeFilter();
            ((DestinationTypeFilter)object).LOCAL = Boolean.TRUE;
            sIMPIterator = this.destinationIndex.iterator((IndexFilter)object);
            while (sIMPIterator.hasNext()) {
                object2 = (DestinationHandler)sIMPIterator.next();
                if (!object2.getName().startsWith("_S_PSB") || arrayList.contains(object2.getName())) continue;
                object3 = (BaseDestinationHandler)object2;
                try {
                    this.deleteSystemDestination((BaseDestinationHandler)object3);
                }
                catch (SIException sIException) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconcileMQLinkPubSubBridgeQs");
        }
    }

    public List getAllSystemDestinations(SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllSystemDestinations", (Object)sIBUuid8);
        }
        DestinationTypeFilter destinationTypeFilter = new DestinationTypeFilter();
        destinationTypeFilter.LOCAL = Boolean.FALSE;
        destinationTypeFilter.DELETE_PENDING = Boolean.FALSE;
        destinationTypeFilter.DELETE_DEFERED = Boolean.FALSE;
        destinationTypeFilter.ACTIVE = Boolean.TRUE;
        ArrayList<JsDestinationAddress> arrayList = new ArrayList<JsDestinationAddress>();
        SIMPIterator sIMPIterator = this.getDestinationIndex().iterator(destinationTypeFilter);
        while (sIMPIterator.hasNext()) {
            DestinationHandler destinationHandler = (DestinationHandler)sIMPIterator.next();
            String string = destinationHandler.getName();
            SIBUuid8 sIBUuid82 = SIMPUtils.parseME(string);
            if (sIBUuid82 == null && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Couldn't parse uuid from " + string));
            }
            if (sIBUuid82 == null || !sIBUuid82.equals((Object)sIBUuid8) || !destinationHandler.isSystem()) continue;
            arrayList.add(SIMPUtils.createJsDestinationAddress(destinationHandler.getName(), sIBUuid8));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllSystemDestinations", arrayList);
        }
        return arrayList;
    }

    protected void activateDestination(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activateDestination", (Object)destinationHandler);
        }
        if (destinationHandler.isLink()) {
            this.linkIndex.create(destinationHandler);
        } else {
            this.destinationIndex.create(destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activateDestination");
        }
    }

    public MQLinkManager getMQLinkManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkManager");
        }
        if (this._mqlinkManager == null) {
            this._mqlinkManager = MQLinkManager.getInstance();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkManager", (Object)this._mqlinkManager);
        }
        return this._mqlinkManager;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/DestinationManager.java, SIB.processor, WAS602.SIB, o0610.11 1.428.1.1");
        }
    }
}

