/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.pmi.rm.SIBPmiRm;
import com.ibm.ws.sib.processor.MPConsumerSession;
import com.ibm.ws.sib.processor.exceptions.SIMPMessageNotLockedException;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIConsumerSession;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ExternalConsumerLock;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class ConsumerSessionImpl
implements MPConsumerSession {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)ConsumerSessionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private boolean _enableReadAhead;
    private boolean _forwardScanning;
    private ConnectionImpl _connection;
    private LocalConsumerPoint _localConsumerPoint;
    private SIDestinationAddress _destAddr;
    private boolean _bifurcatable;
    private long _consumerId;
    private List _bifurcatedConsumers;

    ConsumerSessionImpl(DestinationHandler destinationHandler, SIDestinationAddress sIDestinationAddress, ConsumerDispatcherState consumerDispatcherState, ConnectionImpl connectionImpl, boolean bl, boolean bl2, Reliability reliability, boolean bl3) throws SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException, SISessionDroppedException, SIDestinationLockedException, SIDurableSubscriptionMismatchException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIDurableSubscriptionNotFoundException, SISessionUnavailableException, SIIncorrectCallException, SIResourceException {
        boolean bl4;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)new Object[]{destinationHandler, sIDestinationAddress, consumerDispatcherState, connectionImpl, new Boolean(bl), new Boolean(bl2), reliability, new Boolean(bl3)});
        }
        this._connection = connectionImpl;
        this._messageProcessor = connectionImpl.getMessageProcessor();
        this._enableReadAhead = bl;
        this._forwardScanning = bl2;
        this._bifurcatable = bl3;
        this._destAddr = sIDestinationAddress;
        boolean bl5 = bl4 = ((JsDestinationAddress)sIDestinationAddress).isFromMediation();
        if (!bl4) {
            ((JsDestinationAddress)sIDestinationAddress).setBusName(destinationHandler.getMessageProcessor().getMessagingEngineBus());
        }
        if (!destinationHandler.isPubSub() && !bl4) {
            ConsumerDispatcher consumerDispatcher = destinationHandler.getLocalPtoPConsumerDispatcher();
            if (consumerDispatcher == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"ConsumerDispatcher not found ");
                }
            } else if (consumerDispatcher.isLocked()) {
                if (consumerDispatcher.getDestination().isTemporary()) {
                    SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException = new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("DESTINATION_IS_LOCKED_ERROR_CWSIP0133", new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)((Object)sITemporaryDestinationNotFoundException));
                    }
                    throw sITemporaryDestinationNotFoundException;
                }
                SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException = new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_IS_LOCKED_ERROR_CWSIP0133", new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sINotPossibleInCurrentConfigurationException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)((Object)sINotPossibleInCurrentConfigurationException));
                }
                throw sINotPossibleInCurrentConfigurationException;
            }
        }
        this._localConsumerPoint = new LocalConsumerPoint(destinationHandler, consumerDispatcherState, this, reliability, bl4, bl3);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerSessionImpl", (Object)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIBusMessage receiveNoWait(SITransaction sITransaction) throws SIErrorException, SISessionUnavailableException, SIIncorrectCallException, SIResourceException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveNoWait", (Object)new Object[]{this, sITransaction});
        }
        this.checkTransaction(sITransaction, "TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777");
        JsMessage jsMessage = null;
        Object object = null;
        SIBPmiRm sIBPmiRm = this._messageProcessor.getRmImpl();
        if (sIBPmiRm.isActiveOnThread()) {
            object = sIBPmiRm.syncConsumeMessageBlock(this._destAddr.getBusName(), this._destAddr.getDestinationName());
        }
        boolean bl = false;
        try {
            try {
                jsMessage = this._localConsumerPoint.receive(-1L, (Transaction)sITransaction);
                bl = true;
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveNoWait", (Object)"SISessionUnavailableException");
                }
                throw new SISessionUnavailableException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._destAddr.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (sIBPmiRm.isActiveOnThread()) {
                sIBPmiRm.syncConsumeMessageUnblock(object, bl ? 0 : 1);
            }
            throw throwable;
        }
        if (sIBPmiRm.isActiveOnThread()) {
            sIBPmiRm.syncConsumeMessageUnblock(object, bl ? 0 : 1);
        }
        if (UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(sITransaction, jsMessage, this._destAddr, this.getIdInternal());
        }
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveNoWait", (Object)jsMessage);
        }
        return jsMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIBusMessage receiveWithWait(SITransaction sITransaction, long l) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SIIncorrectCallException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveWithWait", (Object)new Object[]{this, new Long(l), sITransaction});
        }
        this.checkTransaction(sITransaction, "TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777");
        Object object = null;
        SIBPmiRm sIBPmiRm = this._messageProcessor.getRmImpl();
        if (sIBPmiRm.isActiveOnThread()) {
            object = sIBPmiRm.syncConsumeMessageBlock(this._destAddr.getBusName(), this._destAddr.getDestinationName());
        }
        JsMessage jsMessage = null;
        boolean bl = false;
        try {
            try {
                jsMessage = this._localConsumerPoint.receive(l, (Transaction)sITransaction);
                bl = true;
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveWithWait", (Object)"SISessionUnavailableException");
                }
                throw new SISessionUnavailableException(nls.getFormattedMessage("CONSUMER_CLOSED_ERROR_CWSIP0177", new Object[]{this._destAddr.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (sIBPmiRm.isActiveOnThread()) {
                sIBPmiRm.syncConsumeMessageUnblock(object, bl ? 0 : 1);
            }
            throw throwable;
        }
        if (sIBPmiRm.isActiveOnThread()) {
            sIBPmiRm.syncConsumeMessageUnblock(object, bl ? 0 : 1);
        }
        if (UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(sITransaction, jsMessage, this._destAddr, this.getIdInternal());
        }
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"receiveWithWait", (Object)jsMessage);
        }
        return jsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void attachBifurcatedConsumer(BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachBifurcatedConsumer", (Object)bifurcatedConsumerSessionImpl);
        }
        if (this._bifurcatedConsumers == null) {
            object = this;
            synchronized (object) {
                if (this._bifurcatedConsumers == null) {
                    this._bifurcatedConsumers = new LinkedList();
                }
            }
        }
        object = this._bifurcatedConsumers;
        synchronized (object) {
            this._bifurcatedConsumers.add(bifurcatedConsumerSessionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachBifurcatedConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeBifurcatedConsumer(BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBifurcatedConsumer", (Object)bifurcatedConsumerSessionImpl);
        }
        List list = this._bifurcatedConsumers;
        synchronized (list) {
            this._bifurcatedConsumers.remove(bifurcatedConsumerSessionImpl);
        }
        this._localConsumerPoint.cleanupBifurcatedConsumer(bifurcatedConsumerSessionImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBifurcatedConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"close", (Object)this);
        }
        this._close();
        this._connection.removeConsumerSession(this);
        if (this._bifurcatedConsumers != null) {
            List list = this._bifurcatedConsumers;
            synchronized (list) {
                Iterator iterator = this._bifurcatedConsumers.iterator();
                while (iterator.hasNext()) {
                    BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl = (BifurcatedConsumerSessionImpl)iterator.next();
                    bifurcatedConsumerSessionImpl._close();
                    iterator.remove();
                }
            }
        }
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"close");
        }
    }

    void _close() throws SIResourceException, SIConnectionLostException, SIErrorException {
        block4: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"_close");
            }
            try {
                this._localConsumerPoint.close();
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (!tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"_close", (Object)((Object)sINotPossibleInCurrentConfigurationException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotClosed() throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
        }
        try {
            LocalConsumerPoint localConsumerPoint = this._localConsumerPoint;
            synchronized (localConsumerPoint) {
                this._localConsumerPoint.checkNotClosed();
            }
        }
        catch (SISessionUnavailableException sISessionUnavailableException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)((Object)sISessionUnavailableException));
            }
            throw sISessionUnavailableException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNotClosed");
        }
    }

    public void registerAsynchConsumerCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, OrderingContext orderingContext) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback", (Object)new Object[]{this, asynchConsumerCallback, new Integer(n), new Long(l), new Integer(n2), orderingContext});
        }
        this.registerAsynchConsumerCallback(asynchConsumerCallback, n, l, n2, null, false, orderingContext);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback");
        }
    }

    public void registerAsynchMediationConsumerCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, Reliability reliability, boolean bl, OrderingContext orderingContext, ExternalConsumerLock externalConsumerLock) throws SISessionDroppedException, SISessionUnavailableException, SIErrorException, SIIncorrectCallException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchMediationConsumerCallback", (Object)new Object[]{this, asynchConsumerCallback, new Integer(n), new Long(l), new Integer(n2), reliability, new Boolean(bl), orderingContext, externalConsumerLock});
        }
        this._localConsumerPoint.registerAsynchConsumer(asynchConsumerCallback, n, l, n2, reliability, bl, (OrderingContextImpl)orderingContext, externalConsumerLock);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchMediationConsumerCallback");
        }
    }

    public void registerAsynchConsumerCallback(AsynchConsumerCallback asynchConsumerCallback, int n, long l, int n2, Reliability reliability, boolean bl, OrderingContext orderingContext) throws SISessionDroppedException, SISessionUnavailableException, SIErrorException, SIIncorrectCallException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback", (Object)new Object[]{this, asynchConsumerCallback, new Integer(n), new Long(l), new Integer(n2), reliability, new Boolean(bl), orderingContext});
        }
        this._localConsumerPoint.registerAsynchConsumer(asynchConsumerCallback, n, l, n2, reliability, bl, (OrderingContextImpl)orderingContext, null);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"registerAsynchConsumerCallback");
        }
    }

    public void deregisterAsynchConsumerCallback() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"deregisterAsynchConsumerCallback", (Object)this);
        }
        this.registerAsynchConsumerCallback(null, 1, 0L, 1, null);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"deregisterAsynchConsumerCallback");
        }
    }

    public void start(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"start", (Object)new Object[]{this, new Boolean(bl)});
        }
        this._localConsumerPoint.start(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"start");
        }
    }

    public void stop() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"stop", (Object)this);
        }
        this._localConsumerPoint.stop();
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"stop");
        }
    }

    public SICoreConnection getConnection() {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getConnection", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getConnection", (Object)this._connection);
        }
        return this._connection;
    }

    public void unlockSet(SIMessageHandle[] sIMessageHandleArray) throws SIMPMessageNotLockedException, SISessionUnavailableException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(sIMessageHandleArray)});
        }
        this._localConsumerPoint.processMsgSet(sIMessageHandleArray, null, null, true, false, false);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockSet");
        }
    }

    public void deleteSet(SIMessageHandle[] sIMessageHandleArray, SITransaction sITransaction) throws SIMPMessageNotLockedException, SISessionUnavailableException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"deleteSet", (Object)new Object[]{this, SIMPUtils.messageHandleArrayToString(sIMessageHandleArray), sITransaction});
        }
        this.checkTransaction(sITransaction, "TRANSACTION_DELETE_USAGE_ERROR_CWSIP0778");
        this._localConsumerPoint.processMsgSet(sIMessageHandleArray, (Transaction)sITransaction, null, false, true, false);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"deleteSet");
        }
    }

    public void unlockAll() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockAll", (Object)this);
        }
        this._localConsumerPoint.unlockAll();
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"unlockAll");
        }
    }

    SIBUuid12 getConnectionUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionUuid");
        }
        SIBUuid12 sIBUuid12 = this._connection.getUuid();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnectionUuid", (Object)sIBUuid12);
        }
        return sIBUuid12;
    }

    boolean getReadAhead() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReadAhead");
            SibTr.exit((TraceComponent)tc, (String)"getReadAhead", (Object)new Boolean(this._enableReadAhead));
        }
        return this._enableReadAhead;
    }

    boolean getForwardScanning() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForwardScanning");
            SibTr.exit((TraceComponent)tc, (String)"getForwardScanning", (Object)new Boolean(this._forwardScanning));
        }
        return this._forwardScanning;
    }

    public void activateAsynchConsumer(boolean bl) throws SIErrorException, SISessionUnavailableException, SIIncorrectCallException, SIResourceException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"activateAsynchConsumer", (Object)new Object[]{this, new Boolean(bl)});
        }
        this._localConsumerPoint.runIsolatedAsynch(bl);
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"activateAsynchConsumer");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getDestinationAddress", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getDestinationAddress", (Object)this._destAddr);
        }
        return this._destAddr;
    }

    public LocalConsumerPoint getLocalConsumerPoint() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalConsumerPoint");
            SibTr.exit((TraceComponent)tc, (String)"getLocalConsumerPoint", (Object)this._localConsumerPoint);
        }
        return this._localConsumerPoint;
    }

    public long getId() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException {
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConsumerSession.tc, (String)"getId", (Object)this);
        }
        this._localConsumerPoint.checkNotClosed();
        if (CoreSPIConsumerSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConsumerSession.tc, (String)"getId", (Object)new Long(this._consumerId));
        }
        return this._consumerId;
    }

    public long getIdInternal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIdInternal");
            SibTr.exit((TraceComponent)tc, (String)"getIdInternal", (Object)new Long(this._consumerId));
        }
        return this._consumerId;
    }

    void setId(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setId", (Object)new Long(l));
        }
        this._consumerId = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setId");
        }
    }

    public SIBusMessage relockMessageUnderAsynchCursor() throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor");
        }
        SIBusMessage sIBusMessage = null;
        sIBusMessage = this._localConsumerPoint.relockMessageUnderAsynchCursor();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"relockMessageUnderAsynchCursor", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    protected boolean isBifurcatable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isBifurcatable");
            SibTr.exit((TraceComponent)tc, (String)"isBifurcatable", (Object)new Boolean(this._bifurcatable));
        }
        return this._bifurcatable;
    }

    private void checkTransaction(SITransaction sITransaction, String string) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkTransaction", (Object)new Object[]{sITransaction, string});
        }
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage(string, new Object[]{this._destAddr}, null));
            if (tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkTransaction", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkTransaction");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ConsumerSessionImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.155");
        }
    }
}

