/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;

public class ConsumerKeyGroup
extends SimpleEntry
implements DispatchableKey,
Filter {
    private static final TraceComponent tc = SibTr.register((Class)ConsumerKeyGroup.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private boolean ready;
    private boolean specificReady;
    private boolean groupReady;
    private long version;
    private int memberCount;
    private int startedCount;
    private int generalMemberCount;
    private LockingCursor getCursor;
    private DispatchableKey singleMember;
    private ArrayList generalKeyMembers;
    private ArrayList specificKeyMembers;
    private int generalMemberIndex;
    private ConsumerDispatcher consumerDispatcher;
    private SIBUuid12 connectionUuid;
    private boolean currentMatch;
    private ConsumerKey currentMatchingMember;
    private ConsumerKey msgAttachedMember;
    protected Object asynchGroupLock;

    public ConsumerKeyGroup(ConsumerDispatcher consumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerKeyGroup", (Object)consumerDispatcher);
        }
        if (consumerDispatcher.isPubSub()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumerKeyGroup", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:117:1.14"}, null));
        }
        this.ready = false;
        this.groupReady = false;
        this.version = 0L;
        this.getCursor = null;
        this.generalKeyMembers = null;
        this.specificKeyMembers = null;
        this.consumerDispatcher = consumerDispatcher;
        this.connectionUuid = null;
        this.memberCount = 0;
        this.startedCount = 0;
        this.generalMemberCount = 0;
        this.asynchGroupLock = new Object();
        this.singleMember = null;
        this.msgAttachedMember = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerKeyGroup", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addMember(ConsumerKey consumerKey) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMember", (Object)consumerKey);
        }
        if (this.connectionUuid == null) {
            this.connectionUuid = consumerKey.getConnectionUuid();
        } else if (!this.connectionUuid.equals((Object)consumerKey.getConnectionUuid())) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:163:1.14"}, null));
        }
        if (this.consumerDispatcher != consumerKey.getConsumerDispatcher()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:175:1.14"}, null));
        }
        if (consumerKey.getForwardScanning()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:188:1.14"}, null));
        }
        try {
            if (this.getCursor != null) {
                this.getCursor.finished();
                this.getCursor = null;
            }
            this.getCursor = this.consumerDispatcher.getItemStream().newLockingItemCursor(this);
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup.addMember", (String)"1:215:1.14", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKey", "1:225:1.14", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        Object object = this.consumerDispatcher.getReadyConsumerPointLock();
        synchronized (object) {
            if (this.ready) {
                this.ready = false;
                this.consumerDispatcher.removeReadyConsumer(this, this.specificReady);
            }
        }
        if (this.memberCount == 0) {
            this.singleMember = consumerKey;
            if (!consumerKey.isSpecific()) {
                ++this.generalMemberCount;
            }
        } else {
            if (this.singleMember != null) {
                if (this.generalMemberCount == 1) {
                    this.addMemberToList(this.singleMember, false);
                } else {
                    this.addMemberToList(this.singleMember, true);
                }
                this.singleMember = null;
            }
            if (consumerKey.isSpecific()) {
                this.addMemberToList(consumerKey, true);
            } else {
                ++this.generalMemberCount;
                this.addMemberToList(consumerKey, false);
            }
        }
        ++this.memberCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMember", (Object)new Long(this.memberCount));
        }
    }

    private void addMemberToList(DispatchableKey dispatchableKey, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMemberToList", (Object)new Object[]{dispatchableKey, new Boolean(bl)});
        }
        if (bl) {
            if (this.specificKeyMembers == null) {
                this.specificKeyMembers = new ArrayList();
            }
            this.specificKeyMembers.add(dispatchableKey);
        } else {
            if (this.generalKeyMembers == null) {
                this.generalKeyMembers = new ArrayList();
            }
            this.generalKeyMembers.add(dispatchableKey);
            this.generalMemberIndex = 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMemberToList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeMember(ConsumerKey consumerKey) {
        Object object;
        boolean bl;
        block13: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeMember", (Object)consumerKey);
            }
            bl = false;
            object = this.consumerDispatcher.getReadyConsumerPointLock();
            // MONITORENTER : object
            if (this.singleMember != null) {
                if (!consumerKey.isSpecific()) {
                    --this.generalMemberCount;
                }
                if (this.singleMember == consumerKey) {
                    this.singleMember = null;
                    break block13;
                } else {
                    if (!tc.isEntryEnabled()) throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:356:1.14"}, null));
                    SibTr.exit((TraceComponent)tc, (String)"removeMember", (Object)"SIErrorException");
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:356:1.14"}, null));
                }
            }
            if (consumerKey.isSpecific()) {
                this.specificKeyMembers.remove(consumerKey);
            } else {
                this.generalKeyMembers.remove(consumerKey);
                --this.generalMemberCount;
                this.generalMemberIndex = 0;
            }
        }
        --this.memberCount;
        if (this.memberCount == 0) {
            this.consumerDispatcher.removeKeyGroup(this);
            this.getCursor.finished();
        } else if (this.memberCount == this.startedCount) {
            bl = true;
        }
        // MONITOREXIT : object
        if (bl) {
            object = this.singleMember != null ? (ConsumerKey)this.singleMember : (this.generalMemberCount > 0 ? (ConsumerKey)this.generalKeyMembers.get(0) : (ConsumerKey)this.specificKeyMembers.get(0));
            ((ConsumerKey)object).getConsumerPoint().checkForMessages();
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"removeMember");
    }

    protected void startMember() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startMember");
            SibTr.exit((TraceComponent)tc, (String)"startMember", (Object)new Object[]{new Integer(this.startedCount), new Integer(this.memberCount)});
        }
        ++this.startedCount;
    }

    protected void stopMember() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopMember");
            SibTr.exit((TraceComponent)tc, (String)"stopMember", (Object)new Object[]{new Integer(this.startedCount), new Integer(this.memberCount)});
        }
        --this.startedCount;
    }

    protected boolean isStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted", (Object)new Object[]{new Integer(this.startedCount), new Integer(this.memberCount)});
        }
        if (this.startedCount == this.memberCount) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)new Boolean(true));
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)new Boolean(false));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ready() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ready");
        }
        Object object = this.consumerDispatcher.getReadyConsumerPointLock();
        synchronized (object) {
            if (!this.ready && this.startedCount == this.memberCount) {
                this.ready = true;
                this.specificReady = this.generalMemberCount == 0;
                this.version = this.consumerDispatcher.newReadyConsumer(this, this.specificReady);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ready");
        }
    }

    public boolean hasNonSpecificConsumers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNonSpecificConsumers");
        }
        boolean bl = this.generalMemberCount > 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasNonSpecificConsumers", (Object)bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notReady");
        }
        Object object = this.consumerDispatcher.getReadyConsumerPointLock();
        synchronized (object) {
            if (this.ready) {
                this.ready = false;
                this.consumerDispatcher.removeReadyConsumer(this, this.specificReady);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notReady");
        }
    }

    public void markNotReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markNotReady");
            SibTr.exit((TraceComponent)tc, (String)"markNotReady");
        }
        this.ready = false;
    }

    public boolean isKeyReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isKeyReady");
            SibTr.exit((TraceComponent)tc, (String)"isKeyReady", (Object)new Boolean(this.ready));
        }
        return this.ready;
    }

    public long getVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVersion");
            SibTr.exit((TraceComponent)tc, (String)"getVersion", (Object)new Long(this.version));
        }
        return this.version;
    }

    public DispatchableKey resolvedKey() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resolvedKey");
        }
        DispatchableKey dispatchableKey = null;
        if (this.generalMemberCount > 0) {
            if (this.singleMember != null) {
                dispatchableKey = this.singleMember;
            } else {
                dispatchableKey = (ConsumerKey)this.generalKeyMembers.get(this.generalMemberIndex);
                if (++this.generalMemberIndex == this.generalMemberCount) {
                    this.generalMemberIndex = 0;
                }
            }
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"resolvedKey", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:599:1.14"}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resolvedKey", (Object)dispatchableKey);
        }
        return dispatchableKey;
    }

    public DispatchableKey getParent() {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:616:1.14"}, null));
    }

    public boolean requiresRecovery(SIMPMessage sIMPMessage) {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:633:1.14"}, null));
    }

    protected void groupReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"groupReady", (Object)new Boolean(this.groupReady));
        }
        if (this.startedCount == this.memberCount) {
            this.groupReady = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"groupReady", (Object)new Boolean(this.groupReady));
        }
    }

    protected void groupNotReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"groupNotReady", (Object)new Boolean(this.groupReady));
            SibTr.exit((TraceComponent)tc, (String)"groupNotReady");
        }
        this.groupReady = false;
    }

    protected boolean isGroupReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGroupReady");
            SibTr.exit((TraceComponent)tc, (String)"isGroupReady", (Object)new Boolean(this.groupReady));
        }
        return this.groupReady;
    }

    public LockingCursor getCursor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCursor");
            SibTr.exit((TraceComponent)tc, (String)"getCursor", (Object)this.getCursor);
        }
        return this.getCursor;
    }

    public ConsumerPoint getConsumerPoint() {
        throw new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:693:1.14"}, null));
    }

    public SIBUuid12 getConnectionUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnectionUuid");
            SibTr.exit((TraceComponent)tc, (String)"getConnectionUuid", (Object)this.connectionUuid);
        }
        return this.connectionUuid;
    }

    public boolean getForwardScanning() {
        return false;
    }

    public boolean filterMatches(AbstractItem abstractItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"filterMatches", (Object)abstractItem);
        }
        this.currentMatch = false;
        if (this.generalMemberCount > 0) {
            this.currentMatchingMember = null;
            this.currentMatch = true;
        } else if (this.singleMember != null) {
            if (((ConsumerKey)this.singleMember).filterMatches(abstractItem)) {
                this.currentMatch = true;
                this.currentMatchingMember = (ConsumerKey)this.singleMember;
            }
        } else {
            int n = this.specificKeyMembers.size();
            for (int i = 0; i < n && !this.currentMatch; ++i) {
                ConsumerKey consumerKey = (ConsumerKey)this.specificKeyMembers.get(i);
                if (!consumerKey.filterMatches(abstractItem)) continue;
                this.currentMatch = true;
                this.currentMatchingMember = consumerKey;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"filterMatches", (Object)new Object[]{new Boolean(this.currentMatch), this.currentMatchingMember});
        }
        return this.currentMatch;
    }

    public ConsumerKey getMatchingMember(ConsumerKey consumerKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMatchingMember");
        }
        ConsumerKey consumerKey2 = null;
        if (this.currentMatch) {
            if (this.currentMatchingMember == null) {
                if (!consumerKey.isSpecific()) {
                    consumerKey2 = consumerKey;
                } else if (this.generalMemberCount > 0) {
                    consumerKey2 = (ConsumerKey)this.resolvedKey();
                }
            } else {
                consumerKey2 = this.currentMatchingMember;
            }
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMatchingMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:811:1.14"}, null));
        }
        if (consumerKey2 == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMatchingMember", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:824:1.14"}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMatchingMember", (Object)consumerKey2);
        }
        return consumerKey2;
    }

    public void attachMessage(ConsumerKey consumerKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachMessage", (Object)this.msgAttachedMember);
            SibTr.exit((TraceComponent)tc, (String)"attachMessage", (Object)consumerKey);
        }
        if (this.msgAttachedMember != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"attachMessage", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerKeyGroup", "1:856:1.14"}, null));
        }
        this.msgAttachedMember = consumerKey;
    }

    protected ConsumerKey getAttachedMember() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttachedMember");
            SibTr.exit((TraceComponent)tc, (String)"getAttachedMember", (Object)this.msgAttachedMember);
        }
        ConsumerKey consumerKey = this.msgAttachedMember;
        this.msgAttachedMember = null;
        return consumerKey;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ConsumerKeyGroup.java, SIB.processor, WAS602.SIB, o0610.11 1.14");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

