/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.InvalidAddOperation;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BrowserSessionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.ConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ReportHandler;
import com.ibm.ws.sib.processor.impl.SIMPState;
import com.ibm.ws.sib.processor.impl.interfaces.Browsable;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DispatchableKey;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MediationInputItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.matching.MatchingConsumerPoint;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.stats.DurableSubscriptionInstrumentation;
import com.ibm.ws.sib.processor.stats.QueueInstrumentation;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleEntry;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedList;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConsumerDispatcher
implements Browsable,
OutputHandler,
MessageEventListener,
ControllableSubscription {
    private static final TraceComponent tc = SibTr.register((Class)ConsumerDispatcher.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    protected MessageProcessor messageProcessor;
    protected BaseDestinationHandler baseDestination;
    private SubscriptionItemStream subscription = null;
    protected PtoPMessageItemStream itemStream = null;
    protected LinkedList consumerPoints;
    protected SimpleLinkedList nonSpecificReadyCPs;
    private SimpleLinkedList readyFwdScanningCPs;
    private boolean currentReceiveAllowed;
    protected long specificReadyConsumerCount = 0L;
    protected long specificConsumerVersion = 0L;
    protected long readyConsumerVersion = 0L;
    protected ConsumerDispatcherState dispatcherState;
    private QueueInstrumentation pToPStats;
    private DurableSubscriptionInstrumentation durableSubscriptionStats;
    private int exceptionRedeliveryThreshold;
    protected SIMPState state;
    protected Object readyConsumerPointLock = new Object();
    private LinkedList browsers = new LinkedList();
    private ReportHandler reportHandler = null;
    private boolean isGuess = false;
    private boolean isPreMediated;
    private boolean _isPubSub;
    private SIBUuid12 subscriptionUuid = new SIBUuid12();
    private boolean isInMatchSpace = false;
    private HashMap keyGroups = new HashMap();
    private ControlAdapter subscriptionControlAdaptor;
    private ReceiveAllowedThread _receiveAllowedThread = null;

    ConsumerDispatcher(BaseDestinationHandler baseDestinationHandler, SubscriptionItemStream subscriptionItemStream, ConsumerDispatcherState consumerDispatcherState) {
        this(baseDestinationHandler, consumerDispatcherState);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)new Object[]{baseDestinationHandler, subscriptionItemStream, consumerDispatcherState});
        }
        subscriptionItemStream.setConsumerDispatcher(this);
        this.subscription = subscriptionItemStream;
        this.isPreMediated = false;
        this._isPubSub = baseDestinationHandler.isPubSub();
        this.exceptionRedeliveryThreshold = baseDestinationHandler.getMaxFailedDeliveries();
        this.createControlAdapter();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)this);
        }
    }

    public ConsumerDispatcher(BaseDestinationHandler baseDestinationHandler, PtoPMessageItemStream ptoPMessageItemStream, ConsumerDispatcherState consumerDispatcherState) {
        this(baseDestinationHandler, consumerDispatcherState);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)new Object[]{baseDestinationHandler, ptoPMessageItemStream, consumerDispatcherState});
        }
        this.itemStream = ptoPMessageItemStream;
        this.isPreMediated = ptoPMessageItemStream.getClass() == MediationInputItemStream.class;
        this._isPubSub = baseDestinationHandler.isPubSub();
        this.exceptionRedeliveryThreshold = baseDestinationHandler.getMaxFailedDeliveries();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)this);
        }
    }

    private ConsumerDispatcher(BaseDestinationHandler baseDestinationHandler, ConsumerDispatcherState consumerDispatcherState) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)new Object[]{baseDestinationHandler, consumerDispatcherState});
        }
        this.baseDestination = baseDestinationHandler;
        this.dispatcherState = consumerDispatcherState;
        this.consumerPoints = new LinkedList();
        this.nonSpecificReadyCPs = new SimpleLinkedList();
        this.readyFwdScanningCPs = new SimpleLinkedList();
        this.messageProcessor = baseDestinationHandler.getMessageProcessor();
        this.state = SIMPState.LOCKED;
        this.currentReceiveAllowed = true;
        this.exceptionRedeliveryThreshold = baseDestinationHandler.getMaxFailedDeliveries();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConsumerDispatcher", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean storeMessage(MessageItem var1_1, Transaction var2_2, InputHandlerStore var3_3, boolean var4_4) throws SIResourceException {
        if (ConsumerDispatcher.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)new Object[]{var1_1, var2_2, var3_3, new Boolean(var4_4)});
        }
        if (!this.isPreMediated && this._isPubSub) {
            if (!var4_4) {
                var3_3.storeMessage(var1_1, var2_2);
                var4_4 = true;
            }
            try {
                var5_5 = false;
                if (this.dispatcherState.isDurable()) {
                    var1_1.addPersistentRef();
                } else {
                    var1_1.addNonPersistentRef();
                    var5_5 = true;
                }
                var6_11 = new MessageItemReference(var1_1, var5_5);
                this.subscription.getSubscriptionLockManager().lock();
                try {
                    if (this.subscription.isToBeDeleted()) ** GOTO lbl65
                    this.registerForEvents(var6_11);
                    this.subscription.add(var6_11, var2_2);
                }
                finally {
                    this.subscription.getSubscriptionLockManager().unlock();
                }
            }
            catch (OutOfCacheSpace var5_6) {
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)var5_6);
                if (ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)var5_6);
                }
                throw new SIResourceException((Throwable)var5_6);
            }
            catch (MessageStoreException var5_7) {
                FFDCFilter.processException((Throwable)var5_7, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:615:1.253", (Object)this);
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)var5_7);
                SibTr.error((TraceComponent)ConsumerDispatcher.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:622:1.253", var5_7});
                if (ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)var5_7);
                }
                throw new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:633:1.253", var5_7}, null), (Throwable)var5_7);
            }
            catch (InvalidAddOperation var5_8) {
                if (this.state != SIMPState.DELETED) {
                    FFDCFilter.processException((Throwable)var5_8, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:647:1.253", (Object)this);
                    SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)var5_8);
                    SibTr.error((TraceComponent)ConsumerDispatcher.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:654:1.253", var5_8});
                    if (ConsumerDispatcher.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)var5_8);
                    }
                    throw new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:665:1.253", var5_8}, null), (Throwable)var5_8);
                }
                if (!ConsumerDispatcher.tc.isDebugEnabled()) ** GOTO lbl65
                SibTr.debug((TraceComponent)ConsumerDispatcher.tc, (String)("ConsumerDeispatcher deleted " + this));
            }
        } else {
            try {
                this.baseDestination.registerForEvents(var1_1);
                this.itemStream.addItem(var1_1, var2_2);
            }
            catch (OutOfCacheSpace var5_9) {
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)var5_9);
                if (ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)var5_9);
                }
                throw new SIResourceException((Throwable)var5_9);
            }
            catch (MessageStoreException var5_10) {
                FFDCFilter.processException((Throwable)var5_10, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.storeMessage", (String)"1:709:1.253", (Object)this);
                SibTr.exception((TraceComponent)ConsumerDispatcher.tc, (Exception)var5_10);
                SibTr.error((TraceComponent)ConsumerDispatcher.tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:716:1.253", var5_10});
                if (ConsumerDispatcher.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)var5_10);
                }
                throw new SIResourceException(ConsumerDispatcher.nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:727:1.253", var5_10}, null), (Throwable)var5_10);
            }
            this.registerForEvents(var1_1);
            var4_4 = false;
        }
lbl65:
        // 5 sources

        if (ConsumerDispatcher.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)ConsumerDispatcher.tc, (String)"storeMessage", (Object)new Boolean(var4_4));
        }
        return var4_4;
    }

    public void registerForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)sIMPMessage);
        }
        sIMPMessage.registerMessageEventListener(2, this);
        sIMPMessage.registerMessageEventListener(3, this);
        sIMPMessage.registerMessageEventListener(5, this);
        sIMPMessage.registerMessageEventListener(6, this);
        if (this.itemStream != null) {
            this.itemStream.registerForEvents(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    private boolean giveMessageToConsumer(SIMPMessage sIMPMessage, Transaction transaction, ConsumerPoint consumerPoint, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"giveMessageToConsumer", (Object)new Object[]{sIMPMessage, transaction, consumerPoint, new Boolean(bl)});
        }
        boolean bl2 = false;
        bl2 = consumerPoint.put(sIMPMessage, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"giveMessageToConsumer", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    public boolean put(SIMPMessage sIMPMessage, Transaction transaction, InputHandlerStore inputHandlerStore, boolean bl) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{sIMPMessage, transaction, inputHandlerStore, new Boolean(bl)});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        if (sIMPMessage.getRequiresNewId() || jsMessage.getSystemMessageId() == null) {
            jsMessage.setSystemMessageSourceUuid(this.messageProcessor.getMessagingEngineUuid());
            jsMessage.setSystemMessageValue(this.messageProcessor.nextTick());
            sIMPMessage.setRequiresNewId(false);
        }
        if (sIMPMessage.getMessage().getReportCOA() != null) {
            if (this.reportHandler == null) {
                this.reportHandler = new ReportHandler(this.messageProcessor);
            }
            try {
                this.reportHandler.handleMessage(sIMPMessage, transaction, SIApiConstants.REPORT_COA);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.put", (String)"1:847:1.253", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)exception);
            }
        }
        if (sIMPMessage.isTransacted() && !this._isPubSub) {
            boolean bl2 = this.storeMessage((MessageItem)sIMPMessage, transaction, inputHandlerStore, bl);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(bl2));
            }
            return bl2;
        }
        boolean bl3 = this.internalPut(sIMPMessage, transaction, inputHandlerStore, bl, false, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(bl3));
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean internalPut(SIMPMessage sIMPMessage, Transaction transaction, InputHandlerStore inputHandlerStore, boolean bl, boolean bl2, boolean bl3) throws SIResourceException, SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalPut", (Object)new Object[]{sIMPMessage, transaction, inputHandlerStore, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        }
        long l = 0L;
        boolean bl4 = false;
        boolean bl5 = true;
        DispatchableKey dispatchableKey = null;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = bl3;
        long l2 = Long.MAX_VALUE;
        MatchingConsumerPoint[] matchingConsumerPointArray = null;
        MessageProcessorSearchResults messageProcessorSearchResults = null;
        boolean bl9 = false;
        boolean bl10 = true;
        ArrayList<ConsumerKey> arrayList = null;
        if (bl2) {
            bl7 = true;
        }
        while (true) {
            Object[] objectArray;
            block28: {
                ConsumerKey consumerKey;
                block34: {
                    block31: {
                        int n;
                        int n2;
                        block33: {
                            block29: {
                                block32: {
                                    block30: {
                                        if (!bl5) break block29;
                                        objectArray = this.readyConsumerPointLock;
                                        // MONITORENTER : this.readyConsumerPointLock
                                        if (bl8) {
                                            if (this.pToPStats != null) {
                                                this.pToPStats.onProduce(sIMPMessage);
                                            }
                                            bl8 = false;
                                        }
                                        if (bl7) {
                                            l2 = this.readyConsumerVersion;
                                            bl7 = false;
                                        }
                                        if ((dispatchableKey = (DispatchableKey)((Object)this.nonSpecificReadyCPs.getFirst())) != null && dispatchableKey.getVersion() > l2) {
                                            dispatchableKey = null;
                                        }
                                        if (dispatchableKey == null) break block30;
                                        bl9 = false;
                                        dispatchableKey = dispatchableKey.resolvedKey();
                                        break block31;
                                    }
                                    bl9 = true;
                                    if (this.specificReadyConsumerCount <= 0L) break block31;
                                    if (this.specificConsumerVersion == l || bl4) break block32;
                                    if (l <= 0L || bl2) {
                                        bl6 = true;
                                        l = this.specificConsumerVersion;
                                        if (bl2) {
                                            bl4 = true;
                                        }
                                    }
                                    break block31;
                                }
                                if (matchingConsumerPointArray.length <= 0) break block31;
                                n = n2 = sIMPMessage.getProducerSeed() % matchingConsumerPointArray.length;
                                break block33;
                            }
                            if (messageProcessorSearchResults != null) {
                                this.messageProcessor.getSearchResultsObjectPool().add(messageProcessorSearchResults);
                            }
                            if (!tc.isEntryEnabled()) return bl;
                            SibTr.exit((TraceComponent)tc, (String)"internalPut", (Object)new Boolean(bl));
                            return bl;
                        }
                        while (dispatchableKey == null) {
                            ConsumerKey consumerKey2 = matchingConsumerPointArray[n].getConsumerPointData();
                            if (consumerKey2.isKeyReady() && consumerKey2.getVersion() <= l2) {
                                dispatchableKey = consumerKey2;
                                continue;
                            }
                            if ((n = (n + 1) % matchingConsumerPointArray.length) != n2) continue;
                        }
                    }
                    if (dispatchableKey == null) break block34;
                    if (this.dispatcherState.isNoLocal() && dispatchableKey.getConnectionUuid().equals((Object)sIMPMessage.getProducerConnectionUuid())) {
                        bl10 = false;
                        bl5 = false;
                        break block28;
                    } else if (!bl2 && (dispatchableKey.requiresRecovery(sIMPMessage) || sIMPMessage.isTransacted())) {
                        dispatchableKey = null;
                        if (sIMPMessage.isTransacted()) {
                            bl5 = false;
                        }
                        break block28;
                    } else {
                        dispatchableKey.markNotReady();
                        this.removeReadyConsumer(dispatchableKey.getParent(), bl9);
                    }
                    break block28;
                }
                if (bl2 && (consumerKey = (ConsumerKey)this.readyFwdScanningCPs.getFirst()) != null) {
                    arrayList = new ArrayList<ConsumerKey>();
                    while (consumerKey != null) {
                        ConsumerKey consumerKey3 = (ConsumerKey)consumerKey.next();
                        arrayList.add(consumerKey);
                        consumerKey.markNotReady();
                        consumerKey.remove();
                        consumerKey = consumerKey3;
                    }
                }
            }
            // MONITOREXIT : objectArray
            if (!bl10) continue;
            if (dispatchableKey != null) {
                bl5 = !this.giveMessageToConsumer(sIMPMessage, transaction, dispatchableKey.getConsumerPoint(), bl2);
                if (bl5) {
                    dispatchableKey = null;
                    continue;
                }
                if (bl2) continue;
                if (this.pToPStats != null) {
                    this.pToPStats.onConsume(sIMPMessage);
                    continue;
                }
                if (this.durableSubscriptionStats == null) continue;
                this.durableSubscriptionStats.onConsume(sIMPMessage);
                continue;
            }
            if (arrayList != null) {
                objectArray = arrayList.iterator();
                while (objectArray.hasNext()) {
                    this.giveMessageToConsumer(sIMPMessage, transaction, ((ConsumerKey)objectArray.next()).getConsumerPoint(), bl2);
                }
                bl5 = false;
                continue;
            }
            if (bl6) {
                messageProcessorSearchResults = (MessageProcessorSearchResults)this.messageProcessor.getSearchResultsObjectPool().remove();
                messageProcessorSearchResults = this.messageProcessor.getMessageProcessorMatching().retrieveMatchingConsumerPoints(this.baseDestination.getUuid(), sIMPMessage.getMessage(), messageProcessorSearchResults);
                objectArray = messageProcessorSearchResults.getResults(this.baseDestination.getName());
                Set set = (Set)objectArray[2];
                matchingConsumerPointArray = set.toArray(new MatchingConsumerPoint[0]);
                bl6 = false;
                continue;
            }
            if (!bl2) {
                bl = this.storeMessage((MessageItem)sIMPMessage, transaction, inputHandlerStore, bl);
                bl2 = true;
                bl7 = true;
                if (transaction == null || transaction.isAutoCommit()) continue;
                bl5 = false;
                continue;
            }
            bl5 = false;
        }
    }

    public boolean isDurable() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDurable");
        }
        boolean bl2 = bl = this._isPubSub && this.dispatcherState.isDurable();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDurable", (Object)new Boolean(bl));
        }
        return bl;
    }

    long newReadyConsumer(DispatchableKey dispatchableKey, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newReadyConsumer", (Object)new Object[]{dispatchableKey, new Boolean(bl)});
        }
        if (dispatchableKey.getForwardScanning()) {
            this.readyFwdScanningCPs.put((SimpleEntry)((Object)dispatchableKey));
        } else if (bl) {
            ++this.specificReadyConsumerCount;
        } else {
            this.nonSpecificReadyCPs.put((SimpleEntry)((Object)dispatchableKey));
        }
        ++this.readyConsumerVersion;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newReadyConsumer", (Object)new Object[]{new Long(this.readyConsumerVersion), new Long(this.specificReadyConsumerCount)});
        }
        return this.readyConsumerVersion;
    }

    void removeReadyConsumer(DispatchableKey dispatchableKey, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeReadyConsumer", (Object)new Object[]{dispatchableKey, new Boolean(bl)});
        }
        if (dispatchableKey.getForwardScanning()) {
            ((SimpleEntry)((Object)dispatchableKey)).remove();
        } else if (bl) {
            --this.specificReadyConsumerCount;
        } else {
            ((SimpleEntry)((Object)dispatchableKey)).remove();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeReadyConsumer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConsumerKey attachConsumerPoint(ConsumerPoint consumerPoint, SelectionCriteria selectionCriteria, SIBUuid12 sIBUuid12, boolean bl, boolean bl2) throws SINotPossibleInCurrentConfigurationException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachConsumerPoint", (Object)new Object[]{consumerPoint, selectionCriteria, sIBUuid12, new Boolean(bl)});
        }
        ConsumerKey consumerKey = null;
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            if (consumerPoint.getNamedDestination(this).isToBeDeleted() || consumerPoint.getNamedDestination(this).isDeleted()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"destination deleted");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP0111", new Object[]{this.baseDestination.getName(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            if (!this._isPubSub) {
                if (consumerPoint.getNamedDestination(this).isReceiveExclusive() && this.consumerPoints.size() > 0) {
                    SIDestinationLockedException sIDestinationLockedException = new SIDestinationLockedException(nls.getFormattedMessage("DESTINATION_RECEIVE_EXCLUSIVE_CWSIP0114", new Object[]{this.baseDestination.getName(), this.messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDestinationLockedException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"Destination receive exclusive");
                    }
                    throw sIDestinationLockedException;
                }
            } else if (this.isDurable() && !this.dispatcherState.isCloned() && this.consumerPoints.size() > 0) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)"SIDestinationLockedException");
                }
                throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{this.dispatcherState.getSubscriberID(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            consumerKey = this.createConsumerKey(consumerPoint, selectionCriteria, sIBUuid12, bl, bl2);
            this.consumerPoints.add(consumerKey);
            if (consumerKey.isSpecific()) {
                ++this.specificConsumerVersion;
            }
            if (this.pToPStats != null) {
                this.pToPStats.onAttachConsumer();
            }
        }
        if (!this._isPubSub) {
            this.baseDestination.addConsumerPointMatchTarget(consumerKey, selectionCriteria);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachConsumerPoint", (Object)consumerKey);
        }
        return consumerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachConsumerPoint(ConsumerKey consumerKey) throws SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachConsumerPoint", (Object)consumerKey);
        }
        if (!this._isPubSub) {
            this.baseDestination.removeConsumerPointMatchTarget(consumerKey);
        } else {
            this.state = SIMPState.DELETED;
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            if (this.consumerPoints.contains(consumerKey)) {
                this.consumerPoints.remove(consumerKey);
            }
            if (!this.isPreMediated && this.consumerPoints.isEmpty() && this._isPubSub && (!this.isDurable() || this instanceof RemoteConsumerDispatcher)) {
                this.deleteConsumerDispatcher(!this.isDurable(), false);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachConsumerPoint");
        }
    }

    protected ConsumerKey createConsumerKey(ConsumerPoint consumerPoint, SelectionCriteria selectionCriteria, SIBUuid12 sIBUuid12, boolean bl, boolean bl2) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKey", (Object)new Object[]{consumerPoint, selectionCriteria, sIBUuid12, new Boolean(bl), new Boolean(bl2)});
        }
        ConsumerKey consumerKey = new ConsumerKey(consumerPoint, this, selectionCriteria, sIBUuid12, bl2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKey", (Object)consumerKey);
        }
        return consumerKey;
    }

    protected ConsumerKeyGroup createConsumerKeyGroup() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerKeyGroup");
        }
        ConsumerKeyGroup consumerKeyGroup = new ConsumerKeyGroup(this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerKeyGroup", (Object)consumerKeyGroup);
        }
        return consumerKeyGroup;
    }

    protected boolean hasConsumersAttached() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasConsumersAttached");
        }
        boolean bl2 = bl = this.getConsumerCount() > 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasConsumersAttached", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsumerCount() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerCount");
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            n = this.consumerPoints.size();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerCount", (Object)new Integer(n));
        }
        return n;
    }

    public List getConsumerPoints() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerPoints");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerPoints", (Object)this.consumerPoints);
        }
        return (List)this.consumerPoints.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteConsumerDispatcher(boolean bl, boolean bl2) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteConsumerDispatcher", (Object)new Object[]{new Boolean(bl), new Boolean(this.isInMatchSpace)});
        }
        LinkedList linkedList = this.consumerPoints;
        synchronized (linkedList) {
            if (this.hasConsumersAttached()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteConsumerDispatcher", (Object)"Consumers attached ");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETION_ERROR_CWSIP0112", new Object[]{this.baseDestination.getName()}, null));
            }
        }
        this.state = SIMPState.DELETED;
        if (this.isInMatchSpace) {
            this.baseDestination.dereferenceSubscriptionConsumerDispatcher(this, !this.isDurable(), bl);
        }
        if (bl2 && this.durableSubscriptionStats != null) {
            this.durableSubscriptionStats.terminate();
        }
        try {
            if (this.isDurable()) {
                if (this instanceof RemoteConsumerDispatcher) {
                    this.baseDestination.deleteRemoteDurableRME(this.dispatcherState);
                } else {
                    this.baseDestination.deleteRemoteDurableDME(this.dispatcherState.getSubscriberID());
                }
            }
        }
        catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
            FFDCFilter.processException((Throwable)sIDurableSubscriptionNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.deleteConsumerDispatcher", (String)"1:1802:1.253", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDurableSubscriptionNotFoundException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteConsumerDispatcher");
        }
    }

    public NonLockingCursor getBrowseCursor(Filter filter) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)filter);
        }
        NonLockingCursor nonLockingCursor = null;
        try {
            if (this.itemStream != null) {
                nonLockingCursor = this.itemStream.newNonLockingItemCursor(filter);
            } else if (this.subscription != null) {
                nonLockingCursor = this.subscription.newNonLockingCursor(filter);
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.getBrowseCursor", (String)"1:1837:1.253", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1844:1.253", messageStoreException});
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)((Object)messageStoreException));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1858:1.253", messageStoreException}, null), (Throwable)((Object)messageStoreException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)nonLockingCursor);
        }
        return nonLockingCursor;
    }

    public ConsumerDispatcherState getConsumerDispatcherState() {
        return this.dispatcherState;
    }

    protected final Object getReadyConsumerPointLock() {
        return this.readyConsumerPointLock;
    }

    public BaseDestinationHandler getDestination() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination");
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)this.baseDestination);
        }
        return this.baseDestination;
    }

    public MessageProcessor getMessageProcessor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this.messageProcessor);
        }
        return this.messageProcessor;
    }

    public String toString() {
        if (this.itemStream != null) {
            return "Dest CD: " + this.baseDestination.getName() + ":" + this.itemStream.toString();
        }
        if (this.subscription != null) {
            return "Dest CD: " + this.baseDestination.getName() + ":" + this.subscription.toString();
        }
        return "Dest CD: " + this.baseDestination.getName() + "null itemStream";
    }

    public void messageEventOccurred(int n, SIMPMessage sIMPMessage, Transaction transaction) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(n), sIMPMessage, transaction});
        }
        if (n == 2) {
            this.eventPostCommitAdd(sIMPMessage, transaction);
        } else if (3 == n) {
            this.eventPostCommitRemove(sIMPMessage);
        } else if (n == 5) {
            this.eventPostRollbackRemove(sIMPMessage, transaction);
        } else if (n == 6) {
            this.eventUnlocked(sIMPMessage);
        } else {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1971:1.253"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.messageEventOccurred", (String)"1:1977:1.253", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:1985:1.253"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    protected void eventPostCommitAdd(SIMPMessage sIMPMessage, Transaction transaction) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)new Object[]{sIMPMessage, transaction});
        }
        this.internalPut(sIMPMessage, transaction, null, true, true, true);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    protected void eventPostCommitRemove(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)new Object[]{sIMPMessage});
        }
        if (this.pToPStats != null) {
            this.pToPStats.onConsume(sIMPMessage);
        } else if (this.durableSubscriptionStats != null) {
            this.durableSubscriptionStats.onConsume(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void eventPostRollbackRemove(SIMPMessage sIMPMessage, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)new Object[]{sIMPMessage, transaction});
        }
        boolean bl = true;
        if (sIMPMessage.guessBackoutCount() >= this.exceptionRedeliveryThreshold) {
            sIMPMessage.deregisterMessageEventListener(5, this);
            sIMPMessage.deregisterMessageEventListener(4, this);
            UndeliverableReturnCode undeliverableReturnCode = null;
            try {
                undeliverableReturnCode = this.baseDestination.handleUndeliverableMessage(sIMPMessage, 35, new String[]{this.baseDestination.getName(), this.messageProcessor.getMessagingEngineName()});
            }
            catch (SIResourceException sIResourceException) {
                // empty catch block
            }
            sIMPMessage.registerMessageEventListener(5, this);
            sIMPMessage.registerMessageEventListener(4, this);
            if (undeliverableReturnCode == null || undeliverableReturnCode == UndeliverableReturnCode.ERROR) {
                this.messageProcessor.getAlarmManager().create(1000L, new ExceptionDestinationRetryHandler(sIMPMessage, this));
            }
            if (undeliverableReturnCode == UndeliverableReturnCode.BLOCK) {
                LinkedList linkedList = this.consumerPoints;
                synchronized (linkedList) {
                    Iterator iterator = this.consumerPoints.iterator();
                    while (iterator.hasNext()) {
                        ConsumerKey consumerKey = (ConsumerKey)iterator.next();
                        if (!consumerKey.filterMatches((AbstractItem)((Object)sIMPMessage))) continue;
                        ConsumerPoint consumerPoint = consumerKey.getConsumerPoint();
                        this.messageProcessor.getAlarmManager().create(SIMPConstants.BLOCKED_RETRY_TIMEOUT, new BlockedRetryHandler(consumerPoint));
                    }
                }
            }
            if (undeliverableReturnCode != UndeliverableReturnCode.BLOCK) {
                bl = false;
            }
        }
        if (bl) {
            try {
                if (!sIMPMessage.isPersistentlyLocked()) {
                    sIMPMessage.unlock(sIMPMessage.getLockID());
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.eventPostRollbackRemove", (String)"1:2153:1.253", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2160:1.253", messageStoreException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)((Object)messageStoreException));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher", "1:2171:1.253", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    protected void eventUnlocked(SIMPMessage sIMPMessage) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked", (Object)sIMPMessage);
        }
        this.internalPut(sIMPMessage, null, null, true, true, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    public void setReadyForUse() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReadyForUse");
        }
        this.state = SIMPState.READY_FOR_USE;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReadyForUse");
        }
    }

    public void activateDurableSubscriptionStats() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activateDurableSubscriptionStats");
        }
        this.durableSubscriptionStats = new DurableSubscriptionInstrumentation(this.baseDestination, this.dispatcherState, this.subscription);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activateDurableSubscriptionStats");
        }
    }

    void setPtoPStats(QueueInstrumentation queueInstrumentation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPtoPStats", (Object)queueInstrumentation);
        }
        this.pToPStats = queueInstrumentation;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setPtoPStats");
        }
    }

    public void setIsInMatchSpace() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setIsInMatchSpace");
        }
        this.isInMatchSpace = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setIsInMatchSpace");
        }
    }

    public boolean isLocked() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocked");
        }
        boolean bl2 = bl = this.state == SIMPState.LOCKED;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocked", (Object)new Boolean(bl));
        }
        return bl;
    }

    boolean isItemStreamEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isItemStreamEmpty");
        }
        boolean bl = false;
        boolean bl2 = bl = this.itemStream.getStatistics().getTotalItemCount() == 0L;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isItemStreamEmpty", (Object)new Boolean(bl));
        }
        return bl;
    }

    public SIBUuid8 getTargetMEUuid() {
        return this.messageProcessor.getMessagingEngineUuid();
    }

    public ReferenceStream getReferenceStream() {
        return this.subscription;
    }

    public ItemStream getItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getItemStream", (Object)this.itemStream);
        }
        return this.itemStream;
    }

    public boolean commitInsert(MessageItem messageItem) {
        return true;
    }

    public boolean rollbackInsert(MessageItem messageItem) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForDelete(DestinationHandler destinationHandler) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForDelete", (Object)destinationHandler);
        }
        Iterator iterator = null;
        Object object3 = this.consumerPoints;
        synchronized (object3) {
            object2 = this.readyConsumerPointLock;
            synchronized (object2) {
                iterator = this.consumerPoints.iterator();
                while (iterator.hasNext()) {
                    object = (ConsumerKey)iterator.next();
                    ((ConsumerKey)object).closeForDelete(destinationHandler);
                }
            }
            iterator = ((List)this.consumerPoints.clone()).iterator();
        }
        object3 = new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP0111", new Object[]{destinationHandler.getName(), this.messageProcessor.getMessagingEngineName()}, null));
        while (iterator.hasNext()) {
            object2 = (ConsumerKey)iterator.next();
            if (!((ConsumerKey)object2).isClosedDueToDelete()) continue;
            object = this.consumerPoints;
            synchronized (object) {
                this.consumerPoints.remove(object2);
            }
            ((ConsumerKey)object2).notifyConsumerPointAboutException((SIException)((Object)object3));
        }
        this.closeBrowsersDestinationDeleted(destinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForDelete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConsumersForReceiveExclusive() {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAllConsumersForReceiveExclusive");
        }
        Iterator iterator = null;
        Object object3 = this.consumerPoints;
        synchronized (object3) {
            object2 = this.readyConsumerPointLock;
            synchronized (object2) {
                iterator = this.consumerPoints.iterator();
                while (iterator.hasNext()) {
                    object = (ConsumerKey)iterator.next();
                    ((ConsumerKey)object).closeReceiveExclusive();
                }
            }
            iterator = ((List)this.consumerPoints.clone()).iterator();
        }
        object3 = new SIDestinationLockedException(nls.getFormattedMessage("DESTINATION_RECEIVE_EXCLUSIVE_CWSIP0114", new Object[]{this.getDestination().getName(), this.messageProcessor.getMessagingEngineName()}, null));
        while (iterator.hasNext()) {
            object2 = (ConsumerKey)iterator.next();
            object = this.consumerPoints;
            synchronized (object) {
                this.consumerPoints.remove(object2);
            }
            ((ConsumerKey)object2).notifyConsumerPointAboutException((SIException)((Object)object3));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAllConsumersForReceiveExclusive");
        }
    }

    void notifyReceiveAllowed(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{destinationHandler});
        }
        try {
            ReceiveAllowedThread receiveAllowedThread = this.getReceiveAllowedThread(destinationHandler);
            if (receiveAllowedThread != null) {
                this.messageProcessor.startNewThread(receiveAllowedThread);
            }
        }
        catch (InterruptedException interruptedException) {
            SibTr.exception((TraceComponent)tc, (Exception)interruptedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    private synchronized ReceiveAllowedThread getReceiveAllowedThread(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReceiveAllowedThread", (Object)destinationHandler);
        }
        if (this._receiveAllowedThread == null) {
            this._receiveAllowedThread = new ReceiveAllowedThread(destinationHandler);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getReceiveAllowedThread", (Object)this._receiveAllowedThread);
            }
            return this._receiveAllowedThread;
        }
        this._receiveAllowedThread.markForUpdate();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReceiveAllowedThread", null);
        }
        return null;
    }

    private synchronized boolean deleteReceiveAllowedThread() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteReceiveAllowedThread");
        }
        if (this._receiveAllowedThread.isMarkedForUpdate()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteReceiveAllowedThread", (Object)Boolean.FALSE);
            }
            return false;
        }
        this._receiveAllowedThread = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteReceiveAllowedThread", (Object)Boolean.TRUE);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachBrowser(BrowserSessionImpl browserSessionImpl) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachBrowser", (Object)browserSessionImpl);
        }
        LinkedList linkedList = this.browsers;
        synchronized (linkedList) {
            if (browserSessionImpl.getNamedDestination().isToBeDeleted() || browserSessionImpl.getNamedDestination().isDeleted()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachBrowser", (Object)"SINotPossibleInCurrentConfigurationException");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_32", new Object[]{this.baseDestination.getName(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            this.browsers.add(browserSessionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBrowser(BrowserSession browserSession) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"detachBrowser", (Object)browserSession);
        }
        LinkedList linkedList = this.browsers;
        synchronized (linkedList) {
            this.browsers.remove(browserSession);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"detachBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeBrowsersDestinationDeleted(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeBrowsersDestinationDeleted");
        }
        LinkedList linkedList = this.browsers;
        synchronized (linkedList) {
            Iterator iterator = this.browsers.iterator();
            while (iterator.hasNext()) {
                BrowserSessionImpl browserSessionImpl = (BrowserSessionImpl)iterator.next();
                boolean bl = browserSessionImpl._closeBrowserDestinationDeleted(destinationHandler);
                if (!bl) continue;
                iterator.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeBrowsersDestinationDeleted");
        }
    }

    public void registerForEventsPostAddItem(SIMPMessage sIMPMessage) {
    }

    public boolean isWLMGuess() {
        return this.isGuess;
    }

    public void setWLMGuess(boolean bl) {
        this.isGuess = bl;
    }

    public boolean dispatcherStateEquals(ConsumerDispatcherState consumerDispatcherState) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatcherStateEquals", (Object)consumerDispatcherState);
        }
        boolean bl2 = bl = this.dispatcherState == consumerDispatcherState;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatcherStateEquals", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isQHighLimit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQHighLimit");
        }
        boolean bl = this.itemStream.isQHighLimit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQHighLimit", (Object)new Boolean(bl));
        }
        return bl;
    }

    public SIBUuid12 getSubscriptionUuid() {
        return this.subscriptionUuid;
    }

    public OutputHandler getOutputHandler() {
        return this;
    }

    public ControlAdapter getControlAdapter() {
        return this.subscriptionControlAdaptor;
    }

    public void dereferenceControlAdapter() {
        this.subscriptionControlAdaptor.dereferenceControllable();
        this.subscriptionControlAdaptor = null;
    }

    public void createControlAdapter() {
        if (this._isPubSub) {
            this.subscriptionControlAdaptor = new LocalSubscriptionControl(this, (SIMPTopicSpaceControllable)((Object)this.baseDestination.getControlAdapter()), this.messageProcessor);
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public boolean isLocal() {
        return true;
    }

    boolean isPubSub() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)new Boolean(this._isPubSub));
        }
        return this._isPubSub;
    }

    protected boolean isReceiveAllowed(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed", (Object)destinationHandler);
        }
        boolean bl = true;
        if (!(destinationHandler.isToBeDeleted() || this.isPreMediated || destinationHandler.isReceiveAllowed())) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerKeyGroup joinKeyGroup(ConsumerKey consumerKey, OrderingContextImpl orderingContextImpl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"joinKeyGroup", (Object)new Object[]{consumerKey, orderingContextImpl});
        }
        ConsumerKeyGroup consumerKeyGroup = null;
        OrderingContextImpl orderingContextImpl2 = orderingContextImpl;
        synchronized (orderingContextImpl2) {
            Object object = this.readyConsumerPointLock;
            synchronized (object) {
                consumerKeyGroup = (ConsumerKeyGroup)this.keyGroups.get(orderingContextImpl);
                if (consumerKeyGroup == null) {
                    consumerKeyGroup = this.createConsumerKeyGroup();
                    this.keyGroups.put(orderingContextImpl, consumerKeyGroup);
                }
            }
            consumerKey.joinKeyGroup(consumerKeyGroup);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"joinKeyGroup", (Object)consumerKeyGroup);
        }
        return consumerKeyGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyGroup(ConsumerKeyGroup consumerKeyGroup) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeKeyGroup", (Object)consumerKeyGroup);
        }
        Object object = this.readyConsumerPointLock;
        synchronized (object) {
            this.keyGroups.remove(consumerKeyGroup);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeKeyGroup");
        }
    }

    int getExceptionRedeliveryThreshold() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExceptionRedeliveryThreshold");
            SibTr.exit((TraceComponent)tc, (String)"getExceptionRedeliveryThreshold", (Object)new Integer(this.exceptionRedeliveryThreshold));
        }
        return this.exceptionRedeliveryThreshold;
    }

    void setExceptionRedeliveryThreshold(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setExceptionRedeliveryThreshold", (Object)new Integer(n));
        }
        this.exceptionRedeliveryThreshold = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setExceptionRedeliveryThreshold");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ConsumerDispatcher.java, SIB.processor, WAS602.SIB, o0610.11 1.253");
        }
    }

    private class BlockedRetryHandler
    implements AlarmListener {
        private ConsumerPoint cp;

        public BlockedRetryHandler(ConsumerPoint consumerPoint) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"BlockedRetryHandler", (Object)consumerPoint);
            }
            this.cp = consumerPoint;
            consumerPoint.suspendConsumer();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"BlockedRetryHandler", (Object)this);
            }
        }

        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            this.cp.resumeConsumer();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    private class ExceptionDestinationRetryHandler
    implements AlarmListener {
        private SIMPMessage msg;
        private ConsumerDispatcher cd;
        private int wait_time = 1000;

        public ExceptionDestinationRetryHandler(SIMPMessage sIMPMessage, ConsumerDispatcher consumerDispatcher2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ExceptionDestinationRetryHandler", (Object)new Object[]{sIMPMessage, consumerDispatcher2});
            }
            this.msg = sIMPMessage;
            this.cd = consumerDispatcher2;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ExceptionDestinationRetryHandler", (Object)this);
            }
        }

        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            this.msg.deregisterMessageEventListener(5, this.cd);
            this.msg.deregisterMessageEventListener(4, this.cd);
            UndeliverableReturnCode undeliverableReturnCode = null;
            try {
                undeliverableReturnCode = ConsumerDispatcher.this.baseDestination.handleUndeliverableMessage(this.msg, 35, new String[]{ConsumerDispatcher.this.baseDestination.getName(), ConsumerDispatcher.this.messageProcessor.getMessagingEngineName()});
            }
            catch (SIResourceException sIResourceException) {
                // empty catch block
            }
            this.msg.registerMessageEventListener(5, this.cd);
            this.msg.registerMessageEventListener(4, this.cd);
            if (undeliverableReturnCode == null || undeliverableReturnCode == UndeliverableReturnCode.ERROR) {
                ConsumerDispatcher.this.messageProcessor.getAlarmManager().create(this.wait_time, this);
                this.wait_time = this.wait_time > 30000 ? 30000 : (this.wait_time *= 2);
            }
            if (undeliverableReturnCode == UndeliverableReturnCode.BLOCK) {
                try {
                    if (!this.msg.isPersistentlyLocked()) {
                        this.msg.unlock(this.msg.getLockID());
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.ExceptionDestinationRetryHandler.alarm", (String)"1:3089:1.253", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConsumerDispatcher.ExceptionDestinationRetryHandler", "1:3096:1.253", messageStoreException});
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)undeliverableReturnCode);
            }
        }
    }

    private class ReceiveAllowedThread
    implements Runnable {
        private DestinationHandler _destinationHandler;
        private boolean _rerunRequested = false;

        ReceiveAllowedThread(DestinationHandler destinationHandler) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ReceiveAllowedThread", (Object)new Object[]{destinationHandler});
            }
            this._destinationHandler = destinationHandler;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReceiveAllowedThread", (Object)this);
            }
        }

        public boolean isMarkedForUpdate() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isMarkedForUpdate");
            }
            boolean bl = this._rerunRequested;
            this._rerunRequested = false;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"isMarkedForUpdate", (Object)bl);
            }
            return bl;
        }

        public void markForUpdate() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"markForUpdate");
            }
            this._rerunRequested = true;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"markForUpdate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run", (Object)this);
            }
            boolean bl = true;
            while (bl) {
                boolean bl2 = ConsumerDispatcher.this.isReceiveAllowed(this._destinationHandler);
                Object object = ConsumerDispatcher.this.consumerPoints;
                synchronized (object) {
                    if (bl2 == ConsumerDispatcher.this.currentReceiveAllowed) {
                        ConsumerDispatcher.this.currentReceiveAllowed = !bl2;
                    }
                }
                while (bl2 != ConsumerDispatcher.this.currentReceiveAllowed) {
                    object = null;
                    Object object2 = ConsumerDispatcher.this.consumerPoints;
                    synchronized (object2) {
                        object = ((List)ConsumerDispatcher.this.consumerPoints.clone()).iterator();
                    }
                    while (object.hasNext()) {
                        object2 = (ConsumerKey)object.next();
                        ((ConsumerKey)object2).notifyReceiveAllowed(bl2, this._destinationHandler);
                    }
                    object2 = ConsumerDispatcher.this.consumerPoints;
                    synchronized (object2) {
                        ConsumerDispatcher.this.currentReceiveAllowed = bl2;
                        bl2 = ConsumerDispatcher.this.isReceiveAllowed(this._destinationHandler);
                    }
                }
                bl = !ConsumerDispatcher.this.deleteReceiveAllowedThread();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }
    }
}

