/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.processor.DestinationAvailability;
import com.ibm.ws.sib.processor.DestinationListener;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.processor.MulticastProperties;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionUnavailableException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPResourceException;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.AccessChecker;
import com.ibm.ws.sib.processor.impl.AliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BifurcatedConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.BrowserSessionImpl;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.processor.impl.DestinationConfigurationImpl;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DurableInputHandler;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.MulticastPropertiesImpl;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.ProducerSessionImpl;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIConnection;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MQLinkPubSubBridgeItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.utils.DestinationSessionUtils;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BifurcatedConsumerSession;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationConfiguration;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.OrderingContext;
import com.ibm.wsspi.sib.core.ProducerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SICoreUtils;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SIInvalidDestinationPrefixException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.Subject;

public final class ConnectionImpl
implements MPCoreConnection,
TransactionCallback {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private static final TraceComponent tc = SibTr.register((Class)ConnectionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SIMPTransactionManager _txManager;
    private List _connectionListeners;
    private boolean _closed;
    private List _producers;
    private List _consumers;
    private List _bifurcatedConsumers;
    private List _browsers;
    private List _temporaryDestinations;
    private List _ownedTransactions;
    private SIBUuid12 _uuid;
    private Subject _subject = null;
    private boolean _copyMessagesWhenSent = true;
    private boolean _copyMessagesWhenReceived = true;
    private boolean _setWaitTimeInMessage = true;
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private AccessChecker _accessChecker;
    private boolean _isBusSecure = false;

    ConnectionImpl(MessageProcessor messageProcessor, Subject subject) {
        if (tc.isEntryEnabled()) {
            String string = "<null>";
            if (subject != null) {
                string = "subject(" + messageProcessor.getAuthorisationUtils().getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"ConnectionImpl", (Object)new Object[]{messageProcessor, string});
        }
        this._messageProcessor = messageProcessor;
        this._subject = subject;
        this._isBusSecure = messageProcessor.isBusSecure();
        if (this._isBusSecure) {
            this._accessChecker = messageProcessor.getAccessChecker();
        }
        this._txManager = messageProcessor.getTXManager();
        this._destinationManager = messageProcessor.getDestinationManager();
        this._producers = new LinkedList();
        this._consumers = new LinkedList();
        this._bifurcatedConsumers = new LinkedList();
        this._browsers = new LinkedList();
        this._connectionListeners = new LinkedList();
        this._temporaryDestinations = new LinkedList();
        this._ownedTransactions = new LinkedList();
        this._uuid = new SIBUuid12();
        this._closed = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ConnectionImpl", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotClosed() throws SIConnectionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this._closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"Connection Closed exception");
                }
                SIMPConnectionUnavailableException sIMPConnectionUnavailableException = new SIMPConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null));
                sIMPConnectionUnavailableException.setExceptionReason(22);
                sIMPConnectionUnavailableException.setExceptionInserts(new String[]{this._messageProcessor.getMessagingEngineName()});
                throw sIMPConnectionUnavailableException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNotClosed");
        }
    }

    private void checkDestinationType(DestinationType destinationType, DestinationHandler destinationHandler, boolean bl, boolean bl2) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationType", (Object)new Object[]{destinationType, destinationHandler.getDestinationType()});
        }
        boolean bl3 = false;
        if (destinationHandler.isForeign() || destinationHandler.isForeignBus() || destinationHandler.isAlias() && destinationHandler.getDestinationType() == DestinationType.UNKNOWN) {
            bl3 = true;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Correct Type as destination is Foreign");
            }
        } else if (destinationHandler.isPubSub()) {
            if (destinationType == DestinationType.TOPICSPACE) {
                bl3 = true;
            }
        } else if (destinationType == destinationHandler.getDestinationType() || bl2 && destinationHandler.getName().startsWith("_PSIMP.TDRECEIVER")) {
            bl3 = true;
        }
        if (!bl3 && destinationType != null || (bl || bl2) ^ destinationHandler.isSystem()) {
            String string = "SYSTEM";
            if (destinationType != null) {
                string = destinationType.toString();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationType", (Object)("Destination is of wrong type " + string + ":" + destinationHandler.getDestinationType().toString()));
            }
            String string2 = this.locateCorrectMessage(destinationHandler.getDestinationType(), destinationType);
            SIMPNotPossibleInCurrentConfigurationException sIMPNotPossibleInCurrentConfigurationException = null;
            if (!string2.equals("DELIVERY_ERROR_SIRC_14")) {
                sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage(string2, new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(Integer.parseInt(string2.replaceFirst("DELIVERY_ERROR_SIRC_", "")));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()});
            } else {
                sIMPNotPossibleInCurrentConfigurationException = new SIMPNotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage(string2, new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName(), destinationHandler.getDestinationType().toString(), string}, null));
                sIMPNotPossibleInCurrentConfigurationException.setExceptionReason(14);
                sIMPNotPossibleInCurrentConfigurationException.setExceptionInserts(new String[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName(), destinationHandler.getDestinationType().toString(), string});
            }
            throw sIMPNotPossibleInCurrentConfigurationException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationType");
        }
    }

    private String locateCorrectMessage(DestinationType destinationType, DestinationType destinationType2) {
        if (destinationType == DestinationType.QUEUE) {
            if (destinationType2 == DestinationType.TOPICSPACE) {
                return "DELIVERY_ERROR_SIRC_2";
            }
            if (destinationType2 == DestinationType.SERVICE) {
                return "DELIVERY_ERROR_SIRC_3";
            }
            if (destinationType2 == DestinationType.PORT) {
                return "DELIVERY_ERROR_SIRC_4";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        if (destinationType == DestinationType.TOPICSPACE) {
            if (destinationType2 == DestinationType.QUEUE) {
                return "DELIVERY_ERROR_SIRC_11";
            }
            if (destinationType2 == DestinationType.SERVICE) {
                return "DELIVERY_ERROR_SIRC_12";
            }
            if (destinationType2 == DestinationType.PORT) {
                return "DELIVERY_ERROR_SIRC_13";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        if (destinationType == DestinationType.SERVICE) {
            if (destinationType2 == DestinationType.QUEUE) {
                return "DELIVERY_ERROR_SIRC_5";
            }
            if (destinationType2 == DestinationType.TOPICSPACE) {
                return "DELIVERY_ERROR_SIRC_6";
            }
            if (destinationType2 == DestinationType.PORT) {
                return "DELIVERY_ERROR_SIRC_7";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        if (destinationType == DestinationType.PORT) {
            if (destinationType2 == DestinationType.QUEUE) {
                return "DELIVERY_ERROR_SIRC_8";
            }
            if (destinationType2 == DestinationType.TOPICSPACE) {
                return "DELIVERY_ERROR_SIRC_9";
            }
            if (destinationType2 == DestinationType.SERVICE) {
                return "DELIVERY_ERROR_SIRC_10";
            }
            return "DELIVERY_ERROR_SIRC_14";
        }
        return "DELIVERY_ERROR_SIRC_14";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SIResourceException, SIConnectionLostException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"close", (Object)this);
        }
        this._messageProcessor.getConnectionLockManager().lock();
        try {
            this._close(true);
        }
        finally {
            this._messageProcessor.getConnectionLockManager().unlock();
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _close(boolean bl) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close", (Object)new Boolean(bl));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            Object object;
            Iterator iterator;
            if (this._closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"_close", (Object)"Returning as already closed");
                }
                return;
            }
            this._closed = true;
            List list = this._ownedTransactions;
            synchronized (list) {
                iterator = this._ownedTransactions.iterator();
                while (iterator.hasNext()) {
                    object = (ExternalLocalTransaction)iterator.next();
                    iterator.remove();
                    try {
                        object.rollback();
                    }
                    catch (SIException sIException) {}
                }
            }
            list = this._producers;
            synchronized (list) {
                iterator = this._producers.iterator();
                while (iterator.hasNext()) {
                    object = (ProducerSessionImpl)iterator.next();
                    iterator.remove();
                    ((ProducerSessionImpl)object)._close();
                }
            }
            list = this._bifurcatedConsumers;
            synchronized (list) {
                iterator = this._bifurcatedConsumers.iterator();
                while (iterator.hasNext()) {
                    object = (BifurcatedConsumerSessionImpl)iterator.next();
                    iterator.remove();
                    ((BifurcatedConsumerSessionImpl)object)._close();
                }
            }
            list = this._consumers;
            synchronized (list) {
                iterator = this._consumers.iterator();
                while (iterator.hasNext()) {
                    object = (ConsumerSessionImpl)iterator.next();
                    iterator.remove();
                    this._messageProcessor.removeConsumer((ConsumerSessionImpl)object);
                    ((ConsumerSessionImpl)object)._close();
                }
            }
            list = this._browsers;
            synchronized (list) {
                iterator = this._browsers.iterator();
                while (iterator.hasNext()) {
                    object = (BrowserSessionImpl)iterator.next();
                    iterator.remove();
                    ((BrowserSessionImpl)object)._close();
                }
            }
            list = this._temporaryDestinations;
            synchronized (list) {
                iterator = this._temporaryDestinations.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    try {
                        this._destinationManager.deleteTemporaryDestination(SIMPUtils.createJsDestinationAddress((String)object, this._messageProcessor.getMessagingEngineUuid()));
                    }
                    catch (SIException sIException) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    }
                    iterator.remove();
                }
            }
            if (bl) {
                list = this._connectionListeners;
                synchronized (list) {
                    iterator = this._connectionListeners.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                }
            }
            this._messageProcessor.removeConnection(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBrowserSession(BrowserSessionImpl browserSessionImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBrowserSession", (Object)browserSessionImpl);
        }
        List list = this._browsers;
        synchronized (list) {
            this._browsers.remove(browserSessionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBrowserSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConsumerSession(ConsumerSessionImpl consumerSessionImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerSession", (Object)consumerSessionImpl);
        }
        List list = this._consumers;
        synchronized (list) {
            this._consumers.remove(consumerSessionImpl);
        }
        this._messageProcessor.removeConsumer(consumerSessionImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProducerSession(ProducerSessionImpl producerSessionImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeProducerSession");
        }
        List list = this._producers;
        synchronized (list) {
            this._producers.remove(producerSessionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeProducerSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIUncoordinatedTransaction createUncoordinatedTransaction() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createUncoordinatedTransaction", (Object)this);
        }
        ExternalLocalTransaction externalLocalTransaction = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            externalLocalTransaction = this._txManager.createLocalTransaction();
            List list = this._ownedTransactions;
            synchronized (list) {
                this._ownedTransactions.add(externalLocalTransaction);
                externalLocalTransaction.registerCallback(this);
            }
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createUncoordinatedTransaction", (Object)externalLocalTransaction);
        }
        return externalLocalTransaction;
    }

    private void checkProducerSessionNullParameters(SIDestinationAddress sIDestinationAddress) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkProducerSessionNullParameters", (Object)sIDestinationAddress);
        }
        if (sIDestinationAddress == null) {
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls_cwsir.getFormattedMessage("CREATE_PRODUCER_CWSIR0051", null, null));
            sIMPIncorrectCallException.setExceptionReason(900);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.checkProducerSessionNullParameters", "1:907:1.282.1.6"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkProducerSessionNullParameters", (Object)((Object)sIMPIncorrectCallException));
            }
            throw sIMPIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkProducerSessionNullParameters", (Object)sIDestinationAddress);
        }
    }

    public ProducerSession createProducerSession(SIDestinationAddress sIDestinationAddress, String string, DestinationType destinationType, OrderingContext orderingContext, String string2) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)new Object[]{this, sIDestinationAddress, string2, string, destinationType, orderingContext, string});
        }
        this.checkNotClosed();
        this.checkProducerSessionNullParameters(sIDestinationAddress);
        SecurityContext securityContext = null;
        if (this._isBusSecure) {
            securityContext = new SecurityContext(this._subject, string2, string, this._messageProcessor.getAuthorisationUtils());
        }
        boolean bl = false;
        if (((JsDestinationAddress)sIDestinationAddress).isFromMediation()) {
            bl = true;
        }
        ProducerSession producerSession = this.internalCreateProducerSession(sIDestinationAddress, destinationType, sIDestinationAddress.getDestinationName(), sIDestinationAddress.getBusName(), false, securityContext, bl);
        if (string != null && producerSession != null) {
            ((ProducerSessionImpl)producerSession).disableDiscriminatorAccessCheckAtSend(string);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)producerSession);
        }
        return producerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProducerSession internalCreateProducerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, String string, String string2, boolean bl, SecurityContext securityContext, boolean bl2) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SITemporaryDestinationNotFoundException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateProducerSession", (Object)new Object[]{sIDestinationAddress, destinationType, string, string2, new Boolean(bl), securityContext, new Boolean(bl2)});
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!bl && string != null) {
            bl5 = string.startsWith("_T") || string.startsWith("_Q");
        }
        String string3 = string;
        JsDestinationAddress jsDestinationAddress = null;
        SIBUuid8 sIBUuid8 = null;
        DestinationHandler destinationHandler = null;
        if (bl5 || bl) {
            if (string2 == null || string2.equals(this._messageProcessor.getMessagingEngineBus())) {
                sIBUuid8 = SIMPUtils.parseME(string3);
                if (sIBUuid8 != null) {
                    boolean bl6 = bl4 = !sIBUuid8.equals((Object)this._messageProcessor.getMessagingEngineUuid());
                    if (bl4) {
                        jsDestinationAddress = SIMPUtils.createJsDestinationAddress(string, sIBUuid8);
                    }
                }
            } else {
                bl3 = true;
            }
        }
        if (bl4) {
            try {
                destinationHandler = this._destinationManager.getOrCreateRemoteSystemDestination(jsDestinationAddress.getDestinationName(), bl, bl5);
            }
            catch (SIResourceException sIResourceException) {
                if (!(sIResourceException instanceof SIMPResourceException)) {
                    SIMPResourceException sIMPResourceException = new SIMPResourceException(sIResourceException);
                    sIMPResourceException.setExceptionReason(901);
                    sIMPResourceException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateProducerSession", "1:1097:1.282.1.6", SIMPUtils.getStackTrace(sIResourceException)});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"internalCreateProducerSession", (Object)((Object)sIMPResourceException));
                    }
                    throw sIMPResourceException;
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateProducerSession", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        } else {
            destinationHandler = this._destinationManager.getDestination(string, string2, false);
        }
        this.checkDestinationType(destinationType, destinationHandler, bl & !bl3, bl4);
        if (this._isBusSecure) {
            this.checkProducerAuthority(destinationHandler, string, string2, securityContext, bl & !bl3, bl5 & !bl3);
        }
        ProducerSessionImpl producerSessionImpl = null;
        if (destinationHandler.isAlias()) {
            object = (AliasDestinationHandler)destinationHandler;
            jsDestinationAddress = ((AbstractAliasDestinationHandler)object).getRoutingDestination();
        } else if (destinationHandler.isForeign() || destinationHandler.isForeignBus()) {
            jsDestinationAddress = (JsDestinationAddress)sIDestinationAddress;
        }
        object = this;
        synchronized (object) {
            this.checkNotClosed();
            producerSessionImpl = new ProducerSessionImpl(sIDestinationAddress, jsDestinationAddress, destinationHandler, this, securityContext, bl2);
            List list = this._producers;
            synchronized (list) {
                this._producers.add(producerSessionImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateProducerSession", (Object)producerSessionImpl);
        }
        return producerSessionImpl;
    }

    public ProducerSession createProducerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)new Object[]{this, sIDestinationAddress, string, destinationType, orderingContext});
        }
        this.checkNotClosed();
        this.checkProducerSessionNullParameters(sIDestinationAddress);
        SecurityContext securityContext = null;
        if (this._isBusSecure) {
            securityContext = new SecurityContext(this._subject, string, null, this._messageProcessor.getAuthorisationUtils());
        }
        boolean bl = false;
        if (((JsDestinationAddress)sIDestinationAddress).isFromMediation()) {
            bl = true;
        }
        ProducerSession producerSession = this.internalCreateProducerSession(sIDestinationAddress, destinationType, sIDestinationAddress.getDestinationName(), sIDestinationAddress.getBusName(), false, securityContext, bl);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createProducerSession", (Object)producerSession);
        }
        return producerSession;
    }

    public ConsumerSession createMQInterOpConsumerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability, boolean bl, boolean bl2, Reliability reliability2, boolean bl3, String string, boolean bl4, boolean bl5) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSession", (Object)new Object[]{this, sIDestinationAddress, destinationType, selectionCriteria, reliability, new Boolean(bl), new Boolean(bl2), reliability2, new Boolean(bl3), string, new Boolean(bl4), new Boolean(bl5)});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(sIDestinationAddress);
        ConsumerSession consumerSession = this.internalCreateConsumerSession(sIDestinationAddress, string, destinationType, selectionCriteria, reliability, bl, bl2, bl4, bl5, reliability2, bl3, true);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSession", (Object)consumerSession);
        }
        return consumerSession;
    }

    private void checkTemporary(DestinationHandler destinationHandler, boolean bl) throws SITemporaryDestinationNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkTemporary", (Object)new Object[]{destinationHandler, new Boolean(bl)});
        }
        if (destinationHandler.isTemporary() && !bl && this._temporaryDestinations.indexOf(destinationHandler.getName()) == -1) {
            SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException = new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_CONNECTION_ERROR_CWSIP0099", new Object[]{destinationHandler.getName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
                SibTr.exit((TraceComponent)tc, (String)"checkTemporary", (Object)((Object)sITemporaryDestinationNotFoundException));
            }
            throw sITemporaryDestinationNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkTemporary");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerSession internalCreateConsumerSession(SIDestinationAddress sIDestinationAddress, String string, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability, boolean bl, boolean bl2, boolean bl3, boolean bl4, Reliability reliability2, boolean bl5, boolean bl6) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException, SITemporaryDestinationNotFoundException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)new Object[]{sIDestinationAddress, string, destinationType, destinationType, selectionCriteria, reliability, new Boolean(bl), new Boolean(bl2), new Boolean(bl3), reliability2, new Boolean(bl5), new Boolean(bl6)});
        }
        String string2 = sIDestinationAddress.getDestinationName();
        DestinationHandler destinationHandler = this._destinationManager.getDestination(string2, false);
        this.checkDestinationType(destinationType, destinationHandler, bl4, false);
        if (destinationHandler.getDestinationType() == DestinationType.SERVICE && !((JsDestinationAddress)sIDestinationAddress).isFromMediation()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)"cannot browse a service destination");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INVALID_DESTINATION_USAGE_ERROR_CWSIP0021", new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        this.checkTemporary(destinationHandler, bl6);
        if (this._isBusSecure) {
            object = new SecurityContext(this._subject, string, null, this._messageProcessor.getAuthorisationUtils());
            this.checkConsumerAuthority(destinationHandler, string2, selectionCriteria == null ? null : selectionCriteria.getDiscriminator(), (SecurityContext)object, bl4);
        }
        object = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            ConsumerDispatcherState consumerDispatcherState = new ConsumerDispatcherState(null, destinationHandler.getUuid(), selectionCriteria, bl2, "", destinationHandler.getName(), destinationHandler.getBus());
            consumerDispatcherState.setUser(this.getResolvedUserid(), this.isSIBServerSubject());
            try {
                object = new ConsumerSessionImpl(destinationHandler, sIDestinationAddress, consumerDispatcherState, this, bl, bl3, reliability2, bl5);
            }
            catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
                FFDCFilter.processException((Throwable)sIDurableSubscriptionNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:1494:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDurableSubscriptionNotFoundException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)sIDurableSubscriptionNotFoundException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1505:1.282.1.6", sIDurableSubscriptionNotFoundException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1514:1.282.1.6", sIDurableSubscriptionNotFoundException}, null), (Throwable)sIDurableSubscriptionNotFoundException);
            }
            catch (SIDurableSubscriptionMismatchException sIDurableSubscriptionMismatchException) {
                FFDCFilter.processException((Throwable)sIDurableSubscriptionMismatchException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:1526:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDurableSubscriptionMismatchException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)sIDurableSubscriptionMismatchException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1537:1.282.1.6", sIDurableSubscriptionMismatchException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1546:1.282.1.6", sIDurableSubscriptionMismatchException}, null), (Throwable)sIDurableSubscriptionMismatchException);
            }
            catch (SISessionUnavailableException sISessionUnavailableException) {
                FFDCFilter.processException((Throwable)sISessionUnavailableException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSession", (String)"1:1558:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)((Object)sISessionUnavailableException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1569:1.282.1.6", sISessionUnavailableException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:1578:1.282.1.6", sISessionUnavailableException}, null), (Throwable)sISessionUnavailableException);
            }
            List list = this._consumers;
            synchronized (list) {
                this._consumers.add(object);
            }
            this._messageProcessor.addConsumer((ConsumerSessionImpl)object);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSession", (Object)object);
        }
        return object;
    }

    public void createDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, String string3) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException, SIDurableSubscriptionAlreadyExistsException {
        Object object;
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription", (Object)new Object[]{this, string, string2, sIDestinationAddress, string3, selectionCriteria, new Boolean(bl), new Boolean(bl2)});
        }
        SIBUuid8 sIBUuid8 = this.checkDurableSubscriptionInformation(string, string2, sIDestinationAddress, bl, bl2, false, false);
        DestinationHandler destinationHandler = null;
        try {
            destinationHandler = this._destinationManager.getDestination((JsDestinationAddress)sIDestinationAddress, false);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DURABLE_SUBSCRIPTION_USAGE_ERROR_CWSIP0098", new Object[]{string, sIDestinationAddress.getDestinationName()}, null));
        }
        if (!destinationHandler.isPubSub()) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription", (Object)"Destination not a topicspace");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_USEAGE_ERROR_CWSIP0141", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName(), string}, null));
        }
        if (destinationHandler.isTemporary()) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription", (Object)"Destination is Temporary");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DURABLE_SUBSCRIPTION_USAGE_ERROR_CWSIP0098", new Object[]{string, sIDestinationAddress.getDestinationName()}, null));
        }
        if (this._isBusSecure) {
            object = new SecurityContext(this._subject, string3, null, this._messageProcessor.getAuthorisationUtils());
            this.checkConsumerAuthority(destinationHandler, sIDestinationAddress.getDestinationName(), selectionCriteria == null ? null : selectionCriteria.getDiscriminator(), (SecurityContext)object, false);
        }
        object = new ConsumerDispatcherState(string, destinationHandler.getUuid(), selectionCriteria, bl2, string2, destinationHandler.getName(), destinationHandler.getBus());
        ((ConsumerDispatcherState)object).setIsCloned(bl);
        if (string3 == null) {
            ((ConsumerDispatcherState)object).setUser(this.getResolvedUserid(), this.isSIBServerSubject());
        } else {
            ((ConsumerDispatcherState)object).setUser(string3, false);
        }
        if (sIBUuid8.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
            destinationHandler.createDurableSubscription((ConsumerDispatcherState)object, null);
        } else {
            DurableInputHandler.createRemoteDurableSubscription(this._messageProcessor, (ConsumerDispatcherState)object, new MessagingEngine(sIBUuid8), destinationHandler.getUuid());
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createDurableSubscription");
        }
    }

    public ConsumerSession createConsumerSessionForDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, Reliability reliability, boolean bl3, Reliability reliability2, boolean bl4, String string3) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException, SIIncorrectCallException, SIResourceException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSessionForDurableSubscription", (Object)new Object[]{this, string, string2, sIDestinationAddress, selectionCriteria, new Boolean(bl), new Boolean(bl2), reliability, new Boolean(bl3), reliability2, new Boolean(bl4), string3});
        }
        ConsumerSession consumerSession = this.internalCreateConsumerSessionForDurableSubscription(string, string2, sIDestinationAddress, selectionCriteria, bl, bl2, reliability, bl3, reliability2, bl4, string3, false);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSessionForDurableSubscription", (Object)consumerSession);
        }
        return consumerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerSession internalCreateConsumerSessionForDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, Reliability reliability, boolean bl3, Reliability reliability2, boolean bl4, String string3, boolean bl5) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)new Object[]{string, string2, sIDestinationAddress, string3, selectionCriteria, new Boolean(bl), new Boolean(bl2), reliability, new Boolean(bl3), reliability2});
        }
        SIBUuid8 sIBUuid8 = this.checkDurableSubscriptionInformation(string, string2, sIDestinationAddress, bl, bl2, false, true);
        HashMap hashMap = this._destinationManager.getDurableSubscriptionsTable();
        ConsumerDispatcher consumerDispatcher = null;
        if (sIBUuid8.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
            object = hashMap;
            synchronized (object) {
                consumerDispatcher = (ConsumerDispatcher)hashMap.get(string);
                if (consumerDispatcher == null) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription");
                    }
                    throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{string, this._messageProcessor.getMessagingEngineName()}, null));
                }
            }
        }
        object = null;
        try {
            object = this._destinationManager.getDestination((JsDestinationAddress)sIDestinationAddress, false);
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIDurableSubscriptionMismatchException");
            }
            throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("DURABLE_MISMATCH_ERROR_CWSIP0025", new Object[]{sIDestinationAddress.getDestinationName(), consumerDispatcher.getDestination() == null ? null : consumerDispatcher.getDestination().getName(), string, this._messageProcessor.getMessagingEngineName()}, null));
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIDurableSubscriptionMismatchException");
            }
            throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("DURABLE_MISMATCH_ERROR_CWSIP0025", new Object[]{sIDestinationAddress.getDestinationName(), consumerDispatcher.getDestination() == null ? null : consumerDispatcher.getDestination().getName(), string, this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (!object.isPubSub()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"Destination not a topicspace");
            }
            throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("DESTINATION_USEAGE_ERROR_CWSIP0141", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName(), string}, null));
        }
        ConsumerDispatcherState consumerDispatcherState = new ConsumerDispatcherState(string, object.getUuid(), selectionCriteria, bl2, string2, object.getName(), object.getBus());
        consumerDispatcherState.setIsCloned(bl);
        if (string3 == null) {
            consumerDispatcherState.setUser(this.getResolvedUserid(), this.isSIBServerSubject());
        } else {
            consumerDispatcherState.setUser(string3, false);
        }
        ConsumerSessionImpl consumerSessionImpl = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            try {
                consumerSessionImpl = new ConsumerSessionImpl((DestinationHandler)object, sIDestinationAddress, consumerDispatcherState, this, bl3, bl5, reliability2, bl4);
            }
            catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException((Throwable)sINotPossibleInCurrentConfigurationException);
            }
            catch (SISessionUnavailableException sISessionUnavailableException) {
                FFDCFilter.processException((Throwable)sISessionUnavailableException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSessionForDurableSubscription", (String)"1:1999:1.282.1.6", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2005:1.282.1.6", sISessionUnavailableException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2016:1.282.1.6", sISessionUnavailableException}, null), (Throwable)sISessionUnavailableException);
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.internalCreateConsumerSessionForDurableSubscription", (String)"1:2028:1.282.1.6", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2034:1.282.1.6", sITemporaryDestinationNotFoundException});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2045:1.282.1.6", sITemporaryDestinationNotFoundException}, null), (Throwable)sITemporaryDestinationNotFoundException);
            }
            List list = this._consumers;
            synchronized (list) {
                this._consumers.add(consumerSessionImpl);
            }
            this._messageProcessor.addConsumer(consumerSessionImpl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalCreateConsumerSessionForDurableSubscription", (Object)consumerSessionImpl);
        }
        return consumerSessionImpl;
    }

    public ConsumerSession createMQInterOpConsumerSessionForDurableSubscription(String string, String string2, SIDestinationAddress sIDestinationAddress, SelectionCriteria selectionCriteria, boolean bl, boolean bl2, Reliability reliability, boolean bl3, Reliability reliability2, boolean bl4, String string3, boolean bl5) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDurableSubscriptionMismatchException, SIDestinationLockedException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSessionForDurableSubscription", (Object)new Object[]{this, string, string2, sIDestinationAddress, selectionCriteria, new Boolean(bl), new Boolean(bl2), reliability, new Boolean(bl3), reliability2, new Boolean(bl4), string3, new Boolean(bl5)});
        }
        ConsumerSession consumerSession = this.internalCreateConsumerSessionForDurableSubscription(string, string2, sIDestinationAddress, selectionCriteria, bl, bl2, reliability, bl3, reliability2, bl4, string3, bl5);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQInterOpConsumerSessionForDurableSubscription", (Object)consumerSession);
        }
        return consumerSession;
    }

    private SIBUuid8 checkDurableSubscriptionInformation(String string, String string2, SIDestinationAddress sIDestinationAddress, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SIIncorrectCallException, SIConnectionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)new Object[]{string, sIDestinationAddress, new Boolean(bl), new Boolean(bl2)});
        }
        this.checkNotClosed();
        if (string == null) {
            String string3 = "CREATE_DURABLE_SUB_CWSIR0042";
            if (bl4) {
                string3 = "CREATE_DURABLE_SUB_CWSIR0032";
            } else if (bl3) {
                string3 = "DELETE_DURABLE_SUB_CWSIR0061";
            }
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage(string3, null, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (sIDestinationAddress == null && !bl3) {
            String string4 = "CREATE_DURABLE_SUB_CWSIR0041";
            if (bl4) {
                string4 = "CREATE_DURABLE_SUB_CWSIR0031";
            }
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage(string4, null, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBUuid8 sIBUuid8 = this._messageProcessor.mapMeNameToUuid(string2);
        if (sIBUuid8 == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)"SIMENotFoundException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("REMOTE_ME_MAPPING_ERROR_CWSIP0156", new Object[]{string2}, null));
        }
        if (bl2 && bl) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("INVALID_PARAMETER_COMBINATION_ERROR_CWSIP0100", new Object[]{string, sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDurableSubscriptionInformation", (Object)sIBUuid8);
        }
        return sIBUuid8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDurableSubscription(String string, String string2) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)new Object[]{this, string, string2});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            SIBUuid8 sIBUuid8 = this.checkDurableSubscriptionInformation(string, string2, null, false, false, true, false);
            HashMap hashMap = this._destinationManager.getDurableSubscriptionsTable();
            if (sIBUuid8.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
                HashMap hashMap2 = hashMap;
                synchronized (hashMap2) {
                    String string3;
                    ConsumerDispatcherState consumerDispatcherState;
                    boolean bl;
                    ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)hashMap.get(string);
                    if (consumerDispatcher == null) {
                        if (CoreSPIConnection.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription");
                        }
                        throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{string, this._messageProcessor.getMessagingEngineName()}, null));
                    }
                    BaseDestinationHandler baseDestinationHandler = consumerDispatcher.getDestination();
                    if (!baseDestinationHandler.isPubSub()) {
                        if (CoreSPIConnection.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)"SIDestinationWrongTypeException");
                        }
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:2313:1.282.1.6"});
                        throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:2319:1.282.1.6"}, null));
                    }
                    if (this._isBusSecure && !(bl = (consumerDispatcherState = consumerDispatcher.getConsumerDispatcherState()).equalUser(string3 = this.getResolvedUserid(), this.isSIBServerSubject()))) {
                        if (CoreSPIConnection.tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription", (Object)"SINotAuthorizedException");
                        }
                        throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_DELETE_ERROR_CWSIP0311", new Object[]{string3, string, baseDestinationHandler.getName()}, null));
                    }
                    baseDestinationHandler.deleteDurableSubscription(string, null, string2);
                }
            } else {
                DurableInputHandler.deleteRemoteDurableSub(this._messageProcessor, string, this.getResolvedUserid(), new MessagingEngine(sIBUuid8));
            }
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteDurableSubscription");
        }
    }

    private void checkSendNullParameters(SIDestinationAddress sIDestinationAddress, SIBusMessage sIBusMessage) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkSendNullParameters", (Object)new Object[]{sIDestinationAddress, sIBusMessage});
        }
        if (sIDestinationAddress == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkSendNullParameters", (Object)"SIIncorrectCallException - null destAddr");
            }
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls_cwsir.getFormattedMessage("SEND_CWSIR0111", null, null));
            sIMPIncorrectCallException.setExceptionReason(900);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.checkSendNullParameters", "1:2382:1.282.1.6"});
            throw sIMPIncorrectCallException;
        }
        if (sIBusMessage == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkSendNullParameters", (Object)"SIIncorrectCallException - null msg");
            }
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls_cwsir.getFormattedMessage("SEND_CWSIR0112", null, null));
            sIMPIncorrectCallException.setExceptionReason(900);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl.checkSendNullParameters", "1:2397:1.282.1.6"});
            throw sIMPIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkSendNullParameters");
        }
    }

    private void internalSend(SIBusMessage sIBusMessage, SITransaction sITransaction, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string, boolean bl) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalSend", (Object)new Object[]{sIBusMessage, sITransaction, sIDestinationAddress, destinationType, string, orderingContext, new Boolean(bl)});
        }
        this.checkNotClosed();
        this.checkSendNullParameters(sIDestinationAddress, sIBusMessage);
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIMPIncorrectCallException sIMPIncorrectCallException = new SIMPIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_16", new Object[]{sIDestinationAddress}, null));
            sIMPIncorrectCallException.setExceptionReason(16);
            sIMPIncorrectCallException.setExceptionInserts(new String[]{sIDestinationAddress.toString()});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalSend", (Object)((Object)sIMPIncorrectCallException));
            }
            throw sIMPIncorrectCallException;
        }
        SecurityContext securityContext = null;
        if (this._isBusSecure) {
            securityContext = new SecurityContext(this._subject, string, null, this._messageProcessor.getAuthorisationUtils());
        }
        ProducerSession producerSession = this.internalCreateProducerSession(sIDestinationAddress, destinationType, sIDestinationAddress.getDestinationName(), sIDestinationAddress.getBusName(), bl, securityContext, false);
        try {
            producerSession.send(sIBusMessage, sITransaction);
            producerSession.close();
        }
        catch (SISessionUnavailableException sISessionUnavailableException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
            this.checkNotClosed();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalSend", (Object)((Object)sISessionUnavailableException));
            }
            throw new SIConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null), (Throwable)sISessionUnavailableException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalSend");
        }
    }

    public void send(SIBusMessage sIBusMessage, SITransaction sITransaction, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"send", (Object)new Object[]{this, sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, string});
        }
        this.internalSend(sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, string, false);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"send");
        }
    }

    public SIBusMessage receiveNoWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"receiveNoWait", (Object)new Object[]{this, sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, string});
        }
        SIBusMessage sIBusMessage = this.internalReceiveNoWait(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, string, false);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"receiveNoWait", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    private SIBusMessage internalReceiveNoWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, String string, boolean bl) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)new Object[]{sIDestinationAddress, string, destinationType, selectionCriteria, sITransaction, reliability2, reliability, new Boolean(bl)});
        }
        if (sIDestinationAddress == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_NO_WAIT_CWSIR0091", null, null));
        }
        SIBusMessage sIBusMessage = null;
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777", new Object[]{sIDestinationAddress}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        try {
            ConsumerSession consumerSession = this.internalCreateConsumerSession(sIDestinationAddress, string, destinationType, selectionCriteria, reliability2, false, false, false, bl, reliability, false, false);
            consumerSession.start(false);
            sIBusMessage = consumerSession.receiveNoWait(sITransaction);
            consumerSession.close();
        }
        catch (SISessionUnavailableException sISessionUnavailableException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
            this.checkNotClosed();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)((Object)sISessionUnavailableException));
            }
            throw new SIConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null), (Throwable)sISessionUnavailableException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalReceiveNoWait", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    private SIBusMessage internalReceiveWithWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, long l, String string, boolean bl) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)new Object[]{sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, new Long(l), string, new Boolean(bl)});
        }
        if (sITransaction != null && !((Transaction)sITransaction).isAlive()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TRANSACTION_RECEIVE_USAGE_ERROR_CWSIP0777", new Object[]{sIDestinationAddress}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBusMessage sIBusMessage = null;
        try {
            ConsumerSession consumerSession = this.internalCreateConsumerSession(sIDestinationAddress, string, destinationType, selectionCriteria, reliability2, false, false, false, bl, reliability, false, false);
            consumerSession.start(false);
            sIBusMessage = consumerSession.receiveWithWait(sITransaction, l);
            consumerSession.close();
        }
        catch (SISessionUnavailableException sISessionUnavailableException) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
            this.checkNotClosed();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)((Object)sISessionUnavailableException));
            }
            throw new SIConnectionUnavailableException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_22", new Object[]{this._messageProcessor.getMessagingEngineName()}, null), (Throwable)sISessionUnavailableException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalReceiveWithWait", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    public SIBusMessage receiveWithWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, long l, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"receiveWithWait", (Object)new Object[]{this, new Long(l), sIDestinationAddress, string, destinationType, selectionCriteria, sITransaction, reliability2, reliability});
        }
        if (sIDestinationAddress == null) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"receiveWithWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_WITH_WAIT_CWSIR0101", null, null));
        }
        SIBusMessage sIBusMessage = this.internalReceiveWithWait(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, l, string, false);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"receiveWithWait", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    private void checkBrowserSessionNullParameters(SIDestinationAddress sIDestinationAddress) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBrowserSessionNullParameters", (Object)sIDestinationAddress);
        }
        if (sIDestinationAddress == null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("BROWSE_METHOD_CWSIR0001", null, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkBrowserSessionNullParameters", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBrowserSessionNullParameters");
        }
    }

    public BrowserSession createBrowserSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SITemporaryDestinationNotFoundException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createBrowserSession", (Object)new Object[]{this, sIDestinationAddress, destinationType, selectionCriteria});
        }
        this.checkNotClosed();
        this.checkBrowserSessionNullParameters(sIDestinationAddress);
        BrowserSession browserSession = this.createBrowserSession(sIDestinationAddress, destinationType, selectionCriteria, false, string);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBrowserSession", (Object)browserSession);
        }
        return browserSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrowserSession createBrowserSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, boolean bl, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBrowserSession", (Object)new Object[]{sIDestinationAddress, destinationType, selectionCriteria});
        }
        MessageSelectorFilter messageSelectorFilter = null;
        DestinationHandler destinationHandler = this._destinationManager.getDestination((JsDestinationAddress)sIDestinationAddress, false);
        this.checkDestinationType(destinationType, destinationHandler, bl, false);
        if (destinationHandler.getDestinationType() == DestinationType.SERVICE) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createBrowserSession", (Object)"cannot browse a service destination");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INVALID_DESTINATION_USAGE_ERROR_CWSIP0022", new Object[]{destinationHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        this.checkTemporary(destinationHandler, false);
        if (this._isBusSecure) {
            object = new SecurityContext(this._subject, string, null, this._messageProcessor.getAuthorisationUtils());
            this.checkBrowseAuthority(destinationHandler, sIDestinationAddress.getDestinationName(), (SecurityContext)object, bl);
        }
        if (destinationHandler.isPubSub()) {
            destinationHandler = null;
        } else if (selectionCriteria != null && (selectionCriteria.getSelectorString() != null && !selectionCriteria.getSelectorString().equals("") || selectionCriteria.getDiscriminator() != null && !selectionCriteria.getDiscriminator().equals(""))) {
            messageSelectorFilter = new MessageSelectorFilter(this._messageProcessor, selectionCriteria);
        }
        object = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            object = new BrowserSessionImpl(destinationHandler, messageSelectorFilter, this, sIDestinationAddress);
            List list = this._browsers;
            synchronized (list) {
                this._browsers.add(object);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBrowserSession", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(SICoreConnectionListener sICoreConnectionListener) throws SIConnectionUnavailableException, SIConnectionDroppedException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"addConnectionListener", (Object)new Object[]{this, sICoreConnectionListener});
        }
        this.checkNotClosed();
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.add(sICoreConnectionListener);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"addConnectionListener");
        }
    }

    MessageProcessor getMessageProcessor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    SIBUuid12 getUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._uuid);
        }
        return this._uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress createTemporaryDestination(Distribution distribution, String string) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIInvalidDestinationPrefixException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)new Object[]{this, string, distribution});
        }
        this.checkNotClosed();
        if (!SICoreUtils.isDestinationPrefixValid((String)string)) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)"SIInvalidDestinationPrefixException");
            }
            throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INVALID_DESTINATION_PREFIX_ERROR_CWSIP0038", new Object[]{string}, null));
        }
        SIDestinationAddress sIDestinationAddress = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            Object object;
            if (this._isBusSecure && !this._accessChecker.checkDestinationAccess((SecurityContext)(object = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils())), null, string == null ? "" : string, OperationType.CREATE)) {
                if (CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)"not authorized to create this destination");
                }
                String string2 = ((SecurityContext)object).getUserName(true);
                String string3 = nls.getFormattedMessage("USER_NOT_AUTH_CREATE_ERROR_CWSIP0305", new Object[]{string, string2}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(string, string2, OperationType.CREATE, string3);
                throw new SINotAuthorizedException(string3);
            }
            object = this._temporaryDestinations;
            synchronized (object) {
                try {
                    sIDestinationAddress = this._destinationManager.createTemporaryDestination(distribution, string);
                }
                catch (SIMPDestinationAlreadyExistsException sIMPDestinationAlreadyExistsException) {
                    FFDCFilter.processException((Throwable)((Object)sIMPDestinationAlreadyExistsException), (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createTemporaryDestination", (String)"1:3192:1.282.1.6", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:3198:1.282.1.6", sIMPDestinationAlreadyExistsException});
                    if (CoreSPIConnection.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)"SIErrorException");
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:3209:1.282.1.6", sIMPDestinationAlreadyExistsException}, null), (Throwable)((Object)sIMPDestinationAlreadyExistsException));
                }
                this._temporaryDestinations.add(sIDestinationAddress.getDestinationName());
            }
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createTemporaryDestination", (Object)sIDestinationAddress);
        }
        return sIDestinationAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTemporaryDestination(SIDestinationAddress sIDestinationAddress) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIIncorrectCallException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"deleteTemporaryDestination", (Object)new Object[]{this, sIDestinationAddress});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            if (sIDestinationAddress == null) {
                SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("CREATE_PRODUCER_CWSIR0071", null, null));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)((Object)sIIncorrectCallException));
                }
                throw sIIncorrectCallException;
            }
            List list = this._temporaryDestinations;
            synchronized (list) {
                int n = this._temporaryDestinations.indexOf(sIDestinationAddress.getDestinationName());
                if (n == -1) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteTemporaryDestination", (Object)"SITemporaryDestinationNotFoundException");
                    }
                    throw new SITemporaryDestinationNotFoundException(nls.getFormattedMessage("TEMPORARY_DESTINATION_NAME_ERROR_CWSIP0097", new Object[]{sIDestinationAddress}, null));
                }
                this._destinationManager.deleteTemporaryDestination((JsDestinationAddress)sIDestinationAddress);
                this._temporaryDestinations.remove(n);
            }
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"deleteTemporaryDestination");
        }
    }

    public SIXAResource getSIXAResource() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getSIXAResource", (Object)this);
        }
        this.checkNotClosed();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getSIXAResource");
        }
        return this._txManager.createXAResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SICoreConnection cloneConnection() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"cloneConnection", (Object)this);
        }
        SICoreConnection sICoreConnection = null;
        this._messageProcessor.getConnectionLockManager().lock();
        try {
            ConnectionImpl connectionImpl = this;
            synchronized (connectionImpl) {
                this.checkNotClosed();
                sICoreConnection = this._messageProcessor.createConnection(this._subject, false);
            }
        }
        finally {
            this._messageProcessor.getConnectionLockManager().unlock();
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"cloneConnection", (Object)sICoreConnection);
        }
        return sICoreConnection;
    }

    public boolean isEquivalentTo(SICoreConnection sICoreConnection) {
        ConnectionImpl connectionImpl;
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"isEquivalentTo", (Object)new Object[]{this, sICoreConnection});
        }
        boolean bl = false;
        if (sICoreConnection instanceof ConnectionImpl && (connectionImpl = (ConnectionImpl)sICoreConnection).getMessageProcessor() == this.getMessageProcessor()) {
            boolean bl2 = this._subject == null ? connectionImpl.getSecuritySubject() == null : (bl = this._subject.equals(connectionImpl.getSecuritySubject()));
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"isEquivalentTo", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getMeName() {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getMeName", (Object)this);
        }
        String string = this._messageProcessor.getMessagingEngineName();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getMeName", (Object)string);
        }
        return string;
    }

    public String getMeUuid() {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getMeUuid", (Object)this);
        }
        SIBUuid8 sIBUuid8 = this._messageProcessor.getMessagingEngineUuid();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getMeUuid", (Object)sIBUuid8);
        }
        return sIBUuid8.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(SICoreConnectionListener sICoreConnectionListener) {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"removeConnectionListener", (Object)new Object[]{this, sICoreConnectionListener});
        }
        List list = this._connectionListeners;
        synchronized (list) {
            this._connectionListeners.remove(sICoreConnectionListener);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"removeConnectionListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SICoreConnectionListener[] getConnectionListeners() {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getConnectionListeners", (Object)this);
        }
        SICoreConnectionListener[] sICoreConnectionListenerArray = null;
        List list = this._connectionListeners;
        synchronized (list) {
            SICoreConnectionListener[] sICoreConnectionListenerArray2 = new SICoreConnectionListener[this._connectionListeners.size()];
            sICoreConnectionListenerArray = this._connectionListeners.toArray(sICoreConnectionListenerArray2);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getConnectionListeners", (Object)sICoreConnectionListenerArray);
        }
        return sICoreConnectionListenerArray;
    }

    public String getApiLevelDescription() {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getApiLevelDescription", (Object)this);
        }
        String string = this._messageProcessor.getApiLevelDescription();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getApiLevelDescription", (Object)string);
        }
        return string;
    }

    public long getApiMajorVersion() {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getApiMajorVersion", (Object)this);
        }
        long l = this._messageProcessor.getApiMajorVersion();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getApiMajorVersion", (Object)new Long(l));
        }
        return l;
    }

    public long getApiMinorVersion() {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getApiMinorVersion", (Object)this);
        }
        long l = this._messageProcessor.getApiMinorVersion();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getApiMinorVersion", (Object)new Long(l));
        }
        return l;
    }

    public void beforeCompletion(Transaction transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(Transaction transaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{transaction, new Boolean(bl)});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (!this._closed) {
                List list = this._ownedTransactions;
                synchronized (list) {
                    this._ownedTransactions.remove(transaction);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public byte[] createUniqueId() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createUniqueId", (Object)this);
        }
        this.checkNotClosed();
        SIBUuid12 sIBUuid12 = new SIBUuid12();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createUniqueId", (Object)sIBUuid12);
        }
        return sIBUuid12.toByteArray();
    }

    public DestinationConfiguration getDestinationConfiguration(SIDestinationAddress sIDestinationAddress) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getDestinationConfiguration", (Object)new Object[]{this, sIDestinationAddress});
        }
        this.checkNotClosed();
        if (sIDestinationAddress == null) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getDestinationConfiguration", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("GET_DEST_CONFIG_CWSIR0081", null, null));
        }
        DestinationConfigurationImpl destinationConfigurationImpl = null;
        DestinationHandler destinationHandler = this._destinationManager.getDestination((JsDestinationAddress)sIDestinationAddress, false);
        if (sIDestinationAddress.isTemporary()) {
            DestinationType destinationType = DestinationType.QUEUE;
            if (sIDestinationAddress.getDestinationName().startsWith("_T")) {
                destinationType = DestinationType.TOPICSPACE;
            }
            boolean bl = false;
            String string = sIDestinationAddress.getBusName();
            if (string != null && !string.equals(this._messageProcessor.getMessagingEngineBus())) {
                bl = true;
            }
            if (this._isBusSecure) {
                SecurityContext securityContext = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils());
                if (!bl) {
                    this.checkInquireAuthority(destinationHandler, sIDestinationAddress.getDestinationName(), null, securityContext, true);
                } else {
                    this.checkInquireAuthority(destinationHandler, null, string, securityContext, false);
                }
            }
            destinationConfigurationImpl = new DestinationConfigurationImpl(0, Reliability.EXPRESS_NONPERSISTENT, null, null, destinationType, null, 0, Reliability.EXPRESS_NONPERSISTENT, sIDestinationAddress.getDestinationName(), null, false, true, true, true, null, null);
        } else if (destinationHandler.isForeignBus()) {
            if (this._isBusSecure) {
                SecurityContext securityContext = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils());
                String string = destinationHandler.getName();
                this.checkInquireAuthority(destinationHandler, null, string, securityContext, false);
            }
            destinationConfigurationImpl = new DestinationConfigurationImpl(destinationHandler.getDefaultPriority(), destinationHandler.getDefaultReliability(), destinationHandler.getDescription(), ((BusHandler)destinationHandler).getDestinationContext(), destinationHandler.getDestinationType(), destinationHandler.getExceptionDestination(), destinationHandler.getMaxFailedDeliveries(), destinationHandler.getMaxReliability(), destinationHandler.getName(), destinationHandler.getUuid().toString(), destinationHandler.isOverrideOfQOSByProducerAllowed(), destinationHandler.isReceiveAllowed(), destinationHandler.isReceiveExclusive(), destinationHandler.isSendAllowed(), destinationHandler.getDefaultForwardRoutingPath(), (SIDestinationAddress)destinationHandler.getReplyDestination());
        } else {
            BaseDestinationDefinition baseDestinationDefinition = destinationHandler.getDefinition();
            if (destinationHandler.isAlias()) {
                baseDestinationDefinition = ((AliasDestinationHandler)destinationHandler).getResolvedDestinationHandler().getDefinition();
            }
            DestinationDefinition destinationDefinition = (DestinationDefinition)baseDestinationDefinition;
            if (this._isBusSecure) {
                SecurityContext securityContext = new SecurityContext(this._subject, null, null, this._messageProcessor.getAuthorisationUtils());
                String string = sIDestinationAddress.getDestinationName();
                this.checkInquireAuthority(destinationHandler, string, null, securityContext, false);
            }
            destinationConfigurationImpl = new DestinationConfigurationImpl(destinationDefinition.getDefaultPriority(), destinationDefinition.getDefaultReliability(), destinationDefinition.getDescription(), destinationDefinition.getDestinationContext(), destinationDefinition.getDestinationType(), destinationDefinition.getExceptionDestination(), destinationDefinition.getMaxFailedDeliveries(), destinationDefinition.getMaxReliability(), destinationDefinition.getName(), destinationDefinition.getUUID().toString(), destinationDefinition.isOverrideOfQOSByProducerAllowed(), destinationDefinition.isReceiveAllowed(), destinationDefinition.isReceiveExclusive(), destinationDefinition.isSendAllowed(), destinationHandler.getDefaultForwardRoutingPath(), (SIDestinationAddress)destinationHandler.getReplyDestination());
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getDestinationConfiguration", (Object)destinationConfigurationImpl);
        }
        return destinationConfigurationImpl;
    }

    public BrowserSession createSystemBrowserSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)new Object[]{sIDestinationAddress, destinationType, selectionCriteria});
        }
        this.checkNotClosed();
        this.checkBrowserSessionNullParameters(sIDestinationAddress);
        if (!sIDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        BrowserSession browserSession = null;
        try {
            browserSession = this.createBrowserSession(sIDestinationAddress, destinationType, selectionCriteria, true, null);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createSystemBrowserSession", (String)"1:3805:1.282.1.6", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:3811:1.282.1.6", sITemporaryDestinationNotFoundException});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:3821:1.282.1.6", sITemporaryDestinationNotFoundException}, null), (Throwable)sITemporaryDestinationNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemBrowserSession", (Object)browserSession);
        }
        return browserSession;
    }

    public ConsumerSession createSystemConsumerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability, boolean bl, boolean bl2, Reliability reliability2, boolean bl3) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)new Object[]{sIDestinationAddress, destinationType, selectionCriteria, reliability, new Boolean(bl), new Boolean(bl2), reliability2, new Boolean(bl3)});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(sIDestinationAddress);
        if (!sIDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        ConsumerSession consumerSession = null;
        try {
            consumerSession = this.internalCreateConsumerSession(sIDestinationAddress, null, destinationType, selectionCriteria, reliability, bl, bl2, false, true, reliability2, bl3, false);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createSystemConsumerSession", (String)"1:3906:1.282.1.6", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:3912:1.282.1.6", sITemporaryDestinationNotFoundException});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:3922:1.282.1.6", sITemporaryDestinationNotFoundException}, null), (Throwable)sITemporaryDestinationNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemConsumerSession", (Object)consumerSession);
        }
        return consumerSession;
    }

    public ProducerSession createSystemProducerSession(SIDestinationAddress sIDestinationAddress, String string, DestinationType destinationType, OrderingContext orderingContext, String string2) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemProducerSession", (Object)new Object[]{sIDestinationAddress, string, destinationType, orderingContext});
        }
        this.checkNotClosed();
        this.checkProducerSessionNullParameters(sIDestinationAddress);
        if (!sIDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemProducerSession", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        SecurityContext securityContext = null;
        if (this._isBusSecure) {
            securityContext = new SecurityContext(this._subject, string2, null, this._messageProcessor.getAuthorisationUtils());
        }
        ProducerSession producerSession = null;
        try {
            producerSession = this.internalCreateProducerSession(sIDestinationAddress, destinationType, sIDestinationAddress.getDestinationName(), sIDestinationAddress.getBusName(), true, securityContext, false);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createSystemProducerSession", (String)"1:4001:1.282.1.6", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4007:1.282.1.6", sITemporaryDestinationNotFoundException});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSystemProducerSession", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:4017:1.282.1.6", sITemporaryDestinationNotFoundException}, null), (Throwable)sITemporaryDestinationNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemProducerSession", (Object)producerSession);
        }
        return producerSession;
    }

    public SIBusMessage systemReceiveNoWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)new Object[]{sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2});
        }
        if (sIDestinationAddress == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_NO_WAIT_CWSIR0091", null, null));
        }
        if (!sIDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        SIBusMessage sIBusMessage = null;
        try {
            sIBusMessage = this.internalReceiveNoWait(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, null, true);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.systemReceiveNoWait", (String)"1:4096:1.282.1.6", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4102:1.282.1.6"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:4110:1.282.1.6"}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"systemReceiveNoWait", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    public SIBusMessage systemReceiveWithWait(SITransaction sITransaction, Reliability reliability, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability2, long l) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)new Object[]{sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, new Long(l)});
        }
        if (sIDestinationAddress == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)"SIIncorrectCallException - null destAddr");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("RECEIVE_NO_WAIT_CWSIR0091", null, null));
        }
        if (!sIDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)"SIDestinationWrongTypeException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        SIBusMessage sIBusMessage = null;
        try {
            sIBusMessage = this.internalReceiveWithWait(sITransaction, reliability, sIDestinationAddress, destinationType, selectionCriteria, reliability2, l, null, true);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.systemReceiveWithWait", (String)"1:4191:1.282.1.6", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4197:1.282.1.6"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"ConnectionImpl", "1:4205:1.282.1.6"}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"systemReceiveWithWait", (Object)sIBusMessage);
        }
        return sIBusMessage;
    }

    public void systemSend(SIBusMessage sIBusMessage, SITransaction sITransaction, SIDestinationAddress sIDestinationAddress, DestinationType destinationType, OrderingContext orderingContext, boolean bl) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"systemSend", (Object)new Object[]{sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, new Boolean(bl)});
        }
        if (!sIDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemSend", (Object)"SIDestinationWrongTypeException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{sIDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        try {
            this.internalSend(sIBusMessage, sITransaction, sIDestinationAddress, destinationType, orderingContext, null, true);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.systemSend", (String)"1:4259:1.282.1.6", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4265:1.282.1.6", sITemporaryDestinationNotFoundException});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"systemSend", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ConnectionImpl", "1:4275:1.282.1.6", sITemporaryDestinationNotFoundException}, null), (Throwable)sITemporaryDestinationNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"systemSend");
        }
    }

    public JsDestinationAddress createSystemDestination(String string) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException {
        boolean bl = ConnectionImpl.isDestinationPrefixValid(string);
        if (!bl) {
            throw new SIInvalidDestinationPrefixException(nls.getFormattedMessage("INVALID_DESTINATION_PREFIX_ERROR_CWSIP0023", new Object[]{string}, null));
        }
        return this._destinationManager.createSystemDestination(string);
    }

    private static final boolean isDestinationPrefixValid(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDestinationPrefixValid", (Object)string);
        }
        boolean bl = true;
        if (null != string) {
            int n = string.length();
            if (n > 24) {
                bl = false;
            } else {
                for (int i = 0; i < n && bl; ++i) {
                    char c = string.charAt(i);
                    if ('A' <= c && 'Z' >= c || 'a' <= c && 'z' >= c || '0' <= c && '9' >= c || '.' == c || '/' == c || '%' == c) continue;
                    bl = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDestinationPrefixValid", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void deleteSystemDestination(JsDestinationAddress jsDestinationAddress) throws SINotPossibleInCurrentConfigurationException, SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)jsDestinationAddress);
        }
        this.checkNotClosed();
        if (!jsDestinationAddress.getDestinationName().startsWith("_P")) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination", (Object)"SIIncorrectCallException");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SYSTEM_DESTINATION_USAGE_ERROR_CWSIP0024", new Object[]{jsDestinationAddress.getDestinationName(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        this._destinationManager.deleteSystemDestination(jsDestinationAddress);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    public void deleteSystemDestination(String string) throws SINotPossibleInCurrentConfigurationException, SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSystemDestination", (Object)string);
        }
        this.checkNotClosed();
        this._destinationManager.deleteSystemDestination(SIMPUtils.createJsSystemDestinationAddress(string, this._messageProcessor.getMessagingEngineUuid()));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSystemDestination");
        }
    }

    public void setMessageCopiedWhenSent(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageCopiedWhenSent", (Object)new Boolean(bl));
        }
        this._copyMessagesWhenSent = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageCopiedWhenSent");
        }
    }

    boolean getMessageCopiedWhenSent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageCopiedWhenSent");
            SibTr.exit((TraceComponent)tc, (String)"getMessageCopiedWhenSent", (Object)new Boolean(this._copyMessagesWhenSent));
        }
        return this._copyMessagesWhenSent;
    }

    public void setMessageCopiedWhenReceived(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageCopiedWhenReceived", (Object)new Boolean(bl));
        }
        this._copyMessagesWhenReceived = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageCopiedWhenReceived");
        }
    }

    boolean getMessageCopiedWhenReceived() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageCopiedWhenReceived");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageCopiedWhenReceived", (Object)new Boolean(this._copyMessagesWhenReceived));
        }
        return this._copyMessagesWhenReceived;
    }

    private void checkConsumerSessionNullParameters(SIDestinationAddress sIDestinationAddress) throws SIIncorrectCallException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkConsumerSessionNullParameters", (Object)sIDestinationAddress);
        }
        if (sIDestinationAddress == null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("CREATE_CONSUMER_CWSIR0021", null, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkConsumerSessionNullParameters", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkConsumerSessionNullParameters");
        }
    }

    public ConsumerSession createConsumerSession(SIDestinationAddress sIDestinationAddress, DestinationType destinationType, SelectionCriteria selectionCriteria, Reliability reliability, boolean bl, boolean bl2, Reliability reliability2, boolean bl3, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SINotAuthorizedException, SIDestinationLockedException, SITemporaryDestinationNotFoundException, SIResourceException, SIErrorException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)new Object[]{this, sIDestinationAddress, string, destinationType, selectionCriteria, reliability, new Boolean(bl), new Boolean(bl2), reliability2, new Boolean(bl3)});
        }
        this.checkNotClosed();
        this.checkConsumerSessionNullParameters(sIDestinationAddress);
        ConsumerSession consumerSession = this.internalCreateConsumerSession(sIDestinationAddress, string, destinationType, selectionCriteria, reliability, bl, bl2, false, false, reliability2, bl3, false);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createConsumerSession", (Object)consumerSession);
        }
        return consumerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerSession createMQLinkConsumerSession(String string, SelectionCriteria selectionCriteria, Reliability reliability) throws SIConnectionUnavailableException, SIConnectionDroppedException, SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SIDestinationLockedException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)new Object[]{string, selectionCriteria, reliability});
        }
        MQLinkHandler mQLinkHandler = null;
        boolean bl = false;
        this.checkNotClosed();
        if (string == null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{null, this._messageProcessor.getMessagingEngineName()}, null));
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBUuid8 sIBUuid8 = new SIBUuid8(string);
        mQLinkHandler = this._destinationManager.getMQLinkLocalization(sIBUuid8, false);
        if (mQLinkHandler == null) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MQLINK_ERROR_CWSIP0026", new Object[]{sIBUuid8, this._messageProcessor.getMessagingEngineName()}, null));
        }
        ConsumerSessionImpl consumerSessionImpl = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            ConsumerDispatcherState consumerDispatcherState = new ConsumerDispatcherState(null, mQLinkHandler.getUuid(), selectionCriteria, false, "", mQLinkHandler.getName(), mQLinkHandler.getBusName());
            JsDestinationAddress jsDestinationAddress = DestinationSessionUtils.createJsDestinationAddress(mQLinkHandler);
            try {
                consumerSessionImpl = new ConsumerSessionImpl(mQLinkHandler, (SIDestinationAddress)jsDestinationAddress, consumerDispatcherState, this, false, bl, reliability, false);
            }
            catch (SIDurableSubscriptionMismatchException sIDurableSubscriptionMismatchException) {
                FFDCFilter.processException((Throwable)sIDurableSubscriptionMismatchException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:4683:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDurableSubscriptionMismatchException));
                if (CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)sIDurableSubscriptionMismatchException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4694:1.282.1.6", sIDurableSubscriptionMismatchException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4703:1.282.1.6", sIDurableSubscriptionMismatchException}, null), (Throwable)sIDurableSubscriptionMismatchException);
            }
            catch (SIDurableSubscriptionNotFoundException sIDurableSubscriptionNotFoundException) {
                FFDCFilter.processException((Throwable)sIDurableSubscriptionNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:4714:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIDurableSubscriptionNotFoundException));
                if (CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)sIDurableSubscriptionNotFoundException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4725:1.282.1.6", sIDurableSubscriptionNotFoundException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4734:1.282.1.6", sIDurableSubscriptionNotFoundException}, null), (Throwable)sIDurableSubscriptionNotFoundException);
            }
            catch (SISessionUnavailableException sISessionUnavailableException) {
                FFDCFilter.processException((Throwable)sISessionUnavailableException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:4745:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sISessionUnavailableException));
                if (CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)sISessionUnavailableException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4756:1.282.1.6", sISessionUnavailableException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4765:1.282.1.6", sISessionUnavailableException}, null), (Throwable)sISessionUnavailableException);
            }
            catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
                FFDCFilter.processException((Throwable)sITemporaryDestinationNotFoundException, (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.createMQLinkConsumerSession", (String)"1:4776:1.282.1.6", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sITemporaryDestinationNotFoundException));
                if (CoreSPIConnection.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)((Object)sITemporaryDestinationNotFoundException));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4787:1.282.1.6", sITemporaryDestinationNotFoundException});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ConnectionImpl", "1:4796:1.282.1.6", sITemporaryDestinationNotFoundException}, null), (Throwable)sITemporaryDestinationNotFoundException);
            }
            List list = this._consumers;
            synchronized (list) {
                this._consumers.add(consumerSessionImpl);
            }
            this._messageProcessor.addConsumer(consumerSessionImpl);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createMQLinkConsumerSession", (Object)consumerSessionImpl);
        }
        return consumerSessionImpl;
    }

    public ItemStream getMQLinkStateItemStream(String string) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkStateItemStream", (Object)string);
        }
        MQLinkHandler mQLinkHandler = null;
        ItemStream itemStream = null;
        this.checkNotClosed();
        if (string == null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{null, this._messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkStateItemStream", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBUuid8 sIBUuid8 = new SIBUuid8(string);
        mQLinkHandler = this._destinationManager.getMQLinkLocalization(sIBUuid8, false);
        if (mQLinkHandler == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkStateItemStream", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MQLINK_ERROR_CWSIP0026", new Object[]{sIBUuid8, this._messageProcessor.getMessagingEngineName()}, null));
        }
        itemStream = mQLinkHandler.getMqLinkStateItemStream();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkStateItemStream", (Object)itemStream);
        }
        return itemStream;
    }

    public void setMQLinkStateItemStream(String string, ItemStream itemStream) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)new Object[]{string, itemStream});
        }
        MQLinkHandler mQLinkHandler = null;
        this.checkNotClosed();
        if (string == null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{null, this._messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBUuid8 sIBUuid8 = new SIBUuid8(string);
        mQLinkHandler = this._destinationManager.getMQLinkLocalization(sIBUuid8, false);
        if (mQLinkHandler == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MQLINK_ERROR_CWSIP0026", new Object[]{sIBUuid8, this._messageProcessor.getMessagingEngineName()}, null));
        }
        ExternalAutoCommitTransaction externalAutoCommitTransaction = this._txManager.createAutoCommitTransaction();
        try {
            mQLinkHandler.setMqLinkStateItemStream(itemStream, externalAutoCommitTransaction);
        }
        catch (OutOfCacheSpace outOfCacheSpace) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)outOfCacheSpace));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)((Object)outOfCacheSpace));
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.ConnectionImpl.setMQLinkStateItemStream", (String)"1:4963:1.282.1.6", (Object)this);
            SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("MQLINK_STATE_ITEMSTREAM_MESSAGE_STORE_ERROR", null, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMQLinkStateItemStream");
        }
    }

    public ItemStream getMQLinkPubSubBridgeItemStream(String string) throws SIException {
        MQLinkHandler mQLinkHandler = null;
        MQLinkPubSubBridgeItemStream mQLinkPubSubBridgeItemStream = null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)string);
        }
        this.checkNotClosed();
        if (string == null) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_15", new Object[]{null, this._messageProcessor.getMessagingEngineName()}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIIncorrectCallException));
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        SIBUuid8 sIBUuid8 = new SIBUuid8(string);
        mQLinkHandler = this._destinationManager.getMQLinkLocalization(sIBUuid8, false);
        if (mQLinkHandler == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MQLINK_PSB_ERROR_CWSIP0027", new Object[]{sIBUuid8, this._messageProcessor.getMessagingEngineName()}, null));
        }
        mQLinkPubSubBridgeItemStream = mQLinkHandler.getMqLinkPubSubBridgeItemStream();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkPubSubBridgeItemStream", (Object)mQLinkPubSubBridgeItemStream);
        }
        return mQLinkPubSubBridgeItemStream;
    }

    public OrderingContext createOrderingContext() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createOrderingContext", (Object)this);
        }
        this.checkNotClosed();
        OrderingContextImpl orderingContextImpl = new OrderingContextImpl();
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createOrderingContext", (Object)orderingContextImpl);
        }
        return orderingContextImpl;
    }

    public String getResolvedUserid() throws SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"getResolvedUserid", (Object)this);
        }
        this.checkNotClosed();
        String string = null;
        if (this._subject != null) {
            string = this._messageProcessor.getAuthorisationUtils().getUserName(this._subject);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"getResolvedUserid", (Object)string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BifurcatedConsumerSession createBifurcatedConsumerSession(long l) throws SISessionUnavailableException, SISessionDroppedException, SIConnectionUnavailableException, SIConnectionDroppedException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)new Object[]{this, new Long(l)});
        }
        this.checkNotClosed();
        ConsumerSessionImpl consumerSessionImpl = this.findConsumerSession(l);
        if (consumerSessionImpl == null) {
            SISessionUnavailableException sISessionUnavailableException = new SISessionUnavailableException(nls.getFormattedMessage("CREATE_CONSUMER_ERROR_CWSIP0092", new Object[]{new Long(l), this._messageProcessor.getMessagingEngineName()}, null));
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)((Object)sISessionUnavailableException));
            }
            throw sISessionUnavailableException;
        }
        if (!consumerSessionImpl.isBifurcatable()) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("TEMPORARY_CWSIR9999", new Object[]{"ConsumerSession is not bifurcatable"}, null));
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
        BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl = new BifurcatedConsumerSessionImpl(this, consumerSessionImpl);
        List list = this._bifurcatedConsumers;
        synchronized (list) {
            this._bifurcatedConsumers.add(bifurcatedConsumerSessionImpl);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"createBifurcatedConsumerSession", (Object)bifurcatedConsumerSessionImpl);
        }
        return bifurcatedConsumerSessionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBifurcatedConsumerSession(BifurcatedConsumerSessionImpl bifurcatedConsumerSessionImpl) {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"removeBifurcatedConsumerSession", (Object)new Object[]{this, bifurcatedConsumerSessionImpl});
        }
        List list = this._bifurcatedConsumers;
        synchronized (list) {
            this._bifurcatedConsumers.remove(bifurcatedConsumerSessionImpl);
        }
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"removeBifurcatedConsumerSession");
        }
    }

    private ConsumerSessionImpl findConsumerSession(long l) throws SINotAuthorizedException {
        ConsumerSessionImpl consumerSessionImpl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findConsumerSession", (Object)new Long(l));
        }
        if ((consumerSessionImpl = this._messageProcessor.getConsumer(l)) != null && consumerSessionImpl.getIdInternal() == l && consumerSessionImpl.getConnection() != this) {
            Subject subject = ((ConnectionImpl)consumerSessionImpl.getConnection()).getSecuritySubject();
            if (subject != null) {
                String string;
                String string2;
                boolean bl = false;
                if (this._subject == null) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Subjects differ - base subject is null");
                    }
                }
                if (!bl && this.isSIBServerSubject() && !this._messageProcessor.getAuthorisationUtils().isSIBServerSubject(subject)) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Subjects differ - base subject is privileged");
                    }
                }
                if (!bl && !(string2 = this._messageProcessor.getAuthorisationUtils().getUserName(subject)).equals(string = this._messageProcessor.getAuthorisationUtils().getUserName(this._subject))) {
                    bl = true;
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Subjects differ by userid - base " + string + ", connected " + string2));
                    }
                }
                if (bl) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"findConsumerSession", (Object)"SINotAuthorizedException - not same");
                    }
                    throw new SINotAuthorizedException(nls.getFormattedMessage("CREATE_BIFURCATED_CONSUMER_ERROR_CWSIP0094", new Object[]{new Long(l), this._messageProcessor.getMessagingEngineName()}, null));
                }
            } else if (this._subject != null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findConsumerSession", (Object)"SINotAuthorizedException - null");
                }
                throw new SINotAuthorizedException(nls.getFormattedMessage("CREATE_BIFURCATED_CONSUMER_ERROR_CWSIP0094", new Object[]{new Long(l), this._messageProcessor.getMessagingEngineName()}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findConsumerSession", (Object)consumerSessionImpl);
        }
        return consumerSessionImpl;
    }

    final Subject getSecuritySubject() {
        return this._subject;
    }

    private void checkProducerAuthority(DestinationHandler destinationHandler, String string, String string2, SecurityContext securityContext, boolean bl, boolean bl2) throws SIDiscriminatorSyntaxException, SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkProducerAuthority", (Object)new Object[]{destinationHandler, string, string2, securityContext, new Boolean(bl), new Boolean(bl2)});
        }
        if (!bl) {
            Object object;
            if (securityContext.alternateUserCheck() && !destinationHandler.checkDestinationAccess(securityContext, OperationType.IDENTITY_ADOPTER)) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to perform alternate user checks on this destination");
                }
                String string3 = securityContext.getUserName(true);
                String string4 = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{string, string3}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(string, string3, OperationType.IDENTITY_ADOPTER, string4);
                SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(string4);
                sIMPNotAuthorizedException.setExceptionReason(18);
                sIMPNotAuthorizedException.setExceptionInserts(new String[]{string, securityContext.getUserName(true)});
                throw sIMPNotAuthorizedException;
            }
            if (!bl2) {
                if (!destinationHandler.checkDestinationAccess(securityContext, OperationType.SEND)) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to produce to this destination");
                    }
                    String string5 = securityContext.getUserName(false);
                    String string6 = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{string, string5}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(string, string5, OperationType.SEND, string6);
                    SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(string6);
                    sIMPNotAuthorizedException.setExceptionReason(18);
                    sIMPNotAuthorizedException.setExceptionInserts(new String[]{string, securityContext.getUserName(false)});
                    throw sIMPNotAuthorizedException;
                }
            } else {
                object = SIMPUtils.parseTempPrefix(string);
                if (!this._accessChecker.checkDestinationAccess(securityContext, null, (String)(object == null ? "" : object), OperationType.SEND)) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to produce to temporary destination");
                    }
                    String string7 = securityContext.getUserName(false);
                    String string8 = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_19", new Object[]{object, string7}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent((String)object, string7, OperationType.SEND, string8);
                    SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(string8);
                    sIMPNotAuthorizedException.setExceptionReason(19);
                    sIMPNotAuthorizedException.setExceptionInserts(new String[]{object, securityContext.getUserName(false)});
                    throw sIMPNotAuthorizedException;
                }
            }
            if (securityContext.testDiscriminatorAtCreate() && !destinationHandler.checkDiscriminatorAccess(securityContext, OperationType.SEND)) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority", (Object)"not authorized to produce to this destination's discriminator");
                }
                SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destinationHandler.getName(), securityContext.getDiscriminator(), securityContext.getUserName(false)}, null));
                object = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{destinationHandler.getName(), securityContext.getDiscriminator(), securityContext.getUserName(false)}, null));
                ((SIMPNotAuthorizedException)((Object)object)).setExceptionReason(20);
                ((SIMPNotAuthorizedException)((Object)object)).setExceptionInserts(new String[]{destinationHandler.getName(), securityContext.getDiscriminator(), securityContext.getUserName(false)});
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkProducerAuthority");
        }
    }

    private void checkConsumerAuthority(DestinationHandler destinationHandler, String string, String string2, SecurityContext securityContext, boolean bl) throws SIDiscriminatorSyntaxException, SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)new Object[]{destinationHandler, string, string2, securityContext, new Boolean(bl)});
        }
        if (!destinationHandler.isTemporary() && !bl) {
            boolean bl2 = true;
            boolean bl3 = false;
            if (securityContext.alternateUserCheck() && !destinationHandler.checkDestinationAccess(securityContext, OperationType.IDENTITY_ADOPTER)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)"not authorized to perform alternate user checks on this destination");
                }
                bl2 = false;
                bl3 = true;
            }
            if (bl2) {
                if (string.startsWith("_SYSTEM.Exception.Destination")) {
                    if (!this._messageProcessor.getAccessChecker().checkDestinationAccess(securityContext, null, "_SYSTEM.Exception.Destination", OperationType.RECEIVE)) {
                        bl2 = false;
                    }
                } else if (!destinationHandler.checkDestinationAccess(securityContext, OperationType.RECEIVE)) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)"not authorized to consume from this destination");
                }
                String string3 = securityContext.getUserName(bl3);
                OperationType operationType = bl3 ? OperationType.IDENTITY_ADOPTER : OperationType.RECEIVE;
                String string4 = nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0309", new Object[]{destinationHandler.getName(), string3}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationHandler.getName(), string3, operationType, string4);
                throw new SINotAuthorizedException(string4);
            }
        }
        if (string2 != null && !this._messageProcessor.getMessageProcessorMatching().isWildCarded(string2)) {
            securityContext.setDiscriminator(string2);
            if (!destinationHandler.checkDiscriminatorAccess(securityContext, OperationType.RECEIVE)) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkConsumerAuthority", (Object)"not authorized to consume from this destination's discriminator");
                }
                SibTr.audit((TraceComponent)tc, (String)nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0310", new Object[]{destinationHandler.getName(), string2, securityContext.getUserName(false)}, null));
                throw new SINotAuthorizedException(nls.getFormattedMessage("USER_NOT_AUTH_RECEIVE_ERROR_CWSIP0310", new Object[]{destinationHandler.getName(), string2, securityContext.getUserName(false)}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkConsumerAuthority");
        }
    }

    private void checkBrowseAuthority(DestinationHandler destinationHandler, String string, SecurityContext securityContext, boolean bl) throws SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkBrowseAuthority", (Object)new Object[]{destinationHandler, string, securityContext, new Boolean(bl)});
        }
        if (!destinationHandler.isTemporary() && !bl) {
            boolean bl2 = true;
            boolean bl3 = false;
            if (securityContext.alternateUserCheck() && !destinationHandler.checkDestinationAccess(securityContext, OperationType.IDENTITY_ADOPTER)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"checkBrowseAuthority", (Object)"not authorized to perform alternate user checks on this destination");
                }
                bl2 = false;
                bl3 = true;
            }
            if (bl2) {
                if (string.startsWith("_SYSTEM.Exception.Destination")) {
                    if (!this._messageProcessor.getAccessChecker().checkDestinationAccess(securityContext, null, "_SYSTEM.Exception.Destination", OperationType.RECEIVE)) {
                        bl2 = false;
                    }
                } else if (!destinationHandler.checkDestinationAccess(securityContext, OperationType.BROWSE)) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkBrowseAuthority", (Object)"not authorized to browse this destination");
                }
                String string2 = securityContext.getUserName(bl3);
                OperationType operationType = bl3 ? OperationType.IDENTITY_ADOPTER : OperationType.BROWSE;
                String string3 = nls.getFormattedMessage("USER_NOT_AUTH_BROWSE_ERROR_CWSIP0304", new Object[]{destinationHandler.getName(), string2}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(destinationHandler.getName(), string2, operationType, string3);
                throw new SINotAuthorizedException(string3);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBrowseAuthority");
        }
    }

    private void checkInquireAuthority(DestinationHandler destinationHandler, String string, String string2, SecurityContext securityContext, boolean bl) throws SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkInquireAuthority", (Object)new Object[]{destinationHandler, string, string2, securityContext, new Boolean(bl)});
        }
        if (!bl) {
            if (!destinationHandler.checkDestinationAccess(securityContext, OperationType.INQUIRE)) {
                String string3;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkInquireAuthority", (Object)"not authorized to inquire on this destination");
                }
                String string4 = securityContext.getUserName(true);
                if (string != null) {
                    string3 = nls.getFormattedMessage("TEMPORARY_CWSIP9999", new Object[]{"Inquire access for destination " + string + " was denied for user with subject " + securityContext.getUserName(true)}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(string, string4, OperationType.INQUIRE, string3);
                } else {
                    string3 = nls.getFormattedMessage("TEMPORARY_CWSIP9999", new Object[]{"Inquire access for foreign bus " + string2 + " was denied for user with subject " + securityContext.getUserName(true)}, null);
                    this._accessChecker.fireDestinationAccessNotAuthorizedEvent(string2, string4, OperationType.INQUIRE, string3);
                }
                throw new SINotAuthorizedException(string3);
            }
        } else {
            String string5 = SIMPUtils.parseTempPrefix(string);
            if (!this._accessChecker.checkDestinationAccess(securityContext, null, string5 == null ? "" : string5, OperationType.INQUIRE)) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkInquireAuthority", (Object)"not authorized to inquire on temporary destination");
                }
                String string6 = securityContext.getUserName(true);
                String string7 = nls.getFormattedMessage("TEMPORARY_CWSIP9999", new Object[]{"Inquire access for destination " + string5 + " was denied for user with subject " + securityContext.getUserName(true)}, null);
                this._accessChecker.fireDestinationAccessNotAuthorizedEvent(string5, string6, OperationType.INQUIRE, string7);
                throw new SINotAuthorizedException(string7);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkInquireAuthority");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress[] addDestinationListener(DestinationListener destinationListener, DestinationType destinationType, DestinationAvailability destinationAvailability) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{destinationListener, destinationType, destinationAvailability});
        }
        SIDestinationAddress[] sIDestinationAddressArray = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            sIDestinationAddressArray = this._destinationManager.addDestinationListener(destinationListener, destinationType, destinationAvailability, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addDestinationListener", (Object)new Object[]{sIDestinationAddressArray});
        }
        return sIDestinationAddressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestinationListener(DestinationListener destinationListener) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDestinationListener", (Object)new Object[]{destinationListener});
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            this._destinationManager.removeDestinationListener(destinationListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDestinationListener");
        }
    }

    public boolean isBusSecure() {
        return this._isBusSecure;
    }

    public void sendToExceptionDestination(SIDestinationAddress sIDestinationAddress, SIBusMessage sIBusMessage, int n, String[] stringArray, SITransaction sITransaction, String string) throws SIResourceException, SIConnectionLostException, SILimitExceededException, SIErrorException, SINotAuthorizedException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIConnection.tc, (String)"sendToExceptionDestination", (Object)new Object[]{this, sIDestinationAddress, string, sIBusMessage, new Integer(n), stringArray, sITransaction});
        }
        if (sIBusMessage == null) {
            if (CoreSPIConnection.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"sendToExceptionDestination", (Object)"SIIncorrectCallException - null msg");
            }
            throw new SIIncorrectCallException(nls_cwsir.getFormattedMessage("SEND_EXCEPTION_DEST_CWSIR0121", null, null));
        }
        String string2 = null;
        if (sIDestinationAddress != null) {
            string2 = sIDestinationAddress.getDestinationName();
        }
        ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = new ExceptionDestinationHandlerImpl(string2, this._messageProcessor);
        exceptionDestinationHandlerImpl.sendToExceptionDestination(sIBusMessage, string, (Transaction)sITransaction, n, this, stringArray);
        if (CoreSPIConnection.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIConnection.tc, (String)"sendToExceptionDestination");
        }
    }

    public void setSetWaitTimeInMessage(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSetWaitTimeInMessage", (Object)new Boolean(bl));
        }
        this._setWaitTimeInMessage = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSetWaitTimeInMessage");
        }
    }

    boolean getSetWaitTimeInMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSetWaitTimeInMessage");
            SibTr.exit((TraceComponent)tc, (String)"getSetWaitTimeInMessage", (Object)new Boolean(this._setWaitTimeInMessage));
        }
        return this._setWaitTimeInMessage;
    }

    private boolean isSIBServerSubject() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSIBServerSubject");
        }
        boolean bl = false;
        if (this._subject != null) {
            bl = this._messageProcessor.getAuthorisationUtils().isSIBServerSubject(this._subject);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSIBServerSubject", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isMulticastEnabled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMulticastEnabled");
        }
        boolean bl = this._messageProcessor.isMulticastEnabled();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMulticastEnabled", (Object)new Boolean(bl));
        }
        return bl;
    }

    public MulticastProperties getMulticastProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMulticastProperties");
        }
        MulticastPropertiesImpl multicastPropertiesImpl = this._messageProcessor.getMulticastProperties();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMulticastProperties", (Object)multicastPropertiesImpl);
        }
        return multicastPropertiesImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIDestinationAddress checkMessagingRequired(SIDestinationAddress sIDestinationAddress, SIDestinationAddress sIDestinationAddress2, DestinationType destinationType, String string) throws SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException, SIIncorrectCallException, SITemporaryDestinationNotFoundException, SIResourceException, SINotAuthorizedException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkMessagingRequired", (Object)new Object[]{sIDestinationAddress, sIDestinationAddress2, string, destinationType});
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        SIDestinationAddress sIDestinationAddress3 = null;
        boolean bl5 = false;
        HashSet<String> hashSet = null;
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.checkNotClosed();
            this.checkProducerSessionNullParameters(sIDestinationAddress);
            SecurityContext securityContext = null;
            if (this._isBusSecure) {
                securityContext = new SecurityContext(this._subject, string, null, this._messageProcessor.getAuthorisationUtils());
            }
            String string2 = sIDestinationAddress.getDestinationName();
            String string3 = sIDestinationAddress.getBusName();
            if (string3 == null || string3.equals(this._messageProcessor.getMessagingEngineBus())) {
                Object object;
                int n;
                DestinationHandler destinationHandler;
                String string4;
                Object object2;
                DestinationHandler destinationHandler2 = null;
                destinationHandler2 = this._destinationManager.getDestination(string2, string3, false);
                this.checkDestinationType(destinationType, destinationHandler2, false, false);
                boolean bl6 = destinationHandler2.isSendAllowed();
                if (!destinationHandler2.isPubSub() && destinationHandler2.hasLocal() && bl6) {
                    object2 = (PtoPLocalMsgsItemStream)destinationHandler2.getQueuePoint(this._messageProcessor.getMessagingEngineUuid());
                    bl6 = ((PtoPLocalMsgsItemStream)object2).isSendAllowed();
                }
                if (this._isBusSecure) {
                    this.checkProducerAuthority(destinationHandler2, string2, string3, securityContext, false, false);
                    if (sIDestinationAddress2 != null) {
                        object2 = sIDestinationAddress2.getDestinationName();
                        string4 = sIDestinationAddress2.getBusName();
                        destinationHandler = this._destinationManager.getDestination((String)object2, string4, false);
                        this.checkDestinationAccess(destinationHandler, (String)object2, string4, securityContext);
                    }
                }
                if ((object2 = destinationHandler2.getReplyDestination()) != null && sIDestinationAddress2 != null) {
                    linkedList.add(object2);
                }
                string4 = null;
                destinationHandler = destinationHandler2;
                List list = destinationHandler2.getForwardRoutingPath();
                if (list != null) {
                    int n2 = list.size();
                    n = 0;
                    hashSet = new HashSet<String>();
                    hashSet.add(destinationHandler2.getName());
                    while (destinationHandler.getMediationDefinition() == null && !destinationHandler.isPubSub() && !bl4 && !bl5 && bl6 && n < n2) {
                        string4 = (JsDestinationAddress)list.get(n);
                        ++n;
                        object = string4.getDestinationName();
                        String string5 = string4.getBusName();
                        if (string5 == null || string5.equals(this._messageProcessor.getMessagingEngineBus())) {
                            List list2;
                            destinationHandler = this._destinationManager.getDestination((String)object, string5, false);
                            if (this._isBusSecure) {
                                this.checkDestinationAccess(destinationHandler, (String)object, string5, securityContext);
                            }
                            if ((object2 = destinationHandler.getReplyDestination()) != null && sIDestinationAddress2 != null) {
                                linkedList.add(object2);
                            }
                            if (n != n2 || (list2 = destinationHandler.getForwardRoutingPath()) == null) continue;
                            if (hashSet.contains(destinationHandler.getName())) {
                                bl5 = true;
                                continue;
                            }
                            hashSet.add(destinationHandler.getName());
                            list = list2;
                            n2 = list.size();
                            n = 0;
                            continue;
                        }
                        bl4 = true;
                    }
                }
                if (destinationHandler.getMediationDefinition() == null && !bl4 && !bl5 && bl6 && destinationHandler.hasLocal() && destinationHandler.getDestinationType() == DestinationType.PORT && !destinationHandler.isPubSub()) {
                    bl2 = true;
                    sIDestinationAddress3 = SIDestinationAddressFactory.getInstance().createSIDestinationAddress(destinationHandler.getName(), destinationHandler.getBus());
                }
                if (bl2) {
                    DestinationHandler destinationHandler3 = null;
                    while (!linkedList.isEmpty()) {
                        string4 = (JsDestinationAddress)linkedList.remove(0);
                        String string6 = string4.getDestinationName();
                        object = string4.getBusName();
                        if (object != null && !((String)object).equals(this._messageProcessor.getMessagingEngineBus())) {
                            bl3 = false;
                            linkedList.clear();
                            continue;
                        }
                        destinationHandler3 = this._destinationManager.getDestination(string6, (String)object, false);
                        if (destinationHandler3.getMediationDefinition() != null) {
                            bl3 = false;
                            linkedList.clear();
                        }
                        if (!this._isBusSecure) continue;
                        this.checkDestinationAccess(destinationHandler3, string6, (String)object, securityContext);
                    }
                    if (bl3 && sIDestinationAddress2 != null) {
                        string2 = sIDestinationAddress2.getDestinationName();
                        string3 = sIDestinationAddress2.getBusName();
                        if (string3 != null && !string3.equals(this._messageProcessor.getMessagingEngineBus())) {
                            bl3 = false;
                        } else {
                            destinationHandler2 = this._destinationManager.getDestination(string2, string3, false);
                            n = 0;
                            object = destinationHandler2.getForwardRoutingPath();
                            if (object != null && !object.isEmpty()) {
                                n = 1;
                            }
                            if (destinationHandler2.getMediationDefinition() != null || !destinationHandler2.hasLocal() || n == 1 || !destinationHandler2.isReceiveAllowed()) {
                                bl3 = false;
                            }
                        }
                    }
                    if (bl2 && bl3) {
                        bl = true;
                    }
                }
            }
        }
        if (!bl) {
            sIDestinationAddress3 = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkMessagingRequired", sIDestinationAddress3);
        }
        return sIDestinationAddress3;
    }

    private void checkDestinationAccess(DestinationHandler destinationHandler, String string, String string2, SecurityContext securityContext) throws SINotAuthorizedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{destinationHandler, string, string2, securityContext});
        }
        if (!destinationHandler.checkDestinationAccess(securityContext, OperationType.SEND)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)"not authorized to produce to this destination");
            }
            SIMPNotAuthorizedException sIMPNotAuthorizedException = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{string, securityContext.getUserName(false)}, null));
            sIMPNotAuthorizedException.setExceptionReason(18);
            sIMPNotAuthorizedException.setExceptionInserts(new String[]{string, securityContext.getUserName(false)});
            throw sIMPNotAuthorizedException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/ConnectionImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.282.1.6");
        }
    }
}

