/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPIBrowserSession;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.BrowserSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

public final class BrowserSessionImpl
implements BrowserSession {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)BrowserSessionImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Filter _filter;
    private ConnectionImpl _conn;
    private boolean _closed;
    private DestinationHandler _dest;
    private NonLockingCursor _browseCursor;
    private ConsumerDispatcher _consumerDispatcher;
    private SIDestinationAddress _destinationAddress;

    public BrowserSessionImpl(DestinationHandler destinationHandler, Filter filter, ConnectionImpl connectionImpl, SIDestinationAddress sIDestinationAddress) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)new Object[]{destinationHandler, filter, connectionImpl, sIDestinationAddress});
        }
        this._conn = connectionImpl;
        this._dest = destinationHandler;
        this._filter = filter;
        this._destinationAddress = sIDestinationAddress;
        if (destinationHandler != null) {
            if (!destinationHandler.isPubSub()) {
                this._consumerDispatcher = destinationHandler.chooseConsumerDispatcher();
                if (this._consumerDispatcher == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"ConsumerDispatcher not found ");
                    }
                } else if (this._consumerDispatcher.isLocked()) {
                    SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException = new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_IS_LOCKED_ERROR_CWSIP0085", new Object[]{destinationHandler.getName(), destinationHandler.getMessageProcessor().getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sINotPossibleInCurrentConfigurationException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)((Object)sINotPossibleInCurrentConfigurationException));
                    }
                    throw sINotPossibleInCurrentConfigurationException;
                }
                this._consumerDispatcher.attachBrowser(this);
                this._browseCursor = this._consumerDispatcher.getBrowseCursor(filter);
            }
        } else {
            this._browseCursor = null;
        }
        this._closed = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BrowserSessionImpl", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIBusMessage next() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)this);
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            this.checkNotClosed();
            AbstractItem abstractItem = null;
            if (this._browseCursor != null) {
                try {
                    abstractItem = this._browseCursor.next();
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl.next", (String)"1:242:1.70", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:249:1.70", messageStoreException});
                    if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)((Object)messageStoreException));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:260:1.70", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                }
                if (abstractItem != null) {
                    JsMessage jsMessage = ((SIMPMessage)((Object)abstractItem)).getMessage();
                    jsMessage.setRedeliveredCount(abstractItem.guessUnlockCount());
                    try {
                        jsMessage = jsMessage.getReceived();
                    }
                    catch (MessageCopyFailedException messageCopyFailedException) {
                        FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.BrowserSessionImpl.next", (String)"1:282:1.70", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:289:1.70", messageCopyFailedException});
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)((Object)messageCopyFailedException));
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.BrowserSessionImpl", "1:300:1.70", messageCopyFailedException}, null), (Throwable)messageCopyFailedException);
                    }
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", (Object)jsMessage);
                    }
                    return jsMessage;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"next", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"close", (Object)this);
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            if (!this._closed) {
                this._conn.removeBrowserSession(this);
                this._close();
            }
        }
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close");
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            if (!this._closed) {
                if (this._consumerDispatcher != null) {
                    this._consumerDispatcher.detachBrowser(this);
                }
                if (this._browseCursor != null) {
                    this._browseCursor.finished();
                }
                this._browseCursor = null;
                this._conn = null;
                this._closed = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _closeBrowserDestinationDeleted(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_closeBrowserDestinationDeleted", (Object)destinationHandler);
        }
        if (destinationHandler == this._dest) {
            BrowserSessionImpl browserSessionImpl = this;
            synchronized (browserSessionImpl) {
                if (!this._closed) {
                    this._conn.removeBrowserSession(this);
                    if (this._browseCursor != null) {
                        this._browseCursor.finished();
                    }
                    this._browseCursor = null;
                    this._conn = null;
                    this._closed = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_closeBrowserDestinationDeleted", (Object)new Boolean(this._closed));
        }
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNotClosed() throws SISessionUnavailableException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkNotClosed");
        }
        BrowserSessionImpl browserSessionImpl = this;
        synchronized (browserSessionImpl) {
            if (this._closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkNotClosed", (Object)"Object closed");
                }
                throw new SISessionUnavailableException(nls.getFormattedMessage("OBJECT_CLOSED_ERROR_CWSIP0081", new Object[]{this._dest.getName(), this._dest.getMessageProcessor().getMessagingEngineName()}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkNotClosed");
        }
    }

    public SICoreConnection getConnection() {
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"getConnection", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"getConnection", (Object)this._conn);
        }
        return this._conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException {
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"reset", (Object)this);
        }
        this.checkNotClosed();
        if (this._browseCursor != null) {
            NonLockingCursor nonLockingCursor = this._browseCursor;
            synchronized (nonLockingCursor) {
                if (this._browseCursor != null) {
                    this._browseCursor.finished();
                }
                ConsumerDispatcher consumerDispatcher = this._dest.chooseConsumerDispatcher();
                this._browseCursor = consumerDispatcher.getBrowseCursor(this._filter);
            }
        }
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"reset");
        }
    }

    public SIDestinationAddress getDestinationAddress() {
        if (CoreSPIBrowserSession.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPIBrowserSession.tc, (String)"getDestinationAddress", (Object)this);
            SibTr.exit((TraceComponent)CoreSPIBrowserSession.tc, (String)"getDestinationAddress", (Object)this._destinationAddress);
        }
        return this._destinationAddress;
    }

    public DestinationHandler getNamedDestination() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNamedDestination");
            SibTr.exit((TraceComponent)tc, (String)"getNamedDestination", (Object)this._dest);
        }
        return this._dest;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/BrowserSessionImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.70");
        }
    }
}

