/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAccept;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlBrowseEnd;
import com.ibm.ws.sib.mfp.control.ControlBrowseGet;
import com.ibm.ws.sib.mfp.control.ControlBrowseStatus;
import com.ibm.ws.sib.mfp.control.ControlCardinalityInfo;
import com.ibm.ws.sib.mfp.control.ControlCompleted;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlDecisionExpected;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlReject;
import com.ibm.ws.sib.mfp.control.ControlRequest;
import com.ibm.ws.sib.mfp.control.ControlRequestAck;
import com.ibm.ws.sib.mfp.control.ControlRequestHighestGeneratedTick;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAck;
import com.ibm.ws.sib.mfp.control.ControlResetRequestAckAck;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Filter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AOBrowserSession;
import com.ibm.ws.sib.processor.impl.AOBrowserSessionKey;
import com.ibm.ws.sib.processor.impl.AOConsumerKey;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter;
import com.ibm.ws.sib.processor.impl.store.items.AOStartedFlushItem;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.io.impl.MPIO;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class AnycastOutputHandler
implements ControlHandler {
    private static TraceComponent tc = SibTr.register((Class)AnycastOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private final String destName;
    private final SIBUuid12 destUuid;
    private final ConsumerDispatcher cd;
    private final ItemStream containerItemStream;
    private final MessageProcessor mp;
    private final AsyncUpdateThread msUpdateThread;
    private final AsyncUpdateThread persistLockThread;
    private final Hashtable browserSessionTable;
    public final long dmeVersion;
    private final Hashtable streamTable;
    private boolean cardinalityOne;
    private final Object cardinalityOneLock;
    private boolean closed;
    private boolean startedCloseAndFlush;
    private volatile boolean finishedCloseAndFlush;
    private boolean redriveDeletionThread;
    private final long controlItemLockID;
    final ReferenceStream msgReferenceStream;
    final ItemStream msgItemStream;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnycastOutputHandler(String string, SIBUuid12 sIBUuid12, boolean bl, ConsumerDispatcher consumerDispatcher, SIMPItemStream sIMPItemStream, MessageProcessor messageProcessor, AsyncUpdateThread asyncUpdateThread, AsyncUpdateThread asyncUpdateThread2, long l, boolean bl2) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AnycastOutputHandler", (Object)new Object[]{string, sIBUuid12, new Boolean(bl), consumerDispatcher, sIMPItemStream, messageProcessor, asyncUpdateThread, asyncUpdateThread2, new Long(l), new Boolean(bl2)});
        }
        this.destName = string;
        this.destUuid = sIBUuid12;
        this.cardinalityOneLock = new Object();
        this.setCardinalityOne(bl);
        this.cd = consumerDispatcher;
        this.msgReferenceStream = consumerDispatcher.getReferenceStream();
        this.msgItemStream = consumerDispatcher.getItemStream();
        this.containerItemStream = sIMPItemStream;
        this.mp = messageProcessor;
        this.controlItemLockID = messageProcessor.getMessageStore().getUniqueLockID(1);
        this.msUpdateThread = asyncUpdateThread;
        this.persistLockThread = asyncUpdateThread2;
        this.dmeVersion = l;
        this.browserSessionTable = new Hashtable();
        this.streamTable = new Hashtable();
        ArrayList<AOStream> arrayList = new ArrayList<AOStream>();
        try {
            Hashtable hashtable = this.streamTable;
            synchronized (hashtable) {
                Object object2;
                Object object3;
                SIBUuid8 sIBUuid8;
                AbstractItem abstractItem;
                AbstractItem abstractItem2;
                object = sIMPItemStream.newNonLockingItemStreamCursor(null);
                while ((abstractItem2 = object.next()) != null) {
                    if (!(abstractItem2 instanceof AOProtocolItemStream)) continue;
                    abstractItem = (AOProtocolItemStream)abstractItem2;
                    sIBUuid8 = ((AOProtocolItemStream)abstractItem).getRemoteMEId();
                    object3 = ((AOProtocolItemStream)abstractItem).getStreamId();
                    object2 = (StreamInfo)this.streamTable.get(sIBUuid8);
                    if (object2 != null) {
                        if (object2.streamId.equals(object3)) {
                            if (object2.itemStream == null) {
                                object2.itemStream = abstractItem;
                                continue;
                            }
                            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:409:1.77"}, null));
                            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:416:1.77", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:424:1.77"});
                            throw sIErrorException;
                        }
                        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:438:1.77"}, null));
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:444:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:452:1.77"});
                        throw sIErrorException;
                    }
                    object2 = new StreamInfo(sIBUuid8, (SIBUuid12)object3, null, (AOProtocolItemStream)abstractItem);
                    this.streamTable.put(sIBUuid8, object2);
                }
                object.finished();
                object = sIMPItemStream.newNonLockingItemCursor(null);
                while ((abstractItem2 = object.next()) != null) {
                    if (!(abstractItem2 instanceof AOStartedFlushItem)) continue;
                    abstractItem = (AOStartedFlushItem)abstractItem2;
                    sIBUuid8 = ((AOStartedFlushItem)abstractItem).getRemoteMEId();
                    object3 = ((AOStartedFlushItem)abstractItem).getStreamId();
                    object2 = (StreamInfo)this.streamTable.get(sIBUuid8);
                    if (object2 != null) {
                        if (object2.streamId.equals(object3)) {
                            if (object2.item == null) {
                                object2.item = abstractItem;
                                continue;
                            }
                            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:492:1.77"}, null));
                            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:499:1.77", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:507:1.77"});
                            throw sIErrorException;
                        }
                        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:521:1.77"}, null));
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:528:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:534:1.77"});
                        throw sIErrorException;
                    }
                    object2 = new StreamInfo(sIBUuid8, (SIBUuid12)object3, null, null);
                    object2.item = abstractItem;
                    this.streamTable.put(sIBUuid8, object2);
                }
                object.finished();
                boolean bl3 = false;
                if (this.getCardinalityOne() && this.streamTable.size() > 1) {
                    int n = 0;
                    object3 = this.streamTable.elements();
                    while (object3.hasMoreElements()) {
                        object2 = (StreamInfo)object3.nextElement();
                        if (object2.item != null) continue;
                        ++n;
                    }
                    if (n > 1) {
                        object2 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:575:1.77"}, null));
                        FFDCFilter.processException((Throwable)object2, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:582:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)object2);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:589:1.77"});
                        bl3 = true;
                    }
                }
                Enumeration enumeration = this.streamTable.elements();
                object3 = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    Object object4;
                    Object object5;
                    boolean bl4;
                    object2 = (StreamInfo)enumeration.nextElement();
                    boolean bl5 = bl4 = object2.item != null;
                    if (object2.itemStream == null) {
                        object5 = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:612:1.77"}, null));
                        FFDCFilter.processException((Throwable)object5, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:619:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)object5);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:626:1.77"});
                        throw object5;
                    }
                    ((ArrayList)object3).clear();
                    object = object2.itemStream.newNonLockingItemCursor(null);
                    while ((object5 = (AOValue)object.next()) != null) {
                        ((ArrayList)object3).add(object5);
                    }
                    object.finished();
                    if (bl2) {
                        this.deleteAndUnlockPersistentStream((StreamInfo)object2, (ArrayList)object3);
                        this.sendFlushed(new MessagingEngine(object2.remoteMEId), object2.remoteMEId, object2.streamId);
                        continue;
                    }
                    if (bl4 && ((ArrayList)object3).size() == 0) {
                        object4 = new RemovePersistentStream(object2.remoteMEId, object2.streamId, object2.itemStream, object2.item);
                        asyncUpdateThread.enqueueWork((AsyncUpdate)object4);
                        continue;
                    }
                    object2.stream = new AOStream(object2.remoteMEId, object2.streamId, object2.itemStream, this, asyncUpdateThread, false, (List)object3, bl4, messageProcessor, this.dmeVersion);
                    if (this.getCardinalityOne() && !bl4 && !bl3) {
                        try {
                            object4 = new AOConsumerKey();
                            ConsumerKey consumerKey = consumerDispatcher.attachConsumerPoint((ConsumerPoint)object4, null, new SIBUuid12(), false, false);
                            ((AOConsumerKey)object4).init(object2.stream, "", new ConsumerKey[]{consumerKey}, 0L, messageProcessor.getAlarmManager(), null);
                            object2.stream.setConsumerKey((AOConsumerKey)object4);
                        }
                        catch (Exception exception) {
                            SibTr.exception((TraceComponent)tc, (Exception)exception);
                            arrayList.add(object2.stream);
                        }
                    } else if (bl3) {
                        arrayList.add(object2.stream);
                    }
                    object2.stream.start();
                }
                if (bl2) {
                    this.streamTable.clear();
                    SibTr.info((TraceComponent)tc, (String)"FLUSH_COMPLETE_CWSIP0451", (Object)new Object[]{messageProcessor.getMessagingEngineName(), string});
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AnycastOutputHandler", (String)"1:726:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AnycastOutputHandler", (Object)exception);
            }
            throw exception;
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (AOStream)arrayList.get(i);
                ((AOStream)object).processRequestFlush();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AnycastOutputHandler", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        Enumeration enumeration = null;
        Object object = this;
        synchronized (object) {
            Hashtable hashtable = this.streamTable;
            synchronized (hashtable) {
                this.closed = true;
                this.closeBrowserSessionsInternal();
                enumeration = this.streamTable.elements();
            }
        }
        while (enumeration.hasMoreElements()) {
            object = (StreamInfo)enumeration.nextElement();
            if (((StreamInfo)object).stream == null) continue;
            ((StreamInfo)object).stream.close();
        }
        object = this.streamTable;
        synchronized (object) {
            this.streamTable.clear();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndFlush(boolean bl) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeAndFlush", (Object)bl);
        }
        Hashtable hashtable = null;
        Object object2 = this;
        synchronized (object2) {
            object = this.streamTable;
            synchronized (object) {
                if (!this.startedCloseAndFlush) {
                    this.startedCloseAndFlush = true;
                    this.redriveDeletionThread = bl;
                    this.closeBrowserSessionsInternal();
                    if (this.streamTable.size() == 0) {
                        this.finishedCloseAndFlush = true;
                        this.streamTable.notifyAll();
                    } else {
                        hashtable = (Hashtable)this.streamTable.clone();
                    }
                }
            }
        }
        if (hashtable != null) {
            object2 = hashtable.elements();
            while (object2.hasMoreElements()) {
                object = (StreamInfo)object2.nextElement();
                if (((StreamInfo)object).stream == null) continue;
                ((StreamInfo)object).stream.processRequestFlush();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeAndFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanup(boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanup", (Object)new Object[]{bl, bl2});
        }
        boolean bl3 = false;
        Hashtable hashtable = this.streamTable;
        synchronized (hashtable) {
            if (this.finishedCloseAndFlush) {
                bl3 = true;
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"cleanup", (Object)bl3);
                }
                return bl3;
            }
        }
        if (!bl) {
            this.close();
            bl3 = true;
        } else {
            this.closeAndFlush(bl2);
            hashtable = this.streamTable;
            synchronized (hashtable) {
                bl3 = this.finishedCloseAndFlush;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanup", (Object)bl3);
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCloseAndFlushCompleted() {
        Hashtable hashtable = this.streamTable;
        synchronized (hashtable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isCloseAndFlushCompleted");
                SibTr.exit((TraceComponent)tc, (String)"isCloseAndFlushCompleted", (Object)new Boolean(this.finishedCloseAndFlush));
            }
            return this.finishedCloseAndFlush;
        }
    }

    public void closeBrowserSessionsInternal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeBrowserSessionsInternal");
        }
        Enumeration enumeration = this.browserSessionTable.elements();
        while (enumeration.hasMoreElements()) {
            AOBrowserSession aOBrowserSession = (AOBrowserSession)enumeration.nextElement();
            aOBrowserSession.close();
        }
        this.browserSessionTable.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeBrowserSessionsInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getCardinalityOne() {
        Object object = this.cardinalityOneLock;
        synchronized (object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getCardinalityOne");
                SibTr.exit((TraceComponent)tc, (String)"getCardinalityOne", (Object)new Boolean(this.cardinalityOne));
            }
            return this.cardinalityOne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setCardinalityOne(boolean bl) {
        Object object = this.cardinalityOneLock;
        synchronized (object) {
            this.cardinalityOne = bl;
        }
    }

    public final boolean isMEReachable(MessagingEngine messagingEngine) {
        MPIO mPIO = this.mp.getMPIO();
        return mPIO.isMEReachable(messagingEngine);
    }

    public final AsyncUpdateThread getAsyncUpdateThread() {
        return this.msUpdateThread;
    }

    public final AsyncUpdateThread getPersistLockThread() {
        return this.persistLockThread;
    }

    public final AOStream getAOStream(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12) {
        StreamInfo streamInfo;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAOStream", (Object)new Object[]{sIBUuid8, sIBUuid12});
        }
        if ((streamInfo = this.getStreamInfo(sIBUuid8, sIBUuid12)) != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getAOStream", (Object)streamInfo.stream);
            }
            return streamInfo.stream;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAOStream", null);
        }
        return null;
    }

    public void handleControlMessage(Cellule cellule, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cellule, controlMessage});
        }
        SIBUuid8 sIBUuid8 = controlMessage.getGuaranteedSourceMessagingEngineUUID();
        ControlMessageType controlMessageType = controlMessage.getControlMessageType();
        if (controlMessageType == ControlMessageType.BROWSEGET) {
            ControlBrowseGet controlBrowseGet = (ControlBrowseGet)controlMessage;
            long l = controlBrowseGet.getBrowseID();
            String string = controlBrowseGet.getFilter();
            String string2 = controlBrowseGet.getControlDiscriminator();
            SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain((int)controlBrowseGet.getSelectorDomain());
            SelectionCriteria selectionCriteria = this.mp.getSelectionCriteriaFactory().createSelectionCriteria(string2, string, selectorDomain);
            long l2 = controlBrowseGet.getSequenceNumber();
            this.handleControlBrowseGet(sIBUuid8, l, selectionCriteria, l2);
        } else if (controlMessageType == ControlMessageType.BROWSESTATUS) {
            ControlBrowseStatus controlBrowseStatus = (ControlBrowseStatus)controlMessage;
            long l = controlBrowseStatus.getBrowseID();
            int n = controlBrowseStatus.getStatus();
            this.handleControlBrowseStatus(sIBUuid8, l, n);
        } else if (controlMessageType == ControlMessageType.CREATESTREAM) {
            ControlCreateStream controlCreateStream = (ControlCreateStream)controlMessage;
            long l = controlCreateStream.getRequestID();
            SIBUuid12 sIBUuid12 = null;
            if (controlMessage.getGuaranteedProtocolType() == ProtocolType.DURABLEOUTPUT) {
                sIBUuid12 = controlMessage.getGuaranteedTargetDestinationDefinitionUUID();
            }
            this.handleControlCreateStream(sIBUuid8, l, sIBUuid12);
        } else {
            SIBUuid12 sIBUuid12 = controlMessage.getGuaranteedStreamUUID();
            StreamInfo streamInfo = this.getStreamInfo(sIBUuid8, sIBUuid12);
            if (streamInfo == null) {
                this.sendFlushed(new MessagingEngine(sIBUuid8), sIBUuid8, sIBUuid12);
            } else if (streamInfo.stream != null) {
                if (controlMessageType == ControlMessageType.ACCEPT) {
                    ControlAccept controlAccept = (ControlAccept)controlMessage;
                    long[] lArray = controlAccept.getTick();
                    streamInfo.stream.processAccept(lArray);
                } else if (controlMessageType == ControlMessageType.REJECT) {
                    ControlReject controlReject = (ControlReject)controlMessage;
                    long[] lArray = controlReject.getStartTick();
                    long[] lArray2 = controlReject.getEndTick();
                    boolean bl = controlReject.getRecovery();
                    streamInfo.stream.processReject(lArray, lArray2, bl);
                } else if (controlMessageType == ControlMessageType.COMPLETED) {
                    ControlCompleted controlCompleted = (ControlCompleted)controlMessage;
                    long[] lArray = controlCompleted.getStartTick();
                    long[] lArray3 = controlCompleted.getEndTick();
                    streamInfo.stream.processCompleted(lArray, lArray3);
                } else if (controlMessageType == ControlMessageType.REQUEST) {
                    ControlRequest controlRequest = (ControlRequest)controlMessage;
                    String[] stringArray = controlRequest.getControlDisciminator();
                    String[] stringArray2 = controlRequest.getFilter();
                    int[] nArray = controlRequest.getSelectorDomain();
                    long[] lArray = controlRequest.getGetTick();
                    long[] lArray4 = controlRequest.getRejectStartTick();
                    long[] lArray5 = controlRequest.getTimeout();
                    streamInfo.stream.processRequest(stringArray, nArray, stringArray2, lArray4, lArray, lArray5);
                } else if (controlMessageType == ControlMessageType.HIGHESTGENERATEDTICK) {
                    ControlHighestGeneratedTick controlHighestGeneratedTick = (ControlHighestGeneratedTick)controlMessage;
                    long l = controlHighestGeneratedTick.getRequestID();
                    long l3 = controlHighestGeneratedTick.getTick();
                    streamInfo.stream.processHighestGeneratedTick(l, l3);
                } else if (controlMessageType == ControlMessageType.AREYOUFLUSHED) {
                    ControlAreYouFlushed controlAreYouFlushed = (ControlAreYouFlushed)controlMessage;
                    long l = controlAreYouFlushed.getRequestID();
                    streamInfo.stream.processAreYouFlushed(l, null);
                } else if (controlMessageType == ControlMessageType.REQUESTFLUSH) {
                    streamInfo.stream.processRequestFlush();
                } else if (controlMessageType == ControlMessageType.RESETREQUESTACKACK) {
                    ControlResetRequestAckAck controlResetRequestAckAck = (ControlResetRequestAckAck)controlMessage;
                    long l = controlResetRequestAckAck.getDMEVersion();
                    if (this.dmeVersion == l) {
                        streamInfo.stream.processResetRequestAckAck();
                    }
                } else if (controlMessageType != ControlMessageType.REQUESTCARDINALITYINFO) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1081:1.77"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlMessage", (String)"1:1088:1.77", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1094:1.77"});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"handleControlMessage", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleControlBrowseGet(SIBUuid8 sIBUuid8, long l, SelectionCriteria selectionCriteria, long l2) {
        boolean bl;
        AOBrowserSession aOBrowserSession;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlBrowseGet", (Object)new Object[]{sIBUuid8, new Long(l), selectionCriteria, new Long(l2)});
        }
        AOBrowserSessionKey aOBrowserSessionKey = new AOBrowserSessionKey(sIBUuid8, l);
        Object object = this;
        synchronized (object) {
            if (this.startedCloseAndFlush) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleControlBrowseGet");
                }
                return;
            }
            aOBrowserSession = (AOBrowserSession)this.browserSessionTable.get(aOBrowserSessionKey);
        }
        if (aOBrowserSession == null) {
            if (l2 == 0L) {
                object = null;
                try {
                    NonLockingCursor nonLockingCursor;
                    AOBrowserSession aOBrowserSession2;
                    if (selectionCriteria != null && selectionCriteria.getSelectorString() != null && !selectionCriteria.getSelectorString().equals("") || selectionCriteria.getDiscriminator() != null && !selectionCriteria.getDiscriminator().equals("")) {
                        object = new MessageSelectorFilter(this.mp, selectionCriteria);
                    }
                    if ((aOBrowserSession2 = this.browserSessionTable.put(aOBrowserSessionKey = (aOBrowserSession = new AOBrowserSession(this, nonLockingCursor = this.cd.getBrowseCursor((Filter)object), sIBUuid8, l, this.mp.getAlarmManager())).getKey(), aOBrowserSession)) != null) {
                        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1166:1.77"}, null));
                        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1173:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:1180:1.77"});
                        aOBrowserSession2.close();
                    }
                }
                catch (SISelectorSyntaxException sISelectorSyntaxException) {
                    FFDCFilter.processException((Throwable)sISelectorSyntaxException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1188:1.77", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sISelectorSyntaxException));
                    this.sendBrowseEnd(new MessagingEngine(sIBUuid8), sIBUuid8, l, 3);
                    aOBrowserSession = null;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlBrowseGet", (String)"1:1198:1.77", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                    this.sendBrowseEnd(new MessagingEngine(sIBUuid8), sIBUuid8, l, 1);
                    aOBrowserSession = null;
                }
            } else {
                this.sendBrowseEnd(new MessagingEngine(sIBUuid8), sIBUuid8, l, 2);
            }
        }
        if (aOBrowserSession != null && (bl = aOBrowserSession.next(l2))) {
            this.browserSessionTable.remove(aOBrowserSessionKey);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlBrowseGet");
        }
    }

    private final void handleControlBrowseStatus(SIBUuid8 sIBUuid8, long l, int n) {
        AOBrowserSessionKey aOBrowserSessionKey;
        AOBrowserSession aOBrowserSession;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlBrowseStatus", (Object)new Object[]{sIBUuid8, new Long(l), new Integer(n)});
        }
        if ((aOBrowserSession = (AOBrowserSession)this.browserSessionTable.get(aOBrowserSessionKey = new AOBrowserSessionKey(sIBUuid8, l))) != null) {
            if (n == 1) {
                aOBrowserSession.close();
                this.browserSessionTable.remove(aOBrowserSessionKey);
            } else if (n == 0) {
                aOBrowserSession.keepAlive();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlBrowseStatus");
        }
    }

    public final void removeBrowserSession(AOBrowserSessionKey aOBrowserSessionKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeBrowserSession", (Object)aOBrowserSessionKey);
        }
        this.browserSessionTable.remove(aOBrowserSessionKey);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeBrowserSession");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleControlCreateStream(SIBUuid8 sIBUuid8, long l, SIBUuid12 sIBUuid12) {
        StreamInfo streamInfo;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlCreateStream", (Object)new Object[]{sIBUuid8, new Long(l)});
        }
        boolean bl = false;
        Hashtable hashtable = this.streamTable;
        synchronized (hashtable) {
            if (this.startedCloseAndFlush) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleControlCreateStream");
                }
                return;
            }
            streamInfo = (StreamInfo)this.streamTable.get(sIBUuid8);
            if (streamInfo == null) {
                AOConsumerKey aOConsumerKey = null;
                ConsumerKey consumerKey = null;
                if (this.getCardinalityOne()) {
                    try {
                        aOConsumerKey = new AOConsumerKey();
                        consumerKey = this.cd.attachConsumerPoint(aOConsumerKey, null, new SIBUuid12(), false, false);
                    }
                    catch (Exception exception) {
                        bl = true;
                        SibTr.exception((TraceComponent)tc, (Exception)exception);
                    }
                }
                if (!bl) {
                    SIBUuid12 sIBUuid122 = this.generateUniqueStreamName();
                    StreamInfo streamInfo2 = new StreamInfo(sIBUuid8, sIBUuid122, null, null);
                    this.streamTable.put(sIBUuid8, streamInfo2);
                    try {
                        CreatePersistentStream createPersistentStream = new CreatePersistentStream(sIBUuid8, sIBUuid122, l, aOConsumerKey, consumerKey, sIBUuid12, this.cd.getDestination());
                        this.msUpdateThread.enqueueWork(createPersistentStream);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlCreateStream", (String)"1:1336:1.77", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)exception);
                        this.streamTable.remove(sIBUuid8);
                        try {
                            if (consumerKey != null) {
                                consumerKey.detach();
                            }
                        }
                        catch (Exception exception2) {
                            FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.handleControlCreateStream", (String)"1:1352:1.77", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)exception2);
                        }
                    }
                }
            }
        }
        if (streamInfo != null && streamInfo.stream != null) {
            streamInfo.stream.processAreYouFlushed(l, sIBUuid12);
        }
        if (bl) {
            this.sendCardinalityInfo(new MessagingEngine(sIBUuid8), sIBUuid8, l, 1, sIBUuid12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlCreateStream");
        }
    }

    private final StreamInfo getStreamInfo(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12) {
        StreamInfo streamInfo;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamInfo", (Object)new Object[]{sIBUuid8, sIBUuid12});
        }
        if ((streamInfo = (StreamInfo)this.streamTable.get(sIBUuid8)) != null && streamInfo.streamId.equals((Object)sIBUuid12)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getStreamInfo", (Object)streamInfo);
            }
            return streamInfo;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamInfo", null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void streamIsFlushed(AOStream aOStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"streamIsFlushed", (Object)aOStream);
        }
        Hashtable hashtable = this.streamTable;
        synchronized (hashtable) {
            StreamInfo streamInfo = (StreamInfo)this.streamTable.get(aOStream.remoteMEId);
            if (streamInfo != null && streamInfo.streamId.equals((Object)aOStream.streamId)) {
                RemovePersistentStream removePersistentStream = null;
                StreamInfo streamInfo2 = streamInfo;
                synchronized (streamInfo2) {
                    removePersistentStream = new RemovePersistentStream(streamInfo.remoteMEId, streamInfo.streamId, streamInfo.itemStream, streamInfo.item);
                }
                this.doEnqueueWork(removePersistentStream);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"streamIsFlushed");
        }
    }

    private final void initializeControlMessage(ControlMessage controlMessage, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeControlMessage", (Object)new Object[]{controlMessage, sIBUuid8, sIBUuid12});
        }
        controlMessage.setPriority(11);
        controlMessage.setReliability(SIMPConstants.CONTROL_MESSAGE_RELIABILITY);
        controlMessage.setGuaranteedTargetDestinationDefinitionUUID(this.destUuid);
        controlMessage.setGuaranteedStreamUUID(sIBUuid12);
        controlMessage.setGuaranteedSourceMessagingEngineUUID(this.mp.getMessagingEngineUuid());
        controlMessage.setGuaranteedTargetMessagingEngineUUID(sIBUuid8);
        controlMessage.setGuaranteedProtocolType(ProtocolType.ANYCASTINPUT);
        controlMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeControlMessage");
        }
    }

    public final void sendBrowseData(SIMPMessage sIMPMessage, MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseData", (Object)new Object[]{sIMPMessage, messagingEngine, sIBUuid8, new Long(l), new Long(l2)});
        }
        try {
            JsMessage jsMessage = sIMPMessage.getMessage().getReceived();
            jsMessage.clearGuaranteedRemoteGet();
            jsMessage.setGuaranteedSourceMessagingEngineUUID(this.mp.getMessagingEngineUuid());
            jsMessage.setGuaranteedTargetMessagingEngineUUID(sIBUuid8);
            jsMessage.setGuaranteedTargetDestinationDefinitionUUID(this.destUuid);
            jsMessage.setGuaranteedStreamUUID(null);
            jsMessage.setGuaranteedProtocolType(ProtocolType.ANYCASTINPUT);
            jsMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
            jsMessage.setGuaranteedRemoteBrowseID(l);
            jsMessage.setGuaranteedRemoteBrowseSequenceNumber(l2);
            this.sendToMe(messagingEngine, 1, (int)jsMessage.getPriority(), jsMessage);
        }
        catch (MessageCopyFailedException messageCopyFailedException) {
            FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendBrowseData", (String)"1:1843:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseData");
        }
    }

    public final void sendBrowseEnd(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, long l, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendBrowseEnd");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlBrowseEnd controlBrowseEnd = controlMessageFactory.createNewControlBrowseEnd();
            this.initializeControlMessage((ControlMessage)controlBrowseEnd, sIBUuid8, null);
            controlBrowseEnd.setBrowseID(l);
            controlBrowseEnd.setExceptionCode(n);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlBrowseEnd);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendBrowseEnd", (String)"1:1876:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendBrowseEnd");
        }
    }

    public final void sendRequestHighestGeneratedTick(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestHighestGeneratedTick");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlRequestHighestGeneratedTick controlRequestHighestGeneratedTick = controlMessageFactory.createNewControlRequestHighestGeneratedTick();
            this.initializeControlMessage((ControlMessage)controlRequestHighestGeneratedTick, sIBUuid8, sIBUuid12);
            controlRequestHighestGeneratedTick.setRequestID(l);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlRequestHighestGeneratedTick);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendRequestHighestGeneratedTick", (String)"1:1908:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestHighestGeneratedTick");
        }
    }

    public final void sendRemoteGetData(SIMPMessage sIMPMessage, MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long l, long l2, long l3, long l4) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRemoteGetData", (Object)new Object[]{sIMPMessage, messagingEngine, sIBUuid8, sIBUuid12, new Long(l), new Long(l2), new Long(l3), new Long(l4)});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        jsMessage.clearGuaranteedRemoteBrowse();
        jsMessage.setGuaranteedSourceMessagingEngineUUID(this.mp.getMessagingEngineUuid());
        jsMessage.setGuaranteedTargetMessagingEngineUUID(sIBUuid8);
        jsMessage.setGuaranteedTargetDestinationDefinitionUUID(this.destUuid);
        jsMessage.setGuaranteedStreamUUID(sIBUuid12);
        jsMessage.setGuaranteedProtocolType(ProtocolType.ANYCASTINPUT);
        jsMessage.setGuaranteedProtocolVersion(GDConfig.PROTOCOL_VERSION);
        jsMessage.setRedeliveredCount(sIMPMessage.guessRedeliveredCount());
        jsMessage.setGuaranteedRemoteGetPrevTick(l);
        jsMessage.setGuaranteedRemoteGetStartTick(l2);
        jsMessage.setGuaranteedRemoteGetValueTick(l3);
        jsMessage.setGuaranteedRemoteGetWaitTime(l4);
        this.sendToMe(messagingEngine, 1, (int)jsMessage.getPriority(), jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRemoteGetData");
        }
    }

    public final void sendCompleted(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompleted");
        }
        long[] lArray = new long[list.size()];
        long[] lArray2 = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            TickRange tickRange = (TickRange)list.get(i);
            lArray[i] = tickRange.startstamp;
            lArray2[i] = tickRange.endstamp;
        }
        this.sendCompletedInternal(messagingEngine, sIBUuid8, sIBUuid12, lArray, lArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompleted");
        }
    }

    public final void sendCompleted(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, TickRange tickRange) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompleted");
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        lArray[0] = tickRange.startstamp;
        lArray2[0] = tickRange.endstamp;
        this.sendCompletedInternal(messagingEngine, sIBUuid8, sIBUuid12, lArray, lArray2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompleted");
        }
    }

    public final void sendCompletedInternal(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long[] lArray, long[] lArray2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCompletedInternal");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlCompleted controlCompleted = controlMessageFactory.createNewControlCompleted();
            this.initializeControlMessage((ControlMessage)controlCompleted, sIBUuid8, sIBUuid12);
            controlCompleted.setStartTick(lArray);
            controlCompleted.setEndTick(lArray2);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlCompleted);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendCompletedInternal", (String)"1:2028:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCompletedInternal");
        }
    }

    public final void sendDecisionExpected(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendDecisionExpected");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlDecisionExpected controlDecisionExpected = controlMessageFactory.createNewControlDecisionExpected();
            this.initializeControlMessage((ControlMessage)controlDecisionExpected, sIBUuid8, sIBUuid12);
            long[] lArray = new long[list.size()];
            for (int i = 0; i < lArray.length; ++i) {
                AOValue aOValue = (AOValue)list.get(i);
                lArray[i] = aOValue.getTick();
            }
            controlDecisionExpected.setTick(lArray);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlDecisionExpected);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendDecisionExpected", (String)"1:2075:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendDecisionExpected");
        }
    }

    public final void sendFlushed(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushed");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlFlushed controlFlushed = controlMessageFactory.createNewControlFlushed();
            this.initializeControlMessage((ControlMessage)controlFlushed, sIBUuid8, sIBUuid12);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlFlushed);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendFlushed", (String)"1:2106:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushed");
        }
    }

    public final void sendCardinalityInfo(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, long l, int n, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendCardinalityInfo");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlCardinalityInfo controlCardinalityInfo = controlMessageFactory.createNewControlCardinalityInfo();
            this.initializeControlMessage((ControlMessage)controlCardinalityInfo, sIBUuid8, null);
            controlCardinalityInfo.setRequestID(l);
            controlCardinalityInfo.setCardinality(n);
            if (sIBUuid12 != null) {
                controlCardinalityInfo.setGuaranteedProtocolType(ProtocolType.DURABLEINPUT);
            }
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlCardinalityInfo);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendCardinalityInfo", (String)"1:2144:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendCardinalityInfo");
        }
    }

    public final void sendNotFlushed(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long l, long l2, long l3, SIBUuid12 sIBUuid122) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushed");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlNotFlushed controlNotFlushed = controlMessageFactory.createNewControlNotFlushed();
            this.initializeControlMessage((ControlMessage)controlNotFlushed, sIBUuid8, sIBUuid12);
            controlNotFlushed.setRequestID(l);
            int[] nArray = new int[]{0};
            controlNotFlushed.setCompletedPrefixPriority(nArray);
            controlNotFlushed.setCompletedPrefixQOS(nArray);
            controlNotFlushed.setDuplicatePrefixPriority(nArray);
            controlNotFlushed.setDuplicatePrefixQOS(nArray);
            long[] lArray = new long[]{l2};
            controlNotFlushed.setCompletedPrefixTicks(lArray);
            long[] lArray2 = new long[]{l3};
            controlNotFlushed.setDuplicatePrefixTicks(lArray2);
            if (sIBUuid122 != null) {
                controlNotFlushed.setGuaranteedProtocolType(ProtocolType.DURABLEINPUT);
            }
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlNotFlushed);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendNotFlushed", (String)"1:2196:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushed");
        }
    }

    public final void sendRequestAck(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long l, long[] lArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestAck");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlRequestAck controlRequestAck = controlMessageFactory.createNewControlRequestAck();
            this.initializeControlMessage((ControlMessage)controlRequestAck, sIBUuid8, sIBUuid12);
            controlRequestAck.setDMEVersion(l);
            controlRequestAck.setTick(lArray);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlRequestAck);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendRequestAck", (String)"1:2230:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestAck");
        }
    }

    public final void sendResetRequestAck(MessagingEngine messagingEngine, SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendResetRequestAck");
        }
        try {
            ControlMessageFactory controlMessageFactory = MessageProcessor.getControlMessageFactory();
            ControlResetRequestAck controlResetRequestAck = controlMessageFactory.createNewControlResetRequestAck();
            this.initializeControlMessage((ControlMessage)controlResetRequestAck, sIBUuid8, sIBUuid12);
            controlResetRequestAck.setDMEVersion(l);
            this.sendToMe(messagingEngine, 1, 11, (ControlMessage)controlResetRequestAck);
        }
        catch (MessageCreateFailedException messageCreateFailedException) {
            FFDCFilter.processException((Throwable)messageCreateFailedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.sendResetRequestAck", (String)"1:2262:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCreateFailedException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendResetRequestAck");
        }
    }

    public final AOValue persistLockAndTick(Transaction transaction, AOStream aOStream, long l, SIMPMessage sIMPMessage, int n, long l2, long l3) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistLockAndTick");
        }
        AOValue aOValue = null;
        try {
            sIMPMessage.persistLock(transaction);
            long l4 = sIMPMessage.getLockID();
            long l5 = sIMPMessage.getID();
            aOValue = new AOValue(l, l5, n, l4, l2, l3);
            aOStream.itemStream.addItem(aOValue, transaction);
        }
        catch (Exception exception) {
            aOValue = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"persistLockAndTick", (Object)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistLockAndTick", (Object)aOValue);
        }
        return aOValue;
    }

    public final void unlockRejectedTick(Transaction transaction, AOValue aOValue) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockRejectedTick");
        }
        try {
            SIMPMessage sIMPMessage = (SIMPMessage)((Object)(this.msgItemStream == null ? this.msgReferenceStream.findById(aOValue.getMsgId()) : this.msgItemStream.findById(aOValue.getMsgId())));
            sIMPMessage.unlock(aOValue.getPLockId(), transaction);
            aOValue.lockItemIfAvailable(this.controlItemLockID);
            aOValue.remove(transaction, this.controlItemLockID);
        }
        catch (MessageStoreException messageStoreException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"unlockRejectedTick", (Object)((Object)messageStoreException));
            }
            throw messageStoreException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockRejectedTick");
        }
    }

    public final void consumeAcceptedTick(Transaction transaction, AOStream aOStream, AOValue aOValue) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeAcceptedTick");
        }
        try {
            AbstractItem abstractItem = this.msgItemStream == null ? this.msgReferenceStream.findById(aOValue.getMsgId()) : this.msgItemStream.findById(aOValue.getMsgId());
            SIMPMessage sIMPMessage = (SIMPMessage)((Object)abstractItem);
            sIMPMessage.remove(transaction, aOValue.getPLockId());
            aOValue.lockItemIfAvailable(this.controlItemLockID);
            aOValue.remove(transaction, this.controlItemLockID);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"consumeAcceptedTick", (Object)exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeAcceptedTick");
        }
    }

    public final Item writeStartedFlush(Transaction transaction, AOStream aOStream) throws Exception {
        StreamInfo streamInfo;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeStartedFlush");
        }
        if ((streamInfo = (StreamInfo)this.streamTable.get(aOStream.remoteMEId)) != null && streamInfo.streamId.equals((Object)aOStream.streamId)) {
            AOStartedFlushItem aOStartedFlushItem = new AOStartedFlushItem(aOStream.remoteMEId, aOStream.streamId);
            this.containerItemStream.addItem(aOStartedFlushItem, transaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writeStartedFlush", (Object)aOStartedFlushItem);
            }
            return aOStartedFlushItem;
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2415:1.77"}, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.writeStartedFlush", (String)"1:2422:1.77", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2427:1.77"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeStartedFlush", (Object)((Object)sIErrorException));
        }
        throw sIErrorException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writtenStartedFlush(AOStream aOStream, Item item) {
        StreamInfo streamInfo;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writtenStartedFlush");
        }
        if ((streamInfo = (StreamInfo)this.streamTable.get(aOStream.remoteMEId)) != null && streamInfo.streamId.equals((Object)aOStream.streamId)) {
            StreamInfo streamInfo2 = streamInfo;
            synchronized (streamInfo2) {
                streamInfo.item = (AOStartedFlushItem)item;
            }
        } else {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2461:1.77"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.writtenStartedFlush", (String)"1:2468:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2475:1.77"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"writtenStartedFlush", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writtenStartedFlush");
        }
    }

    public final long generateUniqueValue() throws SIResourceException {
        return this.mp.nextTick();
    }

    private final SIBUuid12 generateUniqueStreamName() {
        return new SIBUuid12();
    }

    public final ExternalLocalTransaction getTransaction() {
        SIMPTransactionManager sIMPTransactionManager = this.mp.getTXManager();
        ExternalLocalTransaction externalLocalTransaction = sIMPTransactionManager.createLocalTransaction();
        return externalLocalTransaction;
    }

    public final MessageStore getMessageStore() {
        return this.mp.getMessageStore();
    }

    public final ConsumerDispatcher getConsumerDispatcher() {
        return this.cd;
    }

    public final SelectionCriteria createSelectionCriteria(String string, String string2, SelectorDomain selectorDomain) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSelectionCriteria", (Object)new Object[]{string, string2, selectorDomain});
            SibTr.exit((TraceComponent)tc, (String)"createSelectionCriteria");
        }
        return this.mp.getSelectionCriteriaFactory().createSelectionCriteria(string, string2, selectorDomain);
    }

    private final void doEnqueueWork(AsyncUpdate asyncUpdate) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doEnqueueWork", (Object)asyncUpdate);
        }
        try {
            this.msUpdateThread.enqueueWork(asyncUpdate);
        }
        catch (ClosedException closedException) {
            FFDCFilter.processException((Throwable)closedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.doEnqueueWork", (String)"1:2541:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)closedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork");
        }
    }

    public void sendToMe(MessagingEngine messagingEngine, int n, int n2, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{messagingEngine, new Integer(n), new Integer(n2), jsMessage});
        }
        MPIO mPIO = this.mp.getMPIO();
        mPIO.sendToMe(messagingEngine, n, n2, jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    public void sendToMe(MessagingEngine messagingEngine, int n, int n2, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{messagingEngine, new Integer(n), new Integer(n2), controlMessage});
        }
        MPIO mPIO = this.mp.getMPIO();
        mPIO.sendToMe(messagingEngine, n, n2, controlMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    public int getCountOfBrowseSessions() {
        return this.browserSessionTable.size();
    }

    public SIMPItemStream getItemStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getItemStream");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getItemStream", (Object)this.containerItemStream);
        }
        return (SIMPItemStream)this.containerItemStream;
    }

    public final String getDestName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestName");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestName", (Object)this.destName);
        }
        return this.destName;
    }

    public final SIBUuid12 getDestUUID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestUUID");
            SibTr.exit((TraceComponent)tc, (String)"getDestUUID", (Object)this.destName);
        }
        return this.destUuid;
    }

    public Iterator getIteratorOverAOStreams() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getIteratorOverAOStreams", (Object)new Object[0]);
        }
        ArrayList<AOStream> arrayList = new ArrayList<AOStream>();
        Enumeration enumeration = this.streamTable.elements();
        while (enumeration.hasMoreElements()) {
            object = (StreamInfo)enumeration.nextElement();
            if (object == null) continue;
            arrayList.add(((StreamInfo)object).stream);
        }
        object = arrayList.iterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getIteratorOverAOStreams", (Object)object);
        }
        return object;
    }

    public final String convertSelectionCriteriasToString(String[] stringArray, int[] nArray, String[] stringArray2) {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"convertSelectionCriteriasToString", (Object)new Object[]{stringArray, nArray, stringArray2});
        }
        String string = "";
        if (stringArray.length == 1) {
            n = 1;
            if (stringArray[0] != null && !stringArray[0].equals("")) {
                n = 0;
            }
            if (n != 0 && (stringArray2[0] == null || stringArray2[0].equals(""))) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"convertSelectionCriteriasToString", (Object)string);
                }
                return string;
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] == null) {
                stringArray[n] = "";
            }
            if (stringArray2[n] == null) {
                stringArray2[n] = "";
            }
            string = string + ":" + stringArray[n] + ":" + SelectorDomain.getSelectorDomain((int)nArray[n]).toString() + ":" + stringArray2[n];
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertSelectionCriteriasToString", (Object)string);
        }
        return string;
    }

    public Hashtable getBrowserSessions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowserSessions");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrowserSessions", (Object)this.browserSessionTable);
        }
        return this.browserSessionTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlushAtSource(SIBUuid8 sIBUuid8) {
        StreamInfo streamInfo;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtSource", (Object)sIBUuid8);
        }
        boolean bl = false;
        Object object = this.streamTable;
        synchronized (object) {
            streamInfo = (StreamInfo)this.streamTable.get(sIBUuid8);
        }
        if (streamInfo == null) {
            bl = true;
        } else {
            if (streamInfo.stream == null) {
                object = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2743:1.77"}, null));
                FFDCFilter.processException((Throwable)object, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.forceFlushAtSource", (String)"1:2749:1.77", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)object);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2755:1.77"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
                }
                throw object;
            }
            try {
                AOValue aOValue;
                object = streamInfo.stream;
                ((AOStream)object).close();
                ArrayList<AOValue> arrayList = new ArrayList<AOValue>();
                NonLockingCursor nonLockingCursor = streamInfo.itemStream.newNonLockingItemCursor(null);
                while ((aOValue = (AOValue)nonLockingCursor.next()) != null) {
                    arrayList.add(aOValue);
                }
                nonLockingCursor.finished();
                this.deleteAndUnlockPersistentStream(streamInfo, arrayList);
                Hashtable hashtable = this.streamTable;
                synchronized (hashtable) {
                    this.streamTable.remove(sIBUuid8);
                }
                bl = true;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.forceFlushAtSource", (String)"1:2795:1.77", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2801:1.77"});
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AnycastOutputHandler", "1:2810:1.77"}, null));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
                }
                throw sIErrorException;
            }
        }
        if (bl) {
            SibTr.info((TraceComponent)tc, (String)"FLUSH_COMPLETE_CWSIP0452", (Object)new Object[]{this.destName, this.mp.getMessagingEngineName(), sIBUuid8});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
        }
    }

    private void deleteAndUnlockPersistentStream(StreamInfo streamInfo, ArrayList arrayList) throws MessageStoreException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAndUnlockPersistentStream", (Object)new Object[]{streamInfo, arrayList});
        }
        AOValue aOValue = null;
        ExternalLocalTransaction externalLocalTransaction = this.getTransaction();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            aOValue = (AOValue)arrayList.get(i);
            this.unlockRejectedTick(externalLocalTransaction, aOValue);
        }
        streamInfo.itemStream.lockItemIfAvailable(this.controlItemLockID);
        streamInfo.itemStream.remove(externalLocalTransaction, this.controlItemLockID);
        if (streamInfo.item != null) {
            streamInfo.item.lockItemIfAvailable(this.controlItemLockID);
            streamInfo.item.remove(externalLocalTransaction, this.controlItemLockID);
        }
        externalLocalTransaction.commit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAndUnlockPersistentStream");
        }
    }

    public void notifyReceiveExclusiveChange(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveExclusiveChange", (Object)new Object[]{bl});
        }
        this.setCardinalityOne(bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveExclusiveChange");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AnycastOutputHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.77");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    class RemovePersistentStream
    extends AsyncUpdateWithRetry {
        final SIBUuid8 remoteMEId;
        final SIBUuid12 streamId;
        final ItemStream itemStream;
        final Item item;

        RemovePersistentStream(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, ItemStream itemStream, Item item) {
            super(4, AnycastOutputHandler.this.msUpdateThread, AnycastOutputHandler.this.destName);
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"RemovePersistentStream", (Object)new Object[]{sIBUuid8, sIBUuid12, itemStream, item});
            }
            this.remoteMEId = sIBUuid8;
            this.streamId = sIBUuid12;
            this.itemStream = itemStream;
            this.item = item;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"RemovePersistentStream", (Object)this);
            }
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            if (this.item != null) {
                this.item.lockItemIfAvailable(AnycastOutputHandler.this.controlItemLockID);
                this.item.remove(transaction, AnycastOutputHandler.this.controlItemLockID);
            }
            this.itemStream.lockItemIfAvailable(AnycastOutputHandler.this.controlItemLockID);
            this.itemStream.remove(transaction, AnycastOutputHandler.this.controlItemLockID);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            Hashtable hashtable = AnycastOutputHandler.this.streamTable;
            synchronized (hashtable) {
                StreamInfo streamInfo = (StreamInfo)AnycastOutputHandler.this.streamTable.get(this.remoteMEId);
                if (streamInfo != null && streamInfo.streamId.equals((Object)this.streamId)) {
                    AnycastOutputHandler.this.streamTable.remove(this.remoteMEId);
                    if (AnycastOutputHandler.this.startedCloseAndFlush && AnycastOutputHandler.this.streamTable.size() == 0) {
                        AnycastOutputHandler.this.finishedCloseAndFlush = true;
                        if (AnycastOutputHandler.this.redriveDeletionThread) {
                            AnycastOutputHandler.this.mp.getDestinationManager().startAsynchDeletion();
                        } else {
                            try {
                                ExternalLocalTransaction externalLocalTransaction = AnycastOutputHandler.this.getTransaction();
                                ((SIMPItemStream)AnycastOutputHandler.this.containerItemStream).removeAll(externalLocalTransaction);
                                externalLocalTransaction.commit();
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.RemovePersistentStream.committed", (String)"1:1775:1.77", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)exception);
                            }
                        }
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class CreatePersistentStream
    extends AsyncUpdateWithRetry {
        final SIBUuid8 remoteMEId;
        final SIBUuid12 streamId;
        final long requestId;
        final AOProtocolItemStream itemStream;
        final AOConsumerKey aock;
        final ConsumerKey ck;
        final SIBUuid12 parentDest;

        CreatePersistentStream(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, long l, AOConsumerKey aOConsumerKey, ConsumerKey consumerKey, SIBUuid12 sIBUuid122, DestinationHandler destinationHandler) {
            super(4, AnycastOutputHandler.this.msUpdateThread, AnycastOutputHandler.this.destName);
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"CreatePersistentStream", (Object)new Object[]{sIBUuid8, sIBUuid12, new Long(l), aOConsumerKey, consumerKey, sIBUuid122, destinationHandler});
            }
            this.remoteMEId = sIBUuid8;
            this.streamId = sIBUuid12;
            this.requestId = l;
            this.itemStream = new AOProtocolItemStream(sIBUuid8, sIBUuid12, destinationHandler);
            this.aock = aOConsumerKey;
            this.ck = consumerKey;
            this.parentDest = sIBUuid122;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"CreatePersistentStream", (Object)this);
            }
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute");
            }
            AnycastOutputHandler.this.containerItemStream.addItemStream(this.itemStream, transaction);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rolledback(Throwable throwable) {
            boolean bl;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            if (!(bl = this.rolledbackRetry(throwable))) {
                Hashtable hashtable = AnycastOutputHandler.this.streamTable;
                synchronized (hashtable) {
                    AnycastOutputHandler.this.streamTable.put(this.remoteMEId, null);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() throws SIResourceException, SINotPossibleInCurrentConfigurationException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            try {
                boolean bl;
                AOStream aOStream = new AOStream(this.remoteMEId, this.streamId, this.itemStream, AnycastOutputHandler.this, AnycastOutputHandler.this.msUpdateThread, true, null, false, AnycastOutputHandler.this.mp, AnycastOutputHandler.this.dmeVersion);
                StreamInfo streamInfo = new StreamInfo(this.remoteMEId, this.streamId, aOStream, this.itemStream);
                if (this.aock != null) {
                    this.aock.init(aOStream, "", new ConsumerKey[]{this.ck}, 0L, AnycastOutputHandler.this.mp.getAlarmManager(), null);
                    aOStream.setConsumerKey(this.aock);
                }
                Hashtable hashtable = AnycastOutputHandler.this.streamTable;
                synchronized (hashtable) {
                    if (AnycastOutputHandler.this.closed) {
                        aOStream.close();
                        aOStream = null;
                        if (this.ck != null) {
                            this.ck.detach();
                        }
                    } else {
                        StreamInfo streamInfo2 = AnycastOutputHandler.this.streamTable.put(this.remoteMEId, streamInfo);
                        if (streamInfo2.stream != null) {
                            AnycastOutputHandler.this.streamTable.put(this.remoteMEId, streamInfo);
                            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.CreatePersistentStream", "1:1586:1.77"}, null));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.CreatePersistentStream", "1:1592:1.77"});
                            throw sIErrorException;
                        }
                    }
                    bl = AnycastOutputHandler.this.startedCloseAndFlush;
                }
                if (aOStream != null) {
                    aOStream.start();
                    if (bl) {
                        aOStream.processRequestFlush();
                    } else {
                        aOStream.processAreYouFlushed(this.requestId, this.parentDest);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.CreatePersistentStream.committed", (String)"1:1611:1.77", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                try {
                    if (this.ck != null) {
                        this.ck.detach();
                    }
                    RemovePersistentStream removePersistentStream = new RemovePersistentStream(this.remoteMEId, this.streamId, this.itemStream, null);
                    AnycastOutputHandler.this.msUpdateThread.enqueueWork(removePersistentStream);
                }
                catch (ClosedException closedException) {
                    // empty catch block
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    public static abstract class AsyncUpdateWithRetry
    extends AsyncUpdate {
        private int repetitionCount;
        private final int repetitionThreshold;
        private final AsyncUpdateThread msUpdateThread;
        private final String destName;

        public AsyncUpdateWithRetry(int n, AsyncUpdateThread asyncUpdateThread, String string) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AsyncUpdateWithRetry", (Object)new Object[]{new Integer(n), asyncUpdateThread, string});
            }
            this.repetitionThreshold = n;
            this.msUpdateThread = asyncUpdateThread;
            this.repetitionCount = 1;
            this.destName = string;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AsyncUpdateWithRetry", (Object)this);
            }
        }

        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            this.rolledbackRetry(throwable);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        public boolean rolledbackRetry(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledbackRetry", (Object)throwable);
            }
            boolean bl = true;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AsyncUpdateWithRetry.rolledbackRetry", (String)"1:1420:1.77", (Object)this);
            SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            ++this.repetitionCount;
            if (this.repetitionCount > this.repetitionThreshold) {
                bl = false;
                Exception exception = new Exception(nls.getFormattedMessage("MSGSTORE_STOP_RETRY_CWSIP0457", new Object[]{this.destName, new Integer(this.repetitionThreshold)}, null));
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AsyncUpdateWithRetry.rolledbackRetry", (String)"1:1436:1.77", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            } else {
                try {
                    this.msUpdateThread.enqueueWork(this);
                }
                catch (ClosedException closedException) {
                    FFDCFilter.processException((Throwable)closedException, (String)"com.ibm.ws.sib.processor.impl.AnycastOutputHandler.AsyncUpdateWithRetry.rolledbackRetry", (String)"1:1448:1.77", (Object)this);
                    bl = false;
                    Exception exception = new Exception(nls.getFormattedMessage("MSGSTORE_STOP_RETRY_CWSIP0457", new Object[]{this.destName, new Integer(this.repetitionCount - 1)}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledbackRetry");
            }
            return bl;
        }
    }

    class StreamInfo {
        final SIBUuid8 remoteMEId;
        final SIBUuid12 streamId;
        AOStream stream;
        AOProtocolItemStream itemStream;
        AOStartedFlushItem item;

        StreamInfo(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, AOStream aOStream, AOProtocolItemStream aOProtocolItemStream) {
            this.remoteMEId = sIBUuid8;
            this.streamId = sIBUuid12;
            this.stream = aOStream;
            this.itemStream = aOProtocolItemStream;
            this.item = null;
        }
    }
}

