/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.MediationLocalizationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.SubscriptionDefinition;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationAlreadyExistsException;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationCorruptException;
import com.ibm.ws.sib.processor.exceptions.SIMPNullParameterException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SubscriptionDefinitionImpl;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPLocalMsgsItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SITemporaryDestinationNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class AdministratorImpl
implements Administrator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)AdministratorImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor messageProcessor;
    private DestinationManager destinationManager;
    private boolean started;

    public AdministratorImpl(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AdministratorImpl", (Object)messageProcessor);
        }
        this.messageProcessor = messageProcessor;
        this.destinationManager = messageProcessor.getDestinationManager();
        this.started = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AdministratorImpl", (Object)this);
        }
    }

    public void createSubscription(String string, SubscriptionDefinition subscriptionDefinition, SITransaction sITransaction) throws SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIMPDestinationCorruptException, SIDurableSubscriptionAlreadyExistsException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        DestinationHandler destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscription", (Object)new Object[]{string, subscriptionDefinition, sITransaction});
        }
        this.checkStarted();
        try {
            destinationHandler = this.destinationManager.getDestination(subscriptionDefinition.getDestination(), false);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscription", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(sITemporaryDestinationNotFoundException.getMessage());
        }
        SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain((int)subscriptionDefinition.getSelectorDomain());
        SelectionCriteria selectionCriteria = this.messageProcessor.getSelectionCriteriaFactory().createSelectionCriteria(subscriptionDefinition.getTopic(), subscriptionDefinition.getSelector(), selectorDomain);
        ConsumerDispatcherState consumerDispatcherState = new ConsumerDispatcherState(string, destinationHandler.getUuid(), selectionCriteria, subscriptionDefinition.isNoLocal(), subscriptionDefinition.getDurableHome(), destinationHandler.getName(), destinationHandler.getBus());
        consumerDispatcherState.setIsCloned(subscriptionDefinition.isSupportsMultipleConsumers());
        consumerDispatcherState.setUser(subscriptionDefinition.getUser(), false);
        if (!destinationHandler.isPubSub()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscription", (Object)"SIIncorrectCallException");
            }
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_USEAGE_ERROR_CWSIP0141", new Object[]{destinationHandler.getName(), this.messageProcessor.getMessagingEngineName(), string}, null));
        }
        destinationHandler.createDurableSubscription(consumerDispatcherState, (Transaction)sITransaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSubscription(String string, boolean bl, SITransaction sITransaction) throws SINotAuthorizedException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SIResourceException, SIIncorrectCallException, SINotPossibleInCurrentConfigurationException {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteSubscription", (Object)new Object[]{string, new Boolean(bl), sITransaction});
        }
        this.checkStarted();
        if (string == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteSubscription", (Object)"SubId is null");
            }
            throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{null, this.messageProcessor.getMessagingEngineName()}, null));
        }
        HashMap hashMap2 = hashMap = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap2) {
            ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)hashMap.get(string);
            if (consumerDispatcher == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSubscription", (Object)"SIDestinationNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{string, this.messageProcessor.getMessagingEngineName()}, null));
            }
            BaseDestinationHandler baseDestinationHandler = consumerDispatcher.getDestination();
            baseDestinationHandler.deleteDurableSubscription(string, (Transaction)sITransaction, this.messageProcessor.getMessagingEngineName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionDefinition querySubscription(String string) throws SIDurableSubscriptionNotFoundException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"querySubscription", (Object)string);
        }
        this.checkStarted();
        if (string == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)"Exception SubId null");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{null, this.messageProcessor.getMessagingEngineName()}, null));
        }
        ConsumerDispatcherState consumerDispatcherState = null;
        HashMap hashMap = this.destinationManager.getDurableSubscriptionsTable();
        Object object2 = hashMap;
        synchronized (object2) {
            object = (ConsumerDispatcher)hashMap.get(string);
            if (object == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)"Subscription not found");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{string, this.messageProcessor.getMessagingEngineName()}, null));
            }
            consumerDispatcherState = ((ConsumerDispatcher)object).getConsumerDispatcherState();
        }
        object2 = null;
        try {
            object2 = this.destinationManager.getDestination(consumerDispatcherState.getTopicSpaceUuid(), true);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(sITemporaryDestinationNotFoundException.getMessage());
        }
        object = new SubscriptionDefinitionImpl(object2.getName(), consumerDispatcherState.getSelectionCriteria().getDiscriminator(), consumerDispatcherState.getSelectionCriteria().getSelectorString(), consumerDispatcherState.getSelectionCriteria().getSelectorDomain().toInt(), consumerDispatcherState.getUser(), consumerDispatcherState.isNoLocal(), consumerDispatcherState.getDurableHome());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"querySubscription", (Object)object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubscriptionList() {
        ArrayList arrayList;
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionList");
        }
        HashMap hashMap2 = hashMap = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap2) {
            arrayList = new ArrayList(hashMap.keySet());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionList", arrayList);
        }
        return arrayList;
    }

    public SubscriptionDefinition createSubscriptionDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionDefinition");
        }
        SubscriptionDefinitionImpl subscriptionDefinitionImpl = new SubscriptionDefinitionImpl();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionDefinition", (Object)subscriptionDefinitionImpl);
        }
        return subscriptionDefinitionImpl;
    }

    public void createDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition localizationDefinition, MediationLocalizationDefinition mediationLocalizationDefinition) throws SIBExceptionDestinationNotFound, SIBExceptionBase, SIResourceException, SIMPDestinationAlreadyExistsException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createDestinationLocalization", (Object)new Object[]{destinationDefinition, localizationDefinition, mediationLocalizationDefinition});
        }
        this.checkStarted();
        Set set = this.messageProcessor.getSIBDestinationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        Set set2 = this.messageProcessor.getSIBMediationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        this.destinationManager.createDestinationLocalization(localizationDefinition, mediationLocalizationDefinition, destinationDefinition, set, set2, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestinationLocalization");
        }
    }

    public void alterDestinationLocalization(DestinationDefinition destinationDefinition, LocalizationDefinition localizationDefinition, MediationLocalizationDefinition mediationLocalizationDefinition) throws SIBExceptionDestinationNotFound, SIBExceptionBase, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alterDestinationLocalization", (Object)new Object[]{localizationDefinition, destinationDefinition});
        }
        this.checkStarted();
        Set set = this.messageProcessor.getSIBDestinationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        Set set2 = this.messageProcessor.getSIBMediationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        this.destinationManager.alterDestinationLocalization(localizationDefinition, mediationLocalizationDefinition, destinationDefinition, set, set2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alterDestinationLocalization");
        }
    }

    public void deleteDestinationLocalization(String string, DestinationDefinition destinationDefinition) throws SIBExceptionDestinationNotFound, SIBExceptionBase, SITemporaryDestinationNotFoundException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDestinationLocalization", (Object)new Object[]{string});
        }
        this.checkStarted();
        Set set = null;
        Set set2 = null;
        if (destinationDefinition != null) {
            set = this.messageProcessor.getSIBDestinationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
            set2 = this.messageProcessor.getSIBMediationLocalitySet(null, destinationDefinition.getUUID().toString(), true);
        }
        this.destinationManager.deleteDestinationLocalization(string, destinationDefinition, set, set2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestinationLocalization");
        }
    }

    public LocalizationDefinition getDestinationLocalizationDefinition(String string) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationLocalizationDefinition", (Object)string);
        }
        this.checkStarted();
        LocalizationDefinition localizationDefinition = null;
        DestinationHandler destinationHandler = null;
        try {
            destinationHandler = this.destinationManager.getDestination(new SIBUuid12(string), false);
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getDestinationLocalizationDefinition", (Object)"SINotPossibleInCurrentConfigurationException");
            }
            throw new SINotPossibleInCurrentConfigurationException(sITemporaryDestinationNotFoundException.getMessage());
        }
        if (destinationHandler.isPubSub()) {
            PubSubMessageItemStream pubSubMessageItemStream = destinationHandler.getPublishPoint();
            if (pubSubMessageItemStream != null) {
                localizationDefinition = pubSubMessageItemStream.getLocalizationDefinition();
            }
        } else {
            PtoPLocalMsgsItemStream ptoPLocalMsgsItemStream = null;
            if (!destinationHandler.isAlias() && !destinationHandler.isForeign() && (ptoPLocalMsgsItemStream = (PtoPLocalMsgsItemStream)destinationHandler.getQueuePoint(this.messageProcessor.getMessagingEngineUuid())) != null) {
                localizationDefinition = ptoPLocalMsgsItemStream.getLocalizationDefinition();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationLocalizationDefinition", (Object)localizationDefinition);
        }
        return localizationDefinition;
    }

    public void initiateCleanUp(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initiateCleanUp", (Object)string);
        }
        DestinationHandler destinationHandler = null;
        try {
            destinationHandler = this.destinationManager.getDestination(new SIBUuid12(string), true);
        }
        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
        }
        catch (SITemporaryDestinationNotFoundException sITemporaryDestinationNotFoundException) {
            // empty catch block
        }
        if (destinationHandler != null) {
            this.destinationManager.markDestinationAsCleanUpPending(destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initiateCleanUp");
        }
    }

    public void createMQLink(VirtualLinkDefinition virtualLinkDefinition, String string, LocalizationDefinition localizationDefinition) throws SIIncorrectCallException, SIMPDestinationAlreadyExistsException, SIResourceException, SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMQLink", (Object)new Object[]{virtualLinkDefinition, string, localizationDefinition});
        }
        this.checkStarted();
        Set set = virtualLinkDefinition.getLinkLocalitySet();
        this.destinationManager.createMQLinkLocalization(string, localizationDefinition, virtualLinkDefinition, set);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMQLink");
        }
    }

    public void createGatewayLink(VirtualLinkDefinition virtualLinkDefinition, String string) throws SIResourceException, SIMPDestinationAlreadyExistsException, SIIncorrectCallException, SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createGatewayLink", (Object)new Object[]{virtualLinkDefinition, string});
        }
        this.checkStarted();
        this.destinationManager.createLinkLocalization(virtualLinkDefinition);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createGatewayLink");
        }
    }

    public boolean destinationExists(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationExists", (Object)string);
        }
        boolean bl = false;
        try {
            bl = this.destinationManager.destinationExists(string, this.messageProcessor.getMessagingEngineBus());
        }
        catch (SIMPNullParameterException sIMPNullParameterException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    public SIMPMessageProcessorControllable getMPRuntimeControl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMPRuntimeControl");
        }
        SIMPMessageProcessorControllable sIMPMessageProcessorControllable = (SIMPMessageProcessorControllable)((Object)this.messageProcessor.getControlAdapter());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMPRuntimeControl", (Object)sIMPMessageProcessorControllable);
        }
        return sIMPMessageProcessorControllable;
    }

    public boolean isStarted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStarted");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isStarted", (Object)this.started);
        }
        return this.started;
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this.started = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStarted");
        }
        AdministratorImpl administratorImpl = this;
        synchronized (administratorImpl) {
            if (!this.isStarted()) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkStarted", (Object)"ME not started");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("MESSAGE_PROCESSOR_NOT_STARTED_ERROR_CWSIP0211", new Object[]{this.messageProcessor.getMessagingEngineName(), this.messageProcessor.getMessagingEngineBus()}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStarted");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AdministratorImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.105");
        }
    }
}

