/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.MPTopicAuths;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.security.auth.SIBAccessControl;
import com.ibm.ws.sib.security.auth.SIBAccessControlException;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.util.Properties;
import javax.security.auth.Subject;

public class AccessChecker {
    private static final TraceComponent tc = SibTr.register((Class)AccessChecker.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private SIBAccessControl _securityAccessChecker;
    private TopicAuthorization _topicAuthorization;
    private MessageProcessor _messageProcessor;
    private MPTopicAuths _mpTopicAuths;

    public AccessChecker(MessageProcessor messageProcessor, SIBAccessControl sIBAccessControl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AccessChecker", (Object)new Object[]{messageProcessor, sIBAccessControl});
        }
        this._messageProcessor = messageProcessor;
        this._securityAccessChecker = sIBAccessControl;
        this._mpTopicAuths = new MPTopicAuths(messageProcessor, messageProcessor.getAuthorisationUtils());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AccessChecker", (Object)this);
        }
    }

    public boolean checkBusAccess(Subject subject) {
        if (tc.isEntryEnabled()) {
            String string = "<null>";
            if (subject != null) {
                string = "subject(" + this._messageProcessor.getAuthorisationUtils().getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"checkBusAccess", (Object)string);
        }
        boolean bl = false;
        try {
            bl = this._securityAccessChecker.checkBusAccess(subject);
        }
        catch (SIBAccessControlException sIBAccessControlException) {
            FFDCFilter.processException((Throwable)sIBAccessControlException, (String)"com.ibm.ws.sib.processor.impl.AccessChecker.checkBusAccess", (String)"1:143:1.24", (Object)this);
            String string = null;
            if (subject != null) {
                string = this._messageProcessor.getAuthorisationUtils().getUserName(subject);
            }
            SibTr.exception((TraceComponent)tc, (Exception)sIBAccessControlException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"AccessChecker", "1:154:1.24", sIBAccessControlException, string});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkBusAccess", (Object)sIBAccessControlException);
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"AccessChecker", "1:164:1.24", sIBAccessControlException, string}, null), (Throwable)sIBAccessControlException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkBusAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void listTopicAuthorisations() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"listTopicAuthorisations");
        }
        try {
            this._securityAccessChecker.listTopicAuthorisations(this._mpTopicAuths);
        }
        catch (SIBAccessControlException sIBAccessControlException) {
            SibTr.exception((TraceComponent)tc, (Exception)sIBAccessControlException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"listTopicAuthorisations");
        }
    }

    public boolean checkDestinationAccess(SecurityContext securityContext, String string, String string2, OperationType operationType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Object[]{securityContext, string, string2, operationType});
        }
        boolean bl = false;
        try {
            if (securityContext.isAlternateUserBased() && operationType != OperationType.IDENTITY_ADOPTER) {
                if (this._securityAccessChecker.checkDestinationAccess(securityContext.getAlternateUser(), string, string2, operationType)) {
                    bl = true;
                }
            } else if (securityContext.isSubjectBased()) {
                if (this._securityAccessChecker.checkDestinationAccess(securityContext.getSubject(), string, string2, operationType)) {
                    bl = true;
                }
            } else if (securityContext.isUserIdBased()) {
                if (this._securityAccessChecker.checkDestinationAccess(securityContext.getUserId(), string, string2, operationType)) {
                    bl = true;
                }
            } else if (securityContext.isMsgBased()) {
                if (this._securityAccessChecker.checkDestinationAccess(securityContext.getMsg(), string, string2, operationType)) {
                    bl = true;
                }
            } else {
                bl = false;
            }
        }
        catch (SIBAccessControlException sIBAccessControlException) {
            FFDCFilter.processException((Throwable)sIBAccessControlException, (String)"com.ibm.ws.sib.processor.impl.AccessChecker.checkDestinationAccess", (String)"1:285:1.24", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)sIBAccessControlException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"AccessChecker", "1:291:1.24", sIBAccessControlException, securityContext.getUserName(operationType != OperationType.IDENTITY_ADOPTER)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)sIBAccessControlException);
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"AccessChecker", "1:303:1.24", sIBAccessControlException, securityContext.getUserName(operationType != OperationType.IDENTITY_ADOPTER)}, null), (Throwable)sIBAccessControlException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDestinationAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkDiscriminatorAccess(SecurityContext securityContext, DestinationHandler destinationHandler, String string, OperationType operationType) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Object[]{securityContext, destinationHandler, string, operationType});
        }
        boolean bl = true;
        if (!securityContext.isSIBServerSubject()) {
            if (operationType.toInt() == 1) {
                if (!this._topicAuthorization.checkPermissionToPublish(destinationHandler, string, securityContext)) {
                    bl = false;
                }
            } else if (!this._topicAuthorization.checkPermissionToSubscribe(destinationHandler, string, securityContext)) {
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDiscriminatorAccess", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setTopicAuthorization(TopicAuthorization topicAuthorization) {
        this._topicAuthorization = topicAuthorization;
    }

    public void setSecurityIDInMessage(Subject subject, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            String string = "<null>";
            if (subject != null) {
                string = "subject(" + this._messageProcessor.getAuthorisationUtils().getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"setSecurityIDInMessage", (Object)new Object[]{string, jsMessage});
        }
        this._securityAccessChecker.setSecurityIDInMessage(subject, jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSecurityIDInMessage");
        }
    }

    public void setSecurityIDInMessage(String string, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSecurityIDInMessage", (Object)new Object[]{string, jsMessage});
        }
        this._securityAccessChecker.setSecurityIDInMessage(string, jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSecurityIDInMessage");
        }
    }

    public void fireBusAccessNotAuthorizedEvent(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireBusAccessNotAuthorizedEvent", (Object)new Object[]{string, string2, string3});
        }
        JsMessagingEngine jsMessagingEngine = this._messageProcessor.getMessagingEngine();
        RuntimeEventListener runtimeEventListener = this._messageProcessor.getRuntimeEventListener();
        if (jsMessagingEngine.isEventNotificationEnabled()) {
            if (runtimeEventListener != null) {
                Properties properties = new Properties();
                properties.put("operation", "operation.connect");
                properties.put("security.userid", string2);
                properties.put("security.resource.type", "security.resource.type.bus");
                properties.put("security.resource.name", string);
                properties.put("security.reason", "security.reason.not.authorized");
                runtimeEventListener.runtimeEventOccurred(jsMessagingEngine, "SIB.security.not.authorized", string3, properties);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireBusAccessNotAuthorizedEvent");
        }
    }

    public void fireDestinationAccessNotAuthorizedEvent(String string, String string2, OperationType operationType, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireDestinationAccessNotAuthorizedEvent", (Object)new Object[]{string, string2, operationType, string3});
        }
        JsMessagingEngine jsMessagingEngine = this._messageProcessor.getMessagingEngine();
        RuntimeEventListener runtimeEventListener = this._messageProcessor.getRuntimeEventListener();
        if (jsMessagingEngine.isEventNotificationEnabled()) {
            if (runtimeEventListener != null) {
                Properties properties = new Properties();
                String string4 = null;
                if (operationType == OperationType.BROWSE) {
                    string4 = "operation.browse";
                } else if (operationType == OperationType.CREATE) {
                    string4 = "operation.create";
                } else if (operationType == OperationType.IDENTITY_ADOPTER) {
                    string4 = "operation.identity.adoption";
                } else if (operationType == OperationType.RECEIVE) {
                    string4 = "operation.receive";
                } else if (operationType == OperationType.SEND) {
                    string4 = "operation.send";
                } else if (operationType == OperationType.INQUIRE) {
                    string4 = "operation.inquire";
                }
                properties.put("operation", string4);
                properties.put("security.userid", string2 == null ? "" : string2);
                properties.put("security.resource.type", "security.resource.type.destination");
                properties.put("security.resource.name", string);
                properties.put("security.reason", "security.reason.not.authorized");
                runtimeEventListener.runtimeEventOccurred(jsMessagingEngine, "SIB.security.not.authorized", string3, properties);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireDestinationAccessNotAuthorizedEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AccessChecker.java, SIB.processor, WAS602.SIB, o0610.11 1.24");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

