/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.processor.impl.AbstractAliasDestinationHandler;
import com.ibm.ws.sib.processor.impl.AccessChecker;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.DynamicConfigManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractDestinationHandler
extends SIMPItemStream
implements DestinationHandler {
    private static final TraceComponent tc = SibTr.register((Class)AbstractDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls;
    SIMPTransactionManager txManager;
    ControlAdapter controlAdapter;
    MessageProcessor messageProcessor;
    DestinationManager destinationManager;
    private String busName = null;
    protected AccessChecker accessChecker;
    protected boolean isBusSecure = false;
    private List aliasesThatTargetThisDest = null;
    private boolean isDeleted = false;
    ProducerInputHandler inputHandler = null;

    public AbstractDestinationHandler() {
    }

    public AbstractDestinationHandler(MessageProcessor messageProcessor, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractDestinationHandler", (Object)new Object[]{messageProcessor, string});
        }
        this.initializeNonPersistent(messageProcessor);
        this.busName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractDestinationHandler", (Object)this);
        }
    }

    protected void reconstitute(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)messageProcessor);
        }
        this.initializeNonPersistent(messageProcessor);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    protected void initializeNonPersistent(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)messageProcessor);
        }
        this.messageProcessor = messageProcessor;
        this.txManager = this.messageProcessor.getTXManager();
        this.destinationManager = this.messageProcessor.getDestinationManager();
        this.isBusSecure = this.messageProcessor.isBusSecure();
        if (this.isBusSecure) {
            this.accessChecker = this.messageProcessor.getAccessChecker();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public DestinationManager getDestinationManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationManager");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationManager", (Object)this.destinationManager);
        }
        return this.destinationManager;
    }

    public MessageProcessor getMessageProcessor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this.messageProcessor);
        }
        return this.messageProcessor;
    }

    public SIMPTransactionManager getTransactionManager() {
        return this.txManager;
    }

    public SIMPTransactionManager getTxManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTxManager");
            SibTr.exit((TraceComponent)tc, (String)"getTxManager", (Object)this.txManager);
        }
        return this.txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProducers() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeProducers");
        }
        if (this.aliasesThatTargetThisDest != null) {
            object = this.aliasesThatTargetThisDest;
            synchronized (object) {
                Iterator iterator = this.aliasesThatTargetThisDest.iterator();
                while (iterator.hasNext()) {
                    AbstractAliasDestinationHandler abstractAliasDestinationHandler = (AbstractAliasDestinationHandler)iterator.next();
                    abstractAliasDestinationHandler.closeProducers();
                }
            }
        }
        if ((object = (ProducerInputHandler)this.getInputHandler()) != null) {
            object.closeProducersDestinationDeleted();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeProducers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConsumers() throws SIResourceException {
        ControllableResource controllableResource;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeConsumers");
        }
        if (this.aliasesThatTargetThisDest != null) {
            object2 = this.aliasesThatTargetThisDest;
            synchronized (object2) {
                object = this.aliasesThatTargetThisDest.iterator();
                while (object.hasNext()) {
                    controllableResource = (AbstractAliasDestinationHandler)object.next();
                    ((AbstractDestinationHandler)controllableResource).closeConsumers();
                }
            }
        }
        if (this.isPubSub()) {
            ConsumerDispatcher consumerDispatcher;
            object2 = new SubscriptionTypeFilter();
            ((SubscriptionTypeFilter)object2).LOCAL = Boolean.TRUE;
            object = this.getSubscriptionIndex().iterator((IndexFilter)object2);
            while (object.hasNext()) {
                controllableResource = (ControllableSubscription)object.next();
                consumerDispatcher = (ConsumerDispatcher)controllableResource.getOutputHandler();
                if (!consumerDispatcher.getConsumerDispatcherState().getTopicSpaceUuid().equals((Object)this.getUuid())) continue;
                consumerDispatcher.closeAllConsumersForDelete(this);
            }
            this.messageProcessor.getProxyHandler().topicSpaceDeletedEvent(this);
            if (this.isAlias()) {
                object = this.getSubscriptionIndex().iterator((IndexFilter)object2);
                while (object.hasNext()) {
                    controllableResource = (ControllableSubscription)object.next();
                    consumerDispatcher = (ConsumerDispatcher)controllableResource.getOutputHandler();
                    if (!consumerDispatcher.getConsumerDispatcherState().getTopicSpaceUuid().equals((Object)this.getUuid()) || !consumerDispatcher.isDurable()) continue;
                    SubscriptionItemStream subscriptionItemStream = (SubscriptionItemStream)consumerDispatcher.getReferenceStream();
                    subscriptionItemStream.markAsToBeDeleted();
                    subscriptionItemStream.deleteIfPossible(true);
                    this.messageProcessor.getProxyHandler().unsubscribeEvent(consumerDispatcher.getConsumerDispatcherState(), null, true);
                }
                object.finished();
            }
        } else {
            object2 = this.getQueuePoint(this.messageProcessor.getMessagingEngineUuid());
            if (object2 != null) {
                object = ((PtoPMessageItemStream)object2).getOutputHandler();
                controllableResource = (ConsumerDispatcher)object;
                ((ConsumerDispatcher)controllableResource).closeAllConsumersForDelete(this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeConsumers");
        }
    }

    public boolean isPubSub() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isPubSub");
        }
        boolean bl2 = bl = this.getDestinationType() == DestinationType.TOPICSPACE;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isPubSub", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isLink() {
        return false;
    }

    public boolean isForeignBus() {
        return false;
    }

    public boolean isMQLink() {
        return false;
    }

    public InputHandler getInputHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInputHandler");
            SibTr.exit((TraceComponent)tc, (String)"getInputHandler", (Object)this.inputHandler);
        }
        return this.inputHandler;
    }

    void setBus(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBus", (Object)string);
        }
        this.busName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBus");
        }
    }

    public String getBus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBus");
            SibTr.exit((TraceComponent)tc, (String)"getBus", (Object)this.busName);
        }
        return this.busName;
    }

    public Object getContextValue(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getContextValue", (Object)string);
        }
        Map map = this.getDefinition().getDestinationContext();
        Object v = map.get(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getContextValue", v);
        }
        return v;
    }

    public String getDescription() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        String string = this.getDefinition().getDescription();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)string);
        }
        return string;
    }

    public ControlAdapter getControlAdapter() {
        return this.controlAdapter;
    }

    public void dereferenceControlAdapter() {
        this.controlAdapter.dereferenceControllable();
        this.controlAdapter = null;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String string = this.getDefinition().getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)string);
        }
        return string;
    }

    public SIBUuid12 getUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
        }
        SIBUuid12 sIBUuid12 = this.getDefinition().getUUID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)sIBUuid12);
        }
        return sIBUuid12;
    }

    public SIBUuid12 getBaseUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBaseUuid");
        }
        SIBUuid12 sIBUuid12 = this.getDefinition().getUUID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBaseUuid", (Object)sIBUuid12);
        }
        return sIBUuid12;
    }

    public String toString() {
        return "Destination " + this.getDefinition().getName() + " : " + this.getDefinition().getUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargettingAlias(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTargettingAlias", (Object)destinationHandler);
        }
        if (this.aliasesThatTargetThisDest == null) {
            this.aliasesThatTargetThisDest = new ArrayList();
        }
        List list = this.aliasesThatTargetThisDest;
        synchronized (list) {
            this.aliasesThatTargetThisDest.add(destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTargettingAlias");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargettingAlias(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTargettingAlias", (Object)destinationHandler);
        }
        List list = this.aliasesThatTargetThisDest;
        synchronized (list) {
            this.aliasesThatTargetThisDest.remove(destinationHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTargettingAlias");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTargettingAliases() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteTargettingAliases");
        }
        if (this.aliasesThatTargetThisDest != null) {
            DynamicConfigManager dynamicConfigManager = this.messageProcessor.getDynamicConfigManager();
            List list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                Iterator iterator = this.aliasesThatTargetThisDest.iterator();
                while (iterator.hasNext()) {
                    AbstractAliasDestinationHandler abstractAliasDestinationHandler = (AbstractAliasDestinationHandler)iterator.next();
                    abstractAliasDestinationHandler.deleteTargettingAliases();
                    dynamicConfigManager.deleteAbstractAliasDestinationHandler(abstractAliasDestinationHandler);
                    iterator.remove();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteTargettingAliases");
        }
    }

    public boolean isDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDeleted");
            SibTr.exit((TraceComponent)tc, (String)"isDeleted", (Object)new Boolean(this.isDeleted));
        }
        return this.isDeleted;
    }

    public void setDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDeleted");
            SibTr.exit((TraceComponent)tc, (String)"setDeleted");
        }
        this.isDeleted = true;
    }

    public void reset() throws InvalidOperationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("OPERATION_IS_INVALID_ERROR_CWSIP0121", new Object[]{this.getName(), this.getBus()}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTargettingAliasesReceiveAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyTargettingAliasesReceiveAllowed");
        }
        if (this.aliasesThatTargetThisDest != null) {
            List list = this.aliasesThatTargetThisDest;
            synchronized (list) {
                Iterator iterator = this.aliasesThatTargetThisDest.iterator();
                while (iterator.hasNext()) {
                    AbstractAliasDestinationHandler abstractAliasDestinationHandler = (AbstractAliasDestinationHandler)iterator.next();
                    abstractAliasDestinationHandler.notifyReceiveAllowed(abstractAliasDestinationHandler);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyTargettingAliasesReceiveAllowed");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AbstractDestinationHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.37");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

