/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.processor.impl.AbstractDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.io.IOException;
import java.util.HashMap;

abstract class AbstractBaseDestinationHandler
extends AbstractDestinationHandler {
    private static final TraceComponent tc = SibTr.register((Class)AbstractBaseDestinationHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected DestinationDefinition definition;
    private boolean _isReceiveAllowed = true;

    public AbstractBaseDestinationHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBaseDestinationHandler(MessageProcessor messageProcessor, DestinationDefinition destinationDefinition, String string) {
        super(messageProcessor, string);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractBaseDestinationHandler", (Object)new Object[]{messageProcessor, destinationDefinition, string});
        }
        this.definition = destinationDefinition;
        AbstractBaseDestinationHandler abstractBaseDestinationHandler = this;
        synchronized (abstractBaseDestinationHandler) {
            this._isReceiveAllowed = this.definition != null ? destinationDefinition.isReceiveAllowed() : true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractBaseDestinationHandler", (Object)this);
        }
    }

    public void addPersistentData(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentData", (Object)hashMap);
        }
        hashMap.put("name", this.definition.getName());
        hashMap.put("uuid", this.definition.getUUID().toByteArray());
        hashMap.put("maxReliability", new Integer(this.definition.getMaxReliability().toInt()));
        hashMap.put("defaultReliability", new Integer(this.definition.getDefaultReliability().toInt()));
        hashMap.put("destinationType", new Integer(this.definition.getDestinationType().toInt()));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentData");
        }
    }

    public long getAlterationTime() {
        return this.definition.getAlterationTime();
    }

    public int getDefaultPriority() {
        return this.definition.getDefaultPriority();
    }

    public Reliability getDefaultReliability() {
        return this.definition.getDefaultReliability();
    }

    public DestinationType getDestinationType() {
        return this.definition.getDestinationType();
    }

    public String getExceptionDestination() {
        return this.definition.getExceptionDestination();
    }

    public int getMaxFailedDeliveries() {
        return this.definition.getMaxFailedDeliveries();
    }

    public Reliability getMaxReliability() {
        return this.definition.getMaxReliability();
    }

    public MediationDefinition getMediationDefinition() {
        return this.definition.getMediationDefinition();
    }

    public BaseDestinationDefinition getDefinition() {
        return this.definition;
    }

    public boolean isAlias() {
        return false;
    }

    public boolean isForeign() {
        return false;
    }

    public synchronized boolean isReceiveAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReceiveAllowed");
            SibTr.exit((TraceComponent)tc, (String)"isReceiveAllowed", (Object)new Boolean(this._isReceiveAllowed));
        }
        return this._isReceiveAllowed;
    }

    public boolean isSendAllowed() {
        return this.definition.isSendAllowed();
    }

    public boolean isMediationEnabled() {
        return this.definition.isMediationEnabled();
    }

    public boolean isOverrideOfQOSByProducerAllowed() {
        return this.definition.isOverrideOfQOSByProducerAllowed();
    }

    public boolean isReceiveExclusive() {
        return this.definition.isReceiveExclusive();
    }

    public void restorePersistentData(HashMap hashMap) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restorePersistentData", (Object)hashMap);
        }
        int n = (Integer)hashMap.get("destinationType");
        DestinationType destinationType = DestinationType.getDestinationType((int)n);
        String string = (String)hashMap.get("name");
        JsAdminFactory jsAdminFactory = JsAdminFactory.getInstance();
        this.definition = jsAdminFactory.createDestinationDefinition(destinationType, string);
        this.definition.setUUID(new SIBUuid12((byte[])hashMap.get("uuid")));
        int n2 = (Integer)hashMap.get("maxReliability");
        this.definition.setMaxReliability(Reliability.getReliability((int)n2));
        int n3 = (Integer)hashMap.get("defaultReliability");
        this.definition.setDefaultReliability(Reliability.getReliability((int)n3));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restorePersistentData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefinition(BaseDestinationDefinition baseDestinationDefinition) {
        ControllableResource controllableResource;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDefinition", (Object)new Object[]{baseDestinationDefinition});
        }
        DestinationDefinition destinationDefinition = this.definition;
        DestinationDefinition destinationDefinition2 = (DestinationDefinition)baseDestinationDefinition;
        if (destinationDefinition == null || destinationDefinition.isReceiveExclusive() != destinationDefinition2.isReceiveExclusive()) {
            this.notifyAOHReceiveExclusiveChange(destinationDefinition2.isReceiveExclusive());
            controllableResource = this.getLocalPtoPConsumerDispatcher();
            if (controllableResource != null) {
                controllableResource.closeAllConsumersForReceiveExclusive();
            }
            this.notifyRCDReceiveExclusiveChange(destinationDefinition2.isReceiveExclusive());
        }
        this.definition = (DestinationDefinition)baseDestinationDefinition;
        if (destinationDefinition == null || destinationDefinition.isReceiveAllowed() != destinationDefinition2.isReceiveAllowed()) {
            controllableResource = this;
            synchronized (controllableResource) {
                this._isReceiveAllowed = destinationDefinition2.isReceiveAllowed();
            }
            this.notifyReceiveAllowed(this);
            this.notifyTargettingAliasesReceiveAllowed();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDefinition");
        }
    }

    protected abstract void notifyAOHReceiveExclusiveChange(boolean var1);

    protected abstract void notifyRCDReceiveExclusiveChange(boolean var1);

    public void notifyReceiveAllowed(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{destinationHandler});
        }
        if (this.isPubSub()) {
            SubscriptionTypeFilter subscriptionTypeFilter = new SubscriptionTypeFilter();
            subscriptionTypeFilter.LOCAL = Boolean.TRUE;
            SIMPIterator sIMPIterator = this.getSubscriptionIndex().iterator(subscriptionTypeFilter);
            while (sIMPIterator.hasNext()) {
                ControllableSubscription controllableSubscription = (ControllableSubscription)sIMPIterator.next();
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)controllableSubscription.getOutputHandler();
                if (consumerDispatcher == null) continue;
                consumerDispatcher.notifyReceiveAllowed(destinationHandler);
            }
            sIMPIterator.finished();
        } else {
            ConsumerDispatcher consumerDispatcher = this.getLocalPtoPConsumerDispatcher();
            if (consumerDispatcher != null) {
                consumerDispatcher.notifyReceiveAllowed(destinationHandler);
            }
        }
        this.notifyReceiveAllowedRCD(destinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.newLine();
        formattedWriter.taggedValue("name", (Object)this.definition.getName());
        formattedWriter.newLine();
        formattedWriter.taggedValue("uuid", (Object)this.definition.getUUID());
    }

    public boolean isTopicAccessCheckRequired() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTopicAccessCheckRequired");
        }
        boolean bl = this.definition.isTopicAccessCheckRequired();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTopicAccessCheckRequired", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/AbstractBaseDestinationHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.28");
        }
    }
}

