/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AOConsumerKey;
import com.ibm.ws.sib.processor.impl.AORequested;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdate;
import com.ibm.ws.sib.processor.impl.store.AsyncUpdateThread;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutManager;
import com.ibm.ws.sib.processor.utils.am.BatchedTimeoutProcessor;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public final class AOStream
extends ControllableStream
implements AlarmListener,
BatchedTimeoutProcessor {
    private MPAlarmManager am;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register((Class)AOStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    public static int NUM_OF_BUCKETS = 4;
    public final SIBUuid8 remoteMEId;
    public final MessagingEngine remoteME;
    public final SIBUuid12 streamId;
    public final AOProtocolItemStream itemStream;
    private final AnycastOutputHandler parent;
    private final StateStream stream;
    private AOStreamState streamState = AOStreamState.ACTIVE;
    private volatile long totalReceivedRequests;
    private long firstUnknownTick;
    private final Hashtable consumerKeyTable;
    private boolean startedFlush;
    private boolean isFlushed;
    private boolean scheduleWriteStartedFlush;
    private boolean completedTicksInitialized;
    private Alarm initRepeatHandler;
    private long initRequestId;
    private long initHighestValueTick;
    private ResetRequestAckSender resetRequestAckSender;
    private final BatchedTimeoutManager dem;
    private long dmeVerion;
    private boolean active;
    private boolean closed;
    private final AsyncUpdateThread msUpdateThread;
    private int countAsyncUpdatesOutstanding;
    private final long[][] latestTick;
    private Alarm inactivityTimer;
    private final InactivityTimerHandler inactivityHandler;
    private boolean messagesReceived = false;
    private static final int ACCEPT_MSG = 1;
    private static final int REJECT_MSG = 2;
    private static final int COMPLETED_MSG = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AOStream(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, AOProtocolItemStream aOProtocolItemStream, AnycastOutputHandler anycastOutputHandler, AsyncUpdateThread asyncUpdateThread, boolean bl, List list, boolean bl2, MessageProcessor messageProcessor, long l) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOStream", (Object)new Object[]{sIBUuid8, sIBUuid12, aOProtocolItemStream, anycastOutputHandler, asyncUpdateThread, new Boolean(bl), list, new Boolean(bl2), messageProcessor, new Long(l)});
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            int n;
            this.remoteMEId = sIBUuid8;
            this.remoteME = new MessagingEngine(sIBUuid8);
            this.streamId = sIBUuid12;
            this.itemStream = aOProtocolItemStream;
            this.parent = anycastOutputHandler;
            this.msUpdateThread = asyncUpdateThread;
            this.countAsyncUpdatesOutstanding = 0;
            this.am = messageProcessor.getAlarmManager();
            this.startedFlush = bl2;
            this.isFlushed = false;
            this.consumerKeyTable = new Hashtable();
            this.scheduleWriteStartedFlush = false;
            this.closed = false;
            this.inactivityHandler = new InactivityTimerHandler();
            this.dmeVerion = l;
            this.latestTick = new long[Reliability.MAX_INDEX + 1][10];
            for (int i = 0; i <= Reliability.MAX_INDEX; ++i) {
                for (n = 0; n <= 9; ++n) {
                    this.latestTick[i][n] = i == Reliability.MAX_INDEX ? 0L : SIMPConstants.UNKNOWN_PREV_TICK;
                }
            }
            this.initHighestValueTick = 0L;
            this.stream = new StateStream();
            this.stream.init();
            if (!bl) {
                Object object;
                int n2;
                ArrayList<AOValue> arrayList = null;
                for (n = 0; n < list.size(); ++n) {
                    try {
                        AOValue aOValue = (AOValue)list.get(n);
                        n2 = 0;
                        if (aOValue.getStorageStrategy() == 3) {
                            object = (SIMPMessage)((Object)(anycastOutputHandler.msgItemStream == null ? anycastOutputHandler.msgReferenceStream.findById(aOValue.getMsgId()) : anycastOutputHandler.msgItemStream.findById(aOValue.getMsgId())));
                            if (object == null) {
                                n2 = 1;
                            } else if (object.getLockID() != aOValue.getPLockId()) {
                                n2 = 1;
                            }
                        }
                        if (n2 != 0) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<AOValue>(10);
                            }
                            arrayList.add(aOValue);
                            continue;
                        }
                        if (aOValue.getTick() > this.initHighestValueTick) {
                            this.initHighestValueTick = aOValue.getTick();
                        }
                        object = TickRange.newValueTick(aOValue.getTick(), aOValue, 0L);
                        this.stream.writeRange((TickRange)object);
                        SIMPMessage sIMPMessage = (SIMPMessage)((Object)(anycastOutputHandler.msgItemStream == null ? anycastOutputHandler.msgReferenceStream.findById(aOValue.getMsgId()) : anycastOutputHandler.msgItemStream.findById(aOValue.getMsgId())));
                        int n3 = sIMPMessage.getReliability().getIndex();
                        int n4 = sIMPMessage.getMessage().getPriority();
                        if (this.latestTick[n3][n4] >= aOValue.getTick()) continue;
                        this.latestTick[n3][n4] = aOValue.getTick();
                        continue;
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AOStream.AOStream", (String)"1:401:1.63", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)exception);
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)exception);
                        }
                        throw exception;
                    }
                }
                if (arrayList != null) {
                    try {
                        ExternalLocalTransaction externalLocalTransaction = anycastOutputHandler.getTransaction();
                        int n5 = arrayList.size();
                        for (n2 = 0; n2 < n5; ++n2) {
                            object = (AOValue)arrayList.get(n2);
                            ((AbstractItem)object).remove(externalLocalTransaction, -2L);
                        }
                        externalLocalTransaction.commit();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AOStream.AOStream", (String)"1:429:1.63", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)exception);
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)exception);
                        }
                        throw exception;
                    }
                }
            }
            this.dem = new BatchedTimeoutManager(NUM_OF_BUCKETS, SIMPConstants.DECISION_EXPECTED_REPETITION_INTERVAL, list, this, messageProcessor);
            if (bl) {
                this.completedTicksInitialized = true;
                this.firstUnknownTick = 1L;
                this.changeUnknownToCompleted(0L, 0L);
            } else if (bl2) {
                this.completedTicksInitialized = true;
                if (list.isEmpty()) {
                    this.isFlushed = true;
                    this.closed = true;
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:471:1.63"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOStream.AOStream", (String)"1:476:1.63", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:482:1.63"});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
                this.firstUnknownTick = Long.MAX_VALUE;
                this.changeUnknownToCompleted(0L, Long.MAX_VALUE);
            } else {
                this.completedTicksInitialized = false;
                this.initRequestId = -1L;
                this.resetRequestAckSender = new ResetRequestAckSender();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOStream", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumerKey(AOConsumerKey aOConsumerKey) {
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.consumerKeyTable.put("", aOConsumerKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            boolean bl;
            this.active = true;
            if (!this.completedTicksInitialized) {
                if (this.initRequestId == -1L) {
                    this.initRequestId = this.parent.generateUniqueValue();
                }
                this.alarm(null);
            }
            if (this.parent.getCardinalityOne() && !this.isFlushed) {
                this.inactivityTimer = this.am.create(SIMPConstants.REMOTE_CONSUMER_CARDINALITY_INACTIVITY_INTERVAL, this.inactivityHandler);
            }
            if (this.resetRequestAckSender != null && (bl = this.resetRequestAckSender.start())) {
                this.resetRequestAckSender = null;
            }
            this.dem.startTimer();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.active = false;
            if (this.initRepeatHandler != null) {
                this.initRepeatHandler.cancel();
            }
            if (this.inactivityTimer != null) {
                this.inactivityTimer.cancel();
                this.inactivityTimer = null;
            }
            if (this.resetRequestAckSender != null) {
                this.resetRequestAckSender.stop();
            }
            this.dem.stopTimer();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public final long getInitRequestId() {
        return this.initRequestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        boolean bl = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.active && !this.completedTicksInitialized) {
                bl = true;
                this.initRepeatHandler = this.am.create(SIMPConstants.INIT_REPETITION_INTERVAL, this);
            }
        }
        if (bl) {
            this.parent.sendRequestHighestGeneratedTick(this.remoteME, this.remoteMEId, this.streamId, this.initRequestId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimedoutEntries(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processTimedoutEntries", (Object)list);
        }
        boolean bl = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.active && this.completedTicksInitialized && !list.isEmpty()) {
                bl = true;
            }
        }
        if (bl) {
            this.parent.sendDecisionExpected(this.remoteME, this.remoteMEId, this.streamId, list);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processTimedoutEntries");
        }
    }

    public final void expiredRequest(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiredRequest", (Object)new Long(l));
        }
        this.expiredRequest(l, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiredRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expiredRequest(long l, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiredRequest", (Object)new Object[]{new Long(l), new Boolean(bl)});
        }
        TickRange tickRange = null;
        boolean bl2 = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.stream.setCursor(l);
            TickRange tickRange2 = this.stream.getNext();
            byte by = tickRange2.type;
            if (by == 1 || by == 0 || bl && by == 3) {
                tickRange = new TickRange(7, l, l);
                this.stream.writeCompleted(tickRange);
                if (!this.active) {
                    tickRange = null;
                }
                bl2 = this.tryTransitionToFlushed();
            }
        }
        if (tickRange != null) {
            this.parent.sendCompleted(this.remoteME, this.remoteMEId, this.streamId, tickRange);
        }
        if (bl2) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiredRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void satisfiedRequest(long l, SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"satisfiedRequest", (Object)new Object[]{new Long(l), sIMPMessage});
        }
        boolean bl = false;
        long l2 = l;
        AOValue aOValue = null;
        boolean bl2 = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            try {
                if (this.startedFlush || this.closed) {
                    sIMPMessage.unlock(sIMPMessage.getLockID());
                    TickRange tickRange = new TickRange(7, l, l);
                    this.stream.writeCompleted(tickRange);
                    bl2 = this.tryTransitionToFlushed();
                } else {
                    this.stream.setCursor(l);
                    TickRange tickRange = this.stream.getNext();
                    if (tickRange.type != 1) {
                        sIMPMessage.unlock(sIMPMessage.getLockID());
                    } else {
                        AORequested aORequested = (AORequested)tickRange.value;
                        long l3 = System.currentTimeMillis() - aORequested.startTime;
                        if (sIMPMessage.getReliability().compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0) {
                            int n = sIMPMessage.getReliability().getIndex();
                            int n2 = sIMPMessage.getMessage().getPriority();
                            aOValue = new AOValue(l, sIMPMessage.getID(), 1, 0L, l3, this.latestTick[n][n2]);
                            this.latestTick[n][n2] = l;
                            TickRange tickRange2 = TickRange.newValueTick(l, aOValue, 0L);
                            this.stream.writeCombinedRange(tickRange2);
                            tickRange2 = this.stream.findCompletedRange(tickRange2);
                            this.dem.addTimeoutEntry(aOValue);
                            if (this.active) {
                                bl = true;
                                l2 = tickRange2.startstamp;
                            }
                        } else {
                            int n = sIMPMessage.getReliability().compareTo((Object)Reliability.ASSURED_PERSISTENT) < 0 ? 3 : 4;
                            ((AORequested)tickRange.value).inserting = true;
                            int n3 = sIMPMessage.getReliability().getIndex();
                            int n4 = sIMPMessage.getMessage().getPriority();
                            PersistLockAndTick persistLockAndTick = new PersistLockAndTick(l, sIMPMessage, n, l3, this.latestTick[n3][n4]);
                            this.latestTick[n3][n4] = l;
                            this.parent.getPersistLockThread().enqueueWork(persistLockAndTick);
                            ++this.countAsyncUpdatesOutstanding;
                        }
                    }
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.AOStream.satisfiedRequest", (String)"1:955:1.63", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AOStream.satisfiedRequest", (String)"1:966:1.63", (Object)this);
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:974:1.63", exception}, null));
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:981:1.63", exception});
            }
        }
        if (bl) {
            long l4 = aOValue.getPrevTick();
            this.parent.sendRemoteGetData(sIMPMessage, this.remoteME, this.remoteMEId, this.streamId, l4, l2, l, aOValue.getWaitTime());
        }
        if (bl2) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"satisfiedRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeConsumerKey(String string, AOConsumerKey aOConsumerKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeConsumerKey", (Object)new Object[]{string, aOConsumerKey});
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            AOConsumerKey aOConsumerKey2 = (AOConsumerKey)this.consumerKeyTable.get(string);
            if (aOConsumerKey2 == aOConsumerKey) {
                this.consumerKeyTable.remove(string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeConsumerKey");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storedTicksRemoved(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"storedTicksRemoved", (Object)arrayList);
        }
        ArrayList<TickRange> arrayList2 = new ArrayList<TickRange>(arrayList.size());
        TickRange tickRange = null;
        boolean bl = false;
        boolean bl2 = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            --this.countAsyncUpdatesOutstanding;
            if (this.active) {
                bl = true;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                AOValue aOValue = (AOValue)arrayList.get(i);
                this.dem.removeTimeoutEntry(aOValue);
                tickRange = new TickRange(7, aOValue.getTick(), aOValue.getTick());
                tickRange = this.stream.writeCompleted(tickRange);
                arrayList2.add(tickRange);
            }
            bl2 = this.tryTransitionToFlushed();
        }
        if (bl) {
            if (arrayList2.size() > 0) {
                this.parent.sendCompleted(this.remoteME, this.remoteMEId, this.streamId, arrayList2);
            }
            if (bl2) {
                this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"storedTicksRemoved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(String[] stringArray, int[] nArray, String[] stringArray2, long[] lArray, long[] lArray2, long[] lArray3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequest", (Object)new Object[]{stringArray, nArray, stringArray2, lArray, lArray2, lArray3});
        }
        ArrayList<AORequested> arrayList = null;
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            long l2 = lArray2[i];
            long l3 = lArray3[i];
            boolean bl = false;
            AOValue aOValue = null;
            SIMPMessage sIMPMessage = null;
            long l4 = l2;
            boolean bl2 = false;
            TickRange tickRange = null;
            AOStream aOStream = this;
            synchronized (aOStream) {
                this.messagesReceived = true;
                if (this.completedTicksInitialized && this.active) {
                    Object object;
                    if (l2 >= this.firstUnknownTick && !this.startedFlush) {
                        if (l >= l2 || l < this.firstUnknownTick) {
                            // empty if block
                        }
                        try {
                            if (this.firstUnknownTick < l2) {
                                tickRange = new TickRange(7, this.firstUnknownTick, l2 - 1L);
                                this.stream.writeCompletedRange(tickRange);
                            }
                            l4 = this.firstUnknownTick;
                            this.firstUnknownTick = l2 + 1L;
                            object = this.findOrCreateAOConsumerKey(stringArray, nArray, stringArray2);
                            sIMPMessage = ((AOConsumerKey)object).newRequest(l2, l3);
                            ++this.totalReceivedRequests;
                            if (sIMPMessage != null) {
                                TickRange tickRange2;
                                if (sIMPMessage.getReliability().compareTo((Object)Reliability.RELIABLE_NONPERSISTENT) <= 0) {
                                    int n = sIMPMessage.getReliability().getIndex();
                                    int n2 = sIMPMessage.getMessage().getPriority();
                                    aOValue = new AOValue(l2, sIMPMessage.getID(), 1, 0L, 0L, this.latestTick[n][n2]);
                                    this.latestTick[n][n2] = l2;
                                    tickRange2 = TickRange.newValueTick(l2, aOValue, 0L);
                                    this.stream.writeCombinedRange(tickRange2);
                                    tickRange2 = this.stream.findCompletedRange(tickRange2);
                                    l4 = tickRange2.startstamp;
                                    this.dem.addTimeoutEntry(aOValue);
                                    bl = true;
                                } else {
                                    int n = sIMPMessage.getReliability().compareTo((Object)Reliability.ASSURED_PERSISTENT) < 0 ? 3 : 4;
                                    AORequested aORequested = new AORequested((AOConsumerKey)object, 0L, l3, l2);
                                    aORequested.inserting = true;
                                    tickRange2 = new TickRange(1, l2, l2);
                                    tickRange2.value = aORequested;
                                    this.stream.writeRange(tickRange2);
                                    int n3 = sIMPMessage.getReliability().getIndex();
                                    int n4 = sIMPMessage.getMessage().getPriority();
                                    PersistLockAndTick persistLockAndTick = new PersistLockAndTick(l2, sIMPMessage, n, 0L, this.latestTick[n3][n4]);
                                    this.latestTick[n3][n4] = l2;
                                    this.parent.getPersistLockThread().enqueueWork(persistLockAndTick);
                                    ++this.countAsyncUpdatesOutstanding;
                                }
                            } else if (l3 != 0L) {
                                AORequested aORequested = new AORequested((AOConsumerKey)object, System.currentTimeMillis(), l3, l2);
                                TickRange tickRange3 = new TickRange(1, l2, l2);
                                tickRange3.value = aORequested;
                                this.stream.writeRange(tickRange3);
                            }
                        }
                        catch (ClosedException closedException) {
                            TickRange tickRange4 = new TickRange(7, l2, l2);
                            this.stream.writeCompletedRange(tickRange4);
                            if (this.parent.getCardinalityOne()) {
                                this.processRequestFlush();
                            }
                        }
                        catch (MessageStoreException messageStoreException) {
                            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.AOStream.processRequest", (String)"1:1521:1.63", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        }
                        catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                            FFDCFilter.processException((Throwable)sINotPossibleInCurrentConfigurationException, (String)"com.ibm.ws.sib.processor.impl.AOStream.processRequest", (String)"1:1531:1.63", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)sINotPossibleInCurrentConfigurationException));
                        }
                    } else {
                        this.stream.setCursor(l2);
                        object = this.stream.getNext();
                        if (((TickRange)object).type == 7) {
                            bl2 = true;
                            tickRange = object;
                        } else if (((TickRange)object).type == 3) {
                            aOValue = (AOValue)((TickRange)object).value;
                            sIMPMessage = (SIMPMessage)((Object)(this.parent.msgItemStream == null ? this.parent.msgReferenceStream.findById(aOValue.getMsgId()) : this.parent.msgItemStream.findById(aOValue.getMsgId())));
                            l4 = l2;
                            bl = true;
                        } else if (((TickRange)object).type == 1) {
                            AORequested aORequested = (AORequested)((TickRange)object).value;
                            if (!aORequested.inserting) {
                                long l5;
                                if (aORequested.expiryInterval == SIMPConstants.INFINITE_TIMEOUT) {
                                    l5 = Long.MAX_VALUE;
                                } else {
                                    long l6 = System.currentTimeMillis() - aORequested.startTime;
                                    l5 = aORequested.expiryInterval - l6;
                                }
                                if (l5 >= SIMPConstants.SLOWED_GET_REQUEST_INTERVAL) {
                                    if (arrayList == null) {
                                        arrayList = new ArrayList<AORequested>(lArray2.length);
                                    }
                                    arrayList.add(aORequested);
                                }
                            }
                        }
                    }
                }
            }
            if (bl) {
                long l7 = SIMPConstants.UNKNOWN_PREV_TICK;
                if (this.parent.getCardinalityOne()) {
                    l7 = aOValue.getPrevTick();
                }
                this.parent.sendRemoteGetData(sIMPMessage, this.remoteME, this.remoteMEId, this.streamId, l7, l4, l2, aOValue.getWaitTime());
            }
            if (!bl2) continue;
            this.parent.sendCompleted(this.remoteME, this.remoteMEId, this.streamId, tickRange);
        }
        if (arrayList != null) {
            long[] lArray4 = new long[arrayList.size()];
            for (int i = 0; i < lArray4.length; ++i) {
                lArray4[i] = ((AORequested)arrayList.get((int)i)).tick;
            }
            this.parent.sendRequestAck(this.remoteME, this.remoteMEId, this.streamId, this.parent.dmeVersion, lArray4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAccept(long[] lArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAccept", (Object)lArray);
        }
        ArrayList arrayList = null;
        boolean bl = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.messagesReceived = true;
            if (this.completedTicksInitialized && this.active) {
                arrayList = this.processDecisionInternal(lArray, lArray, 1, false);
                bl = this.tryTransitionToFlushed();
            }
        }
        if (arrayList != null && arrayList.size() != 0) {
            this.parent.sendCompleted(this.remoteME, this.remoteMEId, this.streamId, arrayList);
        }
        if (bl) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAccept");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReject(long[] lArray, long[] lArray2, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processReject", (Object)new Object[]{lArray, lArray2, new Boolean(bl)});
        }
        ArrayList arrayList = null;
        boolean bl2 = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.messagesReceived = true;
            if (this.completedTicksInitialized && this.active) {
                arrayList = this.processDecisionInternal(lArray, lArray2, 2, bl);
                bl2 = this.tryTransitionToFlushed();
            }
        }
        if (arrayList != null && arrayList.size() != 0) {
            this.parent.sendCompleted(this.remoteME, this.remoteMEId, this.streamId, arrayList);
        }
        if (bl2) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processReject");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCompleted(long[] lArray, long[] lArray2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processCompleted", (Object)new Object[]{lArray, lArray2});
        }
        boolean bl = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            this.messagesReceived = true;
            if (this.completedTicksInitialized && this.active) {
                this.processDecisionInternal(lArray, lArray2, 3, false);
                bl = this.tryTransitionToFlushed();
            }
        }
        if (bl) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processCompleted");
        }
    }

    private ArrayList processDecisionInternal(long[] lArray, long[] lArray2, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processDecisionInternal", (Object)new Object[]{lArray, lArray2, new Integer(n), new Boolean(bl)});
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(lArray.length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(lArray.length);
        ArrayList<TickRange> arrayList3 = new ArrayList<TickRange>(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            TickRange tickRange;
            this.stream.setCursor(lArray[i]);
            TickRange tickRange2 = tickRange = this.stream.getNext();
            TickRange tickRange3 = null;
            while (tickRange.startstamp <= lArray2[i]) {
                Object object;
                if (tickRange.type == 0 || tickRange.type == 7) {
                    tickRange3 = this.startOrIncludeInWriteRange(tickRange3, lArray[i], lArray2[i], tickRange);
                } else if (tickRange.type == 1) {
                    object = (AORequested)tickRange.value;
                    if (((AORequested)object).inserting) {
                        if (tickRange3 != null) {
                            arrayList3.add(tickRange3);
                            tickRange3 = null;
                        }
                    } else {
                        tickRange3 = this.startOrIncludeInWriteRange(tickRange3, lArray[i], lArray2[i], tickRange);
                        ((AORequested)object).aock.cancelRequest(tickRange.startstamp);
                    }
                } else if (tickRange.type == 3) {
                    object = (AOValue)tickRange.value;
                    if (((AOValue)object).removing) {
                        if (tickRange3 != null) {
                            arrayList3.add(tickRange3);
                            tickRange3 = null;
                        }
                    } else if (((AOValue)object).getStorageStrategy() == 4 || ((AOValue)object).getStorageStrategy() == 3) {
                        ((AOValue)object).removing = true;
                        arrayList.add(object);
                        if (tickRange3 != null) {
                            arrayList3.add(tickRange3);
                            tickRange3 = null;
                        }
                    } else if (((AOValue)object).getStorageStrategy() == 1) {
                        arrayList2.add(object);
                        tickRange3 = this.startOrIncludeInWriteRange(tickRange3, lArray[i], lArray2[i], tickRange);
                    }
                }
                tickRange2 = tickRange;
                tickRange = this.stream.getNext();
                if (tickRange != tickRange2) continue;
            }
            if (this.firstUnknownTick <= lArray2[i]) {
                this.firstUnknownTick = lArray2[i] + 1L;
            }
            if (tickRange3 == null) continue;
            arrayList3.add(tickRange3);
            tickRange3 = null;
        }
        this.doWriteCompletedRanges(arrayList3);
        if (arrayList.size() > 0) {
            if (n == 1) {
                ConsumeAcceptedTicks consumeAcceptedTicks = new ConsumeAcceptedTicks(arrayList);
                this.doEnqueueWork(consumeAcceptedTicks);
            } else if (n == 2) {
                UnlockRejectedTicks unlockRejectedTicks = new UnlockRejectedTicks(arrayList);
                this.doEnqueueWork(unlockRejectedTicks);
            } else if (n == 3) {
                UnlockRejectedTicks unlockRejectedTicks = new UnlockRejectedTicks(arrayList);
                this.doEnqueueWork(unlockRejectedTicks);
            }
        }
        if (arrayList2.size() > 0) {
            if (n == 1) {
                this.consumeNonPersistentMessages(arrayList2);
            } else if (n == 2) {
                if (bl) {
                    this.consumeNonPersistentMessages(arrayList2);
                } else {
                    this.unlockNonPersistentMessages(arrayList2);
                }
            } else if (n == 3) {
                this.unlockNonPersistentMessages(arrayList2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processDecisionInternal", arrayList3);
        }
        return arrayList3;
    }

    public synchronized void syncRemoveValueTick(long l, ExternalLocalTransaction externalLocalTransaction) throws MessageStoreException, SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"syncRemoveValueTick", (Object)new Object[]{new Long(l), externalLocalTransaction});
        }
        AOValue aOValue = null;
        this.stream.setCursor(l);
        TickRange tickRange = this.stream.getNext();
        if (tickRange.type == 3) {
            aOValue = (AOValue)tickRange.value;
            if (aOValue.removing) {
                aOValue = null;
            } else {
                aOValue.removing = true;
            }
        }
        if (aOValue != null) {
            ExternalLocalTransaction externalLocalTransaction2 = externalLocalTransaction;
            this.dem.removeTimeoutEntry(aOValue);
            SIMPMessage sIMPMessage = (SIMPMessage)((Object)(this.parent.msgItemStream == null ? this.parent.msgReferenceStream.findById(aOValue.getMsgId()) : this.parent.msgItemStream.findById(aOValue.getMsgId())));
            if (aOValue.getStorageStrategy() == 4 || aOValue.getStorageStrategy() == 3) {
                sIMPMessage.remove(externalLocalTransaction2, aOValue.getPLockId());
                aOValue.remove(externalLocalTransaction2, -2L);
            } else {
                sIMPMessage.remove(externalLocalTransaction2, sIMPMessage.getLockID());
            }
            externalLocalTransaction.commit();
            TickRange tickRange2 = new TickRange(7, aOValue.getTick(), aOValue.getTick());
            tickRange2 = this.stream.writeCompleted(tickRange2);
            this.tryTransitionToFlushed();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"syncRemoveValueTick");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processHighestGeneratedTick(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processHighestGeneratedTick", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (l == this.initRequestId && !this.completedTicksInitialized) {
                this.changeUnknownToCompleted(0L, l2);
                this.firstUnknownTick = l2 + 1L;
                if (l2 < this.initHighestValueTick) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2005:1.63"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOStream.processHighestGeneratedTick", (String)"1:2011:1.63", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2017:1.63"});
                } else {
                    this.completedTicksInitialized = true;
                    if (this.initRepeatHandler != null) {
                        this.initRepeatHandler.cancel();
                        this.initRepeatHandler = null;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processHighestGeneratedTick");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAreYouFlushed(long l, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAreYouFlushed", (Object)new Long(l));
        }
        boolean bl = false;
        boolean bl2 = false;
        long l2 = 0L;
        long l3 = 0L;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.active) {
                if (this.isFlushed) {
                    bl = true;
                } else {
                    bl2 = true;
                    if (this.completedTicksInitialized) {
                        l2 = this.stream.getCompletedPrefix();
                        l3 = this.firstUnknownTick - 1L;
                    } else {
                        l2 = 0L;
                        l3 = 0L;
                    }
                }
            }
        }
        if (bl) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        } else if (bl2) {
            this.parent.sendNotFlushed(this.remoteME, this.remoteMEId, this.streamId, l, l2, l3, sIBUuid12);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAreYouFlushed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestFlush() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processRequestFlush");
        }
        boolean bl = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.startedFlush) {
                if (this.isFlushed && this.active) {
                    bl = true;
                }
            } else if (!this.scheduleWriteStartedFlush) {
                this.scheduleWriteStartedFlush = true;
                WriteStartedFlush writeStartedFlush = new WriteStartedFlush();
                this.doEnqueueWork(writeStartedFlush);
            }
        }
        if (bl) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processRequestFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            TickRange tickRange;
            this.closeInternal();
            this.stream.setCursor(0L);
            TickRange tickRange2 = tickRange = this.stream.getNext();
            ArrayList<AOValue> arrayList = new ArrayList<AOValue>();
            do {
                AOValue aOValue;
                if (tickRange.type == 3 && (aOValue = (AOValue)tickRange.value).getStorageStrategy() == 1) {
                    arrayList.add(aOValue);
                }
                tickRange2 = tickRange;
            } while ((tickRange = this.stream.getNext()) != tickRange2);
            this.unlockNonPersistentMessages(arrayList);
            if (this.countAsyncUpdatesOutstanding != 0) {
                long l = 5000L;
                long l2 = 60000L;
                int n = (int)(l2 / l);
                for (int i = 0; this.countAsyncUpdatesOutstanding != 0 && i < n; ++i) {
                    try {
                        Thread.sleep(l);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.countAsyncUpdatesOutstanding != 0) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2184:1.63"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOStream.close", (String)"1:2189:1.63", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOStream", "1:2195:1.63"});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"close");
                    }
                    throw sIErrorException;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public String getID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getID");
        }
        String string = this.streamId.toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getID", (Object)string);
        }
        return string;
    }

    public synchronized long getNumberOfRequestsInState(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfRequestsInState", (Object)new Integer(n));
        }
        long l = 0L;
        this.stream.setCursor(0L);
        this.stream.getNext();
        TickRange tickRange = this.stream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == n) {
                ++l;
            }
            tickRange = this.stream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfRequestsInState", (Object)new Long(l));
        }
        return l;
    }

    public long getDMEVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDMEVersion");
            SibTr.exit((TraceComponent)tc, (String)"getDMEVersion", (Object)new Long(this.dmeVerion));
        }
        return this.dmeVerion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writtenStartedFlush() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writtenStartedFlush");
        }
        boolean bl = false;
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (!this.startedFlush) {
                this.startedFlush = true;
                this.completedTicksInitialized = true;
                if (this.initRepeatHandler != null) {
                    this.initRepeatHandler.cancel();
                    this.initRepeatHandler = null;
                }
                this.firstUnknownTick = Long.MAX_VALUE;
                if (!this.parent.getCardinalityOne() || !this.parent.isMEReachable(this.remoteME)) {
                    Enumeration enumeration = this.consumerKeyTable.elements();
                    while (enumeration.hasMoreElements()) {
                        AOConsumerKey aOConsumerKey = (AOConsumerKey)enumeration.nextElement();
                        aOConsumerKey.close();
                    }
                    this.consumerKeyTable.clear();
                }
                this.changeUnknownToCompleted(0L, Long.MAX_VALUE);
                bl = this.tryTransitionToFlushed();
            }
        }
        if (bl) {
            this.parent.sendFlushed(this.remoteME, this.remoteMEId, this.streamId);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writtenStartedFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResetRequestAckAck() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processResetRequestAckAck");
        }
        AOStream aOStream = this;
        synchronized (aOStream) {
            if (this.resetRequestAckSender != null) {
                this.resetRequestAckSender.stop();
                this.resetRequestAckSender = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processResetRequestAckAck");
        }
    }

    private void changeUnknownToCompleted(long l, long l2) {
        TickRange tickRange;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"changeUnknownToCompleted", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        this.stream.setCursor(l);
        TickRange tickRange2 = tickRange = this.stream.getNext();
        TickRange tickRange3 = null;
        ArrayList<TickRange> arrayList = new ArrayList<TickRange>(5);
        while (tickRange.startstamp <= l2) {
            if (tickRange.type == 0) {
                tickRange3 = this.startOrIncludeInWriteRange(tickRange3, l, l2, tickRange);
            } else if (tickRange3 != null) {
                arrayList.add(tickRange3);
                tickRange3 = null;
            }
            tickRange2 = tickRange;
            tickRange = this.stream.getNext();
            if (tickRange != tickRange2) continue;
        }
        if (tickRange3 != null) {
            arrayList.add(tickRange3);
            tickRange3 = null;
        }
        this.doWriteCompletedRanges(arrayList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"changeUnknownToCompleted");
        }
    }

    private final void doWriteCompletedRanges(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doWriteCompletedRanges", (Object)new Object[]{list});
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, this.stream.writeCompletedRange((TickRange)list.get(i)));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doWriteCompletedRanges");
        }
    }

    private final void doEnqueueWork(AsyncUpdate asyncUpdate) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doEnqueueWork", (Object)asyncUpdate);
        }
        try {
            this.msUpdateThread.enqueueWork(asyncUpdate);
            ++this.countAsyncUpdatesOutstanding;
        }
        catch (ClosedException closedException) {
            FFDCFilter.processException((Throwable)closedException, (String)"com.ibm.ws.sib.processor.impl.AOStream.doEnqueueWork", (String)"1:2484:1.63", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)closedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doEnqueueWork");
        }
    }

    private final TickRange startOrIncludeInWriteRange(TickRange tickRange, long l, long l2, TickRange tickRange2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startOrIncludeInWriteRange");
        }
        if (tickRange == null) {
            tickRange = new TickRange(7, 0L, 0L);
            tickRange.startstamp = AOStream.max(tickRange2.startstamp, l);
            tickRange.endstamp = AOStream.min(tickRange2.endstamp, l2);
        } else {
            tickRange.endstamp = AOStream.min(tickRange2.endstamp, l2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startOrIncludeInWriteRange", (Object)tickRange);
        }
        return tickRange;
    }

    private final void consumeNonPersistentMessages(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consumeNonPersistentMessages", (Object)arrayList);
        }
        try {
            ExternalLocalTransaction externalLocalTransaction;
            ExternalLocalTransaction externalLocalTransaction2 = externalLocalTransaction = this.parent.getTransaction();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                AOValue aOValue = (AOValue)arrayList.get(i);
                this.dem.removeTimeoutEntry(aOValue);
                SIMPMessage sIMPMessage = (SIMPMessage)((Object)(this.parent.msgItemStream == null ? this.parent.msgReferenceStream.findById(aOValue.getMsgId()) : this.parent.msgItemStream.findById(aOValue.getMsgId())));
                sIMPMessage.remove(externalLocalTransaction2, sIMPMessage.getLockID());
            }
            externalLocalTransaction.commit();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AOStream.consumeNonPersistentMessages", (String)"1:2563:1.63", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumeNonPersistentMessages");
        }
    }

    private final void unlockNonPersistentMessages(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockNonPersistentMessages", (Object)arrayList);
        }
        try {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                AOValue aOValue = (AOValue)arrayList.get(i);
                this.dem.removeTimeoutEntry(aOValue);
                SIMPMessage sIMPMessage = (SIMPMessage)((Object)(this.parent.msgItemStream == null ? this.parent.msgReferenceStream.findById(aOValue.getMsgId()) : this.parent.msgItemStream.findById(aOValue.getMsgId())));
                sIMPMessage.unlock(sIMPMessage.getLockID());
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AOStream.unlockNonPersistentMessages", (String)"1:2601:1.63", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockNonPersistentMessages");
        }
    }

    private final AOConsumerKey findOrCreateAOConsumerKey(String[] stringArray, int[] nArray, String[] stringArray2) throws ClosedException {
        String string;
        AOConsumerKey aOConsumerKey;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findOrCreateAOConsumerKey", (Object)new Object[]{stringArray, nArray, stringArray2});
        }
        if ((aOConsumerKey = (AOConsumerKey)this.consumerKeyTable.get(string = this.parent.convertSelectionCriteriasToString(stringArray, nArray, stringArray2))) == null) {
            try {
                aOConsumerKey = new AOConsumerKey();
                ConsumerDispatcher consumerDispatcher = this.parent.getConsumerDispatcher();
                SelectionCriteria[] selectionCriteriaArray = new SelectionCriteria[stringArray.length];
                ConsumerKey[] consumerKeyArray = new ConsumerKey[stringArray.length];
                OrderingContextImpl orderingContextImpl = null;
                SIBUuid12 sIBUuid12 = new SIBUuid12();
                if (stringArray.length > 1) {
                    orderingContextImpl = new OrderingContextImpl();
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    SelectorDomain selectorDomain = SelectorDomain.getSelectorDomain((int)nArray[i]);
                    selectionCriteriaArray[i] = this.parent.createSelectionCriteria(stringArray[i], stringArray2[i], selectorDomain);
                    consumerKeyArray[i] = consumerDispatcher.attachConsumerPoint(aOConsumerKey, selectionCriteriaArray[i], sIBUuid12, false, false);
                    if (orderingContextImpl != null) {
                        consumerDispatcher.joinKeyGroup(consumerKeyArray[i], orderingContextImpl);
                    }
                    consumerKeyArray[i].start();
                }
                if (this.parent.getCardinalityOne()) {
                    aOConsumerKey.init(this, string, consumerKeyArray, Long.MAX_VALUE, this.am, selectionCriteriaArray);
                } else {
                    aOConsumerKey.init(this, string, consumerKeyArray, SIMPConstants.CK_IDLE_TIMEOUT, this.am, selectionCriteriaArray);
                }
                this.consumerKeyTable.put(string, aOConsumerKey);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.AOStream.findOrCreateAOConsumerKey", (String)"1:2689:1.63", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)exception);
                aOConsumerKey = null;
                ClosedException closedException = new ClosedException(exception.getMessage());
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"findOrCreateAOConsumerKey", (Object)closedException);
                }
                throw closedException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findOrCreateAOConsumerKey", (Object)aOConsumerKey);
        }
        return aOConsumerKey;
    }

    private final boolean tryTransitionToFlushed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryTransitionToFlushed");
        }
        boolean bl = false;
        if (this.startedFlush && !this.isFlushed && this.stream.getCompletedPrefix() == Long.MAX_VALUE) {
            this.isFlushed = true;
            bl = this.active;
            this.closeInternal();
            this.parent.streamIsFlushed(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tryTransitionToFlushed", (Object)new Boolean(bl));
        }
        return bl;
    }

    private final void closeInternal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeInternal");
        }
        this.stop();
        this.dem.close();
        this.closed = true;
        Enumeration enumeration = this.consumerKeyTable.elements();
        while (enumeration.hasMoreElements()) {
            AOConsumerKey aOConsumerKey = (AOConsumerKey)enumeration.nextElement();
            aOConsumerKey.close();
        }
        this.consumerKeyTable.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeInternal");
        }
    }

    private static final long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    private static final long min(long l, long l2) {
        return l > l2 ? l2 : l;
    }

    public long getCompletedPrefix() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)new Long(this.stream.getCompletedPrefix()));
        }
        return this.stream.getCompletedPrefix();
    }

    protected int getPriority() {
        return 0;
    }

    protected Reliability getReliability() {
        return null;
    }

    public SIBUuid8 getRemoteMEUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMEUuid", (Object)this.remoteMEId);
        }
        return this.remoteMEId;
    }

    public StateStream getStateStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStateStream");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStateStream", (Object)this.stream);
        }
        return this.stream;
    }

    public AOStreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.streamState);
        }
        return this.streamState;
    }

    public synchronized long getTotalRequestsReceived() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalRequestsReceived");
            SibTr.exit((TraceComponent)tc, (String)"getTotalRequestsReceived");
        }
        return this.totalReceivedRequests;
    }

    public void writeSilenceForced(long l) {
    }

    public static class AOStreamState
    implements SIMPDeliveryTransmitControllable.StreamState {
        public static final AOStreamState ACTIVE = new AOStreamState("Active", 1);
        private String name;
        private int id;

        private AOStreamState(String string, int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AOStreamState", (Object)new Object[]{string, new Integer(n)});
            }
            this.name = string;
            this.id = n;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AOStreamState", (Object)this);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getValue");
                SibTr.exit((TraceComponent)tc, (String)"getValue", (Object)new Integer(this.id));
            }
            return this.id;
        }
    }

    class WriteStartedFlush
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        Item startedFlushItem;

        WriteStartedFlush() {
            super(4, AOStream.this.msUpdateThread, AOStream.this.parent.getDestName());
            this.startedFlushItem = null;
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            this.startedFlushItem = AOStream.this.parent.writeStartedFlush(transaction, AOStream.this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            if (!this.rolledbackRetry(throwable)) {
                WriteStartedFlush writeStartedFlush = this;
                synchronized (writeStartedFlush) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            WriteStartedFlush writeStartedFlush = this;
            synchronized (writeStartedFlush) {
                AOStream.this.countAsyncUpdatesOutstanding--;
            }
            AOStream.this.parent.writtenStartedFlush(AOStream.this, this.startedFlushItem);
            AOStream.this.writtenStartedFlush();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class ConsumeAcceptedTicks
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        ArrayList storedTicks;

        public ConsumeAcceptedTicks(ArrayList arrayList) {
            super(4, AOStream.this.msUpdateThread, AOStream.this.parent.getDestName());
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ConsumeAcceptedTicks", (Object)arrayList);
            }
            this.storedTicks = arrayList;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ConsumeAcceptedTicks", (Object)this);
            }
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            for (int i = 0; i < this.storedTicks.size(); ++i) {
                AOStream.this.parent.consumeAcceptedTick(transaction, AOStream.this, (AOValue)this.storedTicks.get(i));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            AOStream.this.storedTicksRemoved(this.storedTicks);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            if (!this.rolledbackRetry(throwable)) {
                ConsumeAcceptedTicks consumeAcceptedTicks = this;
                synchronized (consumeAcceptedTicks) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    class UnlockRejectedTicks
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        ArrayList storedTicks;

        public UnlockRejectedTicks(ArrayList arrayList) {
            super(4, AOStream.this.msUpdateThread, AOStream.this.parent.getDestName());
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"UnlockRejectedTicks", (Object)arrayList);
            }
            this.storedTicks = arrayList;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"UnlockRejectedTicks", (Object)this);
            }
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute");
            }
            for (int i = 0; i < this.storedTicks.size(); ++i) {
                AOStream.this.parent.unlockRejectedTick(transaction, (AOValue)this.storedTicks.get(i));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            AOStream.this.storedTicksRemoved(this.storedTicks);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            if (!this.rolledbackRetry(throwable)) {
                UnlockRejectedTicks unlockRejectedTicks = this;
                synchronized (unlockRejectedTicks) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }
    }

    class PersistLockAndTick
    extends AnycastOutputHandler.AsyncUpdateWithRetry {
        long tick;
        SIMPMessage msg;
        int storagePolicy;
        long waitTime;
        long prevTick;
        AOValue storedTick;

        public PersistLockAndTick(long l, SIMPMessage sIMPMessage, int n, long l2, long l3) {
            super(4, AOStream.this.parent.getPersistLockThread(), AOStream.this.parent.getDestName());
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"PersistLockAndTick", (Object)new Object[]{new Long(l), sIMPMessage, new Integer(n), new Long(l2), new Long(l3)});
            }
            this.tick = l;
            this.msg = sIMPMessage;
            this.storagePolicy = n;
            this.waitTime = l2;
            this.prevTick = l3;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"PersistLockAndTick", (Object)this);
            }
        }

        public void execute(Transaction transaction) throws Throwable {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"execute", (Object)transaction);
            }
            this.storedTick = AOStream.this.parent.persistLockAndTick(transaction, AOStream.this, this.tick, this.msg, this.storagePolicy, this.waitTime, this.prevTick);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"execute");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rolledback(Throwable throwable) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"rolledback", (Object)throwable);
            }
            if (!this.rolledbackRetry(throwable)) {
                PersistLockAndTick persistLockAndTick = this;
                synchronized (persistLockAndTick) {
                    AOStream.this.countAsyncUpdatesOutstanding--;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rolledback");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void committed() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"committed");
            }
            TickRange tickRange = null;
            boolean bl = false;
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                AOStream.this.countAsyncUpdatesOutstanding--;
                tickRange = TickRange.newValueTick(this.tick, this.storedTick, 0L);
                AOStream.this.stream.writeCombinedRange(tickRange);
                tickRange = AOStream.this.stream.findCompletedRange(tickRange);
                AOStream.this.dem.addTimeoutEntry(this.storedTick);
                if (AOStream.this.active) {
                    bl = true;
                }
            }
            if (bl) {
                long l = this.storedTick.getPrevTick();
                AOStream.this.parent.sendRemoteGetData(this.msg, AOStream.this.remoteME, AOStream.this.remoteMEId, AOStream.this.streamId, l, tickRange.startstamp, this.tick, this.waitTime);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"committed");
            }
        }
    }

    class ResetRequestAckSender
    implements AlarmListener {
        final long initTime = System.currentTimeMillis();
        boolean done = false;
        Alarm rraAlarm;

        ResetRequestAckSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean start() {
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (!this.done) {
                    this.alarm(null);
                }
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() {
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (this.rraAlarm != null) {
                    this.rraAlarm.cancel();
                    this.rraAlarm = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            boolean bl = false;
            long l = System.currentTimeMillis();
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (l - this.initTime > SIMPConstants.SLOWED_GET_REQUEST_INTERVAL) {
                    this.rraAlarm = null;
                    this.done = true;
                } else {
                    bl = AOStream.this.active;
                    this.rraAlarm = AOStream.this.am.create(SIMPConstants.RESET_REPETITION_INTERVAL, this);
                }
            }
            if (bl) {
                AOStream.this.parent.sendResetRequestAck(AOStream.this.remoteME, AOStream.this.remoteMEId, AOStream.this.streamId, ((AOStream)AOStream.this).parent.dmeVersion);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    class InactivityTimerHandler
    implements AlarmListener {
        InactivityTimerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            AOStream aOStream = AOStream.this;
            synchronized (aOStream) {
                if (AOStream.this.active) {
                    if (!(AOStream.this.isFlushed || AOStream.this.messagesReceived || AOStream.this.parent.isMEReachable(AOStream.this.remoteME))) {
                        if (!AOStream.this.startedFlush) {
                            AOStream.this.processRequestFlush();
                        }
                        Enumeration enumeration = AOStream.this.consumerKeyTable.elements();
                        while (enumeration.hasMoreElements()) {
                            AOConsumerKey aOConsumerKey = (AOConsumerKey)enumeration.nextElement();
                            aOConsumerKey.close();
                        }
                        AOStream.this.consumerKeyTable.clear();
                        if (!AOStream.this.startedFlush) {
                            AOStream.this.inactivityTimer = AOStream.this.am.create(SIMPConstants.REMOTE_CONSUMER_CARDINALITY_INACTIVITY_INTERVAL, AOStream.this.inactivityHandler);
                        }
                    } else if (!AOStream.this.isFlushed) {
                        AOStream.this.inactivityTimer = AOStream.this.am.create(SIMPConstants.REMOTE_CONSUMER_CARDINALITY_INACTIVITY_INTERVAL, AOStream.this.inactivityHandler);
                    }
                    AOStream.this.messagesReceived = false;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }
}

