/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.AORequestedTick;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.exceptions.ClosedException;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.mediation.StoppedEventListener;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import java.util.ArrayList;
import java.util.HashMap;

public final class AOConsumerKey
implements AlarmListener,
ConsumerPoint {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)AOConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MPAlarmManager am;
    private AOStream parent;
    private ConsumerDispatcher dispatcher;
    private ConsumerKey[] cks;
    private ConsumerKey ck;
    private String selectionCriteriasAsString;
    private SelectionCriteria[] selectionCriterias;
    private boolean isready;
    private boolean temporarilyStopped;
    private LockingCursor lcursor;
    private boolean closed;
    private long idleTimeout;
    private Alarm idleHandler;
    private LinkedList listOfRequests;
    private HashMap tableOfRequests;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(AOStream aOStream, String string, ConsumerKey[] consumerKeyArray, long l, MPAlarmManager mPAlarmManager, SelectionCriteria[] selectionCriteriaArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{aOStream, string, consumerKeyArray, new Long(l), mPAlarmManager, selectionCriteriaArray});
        }
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            this.parent = aOStream;
            this.selectionCriteriasAsString = string;
            this.cks = consumerKeyArray;
            this.ck = consumerKeyArray[0];
            this.selectionCriterias = selectionCriteriaArray;
            this.isready = false;
            this.dispatcher = this.cks[0].getConsumerDispatcher();
            this.temporarilyStopped = !this.dispatcher.getDestination().isReceiveAllowed();
            this.lcursor = this.cks[0].getGetCursor();
            this.closed = false;
            this.listOfRequests = new LinkedList();
            this.tableOfRequests = new HashMap();
            this.idleTimeout = l;
            this.am = mPAlarmManager;
            if (l > 0L) {
                this.idleHandler = mPAlarmManager.create(l, this);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    public final void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        ArrayList arrayList = new ArrayList(this.tableOfRequests.size());
        this.closeInternal(arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AORequestedTick aORequestedTick = (AORequestedTick)arrayList.get(i);
            this.parent.expiredRequest(aORequestedTick.tick);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeInternal(ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeInternal");
        }
        ConsumerKey[] consumerKeyArray = null;
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            this.closed = true;
            if (this.cks != null) {
                consumerKeyArray = this.cks;
                this.cks = null;
            }
            if (this.lcursor != null) {
                this.lcursor.finished();
                this.lcursor = null;
            }
            if (this.idleHandler != null) {
                this.idleHandler.cancel();
                this.idleHandler = null;
            }
            AORequestedTick aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
            while (aORequestedTick != null) {
                this.listOfRequests.remove(aORequestedTick);
                boolean bl = aORequestedTick.expire(true);
                if (!bl) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:269:1.37"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.closeInternal", (String)"1:275:1.37", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:282:1.37"});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"closeInternal", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
                arrayList.add(aORequestedTick);
                aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
            }
            this.tableOfRequests.clear();
        }
        try {
            if (consumerKeyArray != null) {
                for (int i = 0; i < consumerKeyArray.length; ++i) {
                    consumerKeyArray[i].detach();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeInternal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expiryAlarm(AORequestedTick aORequestedTick) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"expiryAlarm", (Object)aORequestedTick);
        }
        boolean bl = false;
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            if (this.closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"expiryAlarm");
                }
                return;
            }
            bl = this.cancelRequestInternal(aORequestedTick, true);
        }
        if (bl) {
            this.parent.expiredRequest(aORequestedTick.tick);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"expiryAlarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SIMPMessage newRequest(long l, long l2) throws ClosedException, MessageStoreException, SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newRequest", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        Object object = null;
        SIMPMessage sIMPMessage = null;
        AORequestedTick aORequestedTick = null;
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            if (this.closed) {
                ClosedException closedException = new ClosedException();
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)closedException);
                }
                throw closedException;
            }
            if (this.idleHandler != null) {
                this.idleHandler.cancel();
                this.idleHandler = null;
            }
            Long l3 = new Long(l);
            aORequestedTick = new AORequestedTick(this, l, l3, l2, this.am);
            this.listOfRequests.put(aORequestedTick);
            this.tableOfRequests.put(l3, aORequestedTick);
            if (!this.temporarilyStopped) {
                try {
                    if (!this.isready) {
                        this.ck.ready(Reliability.NONE);
                        this.isready = true;
                        sIMPMessage = (SIMPMessage)((Object)this.lcursor.next());
                        if (sIMPMessage != null) {
                            this.ck.notReady();
                            this.isready = false;
                            this.listOfRequests.remove(aORequestedTick);
                            this.tableOfRequests.remove(l3);
                            boolean bl = aORequestedTick.satisfy(sIMPMessage);
                            if (!bl) {
                                sIMPMessage.unlock(sIMPMessage.getLockID());
                                sIMPMessage = null;
                            }
                        }
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    object = messageStoreException;
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    object = sINotPossibleInCurrentConfigurationException;
                }
            }
            if (sIMPMessage != null && this.idleTimeout > 0L) {
                this.idleHandler = this.am.create(this.idleTimeout, this);
            }
        }
        if (object != null) {
            this.close();
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)object);
            }
            if (object instanceof SINotPossibleInCurrentConfigurationException) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"newRequest");
                }
                throw (SINotPossibleInCurrentConfigurationException)((Object)object);
            }
            if (object instanceof MessageStoreException) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"newRequest");
                }
                throw object;
            }
        }
        if (l2 == 0L && sIMPMessage == null && aORequestedTick != null) {
            this.expiryAlarm(aORequestedTick);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newRequest", (Object)sIMPMessage);
        }
        return sIMPMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelRequest(long l) {
        Long l2 = new Long(l);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelRequest", (Object)l2);
        }
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            if (this.closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"cancelRequest");
                }
                return;
            }
            AORequestedTick aORequestedTick = (AORequestedTick)this.tableOfRequests.get(l2);
            if (aORequestedTick != null) {
                this.cancelRequestInternal(aORequestedTick, false);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelRequest");
        }
    }

    private boolean cancelRequestInternal(AORequestedTick aORequestedTick, boolean bl) {
        boolean bl2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cancelRequestInternal", (Object)new Object[]{aORequestedTick, new Boolean(bl)});
        }
        if (bl2 = aORequestedTick.expire(!bl)) {
            this.listOfRequests.remove(aORequestedTick);
            this.tableOfRequests.remove(aORequestedTick.objTick);
            if (this.listOfRequests.isEmpty()) {
                if (this.idleTimeout > 0L) {
                    this.idleHandler = this.am.create(this.idleTimeout, this);
                }
                if (this.isready) {
                    this.isready = false;
                    this.ck.notReady();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cancelRequestInternal", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(SIMPMessage sIMPMessage, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{sIMPMessage, new Boolean(bl)});
        }
        boolean bl2 = false;
        ArrayList<AORequestedTick> arrayList = new ArrayList<AORequestedTick>(5);
        Object object = null;
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            if (this.closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)Boolean.FALSE);
                }
                return false;
            }
            if (!bl) {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:597:1.37"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.put", (String)"1:602:1.37", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:608:1.37"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(false));
                }
                return false;
            }
            if (!this.isready) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(false));
                }
                return false;
            }
            this.isready = false;
            AORequestedTick aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
            if (aORequestedTick != null) {
                AORequestedTick aORequestedTick2;
                boolean bl3 = sIMPMessage.lockItemIfAvailable(this.lcursor.getLockID());
                if (!bl3) {
                    sIMPMessage = null;
                }
                if (sIMPMessage != null) {
                    aORequestedTick2 = this.satisfyRequest(aORequestedTick, sIMPMessage);
                    if (aORequestedTick2 != null) {
                        arrayList.add(aORequestedTick2);
                    }
                    aORequestedTick = null;
                    sIMPMessage = null;
                    bl2 = true;
                }
                if (aORequestedTick == null) {
                    aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
                }
                try {
                    if (aORequestedTick != null) {
                        this.ck.ready(Reliability.NONE);
                        this.isready = true;
                        while (aORequestedTick != null && (sIMPMessage = (SIMPMessage)((Object)this.lcursor.next())) != null) {
                            aORequestedTick2 = this.satisfyRequest(aORequestedTick, sIMPMessage);
                            if (aORequestedTick2 != null) {
                                arrayList.add(aORequestedTick2);
                            }
                            aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
                        }
                    }
                    if (aORequestedTick == null) {
                        this.ck.notReady();
                        this.isready = false;
                        if (this.idleHandler == null && this.idleTimeout > 0L) {
                            this.idleHandler = this.am.create(this.idleTimeout, this);
                        }
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    object = messageStoreException;
                }
                catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                    object = sINotPossibleInCurrentConfigurationException;
                }
            }
        }
        if (object != null) {
            FFDCFilter.processException(object, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.put", (String)"1:708:1.37", (Object)this);
            SibTr.exception((TraceComponent)tc, object);
            this.close();
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AORequestedTick aORequestedTick = (AORequestedTick)arrayList.get(i);
            long l = aORequestedTick.tick;
            SIMPMessage sIMPMessage2 = aORequestedTick.getMessage();
            this.parent.satisfiedRequest(l, sIMPMessage2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    public void notifyException(SIException sIException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyException", (Object)((Object)sIException));
        }
        this.close();
        this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
        FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.notifyException", (String)"1:747:1.37", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReceiveAllowed(boolean bl) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyReceiveAllowed", (Object)new Object[]{new Boolean(bl)});
        }
        Object object2 = null;
        ArrayList<AORequestedTick> arrayList = new ArrayList<AORequestedTick>(5);
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            block16: {
                if (!this.closed && bl) {
                    this.temporarilyStopped = false;
                    try {
                        AORequestedTick aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
                        if (aORequestedTick != null) {
                            this.ck.ready(Reliability.NONE);
                            this.isready = true;
                            while (aORequestedTick != null && (object = (SIMPMessage)((Object)this.lcursor.next())) != null) {
                                AORequestedTick aORequestedTick2 = this.satisfyRequest(aORequestedTick, (SIMPMessage)object);
                                if (aORequestedTick2 != null) {
                                    arrayList.add(aORequestedTick2);
                                }
                                aORequestedTick = (AORequestedTick)this.listOfRequests.getFirst();
                            }
                        }
                        if (aORequestedTick != null) break block16;
                        this.ck.notReady();
                        this.isready = false;
                        if (this.idleHandler == null && this.idleTimeout > 0L) {
                            this.idleHandler = this.am.create(this.idleTimeout, this);
                        }
                    }
                    catch (MessageStoreException messageStoreException) {
                        object2 = messageStoreException;
                    }
                    catch (SINotPossibleInCurrentConfigurationException sINotPossibleInCurrentConfigurationException) {
                        object2 = sINotPossibleInCurrentConfigurationException;
                    }
                } else {
                    this.temporarilyStopped = true;
                    this.isready = false;
                    this.ck.notReady();
                }
            }
        }
        if (object2 != null) {
            FFDCFilter.processException((Throwable)object2, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.notifyReceiveAllowed", (String)"1:835:1.37", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)object2);
            this.close();
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            object = (AORequestedTick)arrayList.get(i);
            long l = ((AORequestedTick)object).tick;
            SIMPMessage sIMPMessage = ((AORequestedTick)object).getMessage();
            this.parent.satisfiedRequest(l, sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyReceiveAllowed");
        }
    }

    public SelectionCriteria[] getSelectionCriterias() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelectionCriterias");
            SibTr.exit((TraceComponent)tc, (String)"getSelectionCriterias", (Object)this.selectionCriterias);
        }
        return this.selectionCriterias;
    }

    private AORequestedTick satisfyRequest(AORequestedTick aORequestedTick, SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"satisfyRequest", (Object)new Object[]{aORequestedTick, sIMPMessage});
        }
        if (!aORequestedTick.satisfy(sIMPMessage)) {
            aORequestedTick = null;
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:892:1.37"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.satisfyRequest", (String)"1:898:1.37", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:904:1.37"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"satisfyRequest", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        this.listOfRequests.remove(aORequestedTick);
        this.tableOfRequests.remove(aORequestedTick.objTick);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"satisfyRequest");
        }
        return aORequestedTick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        boolean bl = false;
        AOConsumerKey aOConsumerKey = this;
        synchronized (aOConsumerKey) {
            if (this.idleHandler != null) {
                if (!this.listOfRequests.isEmpty()) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:944:1.37"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.AOConsumerKey.alarm", (String)"1:949:1.37", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOConsumerKey", "1:955:1.37"});
                } else {
                    bl = true;
                }
            }
        }
        if (bl) {
            this.close();
            this.parent.removeConsumerKey(this.selectionCriteriasAsString, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public boolean destinationMatches(DestinationHandler destinationHandler, ConsumerDispatcher consumerDispatcher) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destinationMatches", (Object)new Object[]{destinationHandler, consumerDispatcher});
        }
        boolean bl2 = bl = consumerDispatcher.getDestination() == destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationMatches", (Object)new Boolean(bl));
        }
        return bl;
    }

    public DestinationHandler getNamedDestination(ConsumerDispatcher consumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNamedDestination", (Object)consumerDispatcher);
            SibTr.exit((TraceComponent)tc, (String)"getNamedDestination", (Object)consumerDispatcher.getDestination());
        }
        return consumerDispatcher.getDestination();
    }

    public void checkForMessages() {
    }

    public void resumeConsumer() {
    }

    public void suspendConsumer() {
    }

    public boolean isConsumerAMediation() {
        return false;
    }

    public void registerMediationStoppedEventListener(StoppedEventListener stoppedEventListener) {
    }

    public void unregisterMediationStoppedEventListener() {
    }
}

