/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.impl.AOBrowserSessionKey;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class AOBrowserSession
implements AlarmListener {
    private MPAlarmManager am;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)AOBrowserSession.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final AnycastOutputHandler parent;
    private NonLockingCursor browseCursor;
    private final AOBrowserSessionKey key;
    private final MessagingEngine remoteME;
    private long expectedSequenceNumber;
    private Alarm expiryAlarmHandle;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AOBrowserSession(AnycastOutputHandler anycastOutputHandler, NonLockingCursor nonLockingCursor, SIBUuid8 sIBUuid8, long l, MPAlarmManager mPAlarmManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AOBrowserSession", (Object)new Object[]{anycastOutputHandler, nonLockingCursor, sIBUuid8, new Long(l), mPAlarmManager});
        }
        AOBrowserSession aOBrowserSession = this;
        synchronized (aOBrowserSession) {
            this.parent = anycastOutputHandler;
            this.browseCursor = nonLockingCursor;
            this.key = new AOBrowserSessionKey(sIBUuid8, l);
            this.remoteME = new MessagingEngine(sIBUuid8);
            this.am = mPAlarmManager;
            this.expectedSequenceNumber = 0L;
            this.expiryAlarmHandle = mPAlarmManager.create(SIMPConstants.BROWSE_EXPIRY_TIMEOUT, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AOBrowserSession", (Object)this);
        }
    }

    public AOBrowserSessionKey getKey() {
        return this.key;
    }

    public synchronized boolean next(long l) {
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next", (Object)new Long(l));
            }
            this.expiryAlarmHandle.cancel();
            this.expiryAlarmHandle = this.am.create(SIMPConstants.BROWSE_EXPIRY_TIMEOUT, this);
            if (this.closed) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"next", (Object)new Boolean(this.closed));
                }
                return true;
            }
            if (l == this.expectedSequenceNumber) {
                try {
                    SIMPMessage sIMPMessage = (SIMPMessage)((Object)this.browseCursor.next());
                    if (sIMPMessage != null) {
                        this.parent.sendBrowseData(sIMPMessage, this.remoteME, this.key.getRemoteMEUuid(), this.key.getBrowseId(), this.expectedSequenceNumber);
                        ++this.expectedSequenceNumber;
                        break block9;
                    }
                    this.parent.sendBrowseEnd(this.remoteME, this.key.getRemoteMEUuid(), this.key.getBrowseId(), 0);
                    this.close();
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.AOBrowserSession.next", (String)"1:171:1.19", (Object)this);
                    SIResourceException sIResourceException = new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.AOBrowserSession", "1:179:1.19", messageStoreException}, null), (Throwable)((Object)messageStoreException));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.AOBrowserSession", "1:188:1.19", messageStoreException});
                    this.parent.sendBrowseEnd(this.remoteME, this.key.getRemoteMEUuid(), this.key.getBrowseId(), 1);
                    this.close();
                }
            } else {
                this.parent.sendBrowseEnd(this.remoteME, this.key.getRemoteMEUuid(), this.key.getBrowseId(), 2);
                this.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)new Boolean(this.closed));
        }
        return this.closed;
    }

    public final synchronized void close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        this.closed = true;
        if (this.browseCursor != null) {
            this.browseCursor.finished();
            this.browseCursor = null;
        }
        if (this.expiryAlarmHandle != null) {
            this.expiryAlarmHandle.cancel();
            this.expiryAlarmHandle = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public final synchronized void keepAlive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"keepAlive");
        }
        if (!this.closed) {
            if (this.expiryAlarmHandle != null) {
                this.expiryAlarmHandle.cancel();
            }
            this.expiryAlarmHandle = this.am.create(SIMPConstants.BROWSE_EXPIRY_TIMEOUT, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"keepAlive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        AOBrowserSession aOBrowserSession = this;
        synchronized (aOBrowserSession) {
            if (this.expiryAlarmHandle != null) {
                this.expiryAlarmHandle = null;
                this.close();
                this.parent.removeBrowserSession(this.key);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    public long getExpectedSequenceNumber() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExpectedSequenceNumber");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExpectedSequenceNumber", (Object)new Long(this.expectedSequenceNumber));
        }
        return this.expectedSequenceNumber;
    }
}

