/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidMessageException;
import com.ibm.ws.sib.processor.impl.interfaces.BatchListener;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SourceStreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SourceStream
extends ControllableStream
implements BatchListener {
    private static final TraceComponent tc = SibTr.register((Class)SourceStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private StreamSet streamSet;
    private SourceStreamState sourceStreamState = SourceStreamState.ACTIVE;
    private int priority;
    private Reliability reliability;
    private DownstreamControl downControl;
    private StateStream oststream;
    private long oack = 0L;
    private boolean ackExpAlarmStarted = false;
    private final AckExpExpiryHandler ackExpExpiryHandler;
    private MPAlarmManager am;
    private long lastMsgAdded = 0L;
    private long lastMsgSent = 0L;
    private long timerStartSendTick = 0L;
    private long ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
    private SIBUuid12 stream;
    private boolean containsGuesses = false;
    private long definedSendWindow;
    private long sendWindow = this.definedSendWindow = 1000L;
    private long firstMsgOutsideWindow = Long.MAX_VALUE;
    private long totalMessages = 0L;
    private long totalMessagesSent = 0L;
    private String remoteEngineUUID;
    List batchList = null;
    List batchSendList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceStream(int n, Reliability reliability, DownstreamControl downstreamControl, List list, StreamSet streamSet, MPAlarmManager mPAlarmManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SourceStream", (Object)new Object[]{new Integer(n), reliability, downstreamControl, list, streamSet, mPAlarmManager});
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.remoteEngineUUID = streamSet.getRemoteEngineUUID();
            this.oststream = new StateStream();
            this.oststream.init();
            this.downControl = downstreamControl;
            this.priority = n;
            this.reliability = reliability;
            this.streamSet = streamSet;
            this.stream = streamSet.getStreamID();
            this.am = mPAlarmManager;
            this.ackExpExpiryHandler = new AckExpExpiryHandler(this);
            this.batchList = new ArrayList();
            this.batchSendList = new ArrayList();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SourceStream", (Object)this);
        }
    }

    public int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    public Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    public long getCompletedPrefix() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCompletedPrefix");
        }
        long l = this.oststream.getCompletedPrefix();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCompletedPrefix", (Object)new Long(l));
        }
        return l;
    }

    public long getAckPrefix() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAckPrefix");
            SibTr.exit((TraceComponent)tc, (String)"getAckPrefix", (Object)new Long(this.oack));
        }
        return this.oack;
    }

    public synchronized long getLastMsgAdded() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastMsgAdded");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgAdded", (Object)new Long(this.lastMsgAdded));
        }
        return this.lastMsgAdded;
    }

    public synchronized long getLastMsgSent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastMsgSent");
            SibTr.exit((TraceComponent)tc, (String)"getLastMsgSent", (Object)new Long(this.lastMsgSent));
        }
        return this.lastMsgSent;
    }

    public long getTotalMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalMessages");
            SibTr.exit((TraceComponent)tc, (String)"getTotalMessages", (Object)new Long(this.totalMessages));
        }
        return this.totalMessages;
    }

    public synchronized long getTotalMessagesSent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalMessagesSent");
            SibTr.exit((TraceComponent)tc, (String)"getTotalMessagesSent", (Object)new Long(this.totalMessagesSent));
        }
        return this.totalMessagesSent;
    }

    public long getFirstMsgOutsideWindow() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirstMsgOutsideWindow");
            SibTr.exit((TraceComponent)tc, (String)"getFirstMsgOutsideWindow", (Object)new Long(this.firstMsgOutsideWindow));
        }
        return this.firstMsgOutsideWindow;
    }

    public long getSendWindow() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSendWindow");
            SibTr.exit((TraceComponent)tc, (String)"getSendWindow", (Object)new Long(this.sendWindow));
        }
        return this.sendWindow;
    }

    public boolean containsGuesses() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsGuesses");
            SibTr.exit((TraceComponent)tc, (String)"containsGuesses", (Object)new Boolean(this.containsGuesses));
        }
        return this.containsGuesses;
    }

    public StateStream getStateStream() {
        return this.oststream;
    }

    public SourceStreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.sourceStreamState);
        }
        return this.sourceStreamState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUncommitted(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeUncommitted", (Object)new Object[]{sIMPMessage});
        }
        TickRange tickRange = null;
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        long l2 = jsMessage.getGuaranteedValueStartTick();
        long l3 = jsMessage.getGuaranteedValueEndTick();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeUncommitted at: " + l + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            if (sIMPMessage.getStreamIsGuess()) {
                this.newGuessInStream(l);
            }
            this.msgAdded(l);
            tickRange = TickRange.newUncommittedTick(l);
            tickRange.startstamp = l2;
            tickRange.endstamp = l3;
            tickRange.value = sIMPMessage;
            this.oststream.writeCombinedRange(tickRange);
            this.lastMsgAdded = l;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeUncommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeValue(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeValue", (Object)sIMPMessage);
        }
        TickRange tickRange = null;
        boolean bl = true;
        long l = -1L;
        if (sIMPMessage.isInStore()) {
            l = sIMPMessage.getID();
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l2 = jsMessage.getGuaranteedValueValueTick();
        long l3 = jsMessage.getGuaranteedValueStartTick();
        long l4 = jsMessage.getGuaranteedValueEndTick();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeValue at: " + l2 + " with Silence from: " + l3 + " to " + l4 + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tickRange = TickRange.newValueTick(l2, null, l);
            tickRange.startstamp = l3;
            tickRange.endstamp = l4;
            this.oststream.writeCombinedRange(tickRange);
            ++this.totalMessagesSent;
            bl = this.msgCanBeSent(l2);
            if (bl) {
                this.lastMsgSent = l2;
                if (!this.ackExpAlarmStarted) {
                    this.ackExpAlarmStarted = true;
                    this.timerStartSendTick = this.lastMsgSent;
                    this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                    this.am.create(this.ackExpInterval, this.ackExpExpiryHandler);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeSilence(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilence", (Object)new Object[]{sIMPMessage});
        }
        boolean bl = true;
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        long l2 = jsMessage.getGuaranteedValueStartTick();
        long l3 = jsMessage.getGuaranteedValueEndTick();
        if (l3 < l) {
            l3 = l;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilence from: " + l2 + " to " + l3 + " on Stream " + this.stream));
        }
        TickRange tickRange = new TickRange(7, l2, l3);
        ArrayList<TickRange> arrayList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tickRange = this.oststream.writeCompletedRange(tickRange);
            bl = this.msgCanBeSent(l);
            if (bl && l > this.lastMsgSent) {
                this.lastMsgSent = l;
            }
            TickRange tickRange2 = null;
            tickRange2 = this.msgRemoved(l, this.oststream, null);
            if (tickRange2 != null) {
                arrayList = new ArrayList<TickRange>();
                arrayList.add(tickRange2);
                this.lastMsgSent = tickRange2.valuestamp;
            }
        }
        if (arrayList != null) {
            this.sendMsgs(arrayList, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilence");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(SIMPMessage sIMPMessage) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Object[]{sIMPMessage});
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueStartTick();
        long l2 = jsMessage.getGuaranteedValueEndTick();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + l + " to " + l2 + " on Stream " + this.stream));
        }
        TickRange tickRange = new TickRange(7, l, l2);
        LinkedList<TickRange> linkedList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tickRange = this.oststream.writeCompletedRangeForced(tickRange);
            TickRange tickRange2 = null;
            tickRange2 = this.msgRemoved(jsMessage.getGuaranteedValueValueTick(), this.oststream, null);
            if (tickRange2 != null) {
                linkedList = new LinkedList<TickRange>();
                linkedList.add(tickRange2);
                this.lastMsgSent = tickRange2.valuestamp;
            }
        }
        if (linkedList != null) {
            this.sendMsgs(linkedList, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(TickRange tickRange) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Object[]{tickRange});
        }
        long l = tickRange.startstamp;
        long l2 = tickRange.endstamp;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + l + " to " + l2 + " on Stream " + this.stream));
        }
        TickRange tickRange2 = new TickRange(7, l, l2);
        LinkedList<TickRange> linkedList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tickRange2 = this.oststream.writeCompletedRangeForced(tickRange2);
            TickRange tickRange3 = null;
            tickRange3 = this.msgRemoved(tickRange.valuestamp, this.oststream, null);
            if (tickRange3 != null) {
                linkedList = new LinkedList<TickRange>();
                linkedList.add(tickRange3);
                this.lastMsgSent = tickRange3.valuestamp;
            }
        }
        if (linkedList != null) {
            this.sendMsgs(linkedList, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSilenceForced(long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeSilenceForced", (Object)new Long(l));
        }
        LinkedList<TickRange> linkedList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream.setCursor(l);
            TickRange tickRange = this.oststream.getNext();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("writeSilenceForced from: " + tickRange.startstamp + " to " + tickRange.endstamp + " on Stream " + this.stream));
            }
            this.oststream.writeCompletedRangeForced(tickRange);
            TickRange tickRange2 = null;
            tickRange2 = this.msgRemoved(l, this.oststream, null);
            if (tickRange2 != null) {
                linkedList = new LinkedList<TickRange>();
                linkedList.add(tickRange2);
                this.lastMsgSent = tickRange2.valuestamp;
            }
        }
        if (linkedList != null) {
            this.sendMsgs(linkedList, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeSilenceForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List writeAckPrefix(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeAckPrefix", (Object)new Long(l));
        }
        ArrayList<TickRange> arrayList = new ArrayList<TickRange>();
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            long l2 = this.oststream.getCompletedPrefix();
            if (l > l2) {
                this.oststream.setCursor(l2 + 1L);
                TickRange tickRange = this.oststream.getNext();
                TickRange tickRange2 = null;
                while (tickRange.startstamp <= l && tickRange != tickRange2) {
                    if (tickRange.type == 3) {
                        arrayList.add(tickRange);
                    } else if (tickRange.type != 7) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Invalid message found processing ack stamp " + l + ": completed prefix " + l2), (Object)tickRange);
                        }
                        InvalidMessageException invalidMessageException = new InvalidMessageException();
                        FFDCFilter.processException((Throwable)invalidMessageException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.writeAckPrefix", (String)"1:860:1.102", (Object)this, (Object[])new Object[]{new Long(l), new Long(l2), tickRange});
                        try {
                            this.writeSilenceForced(tickRange);
                        }
                        catch (SIResourceException sIResourceException) {
                            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.writeAckPrefix", (String)"1:874:1.102", (Object)this);
                        }
                    }
                    tickRange2 = tickRange;
                    tickRange = this.oststream.getNext();
                }
                this.oststream.setCompletedPrefix(l);
                this.oack = this.oststream.getCompletedPrefix();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeAckPrefix", (Object)Boolean.FALSE);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNack(ControlNack controlNack) throws SIResourceException {
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)controlNack);
        }
        boolean bl = false;
        ArrayList<TickRange> arrayList = new ArrayList<TickRange>();
        boolean bl2 = false;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl3 = false;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = controlNack.getStartTick();
        long l7 = controlNack.getEndTick();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("processNack from: " + l6 + " to " + l7 + " on Stream " + this.stream));
        }
        TickRange tickRange = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            l = this.oststream.getCompletedPrefix();
            if (l6 <= l) {
                bl2 = true;
                l2 = l6;
                l3 = l;
                l6 = l + 1L;
            }
            if (l7 > l) {
                this.oststream.setCursor(l6);
                TickRange tickRange2 = this.oststream.getNext();
                TickRange tickRange3 = null;
                while (tickRange2.startstamp <= l7 && tickRange2 != tickRange3 && tickRange2.type != 0 && tickRange2.type != 1) {
                    if (tickRange2.type == 3) {
                        if (bl) {
                            arrayList.add(tickRange);
                        }
                        if (!this.msgCanBeSent(tickRange2.valuestamp)) break;
                        tickRange = (TickRange)tickRange2.clone();
                        bl = true;
                    } else if (tickRange2.type == 2 && bl) {
                        if (tickRange2.valuestamp > tickRange.valuestamp + 1L) {
                            tickRange.endstamp = tickRange2.valuestamp - 1L;
                        }
                        arrayList.add(tickRange);
                        bl = false;
                    }
                    tickRange3 = tickRange2;
                    tickRange2 = this.oststream.getNext();
                }
                if (tickRange3 != null && tickRange3.type == 7) {
                    if (bl) {
                        tickRange.endstamp = tickRange3.endstamp;
                    } else if (this.msgCanBeSent(tickRange3.startstamp)) {
                        bl3 = true;
                        l4 = tickRange3.startstamp;
                        l5 = tickRange3.endstamp;
                    }
                }
                if (bl) {
                    arrayList.add(tickRange);
                }
            }
        }
        if (bl2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("processNack sending Silence from: " + l2 + " to " + l3 + " on Stream " + this.stream));
            }
            try {
                this.downControl.sendSilenceMessage(l2, l3, l, true, controlNack.getPriority(), controlNack.getReliability(), this.stream);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.processNack", (String)"1:1077:1.102", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (arrayList.size() != 0) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("processNack resending Value messages on Stream " + this.stream));
            }
            this.sendMsgs(arrayList, true);
        }
        if (bl3) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("processNack sending Silence from: " + l4 + " to " + l5 + " on Stream " + this.stream));
            }
            try {
                this.downControl.sendSilenceMessage(l4, l5, l, true, controlNack.getPriority(), controlNack.getReliability(), this.stream);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.processNack", (String)"1:1122:1.102", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processNack", (Object)((Object)sIResourceException));
                }
                throw sIResourceException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List restoreStream(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreStream");
        }
        ArrayList<Long> arrayList = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream.setCursor(0L);
            TickRange tickRange = this.oststream.getNext();
            TickRange tickRange2 = null;
            long l = 0L;
            while (tickRange.endstamp != Long.MAX_VALUE) {
                if (tickRange.type == 3 || tickRange.type == 2) {
                    tickRange2 = new TickRange(7, l + 1L, tickRange.valuestamp - 1L);
                    this.oststream.writeCompletedRange(tickRange2);
                    l = tickRange.valuestamp;
                    ++this.totalMessages;
                    if (this.totalMessages > this.sendWindow) {
                        if (this.firstMsgOutsideWindow == Long.MAX_VALUE) {
                            this.firstMsgOutsideWindow = tickRange.valuestamp;
                        }
                    } else if (tickRange.type == 3) {
                        this.lastMsgSent = tickRange.valuestamp;
                        if (arrayList == null) {
                            arrayList = new ArrayList<Long>();
                        }
                        arrayList.add(new Long(tickRange.itemStreamIndex));
                    }
                    this.oststream.setCursor(tickRange.valuestamp);
                    tickRange = this.oststream.getNext();
                }
                tickRange = this.oststream.getNext();
            }
            this.lastMsgAdded = l;
            if ((n & 2) == 0 && !this.ackExpAlarmStarted) {
                this.ackExpAlarmStarted = true;
                this.timerStartSendTick = this.lastMsgSent;
                this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                this.am.create(this.ackExpInterval, this.ackExpExpiryHandler);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreStream");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreUncommitted(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreUncommitted", (Object)new Object[]{sIMPMessage});
        }
        TickRange tickRange = null;
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l = jsMessage.getGuaranteedValueValueTick();
        long l2 = jsMessage.getGuaranteedValueStartTick();
        long l3 = jsMessage.getGuaranteedValueEndTick();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("restoreUncommitted at: " + l + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tickRange = TickRange.newUncommittedTick(l);
            tickRange.startstamp = l2;
            tickRange.endstamp = l3;
            tickRange.value = sIMPMessage;
            this.oststream.writeCombinedRange(tickRange);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreUncommitted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreValue(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreValue", (Object)sIMPMessage);
        }
        TickRange tickRange = null;
        long l = -1L;
        if (sIMPMessage.isInStore()) {
            l = sIMPMessage.getID();
        }
        JsMessage jsMessage = sIMPMessage.getMessage();
        long l2 = jsMessage.getGuaranteedValueValueTick();
        long l3 = jsMessage.getGuaranteedValueStartTick();
        long l4 = jsMessage.getGuaranteedValueEndTick();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("restoreValue at: " + l2 + " with Silence from: " + l3 + " to " + l4 + " on Stream " + this.stream));
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            tickRange = TickRange.newValueTick(l2, null, l);
            tickRange.startstamp = l3;
            tickRange.endstamp = l4;
            this.oststream.writeCombinedRange(tickRange);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreValue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMemory() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"releaseMemory");
        }
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            this.oststream = new StateStream();
            this.oststream.init();
            this.oststream.setCompletedPrefix(this.oack);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"releaseMemory");
        }
    }

    public String toString() {
        String string = "SourceStream : Stream ID " + this.stream + " Priority " + this.priority + " Reliability " + this.reliability;
        return string;
    }

    public synchronized boolean flushable() {
        TickRange tickRange = new TickRange(0, 0L, Long.MAX_VALUE);
        return !this.oststream.containsState(tickRange, (byte)3) && !this.oststream.containsState(tickRange, (byte)2) && !this.oststream.containsState(tickRange, (byte)8);
    }

    public synchronized void newGuessInStream(long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newGuessInStream()");
        }
        if (!this.containsGuesses) {
            this.containsGuesses = true;
            if (this.sendWindow > this.totalMessages) {
                this.sendWindow = this.totalMessages;
                this.persistSendWindow(this.sendWindow, null);
                this.firstMsgOutsideWindow = l;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newGuessInStream()");
        }
    }

    public synchronized void guessesInStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"guessesInStream");
        }
        this.containsGuesses = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"guessesInStream");
        }
    }

    public synchronized void noGuessesInStream() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"noGuessesInStream");
        }
        this.containsGuesses = false;
        if (this.definedSendWindow > this.sendWindow) {
            long l = this.sendWindow;
            this.sendWindow = this.definedSendWindow;
            this.persistSendWindow(this.sendWindow, null);
            this.sendMsgsInWindow(l, this.sendWindow);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("no processing : definedSendWindow=" + this.definedSendWindow + ", sendWindow=" + this.sendWindow));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"noGuessesInStream");
        }
    }

    public synchronized void initialiseSendWindow(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseSendWindow", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        if (l == Long.MAX_VALUE) {
            this.definedSendWindow = l2;
            this.sendWindow = l2;
        } else {
            this.sendWindow = l;
            this.definedSendWindow = l2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseSendWindow");
        }
    }

    public synchronized void setDefinedSendWindow(long l) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDefinedSendWindow", (Object)new Long(l));
        }
        this.definedSendWindow = l;
        this.updateAndPersistSendWindow();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDefinedSendWindow", (Object)new Long(l));
        }
    }

    public void updateAndPersistSendWindow() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateAndPersistSendWindow");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("definedSendWindow is: " + this.definedSendWindow + " sendWindow is " + this.sendWindow + " containsGuesses is " + this.containsGuesses));
        }
        if (this.definedSendWindow > this.sendWindow) {
            if (!this.containsGuesses) {
                long l = this.sendWindow;
                this.sendWindow = this.definedSendWindow;
                this.persistSendWindow(this.sendWindow, null);
                this.sendMsgsInWindow(l, this.sendWindow);
            }
        } else if (this.definedSendWindow > this.totalMessages) {
            this.sendWindow = this.definedSendWindow;
            this.persistSendWindow(this.sendWindow, null);
        } else if (this.totalMessages < this.sendWindow) {
            this.sendWindow = this.totalMessages;
            this.persistSendWindow(this.sendWindow, null);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateAndPersistSendWindow");
        }
    }

    public void msgAdded(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"msgAdded");
        }
        ++this.totalMessages;
        if (this.totalMessages > this.sendWindow && this.firstMsgOutsideWindow == Long.MAX_VALUE) {
            this.firstMsgOutsideWindow = l;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"msgAdded");
        }
    }

    public boolean msgCanBeSent(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"msgCanBeSent", (Object)new Long(l));
        }
        boolean bl = true;
        if (l >= this.firstMsgOutsideWindow || this.containsGuesses) {
            bl = false;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("firstMsgOutsideWindow is: " + this.firstMsgOutsideWindow + " sendWindow is " + this.sendWindow + " containsGuesses is " + this.containsGuesses));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"msgCanBeSent", (Object)bl);
        }
        return bl;
    }

    private TickRange msgRemoved(long l, StateStream stateStream, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"msgRemoved", (Object)new Object[]{new Long(l), stateStream, transaction});
        }
        TickRange tickRange = null;
        boolean bl = false;
        long l2 = l;
        --this.totalMessages;
        if ((this.containsGuesses || this.sendWindow > this.definedSendWindow) && l2 < this.firstMsgOutsideWindow) {
            if (this.sendWindow > 0L) {
                --this.sendWindow;
                this.persistSendWindow(this.sendWindow, transaction);
            }
        } else if (l2 <= this.firstMsgOutsideWindow) {
            stateStream.setCursor(this.firstMsgOutsideWindow);
            tickRange = stateStream.getNext();
            if (tickRange.type == 3) {
                bl = true;
            }
            TickRange tickRange2 = null;
            if (this.totalMessages > this.sendWindow) {
                tickRange2 = stateStream.getNext();
                while (tickRange2.type == 7 && tickRange2.endstamp != Long.MAX_VALUE) {
                    tickRange2 = stateStream.getNext();
                }
                this.firstMsgOutsideWindow = tickRange2.valuestamp;
            } else {
                this.firstMsgOutsideWindow = Long.MAX_VALUE;
            }
        }
        if (!bl) {
            tickRange = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"msgRemoved", (Object)tickRange);
        }
        return tickRange;
    }

    private void sendMsgsInWindow(long l, long l2) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendMsgsInWindow", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        long l3 = Long.MAX_VALUE;
        long l4 = 0L;
        if (this.totalMessages > l) {
            l4 = this.totalMessages > l2 ? l2 - l : this.totalMessages - l;
            this.oststream.setCursor(this.firstMsgOutsideWindow);
            TickRange tickRange = this.oststream.getNext();
            ArrayList<TickRange> arrayList = new ArrayList<TickRange>();
            while ((long)arrayList.size() < l4) {
                if (tickRange.type == 3) {
                    arrayList.add(tickRange);
                    this.lastMsgSent = tickRange.valuestamp;
                } else if (tickRange.type == 2) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("uncommited tick range: " + tickRange + " : reducing messagesToSend from " + l4 + " to " + (l4 - 1L)));
                    }
                    --l4;
                }
                tickRange = this.oststream.getNext();
            }
            if (this.totalMessages > l2) {
                while (tickRange.type == 7 && tickRange.endstamp != Long.MAX_VALUE) {
                    tickRange = this.oststream.getNext();
                }
                l3 = tickRange.valuestamp;
            }
            if (arrayList.size() != 0) {
                this.sendMsgs(arrayList, false);
            }
        }
        this.firstMsgOutsideWindow = l3;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMsgsInWindow");
        }
    }

    void persistSendWindow(long l, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persistSendWindow", (Object)new Object[]{new Long(l), transaction});
        }
        this.streamSet.setPersistentData(this.priority, this.reliability, l);
        this.streamSet.requestUpdate(this.reliability, transaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persistSendWindow");
        }
    }

    public synchronized List getMessagesAfterSendWindow() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagesAfterSendWindow");
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (this.firstMsgOutsideWindow != Long.MAX_VALUE) {
            this.oststream.setCursor(this.firstMsgOutsideWindow);
            TickRange tickRange = this.oststream.getNext();
            while (tickRange.endstamp < Long.MAX_VALUE) {
                if (tickRange.type == 3) {
                    arrayList.add(new Long(tickRange.itemStreamIndex));
                }
                if (tickRange.type == 2) {
                    tickRange.reallocateOnCommit();
                }
                tickRange = this.oststream.getNext();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagesAfterSendWindow", arrayList);
        }
        return arrayList;
    }

    public synchronized List getAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList<Long> linkedList = new LinkedList<Long>();
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                linkedList.add(new Long(tickRange.itemStreamIndex));
            }
            if (tickRange.type == 2) {
                tickRange.reallocateOnCommit();
            }
            tickRange = this.oststream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        return Collections.unmodifiableList(linkedList);
    }

    public synchronized List getAllMessageItemsOnStream(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessageItemsOnStream", (Object)new Boolean(bl));
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                long l = tickRange.itemStreamIndex;
                MessageItem messageItem = this.downControl.getValueMessage(l);
                if (messageItem != null) {
                    linkedList.add(messageItem);
                }
            } else if (tickRange.type == 2 && bl && tickRange.value != null) {
                linkedList.add(tickRange.value);
            }
            tickRange = this.oststream.getNext();
        }
        List list = Collections.unmodifiableList(linkedList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessageItemsOnStream", list);
        }
        return list;
    }

    public synchronized long countAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"countAllMessagesOnStream");
        }
        long l = 0L;
        this.oststream.setCursor(0L);
        TickRange tickRange = this.oststream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type == 3) {
                ++l;
            }
            if (tickRange.type == 2) {
                tickRange.reallocateOnCommit();
            }
            tickRange = this.oststream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"countAllMessagesOnStream", (Object)new Long(l));
        }
        return l;
    }

    public synchronized TickRange getTickRange(long l) {
        this.oststream.setCursor(l);
        return (TickRange)this.oststream.getNext().clone();
    }

    private void sendMsgs(List list, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendMsgs", (Object)list);
        }
        if (!this.ackExpAlarmStarted) {
            this.ackExpAlarmStarted = true;
            this.timerStartSendTick = this.lastMsgSent;
            this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
            this.am.create(this.ackExpInterval, this.ackExpExpiryHandler);
        }
        List list2 = null;
        try {
            list2 = this.downControl.sendValueMessages(list, this.getCompletedPrefix(), bl, this.priority, this.reliability, this.streamSet.getStreamID());
            this.totalMessagesSent += (long)list.size();
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.sendMsgs", (String)"1:2046:1.102", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendMsgs", (Object)((Object)sIResourceException));
            }
            throw sIResourceException;
        }
        if (list2 != null) {
            TickRange tickRange = null;
            for (int i = 0; i < list2.size(); ++i) {
                tickRange = (TickRange)list2.get(i);
                this.writeSilenceForced(tickRange);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendMsgs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batchPrecommit(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"batchPrecommit", (Object)transaction);
        }
        TickRange tickRange = null;
        TickRange tickRange2 = null;
        SourceStream sourceStream = this;
        synchronized (sourceStream) {
            for (int i = 0; i < this.batchList.size(); ++i) {
                tickRange2 = (TickRange)this.batchList.get(i);
                try {
                    tickRange = this.msgRemoved(tickRange2.valuestamp, this.oststream, transaction);
                    if (tickRange == null) continue;
                    this.batchSendList.add(tickRange);
                    this.lastMsgSent = tickRange.valuestamp;
                    continue;
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.batchPrecommit", (String)"1:2104:1.102", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchPrecommit");
        }
    }

    public void batchCommitted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"batchCommitted");
        }
        if (this.batchSendList.size() != 0) {
            try {
                this.sendMsgs(this.batchSendList, false);
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.SourceStream.batchCommitted", (String)"1:2135:1.102", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
            }
        }
        this.batchList.clear();
        this.batchSendList.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"batchCommitted");
        }
    }

    public void batchRolledBack() {
    }

    public void addToBatchList(TickRange tickRange) {
        this.batchList.add(tickRange);
    }

    public SourceStreamControl getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        SourceStreamControl sourceStreamControl = new SourceStreamControl(this.remoteEngineUUID, this, this.streamSet);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)sourceStreamControl);
        }
        return sourceStreamControl;
    }

    private TickRange getRangeForMessageId(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRangeForMessageId", (Object)new Long(l));
        }
        TickRange tickRange = null;
        if (l != -1L) {
            this.oststream.setCursor(0L);
            TickRange tickRange2 = this.oststream.getNext();
            while (tickRange2.endstamp < Long.MAX_VALUE) {
                if (tickRange2.type == 3 && tickRange2.value instanceof MessageItem && ((MessageItem)tickRange2.value).getID() == l) {
                    tickRange = tickRange2;
                    break;
                }
                tickRange2 = this.oststream.getNext();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRangeForMessageId", tickRange);
        }
        return tickRange;
    }

    public synchronized void moveMessage(long l) {
        TickRange tickRange;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessage", (Object)new Long(l));
        }
        if ((tickRange = this.getRangeForMessageId(l)) != null) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/SourceStream.java, SIB.processor, WAS602.SIB, o0610.11 1.102");
        }
    }

    public class AckExpExpiryHandler
    implements AlarmListener {
        private SourceStream sourceStream;

        public AckExpExpiryHandler(SourceStream sourceStream2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AckExpExpiryHandler", (Object)sourceStream2);
            }
            this.sourceStream = sourceStream2;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AckExpExpiryHandler", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            block12: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
                }
                try {
                    long l = SourceStream.this.getCompletedPrefix();
                    if (SourceStream.this.timerStartSendTick > l) {
                        SourceStream.this.downControl.sendAckExpectedMessage(SourceStream.this.timerStartSendTick, SourceStream.this.priority, SourceStream.this.reliability, SourceStream.this.stream);
                    }
                    SourceStream sourceStream = this.sourceStream;
                    synchronized (sourceStream) {
                        if (SourceStream.this.lastMsgSent > l) {
                            if (SourceStream.this.timerStartSendTick > l) {
                                SourceStream.this.ackExpInterval = SourceStream.this.ackExpInterval * 2L > (long)GDConfig.GD_ACK_EXPECTED_THRESHOLD_MAX ? (long)GDConfig.GD_ACK_EXPECTED_THRESHOLD_MAX : SourceStream.this.ackExpInterval * 2L;
                            } else {
                                SourceStream.this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                            }
                            SourceStream.this.timerStartSendTick = SourceStream.this.lastMsgSent;
                            SourceStream.this.am.create(SourceStream.this.ackExpInterval, SourceStream.this.ackExpExpiryHandler);
                        } else {
                            SourceStream.this.ackExpAlarmStarted = false;
                            SourceStream.this.ackExpInterval = GDConfig.GD_ACK_EXPECTED_THRESHOLD;
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.gd.SourceStream.AckExpExpiryHandler.alarm", (String)"1:1452:1.102", (Object)this);
                    if (!tc.isDebugEnabled()) break block12;
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    public static class SourceStreamState
    implements SIMPDeliveryTransmitControllable.StreamState {
        public static final SourceStreamState ACTIVE = new SourceStreamState("Active", 0);
        private String state;
        private int value = -1;

        private SourceStreamState(String string, int n) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"SourceStreamState", (Object)new Object[]{string, new Integer(n)});
            }
            this.state = string;
            this.value = n;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"SourceStreamState", (Object)this);
            }
        }

        public String toString() {
            return this.state;
        }

        public int getValue() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getValue");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getValue", (Object)new Integer(this.value));
            }
            return this.value;
        }
    }
}

