/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class InternalInputStream
extends ControllableStream {
    private static final TraceComponent tc = SibTr.register((Class)InternalInputStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    volatile long iack;
    private StateStream iststream;
    private int priority;
    private Reliability reliability;
    AckExpiryHandle ackExpiry;
    UpstreamControl upControl;
    SIBUuid12 streamID;
    private MPAlarmManager am;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalInputStream(int n, Reliability reliability, UpstreamControl upstreamControl, SIBUuid12 sIBUuid12, List list, MPAlarmManager mPAlarmManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalInputStream", (Object)new Object[]{new Integer(n), reliability, upstreamControl, sIBUuid12, list, mPAlarmManager});
        }
        InternalInputStream internalInputStream = this;
        synchronized (internalInputStream) {
            this.priority = n;
            this.reliability = reliability;
            this.upControl = upstreamControl;
            this.am = mPAlarmManager;
            this.streamID = sIBUuid12;
            this.iststream = new StateStream();
            this.iststream.init();
            this.iack = 0L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalInputStream", (Object)this);
        }
    }

    private void sendAck() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAck");
        }
        try {
            this.upControl.sendAckMessage(null, null, null, this.iack, this.priority, this.reliability, this.streamID, false);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.InternalInputStream.sendAck", (String)"1:161:1.42", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAck");
        }
    }

    protected void scheduleAck() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"scheduleAck");
        }
        if (GDConfig.GD_ACK_PROPAGATION_THRESHOLD == 0) {
            this.sendAck();
        } else if (this.ackExpiry == null) {
            this.ackExpiry = new AckExpiryHandle();
            this.am.create(GDConfig.GD_ACK_PROPAGATION_THRESHOLD, this.ackExpiry, this.ackExpiry);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleAck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNack(ControlNack controlNack) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)controlNack);
        }
        long l = controlNack.getStartTick();
        long l2 = controlNack.getEndTick();
        InternalInputStream internalInputStream = this;
        synchronized (internalInputStream) {
            TickRange tickRange;
            this.iststream.setCursor(l);
            boolean bl = false;
            TickRange tickRange2 = this.iststream.getNext();
            do {
                if (tickRange2.type == 0) {
                    bl = true;
                    long l3 = InternalInputStream.max(tickRange2.startstamp, l);
                    long l4 = InternalInputStream.min(tickRange2.endstamp, l2);
                    this.upControl.sendNackMessage(null, null, null, l3, l4, this.priority, this.reliability, this.streamID);
                }
                tickRange = tickRange2;
                tickRange2 = this.iststream.getNext();
            } while (tickRange2.startstamp <= l2 && tickRange != tickRange2);
            if (bl) {
                tickRange2 = new TickRange(1, l, l2);
                this.iststream.writeRange(tickRange2);
                new ReqExpiryHandle(tickRange2);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAckExpected(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{new Long(l)});
        }
        InternalInputStream internalInputStream = this;
        synchronized (internalInputStream) {
            this.sendAck();
            if (l > this.iack) {
                try {
                    this.upControl.sendNackMessage(null, null, null, this.iack + 1L, l, this.priority, this.reliability, this.streamID);
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.gd.InternalInputStream.processAckExpected", (String)"1:379:1.42", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.InternalInputStream", "1:386:1.42", sIResourceException});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)((Object)sIResourceException));
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.InternalInputStream", "1:397:1.42", sIResourceException}, null), (Throwable)sIResourceException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    public synchronized void releaseMemory() {
        this.iststream = new StateStream();
        this.iststream.init();
    }

    private static long max(long l, long l2) {
        return l > l2 ? l : l2;
    }

    private static long min(long l, long l2) {
        return l < l2 ? l : l2;
    }

    public long getAckPrefix() {
        return this.iack;
    }

    public synchronized List writeAckPrefix(long l) {
        this.iack = l;
        this.scheduleAck();
        return null;
    }

    public long getCompletedPrefix() {
        return this.iststream.getCompletedPrefix();
    }

    public StateStream getStateStream() {
        return this.iststream;
    }

    public void writeSilenceForced(long l) {
    }

    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    protected Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/InternalInputStream.java, SIB.processor, WAS602.SIB, o0610.11 1.42");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }

    class ReqExpiryHandle
    implements AlarmListener {
        TickRange tr;

        ReqExpiryHandle(TickRange tickRange) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ReqExpiryHandle", (Object)tickRange);
            }
            this.tr = tickRange;
            InternalInputStream.this.am.create(GDConfig.GD_REQUESTED_FORGETTING_THRESHOLD, this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReqExpiryHandle", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            InternalInputStream internalInputStream = InternalInputStream.this;
            synchronized (internalInputStream) {
                if (this.tr.type == 1) {
                    this.tr.type = 0;
                    InternalInputStream.this.iststream.writeRange(this.tr);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    class AckExpiryHandle
    implements AlarmListener {
        AckExpiryHandle() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
            }
            if (object == InternalInputStream.this.ackExpiry) {
                AckExpiryHandle ackExpiryHandle = this;
                synchronized (ackExpiryHandle) {
                    InternalInputStream.this.ackExpiry = null;
                }
                try {
                    InternalInputStream.this.upControl.sendAckMessage(null, null, null, InternalInputStream.this.iack, InternalInputStream.this.priority, InternalInputStream.this.reliability, InternalInputStream.this.streamID, false);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.InternalInputStream.AckExpiryHandle.alarm", (String)"1:228:1.42", (Object)this);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }
}

