/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TargetStream;
import com.ibm.ws.sib.processor.impl.interfaces.MessageDeliverer;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.TargetStreamControl;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.LinkedList;
import java.util.List;

public class ExpressTargetStream
extends ControllableStream
implements TargetStream {
    private MessageDeliverer deliverer;
    private static TraceComponent tc = SibTr.register((Class)ExpressTargetStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private long lastTick;
    private long messagesReceived;
    private SIBUuid12 streamSetUUID;
    String remoteEngineUUID;
    private ExpressTargetStreamState streamState = ExpressTargetStreamState.ACTIVE;

    public ExpressTargetStream(MessageDeliverer messageDeliverer, String string, SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ExpressTargetStream", (Object)new Object[]{messageDeliverer, string, sIBUuid12});
        }
        this.remoteEngineUUID = string;
        this.lastTick = -1L;
        this.deliverer = messageDeliverer;
        this.streamSetUUID = sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ExpressTargetStream", (Object)this);
        }
    }

    public long getCompletedPrefix() {
        return this.lastTick;
    }

    private boolean getStreamIsFull(JsMessage jsMessage) throws SIException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamIsFull", (Object)jsMessage);
        }
        boolean bl = this.deliverer.isDestinationFull(jsMessage.getRoutingDestination());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamIsFull", (Object)new Boolean(bl));
        }
        return bl;
    }

    public synchronized void writeValue(MessageItem messageItem) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"writeValue", (Object)messageItem);
        }
        if (messageItem.getMessage().getGuaranteedValueValueTick() > this.lastTick) {
            try {
                if (this.getStreamIsFull(messageItem.getMessage())) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"discarding message as the stream is full.");
                    }
                } else {
                    this.deliverer.deliverExpressMessage(messageItem, this);
                    ++this.messagesReceived;
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.gd.ExpressTargetStream.writeValue", (String)"1:192:1.43", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"writeValue", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"writeValue");
        }
    }

    public long reconstituteCompletedPrefix(long l) {
        this.lastTick = l;
        return this.lastTick;
    }

    public void setCompletedPrefix(long l) {
        this.lastTick = l;
    }

    public void writeSilence(ControlSilence controlSilence) {
    }

    public void writeSilence(MessageItem messageItem) {
    }

    public void processAckExpected(long l) {
    }

    public void flush() {
    }

    public void batchPrecommit(Transaction transaction) {
    }

    public void batchCommitted() {
    }

    public void batchRolledBack() {
    }

    public long getLastKnownTick() {
        return this.lastTick;
    }

    public StateStream getStateStream() {
        return null;
    }

    public void writeSilenceForced(long l) {
    }

    protected int getPriority() {
        return 0;
    }

    protected Reliability getReliability() {
        return Reliability.EXPRESS_NONPERSISTENT;
    }

    public TargetStreamControl getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        TargetStreamControl targetStreamControl = new TargetStreamControl(this.remoteEngineUUID, this, this.streamSetUUID, this.getReliability(), this.getPriority());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)targetStreamControl);
        }
        return targetStreamControl;
    }

    public List getAllMessagesOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllMessagesOnStream");
        }
        LinkedList linkedList = new LinkedList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllMessagesOnStream", linkedList);
        }
        return linkedList;
    }

    public long getNumberOfMessagesReceived() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesReceived");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesReceived", (Object)new Long(this.messagesReceived));
        }
        return this.messagesReceived;
    }

    public TargetStream.TargetStreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)this.streamState);
        }
        return this.streamState;
    }

    public long countAllMessagesOnStream() {
        return 0L;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/ExpressTargetStream.java, SIB.processor, WAS602.SIB, o0610.11 1.43");
        }
    }

    public static class ExpressTargetStreamState
    extends TargetStream.TargetStreamState {
        public static final ExpressTargetStreamState ACTIVE = new ExpressTargetStreamState("Active", 1);

        private ExpressTargetStreamState(String string, int n) {
            super(string, n);
        }
    }
}

