/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

public abstract class ControllableStream
implements Stream {
    private static final TraceComponent tc = SibTr.register((Class)ControllableStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final String ID_SEPERATOR = ":";

    public synchronized List getTicksOnStream() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTicksOnStream");
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        StateStream stateStream = this.getStateStream();
        stateStream.setCursor(0L);
        stateStream.getNext();
        TickRange tickRange = stateStream.getNext();
        while (tickRange.endstamp < Long.MAX_VALUE) {
            if (tickRange.type != 7) {
                arrayList.add(new Long(tickRange.startstamp));
            }
            tickRange = stateStream.getNext();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTicksOnStream");
        }
        return arrayList;
    }

    public synchronized TickRange getTickRange(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTickRange");
        }
        TickRange tickRange = null;
        StateStream stateStream = this.getStateStream();
        stateStream.setCursor(l);
        tickRange = (TickRange)stateStream.getNext().clone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTickRange", (Object)tickRange);
        }
        return tickRange;
    }

    public abstract long getCompletedPrefix();

    public abstract StateStream getStateStream();

    public abstract void writeSilenceForced(long var1) throws SIException;

    public String getID() {
        String string = "" + this.getReliability() + ID_SEPERATOR + this.getPriority() + ID_SEPERATOR;
        return string;
    }

    protected abstract Reliability getReliability();

    protected abstract int getPriority();

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/gd/ControllableStream.java, SIB.processor, WAS602.SIB, o0610.11 1.10");
        }
    }
}

