/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.XidAlreadyKnownException;
import com.ibm.ws.sib.msgstore.XidStillAssociatedException;
import com.ibm.ws.sib.msgstore.XidUnknownException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.transactions.ExternalXAResource;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.msgstore.transactions.TransactionParticipant;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.WorkList;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.msgstore.transactions.XidParticipant;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MSDelegatingXAResource
implements ExternalXAResource,
PersistentTransaction {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)MSDelegatingXAResource.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private MessageStoreImpl _ms;
    private MSInstrumentation _pmi;
    private PersistenceManager _persistence;
    private PersistentTranId _currentPtid;
    private TransactionParticipant _currentTran;
    private XidManager _manager;
    private int _maxSize;
    private BatchingContext _bc;

    public MSDelegatingXAResource(MessageStoreImpl messageStoreImpl, PersistenceManager persistenceManager, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MSDelegatingXAResource", (Object)("MessageStore=" + messageStoreImpl + ", Persistence=" + persistenceManager + ", MaxSize=" + n));
        }
        this._ms = messageStoreImpl;
        this._pmi = messageStoreImpl._getInstrumentation();
        this._manager = messageStoreImpl.getXidManager();
        this._persistence = persistenceManager;
        this._maxSize = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MSDelegatingXAResource");
        }
    }

    public synchronized void addWork(WorkItem workItem) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + workItem));
        }
        if (this._currentTran == null) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"No Xid currently associated with this XAResource!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addWork");
            }
            throw protocolException;
        }
        this._currentTran.addWork(workItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    public WorkList getWorkList() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWorkList");
        }
        WorkList workList = null;
        if (this._currentTran != null) {
            workList = this._currentTran.getWorkList();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWorkList", (Object)("return=" + workList));
        }
        return workList;
    }

    public void registerCallback(TransactionCallback transactionCallback) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + transactionCallback));
        }
        if (this._currentTran != null) {
            this._currentTran.registerCallback(transactionCallback);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No Xid currently associated with this XAResource!");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    public final boolean isAutoCommit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((TraceComponent)tc, (String)"isAutoCommit", (Object)"return=false");
        }
        return false;
    }

    public PersistentTranId getPersistentTranId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentTranId");
        }
        PersistentTranId persistentTranId = null;
        if (this._currentTran != null) {
            persistentTranId = this._currentTran.getPersistentTranId();
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + persistentTranId));
        }
        return persistentTranId;
    }

    public void incrementCurrentSize() throws TransactionMaxSizeExceededException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incrementCurrentSize");
        }
        if (this._currentTran != null) {
            this._currentTran.incrementCurrentSize();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incrementCurrentSize");
        }
    }

    public boolean isAlive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlive");
        }
        boolean bl = false;
        if (this._currentTran != null) {
            bl = this._currentTran.isAlive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAlive", (Object)("return=" + bl));
        }
        return bl;
    }

    public void start(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)("XID=" + xid + ", Flags=" + n));
        }
        if (this._currentTran != null) {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot associate with XAResource. It is already associated with an Xid!", (Object)("CurrentXID=" + this._currentPtid));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start");
            }
            throw new XAException(-6);
        }
        try {
            this._currentPtid = new PersistentTranId(xid);
            this._currentTran = new XidParticipant(this._ms, this._currentPtid, this._persistence, this._maxSize);
            this._manager.start(this._currentPtid, this._currentTran);
            if (this._pmi != null) {
                this._pmi.increment(36);
            }
        }
        catch (XidAlreadyKnownException xidAlreadyKnownException) {
            FFDCFilter.processException((Throwable)((Object)xidAlreadyKnownException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.start", (String)"227", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot start new association with this Xid. It is already known!", (Object)((Object)xidAlreadyKnownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start");
            }
            throw new XAException(-8);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.start", (String)"234", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected exception caught during transaction association!", (Object)exception);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"start");
            }
            throw new XAException(-3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void end(Xid xid, int n) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"end", (Object)("XID=" + xid + ", Flags=" + n));
        }
        if (this._currentTran == null) {
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot dis-associate XAResource. It is not currently associated with an Xid!");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"end");
            }
            throw new XAException(-6);
        }
        try {
            this._manager.end(new PersistentTranId(xid));
            this._currentTran = null;
            this._currentPtid = null;
        }
        catch (XidUnknownException xidUnknownException) {
            FFDCFilter.processException((Throwable)((Object)xidUnknownException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.end", (String)"212", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot dis-associate from this Xid. It is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"end");
            }
            throw new XAException(-4);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"end");
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepare", (Object)("XID=" + xid));
        }
        int n = 0;
        try {
            n = this._manager.prepare(new PersistentTranId(xid));
            if (this._pmi != null) {
                this._pmi.increment(37);
            }
        }
        catch (XidStillAssociatedException xidStillAssociatedException) {
            FFDCFilter.processException((Throwable)((Object)xidStillAssociatedException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"351", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot prepare transaction branch, resources are still associated with this Xid!", (Object)((Object)xidStillAssociatedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw new XAException(-6);
        }
        catch (XidUnknownException xidUnknownException) {
            FFDCFilter.processException((Throwable)((Object)xidUnknownException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"358", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot prepare transaction branch, Xid is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw new XAException(-4);
        }
        catch (ProtocolException protocolException) {
            FFDCFilter.processException((Throwable)((Object)protocolException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"365", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"A Transaction protocol error occurred during prepare of transaction branch!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw new XAException(-6);
        }
        catch (RollbackException rollbackException) {
            FFDCFilter.processException((Throwable)((Object)rollbackException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"372", (Object)this);
            if (this._pmi != null) {
                this._pmi.increment(38);
            }
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"RollbackException caught during prepare of transaction branch!", (Object)((Object)rollbackException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw new XAException(100);
        }
        catch (SeverePersistenceException severePersistenceException) {
            FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"385", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected error occurred whilst persisting transaction work!", (Object)((Object)severePersistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"prepare");
            }
            throw new XAException(-7);
        }
        if (tc.isEntryEnabled()) {
            String string;
            switch (n) {
                case 0: {
                    string = "return=XA_OK";
                    break;
                }
                case 3: {
                    string = "return=XA_RDONLY";
                    break;
                }
                default: {
                    string = "return=XA_UNKNOWN";
                }
            }
            SibTr.exit((TraceComponent)tc, (String)"prepare", (Object)string);
        }
        return n;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit", (Object)("XID=" + xid + ", OnePhase=" + bl));
        }
        try {
            this._manager.commit(new PersistentTranId(xid), bl);
            if (this._pmi != null) {
                if (!bl) {
                    this._pmi.decrement(37);
                }
                this._pmi.increment(39);
            }
        }
        catch (XidUnknownException xidUnknownException) {
            FFDCFilter.processException((Throwable)((Object)xidUnknownException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"434", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot commit transaction branch, Xid is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(-4);
        }
        catch (XidStillAssociatedException xidStillAssociatedException) {
            FFDCFilter.processException((Throwable)((Object)xidStillAssociatedException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"441", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot commit transaction branch, resources are still associated with this Xid!", (Object)((Object)xidStillAssociatedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(-6);
        }
        catch (ProtocolException protocolException) {
            FFDCFilter.processException((Throwable)((Object)protocolException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"448", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"A Transaction protocol error occurred during prepare of transaction branch!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(-6);
        }
        catch (RollbackException rollbackException) {
            FFDCFilter.processException((Throwable)((Object)rollbackException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"455", (Object)this);
            if (this._pmi != null) {
                if (!bl) {
                    this._pmi.decrement(37);
                }
                this._pmi.increment(38);
            }
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"RollbackException caught during commit of transaction branch!", (Object)((Object)rollbackException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(100);
        }
        catch (SeverePersistenceException severePersistenceException) {
            FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"472", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected error occurred during commit of transaction branch!", (Object)((Object)severePersistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(-7);
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"479", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected error occurred whilst persisting transaction work!", (Object)((Object)persistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(4);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"486", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected error occurred during commit of transaction branch!", (Object)((Object)transactionException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"commit");
            }
            throw new XAException(-7);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback", (Object)("XID=" + xid));
        }
        try {
            this._manager.rollback(new PersistentTranId(xid));
            if (this._pmi != null) {
                this._pmi.increment(38);
            }
        }
        catch (XidUnknownException xidUnknownException) {
            FFDCFilter.processException((Throwable)((Object)xidUnknownException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"514", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot rollback transaction branch, Xid is unknown!", (Object)((Object)xidUnknownException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw new XAException(-4);
        }
        catch (XidStillAssociatedException xidStillAssociatedException) {
            FFDCFilter.processException((Throwable)((Object)xidStillAssociatedException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"521", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot rollback transaction branch, resources are still associated with this Xid!", (Object)((Object)xidStillAssociatedException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw new XAException(-6);
        }
        catch (ProtocolException protocolException) {
            FFDCFilter.processException((Throwable)((Object)protocolException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"528", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"A Transaction protocol error occurred during rollback of transaction branch!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw new XAException(-6);
        }
        catch (TransactionException transactionException) {
            FFDCFilter.processException((Throwable)((Object)transactionException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"535", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected error occurred during rollback of transaction branch!", (Object)((Object)transactionException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw new XAException(-7);
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"542", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Unexpected error occurred whilst persisting transaction work!", (Object)((Object)persistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw new XAException(-3);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public Xid[] recover(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recover", (Object)("Recovery ID=" + n));
        }
        Xid[] xidArray = this._manager.recover();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recover", (Object)("return=" + xidArray));
        }
        return xidArray;
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forget", (Object)("XID=" + xid));
            SibTr.exit((TraceComponent)tc, (String)"forget");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionTimeout");
            SibTr.exit((TraceComponent)tc, (String)"getTransactionTimeout", (Object)"return=0");
        }
        return 0;
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTransactionTimeout", (Object)("Timeout=" + n));
            SibTr.exit((TraceComponent)tc, (String)"setTransactionTimeout", (Object)"return=false");
        }
        return false;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSameRM", (Object)("Resource=" + xAResource));
        }
        boolean bl = false;
        if (xAResource != null && xAResource instanceof MSDelegatingXAResource) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSameRM", (Object)("return=" + bl));
        }
        return bl;
    }

    public final int getTransactionType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_GLOBAL");
        }
        return 2;
    }

    public void setTransactionState(int n) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("State=");
            switch (n) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.entry((TraceComponent)tc, (String)"setTransactionState", (Object)stringBuffer.toString());
        }
        if (this._currentTran != null) {
            this._currentTran.setTransactionState(n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionState");
        }
    }

    public int getTransactionState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionState");
        }
        int n = this._currentTran != null ? this._currentTran.getTransactionState() : 18;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("return=");
            switch (n) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                    break;
                }
                case 18: {
                    stringBuffer.append("STATE_NONE");
                }
            }
            SibTr.exit((TraceComponent)tc, (String)"getTransactionState", (Object)stringBuffer.toString());
        }
        return n;
    }

    public BatchingContext getBatchingContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    public void setBatchingContext(BatchingContext batchingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + batchingContext));
        }
        this._bc = batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBatchingContext");
        }
    }

    public boolean isEnlisted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEnlisted");
        }
        boolean bl = false;
        if (this._currentTran != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEnlisted", (Object)("return=" + bl));
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        n = this._currentTran != null ? this._currentTran.hashCode() : super.hashCode();
        return n;
    }
}

