/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.TransactionMaxSizeExceededException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.WorkList;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;

public class MSDelegatingLocalTransaction
implements ExternalLocalTransaction,
PersistentTransaction {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)MSDelegatingLocalTransaction.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private MessageStoreImpl _ms;
    private MSInstrumentation _pmi;
    private PersistenceManager _persistence;
    private XidManager _xidManager;
    private int _state = 10;
    private PersistentTranId _ptid;
    private WorkList _workList;
    private ArrayList _callbacks = new ArrayList(5);
    private int _maxSize;
    private int _size = 0;
    private BatchingContext _bc;

    public MSDelegatingLocalTransaction(MessageStoreImpl messageStoreImpl, PersistenceManager persistenceManager, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MSDelegatingLocalTransaction", (Object)("MessageStore=" + messageStoreImpl + ", Persistence=" + persistenceManager + ", MaxSize=" + n));
        }
        this._ms = messageStoreImpl;
        this._persistence = persistenceManager;
        this._maxSize = n;
        if (this._ms != null) {
            this._pmi = this._ms._getInstrumentation();
            this._xidManager = this._ms.getXidManager();
            if (this._pmi != null) {
                this._pmi.increment(33);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MSDelegatingLocalTransaction");
        }
    }

    public synchronized void addWork(WorkItem workItem) throws ProtocolException, TransactionException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + workItem));
        }
        if (this._state != 10) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot add work to transaction. Transaction is complete or completing!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addWork");
            }
            throw protocolException;
        }
        if (workItem != null) {
            if (this._workList == null) {
                this._workList = new TaskList();
            }
        } else {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot add null work item to transaction!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addWork");
            }
            throw protocolException;
        }
        this._workList.addWork(workItem);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addWork");
        }
    }

    public WorkList getWorkList() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getWorkList");
            SibTr.exit((TraceComponent)tc, (String)"getWorkList", (Object)("return=" + this._workList));
        }
        return this._workList;
    }

    public void registerCallback(TransactionCallback transactionCallback) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + transactionCallback));
        }
        this._callbacks.add(transactionCallback);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    public final boolean isAutoCommit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((TraceComponent)tc, (String)"isAutoCommit", (Object)"return=false");
        }
        return false;
    }

    public synchronized PersistentTranId getPersistentTranId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentTranId");
        }
        if (this._ptid == null) {
            this._ptid = this._xidManager != null ? new PersistentTranId(this._xidManager.generateLocalTranId()) : new PersistentTranId(this.hashCode());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + this._ptid));
        }
        return this._ptid;
    }

    public void incrementCurrentSize() throws TransactionMaxSizeExceededException {
        if (++this._size > this._maxSize) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
            }
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Maximum transaction size reached, throwing exception!");
            }
            throw new TransactionMaxSizeExceededException();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Transaction size incremented: " + this._size));
        }
    }

    public boolean isAlive() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlive");
        }
        boolean bl2 = bl = this._state == 10;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isAlive", (Object)("return=" + bl));
        }
        return bl;
    }

    public void begin() throws ProtocolException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"begin");
        }
        if (this._state == 10 && this._workList != null) {
            ProtocolException protocolException = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0]);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot begin new LocalTran. Existing work needs completing first!", (Object)((Object)protocolException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"begin");
            }
            throw protocolException;
        }
        this._ptid = null;
        this._workList = null;
        this._size = 0;
        this._callbacks.clear();
        this._state = 10;
        if (this._pmi != null) {
            this._pmi.increment(33);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"begin");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws SIIncorrectCallException, SIRollbackException, SIResourceException, SIErrorException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit");
        }
        if (this._state != 10) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("CANNOT_COMMIT_COMPLETE_SIMS1004", new Object[0], null));
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot commit Transaction. Transaction is complete or completing!", (Object)((Object)sIIncorrectCallException));
            }
            if (!tc.isEntryEnabled()) throw sIIncorrectCallException;
            SibTr.exit((TraceComponent)tc, (String)"commit");
            throw sIIncorrectCallException;
        }
        for (int i = 0; i < this._callbacks.size(); ++i) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
            transactionCallback.beforeCompletion(this);
        }
        if (this._workList != null) {
            try {
                this._workList.preCommit(this);
            }
            catch (Throwable throwable) {
                block35: {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:333:1.52", (Object)this);
                    try {
                        this.rollback();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:347:1.52", (Object)this);
                        if (!tc.isEventEnabled()) break block35;
                        SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back transaction after preCommit failure!", (Object)exception);
                    }
                }
                this._state = 17;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in preCommit!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw new SIRollbackException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, null), throwable);
            }
        }
        this._state = 13;
        try {
            try {
                if (this._workList != null) {
                    this._persistence.commit(this, true);
                    this._workList.commit(this);
                }
                this._state = 15;
            }
            catch (SeverePersistenceException severePersistenceException) {
                FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:381:1.52", (Object)this);
                if (this._ms != null) {
                    this._ms.reportLocalError();
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Unrecoverable persistence exception caught during commit phase of transaction!", (Object)((Object)severePersistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw new SIResourceException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{severePersistenceException}, null), (Throwable)((Object)severePersistenceException));
            }
            catch (PersistenceException persistenceException) {
                block36: {
                    FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:396:1.52", (Object)this);
                    try {
                        this._workList.rollback(this);
                        this._state = 17;
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:412:1.52", (Object)this);
                        if (!tc.isEventEnabled()) break block36;
                        SibTr.event((TraceComponent)tc, (String)"Exception caught rolling-back WorkList after Commit failure!", (Object)throwable);
                    }
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Transaction rolled-back due to Exception in Commit!", (Object)((Object)persistenceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw new SIRollbackException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{persistenceException}, null), (Throwable)((Object)persistenceException));
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.commit", (String)"1:422:1.52", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Exception caught during commit phase of transaction!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"commit");
                }
                throw new SIErrorException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, null), throwable);
            }
            Object var4_10 = null;
            bl = this._state == 15;
        }
        catch (Throwable throwable) {
            boolean bl3;
            Object var4_11 = null;
            boolean bl2 = bl3 = this._state == 15;
            if (this._workList != null) {
                this._workList.postComplete(this, bl3);
            }
            for (int i = 0; i < this._callbacks.size(); ++i) {
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.afterCompletion(this, bl3);
            }
            if (this._pmi == null) throw throwable;
            if (bl3) {
                this._pmi.increment(35);
                throw throwable;
            }
            this._pmi.increment(34);
            throw throwable;
        }
        boolean bl3 = bl;
        if (this._workList != null) {
            this._workList.postComplete(this, bl3);
        }
        for (int i = 0; i < this._callbacks.size(); ++i) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
            transactionCallback.afterCompletion(this, bl3);
        }
        if (this._pmi != null) {
            if (bl3) {
                this._pmi.increment(35);
            } else {
                this._pmi.increment(34);
            }
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"commit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() throws SIIncorrectCallException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback");
        }
        if (this._state != 10) {
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls.getFormattedMessage("CANNOT_ROLLBACK_COMPLETE_SIMS1005", new Object[0], null));
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot rollback Transaction. Transaction is complete or completing!", (Object)((Object)sIIncorrectCallException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"rollback");
            }
            throw sIIncorrectCallException;
        }
        this._state = 16;
        try {
            try {
                if (this._workList != null) {
                    this._workList.rollback(this);
                }
                this._state = 17;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.rollback", (String)"1:499:1.52", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Exception caught during rollback phase of transaction!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"rollback");
                }
                throw new SIResourceException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, null), throwable);
            }
            Object var3_3 = null;
            if (this._workList != null) {
                this._workList.postComplete(this, false);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (this._workList != null) {
                this._workList.postComplete(this, false);
            }
            for (int i = 0; i < this._callbacks.size(); ++i) {
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.afterCompletion(this, false);
            }
            if (this._pmi != null) {
                this._pmi.increment(34);
            }
            throw throwable;
        }
        for (int i = 0; i < this._callbacks.size(); ++i) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
            transactionCallback.afterCompletion(this, false);
        }
        if (this._pmi != null) {
            this._pmi.increment(34);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"beforeCompletion");
        }
        if (this._state != 10) {
            MessageStoreRuntimeException messageStoreRuntimeException = new MessageStoreRuntimeException(nls.getFormattedMessage("TRAN_PROTOCOL_ERROR_SIMS1001", new Object[0], null));
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Cannot complete Transaction. Transaction is complete or completing!", (Object)((Object)messageStoreRuntimeException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"beforeCompletion");
            }
            throw messageStoreRuntimeException;
        }
        for (int i = 0; i < this._callbacks.size(); ++i) {
            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
            transactionCallback.beforeCompletion(this);
        }
        if (this._workList != null) {
            try {
                this._workList.preCommit(this);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.beforeCompletion", (String)"1:564:1.52", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Throwing exception in beforeCompletion to ensure rollback due to Exception in preCommit!", (Object)throwable);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"beforeCompletion");
                }
                throw new MessageStoreRuntimeException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{throwable}, null), throwable);
            }
        }
        this._state = 13;
        try {
            if (this._workList != null) {
                this._persistence.beforeCompletion(this);
            }
        }
        catch (PersistenceException persistenceException) {
            FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.beforeCompletion", (String)"1:595:1.52", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Rollback-only set on transaction due to PersistenceException in beforeCompletion!", (Object)((Object)persistenceException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"beforeCompletion");
            }
            throw new MessageStoreRuntimeException(nls.getFormattedMessage("COMPLETION_EXCEPTION_SIMS1002", new Object[]{persistenceException}, null), (Throwable)((Object)persistenceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void afterCompletion(int n) {
        block28: {
            boolean bl;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"afterCompletion");
            }
            switch (n) {
                case 3: 
                case 8: {
                    if (this._workList != null) {
                        this._persistence.afterCompletion(this, true);
                        this._workList.commit(this);
                    }
                    this._state = 15;
                    break;
                }
                case 4: 
                case 9: {
                    if (this._workList != null) {
                        this._persistence.afterCompletion(this, false);
                        this._workList.rollback(this);
                    }
                    this._state = 17;
                    break;
                }
                case 5: {
                    SibTr.info((TraceComponent)tc, (String)"TEMPORARY_SIMS9999", (Object)"A heuristic hazard has been detected. The messaging engine will be stopped to avoid data loss.");
                    if (this._ms == null) break;
                    this._ms.reportLocalError();
                }
            }
            Object var4_2 = null;
            boolean bl2 = bl = this._state == 15;
            if (this._workList != null) {
                this._workList.postComplete(this, bl);
            }
            for (int i = 0; i < this._callbacks.size(); ++i) {
                TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                transactionCallback.afterCompletion(this, bl);
            }
            if (this._pmi == null) break block28;
            if (bl) {
                this._pmi.increment(35);
            } else {
                this._pmi.increment(34);
                {
                    break block28;
                    catch (Throwable throwable) {
                        boolean bl3;
                        FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingLocalTransaction.afterCompletion", (String)"1:660:1.52", (Object)this);
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Exception caught completing transaction work list!", (Object)throwable);
                        }
                        Object var4_3 = null;
                        boolean bl4 = bl3 = this._state == 15;
                        if (this._workList != null) {
                            this._workList.postComplete(this, bl3);
                        }
                        for (int i = 0; i < this._callbacks.size(); ++i) {
                            TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                            transactionCallback.afterCompletion(this, bl3);
                        }
                        if (this._pmi != null) {
                            if (bl3) {
                                this._pmi.increment(35);
                            } else {
                                this._pmi.increment(34);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    boolean bl5;
                    Object var4_4 = null;
                    boolean bl6 = bl5 = this._state == 15;
                    if (this._workList != null) {
                        this._workList.postComplete(this, bl5);
                    }
                    for (int i = 0; i < this._callbacks.size(); ++i) {
                        TransactionCallback transactionCallback = (TransactionCallback)this._callbacks.get(i);
                        transactionCallback.afterCompletion(this, bl5);
                    }
                    if (this._pmi != null) {
                        if (bl5) {
                            this._pmi.increment(35);
                        } else {
                            this._pmi.increment(34);
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public final int getTransactionType() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_LOCAL");
        }
        return 1;
    }

    public void setTransactionState(int n) {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("State=");
            switch (n) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.entry((TraceComponent)tc, (String)"setTransactionState", (Object)stringBuffer.toString());
        }
        this._state = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionState");
        }
    }

    public int getTransactionState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionState");
            StringBuffer stringBuffer = new StringBuffer("return=");
            switch (this._state) {
                case 10: {
                    stringBuffer.append("STATE_ACTIVE");
                    break;
                }
                case 11: {
                    stringBuffer.append("STATE_PREPARING");
                    break;
                }
                case 12: {
                    stringBuffer.append("STATE_PREPARED");
                    break;
                }
                case 13: {
                    stringBuffer.append("STATE_COMMITTING_1PC");
                    break;
                }
                case 14: {
                    stringBuffer.append("STATE_COMMITTING_2PC");
                    break;
                }
                case 15: {
                    stringBuffer.append("STATE_COMMITTED");
                    break;
                }
                case 16: {
                    stringBuffer.append("STATE_ROLLINGBACK");
                    break;
                }
                case 17: {
                    stringBuffer.append("STATE_ROLLEDBACK");
                }
            }
            SibTr.exit((TraceComponent)tc, (String)"getTransactionState", (Object)stringBuffer.toString());
        }
        return this._state;
    }

    public BatchingContext getBatchingContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    public void setBatchingContext(BatchingContext batchingContext) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + batchingContext));
        }
        this._bc = batchingContext;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setBatchingContext");
        }
    }
}

