/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.FormatBuffer;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.Operation;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.WorkItem;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class Task
implements Operation,
WorkItem {
    private static TraceComponent tc = SibTr.register((Class)Task.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final int DEFAULT_TASK_PERSISTABLE_SIZE_APPROXIMATION = 500;
    private final AbstractItemLink _link;
    private AbstractItem _item = null;
    Task _nextTask = null;

    protected final AbstractItem getItem() {
        if (null == this._item) {
            this._item = this._link.getItem();
            if (null == this._item && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        }
        return this._item;
    }

    public Task(AbstractItemLink abstractItemLink) {
        this._link = abstractItemLink;
        if (this._link != null) {
            this.getItem();
        }
    }

    public abstract void abort(Transaction var1);

    public abstract void commitExternal(Transaction var1);

    public abstract void commitInternal(Transaction var1);

    public void copyDataIfVulnerable() throws PersistentDataEncodingException {
    }

    public void ensureDataAvailable() throws PersistentDataEncodingException {
        this.copyDataIfVulnerable();
    }

    public final AbstractItemLink getLink() {
        return this._link;
    }

    public Persistable getPersistable() {
        return this._link.getTuple();
    }

    final int getStorageStrategy() {
        return this.getPersistable().getStorageStrategy();
    }

    public Type getTaskType() {
        return Type.UNKNOWN;
    }

    public boolean isCreateOfPersistentRepresentation() {
        return false;
    }

    public boolean isDeleteOfPersistentRepresentation() {
        return false;
    }

    public boolean isRemoveFromList(LinkOwner linkOwner) {
        return false;
    }

    public abstract void postAbort(Transaction var1);

    public abstract void postCommit(Transaction var1);

    public abstract void preCommit(Transaction var1);

    public void printOn(FormatBuffer formatBuffer) {
        formatBuffer.append("Task");
    }

    public String toString() {
        if (this.getPersistable() == null) {
            return "[" + this.getTaskType() + "]";
        }
        return "[" + this.getTaskType() + ":" + this.getPersistable().getUniqueId() + "]";
    }

    public static final class Type {
        public static final Type ADD = new Type("Add");
        public static final Type PERSIST_LOCK = new Type("PLo");
        public static final Type PERSIST_UNLOCK = new Type("PUn");
        public static final Type REMOVE = new Type("Rmv");
        public static final Type REMOVE_LOCKED = new Type("RmL");
        public static final Type UNKNOWN = new Type("???");
        public static final Type UPDATE = new Type("Upd");
        private String _name;

        private Type(String string) {
            this._name = string;
        }

        public String toString() {
            return this._name;
        }
    }
}

