/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.lock;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.utils.ras.SibTr;

public class DBLockTimeouts {
    private static TraceComponent tc = SibTr.register((Class)DBLockTimeouts.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _lockWaitTimeout;
    private long _keepAliveWait;

    public DBLockTimeouts(MessageStoreImpl messageStoreImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DBLockTimeouts", (Object)("MS=" + messageStoreImpl));
        }
        if (messageStoreImpl != null) {
            String string = messageStoreImpl.getProperty("jdbcDataStoreLockPatienceDelay", "5000");
            this._lockWaitTimeout = Integer.parseInt(string);
            String string2 = messageStoreImpl.getProperty("jdbcDataStoreLockRefreshDelay", "20000");
            this._keepAliveWait = Integer.parseInt(string2);
        } else {
            this._lockWaitTimeout = Integer.parseInt("5000");
            this._keepAliveWait = Integer.parseInt("20000");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("LOCK_WAIT_TIMEOUT=" + this._lockWaitTimeout));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("KEEP_ALIVE_WAIT=" + this._keepAliveWait));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DBLockTimeouts");
        }
    }

    public long getLockWaitTimeout() {
        return this._lockWaitTimeout;
    }

    public long getKeepAliveWait() {
        return this._keepAliveWait;
    }
}

