/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.lock;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.MEOwnerTable;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockOwner;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockTimeouts;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockingDatasource;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockingThread;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Date;

public class DBLockManagerThread
extends Thread {
    private static TraceComponent tc = SibTr.register((Class)DBLockManagerThread.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private DBLockingThread _lockingThread;
    private DBLockTimeouts _timeouts;
    private DBLockingDatasource _datasource;
    private DBLockOwner _lockOwner;
    private MEOwnerTable _meTable;
    private MessageStoreImpl _ms;
    private JsMessagingEngine _me;
    private boolean _keepTrying = true;

    public DBLockManagerThread(MessageStoreImpl messageStoreImpl, DBLockingDatasource dBLockingDatasource, MEOwnerTable mEOwnerTable, DBLockTimeouts dBLockTimeouts) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DBLockManagerThread", (Object)("MS=" + messageStoreImpl + ", Datasource=" + dBLockingDatasource + ", METable=" + mEOwnerTable));
        }
        this._ms = messageStoreImpl;
        this._me = messageStoreImpl._getMessagingEngine();
        this._datasource = dBLockingDatasource;
        this._meTable = mEOwnerTable;
        this._timeouts = dBLockTimeouts;
        this._lockOwner = this._me != null ? new DBLockOwner(this._me.getUuid().toString(), this.generateIncUuid(), 1, 0) : new DBLockOwner("sib.LockThread", this.generateIncUuid(), 1, 0);
        this.setName("sib.LockManagerThread");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DBLockManagerThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this._me != null) {
            SibTr.push((Object)this._me);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"run");
        }
        String string = this._me == null ? "default" : this._me.getName();
        SibTr.info((TraceComponent)tc, (String)"DBLOCK_ATTEMPTING_SIMS1538", (Object)new Object[]{this._lockOwner.getMeUUID(), this._lockOwner.getIncUUID()});
        this._lockingThread = new DBLockingThread(this._me, this._datasource, this._meTable, this._timeouts, this._lockOwner, false);
        this._lockingThread.start();
        boolean bl = true;
        while (this._keepTrying && bl) {
            try {
                DBLockingThread dBLockingThread = this._lockingThread;
                synchronized (dBLockingThread) {
                    this._lockingThread.wait(this._timeouts.getLockWaitTimeout());
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this._lockingThread.isLockAquired()) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"MessageStore unable to obtain DB lock!");
                }
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_NOT_HELD_SIMS1546", (Object)new Object[]{this._lockOwner.getMeUUID(), this._lockOwner.getIncUUID()});
                this._datasource.disable();
                if (this._lockingThread.hasCheckedDataStore()) {
                    bl = false;
                    this._ms.reportGlobalError();
                    ((DatasourceWrapper)((Object)this._datasource)).stop(0);
                    this._lockingThread.stopTrying();
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"MessageStore lost lock to another instance!");
                    }
                    SibTr.info((TraceComponent)tc, (String)"CANNOT_OBTAIN_DATA_STORE_LOCK_SIMS1519", (Object)new Object[]{string});
                    continue;
                }
                bl = true;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"MessageStore will retry the attempt to obtain DB lock!");
                }
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_ATTEMPTING_SIMS1538", (Object)new Object[]{this._lockOwner.getMeUUID(), this._lockOwner.getIncUUID()});
                continue;
            }
            SibTr.info((TraceComponent)tc, (String)"DBLOCK_ACQUIRED_SIMS1537", (Object)new Object[]{this._lockOwner.getMeUUID(), this._lockOwner.getIncUUID()});
            this._datasource.enable();
            boolean bl2 = true;
            while (this._keepTrying && bl2) {
                try {
                    DBLockManagerThread dBLockManagerThread = this;
                    synchronized (dBLockManagerThread) {
                        this.wait(this._timeouts.getKeepAliveWait());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._lockingThread.isLockAquired()) continue;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"MessageStore lost DB lock!");
                }
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_NOT_HELD_SIMS1546", (Object)new Object[]{this._lockOwner.getMeUUID(), this._lockOwner.getIncUUID()});
                this._datasource.disable();
                bl2 = false;
                if (this._lockingThread.hasCheckedDataStore()) {
                    bl = false;
                    this._ms.reportGlobalError();
                    ((DatasourceWrapper)((Object)this._datasource)).stop(0);
                    this._lockingThread.stopTrying();
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"MessageStore unable to regain DB lock!");
                    }
                    SibTr.info((TraceComponent)tc, (String)"CANNOT_OBTAIN_DATA_STORE_LOCK_SIMS1519", (Object)new Object[]{string});
                    continue;
                }
                bl = true;
                this._lockingThread.stopTrying();
                this._lockingThread = new DBLockingThread(this._me, this._datasource, this._meTable, this._timeouts, this._lockOwner, true);
                this._lockingThread.start();
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"MessageStore will attempt to regain DB lock!");
                }
                SibTr.info((TraceComponent)tc, (String)"DBLOCK_ATTEMPTING_SIMS1538", (Object)new Object[]{this._lockOwner.getMeUUID(), this._lockOwner.getIncUUID()});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"run");
        }
        if (this._me != null) {
            SibTr.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTrying() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopTrying");
        }
        this._keepTrying = false;
        if (this._lockingThread != null) {
            this._lockingThread.stopTrying();
        }
        DBLockManagerThread dBLockManagerThread = this;
        synchronized (dBLockManagerThread) {
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopTrying");
        }
    }

    private String generateIncUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateIncUuid");
        }
        Date date = new Date();
        int n = this.hashCode();
        long l = date.getTime();
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n, (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(string.charAt(byArray[i] >> 4 & 0xF));
            stringBuffer.append(string.charAt(byArray[i] & 0xF));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateIncUuid", (Object)("return=" + stringBuffer));
        }
        return stringBuffer.toString();
    }
}

