/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import java.util.IdentityHashMap;
import java.util.Map;

public class TransactionsTableHelper {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String XID = "XID";
    public static final String STATE = "STATE";
    private static final Map DEFAULT = new IdentityHashMap();
    private static final Map SYSTEMS = new IdentityHashMap();

    private TransactionsTableHelper() {
    }

    public static Map getReferenceInfo(String string) {
        return (Map)SYSTEMS.get(string);
    }

    public static String[] getCreateTableSql(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string6 == "db2j" || string6 == "Derby") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " VARCHAR(254) NOT NULL, " + STATE + " CHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") )"};
        }
        if (string6 == "DB2" || string6 == "DB2iSeries") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " VARCHAR(254) NOT NULL, " + STATE + " CHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") )"};
        }
        if (string6 == "Oracle" || string6 == "Oracle8i") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " VARCHAR2(254) NOT NULL, " + STATE + " CHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") )"};
        }
        if (string6 == "MS SQL Server") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " NVARCHAR(254) NOT NULL, " + STATE + " NCHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") )"};
        }
        if (string6 == "Informix" || string6 == "Informix_73") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " VARCHAR(254) NOT NULL, " + STATE + " CHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") ) LOCK MODE ROW"};
        }
        if (string6 == "Sybase") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " NVARCHAR(254) NOT NULL, " + STATE + " NCHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") )"};
        }
        if (string6 == "DB2390") {
            return new String[]{"CREATE TABLESPACE XACTSTS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 6400 SECQTY 640 ERASE NO PCTFREE 20 SEGSIZE 32 BUFFERPOOL " + string3 + " LOCKSIZE ROW CLOSE NO", "CREATE TABLE " + string4 + "." + string5 + " ( " + XID + " VARCHAR(254) NOT NULL, " + STATE + " CHAR(1) NOT NULL, PRIMARY KEY(" + XID + ") ) IN " + string + ".XACTSTS", "CREATE UNIQUE INDEX " + string4 + "." + string5 + " ON " + string4 + "." + string5 + "(" + XID + ") USING STOGROUP " + string2 + " PRIQTY 200 SECQTY 20"};
        }
        if (string6 == "Dummy") {
            return new String[0];
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string6}, null));
    }

    public static String[] getDropTableSql(String string, String string2, String string3, String string4) {
        if (string4 == "DB2390") {
            return new String[]{"DROP TABLE " + string2 + "." + string3, "DROP TABLESPACE " + string + ".XACTSTS"};
        }
        return new String[]{"DROP TABLE " + string2 + "." + string3};
    }

    public static String getInsertSql(String string, String string2) {
        return "INSERT INTO " + string + "." + string2 + " (" + XID + "," + STATE + ") VALUES (?,?)";
    }

    public static String getUpdateSql(String string, String string2) {
        return "UPDATE " + string + "." + string2 + " SET " + STATE + "=? WHERE " + XID + "=?";
    }

    public static String getDeleteSql(String string, String string2) {
        return "DELETE FROM " + string + "." + string2 + " WHERE " + XID + "=?";
    }

    public static String getQuerySql(String string, String string2) {
        return "SELECT XID FROM " + string + "." + string2 + " WHERE " + STATE + "=?";
    }

    public static String getGrantSql(String string, String string2, String string3) {
        return "GRANT SELECT,INSERT,UPDATE,DELETE ON " + string + "." + string2 + " TO " + string3;
    }

    static {
        DEFAULT.put(XID, TableHelper.VARCHAR);
        DEFAULT.put(STATE, TableHelper.CHAR);
        SYSTEMS.put("DB2", DEFAULT);
        SYSTEMS.put("DB2iSeries", DEFAULT);
        SYSTEMS.put("DB2390", DEFAULT);
        SYSTEMS.put("db2j", DEFAULT);
        SYSTEMS.put("Derby", DEFAULT);
        SYSTEMS.put("Oracle", DEFAULT);
        SYSTEMS.put("Oracle8i", DEFAULT);
        SYSTEMS.put("MS SQL Server", DEFAULT);
        SYSTEMS.put("Informix", DEFAULT);
        SYSTEMS.put("Informix_73", DEFAULT);
        SYSTEMS.put("Sybase", DEFAULT);
    }
}

