/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.DatabaseMetaDataExtensions;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Table {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)Table.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final String[] TABLE_TYPES = new String[]{"TABLE"};
    protected static final int BATCH_SIZE_LOWER_LIMIT = 1;
    protected static final String ALL_COLUMNS_PATTERN = "%";
    protected final String databaseName = "SIBDB";
    protected final String stogroupName = "SIBSG";
    protected final String bufpoolName = "BP1";
    protected final String tableName;
    protected DatabaseMetaDataExtensions metadata;
    protected String schemaName;
    protected boolean jdbcBatchesAreSupported;

    protected Table(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{string, string2});
        }
        this.tableName = string2;
        this.schemaName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialize(ConnectionWrapper connectionWrapper, boolean bl, boolean bl2) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)new Object[]{connectionWrapper, new Boolean(bl), new Boolean(bl2)});
        }
        this.metadata = connectionWrapper.getMetaDataExtensions();
        this.jdbcBatchesAreSupported = this.metadata.supportsJdbcBatches();
        if (this.metadata.getDBMS() == "DB2390" && bl) {
            throw new IllegalStateException(nls.getString("DYNAMIC_TABLE_CREATION_EXCEPTION_SIMS1523"));
        }
        if (this.metadata.storesUpperCaseIdentifiers()) {
            this.schemaName = this.schemaName.toUpperCase();
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Schema name upper cased: " + this.schemaName));
            }
        }
        if (this.metadata.creatingTablesWillCreateSchema() || this.schemaExists()) {
            if (this.tableExists()) {
                if (bl2) {
                    this.dropTable(connectionWrapper);
                    this.createTablesAndIndexes(connectionWrapper);
                }
            } else {
                if (!bl) throw new IllegalStateException(nls.getFormattedMessage("MISSING_TABLE_EXCEPTION_SIMS1532", new Object[]{this.schemaName + "." + this.tableName}, null));
                this.createTablesAndIndexes(connectionWrapper);
            }
        } else {
            if (!bl || !this.metadata.createSchemaIsAllowed()) throw new IllegalStateException(nls.getFormattedMessage("MISSING_SCHEMA_EXCEPTION_SIMS1533", new Object[]{this.schemaName}, null));
            this.createSchema(connectionWrapper);
            this.createTablesAndIndexes(connectionWrapper);
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
    }

    protected abstract void createTablesAndIndexes(ConnectionWrapper var1) throws SQLException;

    protected abstract void dropTable(ConnectionWrapper var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTablesAndIndexes(ConnectionWrapper connectionWrapper, String[] stringArray) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTablesAndIndexes", (Object)new Object[]{connectionWrapper, stringArray});
        }
        Statement statement = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                statement = connectionWrapper.createStatement();
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)stringArray[i]);
                }
                statement.executeUpdate(stringArray[i]);
                continue;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTablesAndIndexes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTable(ConnectionWrapper connectionWrapper, String[] stringArray) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dropTable", (Object)new Object[]{connectionWrapper, stringArray});
        }
        Statement statement = null;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                statement = connectionWrapper.createStatement();
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)stringArray[i]);
                }
                statement.executeUpdate(stringArray[i]);
                continue;
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dropTable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performColumnChecks(Map map) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"performColumnChecks", (Object)new Object[]{map});
        }
        ResultSet resultSet = null;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            resultSet = this.metadata.getColumns(null, this.schemaName, this.tableName, ALL_COLUMNS_PATTERN);
            while (resultSet.next()) {
                String string = resultSet.getString(4);
                int n = resultSet.getInt(5);
                string = string.toUpperCase().trim();
                hashMap.put(string, new Integer(n));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        this.compareColumnInfo(map, hashMap);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"performColumnChecks");
        }
    }

    protected void compareColumnInfo(Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"compareColumnInfo", (Object)new Object[]{map, map2});
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map2.containsKey(string)) {
                Integer[] integerArray;
                Object v = map.get(string);
                Integer n = (Integer)map2.get(string);
                if (v instanceof Integer) {
                    integerArray = (Integer[])v;
                    if (integerArray.equals(n)) continue;
                    throw new IllegalStateException(nls.getFormattedMessage("EXPECTED_DATA_TYPE_NOT_FOUND_SIMS1530", new Object[]{n, integerArray, string, this.schemaName + "." + this.tableName}, null));
                }
                integerArray = (Integer[])v;
                int n2 = integerArray.length;
                boolean bl = false;
                for (int i = 0; i < n2; ++i) {
                    Integer n3 = integerArray[i];
                    if (!n3.equals(n)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new IllegalStateException(nls.getFormattedMessage("EXPECTED_DATA_TYPE_NOT_FOUND_SIMS1530", new Object[]{n, integerArray, string, this.schemaName + "." + this.tableName}, null));
            }
            throw new IllegalStateException(nls.getFormattedMessage("EXPECTED_COLUMN_NOT_FOUND_SIMS1529", new Object[]{string, this.schemaName + "." + this.tableName}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"compareColumnInfo");
        }
    }

    protected int getNumberOfRows(ResultSet resultSet) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNumberOfRows", (Object)new Object[]{resultSet});
        }
        int n = 0;
        if (this.metadata.supportsScrollableResultSet()) {
            resultSet.last();
            n = resultSet.getRow();
            resultSet.beforeFirst();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNumberOfRows", (Object)new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schemaExists() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"schemaExists");
        }
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            resultSet = this.metadata.getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getString(1).equalsIgnoreCase(this.schemaName)) continue;
                bl = true;
                break;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"schemaExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"tableExists");
        }
        boolean bl = false;
        ResultSet resultSet = null;
        try {
            resultSet = this.metadata.getTables(null, this.schemaName, this.tableName, TABLE_TYPES);
            if (resultSet.next()) {
                bl = true;
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"tableExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStogroup(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createStogroup", (Object)new Object[]{connectionWrapper});
        }
        String string = TableHelper.getCreateStogroupSQL("SIBSG");
        Statement statement = null;
        try {
            statement = connectionWrapper.createStatement();
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)string);
            }
            statement.executeUpdate(string);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createStogroup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabase(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createDatabase", (Object)new Object[]{connectionWrapper});
        }
        String string = TableHelper.getCreateDatabaseSQL("SIBDB", "SIBSG", "BP1");
        Statement statement = null;
        try {
            statement = connectionWrapper.createStatement();
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)string);
            }
            statement.executeUpdate(string);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createDatabase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createSchema", (Object)new Object[]{connectionWrapper});
        }
        String string = TableHelper.getCreateSchemaSQL(this.schemaName);
        Statement statement = null;
        try {
            statement = connectionWrapper.createStatement();
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)string);
            }
            statement.executeUpdate(string);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createSchema");
        }
    }
}

