/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.cache.links.RootMembership;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.Operation;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.PersistentMessageStore;
import com.ibm.ws.sib.msgstore.persistence.RangeManager;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.UniqueKeyGenerator;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.PersistentDispatcher;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.SpillDispatcher;
import com.ibm.ws.sib.msgstore.persistence.impl.BatchingContextFactoryImpl;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.DatasourceController;
import com.ibm.ws.sib.msgstore.persistence.impl.RetryableAction;
import com.ibm.ws.sib.msgstore.persistence.impl.TableManager;
import com.ibm.ws.sib.msgstore.persistence.impl.Token;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.persistence.impl.UniqueKeyGeneratorImpl;
import com.ibm.ws.sib.msgstore.task.TaskList;
import com.ibm.ws.sib.msgstore.transactions.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PersistentMessageStoreImpl
implements PersistentMessageStore,
PersistenceManager,
RangeManager {
    private static TraceComponent tc = SibTr.register((Class)PersistentMessageStoreImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private DatasourceController controller;
    private TableManager tableManager;
    private SpillDispatcher spillDispatcher;
    private PersistentDispatcher persistentDispatcher;
    private BatchingContextFactory batchingContextFactory;
    private boolean upgradeStoreEventuallyToStoreAlways;

    public PersistentMessageStoreImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>");
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public void initialize(MessageStoreImpl messageStoreImpl, XidManager xidManager, Configuration configuration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize", (Object)new Object[]{messageStoreImpl, xidManager, configuration});
        }
        this.controller = new DatasourceController(messageStoreImpl, configuration);
        this.tableManager = new TableManager(messageStoreImpl, this.controller, configuration, xidManager);
        this.batchingContextFactory = new BatchingContextFactoryImpl(messageStoreImpl, this.tableManager, this.controller);
        this.spillDispatcher = new SpillDispatcher(messageStoreImpl, this.batchingContextFactory);
        this.persistentDispatcher = new PersistentDispatcher(messageStoreImpl, this.batchingContextFactory);
        String string = messageStoreImpl.getProperty("upgradeReliablePersistentToAssured", "false");
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("upgradeReliablePersistentToAssured=" + string));
        }
        this.upgradeStoreEventuallyToStoreAlways = Boolean.valueOf(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize", (Object)this);
        }
    }

    public void start() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            this.tableManager.initialize();
            this.spillDispatcher.start();
            this.persistentDispatcher.start();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.start", (String)"1:186:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop", (Object)new Object[]{new Integer(n)});
        }
        this.spillDispatcher.stop(n);
        this.persistentDispatcher.stop(n);
        this.tableManager.stop(n);
        this.controller.stop(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public byte[] readDataOnly(final Persistable persistable) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readDataOnly", (Object)new Object[]{persistable});
        }
        byte[] byArray = null;
        try {
            byArray = (byte[])this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    byte[] byArray = PersistentMessageStoreImpl.this.tableManager.readDataOnly(connectionWrapper, (Tuple)persistable);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)byArray);
                    }
                    return byArray;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.readDataOnly", (String)"1:245:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readDataOnly", (Object)byArray);
        }
        return byArray;
    }

    public List readNonStreamItems(final Persistable persistable) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readNonStreamItems", (Object)new Object[]{persistable});
        }
        List list = null;
        try {
            list = (List)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    List list = PersistentMessageStoreImpl.this.tableManager.readNonStreamItems(connectionWrapper, (Tuple)persistable);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)list);
                    }
                    return list;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.readNonStreamItems", (String)"1:285:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readNonStreamItems", (Object)list);
        }
        return list;
    }

    public Set identifyStreamsWithExpirableItems() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"identifyStreamsExpirableItems");
        }
        Set set = null;
        try {
            set = (Set)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    Set set = PersistentMessageStoreImpl.this.tableManager.identifyStreamsWithExpirableItems(connectionWrapper);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)set);
                    }
                    return set;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.processExpiredItems", (String)"1:325:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"identifyStreamsWithExpirableItems", (Object)set);
        }
        return set;
    }

    public List readIndoubtXIDs() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readIndoubtXIDs");
        }
        List list = null;
        try {
            list = (List)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    List list = PersistentMessageStoreImpl.this.tableManager.readAllIndoubts(connectionWrapper);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)list);
                    }
                    return list;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.readIndoubtXIDs", (String)"1:365:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readIndoubtXIDs", (Object)list);
        }
        return list;
    }

    public Set identifyStreamsWithIndoubtItems() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems");
        }
        Set set = null;
        try {
            set = (Set)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    Set set = PersistentMessageStoreImpl.this.tableManager.identifyStreamsWithIndoubtItems(connectionWrapper);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)set);
                    }
                    return set;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.readStreamsWithIndoubtItems", (String)"1:405:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems", (Object)set);
        }
        return set;
    }

    public List readAllStreams() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readAllStreams");
        }
        List list = null;
        try {
            list = (List)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    List list = PersistentMessageStoreImpl.this.tableManager.readAllStreams(connectionWrapper);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)list);
                    }
                    return list;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.readAllStreams", (String)"1:445:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readAllStreams", (Object)list);
        }
        return list;
    }

    public Persistable readRootPersistable() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readRootPersistable");
        }
        Tuple tuple = null;
        try {
            tuple = (Tuple)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    Tuple tuple = PersistentMessageStoreImpl.this.tableManager.readRootPersistable(connectionWrapper, -2L, -3L);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)tuple);
                    }
                    return tuple;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.readRootPersistable", (String)"1:485:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tuple == null) {
            tuple = new Token(-2L, -3L, TupleTypeEnum.ROOT);
            tuple.setStorageStrategy(4);
            tuple.setItemClassName(RootMembership.class.getName());
            BatchingContext batchingContext = this.batchingContextFactory.createBatchingContext();
            batchingContext.insert(tuple);
            batchingContext.executeBatch();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readRootPersistable", (Object)tuple);
        }
        return tuple;
    }

    public void prepare(PersistentTransaction persistentTransaction) throws PersistenceException {
        Tuple tuple;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepare", (Object)new Object[]{persistentTransaction});
        }
        TaskList taskList = (TaskList)persistentTransaction.getWorkList();
        PersistentTranId persistentTranId = persistentTransaction.getPersistentTranId();
        int n = persistentTransaction.getTransactionState();
        int n2 = taskList.countLinks();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = taskList.hasStoreMaybe();
        BatchingContext batchingContext = null;
        ArrayList<Tuple> arrayList = null;
        ArrayList<Operation> arrayList2 = null;
        if (taskList.hasStoreAlways() || taskList.hasStoreEventually()) {
            batchingContext = this.batchingContextFactory.getBatchingContext(persistentTransaction, n2);
            object = taskList.iterator();
            while (object.hasNext()) {
                Operation operation = (Operation)object.next();
                tuple = (Tuple)operation.getPersistable();
                if (!tuple.requiresPersistence()) continue;
                int n3 = tuple.getStorageStrategy();
                if (n3 == 4 || this.upgradeStoreEventuallyToStoreAlways && n3 == 3) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Tuple>(n2);
                        bl = true;
                    }
                    tuple.setPersistentTranId(persistentTranId);
                    operation.persist(batchingContext, n);
                    arrayList.add(tuple);
                    continue;
                }
                if (this.upgradeStoreEventuallyToStoreAlways || n3 != 3) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Operation>(n2);
                    bl2 = true;
                }
                tuple.setPersistentTranId(persistentTranId);
                arrayList2.add(operation);
            }
        }
        if (bl2 && bl && !this.persistentDispatcher.isFullOfHealth()) {
            object = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
            if (tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The persistent dispatcher cannot accept work.", (Object)object);
            }
            throw object;
        }
        if (bl3 && !this.spillDispatcher.isFullOfHealth()) {
            object = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
            if (tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The spill dispatcher cannot accept work.", (Object)object);
            }
            throw object;
        }
        if (bl || bl2) {
            batchingContext.addIndoubtXID(persistentTranId);
            batchingContext.executeBatch();
            if (bl) {
                int n4 = arrayList.size();
                for (int i = 0; i < n4; ++i) {
                    tuple = (Tuple)arrayList.get(i);
                    tuple.persistableOperationBegun();
                    tuple.persistableOperationCompleted();
                }
            }
            if (bl2) {
                this.persistentDispatcher.dispatch(arrayList2, persistentTransaction, !bl);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepare");
        }
    }

    public void rollback(PersistentTransaction persistentTransaction) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback", (Object)new Object[]{persistentTransaction});
        }
        TaskList taskList = (TaskList)persistentTransaction.getWorkList();
        PersistentTranId persistentTranId = persistentTransaction.getPersistentTranId();
        boolean bl = false;
        boolean bl2 = false;
        BatchingContext batchingContext = null;
        ArrayList<Operation> arrayList = null;
        int n = persistentTransaction.getTransactionState();
        int n2 = taskList.countLinks();
        if (taskList.hasStoreAlways() || taskList.hasStoreEventually()) {
            batchingContext = this.batchingContextFactory.getBatchingContext(persistentTransaction, n2);
            Iterator iterator = taskList.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                Tuple tuple = (Tuple)operation.getPersistable();
                if (!tuple.requiresPersistence()) continue;
                int n3 = tuple.getStorageStrategy();
                if (n3 == 4 || this.upgradeStoreEventuallyToStoreAlways && n3 == 3) {
                    bl = true;
                    tuple.setPersistentTranId(null);
                    operation.persist(batchingContext, n);
                    continue;
                }
                if (this.upgradeStoreEventuallyToStoreAlways || n3 != 3) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Operation>(n2);
                    bl2 = true;
                }
                tuple.setPersistentTranId(null);
                arrayList.add(operation);
            }
        }
        if (bl || bl2) {
            if (bl2) {
                batchingContext.updateXIDToRolledback(persistentTranId);
            } else {
                batchingContext.deleteXID(persistentTranId);
            }
            batchingContext.executeBatch();
            if (bl2) {
                this.persistentDispatcher.dispatch(arrayList, persistentTransaction, false);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    public void commit(PersistentTransaction persistentTransaction, boolean bl) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit", (Object)new Object[]{persistentTransaction, new Boolean(bl)});
        }
        TaskList taskList = (TaskList)persistentTransaction.getWorkList();
        int n = persistentTransaction.getTransactionState();
        int n2 = taskList.countLinks();
        ArrayList<Operation> arrayList = null;
        ArrayList<Object> arrayList2 = null;
        BatchingContext batchingContext = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl) {
            Object object;
            ArrayList<Tuple> arrayList3 = null;
            Iterator iterator = taskList.iterator();
            while (iterator.hasNext()) {
                object = (Operation)iterator.next();
                Tuple tuple = (Tuple)object.getPersistable();
                if (!tuple.requiresPersistence()) continue;
                int n3 = tuple.getStorageStrategy();
                if (n3 == 4 || this.upgradeStoreEventuallyToStoreAlways && n3 == 3) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Tuple>(n2);
                        bl2 = true;
                        batchingContext = this.batchingContextFactory.getBatchingContext(persistentTransaction, n2);
                    }
                    object.persist(batchingContext, n);
                    arrayList3.add(tuple);
                    continue;
                }
                if (!this.upgradeStoreEventuallyToStoreAlways && n3 == 3) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(n2);
                        bl3 = true;
                    }
                    arrayList.add((Operation)object);
                    continue;
                }
                if (n3 != 2) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList(n2);
                    bl4 = true;
                }
                arrayList2.add(object);
            }
            if (bl4 && !this.spillDispatcher.isFullOfHealth()) {
                object = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
                if (tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"The spill dispatcher cannot accept work.", (Object)object);
                }
                throw object;
            }
            if (bl2) {
                if (bl3 && !this.persistentDispatcher.isFullOfHealth()) {
                    object = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
                    if (tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)"The persistent dispatcher cannot accept work.", (Object)object);
                    }
                    throw object;
                }
                batchingContext.executeBatch();
                int n4 = arrayList3.size();
                for (int i = 0; i < n4; ++i) {
                    Tuple tuple = (Tuple)arrayList3.get(i);
                    tuple.persistableOperationBegun();
                    tuple.persistableOperationCompleted();
                }
            }
            if (bl3) {
                this.persistentDispatcher.dispatch(arrayList, persistentTransaction, !bl2);
            }
        } else {
            PersistentTranId persistentTranId = persistentTransaction.getPersistentTranId();
            Iterator iterator = taskList.iterator();
            while (iterator.hasNext()) {
                Operation operation = (Operation)iterator.next();
                Tuple tuple = (Tuple)operation.getPersistable();
                if (!tuple.requiresPersistence()) continue;
                int n5 = tuple.getStorageStrategy();
                if (!(this.upgradeStoreEventuallyToStoreAlways || n5 != 4 && n5 != 3)) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Operation>(n2);
                        bl3 = true;
                    }
                    if (batchingContext == null) {
                        batchingContext = this.batchingContextFactory.getBatchingContext(persistentTransaction, n2);
                    }
                    arrayList.add(operation);
                    continue;
                }
                if (this.upgradeStoreEventuallyToStoreAlways && (n5 == 4 || n5 == 3)) {
                    bl2 = true;
                    if (batchingContext == null) {
                        batchingContext = this.batchingContextFactory.getBatchingContext(persistentTransaction, n2);
                    }
                    operation.persist(batchingContext, n);
                    continue;
                }
                if (n5 != 2) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Object>(n2);
                    bl4 = true;
                }
                arrayList2.add(operation);
            }
            if (bl3) {
                batchingContext.updateXIDToCommitted(persistentTranId);
                batchingContext.executeBatch();
                this.persistentDispatcher.dispatch(arrayList, persistentTransaction, false);
            } else if (bl2) {
                batchingContext.deleteXID(persistentTranId);
                batchingContext.executeBatch();
            }
        }
        if (bl4) {
            this.spillDispatcher.dispatch(arrayList2, persistentTransaction, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    public void beforeCompletion(PersistentTransaction persistentTransaction) throws PersistenceException {
        Tuple tuple;
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"beforeCompletion", (Object)new Object[]{persistentTransaction});
        }
        TaskList taskList = (TaskList)persistentTransaction.getWorkList();
        int n = persistentTransaction.getTransactionState();
        int n2 = taskList.countLinks();
        ArrayList<Tuple> arrayList = null;
        BatchingContext batchingContext = null;
        boolean bl = false;
        boolean bl2 = !this.upgradeStoreEventuallyToStoreAlways && taskList.hasStoreEventually();
        boolean bl3 = taskList.hasStoreMaybe();
        if (taskList.hasStoreAlways() || this.upgradeStoreEventuallyToStoreAlways && taskList.hasStoreEventually()) {
            object = taskList.iterator();
            while (object.hasNext()) {
                int n3;
                Operation operation = (Operation)object.next();
                tuple = (Tuple)operation.getPersistable();
                if (!tuple.requiresPersistence() || (n3 = tuple.getStorageStrategy()) != 4 && (!this.upgradeStoreEventuallyToStoreAlways || n3 != 3)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Tuple>(n2);
                    bl = true;
                    batchingContext = this.batchingContextFactory.getBatchingContext(persistentTransaction, n2, true);
                }
                operation.persist(batchingContext, n);
                arrayList.add(tuple);
            }
        }
        if (bl2 && !this.persistentDispatcher.isFullOfHealth()) {
            object = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
            if (tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The persistent dispatcher cannot accept work.", (Object)object);
            }
            throw object;
        }
        if (bl3 && !this.spillDispatcher.isFullOfHealth()) {
            object = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
            if (tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The spill dispatcher cannot accept work.", (Object)object);
            }
            throw object;
        }
        if (bl) {
            batchingContext.executeBatch();
            int n4 = arrayList.size();
            for (int i = 0; i < n4; ++i) {
                tuple = (Tuple)arrayList.get(i);
                tuple.persistableOperationBegun();
                tuple.persistableOperationCompleted();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    public void afterCompletion(PersistentTransaction persistentTransaction, boolean bl) {
        block12: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)new Object[]{persistentTransaction, new Boolean(bl)});
            }
            if (bl) {
                TaskList taskList = (TaskList)persistentTransaction.getWorkList();
                if (!this.upgradeStoreEventuallyToStoreAlways && taskList.hasStoreEventually() || taskList.hasStoreMaybe()) {
                    int n = taskList.countLinks();
                    ArrayList<Operation> arrayList = null;
                    ArrayList<Operation> arrayList2 = null;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Iterator iterator = taskList.iterator();
                    while (iterator.hasNext()) {
                        Operation operation = (Operation)iterator.next();
                        Tuple tuple = (Tuple)operation.getPersistable();
                        if (!tuple.requiresPersistence()) continue;
                        int n2 = tuple.getStorageStrategy();
                        if (!this.upgradeStoreEventuallyToStoreAlways && n2 == 3) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Operation>(n);
                                bl3 = true;
                            }
                            arrayList.add(operation);
                            continue;
                        }
                        if (n2 != 2) continue;
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<Operation>(n);
                            bl2 = true;
                        }
                        arrayList2.add(operation);
                    }
                    try {
                        if (bl3) {
                            this.persistentDispatcher.dispatch(arrayList, persistentTransaction, false);
                        }
                        if (bl2) {
                            this.spillDispatcher.dispatch(arrayList2, persistentTransaction, false);
                        }
                    }
                    catch (PersistenceException persistenceException) {
                        FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.afterCompletion", (String)"1:1129:1.47.2.2", (Object)this);
                        if (!tc.isEventEnabled()) break block12;
                        SibTr.event((TraceComponent)tc, (String)"Exception thrown during after completion", (Object)((Object)persistenceException));
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public void scheduleUpdate(UniqueKeyGenerator uniqueKeyGenerator) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"scheduleUpdate", (Object)new Object[]{uniqueKeyGenerator});
        }
        this.tableManager.scheduleUpdate((UniqueKeyGeneratorImpl)uniqueKeyGenerator);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleUpdate");
        }
    }

    public boolean entryExists(UniqueKeyGenerator uniqueKeyGenerator) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"entryExists", (Object)new Object[]{uniqueKeyGenerator});
        }
        boolean bl = this.tableManager.entryExists((UniqueKeyGeneratorImpl)uniqueKeyGenerator);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"entryExists", (Object)new Boolean(bl));
        }
        return bl;
    }

    public long addEntry(final UniqueKeyGenerator uniqueKeyGenerator) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addEntry", (Object)new Object[]{uniqueKeyGenerator});
        }
        Long l = null;
        try {
            l = (Long)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    Long l = PersistentMessageStoreImpl.this.tableManager.addEntry(connectionWrapper, (UniqueKeyGeneratorImpl)uniqueKeyGenerator);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)l);
                    }
                    return l;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.addEntry", (String)"1:1201:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addEntry", (Object)l);
        }
        return l;
    }

    public long updateEntry(final UniqueKeyGenerator uniqueKeyGenerator) throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateEntry", (Object)new Object[]{uniqueKeyGenerator});
        }
        Long l = null;
        try {
            l = (Long)this.controller.performAction(new RetryableAction(){

                public final Object run(ConnectionWrapper connectionWrapper) throws SQLException, IOException {
                    if (tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
                    }
                    Long l = PersistentMessageStoreImpl.this.tableManager.updateEntry(connectionWrapper, (UniqueKeyGeneratorImpl)uniqueKeyGenerator);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"run", (Object)l);
                    }
                    return l;
                }
            });
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.PersistentMessageStoreImpl.updateEntry", (String)"1:1241:1.47.2.2", (Object)this);
            throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateEntry", (Object)l);
        }
        return l;
    }
}

