/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import java.util.IdentityHashMap;
import java.util.Map;

public class ListingTableHelper {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String ID = "ID";
    public static final String SCHEMANAME = "SCHEMA_NAME";
    public static final String TABLENAME = "TABLE_NAME";
    public static final String TABLETYPE = "TABLE_TYPE";
    private static final Map DEFAULT = new IdentityHashMap();
    private static final Map ORACLE = new IdentityHashMap();
    private static final Map SYSTEMS = new IdentityHashMap();

    private ListingTableHelper() {
    }

    public static Map getReferenceInfo(String string) {
        return (Map)SYSTEMS.get(string);
    }

    public static String[] getCreateTableSql(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string6 == "db2j" || string6 == "Derby") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INTEGER NOT NULL, " + SCHEMANAME + " VARCHAR(10), " + TABLENAME + " VARCHAR(10) NOT NULL, " + TABLETYPE + " CHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") )"};
        }
        if (string6 == "DB2" || string6 == "DB2iSeries") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INTEGER NOT NULL, " + SCHEMANAME + " VARCHAR(10), " + TABLENAME + " VARCHAR(10) NOT NULL, " + TABLETYPE + " CHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") )"};
        }
        if (string6 == "Oracle" || string6 == "Oracle8i") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INTEGER NOT NULL, " + SCHEMANAME + " VARCHAR2(10), " + TABLENAME + " VARCHAR2(10) NOT NULL, " + TABLETYPE + " CHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") )"};
        }
        if (string6 == "MS SQL Server") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INT NOT NULL, " + SCHEMANAME + " NVARCHAR(10), " + TABLENAME + " NVARCHAR(10) NOT NULL, " + TABLETYPE + " NCHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") )"};
        }
        if (string6 == "Informix" || string6 == "Informix_73") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INT NOT NULL, " + SCHEMANAME + " VARCHAR(10), " + TABLENAME + " VARCHAR(10) NOT NULL, " + TABLETYPE + " CHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") ) LOCK MODE ROW"};
        }
        if (string6 == "Sybase") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INT NOT NULL, " + SCHEMANAME + " NVARCHAR(10), " + TABLENAME + " NVARCHAR(10) NOT NULL, " + TABLETYPE + " NCHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") )"};
        }
        if (string6 == "DB2390") {
            return new String[]{"CREATE TABLESPACE LISTTS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 3200 SECQTY 320 ERASE NO PCTFREE 0 SEGSIZE 32 BUFFERPOOL " + string3 + " LOCKSIZE ANY CLOSE NO", "CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INTEGER NOT NULL, " + SCHEMANAME + " VARCHAR(10), " + TABLENAME + " VARCHAR(10) NOT NULL, " + TABLETYPE + " CHAR(1) NOT NULL, PRIMARY KEY(" + ID + ") ) IN " + string + ".LISTTS", "CREATE UNIQUE INDEX " + string4 + "." + string5 + " ON " + string4 + "." + string5 + "(" + ID + ") USING STOGROUP " + string2 + " PRIQTY 200 SECQTY 20"};
        }
        if (string6 == "Dummy") {
            return new String[0];
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string6}, null));
    }

    public static String[] getDropTableSql(String string, String string2, String string3, String string4) {
        if (string4 == "DB2390") {
            return new String[]{"DROP TABLE " + string2 + "." + string3, "DROP TABLESPACE " + string + ".LISTTS"};
        }
        return new String[]{"DROP TABLE " + string2 + "." + string3};
    }

    public static String getInsertSql(String string, String string2) {
        return "INSERT INTO " + string + "." + string2 + " (" + ID + "," + SCHEMANAME + "," + TABLENAME + "," + TABLETYPE + ") VALUES (?,?,?,?)";
    }

    public static String getReadTableSql(String string, String string2) {
        return "SELECT ID,SCHEMA_NAME,TABLE_NAME,TABLE_TYPE FROM " + string + "." + string2;
    }

    public static String getGrantSql(String string, String string2, String string3) {
        return "GRANT SELECT,INSERT ON " + string + "." + string2 + " TO " + string3;
    }

    static {
        DEFAULT.put(ID, TableHelper.INTEGER);
        DEFAULT.put(SCHEMANAME, TableHelper.VARCHAR);
        DEFAULT.put(TABLENAME, TableHelper.VARCHAR);
        DEFAULT.put(TABLETYPE, TableHelper.CHAR);
        ORACLE.put(ID, TableHelper.DECIMAL);
        ORACLE.put(SCHEMANAME, TableHelper.VARCHAR);
        ORACLE.put(TABLENAME, TableHelper.VARCHAR);
        ORACLE.put(TABLETYPE, TableHelper.CHAR);
        SYSTEMS.put("DB2", DEFAULT);
        SYSTEMS.put("DB2iSeries", DEFAULT);
        SYSTEMS.put("DB2390", DEFAULT);
        SYSTEMS.put("db2j", DEFAULT);
        SYSTEMS.put("Derby", DEFAULT);
        SYSTEMS.put("Oracle", ORACLE);
        SYSTEMS.put("Oracle8i", ORACLE);
        SYSTEMS.put("MS SQL Server", DEFAULT);
        SYSTEMS.put("Informix", DEFAULT);
        SYSTEMS.put("Informix_73", DEFAULT);
        SYSTEMS.put("Sybase", DEFAULT);
    }
}

