/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.ListingTableEntry;
import com.ibm.ws.sib.msgstore.persistence.impl.ListingTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.Table;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ListingTable
extends Table {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)ListingTable.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final int numberOfStreamTables;
    private final int numberOfPermanentTables;
    private final int numberOfTemporaryTables;
    private final String readAllSql;
    private final String insertSql;
    private int streamTableCount;
    private int permanentTableCount;
    private int temporaryTableCount;
    private int nextEntryNumber;

    public ListingTable(String string, String string2, int n, int n2, int n3) {
        super(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{string, string2, new Integer(n), new Integer(n2), new Integer(n3)});
        }
        if (n < 0) {
            throw new IllegalArgumentException(nls.getFormattedMessage("INVALID_NUMBER_OF_TABLES_SPECIFIED_SIMS1540", new Object[]{new Integer(n)}, null));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(nls.getFormattedMessage("INVALID_NUMBER_OF_TABLES_SPECIFIED_SIMS1540", new Object[]{new Integer(n2)}, null));
        }
        if (n3 < 0) {
            throw new IllegalArgumentException(nls.getFormattedMessage("INVALID_NUMBER_OF_TABLES_SPECIFIED_SIMS1540", new Object[]{new Integer(n3)}, null));
        }
        this.numberOfStreamTables = n;
        this.numberOfPermanentTables = n2;
        this.numberOfTemporaryTables = n3;
        this.readAllSql = ListingTableHelper.getReadTableSql(string, string2);
        this.insertSql = ListingTableHelper.getInsertSql(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public void initialize(ConnectionWrapper connectionWrapper, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)new Object[]{connectionWrapper, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        }
        super.initialize(connectionWrapper, bl, bl2);
        if (bl3) {
            Map map = ListingTableHelper.getReferenceInfo(this.metadata.getDBMS());
            this.performColumnChecks(map);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    protected void createTablesAndIndexes(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createTablesAndIndexes", (Object)new Object[]{connectionWrapper});
        }
        String[] stringArray = ListingTableHelper.getCreateTableSql("SIBDB", "SIBSG", "BP1", this.schemaName, this.tableName, this.metadata.getDBMS());
        super.createTablesAndIndexes(connectionWrapper, stringArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createTablesAndIndexes");
        }
    }

    protected void dropTable(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dropTable", (Object)new Object[]{connectionWrapper});
        }
        String[] stringArray = ListingTableHelper.getDropTableSql("SIBDB", this.schemaName, this.tableName, this.metadata.getDBMS());
        super.dropTable(connectionWrapper, stringArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dropTable");
        }
    }

    public List readTable(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"readTable", (Object)new Object[]{connectionWrapper});
        }
        List list = this.readAll(connectionWrapper);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ListingTableEntry listingTableEntry = (ListingTableEntry)list.get(i);
            String string = listingTableEntry.getTableType();
            if (string.equals("P")) {
                ++this.permanentTableCount;
                continue;
            }
            if (string.equals("T")) {
                ++this.temporaryTableCount;
                continue;
            }
            if (string.equals("S")) {
                ++this.streamTableCount;
                continue;
            }
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TABLE_TYPE_EXCEPTION_SIMS1525", new Object[]{string}, null));
        }
        this.addNewEntries(list, this.numberOfStreamTables, this.streamTableCount, "S");
        this.addNewEntries(list, this.numberOfPermanentTables, this.permanentTableCount, "P");
        this.addNewEntries(list, this.numberOfTemporaryTables, this.temporaryTableCount, "T");
        this.updateTable(connectionWrapper, list, n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readTable", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List readAll(ConnectionWrapper connectionWrapper) throws SQLException {
        ArrayList<ListingTableEntry> arrayList;
        PreparedStatement preparedStatement;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"readAll", (Object)new Object[]{connectionWrapper});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            arrayList = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readAllSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                resultSet = preparedStatement.executeQuery();
                int n = this.getNumberOfRows(resultSet);
                arrayList = new ArrayList<ListingTableEntry>(n);
                while (resultSet.next()) {
                    arrayList.add(new ListingTableEntry(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4)));
                }
                Object var7_6 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        this.nextEntryNumber = arrayList.size();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"readAll", arrayList);
        }
        return arrayList;
    }

    private String intToString(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"intToString", (Object)new Object[]{new Integer(n)});
        }
        String string = "000";
        int n2 = string.length();
        String string2 = Integer.toString(n);
        int n3 = string2.length();
        if (n3 < n2) {
            string2 = string.substring(0, n2 - n3) + string2;
        } else if (n3 > n2) {
            throw new NumberFormatException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"intToString", (Object)string2);
        }
        return string2;
    }

    private void addNewEntries(List list, int n, int n2, String string) {
        int n3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNewEntries", (Object)new Object[]{list, new Integer(n), new Integer(n2)});
        }
        if ((n3 = n - n2) == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalStateException(nls.getFormattedMessage("INCOMPATIBLE_NUMBER_OF_TABLES_SIMS1542", new Object[]{new Integer(n), new Integer(n2)}, null));
        }
        for (int i = 0; i < n3; ++i) {
            String string2 = "SIB" + this.intToString(this.nextEntryNumber);
            ListingTableEntry listingTableEntry = new ListingTableEntry(this.nextEntryNumber, null, string2, string);
            list.add(listingTableEntry);
            ++this.nextEntryNumber;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNewEntries");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(ConnectionWrapper connectionWrapper, List list, int n) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateTable", (Object)new Object[]{connectionWrapper, list, new Integer(n)});
        }
        PreparedStatement preparedStatement = null;
        int n2 = list.size();
        boolean bl = this.jdbcBatchesAreSupported && n2 - n > 1;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.insertSql);
            for (int i = n; i < n2; ++i) {
                ListingTableEntry listingTableEntry = (ListingTableEntry)list.get(i);
                preparedStatement.setInt(1, listingTableEntry.getId());
                preparedStatement.setString(2, listingTableEntry.getSchemaName());
                preparedStatement.setString(3, listingTableEntry.getTableName());
                preparedStatement.setString(4, listingTableEntry.getTableType());
                if (bl) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateTable");
        }
    }
}

