/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import java.util.IdentityHashMap;
import java.util.Map;

public class ItemTableHelper {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String ID = "ID";
    public static final String ITEMSTREAM = "STREAM_ID";
    public static final String TYPE = "TYPE";
    public static final String EXPIRYTIME = "EXPIRY_TIME";
    public static final String CLASSID = "CLASS_ID";
    public static final String PRIORITY = "PRIORITY";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String REFERENCE = "REFERENCE";
    public static final String STORAGESTRATEGY = "STRATEGY";
    public static final String LOCKID = "LOCK_ID";
    public static final String LOGICALLYDELETED = "DELETED";
    public static final String PERMANENTID = "PERMANENT_ID";
    public static final String TEMPORARYID = "TEMPORARY_ID";
    public static final String DATASIZE = "DATA_SIZE";
    public static final String XID = "XID";
    public static final String DATA = "DATA";
    public static final String LONGDATA = "LONG_DATA";
    public static final String LONGDATAID = "LONG_DATA_ID";
    private static final String COLUMNS = "ID,STREAM_ID,TYPE,EXPIRY_TIME,STRATEGY,REFERENCE,CLASS_ID,PRIORITY,SEQUENCE,PERMANENT_ID,TEMPORARY_ID,LOCK_ID,DATA_SIZE,XID,DELETED";
    private static final int NEVER_EXPIRE = 0;
    private static final Map CLOUDSCAPE = new IdentityHashMap();
    private static final Map DB2 = new IdentityHashMap();
    private static final Map DB2_iSeries = new IdentityHashMap();
    private static final Map DB2_390 = new IdentityHashMap();
    private static final Map ORACLE = new IdentityHashMap();
    private static final Map MSSQL = new IdentityHashMap();
    private static final Map INFORMIX = new IdentityHashMap();
    private static final Map INFORMIX_73 = new IdentityHashMap();
    private static final Map SYBASE = new IdentityHashMap();
    private static final Map SYSTEMS = new IdentityHashMap();

    private ItemTableHelper() {
    }

    public static Map getReferenceInfo(String string) {
        return (Map)SYSTEMS.get(string);
    }

    public static String[] getCreateTableSql(String string, String string2, String string3, String string4, String string5, String string6) {
        if (string6 == "db2j" || string6 == "Derby") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " BIGINT NOT NULL, " + ITEMSTREAM + " BIGINT NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " BIGINT, " + STORAGESTRATEGY + " INTEGER, " + REFERENCE + " BIGINT, " + CLASSID + " INTEGER NOT NULL, " + PRIORITY + " INTEGER, " + SEQUENCE + " BIGINT, " + PERMANENTID + " INTEGER, " + TEMPORARYID + " INTEGER, " + LOCKID + " BIGINT, " + DATASIZE + " INTEGER NOT NULL, " + LONGDATA + " BLOB(1G), " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") )", "CREATE INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "DB2") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " BIGINT NOT NULL, " + ITEMSTREAM + " BIGINT NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " BIGINT, " + STORAGESTRATEGY + " INTEGER, " + REFERENCE + " BIGINT, " + CLASSID + " INTEGER NOT NULL, " + PRIORITY + " INTEGER, " + SEQUENCE + " BIGINT, " + PERMANENTID + " INTEGER, " + TEMPORARYID + " INTEGER, " + LOCKID + " BIGINT, " + DATASIZE + " INTEGER NOT NULL, " + DATA + " VARCHAR(3360) FOR BIT DATA, " + LONGDATA + " BLOB(1G), " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT )", "CREATE UNIQUE INDEX " + string4 + "." + string5 + "PKIX ON " + string4 + "." + string5 + " (" + ID + ") ALLOW REVERSE SCANS", "CREATE INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ") ALLOW REVERSE SCANS", "ALTER TABLE " + string4 + "." + string5 + " ADD CONSTRAINT " + string5 + "PKIX PRIMARY KEY (" + ID + ")", "ALTER TABLE " + string4 + "." + string5 + " VOLATILE CARDINALITY"};
        }
        if (string6 == "DB2iSeries") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " BIGINT NOT NULL, " + ITEMSTREAM + " BIGINT NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " BIGINT, " + STORAGESTRATEGY + " INTEGER, " + REFERENCE + " BIGINT, " + CLASSID + " INTEGER NOT NULL, " + PRIORITY + " INTEGER, " + SEQUENCE + " BIGINT, " + PERMANENTID + " INTEGER, " + TEMPORARYID + " INTEGER, " + LOCKID + " BIGINT, " + DATASIZE + " INTEGER NOT NULL, " + DATA + " VARCHAR(3360) FOR BIT DATA, " + LONGDATA + " BLOB(1G), " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") )", "CREATE INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "Oracle") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " NUMBER(19) NOT NULL, " + ITEMSTREAM + " NUMBER(19) NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " NUMBER(19), " + STORAGESTRATEGY + " INTEGER, " + REFERENCE + " NUMBER(19), " + CLASSID + " INTEGER NOT NULL, " + PRIORITY + " INTEGER, " + SEQUENCE + " NUMBER(19), " + PERMANENTID + " INTEGER, " + TEMPORARYID + " INTEGER, " + LOCKID + " NUMBER(19), " + DATASIZE + " INTEGER NOT NULL, " + LONGDATA + " BLOB, " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") ) LOB(" + LONGDATA + ") STORE AS (CACHE STORAGE(INITIAL 10M NEXT 10M))", "CREATE INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "Oracle8i") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " NUMBER(19) NOT NULL, " + ITEMSTREAM + " NUMBER(19) NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " NUMBER(19), " + STORAGESTRATEGY + " INTEGER, " + REFERENCE + " NUMBER(19), " + CLASSID + " INTEGER NOT NULL, " + PRIORITY + " INTEGER, " + SEQUENCE + " NUMBER(19), " + PERMANENTID + " INTEGER, " + TEMPORARYID + " INTEGER, " + LOCKID + " NUMBER(19), " + DATASIZE + " INTEGER NOT NULL, " + LONGDATA + " LONG RAW, " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") )", "CREATE INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "MS SQL Server") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " BIGINT NOT NULL, " + ITEMSTREAM + " BIGINT NOT NULL, " + TYPE + " NCHAR(2), " + EXPIRYTIME + " BIGINT, " + STORAGESTRATEGY + " INT, " + REFERENCE + " BIGINT, " + CLASSID + " INT NOT NULL, " + PRIORITY + " INT, " + SEQUENCE + " BIGINT, " + PERMANENTID + " INT, " + TEMPORARYID + " INT, " + LOCKID + " BIGINT, " + DATASIZE + " INT NOT NULL, " + LONGDATA + " IMAGE, " + XID + " NVARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY NONCLUSTERED (" + ID + ") )", "CREATE CLUSTERED INDEX " + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "Informix") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " INT8 NOT NULL, " + ITEMSTREAM + " INT8 NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " INT8, " + STORAGESTRATEGY + " INT, " + REFERENCE + " INT8, " + CLASSID + " INT NOT NULL, " + PRIORITY + " INT, " + SEQUENCE + " INT8, " + PERMANENTID + " INT, " + TEMPORARYID + " INT, " + LOCKID + " INT8, " + DATASIZE + " INT NOT NULL, " + LONGDATA + " BLOB, " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") ) LOCK MODE ROW", "CREATE CLUSTER INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "Informix_73") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " DECIMAL(19,0) NOT NULL, " + ITEMSTREAM + " DECIMAL(19,0) NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " DECIMAL(19,0), " + STORAGESTRATEGY + " INT, " + REFERENCE + " DECIMAL(19,0), " + CLASSID + " INT NOT NULL, " + PRIORITY + " INT, " + SEQUENCE + " DECIMAL(19,0), " + PERMANENTID + " INT, " + TEMPORARYID + " INT, " + LOCKID + " DECIMAL(19,0), " + DATASIZE + " INT NOT NULL, " + LONGDATA + " BYTE, " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") ) LOCK MODE ROW", "CREATE CLUSTER INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "Sybase") {
            return new String[]{"CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " DECIMAL(19) NOT NULL, " + ITEMSTREAM + " DECIMAL(19) NOT NULL, " + TYPE + " NCHAR(2), " + EXPIRYTIME + " DECIMAL(19), " + STORAGESTRATEGY + " INT, " + REFERENCE + " DECIMAL(19), " + CLASSID + " INT NOT NULL, " + PRIORITY + " INT, " + SEQUENCE + " DECIMAL(19), " + PERMANENTID + " INT, " + TEMPORARYID + " INT, " + LOCKID + " DECIMAL(19), " + DATASIZE + " INT NOT NULL, " + LONGDATA + " IMAGE, " + XID + " NVARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY NONCLUSTERED (" + ID + ") )", "CREATE CLUSTERED INDEX " + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ")"};
        }
        if (string6 == "DB2390") {
            return new String[]{"SET CURRENT RULES = 'DB2'", "CREATE TABLESPACE " + string5 + "TS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 10240 SECQTY 1024 ERASE NO PCTFREE 20 SEGSIZE 32 BUFFERPOOL " + string3 + " LOCKSIZE ROW CLOSE NO", "CREATE TABLE " + string4 + "." + string5 + " ( " + ID + " DECIMAL(19) NOT NULL, " + ITEMSTREAM + " DECIMAL(19) NOT NULL, " + TYPE + " CHAR(2), " + EXPIRYTIME + " DECIMAL(19), " + STORAGESTRATEGY + " INTEGER, " + REFERENCE + " DECIMAL(19), " + CLASSID + " INTEGER NOT NULL, " + PRIORITY + " INTEGER, " + SEQUENCE + " DECIMAL(19), " + PERMANENTID + " INTEGER, " + TEMPORARYID + " INTEGER, " + LOCKID + " DECIMAL(19), " + DATASIZE + " INTEGER NOT NULL, " + DATA + " VARCHAR(3360) FOR BIT DATA, " + LONGDATA + " BLOB(1G), " + LONGDATAID + " ROWID GENERATED ALWAYS NOT NULL, " + XID + " VARCHAR(254), " + LOGICALLYDELETED + " SMALLINT, PRIMARY KEY(" + ID + ") ) IN " + string + "." + string5 + "TS", "CREATE UNIQUE INDEX " + string4 + "." + string5 + " ON " + string4 + "." + string5 + "(" + ID + ") USING STOGROUP " + string2 + " PRIQTY 500 SECQTY 50", "CREATE LOB TABLESPACE " + string5 + "LS IN " + string + " USING STOGROUP " + string2 + " PRIQTY 102400 SECQTY 10240 BUFFERPOOL " + string3 + " LOCKSIZE LOB", "CREATE AUXILIARY TABLE " + string4 + "." + string5 + "AUX IN " + string + "." + string5 + "LS STORES " + string4 + "." + string5 + " COLUMN " + LONGDATA, "CREATE UNIQUE INDEX " + string4 + "." + string5 + "AUXIX ON " + string4 + "." + string5 + "AUX USING STOGROUP " + string2 + " PRIQTY 500 SECQTY 50", "CREATE INDEX " + string4 + "." + string5 + "STREAMIX ON " + string4 + "." + string5 + "(" + ITEMSTREAM + "," + SEQUENCE + ") USING STOGROUP " + string2 + " PRIQTY 500 SECQTY 50"};
        }
        if (string6 == "Dummy") {
            return new String[0];
        }
        throw new IllegalStateException(nls.getFormattedMessage("DATABASE_NOT_RECOGNIZED_SIMS1515", new Object[]{string6}, null));
    }

    public static String[] getDropTableSql(String string, String string2, String string3, String string4) {
        if (string4 == "DB2390") {
            return new String[]{"DROP TABLE " + string2 + "." + string3, "DROP TABLESPACE " + string + "." + string3 + "TS"};
        }
        return new String[]{"DROP TABLE " + string2 + "." + string3};
    }

    public static String getDeleteItemSql(String string, String string2) {
        return "DELETE FROM " + string + "." + string2 + " WHERE " + ID + "=?";
    }

    public static String getInsertItemSql(String string, String string2, boolean bl) {
        if (bl) {
            return "INSERT INTO " + string + "." + string2 + " (" + COLUMNS + "," + DATA + "," + LONGDATA + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }
        return "INSERT INTO " + string + "." + string2 + " (" + COLUMNS + "," + LONGDATA + ") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    public static String getUpdateLockIDOnlySql(String string, String string2) {
        return "UPDATE " + string + "." + string2 + " SET " + LOCKID + "=? WHERE " + ID + "=?";
    }

    public static String getUpdateDataAndSizeSql(String string, String string2, boolean bl) {
        if (bl) {
            return "UPDATE " + string + "." + string2 + " SET " + DATASIZE + "=?," + DATA + "=?," + LONGDATA + "=? WHERE " + ID + "=?";
        }
        return "UPDATE " + string + "." + string2 + " SET " + DATASIZE + "=?," + LONGDATA + "=? WHERE " + ID + "=?";
    }

    public static String getUpdateLogicalDeleteAndXIDSql(String string, String string2) {
        return "UPDATE " + string + "." + string2 + " SET " + LOGICALLYDELETED + "=?," + XID + "=? WHERE " + ID + "=?";
    }

    public static String getTruncateSql(String string, String string2, String string3) {
        if (string3 == "DB2390") {
            return "DELETE FROM " + string + "." + string2;
        }
        return "TRUNCATE TABLE " + string + "." + string2;
    }

    public static String getReadPrimaryKeysSql(String string, String string2) {
        return "SELECT ID FROM " + string + "." + string2;
    }

    public static String getRemoveGarbageSql(String string, String string2) {
        return "DELETE FROM " + string + "." + string2 + " WHERE " + LOGICALLYDELETED + "=? AND " + XID + "=?";
    }

    public static String getUndoRolledbackDeletesSql(String string, String string2) {
        return "UPDATE " + string + "." + string2 + " SET " + LOGICALLYDELETED + "=?," + XID + "=? WHERE " + XID + "=?";
    }

    public static String getReadDataOnlySql(String string, String string2, boolean bl) {
        if (bl) {
            return "SELECT DATA,LONG_DATA FROM " + string + "." + string2 + " WHERE " + ID + "=?";
        }
        return "SELECT LONG_DATA FROM " + string + "." + string2 + " WHERE " + ID + "=?";
    }

    public static String getReadRootPersistableSql(String string, String string2) {
        return "SELECT ID,STREAM_ID,TYPE,EXPIRY_TIME,STRATEGY,REFERENCE,CLASS_ID,PRIORITY,SEQUENCE,PERMANENT_ID,TEMPORARY_ID,LOCK_ID,DATA_SIZE,XID,DELETED FROM " + string + "." + string2 + " WHERE " + ITEMSTREAM + "=? AND " + ID + "=? AND " + TYPE + "='" + TupleTypeEnum.ROOT + "'";
    }

    public static String getReadAllStreamsSql(String string, String string2) {
        return "SELECT ID,STREAM_ID,TYPE,EXPIRY_TIME,STRATEGY,REFERENCE,CLASS_ID,PRIORITY,SEQUENCE,PERMANENT_ID,TEMPORARY_ID,LOCK_ID,DATA_SIZE,XID,DELETED FROM " + string + "." + string2 + " WHERE " + TYPE + "<>'" + TupleTypeEnum.ROOT + "'";
    }

    public static String getReadNonStreamItemsSql(String string, String string2) {
        return "SELECT ID,STREAM_ID,TYPE,EXPIRY_TIME,STRATEGY,REFERENCE,CLASS_ID,PRIORITY,SEQUENCE,PERMANENT_ID,TEMPORARY_ID,LOCK_ID,DATA_SIZE,XID,DELETED FROM " + string + "." + string2 + " WHERE " + ITEMSTREAM + "=? ORDER BY " + SEQUENCE;
    }

    public static String getIdentifyStreamsWithExpirableItemsSql(String string, String string2) {
        return "SELECT DISTINCT STREAM_ID FROM " + string + "." + string2 + " WHERE " + EXPIRYTIME + "<>" + 0;
    }

    public static String getIdentifyStreamsWithIndoubtItemsSql(String string, String string2) {
        return "SELECT DISTINCT STREAM_ID FROM " + string + "." + string2 + "," + string + "." + "SIBXACTS" + " WHERE STATE='" + "I" + "' AND " + string + "." + "SIBXACTS" + "." + XID + "=" + string + "." + string2 + "." + XID;
    }

    public static String getGrantSql(String string, String string2, String string3) {
        return "GRANT SELECT,INSERT,DELETE,UPDATE ON " + string + "." + string2 + " TO " + string3;
    }

    static {
        CLOUDSCAPE.put(ID, TableHelper.BIGINT);
        CLOUDSCAPE.put(ITEMSTREAM, TableHelper.BIGINT);
        CLOUDSCAPE.put(TYPE, TableHelper.CHAR);
        CLOUDSCAPE.put(EXPIRYTIME, TableHelper.BIGINT);
        CLOUDSCAPE.put(CLASSID, TableHelper.INTEGER);
        CLOUDSCAPE.put(PRIORITY, TableHelper.INTEGER);
        CLOUDSCAPE.put(SEQUENCE, TableHelper.BIGINT);
        CLOUDSCAPE.put(REFERENCE, TableHelper.BIGINT);
        CLOUDSCAPE.put(STORAGESTRATEGY, TableHelper.INTEGER);
        CLOUDSCAPE.put(LOCKID, TableHelper.BIGINT);
        CLOUDSCAPE.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        CLOUDSCAPE.put(PERMANENTID, TableHelper.INTEGER);
        CLOUDSCAPE.put(TEMPORARYID, TableHelper.INTEGER);
        CLOUDSCAPE.put(DATASIZE, TableHelper.INTEGER);
        CLOUDSCAPE.put(XID, TableHelper.VARCHAR);
        CLOUDSCAPE.put(LONGDATA, TableHelper.BLOB);
        DB2.put(ID, TableHelper.BIGINT);
        DB2.put(ITEMSTREAM, TableHelper.BIGINT);
        DB2.put(TYPE, TableHelper.CHAR);
        DB2.put(EXPIRYTIME, TableHelper.BIGINT);
        DB2.put(CLASSID, TableHelper.INTEGER);
        DB2.put(PRIORITY, TableHelper.INTEGER);
        DB2.put(SEQUENCE, TableHelper.BIGINT);
        DB2.put(REFERENCE, TableHelper.BIGINT);
        DB2.put(STORAGESTRATEGY, TableHelper.INTEGER);
        DB2.put(LOCKID, TableHelper.BIGINT);
        DB2.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        DB2.put(PERMANENTID, TableHelper.INTEGER);
        DB2.put(TEMPORARYID, TableHelper.INTEGER);
        DB2.put(DATASIZE, TableHelper.INTEGER);
        DB2.put(XID, TableHelper.VARCHAR);
        DB2.put(DATA, TableHelper.VARBINARY);
        DB2.put(LONGDATA, TableHelper.BLOB);
        DB2_iSeries.put(ID, TableHelper.BIGINT);
        DB2_iSeries.put(ITEMSTREAM, TableHelper.BIGINT);
        DB2_iSeries.put(TYPE, TableHelper.CHAR);
        DB2_iSeries.put(EXPIRYTIME, TableHelper.BIGINT);
        DB2_iSeries.put(CLASSID, TableHelper.INTEGER);
        DB2_iSeries.put(PRIORITY, TableHelper.INTEGER);
        DB2_iSeries.put(SEQUENCE, TableHelper.BIGINT);
        DB2_iSeries.put(REFERENCE, TableHelper.BIGINT);
        DB2_iSeries.put(STORAGESTRATEGY, TableHelper.INTEGER);
        DB2_iSeries.put(LOCKID, TableHelper.BIGINT);
        DB2_iSeries.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        DB2_iSeries.put(PERMANENTID, TableHelper.INTEGER);
        DB2_iSeries.put(TEMPORARYID, TableHelper.INTEGER);
        DB2_iSeries.put(DATASIZE, TableHelper.INTEGER);
        DB2_iSeries.put(XID, TableHelper.VARCHAR);
        DB2_iSeries.put(DATA, new Integer[]{TableHelper.VARCHAR, TableHelper.VARBINARY});
        DB2_iSeries.put(LONGDATA, TableHelper.BLOB);
        DB2_390.put(ID, TableHelper.DECIMAL);
        DB2_390.put(ITEMSTREAM, TableHelper.DECIMAL);
        DB2_390.put(TYPE, TableHelper.CHAR);
        DB2_390.put(EXPIRYTIME, TableHelper.DECIMAL);
        DB2_390.put(CLASSID, TableHelper.INTEGER);
        DB2_390.put(PRIORITY, TableHelper.INTEGER);
        DB2_390.put(SEQUENCE, TableHelper.DECIMAL);
        DB2_390.put(REFERENCE, TableHelper.DECIMAL);
        DB2_390.put(STORAGESTRATEGY, TableHelper.INTEGER);
        DB2_390.put(LOCKID, TableHelper.DECIMAL);
        DB2_390.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        DB2_390.put(PERMANENTID, TableHelper.INTEGER);
        DB2_390.put(TEMPORARYID, TableHelper.INTEGER);
        DB2_390.put(DATASIZE, TableHelper.INTEGER);
        DB2_390.put(XID, TableHelper.VARCHAR);
        DB2_390.put(DATA, TableHelper.LONGVARBINARY);
        DB2_390.put(LONGDATA, TableHelper.BLOB);
        DB2_390.put(LONGDATAID, new Integer[]{TableHelper.OTHER, TableHelper.VARBINARY});
        ORACLE.put(ID, TableHelper.DECIMAL);
        ORACLE.put(ITEMSTREAM, TableHelper.DECIMAL);
        ORACLE.put(TYPE, TableHelper.CHAR);
        ORACLE.put(EXPIRYTIME, TableHelper.DECIMAL);
        ORACLE.put(CLASSID, TableHelper.DECIMAL);
        ORACLE.put(PRIORITY, TableHelper.DECIMAL);
        ORACLE.put(SEQUENCE, TableHelper.DECIMAL);
        ORACLE.put(REFERENCE, TableHelper.DECIMAL);
        ORACLE.put(STORAGESTRATEGY, TableHelper.DECIMAL);
        ORACLE.put(LOCKID, TableHelper.DECIMAL);
        ORACLE.put(LOGICALLYDELETED, TableHelper.DECIMAL);
        ORACLE.put(PERMANENTID, TableHelper.DECIMAL);
        ORACLE.put(TEMPORARYID, TableHelper.DECIMAL);
        ORACLE.put(DATASIZE, TableHelper.DECIMAL);
        ORACLE.put(XID, TableHelper.VARCHAR);
        ORACLE.put(LONGDATA, new Integer[]{TableHelper.BLOB, TableHelper.LONGVARBINARY, TableHelper.OTHER});
        MSSQL.put(ID, TableHelper.BIGINT);
        MSSQL.put(ITEMSTREAM, TableHelper.BIGINT);
        MSSQL.put(TYPE, TableHelper.CHAR);
        MSSQL.put(EXPIRYTIME, TableHelper.BIGINT);
        MSSQL.put(CLASSID, TableHelper.INTEGER);
        MSSQL.put(PRIORITY, TableHelper.INTEGER);
        MSSQL.put(SEQUENCE, TableHelper.BIGINT);
        MSSQL.put(REFERENCE, TableHelper.BIGINT);
        MSSQL.put(STORAGESTRATEGY, TableHelper.INTEGER);
        MSSQL.put(LOCKID, TableHelper.BIGINT);
        MSSQL.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        MSSQL.put(PERMANENTID, TableHelper.INTEGER);
        MSSQL.put(TEMPORARYID, TableHelper.INTEGER);
        MSSQL.put(DATASIZE, TableHelper.INTEGER);
        MSSQL.put(XID, TableHelper.VARCHAR);
        MSSQL.put(LONGDATA, TableHelper.LONGVARBINARY);
        INFORMIX.put(ID, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        INFORMIX.put(ITEMSTREAM, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        INFORMIX.put(TYPE, TableHelper.CHAR);
        INFORMIX.put(EXPIRYTIME, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        INFORMIX.put(CLASSID, TableHelper.INTEGER);
        INFORMIX.put(PRIORITY, TableHelper.INTEGER);
        INFORMIX.put(SEQUENCE, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        INFORMIX.put(REFERENCE, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        INFORMIX.put(STORAGESTRATEGY, TableHelper.INTEGER);
        INFORMIX.put(LOCKID, new Integer[]{TableHelper.BIGINT, TableHelper.DECIMAL});
        INFORMIX.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        INFORMIX.put(PERMANENTID, TableHelper.INTEGER);
        INFORMIX.put(TEMPORARYID, TableHelper.INTEGER);
        INFORMIX.put(DATASIZE, TableHelper.INTEGER);
        INFORMIX.put(XID, TableHelper.VARCHAR);
        INFORMIX.put(LONGDATA, new Integer[]{TableHelper.BLOB, TableHelper.LONGVARBINARY});
        SYBASE.put(ID, TableHelper.DECIMAL);
        SYBASE.put(ITEMSTREAM, TableHelper.DECIMAL);
        SYBASE.put(TYPE, TableHelper.CHAR);
        SYBASE.put(EXPIRYTIME, TableHelper.DECIMAL);
        SYBASE.put(CLASSID, TableHelper.INTEGER);
        SYBASE.put(PRIORITY, TableHelper.INTEGER);
        SYBASE.put(SEQUENCE, TableHelper.DECIMAL);
        SYBASE.put(REFERENCE, TableHelper.DECIMAL);
        SYBASE.put(STORAGESTRATEGY, TableHelper.INTEGER);
        SYBASE.put(LOCKID, TableHelper.DECIMAL);
        SYBASE.put(LOGICALLYDELETED, TableHelper.SMALLINT);
        SYBASE.put(PERMANENTID, TableHelper.INTEGER);
        SYBASE.put(TEMPORARYID, TableHelper.INTEGER);
        SYBASE.put(DATASIZE, TableHelper.INTEGER);
        SYBASE.put(XID, TableHelper.VARCHAR);
        SYBASE.put(LONGDATA, TableHelper.LONGVARBINARY);
        SYSTEMS.put("DB2", DB2);
        SYSTEMS.put("DB2iSeries", DB2_iSeries);
        SYSTEMS.put("DB2390", DB2_390);
        SYSTEMS.put("db2j", CLOUDSCAPE);
        SYSTEMS.put("Derby", CLOUDSCAPE);
        SYSTEMS.put("Oracle", ORACLE);
        SYSTEMS.put("Oracle8i", ORACLE);
        SYSTEMS.put("MS SQL Server", MSSQL);
        SYSTEMS.put("Informix", INFORMIX);
        SYSTEMS.put("Informix_73", INFORMIX);
        SYSTEMS.put("Sybase", SYBASE);
    }
}

