/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.ItemTableHelper;
import com.ibm.ws.sib.msgstore.persistence.impl.Table;
import com.ibm.ws.sib.msgstore.persistence.impl.Token;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.XidManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemTable
extends Table {
    public static final String $ssccid = "@(#) 1.58.5.1 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/persistence/impl/ItemTable.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/08/23 11:04:35 [3/13/06 13:59:34]";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)ItemTable.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String STREAM = "S";
    public static final String PERMANENT = "P";
    public static final String TEMPORARY = "T";
    private static final byte[] BYTE_ARRAY = new byte[0];
    private static final byte[] NOT_XML_ARRAY = "NOTXML".getBytes();
    private final String tableType;
    private final MSInstrumentation instrument;
    private final XidManager _manager;
    private final String deleteSql;
    private final String updateLockIDOnlySql;
    private final String updateLogicalDeleteAndXIDSql;
    private final String removeGarbageSql;
    private final String undoRolledbackDeletesSql;
    private final String readPrimaryKeysSql;
    private final String readRootPersistableSql;
    private final String readAllStreamsSql;
    private final String readNonStreamItemsSql;
    private final String identifyStreamsWithExpirableItemsSql;
    private final String identifyStreamsWithIndoubtItemsSql;
    private String insertSql;
    private String truncateSql;
    private String updateDataAndSizeSql;
    private String readDataOnlySql;
    private int maximumSizeOfDataColumn = 3360;
    private int maximumSizeOfLongDataColumn = Integer.MAX_VALUE;

    public ItemTable(MSInstrumentation mSInstrumentation, XidManager xidManager, String string, String string2, String string3) {
        super(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{mSInstrumentation, xidManager, string, string2, string3});
        }
        if (!(string3.equals(STREAM) || string3.equals(PERMANENT) || string3.equals(TEMPORARY))) {
            throw new IllegalArgumentException(string3);
        }
        this.tableType = string3;
        this.instrument = mSInstrumentation;
        this._manager = xidManager;
        this.deleteSql = ItemTableHelper.getDeleteItemSql(string, string2);
        this.updateLockIDOnlySql = ItemTableHelper.getUpdateLockIDOnlySql(string, string2);
        this.updateLogicalDeleteAndXIDSql = ItemTableHelper.getUpdateLogicalDeleteAndXIDSql(string, string2);
        this.removeGarbageSql = ItemTableHelper.getRemoveGarbageSql(string, string2);
        this.undoRolledbackDeletesSql = ItemTableHelper.getUndoRolledbackDeletesSql(string, string2);
        this.readPrimaryKeysSql = ItemTableHelper.getReadPrimaryKeysSql(string, string2);
        this.readRootPersistableSql = ItemTableHelper.getReadRootPersistableSql(string, string2);
        this.readAllStreamsSql = ItemTableHelper.getReadAllStreamsSql(string, string2);
        this.readNonStreamItemsSql = ItemTableHelper.getReadNonStreamItemsSql(string, string2);
        this.identifyStreamsWithIndoubtItemsSql = ItemTableHelper.getIdentifyStreamsWithIndoubtItemsSql(string, string2);
        this.identifyStreamsWithExpirableItemsSql = ItemTableHelper.getIdentifyStreamsWithExpirableItemsSql(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ConnectionWrapper connectionWrapper, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"initialize", (Object)new Object[]{connectionWrapper, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        }
        super.initialize(connectionWrapper, bl, bl2);
        if (bl3) {
            Object object;
            ResultSet resultSet = null;
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            try {
                resultSet = this.metadata.getColumns(null, this.schemaName, this.tableName, "%");
                while (resultSet.next()) {
                    object = resultSet.getString(4);
                    int n = resultSet.getInt(5);
                    if (((String)(object = ((String)object).toUpperCase().trim())).equals("LONG_DATA")) {
                        this.maximumSizeOfLongDataColumn = resultSet.getInt(7);
                        if (this.metadata.getDBMS() == "Oracle" || this.metadata.getDBMS() == "Oracle8i") {
                            this.maximumSizeOfLongDataColumn = Integer.MAX_VALUE;
                        }
                    } else if (((String)object).equals("DATA")) {
                        this.maximumSizeOfDataColumn = resultSet.getInt(7);
                    }
                    hashMap.put(object, new Integer(n));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            object = ItemTableHelper.getReferenceInfo(this.metadata.getDBMS());
            this.compareColumnInfo((Map)object, hashMap);
        }
        this.insertSql = ItemTableHelper.getInsertItemSql(this.schemaName, this.tableName, this.metadata.supportsBinaryDataInStringColumns());
        this.truncateSql = ItemTableHelper.getTruncateSql(this.schemaName, this.tableName, this.metadata.getDBMS());
        this.updateDataAndSizeSql = ItemTableHelper.getUpdateDataAndSizeSql(this.schemaName, this.tableName, this.metadata.supportsBinaryDataInStringColumns());
        this.readDataOnlySql = ItemTableHelper.getReadDataOnlySql(this.schemaName, this.tableName, this.metadata.supportsBinaryDataInStringColumns());
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"initialize");
        }
    }

    protected void createTablesAndIndexes(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"createTablesAndIndexes", (Object)new Object[]{connectionWrapper});
        }
        String[] stringArray = ItemTableHelper.getCreateTableSql("SIBDB", "SIBSG", "BP1", this.schemaName, this.tableName, this.metadata.getDBMS());
        super.createTablesAndIndexes(connectionWrapper, stringArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"createTablesAndIndexes");
        }
    }

    protected void dropTable(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dropTable", (Object)new Object[]{connectionWrapper});
        }
        String[] stringArray = ItemTableHelper.getDropTableSql("SIBDB", this.schemaName, this.tableName, this.metadata.getDBMS());
        super.dropTable(connectionWrapper, stringArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dropTable");
        }
    }

    public void setMaximumDataSize(int n) {
        this.maximumSizeOfLongDataColumn = n;
    }

    public int getMaximumDataSize() {
        return this.maximumSizeOfLongDataColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(ConnectionWrapper connectionWrapper, List list) throws SQLException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"insert", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.insertSql);
            int n = list.size();
            boolean bl = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                Tuple tuple = (Tuple)list.get(i);
                byte[] byArray = tuple.getData();
                if (byArray == null) {
                    byArray = BYTE_ARRAY;
                }
                int n2 = byArray.length;
                tuple.setPersistentSize(n2);
                long l = tuple.getExpiryTime();
                boolean bl2 = tuple.getCanExpireSilently();
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values: " + tuple + ", " + byArray));
                }
                preparedStatement.setLong(1, tuple.getUniqueId());
                preparedStatement.setLong(2, tuple.getContainingStreamId());
                preparedStatement.setString(3, tuple.getTupleType().toString());
                preparedStatement.setLong(4, bl2 ? -l : l);
                preparedStatement.setLong(5, tuple.getStorageStrategy());
                preparedStatement.setLong(6, tuple.getReferredID());
                preparedStatement.setInt(7, tuple.getItemClassId());
                preparedStatement.setInt(8, tuple.getPriority());
                preparedStatement.setLong(9, tuple.getSequence());
                preparedStatement.setInt(10, tuple.getPermanentTableId());
                preparedStatement.setInt(11, tuple.getTemporaryTableId());
                preparedStatement.setLong(12, tuple.getLockID());
                preparedStatement.setInt(13, n2);
                preparedStatement.setString(14, tuple.getPersistentTranId() == null ? null : tuple.getPersistentTranId().getPersistentData());
                preparedStatement.setBoolean(15, tuple.isLogicallyDeleted());
                ByteArrayInputStream byteArrayInputStream = null;
                if (n2 > this.maximumSizeOfLongDataColumn) {
                    throw new IllegalStateException(nls.getFormattedMessage("MAX_DATA_SIZE_EXCEPTION_SIMS1531", new Object[]{new Integer(this.maximumSizeOfLongDataColumn), new Integer(n2)}, null));
                }
                if (this.metadata.supportsBinaryDataInStringColumns()) {
                    if (n2 > this.maximumSizeOfDataColumn) {
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        byArray = null;
                    }
                    preparedStatement.setBytes(16, byArray);
                    preparedStatement.setBinaryStream(17, (InputStream)byteArrayInputStream, byteArrayInputStream != null ? n2 : 0);
                } else {
                    byteArrayInputStream = this.metadata.getDBMS() == "Sybase" && n2 == 0 ? new ByteArrayInputStream(NOT_XML_ARRAY) : new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(16, (InputStream)byteArrayInputStream, n2);
                }
                if (bl) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Execute batch");
                }
                preparedStatement.executeBatch();
            }
            this.instrument.increment(44, n);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"insert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"delete", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        long l = -1L;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.deleteSql);
            int n = list.size();
            boolean bl = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (e instanceof Tuple) {
                    l = ((Tuple)e).getUniqueId();
                } else if (e instanceof Long) {
                    l = (Long)e;
                } else {
                    throw new UnsupportedOperationException();
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + l + ")"));
                }
                preparedStatement.setLong(1, l);
                if (bl) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
            this.instrument.increment(45, n);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(ConnectionWrapper connectionWrapper) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"truncate", (Object)new Object[]{connectionWrapper});
        }
        PreparedStatement preparedStatement = null;
        if (!this.tableType.equals(TEMPORARY)) {
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TABLE_OPERATION_EXCEPTION_SIMS1526", new Object[]{this.schemaName + "." + this.tableName, this.tableType}, null));
        }
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.truncateSql);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Executing Statement");
            }
            preparedStatement.executeUpdate();
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"truncate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLockIDOnly(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLockIDOnly", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.updateLockIDOnlySql);
            int n = list.size();
            boolean bl = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                Tuple tuple = (Tuple)list.get(i);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + tuple.getLockID() + ", " + tuple.getUniqueId() + ")"));
                }
                preparedStatement.setLong(1, tuple.getLockID());
                preparedStatement.setLong(2, tuple.getUniqueId());
                if (bl) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
            this.instrument.increment(46, n);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLockIDOnly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataAndSize(ConnectionWrapper connectionWrapper, List list) throws SQLException, PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateDataAndSize", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.updateDataAndSizeSql);
            int n = list.size();
            boolean bl = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                Tuple tuple = (Tuple)list.get(i);
                byte[] byArray = tuple.getData();
                if (byArray == null) {
                    byArray = BYTE_ARRAY;
                }
                int n2 = byArray.length;
                tuple.setPersistentSize(n2);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + n2 + ", " + byArray + ")"));
                }
                preparedStatement.setInt(1, n2);
                if (n2 > this.maximumSizeOfLongDataColumn) {
                    throw new IllegalStateException(nls.getFormattedMessage("MAX_DATA_SIZE_EXCEPTION_SIMS1531", new Object[]{new Integer(this.maximumSizeOfLongDataColumn), new Integer(n2)}, null));
                }
                if (this.metadata.supportsBinaryDataInStringColumns()) {
                    if (n2 > this.maximumSizeOfDataColumn) {
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        byArray = null;
                    }
                    preparedStatement.setBytes(2, byArray);
                    preparedStatement.setBinaryStream(3, (InputStream)byteArrayInputStream, byteArrayInputStream != null ? n2 : 0);
                    preparedStatement.setLong(4, tuple.getUniqueId());
                } else {
                    byteArrayInputStream = this.metadata.getDBMS() == "Sybase" && n2 == 0 ? new ByteArrayInputStream(NOT_XML_ARRAY) : new ByteArrayInputStream(byArray);
                    preparedStatement.setBinaryStream(2, (InputStream)byteArrayInputStream, n2);
                    preparedStatement.setLong(3, tuple.getUniqueId());
                }
                if (bl) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
            this.instrument.increment(46, n);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateDataAndSize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLogicalDeleteAndXID(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLogicalDeleteAndXID", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.updateLogicalDeleteAndXIDSql);
            int n = list.size();
            boolean bl = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                Tuple tuple = (Tuple)list.get(i);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + tuple.isLogicallyDeleted() + "," + tuple.getPersistentTranId() + "," + tuple.getUniqueId() + ")"));
                }
                preparedStatement.setBoolean(1, tuple.isLogicallyDeleted());
                preparedStatement.setString(2, tuple.getPersistentTranId() == null ? null : tuple.getPersistentTranId().getPersistentData());
                preparedStatement.setLong(3, tuple.getUniqueId());
                if (bl) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Adding a batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Execute");
                }
                preparedStatement.executeUpdate();
            }
            if (bl) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Execute batch");
                }
                preparedStatement.executeBatch();
            }
            this.instrument.increment(46, n);
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"updateLogicalDeleteAndXID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommittedDeletes(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeCommittedDeletes", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.removeGarbageSql);
            int n = list.size();
            boolean bl2 = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                PersistentTranId persistentTranId = (PersistentTranId)list.get(i);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + bl + "," + persistentTranId.getPersistentData() + ")"));
                }
                preparedStatement.setBoolean(1, bl);
                preparedStatement.setString(2, persistentTranId.getPersistentData());
                if (bl2) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl2) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeCommittedDeletes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRolledbackInserts(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeRolledbackInserts", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.removeGarbageSql);
            int n = list.size();
            boolean bl2 = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                PersistentTranId persistentTranId = (PersistentTranId)list.get(i);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + bl + "," + persistentTranId.getPersistentData() + ")"));
                }
                preparedStatement.setBoolean(1, bl);
                preparedStatement.setString(2, persistentTranId.getPersistentData());
                if (bl2) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl2) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeRolledbackInserts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoRolledbackDeletes(ConnectionWrapper connectionWrapper, List list) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"undoRolledbackDeletes", (Object)new Object[]{connectionWrapper, list});
        }
        PreparedStatement preparedStatement = null;
        boolean bl = false;
        String string = null;
        try {
            preparedStatement = connectionWrapper.prepareStatement(this.undoRolledbackDeletesSql);
            int n = list.size();
            boolean bl2 = this.jdbcBatchesAreSupported && n > 1 && connectionWrapper.isStatementBatchingEnabled();
            for (int i = 0; i < n; ++i) {
                PersistentTranId persistentTranId = (PersistentTranId)list.get(i);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting values (" + bl + "," + string + "," + persistentTranId.getPersistentData() + ")"));
                }
                preparedStatement.setBoolean(1, bl);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, persistentTranId.getPersistentData());
                if (bl2) {
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Adding batch");
                    }
                    preparedStatement.addBatch();
                    continue;
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing update");
                }
                preparedStatement.executeUpdate();
            }
            if (bl2) {
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing batch");
                }
                preparedStatement.executeBatch();
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"undoRolledbackDeletes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readDataOnly(ConnectionWrapper connectionWrapper, Tuple tuple) throws SQLException, IOException {
        byte[] byArray;
        PreparedStatement preparedStatement;
        block15: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"readDataOnly", (Object)new Object[]{connectionWrapper, tuple});
            }
            preparedStatement = null;
            byArray = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readDataOnlySql);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting (" + tuple.getUniqueId() + ")"));
                }
                preparedStatement.setLong(1, tuple.getUniqueId());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing query");
                }
                if ((resultSet = preparedStatement.executeQuery()).next()) {
                    InputStream inputStream = null;
                    if (this.metadata.supportsBinaryDataInStringColumns()) {
                        byArray = resultSet.getBytes(1);
                        inputStream = resultSet.getBinaryStream(2);
                        if (byArray != null && inputStream != null) {
                            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TABLE_ENTRY_SIMS1516", new Object[]{this.schemaName + "." + this.tableName}, null));
                        }
                    } else {
                        inputStream = resultSet.getBinaryStream(1);
                    }
                    if (inputStream != null) {
                        int n;
                        int n2 = tuple.getPersistentSize();
                        byArray = new byte[n2];
                        for (int i = 0; i < n2 && (n = inputStream.read(byArray, i, n2 - i)) != -1; i += n) {
                        }
                    }
                }
                Object var11_10 = null;
                if (resultSet == null) break block15;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readDataOnly", (Object)byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple readRootPersistable(ConnectionWrapper connectionWrapper, long l, long l2) throws SQLException {
        Tuple tuple;
        PreparedStatement preparedStatement;
        block11: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"readRootPersistable", (Object)new Object[]{connectionWrapper, new Long(l), new Long(l2)});
            }
            preparedStatement = null;
            tuple = null;
            ResultSet resultSet = null;
            List list = null;
            if (!this.tableType.equals(STREAM)) {
                throw new IllegalStateException(nls.getFormattedMessage("INVALID_TABLE_OPERATION_EXCEPTION_SIMS1526", new Object[]{this.schemaName + "." + this.tableName, this.tableType}, null));
            }
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readRootPersistableSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting (" + l2 + ", " + l + ")"));
                }
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing Query");
                }
                if (!(list = this.processResultSet(resultSet = preparedStatement.executeQuery())).isEmpty()) {
                    tuple = (Tuple)list.get(0);
                }
                Object var11_8 = null;
                if (resultSet == null) break block11;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readRootPersistable", (Object)tuple);
        }
        return tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readAllStreams(ConnectionWrapper connectionWrapper) throws SQLException {
        List list;
        PreparedStatement preparedStatement;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"readAllStreams", (Object)new Object[]{connectionWrapper});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            list = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readAllStreamsSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing Query");
                }
                resultSet = preparedStatement.executeQuery();
                list = this.processResultSet(resultSet);
                Object var6_5 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readAllStreams", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readNonStreamItems(ConnectionWrapper connectionWrapper, Tuple tuple) throws SQLException {
        List list;
        PreparedStatement preparedStatement;
        block9: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"readNonStreamItems", (Object)new Object[]{connectionWrapper, tuple});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            list = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readNonStreamItemsSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)("Setting (" + tuple.getUniqueId() + ")"));
                }
                preparedStatement.setLong(1, tuple.getUniqueId());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing Query");
                }
                resultSet = preparedStatement.executeQuery();
                list = this.processResultSet(resultSet, tuple);
                Object var7_6 = null;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readNonStreamItems", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List identifyStreamsWithExpirableItems(ConnectionWrapper connectionWrapper) throws SQLException {
        List list;
        PreparedStatement preparedStatement;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithExpirableItems", (Object)new Object[]{connectionWrapper});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            list = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.identifyStreamsWithExpirableItemsSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing Query");
                }
                resultSet = preparedStatement.executeQuery();
                list = this.processIdsResultSet(resultSet);
                Object var6_5 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithExpirableItems", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List identifyStreamsWithIndoubtItems(ConnectionWrapper connectionWrapper) throws SQLException {
        List list;
        PreparedStatement preparedStatement;
        block7: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems", (Object)new Object[]{connectionWrapper});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            list = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.identifyStreamsWithIndoubtItemsSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                resultSet = preparedStatement.executeQuery();
                list = this.processIdsResultSet(resultSet);
                Object var6_5 = null;
                if (resultSet == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyStreamsWithIndoubtItems", (Object)list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List identifyAllItems(ConnectionWrapper connectionWrapper) throws SQLException {
        List list;
        PreparedStatement preparedStatement;
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"identifyAllItems", (Object)new Object[]{connectionWrapper});
            }
            preparedStatement = null;
            ResultSet resultSet = null;
            list = null;
            try {
                preparedStatement = connectionWrapper.prepareStatement(this.readPrimaryKeysSql, 1004, 1007, this.metadata.supportsScrollableResultSet());
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Executing query");
                }
                resultSet = preparedStatement.executeQuery();
                list = this.processIdsResultSet(resultSet);
                Object var6_5 = null;
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"identifyAllItems", (Object)list);
        }
        return list;
    }

    private List processResultSet(ResultSet resultSet, Tuple tuple) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processResultSet", (Object)new Object[]{resultSet, tuple});
        }
        List list = this.processResultSet(resultSet);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Tuple tuple2 = (Tuple)list.get(i);
            tuple2.setContainingStream(tuple);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processResultSet", (Object)list);
        }
        return list;
    }

    private List processResultSet(ResultSet resultSet) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processResultSet", (Object)new Object[]{resultSet});
        }
        int n = this.getNumberOfRows(resultSet);
        ArrayList<Token> arrayList = new ArrayList<Token>(n);
        while (resultSet.next()) {
            PersistentTranId persistentTranId;
            String string = resultSet.getString(14);
            boolean bl = resultSet.getBoolean(15);
            PersistentTranId persistentTranId2 = persistentTranId = string == null ? null : new PersistentTranId(string);
            if (bl && !this._manager.isTranIdKnown(persistentTranId)) {
                if (!tc.isEventEnabled()) continue;
                SibTr.event((TraceComponent)tc, (String)"Item filtered out: ", (Object)new Long(resultSet.getLong(1)));
                continue;
            }
            Token token = new Token(resultSet.getLong(1), resultSet.getLong(2), TupleTypeEnum.getInstance(resultSet.getString(3)));
            long l = resultSet.getLong(4);
            token.setCanExpireSilently(l <= 0L);
            token.setExpiryTime(Math.abs(l));
            token.setStorageStrategy(resultSet.getInt(5));
            token.setReferredID(resultSet.getLong(6));
            token.setItemClassId(resultSet.getInt(7));
            token.setPriority(resultSet.getInt(8));
            token.setSequence(resultSet.getLong(9));
            token.setPermanentTableId(resultSet.getInt(10));
            token.setTemporaryTableId(resultSet.getInt(11));
            token.setLockID(resultSet.getLong(12));
            token.setPersistentSize(resultSet.getInt(13));
            token.setPersistentTranId(persistentTranId);
            token.setLogicallyDeleted(bl);
            arrayList.add(token);
            token.persistableOperationBegun();
            token.persistableOperationCompleted();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processResultSet", arrayList);
        }
        return arrayList;
    }

    private List processIdsResultSet(ResultSet resultSet) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processStreamIdsResultSet", (Object)new Object[]{resultSet});
        }
        int n = this.getNumberOfRows(resultSet);
        ArrayList<Long> arrayList = new ArrayList<Long>(n);
        while (resultSet.next()) {
            arrayList.add(new Long(resultSet.getLong(1)));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processStreamIdsResultSet", arrayList);
        }
        return arrayList;
    }
}

