/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Configuration;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.ConnectionUnavailableException;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapper;
import com.ibm.ws.sib.msgstore.persistence.DatasourceWrapperStateException;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.DatabaseMetaDataExtensions;
import com.ibm.ws.sib.msgstore.persistence.impl.TableHelper;
import com.ibm.ws.sib.msgstore.persistence.lock.DBLockingDatasource;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class DefaultDatasourceWrapper
implements DatasourceWrapper,
ConnectionEventListener,
DBLockingDatasource {
    private static TraceComponent tc = SibTr.register((Class)DefaultDatasourceWrapper.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static final int STOPPED = 0;
    private static final int STARTED = 1;
    private static final int DISABLED = 2;
    private final ConnectionPoolDataSource cpds;
    private final String username;
    private final String password;
    private final int maxSize;
    private final MessageStoreImpl msi;
    private final MSInstrumentation instrument;
    private PooledConnection[] pool;
    private int currentIndex = 0;
    private Object lock = new Object();
    private String databaseVendor;
    private long disabledDatasourceWaitTimeout;
    private volatile int _state = 0;
    static /* synthetic */ Class class$java$lang$String;

    public DefaultDatasourceWrapper(MessageStoreImpl messageStoreImpl, Configuration configuration) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{messageStoreImpl, configuration});
        }
        try {
            Class<?> clazz = Class.forName(configuration.getDatasourceClassname());
            this.cpds = (ConnectionPoolDataSource)clazz.newInstance();
            Properties properties = configuration.getDatasourceProperties();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = "set" + new String(new char[]{string.charAt(0)}).toUpperCase() + string.substring(1);
                try {
                    Method method = clazz.getMethod(string2, class$java$lang$String == null ? DefaultDatasourceWrapper.class$("java.lang.String") : class$java$lang$String);
                    method.invoke((Object)this.cpds, properties.get(string));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Method method = clazz.getMethod(string2, Integer.TYPE);
                    method.invoke((Object)this.cpds, new Integer(Integer.parseInt((String)properties.get(string))));
                }
            }
            this.username = configuration.getDatasourceUsername();
            this.password = configuration.getDatasourcePassword();
            this.maxSize = configuration.getNumberOfPooledConnections();
            this.msi = messageStoreImpl;
            this.instrument = messageStoreImpl._getInstrumentation();
            this.initializePool();
            this.disabledDatasourceWaitTimeout = 200L;
            this._state = 1;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.DefaultDatasourceWrapper", (String)"105", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught loading datasource class!", (Object)exception);
            }
            throw new MessageStoreRuntimeException("Cannot load datasource class", exception);
        }
        if (configuration.verbose()) {
            System.out.println(configuration);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnection(boolean bl) throws SQLException, DatasourceWrapperStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnection", (Object)("autoCommit=" + bl));
        }
        if (this._state == 2) {
            object = this;
            synchronized (object) {
                if (this._state == 2) {
                    try {
                        this.wait(this.disabledDatasourceWaitTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._state == 2) {
                        ConnectionUnavailableException connectionUnavailableException = new ConnectionUnavailableException("Connection cannot be provided as Datasource has been disabled!");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been disabled!", (Object)connectionUnavailableException);
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw connectionUnavailableException;
                    }
                    if (this._state == 0) {
                        DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw datasourceWrapperStateException;
                    }
                }
            }
        }
        object = this.getLockConnection(bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection", (Object)("return=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnection(boolean bl, long l) throws SQLException, DatasourceWrapperStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnection", (Object)("autoCommit=" + bl + ", timeOut=" + l));
        }
        if (this._state == 2) {
            object = this;
            synchronized (object) {
                if (this._state == 2) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._state == 2) {
                        ConnectionUnavailableException connectionUnavailableException = new ConnectionUnavailableException("Connection cannot be provided as Datasource has been disabled!");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been disabled!", (Object)connectionUnavailableException);
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw connectionUnavailableException;
                    }
                    if (this._state == 0) {
                        DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw datasourceWrapperStateException;
                    }
                }
            }
        }
        object = this.getLockConnection(bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection", (Object)("return=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getConnection(boolean bl, boolean bl2) throws SQLException, DatasourceWrapperStateException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConnection", (Object)("autoCommit=" + bl + ", useEnlistedConnections=" + bl2));
        }
        if (this._state == 2) {
            object = this;
            synchronized (object) {
                if (this._state == 2) {
                    try {
                        this.wait(this.disabledDatasourceWaitTimeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this._state == 2) {
                        ConnectionUnavailableException connectionUnavailableException = new ConnectionUnavailableException("Connection cannot be provided as Datasource has been disabled!");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been disabled!", (Object)connectionUnavailableException);
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw connectionUnavailableException;
                    }
                    if (this._state == 0) {
                        DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
                        if (tc.isEventEnabled()) {
                            SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
                        }
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"getConnection");
                        }
                        throw datasourceWrapperStateException;
                    }
                }
            }
        }
        object = this.getLockConnection(bl, bl2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConnection", (Object)("return=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionWrapper getLockConnection(boolean bl, boolean bl2) throws SQLException, DatasourceWrapperStateException {
        PooledConnection pooledConnection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLockConnection", (Object)("autoCommit=" + bl + ", useEnlistedConnections=" + bl2));
        }
        Statement statement = null;
        if (this._state == 0) {
            DatasourceWrapperStateException datasourceWrapperStateException = new DatasourceWrapperStateException("New connections cannot be provided because the persistence layer has been stopped");
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Connection cannot be provided as Datasource has been stopped!", (Object)((Object)datasourceWrapperStateException));
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLockConnection");
            }
            throw datasourceWrapperStateException;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.currentIndex > 0) {
                int n = this.currentIndex - 1;
                pooledConnection = this.pool[n];
                this.pool[n] = null;
                this.currentIndex = n;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Connection retrieved from pool", (Object)new Object[]{pooledConnection, new Integer(this.currentIndex)});
                }
            } else {
                pooledConnection = this.getNewPooledConnection();
                pooledConnection.addConnectionEventListener(this);
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"New connection created", (Object)pooledConnection);
                }
            }
        }
        Connection connection = pooledConnection.getConnection();
        connection.setAutoCommit(bl);
        connection.setTransactionIsolation(2);
        if (this.databaseVendor.lastIndexOf("ifx") != -1 || this.databaseVendor.lastIndexOf("Informix") != -1 || this.databaseVendor.lastIndexOf("INFORMIX") != -1) {
            try {
                statement = connection.createStatement();
                statement.execute("SET LOCK MODE TO WAIT");
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                block20: {
                    Object var10_11 = null;
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.getConnection", (String)"233", (Object)this);
                        if (!tc.isDebugEnabled()) break block20;
                        SibTr.debug((TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object)sQLException);
                    }
                }
                throw throwable;
            }
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.getConnection", (String)"233", (Object)this);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object)sQLException);
                }
            }
        }
        object = new ConnectionWrapper(this.instrument, connection, bl, false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLockConnection", (Object)("return=" + object));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(ConnectionEvent connectionEvent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connectionClosed", (Object)new Object[]{connectionEvent});
        }
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        Object object = this.lock;
        synchronized (object) {
            if (this.currentIndex < this.maxSize) {
                this.pool[this.currentIndex] = pooledConnection;
                ++this.currentIndex;
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Connection returned to pool", (Object)new Object[]{pooledConnection, new Integer(this.currentIndex)});
                }
            } else {
                try {
                    pooledConnection.removeConnectionEventListener(this);
                    pooledConnection.close();
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.connectionClosed", (String)"224", (Object)this);
                }
                if (tc.isEventEnabled()) {
                    SibTr.event((TraceComponent)tc, (String)"Connection closed", (Object)pooledConnection);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connectionClosed");
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"connectionErrorOccurred", (Object)new Object[]{connectionEvent});
        }
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        try {
            pooledConnection.removeConnectionEventListener(this);
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.connectionErrorOccurred", (String)"253", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"connectionErrorOccurred");
        }
    }

    public int getStaleConnectionRetryCount() {
        return 10;
    }

    public long getStaleConnectionRetryDelay() {
        return 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void stop(int n) {
        Object object;
        block25: {
            Statement statement;
            ConnectionWrapper connectionWrapper;
            block24: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"stop", (Object)("mode=" + n));
                }
                connectionWrapper = null;
                statement = null;
                if (this._state == 0) {
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"stop");
                    }
                    return;
                }
                connectionWrapper = this.getLockConnection(true, false);
                object = connectionWrapper.getMetaDataExtensions();
                String string = ((DatabaseMetaDataExtensions)object).getDBMS();
                if (string != "db2j" && string != "Derby") break block24;
                statement = connectionWrapper.createStatement();
                statement.executeUpdate(TableHelper.getCheckpointSql(string));
            }
            Object var7_8 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connectionWrapper != null) {
                    connectionWrapper.close();
                }
                break block25;
            }
            catch (Exception exception2) {}
            break block25;
            {
                catch (Exception exception) {
                    var7_8 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connectionWrapper != null) {
                            connectionWrapper.close();
                        }
                        break block25;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connectionWrapper != null) {
                        connectionWrapper.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this._state = 0;
        this.notifyAll();
        object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.currentIndex; ++i) {
                try {
                    this.pool[i].removeConnectionEventListener(this);
                    this.pool[i].close();
                    continue;
                }
                catch (SQLException sQLException) {
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.quiesce", (String)"279", (Object)this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void enable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"enable");
        }
        if (this._state == 2) {
            this._state = 1;
            this.notifyAll();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Datasource re-enabled for use by MessageStore.");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Datasource not enabled as it is not in a suitable state, " + this._state));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"enable");
        }
    }

    public synchronized void disable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"disable");
        }
        if (this._state == 1) {
            this._state = 2;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Datasource disabled for use by MessageStore.");
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Datasource not disabled as it is not in a suitable state, " + this._state));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"disable");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePool() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializePool");
        }
        this.pool = new PooledConnection[this.maxSize];
        for (int i = 0; i < this.maxSize; ++i) {
            this.pool[i] = this.getNewPooledConnection();
        }
        this.currentIndex = this.pool.length;
        if (tc.isEventEnabled()) {
            SibTr.event((TraceComponent)tc, (String)("Initialized " + this.currentIndex + " database connections."));
        }
        Connection connection = null;
        try {
            connection = this.pool[this.currentIndex - 1].getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.databaseVendor = databaseMetaData.getDatabaseProductName();
        }
        finally {
            connection.close();
        }
        for (int i = 0; i < this.maxSize; ++i) {
            this.pool[i].addConnectionEventListener(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializePool");
        }
    }

    private PooledConnection getNewPooledConnection() throws SQLException {
        PooledConnection pooledConnection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNewPooledConnection");
        }
        if (this.cpds == null) {
            throw new IllegalStateException("DataSource is not available");
        }
        try {
            if (this.username != null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("DataSource.getPooledConnection(" + this.username + ", *******)"));
                }
                pooledConnection = this.cpds.getPooledConnection(this.username, this.password);
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"DataSource.getPooledConnection()");
                }
                pooledConnection = this.cpds.getPooledConnection();
            }
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.DefaultDatasourceWrapper.getNewPooledConnection", (String)"148", (Object)this);
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught getting connection from Datasource!", (Object)sQLException);
            }
            throw sQLException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNewPooledConnection", (Object)pooledConnection);
        }
        return pooledConnection;
    }
}

