/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.persistence.impl.DatabaseMetaDataExtensions;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public final class ConnectionWrapper {
    public static final String $ssccid = "@(#) 1.27.1.2 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/persistence/impl/ConnectionWrapper.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/08/25 12:42:37 [3/13/06 13:59:37]";
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register((Class)ConnectionWrapper.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private final MSInstrumentation instrument;
    private final Connection connection;
    private final boolean autoCommit;
    private final boolean enlisted;
    private DatabaseMetaDataExtensions dmde;
    private boolean rollbackOnly;
    private boolean statementBatchingEnabled;

    public ConnectionWrapper(MSInstrumentation mSInstrumentation, Connection connection, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{mSInstrumentation, connection, new Boolean(bl), new Boolean(bl2)});
        }
        this.instrument = mSInstrumentation;
        this.connection = connection;
        this.autoCommit = bl;
        this.enlisted = bl2;
        this.statementBatchingEnabled = true;
        mSInstrumentation.increment(40);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public DatabaseMetaDataExtensions getMetaDataExtensions() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMetaDataExtensions");
        }
        if (this.dmde == null) {
            this.dmde = new DatabaseMetaDataExtensions(this.connection.getMetaData());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMetaDataExtensions", (Object)this.dmde);
        }
        return this.dmde;
    }

    public boolean getAutoCommit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAutoCommit");
            SibTr.exit((TraceComponent)tc, (String)"getAutoCommit", (Object)new Boolean(this.autoCommit));
        }
        return this.autoCommit;
    }

    public void setTransactionRollbackOnly() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTransactionRollbackOnly");
        }
        if (this.autoCommit) {
            throw new IllegalStateException(nls.getString("ROLLBACK_ONLY_EXCEPTION_SIMS1513"));
        }
        this.rollbackOnly = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionRollbackOnly");
        }
    }

    public void setStatementBatchingEnabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStatementBatchingEnabled", (Object)new Boolean(bl));
        }
        this.statementBatchingEnabled = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStatementBatchingEnabled");
        }
    }

    public boolean isStatementBatchingEnabled() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isStatementBatchingEnabled");
            SibTr.exit((TraceComponent)tc, (String)"isStatementBatchingEnabled", (Object)new Boolean(this.statementBatchingEnabled));
        }
        return this.statementBatchingEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"close");
        }
        try {
            if (!this.autoCommit && !this.enlisted) {
                if (!this.rollbackOnly) {
                    this.commit();
                } else {
                    try {
                        this.rollback();
                    }
                    catch (SQLException sQLException) {
                        FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper.close", (String)"1:204:1.27.1.2", (Object)this);
                    }
                }
            }
        }
        finally {
            this._close();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public Statement createStatement() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createStatement");
        }
        Statement statement = this.connection.createStatement();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createStatement", (Object)statement);
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepareStatement", (Object)new Object[]{string});
        }
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, boolean bl) throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepareStatement", (Object)new Object[]{string, new Integer(n), new Integer(n2), new Boolean(bl)});
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = bl ? this.connection.prepareStatement(string, n, n2) : this.connection.prepareStatement(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepareStatement", (Object)preparedStatement);
        }
        return preparedStatement;
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(Object object) {
        return this.connection.equals(object);
    }

    public String toString() {
        return this.connection.toString();
    }

    private void commit() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commit");
        }
        this.instrument.increment(41);
        this.connection.commit();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commit");
        }
    }

    private void rollback() throws SQLException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollback");
        }
        this.instrument.increment(42);
        this.connection.rollback();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollback");
        }
    }

    private void _close() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_close");
        }
        this.instrument.decrement(40);
        if (this.dmde != null) {
            this.dmde.close();
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_close");
        }
    }
}

