/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.persistence.SevereSQLException;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.msgstore.persistence.impl.BatchingAction;
import com.ibm.ws.sib.msgstore.persistence.impl.ConnectionWrapper;
import com.ibm.ws.sib.msgstore.persistence.impl.DatasourceController;
import com.ibm.ws.sib.msgstore.persistence.impl.PersistenceMap;
import com.ibm.ws.sib.msgstore.persistence.impl.TableManager;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class BatchingContextImpl
implements BatchingContext {
    public static final String $ssccid = "@(#) 1.17.4.1 SIB/ws/code/sib.msgstore.impl/src/com/ibm/ws/sib/msgstore/persistence/impl/BatchingContextImpl.java, SIB.msgstore.impl, WAS602.SIB, o0610.11 05/08/23 11:04:28 [3/13/06 13:59:33]";
    private static TraceComponent tc = SibTr.register((Class)BatchingContextImpl.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private PersistenceMap tuplesToInsert;
    private PersistenceMap tuplesToUpdateData;
    private PersistenceMap tuplesToUpdateLockID;
    private PersistenceMap tuplesToUpdateLogicalDelete;
    private PersistenceMap tuplesToDelete;
    private List xidLogEntriesToAdd;
    private List xidLogEntriesToCommitted;
    private List xidLogEntriesToRolledback;
    private List xidLogEntriesToDelete;
    private final DatasourceController controller;
    private final TableManager tableManager;
    private final MSInstrumentation instrument;
    private final int numberOfTables;
    private int capacity = 10;
    private int batchCount;
    private boolean useEnlistedConnections;
    private final BatchingAction execute = new BatchingAction(){

        public final void run(ConnectionWrapper connectionWrapper) throws SQLException, PersistenceException {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"run", (Object)new Object[]{connectionWrapper});
            }
            int n = 0;
            int n2 = 0;
            if (BatchingContextImpl.this.tuplesToInsert != null && !BatchingContextImpl.this.tuplesToInsert.isEmpty()) {
                BatchingContextImpl.this.tuplesToInsert.resetPosition();
                BatchingContextImpl.this.tableManager.insert(connectionWrapper, BatchingContextImpl.this.tuplesToInsert);
                BatchingContextImpl.this.instrument.increment(47, 1L);
            }
            if (BatchingContextImpl.this.tuplesToUpdateData != null && !BatchingContextImpl.this.tuplesToUpdateData.isEmpty()) {
                BatchingContextImpl.this.tuplesToUpdateData.resetPosition();
                BatchingContextImpl.this.tableManager.updateDataAndSize(connectionWrapper, BatchingContextImpl.this.tuplesToUpdateData);
                ++n;
            }
            if (BatchingContextImpl.this.tuplesToUpdateLockID != null && !BatchingContextImpl.this.tuplesToUpdateLockID.isEmpty()) {
                BatchingContextImpl.this.tuplesToUpdateLockID.resetPosition();
                BatchingContextImpl.this.tableManager.updateLockIDOnly(connectionWrapper, BatchingContextImpl.this.tuplesToUpdateLockID);
                ++n;
            }
            if (BatchingContextImpl.this.tuplesToUpdateLogicalDelete != null && !BatchingContextImpl.this.tuplesToUpdateLogicalDelete.isEmpty()) {
                BatchingContextImpl.this.tuplesToUpdateLogicalDelete.resetPosition();
                BatchingContextImpl.this.tableManager.updateLogicalDeleteAndXID(connectionWrapper, BatchingContextImpl.this.tuplesToUpdateLogicalDelete);
                ++n;
            }
            if (BatchingContextImpl.this.tuplesToDelete != null && !BatchingContextImpl.this.tuplesToDelete.isEmpty()) {
                BatchingContextImpl.this.tuplesToDelete.resetPosition();
                BatchingContextImpl.this.tableManager.delete(connectionWrapper, BatchingContextImpl.this.tuplesToDelete);
                BatchingContextImpl.this.instrument.increment(48, 1L);
            }
            if (BatchingContextImpl.this.xidLogEntriesToAdd != null && !BatchingContextImpl.this.xidLogEntriesToAdd.isEmpty()) {
                BatchingContextImpl.this.tableManager.addTransaction(connectionWrapper, BatchingContextImpl.this.xidLogEntriesToAdd);
                BatchingContextImpl.this.instrument.increment(53, 1L);
            }
            if (BatchingContextImpl.this.xidLogEntriesToCommitted != null && !BatchingContextImpl.this.xidLogEntriesToCommitted.isEmpty()) {
                BatchingContextImpl.this.tableManager.commitTransaction(connectionWrapper, BatchingContextImpl.this.xidLogEntriesToCommitted);
                ++n2;
            }
            if (BatchingContextImpl.this.xidLogEntriesToRolledback != null && !BatchingContextImpl.this.xidLogEntriesToRolledback.isEmpty()) {
                BatchingContextImpl.this.tableManager.rollbackTransaction(connectionWrapper, BatchingContextImpl.this.xidLogEntriesToRolledback);
                ++n2;
            }
            if (BatchingContextImpl.this.xidLogEntriesToDelete != null && !BatchingContextImpl.this.xidLogEntriesToDelete.isEmpty()) {
                BatchingContextImpl.this.tableManager.removeTransaction(connectionWrapper, BatchingContextImpl.this.xidLogEntriesToDelete);
                BatchingContextImpl.this.instrument.increment(54, 1L);
            }
            if (n != 0) {
                BatchingContextImpl.this.instrument.increment(49, n);
            }
            if (n2 != 0) {
                BatchingContextImpl.this.instrument.increment(55, n2);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"run");
            }
        }

        public final boolean useEnlistedConnections() {
            return BatchingContextImpl.this.useEnlistedConnections;
        }

        public final int getBatchCount() {
            return BatchingContextImpl.this.batchCount;
        }
    };

    protected BatchingContextImpl(MSInstrumentation mSInstrumentation, TableManager tableManager, DatasourceController datasourceController) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{mSInstrumentation, tableManager, datasourceController});
        }
        this.tableManager = tableManager;
        this.controller = datasourceController;
        this.instrument = mSInstrumentation;
        this.numberOfTables = tableManager.getNumberOfItemTables();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public void setCapacity(int n) {
        this.capacity = n;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setUseEnlistedConnections(boolean bl) {
        this.useEnlistedConnections = bl;
    }

    public void executeBatch() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"executeBatch");
        }
        long l = System.currentTimeMillis();
        try {
            try {
                this.controller.performAction(this.execute);
            }
            catch (SevereSQLException severeSQLException) {
                FFDCFilter.processException((Throwable)severeSQLException, (String)"com.ibm.ws.sib.msgstore.persistence.impl.BatchingContextImpl.executeBatch", (String)"1:269:1.17.4.1", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"SEVERE_PERSISTENCE_EXCEPTION_SIMS1504");
                throw new SeverePersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{severeSQLException}, severeSQLException);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.persistence.impl.BatchingContextImpl.executeBatch", (String)"1:276:1.17.4.1", (Object)this);
                throw new PersistenceException("DATASOURCE_EXCEPTION_SIMS1501", new Object[]{exception}, exception);
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            this.instrument.add(43, l3);
            throw throwable;
        }
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l;
        this.instrument.add(43, l5);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"executeBatch");
        }
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clear");
        }
        if (this.tuplesToInsert != null) {
            this.tuplesToInsert.clear();
        }
        if (this.tuplesToUpdateData != null) {
            this.tuplesToUpdateData.clear();
        }
        if (this.tuplesToUpdateLockID != null) {
            this.tuplesToUpdateLockID.clear();
        }
        if (this.tuplesToUpdateLogicalDelete != null) {
            this.tuplesToUpdateLogicalDelete.clear();
        }
        if (this.tuplesToDelete != null) {
            this.tuplesToDelete.clear();
        }
        if (this.xidLogEntriesToAdd != null) {
            this.xidLogEntriesToAdd.clear();
        }
        if (this.xidLogEntriesToCommitted != null) {
            this.xidLogEntriesToCommitted.clear();
        }
        if (this.xidLogEntriesToRolledback != null) {
            this.xidLogEntriesToRolledback.clear();
        }
        if (this.xidLogEntriesToDelete != null) {
            this.xidLogEntriesToDelete.clear();
        }
        this.batchCount = 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    public void insert(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"insert", (Object)new Object[]{persistable});
        }
        if (this.tuplesToInsert == null) {
            this.tuplesToInsert = new PersistenceMap(this.numberOfTables, this);
        }
        this.sortByItemTable((Tuple)persistable, this.tuplesToInsert);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"insert");
        }
    }

    public void updateDataAndSize(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateDataAndSize", (Object)new Object[]{persistable});
        }
        if (this.tuplesToUpdateData == null) {
            this.tuplesToUpdateData = new PersistenceMap(this.numberOfTables, this);
        }
        this.sortByItemTable((Tuple)persistable, this.tuplesToUpdateData);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateDataAndSize");
        }
    }

    public void updateLogicalDeleteAndXID(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLogicalDeleteAndXID", (Object)new Object[]{persistable});
        }
        if (this.tuplesToUpdateLogicalDelete == null) {
            this.tuplesToUpdateLogicalDelete = new PersistenceMap(this.numberOfTables, this);
        }
        this.sortByItemTable((Tuple)persistable, this.tuplesToUpdateLogicalDelete);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLogicalDeleteAndXID");
        }
    }

    public void updateLockIDOnly(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLockIDOnly", (Object)new Object[]{persistable});
        }
        if (this.tuplesToUpdateLockID == null) {
            this.tuplesToUpdateLockID = new PersistenceMap(this.numberOfTables, this);
        }
        this.sortByItemTable((Tuple)persistable, this.tuplesToUpdateLockID);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLockIDOnly");
        }
    }

    public void delete(Persistable persistable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete", (Object)new Object[]{persistable});
        }
        if (this.tuplesToDelete == null) {
            this.tuplesToDelete = new PersistenceMap(this.numberOfTables, this);
        }
        this.sortByItemTable((Tuple)persistable, this.tuplesToDelete);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete");
        }
    }

    public void addIndoubtXID(PersistentTranId persistentTranId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addIndoubtXID", (Object)new Object[]{persistentTranId});
        }
        if (this.xidLogEntriesToAdd == null) {
            this.xidLogEntriesToAdd = new ArrayList(this.capacity);
        }
        this.xidLogEntriesToAdd.add(persistentTranId);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addIndoubtXID");
        }
    }

    public void updateXIDToCommitted(PersistentTranId persistentTranId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateXIDToCommitted", (Object)new Object[]{persistentTranId});
        }
        if (this.xidLogEntriesToCommitted == null) {
            this.xidLogEntriesToCommitted = new ArrayList(this.capacity);
        }
        this.xidLogEntriesToCommitted.add(persistentTranId);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateXIDToCommitted");
        }
    }

    public void updateXIDToRolledback(PersistentTranId persistentTranId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateXIDToRolledback", (Object)new Object[]{persistentTranId});
        }
        if (this.xidLogEntriesToRolledback == null) {
            this.xidLogEntriesToRolledback = new ArrayList(this.capacity);
        }
        this.xidLogEntriesToRolledback.add(persistentTranId);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateXIDToRolledback");
        }
    }

    public void deleteXID(PersistentTranId persistentTranId) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteIndoubtXID", (Object)new Object[]{persistentTranId});
        }
        if (this.xidLogEntriesToDelete == null) {
            this.xidLogEntriesToDelete = new ArrayList(this.capacity);
        }
        this.xidLogEntriesToDelete.add(persistentTranId);
        ++this.batchCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteIndoubtXID");
        }
    }

    private void sortByItemTable(Tuple tuple, PersistenceMap persistenceMap) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sortByItemTable", (Object)new Object[]{tuple, persistenceMap});
        }
        TupleTypeEnum tupleTypeEnum = tuple.getTupleType();
        int n = tuple.getStorageStrategy();
        int n2 = -1;
        if (tupleTypeEnum == TupleTypeEnum.ITEM || tupleTypeEnum == TupleTypeEnum.ITEM_REFERENCE) {
            Tuple tuple2 = (Tuple)tuple.getContainingStream();
            int n3 = tuple2.getTemporaryTableId();
            int n4 = tuple2.getPermanentTableId();
            String string = tuple2.getItemClassName();
            if (n4 == -1) {
                n4 = this.tableManager.nextKeyForPermanentTable(string);
                tuple2.setPermanentTableId(n4);
            }
            if (n3 == -1) {
                n3 = this.tableManager.nextKeyForTemporaryTable(string);
                tuple2.setTemporaryTableId(n3);
            }
            n2 = n == 2 ? n3 : n4;
        } else if (tupleTypeEnum == TupleTypeEnum.REFERENCE_STREAM) {
            String string;
            Tuple tuple3 = (Tuple)tuple.getContainingStream();
            int n5 = tuple.getTemporaryTableId();
            int n6 = tuple.getPermanentTableId();
            if (n6 == -1) {
                n6 = tuple3.getPermanentTableId();
                string = tuple3.getItemClassName();
                if (n6 == -1) {
                    n6 = this.tableManager.nextKeyForPermanentTable(string);
                    tuple3.setPermanentTableId(n6);
                }
                tuple.setPermanentTableId(n6);
            }
            if (n5 == -1) {
                n5 = tuple3.getTemporaryTableId();
                string = tuple3.getItemClassName();
                if (n5 == -1) {
                    n5 = this.tableManager.nextKeyForTemporaryTable(string);
                    tuple3.setTemporaryTableId(n5);
                }
                tuple.setTemporaryTableId(n5);
            }
            n2 = this.tableManager.nextKeyForStreamTable();
        } else {
            int n7 = tuple.getTemporaryTableId();
            int n8 = tuple.getPermanentTableId();
            String string = tuple.getItemClassName();
            if (n8 == -1) {
                n8 = this.tableManager.nextKeyForPermanentTable(string);
                tuple.setPermanentTableId(n8);
            }
            if (n7 == -1) {
                n7 = this.tableManager.nextKeyForTemporaryTable(string);
                tuple.setTemporaryTableId(n7);
            }
            n2 = this.tableManager.nextKeyForStreamTable();
        }
        persistenceMap.set(n2, tuple);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sortByItemTable");
        }
    }
}

