/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class TaskMap {
    private static TraceComponent tc = SibTr.register((Class)TaskMap.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private HashMap _map = new HashMap();

    public boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty");
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Boolean(this._map.isEmpty()));
        }
        return this._map.isEmpty();
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clear");
        }
        this._map.clear();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    public int size() {
        return this._map.size();
    }

    public Task getFirst(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirst", (Object)new Long(l));
        }
        Task task = null;
        Object v = this._map.get(new Long(l));
        if (v != null) {
            if (v instanceof Task) {
                task = (Task)v;
            } else {
                LinkedList linkedList = (LinkedList)v;
                task = (Task)linkedList.getFirst();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFirst", (Object)task);
        }
        return task;
    }

    public void put(long l, Task task) {
        Long l2;
        Object v;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{new Long(l), task});
        }
        if ((v = this._map.get(l2 = new Long(l))) == null) {
            this._map.put(l2, task);
        } else if (v instanceof Task) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(v);
            linkedList.add(task);
            this._map.put(l2, linkedList);
        } else {
            LinkedList linkedList = (LinkedList)v;
            linkedList.add(task);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put");
        }
    }

    public void remove(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Long(l));
        }
        this._map.remove(new Long(l));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public long persist(BatchingContext batchingContext, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, new Integer(n)});
        }
        long l = 0L;
        if (!this._map.isEmpty()) {
            Iterator iterator = this._map.values().iterator();
            while (iterator.hasNext()) {
                Object object;
                Object v = iterator.next();
                if (v instanceof Task) {
                    object = (Task)v;
                    object.persist(batchingContext, n);
                    if (!((Task)object).isCreateOfPersistentRepresentation()) continue;
                    l += (long)((Task)object).getPersistable().getPersistentSize();
                    continue;
                }
                object = ((LinkedList)v).iterator();
                while (object.hasNext()) {
                    Task task = (Task)object.next();
                    task.persist(batchingContext, n);
                    if (!task.isCreateOfPersistentRepresentation()) continue;
                    l += (long)task.getPersistable().getPersistentSize();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persist", (Object)new Long(l));
        }
        return l;
    }

    public String toString() {
        return this._map.toString();
    }
}

