/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.Batch;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchUnit;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class PersistentDispatcherQueue {
    private static TraceComponent tc = SibTr.register((Class)PersistentDispatcherQueue.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private DispatchUnit _head;
    private DispatchUnit _tail;
    private int _size;
    private DispatchUnit _dispatchCursor;
    private long _persistentSize;
    private HashMap _idIndex;
    private HashMap _tranidIndex;
    private MSInstrumentation _instrument;

    public PersistentDispatcherQueue(MessageStoreImpl messageStoreImpl) {
        if (messageStoreImpl != null) {
            this._instrument = messageStoreImpl._getInstrumentation();
        }
        this._head = null;
        this._tail = null;
        this._size = 0;
        this._dispatchCursor = null;
        this._idIndex = new HashMap();
        this._tranidIndex = new HashMap();
    }

    public void add(DispatchUnit dispatchUnit) {
        PersistentTranId persistentTranId;
        Object v;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)dispatchUnit);
        }
        if ((v = this._tranidIndex.get(persistentTranId = dispatchUnit.getTranId())) != null) {
            DispatchUnit dispatchUnit2 = (DispatchUnit)v;
            if (!dispatchUnit2.isAssigned()) {
                if (dispatchUnit.getTransactionState() == 14) {
                    dispatchUnit2.setTransactionState(13);
                    dispatchUnit.setTransactionState(15);
                    dispatchUnit.setExcludedFromConflictChecks(true);
                } else {
                    dispatchUnit2.setTransactionState(17);
                    this.removeDUFromIdIndex(dispatchUnit2);
                    dispatchUnit2.setDispatchable(true);
                    dispatchUnit2.setExcludedFromConflictChecks(true);
                    dispatchUnit.setTransactionState(17);
                    dispatchUnit.setExcludedFromConflictChecks(true);
                }
                if (this._instrument != null) {
                    this._instrument.increment(29);
                }
            }
        } else {
            this._tranidIndex.put(persistentTranId, dispatchUnit);
        }
        if (!dispatchUnit.isExcludedFromConflictChecks()) {
            this.addDUToIdIndex(dispatchUnit);
        }
        if (this._tail == null) {
            this._head = dispatchUnit;
            this._tail = dispatchUnit;
            this._dispatchCursor = dispatchUnit;
        } else {
            dispatchUnit._previous = this._tail;
            this._tail._next = dispatchUnit;
            this._tail = dispatchUnit;
            if (this._dispatchCursor == null) {
                this._dispatchCursor = dispatchUnit;
            }
        }
        ++this._size;
        this._persistentSize += dispatchUnit.getPersistentSize();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add");
        }
    }

    public void remove(DispatchUnit dispatchUnit) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)dispatchUnit);
        }
        if (!dispatchUnit.isExcludedFromConflictChecks()) {
            this.removeDUFromIdIndex(dispatchUnit);
        }
        this._tranidIndex.remove(dispatchUnit.getTranId());
        if (dispatchUnit._next != null) {
            dispatchUnit._next._previous = dispatchUnit._previous;
        } else {
            this._tail = dispatchUnit._previous;
        }
        if (dispatchUnit._previous != null) {
            dispatchUnit._previous._next = dispatchUnit._next;
        } else {
            this._head = dispatchUnit._next;
        }
        --this._size;
        if (this._dispatchCursor == dispatchUnit) {
            this._dispatchCursor = dispatchUnit._next;
        }
        dispatchUnit._next = null;
        dispatchUnit._previous = null;
        this._persistentSize -= dispatchUnit.getPersistentSize();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public long getPersistentSize() {
        return this._persistentSize;
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._head == null;
    }

    public DispatchUnit getFirstDispatchable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getFirstDispatchable");
        }
        DispatchUnit dispatchUnit = null;
        if (this._dispatchCursor != null) {
            DispatchUnit dispatchUnit2 = this._dispatchCursor;
            boolean bl = true;
            while (dispatchUnit2 != null && dispatchUnit == null) {
                if (bl) {
                    if (dispatchUnit2.isAssigned()) {
                        this._dispatchCursor = dispatchUnit2._next;
                    } else {
                        bl = false;
                    }
                }
                if (dispatchUnit2.isDispatchable() && !dispatchUnit2.isAssigned()) {
                    dispatchUnit = dispatchUnit2;
                }
                dispatchUnit2 = dispatchUnit2._next;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getFirstDispatchable", dispatchUnit);
        }
        return dispatchUnit;
    }

    public boolean buildBatch(Batch batch, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"buildBatch", (Object)new Object[]{"batch", new Integer(n), new Integer(n2)});
        }
        boolean bl = true;
        int n3 = 0;
        batch.clear();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Queue", (Object)this);
        }
        if (this._dispatchCursor != null) {
            DispatchUnit dispatchUnit = this._dispatchCursor;
            while (dispatchUnit != null && n3 < n2) {
                if (bl) {
                    if (!dispatchUnit.isAssigned() && dispatchUnit.isDispatchable()) {
                        bl = false;
                        batch.add(dispatchUnit, true);
                        dispatchUnit.assignToThread(n);
                        ++n3;
                        if (dispatchUnit.hasPreferredOptimisations()) {
                            n3 = this.buildBatchUsingPreferredOptimisations(batch, n, n3, dispatchUnit, n2);
                        }
                    }
                } else if (!dispatchUnit.isAssigned() && (dispatchUnit.isDispatchable() || this.isDispatchableWithConflict(dispatchUnit, n)) && batch.add(dispatchUnit, true)) {
                    dispatchUnit.assignToThread(n);
                    ++n3;
                    if (dispatchUnit.hasPreferredOptimisations()) {
                        n3 = this.buildBatchUsingPreferredOptimisations(batch, n, n3, dispatchUnit, n2);
                    }
                }
                if (this._dispatchCursor == dispatchUnit && dispatchUnit.isAssigned()) {
                    this._dispatchCursor = dispatchUnit._next;
                }
                dispatchUnit = dispatchUnit._next;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"buildBatch", (Object)new Boolean(!bl));
        }
        return !bl;
    }

    private int buildBatchUsingPreferredOptimisations(Batch batch, int n, int n2, DispatchUnit dispatchUnit, int n3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"buildBatchUsingPreferredOptimisations", (Object)new Object[]{batch, new Integer(n), new Integer(n2), dispatchUnit, new Integer(n3)});
        }
        Object[] objectArray = dispatchUnit.getPreferredOptimisations();
        for (int i = 0; i < objectArray.length; ++i) {
            DispatchUnit dispatchUnit2 = (DispatchUnit)objectArray[i];
            if (dispatchUnit2.isAssigned() || !dispatchUnit2.isCommittedSingletonDeletion() || !batch.add(dispatchUnit2, false)) continue;
            dispatchUnit2.assignToThread(n);
            ++n2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"buildBatchUsingPreferredOptimisations", (Object)new Integer(n2));
        }
        return n2;
    }

    public void confirmBatch(Batch batch) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"confirmBatch", (Object)batch);
        }
        Iterator iterator = batch.iterator();
        while (iterator.hasNext()) {
            DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
            this.remove(dispatchUnit);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"confirmBatch");
        }
    }

    private boolean isDispatchableWithConflict(DispatchUnit dispatchUnit, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isDispatchableWithConflict", (Object)new Object[]{dispatchUnit, new Integer(n)});
        }
        boolean bl = true;
        if (dispatchUnit.isAssigned()) {
            bl = false;
        } else if (!dispatchUnit.isDispatchable()) {
            Collection collection = dispatchUnit.getTasks();
            Iterator iterator = collection.iterator();
            int n2 = dispatchUnit.getConflictCount();
            while (iterator.hasNext() && n2 > 0 && bl) {
                Task task = (Task)iterator.next();
                long l = task.getPersistable().getUniqueId();
                Long l2 = new Long(l);
                Object v = this._idIndex.get(l2);
                if (v == null || v instanceof DispatchUnit) continue;
                LinkedList linkedList = (LinkedList)v;
                int n3 = linkedList.indexOf(dispatchUnit);
                for (int i = 0; i < n3 && bl; ++i) {
                    DispatchUnit dispatchUnit2 = (DispatchUnit)linkedList.get(i);
                    if (dispatchUnit2.isAssignedToThread(n)) continue;
                    bl = false;
                }
                --n2;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isDispatchableWithConflict", (Object)new Boolean(bl));
        }
        return bl;
    }

    private boolean addDUToIdIndex(DispatchUnit dispatchUnit) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addDUToIdIndex", (Object)dispatchUnit);
        }
        boolean bl = false;
        Collection collection = dispatchUnit.getTasks();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            LinkedList<Object> linkedList;
            Task task = (Task)iterator.next();
            long l = task.getPersistable().getUniqueId();
            Long l2 = new Long(l);
            Object v = this._idIndex.get(l2);
            if (v == null) {
                this._idIndex.put(l2, dispatchUnit);
                continue;
            }
            bl = true;
            if (v instanceof DispatchUnit) {
                if (v == dispatchUnit) continue;
                linkedList = new LinkedList<Object>();
                linkedList.add(v);
                linkedList.add(dispatchUnit);
                this._idIndex.put(l2, linkedList);
                dispatchUnit.conflictForId(l);
                if (!dispatchUnit.isSingletonDeletion()) continue;
                DispatchUnit dispatchUnit2 = (DispatchUnit)v;
                dispatchUnit2.addPreferredOptimisation(dispatchUnit);
                continue;
            }
            linkedList = (LinkedList<Object>)v;
            if (linkedList.getLast() == dispatchUnit) continue;
            linkedList.add(dispatchUnit);
            dispatchUnit.conflictForId(l);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addDUToIdIndex", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void removeDUFromIdIndex(DispatchUnit dispatchUnit) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeDUFromIdIndex", (Object)dispatchUnit);
        }
        Collection collection = dispatchUnit.getTasks();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DispatchUnit dispatchUnit2;
            Task task = (Task)iterator.next();
            long l = task.getPersistable().getUniqueId();
            Long l2 = new Long(l);
            Object v = this._idIndex.remove(l2);
            if (v == null || !(v instanceof LinkedList)) continue;
            LinkedList linkedList = (LinkedList)v;
            int n = linkedList.indexOf(dispatchUnit);
            if (n == 0) {
                if (linkedList.size() == 2) {
                    dispatchUnit2 = (DispatchUnit)linkedList.getLast();
                    this._idIndex.put(l2, dispatchUnit2);
                    dispatchUnit2.noConflictForId(l);
                    continue;
                }
                linkedList.removeFirst();
                this._idIndex.put(l2, linkedList);
                dispatchUnit2 = (DispatchUnit)linkedList.getFirst();
                dispatchUnit2.noConflictForId(l);
                continue;
            }
            if (n == -1) continue;
            if (linkedList.size() == 2) {
                dispatchUnit2 = (DispatchUnit)linkedList.getFirst();
                this._idIndex.put(l2, dispatchUnit2);
                continue;
            }
            linkedList.remove(n);
            this._idIndex.put(l2, linkedList);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeDUFromIdIndex");
        }
    }

    public void unassignBatchedWork(Batch batch) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unassignBatchedWork");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Queue", (Object)this);
        }
        if (bl = batch.unassignBatchedWork()) {
            this._dispatchCursor = this._head;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unassignBatchedWork");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._head == null) {
            stringBuffer.append("Empty dispatch queue\n");
        } else {
            stringBuffer.append("Dispatch queue: persistent size " + this._persistentSize + "\n\n");
            DispatchUnit dispatchUnit = this._head;
            while (dispatchUnit != null) {
                if (this._dispatchCursor == dispatchUnit) {
                    stringBuffer.append("<<CURSOR>> ");
                }
                stringBuffer.append(dispatchUnit);
                stringBuffer.append("\n");
                dispatchUnit = dispatchUnit._next;
            }
            if (this._dispatchCursor == null) {
                stringBuffer.append("Cursor past tail\n");
            }
            stringBuffer.append("End of dispatch queue\n");
        }
        return stringBuffer.toString();
    }
}

