/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.BatchingContextFactory;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.Batch;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchNotifier;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchUnit;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatcherBase;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.PersistentDispatcherQueue;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PersistentDispatcher
extends DispatcherBase {
    private static TraceComponent tc = SibTr.register((Class)PersistentDispatcher.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _maxBytesPerBatch;
    private int _maxTasksPerBatch;
    private int _maxPendingDispatchRequests;
    private long _maxDispatchedBytes;
    public static final int WRITES_TO_RESET_ERROR_STATE = 16;
    private int _maxThreads;
    private int _numThreads;
    private MessageStoreImpl _msi;
    private Thread[] _threads;
    private PersistentDispatcherThread[] _workers;
    private int _threadsAsleep;
    private int _threadsActive;
    private int _threadsAssigned;
    private boolean _notifyOutstanding;
    private ArrayList _waitingQueue;
    private PersistentDispatcherQueue _dispatchQueue;
    private Object _dispatchingLock;
    private BatchingContextFactory _bcfactory;
    private MSInstrumentation _instrument;
    private boolean _stopRequested = false;
    private int _stopMode = 0;
    private boolean _running = false;
    private int _threadWriteErrorsOutstanding = 0;

    public PersistentDispatcher(MessageStoreImpl messageStoreImpl, BatchingContextFactory batchingContextFactory) {
        this(messageStoreImpl, batchingContextFactory, PersistentDispatcher.obtainIntConfigParameter(messageStoreImpl, "jdbcWriteThreads", "8", 1, 32));
    }

    public PersistentDispatcher(MessageStoreImpl messageStoreImpl, BatchingContextFactory batchingContextFactory, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{messageStoreImpl, batchingContextFactory, new Integer(n)});
        }
        this._msi = messageStoreImpl;
        if (this._msi != null) {
            this._instrument = this._msi._getInstrumentation();
        }
        this._bcfactory = batchingContextFactory;
        this._waitingQueue = new ArrayList();
        this._dispatchQueue = new PersistentDispatcherQueue(this._msi);
        this._dispatchingLock = new Object();
        this._maxThreads = n;
        this._maxBytesPerBatch = PersistentDispatcher.obtainLongConfigParameter(this._msi, "jdbcWriteMaxBytesPerBatch", "1000000", 100000L, 100000000L);
        this._maxTasksPerBatch = PersistentDispatcher.obtainIntConfigParameter(this._msi, "jdbcWriteMaxTasksPerBatch", "64", 1, 10000);
        this._maxDispatchedBytes = PersistentDispatcher.obtainLongConfigParameter(this._msi, "jdbcWriteMaxDispatchedBytes", "20000000", 1L, 100000000L);
        int n2 = PersistentDispatcher.obtainIntConfigParameter(this._msi, "jdbcWriteRate", "80", 1, 10000);
        long l = PersistentDispatcher.obtainLongConfigParameter(this._msi, "jdbcWriteTargetLatencyMillis", "1000", 0L, 30000L);
        this._maxPendingDispatchRequests = (int)((long)(this._maxThreads * n2) * l / 1000L);
        if (this._maxPendingDispatchRequests < this._maxThreads) {
            this._maxPendingDispatchRequests = this._maxThreads;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("max pending dispatch requests = " + this._maxPendingDispatchRequests));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>");
        }
    }

    public boolean isFullOfHealth() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isFullOfHealth");
        }
        boolean bl2 = bl = this._running && !this._stopRequested && this._threadWriteErrorsOutstanding == 0;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isFullOfHealth", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(Collection collection, PersistentTransaction persistentTransaction, boolean bl) throws PersistenceException {
        boolean bl2;
        block21: {
            block22: {
                Iterator iterator;
                if (tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatch", (Object)new Object[]{collection, persistentTransaction, new Boolean(bl)});
                }
                bl2 = true;
                int n = 0;
                boolean bl3 = this.isFullOfHealth();
                if (!bl3 && bl) break block22;
                if (collection != null) {
                    n = collection.size();
                    Iterator iterator2 = collection.iterator();
                    while (iterator2.hasNext()) {
                        Task task = (Task)iterator2.next();
                        task.ensureDataAvailable();
                        ((Tuple)task.getPersistable()).persistableOperationBegun();
                    }
                }
                boolean bl4 = false;
                boolean bl5 = false;
                try {
                    long l = System.currentTimeMillis();
                    DispatchNotifier dispatchNotifier = new DispatchNotifier(1, bl);
                    DispatchUnit dispatchUnit = new DispatchUnit(collection, persistentTransaction, l, dispatchNotifier);
                    Object object = this._dispatchingLock;
                    synchronized (object) {
                        bl3 = this.isFullOfHealth();
                        if (bl3 || !bl) {
                            if (this._waitingQueue.isEmpty() && (this._dispatchQueue.isEmpty() || this._dispatchQueue.size() < this._maxPendingDispatchRequests && this._dispatchQueue.getPersistentSize() + dispatchUnit.getPersistentSize() <= this._maxDispatchedBytes)) {
                                this._dispatchQueue.add(dispatchUnit);
                            } else {
                                this._waitingQueue.add(dispatchUnit);
                                bl4 = bl3;
                            }
                            this.notifyWorkers();
                        } else {
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        if (bl4) {
                            dispatchNotifier.waitForDispatch();
                        }
                        if (this._instrument != null) {
                            this._instrument.add(27, l, n);
                        }
                        bl5 = true;
                    }
                    Object var16_17 = null;
                    if (bl5) break block21;
                    iterator = collection.iterator();
                }
                catch (Throwable throwable) {
                    Object var16_18 = null;
                    if (!bl5) {
                        Iterator iterator3 = collection.iterator();
                        while (iterator3.hasNext()) {
                            Task task = (Task)iterator3.next();
                            ((Tuple)task.getPersistable()).persistableOperationCancelled();
                        }
                    }
                    throw throwable;
                }
                while (iterator.hasNext()) {
                    Task task = (Task)iterator.next();
                    ((Tuple)task.getPersistable()).persistableOperationCancelled();
                }
                break block21;
            }
            bl2 = false;
        }
        if (!bl2) {
            PersistenceException persistenceException = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
            if (tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"The dispatcher cannot accept work.", (Object)((Object)persistenceException));
            }
            throw persistenceException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatch");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start");
        }
        int n = PersistentDispatcher.obtainIntConfigParameter(this._msi, "jdbcWriteThreadPriorityDelta", "0", -4, 5);
        this._threads = new Thread[this._maxThreads];
        this._workers = new PersistentDispatcherThread[this._maxThreads];
        this._threadsAsleep = 0;
        this._threadsActive = 0;
        this._threadsAssigned = 0;
        this._notifyOutstanding = false;
        this._stopRequested = false;
        this._running = true;
        for (int i = 0; i < this._maxThreads; ++i) {
            this._workers[i] = new PersistentDispatcherThread(i);
            this._threads[i] = new Thread((Runnable)this._workers[i], "sib.PersistentDispatcher-" + i);
            this._threads[i].setDaemon(true);
            this._threads[i].setPriority(5 + n);
            this._threads[i].start();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"stop", (Object)new Integer(n));
        }
        boolean bl = false;
        Object object = this._dispatchingLock;
        synchronized (object) {
            if (this._threadWriteErrorsOutstanding > 0 && n != 1 && !this._dispatchQueue.isEmpty()) {
                n = 1;
            }
            if (this._running && !this._stopRequested) {
                bl = true;
                this._stopRequested = true;
                this._stopMode = n;
                for (int i = 0; i < this._maxThreads; ++i) {
                    if (!this._workers[i].isInterruptible()) continue;
                    this._threads[i].interrupt();
                }
                if (n != 1) {
                    this.notifyWorkers();
                } else {
                    this._dispatchingLock.notifyAll();
                }
            }
        }
        if (bl) {
            long l = System.currentTimeMillis() + 60000L;
            for (int i = 0; i < this._maxThreads; ++i) {
                long l2 = l - System.currentTimeMillis();
                if (l2 <= 0L) {
                    l2 = 1L;
                }
                try {
                    if (this._threads[i] == null) continue;
                    this._threads[i].join(l2);
                    if (!this._threads[i].isAlive() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)("Cannot join dispatcher thread " + this._workers[i]));
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this._dispatchQueue.isEmpty() && this._msi != null && this._msi._getMessagingEngine() != null) {
                SibTr.warning((TraceComponent)tc, (String)"RELIABLE_PERSISTENT_DATA_LOST_SIMS1517", (Object)new Object[]{this._msi._getMessagingEngine().getName()});
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"stop");
        }
    }

    public synchronized void threadWriteErrorOccurred(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"threadWriteErrorOccurred", (Object)new Integer(n));
        }
        ++this._threadWriteErrorsOutstanding;
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"threadWriteErrorOccurred");
        }
    }

    public synchronized void threadWriteErrorCleared(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"threadWriteErrorCleared", (Object)new Integer(n));
        }
        if (this._threadWriteErrorsOutstanding > 0) {
            --this._threadWriteErrorsOutstanding;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"threadWriteErrorCleared");
        }
    }

    private void notifyWorkers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyWorkers");
        }
        if (this._threadsActive < this._maxThreads && this._threadsAssigned == this._threadsActive && !this._notifyOutstanding) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Notifying worker", (Object)this);
            }
            this._notifyOutstanding = true;
            this._dispatchingLock.notify();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyWorkers");
        }
    }

    public String toString() {
        return super.toString() + (this._stopRequested ? " (STOP REQUESTED)" : "") + (!this._running ? " (STOPPED)" : "") + (this._threadWriteErrorsOutstanding > 0 ? " (ERROR)" : "");
    }

    private class PersistentDispatcherThread
    implements Runnable {
        private int _threadNum;
        private String _threadName;
        private boolean _writeErrorOccurred = false;
        private int _goodWritesSinceLastError = 0;
        private int _consecutiveWriteErrors = 0;
        private boolean _isContributingToThreadWriteErrors = false;
        private long _writeErrorRetryDelay;
        private boolean _interruptible = false;

        PersistentDispatcherThread(int n) {
            this._threadNum = n;
            this._threadName = "sib.PersistentDispatcher-" + n;
            PersistentDispatcher.this._numThreads++;
            PersistentDispatcher.this._threadsActive++;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            if (PersistentDispatcher.this._msi != null && PersistentDispatcher.this._msi._getMessagingEngine() != null) {
                SibTr.push((Object)PersistentDispatcher.this._msi._getMessagingEngine());
            }
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            Batch batch = new Batch(PersistentDispatcher.this._maxTasksPerBatch, PersistentDispatcher.this._maxBytesPerBatch);
            BatchingContext batchingContext = PersistentDispatcher.this._bcfactory.createBatchingContext();
            boolean bl = false;
            boolean bl2 = false;
            int n = PersistentDispatcher.this._maxTasksPerBatch;
            boolean bl3 = true;
            try {
                while (!bl2) {
                    Object object = PersistentDispatcher.this._dispatchingLock;
                    synchronized (object) {
                        if (PersistentDispatcher.this._stopRequested && (PersistentDispatcher.this._dispatchQueue.isEmpty() && PersistentDispatcher.this._waitingQueue.isEmpty() || PersistentDispatcher.this._stopMode == 1)) {
                            bl2 = true;
                        }
                        while (!bl && !bl2) {
                            block57: {
                                this.promoteWaiters();
                                if (batch.isEmpty()) {
                                    bl = PersistentDispatcher.this._dispatchQueue.buildBatch(batch, this._threadNum, n);
                                    if (bl) {
                                        PersistentDispatcher.this._threadsAssigned++;
                                    }
                                    if (PersistentDispatcher.this._dispatchQueue.getFirstDispatchable() != null) {
                                        PersistentDispatcher.this.notifyWorkers();
                                    }
                                } else {
                                    bl = true;
                                }
                                if (!bl) {
                                    Object var10_10;
                                    PersistentDispatcher.this._threadsActive--;
                                    bl3 = false;
                                    try {
                                        PersistentDispatcher.this._dispatchingLock.wait(0L);
                                        var10_10 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var10_10 = null;
                                        PersistentDispatcher.this._notifyOutstanding = false;
                                        PersistentDispatcher.this._threadsActive++;
                                        bl3 = true;
                                        throw throwable;
                                    }
                                    PersistentDispatcher.this._notifyOutstanding = false;
                                    PersistentDispatcher.this._threadsActive++;
                                    bl3 = true;
                                    {
                                        break block57;
                                        catch (InterruptedException interruptedException) {
                                            var10_10 = null;
                                            PersistentDispatcher.this._notifyOutstanding = false;
                                            PersistentDispatcher.this._threadsActive++;
                                            bl3 = true;
                                        }
                                    }
                                }
                            }
                            if (!PersistentDispatcher.this._stopRequested || (!PersistentDispatcher.this._dispatchQueue.isEmpty() || !PersistentDispatcher.this._waitingQueue.isEmpty()) && PersistentDispatcher.this._stopMode != 1) continue;
                            bl2 = true;
                        }
                    }
                    if (!PersistentDispatcher.this._stopRequested && this._writeErrorOccurred && this._consecutiveWriteErrors > 1) {
                        Object object2;
                        Object var14_11;
                        object = PersistentDispatcher.this._dispatchingLock;
                        synchronized (object) {
                            this._interruptible = true;
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Dispatcher started retry wait of " + this._writeErrorRetryDelay + " ms"), (Object)this);
                        }
                        try {
                            block58: {
                                Thread.sleep(this._writeErrorRetryDelay);
                                if (!tc.isDebugEnabled()) break block58;
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dispatcher completed wait", (Object)this);
                            }
                            var14_11 = null;
                        }
                        catch (Throwable throwable) {
                            var14_11 = null;
                            object2 = PersistentDispatcher.this._dispatchingLock;
                            synchronized (object2) {
                                this._interruptible = false;
                            }
                            throw throwable;
                        }
                        object2 = PersistentDispatcher.this._dispatchingLock;
                        synchronized (object2) {
                            this._interruptible = false;
                        }
                        {
                            catch (InterruptedException interruptedException) {
                                if (tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Dispatcher interrupted during wait", (Object)this);
                                }
                                var14_11 = null;
                                object2 = PersistentDispatcher.this._dispatchingLock;
                                synchronized (object2) {
                                    this._interruptible = false;
                                }
                            }
                        }
                    }
                    if (bl2 || !bl) continue;
                    if (batch.persist(batchingContext, PersistentDispatcher.this._instrument)) {
                        this.confirmBatchCompleted(batch);
                        bl = false;
                        if (!this._writeErrorOccurred) continue;
                        this._consecutiveWriteErrors = 0;
                        ++this._goodWritesSinceLastError;
                        if (this._isContributingToThreadWriteErrors) {
                            this._isContributingToThreadWriteErrors = false;
                            PersistentDispatcher.this.threadWriteErrorCleared(this._threadNum);
                        }
                        if (this._goodWritesSinceLastError <= 16) continue;
                        this._writeErrorOccurred = false;
                        n = PersistentDispatcher.this._maxTasksPerBatch;
                        continue;
                    }
                    bl2 = this.handleWriteError(batch);
                    n = 1;
                }
                Object var18_20 = null;
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                Object object = PersistentDispatcher.this._dispatchingLock;
                synchronized (object) {
                    if (bl3) {
                        PersistentDispatcher.this._threadsActive--;
                    }
                    PersistentDispatcher.this._numThreads--;
                    if (PersistentDispatcher.this._stopRequested) {
                        if (PersistentDispatcher.this._threadsActive < PersistentDispatcher.this._numThreads) {
                            PersistentDispatcher.this._dispatchingLock.notifyAll();
                        }
                    } else if (PersistentDispatcher.this._msi != null) {
                        PersistentDispatcher.this._msi.reportLocalError();
                    }
                    if (PersistentDispatcher.this._numThreads == 0) {
                        PersistentDispatcher.this._running = false;
                    }
                }
                throw throwable;
            }
            Object object = PersistentDispatcher.this._dispatchingLock;
            synchronized (object) {
                if (bl3) {
                    PersistentDispatcher.this._threadsActive--;
                }
                PersistentDispatcher.this._numThreads--;
                if (PersistentDispatcher.this._stopRequested) {
                    if (PersistentDispatcher.this._threadsActive < PersistentDispatcher.this._numThreads) {
                        PersistentDispatcher.this._dispatchingLock.notifyAll();
                    }
                } else if (PersistentDispatcher.this._msi != null) {
                    PersistentDispatcher.this._msi.reportLocalError();
                }
                if (PersistentDispatcher.this._numThreads == 0) {
                    PersistentDispatcher.this._running = false;
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
            if (PersistentDispatcher.this._msi != null && PersistentDispatcher.this._msi._getMessagingEngine() != null) {
                SibTr.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void confirmBatchCompleted(Batch batch) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"confirmBatchCompleted", (Object)batch);
            }
            batch.confirmDispatch();
            Object object = PersistentDispatcher.this._dispatchingLock;
            synchronized (object) {
                Iterator iterator = batch.iterator();
                while (iterator.hasNext()) {
                    DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
                    PersistentDispatcher.this._dispatchQueue.remove(dispatchUnit);
                }
                PersistentDispatcher.this._threadsAssigned--;
            }
            batch.clear();
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"confirmBatchCompleted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleWriteError(Batch batch) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"handleWriteError");
            }
            boolean bl = false;
            if (!this._writeErrorOccurred || this._consecutiveWriteErrors == 0) {
                PersistentDispatcher.this._dispatchQueue.unassignBatchedWork(batch);
                this._writeErrorOccurred = true;
                this._goodWritesSinceLastError = 0;
                this._consecutiveWriteErrors = 1;
                this._writeErrorRetryDelay = 1L;
                Object object = PersistentDispatcher.this._dispatchingLock;
                synchronized (object) {
                    PersistentDispatcher.this.notifyWorkers();
                }
            }
            if (PersistentDispatcher.this._stopRequested) {
                PersistentDispatcher.this._stopMode = 1;
                bl = true;
            }
            if (!this._isContributingToThreadWriteErrors) {
                this._isContributingToThreadWriteErrors = true;
                PersistentDispatcher.this.threadWriteErrorOccurred(this._threadNum);
            }
            ++this._consecutiveWriteErrors;
            this._writeErrorRetryDelay = 5000 * (this._consecutiveWriteErrors > 5 ? 5 : this._consecutiveWriteErrors);
            Object object = PersistentDispatcher.this._dispatchingLock;
            synchronized (object) {
                Iterator iterator = PersistentDispatcher.this._waitingQueue.iterator();
                while (iterator.hasNext()) {
                    DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
                    DispatchNotifier dispatchNotifier = dispatchUnit.getDispatchNotifier();
                    if (dispatchNotifier.isRejectable()) {
                        dispatchNotifier.notifyRejected();
                        iterator.remove();
                        continue;
                    }
                    dispatchNotifier.notifyDispatch();
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"handleWriteError", (Object)new Boolean(bl));
            }
            return bl;
        }

        private void promoteWaiters() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"promoteWaiters");
            }
            if (!PersistentDispatcher.this._waitingQueue.isEmpty() && PersistentDispatcher.this._dispatchQueue.size() < PersistentDispatcher.this._maxPendingDispatchRequests && PersistentDispatcher.this._dispatchQueue.getPersistentSize() < PersistentDispatcher.this._maxDispatchedBytes) {
                Iterator iterator = PersistentDispatcher.this._waitingQueue.iterator();
                while (iterator.hasNext() && PersistentDispatcher.this._dispatchQueue.size() < PersistentDispatcher.this._maxPendingDispatchRequests) {
                    DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
                    if (!PersistentDispatcher.this._dispatchQueue.isEmpty() && PersistentDispatcher.this._dispatchQueue.getPersistentSize() + dispatchUnit.getPersistentSize() >= PersistentDispatcher.this._maxDispatchedBytes) break;
                    DispatchNotifier dispatchNotifier = dispatchUnit.getDispatchNotifier();
                    dispatchNotifier.notifyDispatch();
                    iterator.remove();
                    PersistentDispatcher.this._dispatchQueue.add(dispatchUnit);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"promoteWaiters");
            }
        }

        public boolean isInterruptible() {
            return this._interruptible;
        }

        public String toString() {
            return this._threadName;
        }
    }
}

