/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchNotifier;
import com.ibm.ws.sib.msgstore.persistence.impl.Tuple;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.msgstore.transactions.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class DispatchUnit {
    private static TraceComponent tc = SibTr.register((Class)DispatchUnit.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private Collection _tasks;
    private long _persistentSize;
    private PersistentTranId _tranid;
    private int _originalTranState;
    private int _tranState;
    private boolean _dispatchable;
    private boolean _assigned;
    private boolean _excludedFromConflictChecks;
    private int _assignedThreadId;
    private int _taskCount;
    private int _conflictCount;
    private long _dispatchTimeMillis;
    private DispatchNotifier _notifier;
    private boolean _isSingletonDeletion;
    private Vector _preferredOptimisations;
    DispatchUnit _next;
    DispatchUnit _previous;

    public DispatchUnit(Collection collection, PersistentTransaction persistentTransaction, long l, DispatchNotifier dispatchNotifier) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{collection, persistentTransaction, new Long(l), dispatchNotifier});
        }
        this._tasks = collection;
        if (persistentTransaction != null) {
            this._tranid = persistentTransaction.getPersistentTranId();
            this._tranState = persistentTransaction.getTransactionState();
        } else {
            this._tranid = null;
            this._tranState = 18;
        }
        this._originalTranState = this._tranState;
        this._assignedThreadId = -1;
        this._conflictCount = 0;
        this._dispatchable = true;
        this._dispatchTimeMillis = l;
        this._notifier = dispatchNotifier;
        this._isSingletonDeletion = false;
        if (collection == null) {
            this._tasks = new ArrayList();
            this._taskCount = 0;
            this._persistentSize = 0L;
        } else {
            this._taskCount = this._tasks.size();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                this._persistentSize += (long)task.getPersistableSizeApproximation(this._tranState);
                if (this._taskCount != 1) continue;
                this._isSingletonDeletion = task.isDeleteOfPersistentRepresentation();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<ctor>", (Object)this);
        }
    }

    public long getPersistentSize() {
        return this._persistentSize;
    }

    public boolean isAssigned() {
        return this._assigned;
    }

    public boolean isSingletonDeletion() {
        return this._isSingletonDeletion;
    }

    public boolean isCommittedSingletonDeletion() {
        boolean bl = false;
        if (this._isSingletonDeletion && (this._tranState == 13 || this._tranState == 15)) {
            bl = true;
        }
        return bl;
    }

    public void addPreferredOptimisation(DispatchUnit dispatchUnit) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addPreferredOptimisation", (Object)dispatchUnit);
        }
        if (this._preferredOptimisations == null) {
            this._preferredOptimisations = new Vector();
        }
        this._preferredOptimisations.add(dispatchUnit);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addPreferredOptimisation");
        }
    }

    public boolean hasPreferredOptimisations() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setExcludedFromConflictChecks");
        }
        boolean bl2 = bl = this._preferredOptimisations != null;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setExcludedFromConflictChecks", (Object)new Boolean(bl));
        }
        return bl;
    }

    public Object[] getPreferredOptimisations() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreferredOptimisations");
        }
        Object[] objectArray = null;
        objectArray = this._preferredOptimisations == null ? new Object[]{} : this._preferredOptimisations.toArray();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreferredOptimisations");
        }
        return objectArray;
    }

    public void assignToThread(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assignToThread", (Object)new Integer(n));
        }
        this._assigned = true;
        this._assignedThreadId = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assignToThread");
        }
    }

    public boolean isAssignedToThread(int n) {
        return this._assigned && this._assignedThreadId == n;
    }

    public void unassign() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unassign");
        }
        this._assigned = false;
        this._assignedThreadId = -1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unassign");
        }
    }

    public boolean isDispatchable() {
        return this._dispatchable;
    }

    public void setDispatchable(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDispatchable", (Object)new Boolean(bl));
        }
        this._conflictCount = 0;
        this._dispatchable = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDispatchable");
        }
    }

    public boolean isExcludedFromConflictChecks() {
        return this._excludedFromConflictChecks;
    }

    public void setExcludedFromConflictChecks(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setExcludedFromConflictChecks", (Object)new Boolean(bl));
        }
        this._excludedFromConflictChecks = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setExcludedFromConflictChecks");
        }
    }

    public void conflictForId(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"conflictForId", (Object)new Long(l));
        }
        ++this._conflictCount;
        this._dispatchable = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"conflictForId");
        }
    }

    public void noConflictForId(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"noConflictForId", (Object)new Long(l));
        }
        if (this._conflictCount > 0) {
            --this._conflictCount;
            if (this._conflictCount == 0) {
                this._dispatchable = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"noConflictForId");
        }
    }

    public int getConflictCount() {
        return this._conflictCount;
    }

    public Collection getTasks() {
        return this._tasks;
    }

    public PersistentTranId getTranId() {
        return this._tranid;
    }

    public int getTransactionState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTransactionState");
            SibTr.exit((TraceComponent)tc, (String)"setTransactionState", (Object)new Integer(this._tranState));
        }
        return this._tranState;
    }

    public void setTransactionState(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTransactionState", (Object)new Integer(n));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Original tran state", (Object)new Integer(this._originalTranState));
        }
        this._tranState = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTransactionState");
        }
    }

    public long getDispatchTimeMillis() {
        return this._dispatchTimeMillis;
    }

    public DispatchNotifier getDispatchNotifier() {
        return this._notifier;
    }

    public void confirmDispatch() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"confirmDispatch");
        }
        Iterator iterator = this._tasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            ((Tuple)task.getPersistable()).persistableOperationCompleted();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"confirmDispatch");
        }
    }

    public String toString() {
        Object object;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DispatchUnit@" + System.identityHashCode(this));
        stringBuffer.append("\n");
        stringBuffer.append(this._assigned ? "Assigned to thread " + this._assignedThreadId : "Not assigned");
        stringBuffer.append("\n");
        stringBuffer.append(this._dispatchable ? "Dispatchable" : "Not dispatchable");
        stringBuffer.append(", conflict count " + this._conflictCount);
        if (this._excludedFromConflictChecks) {
            stringBuffer.append(", excluded from conflict checks");
        }
        if (this._isSingletonDeletion) {
            stringBuffer.append(", is singleton deletion");
        }
        stringBuffer.append("\n");
        if (this._preferredOptimisations != null) {
            stringBuffer.append("Preferred optimisations:");
            iterator = this._preferredOptimisations.iterator();
            while (iterator.hasNext()) {
                object = (DispatchUnit)iterator.next();
                stringBuffer.append("  DU@" + System.identityHashCode(object));
            }
            stringBuffer.append("\n");
        }
        if (this._tranid != null) {
            stringBuffer.append("Transaction " + this._tranid.toString());
            switch (this._tranState) {
                case 11: {
                    stringBuffer.append(" - Preparing");
                    break;
                }
                case 13: {
                    stringBuffer.append(" - Committing 1-phase");
                    break;
                }
                case 14: {
                    stringBuffer.append(" - Committing 2-phase");
                    break;
                }
                case 15: {
                    stringBuffer.append(" - Committed");
                    break;
                }
                case 16: {
                    stringBuffer.append(" - Rolling back");
                    break;
                }
                case 17: {
                    stringBuffer.append(" - Rolled back");
                    break;
                }
                default: {
                    stringBuffer.append(" - Other (" + this._tranState + ")");
                }
            }
            if (this._originalTranState != this._tranState) {
                switch (this._originalTranState) {
                    case 11: {
                        stringBuffer.append(" (was Preparing)");
                        break;
                    }
                    case 13: {
                        stringBuffer.append(" (was Committing 1-phase)");
                        break;
                    }
                    case 14: {
                        stringBuffer.append(" (was Committing 2-phase)");
                        break;
                    }
                    case 15: {
                        stringBuffer.append(" (was Committed)");
                        break;
                    }
                    case 16: {
                        stringBuffer.append(" (was Rolling back)");
                        break;
                    }
                    case 17: {
                        stringBuffer.append(" (was Rolled back)");
                        break;
                    }
                    default: {
                        stringBuffer.append(" (was " + this._tranState + ")");
                    }
                }
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("Tasks (" + this._taskCount + "):");
        iterator = this._tasks.iterator();
        while (iterator.hasNext()) {
            object = (Task)iterator.next();
            stringBuffer.append("  ");
            stringBuffer.append(object);
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

