/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class DispatchNotifier {
    private static TraceComponent tc = SibTr.register((Class)DispatchNotifier.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private int _numRequests;
    private boolean _notified;
    private boolean _isRejectable;
    private boolean _dispatchRejected;

    public DispatchNotifier(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<ctor>", (Object)new Object[]{new Integer(n), new Boolean(bl)});
            SibTr.exit((TraceComponent)tc, (String)"<ctor>");
        }
        this._numRequests = n;
        this._isRejectable = bl;
        this._notified = false;
    }

    public synchronized void notifyDispatch() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyDispatch");
        }
        if (this._numRequests > 0) {
            --this._numRequests;
            if (this._numRequests == 0) {
                this._notified = true;
                this.notify();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyDispatch");
        }
    }

    public synchronized void forceNotify() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceNotify");
        }
        if (!this._notified) {
            this._notified = true;
            this.notify();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceNotify");
        }
    }

    public boolean isRejectable() {
        return this._isRejectable;
    }

    public synchronized void notifyRejected() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyRejected");
        }
        if (!this._isRejectable) {
            throw new IllegalStateException("!_isRejectable");
        }
        this._dispatchRejected = true;
        this.forceNotify();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyRejected");
        }
    }

    public synchronized void waitForDispatch() throws PersistenceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"waitForDispatch");
        }
        while (!this._notified) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Waiting for dispatch");
                }
                this.wait();
                if (!this._dispatchRejected) continue;
                PersistenceException persistenceException = new PersistenceException("DISPATCHER_CANNOT_ACCEPT_WORK_SIMS1500");
                if (tc.isEventEnabled()) {
                    SibTr.event((Object)this, (TraceComponent)tc, (String)"The dispatcher cannot accept work.", (Object)((Object)persistenceException));
                }
                throw persistenceException;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waitForDispatch");
        }
    }
}

