/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.DispatchUnit;
import com.ibm.ws.sib.msgstore.persistence.dispatcher.TaskMap;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class Batch {
    private static TraceComponent tc = SibTr.register((Class)Batch.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private LinkedList _dus = new LinkedList();
    private boolean _isEmpty = true;
    private int _numTasks = 0;
    private long _persistentSize = 0L;
    private TaskMap _tasksToPersistCommitting1PC = new TaskMap();
    private TaskMap _tasksToPersistPreparing = new TaskMap();
    private TaskMap _tasksToPersistCommitting2PC = new TaskMap();
    private TaskMap _tasksToPersistRollingBack = new TaskMap();
    private int _maxTasks;
    private long _maxPersistentSize;

    public Batch() {
        this(Integer.parseInt("64"), Long.parseLong("1000000"));
    }

    public Batch(int n, long l) {
        this._maxTasks = n;
        this._maxPersistentSize = l;
    }

    public boolean add(DispatchUnit dispatchUnit, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{dispatchUnit, new Boolean(bl)});
        }
        boolean bl2 = true;
        int n = dispatchUnit.getTasks().size();
        if (this._isEmpty) {
            this._isEmpty = false;
        } else if (bl && (this._numTasks + n > this._maxTasks || this._persistentSize + dispatchUnit.getPersistentSize() > this._maxPersistentSize)) {
            bl2 = false;
        }
        if (bl2) {
            this._dus.add(dispatchUnit);
            this._persistentSize += dispatchUnit.getPersistentSize();
            this._numTasks += n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    public Iterator iterator() {
        return this._dus.iterator();
    }

    public boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty");
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Boolean(this._isEmpty));
        }
        return this._isEmpty;
    }

    public void clear() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clear");
        }
        this._isEmpty = true;
        this._dus.clear();
        this._numTasks = 0;
        this._persistentSize = 0L;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean persist(BatchingContext batchingContext, MSInstrumentation mSInstrumentation) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"persist", (Object)batchingContext);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Batch to persist", (Object)this);
        }
        boolean bl = false;
        Iterator iterator = null;
        this.optimise();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Taskmap 1PC", (Object)this._tasksToPersistCommitting1PC);
            SibTr.debug((TraceComponent)tc, (String)"Taskmap P", (Object)this._tasksToPersistPreparing);
            SibTr.debug((TraceComponent)tc, (String)"Taskmap 2PC", (Object)this._tasksToPersistCommitting2PC);
            SibTr.debug((TraceComponent)tc, (String)"Taskmap R", (Object)this._tasksToPersistRollingBack);
        }
        long l = this._tasksToPersistCommitting1PC.persist(batchingContext, 13);
        l += this._tasksToPersistPreparing.persist(batchingContext, 11);
        l += this._tasksToPersistCommitting2PC.persist(batchingContext, 14);
        this._tasksToPersistRollingBack.persist(batchingContext, 16);
        iterator = this._dus.iterator();
        while (iterator.hasNext()) {
            DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
            int n = dispatchUnit.getTransactionState();
            PersistentTranId persistentTranId = dispatchUnit.getTranId();
            switch (n) {
                case 14: 
                case 16: {
                    batchingContext.deleteXID(persistentTranId);
                }
            }
        }
        try {
            block16: {
                try {
                    batchingContext.executeBatch();
                    bl = true;
                    if (mSInstrumentation == null || !mSInstrumentation.isEnabled(28) && !mSInstrumentation.isEnabled(30) && !mSInstrumentation.isEnabled(31)) break block16;
                    long l2 = System.currentTimeMillis();
                    mSInstrumentation.add(28, l2, this._numTasks);
                    if (mSInstrumentation.isEnabled(30)) {
                        mSInstrumentation.add(30, l2, this._numTasks - this._tasksToPersistCommitting1PC.size() - this._tasksToPersistPreparing.size() - this._tasksToPersistCommitting2PC.size() - this._tasksToPersistRollingBack.size());
                    }
                    mSInstrumentation.add(31, l2, this._persistentSize - l);
                }
                catch (SeverePersistenceException severePersistenceException) {
                    FFDCFilter.processException((Throwable)((Object)severePersistenceException), (String)"com.ibm.ws.sib.msgstore.persistence.dispatcher.Batch.persist", (String)"002", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Severe exception persisting batch", (Object)((Object)severePersistenceException));
                    }
                    throw new MessageStoreRuntimeException((Throwable)((Object)severePersistenceException));
                }
                catch (PersistenceException persistenceException) {
                    FFDCFilter.processException((Throwable)((Object)persistenceException), (String)"com.ibm.ws.sib.msgstore.persistence.dispatcher.Batch.persist", (String)"001", (Object)this);
                    if (tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"Exception persisting batch", (Object)((Object)persistenceException));
                    }
                    Object var11_13 = null;
                    batchingContext.clear();
                    this._tasksToPersistCommitting1PC.clear();
                    this._tasksToPersistPreparing.clear();
                    this._tasksToPersistCommitting2PC.clear();
                    this._tasksToPersistRollingBack.clear();
                }
            }
            Object var11_12 = null;
            batchingContext.clear();
            this._tasksToPersistCommitting1PC.clear();
            this._tasksToPersistPreparing.clear();
            this._tasksToPersistCommitting2PC.clear();
            this._tasksToPersistRollingBack.clear();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            batchingContext.clear();
            this._tasksToPersistCommitting1PC.clear();
            this._tasksToPersistPreparing.clear();
            this._tasksToPersistCommitting2PC.clear();
            this._tasksToPersistRollingBack.clear();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"persist", (Object)(bl ? "true" : "false"));
        }
        return bl;
    }

    public void confirmDispatch() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"confirmDispatch");
        }
        Iterator iterator = this._dus.iterator();
        while (iterator.hasNext()) {
            DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
            dispatchUnit.confirmDispatch();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"confirmDispatch");
        }
    }

    public boolean unassignBatchedWork() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unassignBatchedWork");
        }
        boolean bl = false;
        if (this._dus.size() > 1) {
            bl = true;
            Iterator iterator = this._dus.iterator();
            DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
            while (iterator.hasNext()) {
                DispatchUnit dispatchUnit2 = (DispatchUnit)iterator.next();
                dispatchUnit2.unassign();
            }
            this.clear();
            this.add(dispatchUnit, true);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unassignBatchedWork", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void optimise() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"optimise");
        }
        Iterator iterator = this._dus.iterator();
        while (iterator.hasNext()) {
            DispatchUnit dispatchUnit = (DispatchUnit)iterator.next();
            switch (dispatchUnit.getTransactionState()) {
                case 13: {
                    this.addTasksToAccumulator(dispatchUnit, this._tasksToPersistCommitting1PC, true);
                    break;
                }
                case 11: {
                    this.addTasksToAccumulator(dispatchUnit, this._tasksToPersistPreparing, false);
                    break;
                }
                case 14: {
                    this.addTasksToAccumulator(dispatchUnit, this._tasksToPersistCommitting2PC, true);
                    break;
                }
                case 16: {
                    this.addTasksToAccumulator(dispatchUnit, this._tasksToPersistRollingBack, false);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"optimise");
        }
    }

    private void addTasksToAccumulator(DispatchUnit dispatchUnit, TaskMap taskMap, boolean bl) {
        Collection collection;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTasksToAccumulator", (Object)new Object[]{dispatchUnit, taskMap, new Boolean(bl)});
        }
        if ((collection = dispatchUnit.getTasks()) != null) {
            Iterator iterator = dispatchUnit.getTasks().iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                long l = task.getPersistable().getUniqueId();
                if (bl && task.isDeleteOfPersistentRepresentation()) {
                    boolean bl2 = false;
                    Task task2 = this._tasksToPersistCommitting1PC.getFirst(l);
                    if (task2 != null && task2.isCreateOfPersistentRepresentation()) {
                        bl2 = true;
                    }
                    this._tasksToPersistCommitting1PC.remove(l);
                    this._tasksToPersistPreparing.remove(l);
                    this._tasksToPersistCommitting2PC.remove(l);
                    this._tasksToPersistRollingBack.remove(l);
                    if (bl2) continue;
                    taskMap.put(l, task);
                    continue;
                }
                taskMap.put(l, task);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTasksToAccumulator");
        }
    }
}

