/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class MultiHashMap
implements Map {
    private final int _subMapCount;
    private final SubMap[] _subMaps;

    public MultiHashMap(int n) {
        this._subMapCount = n;
        this._subMaps = new SubMap[this._subMapCount];
        for (int i = 0; i < this._subMaps.length; ++i) {
            this._subMaps[i] = new SubMap();
        }
    }

    private final SubMap _subMap(long l) {
        return this._subMaps[(int)Math.abs(l) % this._subMapCount];
    }

    public final AbstractItemLink get(long l) {
        return (AbstractItemLink)this._subMap(l).get(l);
    }

    public final void put(long l, AbstractItemLink abstractItemLink) {
        this._subMap(l).put(l, abstractItemLink);
    }

    public final AbstractItemLink remove(long l) {
        return (AbstractItemLink)this._subMap(l).remove(l);
    }

    public final void clear() {
        for (int i = 0; i < this._subMaps.length; ++i) {
            this._subMaps[i].clear();
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        for (int i = 0; i < this._subMaps.length; ++i) {
            Iterator iterator = this._subMaps[i].values().iterator();
            while (iterator.hasNext()) {
                formattedWriter.newLine();
                AbstractItemLink abstractItemLink = (AbstractItemLink)iterator.next();
                abstractItemLink.xmlShortWriteOn(formattedWriter);
            }
        }
    }

    private static final class SubMap
    extends HashMap {
        private static final long serialVersionUID = -4648138397952456765L;

        private SubMap() {
        }

        private final synchronized Object get(long l) {
            return this.get(new Long(l));
        }

        private final synchronized Object put(long l, Object object) {
            return this.put(new Long(l), object);
        }

        private final synchronized Object remove(long l) {
            return this.remove(new Long(l));
        }
    }
}

