/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;

public final class ItemMap
implements Map {
    private final int _capacityMask;
    private final Entry[] _entry;
    private final Lock[] _lock;
    private int _size;

    ItemMap(int n) {
        if (n > 30) {
            n = 30;
        } else if (n < 8) {
            n = 8;
        }
        int n2 = 2 << n;
        this._entry = new Entry[n2];
        this._lock = new Lock[n2];
        this._capacityMask = n2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Lock _getLock(int n) {
        Lock lock = this._lock[n];
        if (null != lock) return lock;
        Lock[] lockArray = this._lock;
        synchronized (this._lock) {
            this._lock[n] = lock = new Lock();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return lock;
        }
    }

    private int _indexOfKey(long l) {
        int n = (int)(l & (long)this._capacityMask);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItemLink get(long l) {
        AbstractItemLink abstractItemLink = null;
        int n = this._indexOfKey(l);
        Lock lock = this._getLock(n);
        synchronized (lock) {
            Entry entry = this._entry[n];
            while (null == abstractItemLink && null != entry) {
                if (l == entry.id) {
                    abstractItemLink = entry.link;
                    continue;
                }
                entry = entry.next;
            }
        }
        return abstractItemLink;
    }

    public final int getSize() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(long l, AbstractItemLink abstractItemLink) {
        int n = this._indexOfKey(l);
        Lock lock = this._getLock(n);
        synchronized (lock) {
            Entry entry;
            Entry entry2 = this._entry[n];
            this._entry[n] = entry = new Entry(l, abstractItemLink, entry2);
            ++this._size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AbstractItemLink remove(long l) {
        AbstractItemLink abstractItemLink = null;
        int n = this._indexOfKey(l);
        Lock lock = this._getLock(n);
        synchronized (lock) {
            Entry entry;
            Entry entry2 = entry = this._entry[n];
            while (null != entry2 && null == abstractItemLink) {
                Entry entry3 = entry2.next;
                if (l == entry2.id) {
                    abstractItemLink = entry2.link;
                    --this._size;
                    if (entry == entry2) {
                        this._entry[n] = entry3;
                    } else {
                        entry.next = entry3;
                    }
                }
                entry = entry2;
                entry2 = entry3;
            }
        }
        return abstractItemLink;
    }

    public final void clear() {
        for (int i = 0; i < this._entry.length; ++i) {
            this._entry[i] = null;
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        for (int i = 0; i < this._entry.length; ++i) {
            Entry entry = this._entry[i];
            while (null != entry) {
                AbstractItemLink abstractItemLink = entry.link;
                formattedWriter.newLine();
                abstractItemLink.xmlShortWriteOn(formattedWriter);
                entry = entry.next;
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static final class Entry {
        private final long id;
        private final AbstractItemLink link;
        private Entry next;

        Entry(long l, AbstractItemLink abstractItemLink, Entry entry) {
            this.link = abstractItemLink;
            this.next = entry;
            this.id = l;
        }

        public String toString() {
            return "" + this.id + "=" + this.link;
        }
    }
}

