/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.gbs;

import com.ibm.ws.sib.msgstore.gbs.GBSTree;
import com.ibm.ws.sib.msgstore.gbs.InsertStack;
import com.ibm.ws.sib.msgstore.gbs.NodeInsertPoint;
import com.ibm.ws.sib.msgstore.gbs.NodeStack;
import com.ibm.ws.sib.msgstore.gbs.OptimisticDepthException;
import com.ibm.ws.sib.msgstore.gbs.SearchComparator;
import java.util.Comparator;

public class GBSNode {
    private GBSNode _leftChild;
    private GBSNode _rightChild;
    private short _balance;
    private short _population;
    private GBSTree _index;
    private Object[] _nodeKey;

    private GBSNode() {
    }

    public GBSNode(GBSTree gBSTree) {
        this._index = gBSTree;
        this._nodeKey = new Object[this.width()];
        this._population = 0;
        this._balance = 0;
    }

    public GBSNode(GBSTree gBSTree, Object object) {
        this._index = gBSTree;
        this._nodeKey = new Object[this.width()];
        this.reset(object);
    }

    public GBSNode(GBSTree gBSTree, int n) {
        this._index = gBSTree;
    }

    void reset(Object object) {
        this._nodeKey[0] = object;
        this._nodeKey[this.midPoint()] = object;
        this._population = 1;
        this._rightChild = null;
        this._leftChild = null;
        this._balance = 0;
    }

    GBSTree index() {
        return this._index;
    }

    public int kFactor() {
        return this.index().kFactor();
    }

    public GBSNode leftChild() {
        return this._leftChild;
    }

    public GBSNode rightChild() {
        return this._rightChild;
    }

    public Object key(int n) {
        return this._nodeKey[n];
    }

    String keyString(int n) {
        if (this.isDummy()) {
            return "---";
        }
        return this.key(n).toString();
    }

    public Object testKey(int n) {
        if (this.isDummy()) {
            return null;
        }
        return this.key(n);
    }

    public void testSetKey(int n, Object object) {
        this._nodeKey[n] = object;
    }

    public void testIncrementPopulation() {
        this._population = (short)(this._population + 1);
    }

    boolean hasChild() {
        boolean bl = false;
        if (this.leftChild() != null || this.rightChild() != null) {
            bl = true;
        }
        return bl;
    }

    private boolean isDummy() {
        boolean bl = false;
        if (this._nodeKey == null) {
            bl = true;
        }
        return bl;
    }

    public short balance() {
        if (this._balance == -1 || this._balance == 0 || this._balance == 1) {
            return this._balance;
        }
        String string = "Found invalid balance factor: " + this._balance;
        throw new RuntimeException(string);
    }

    void clearBalance() {
        this._balance = 0;
    }

    void setBalance(int n) {
        if (n != -1 && n != 0 && n != 1) {
            String string = "Attempt to set invalid balance factor: " + n;
            throw new IllegalArgumentException(string);
        }
        this._balance = (short)n;
    }

    public int population() {
        return this._population;
    }

    void decrementPopulation() {
        if (this._population <= 0) {
            String string = "Attempt to make node population negative.\nCurrent population = " + this._population + ".";
            throw new IllegalArgumentException(string);
        }
        this._population = (short)(this._population - 1);
    }

    public boolean isFull() {
        boolean bl = false;
        if (this.population() == this.width()) {
            bl = true;
        }
        return bl;
    }

    public boolean isInnerNode() {
        boolean bl = true;
        if (this._leftChild == null || this._rightChild == null) {
            bl = false;
        }
        return bl;
    }

    public boolean isLeafNode() {
        boolean bl = false;
        if (this._leftChild == null && this._rightChild == null) {
            bl = true;
        }
        return bl;
    }

    public int width() {
        return this.index().nodeWidth();
    }

    int midPoint() {
        return this.index().nodeMidPoint();
    }

    public Object middleKey() {
        return this._nodeKey[this.midPoint()];
    }

    public Object leftMostKey() {
        return this._nodeKey[0];
    }

    public String lmkString() {
        if (this.isDummy()) {
            return "---";
        }
        return this._nodeKey[0].toString();
    }

    private int endPoint() {
        int n = this.midPoint();
        int n2 = this.rightMostIndex();
        if (n2 < this.midPoint()) {
            n = n2;
        }
        return n;
    }

    void findInsertPointInLeft(Object object, NodeInsertPoint nodeInsertPoint) {
        int n = this.endPoint();
        this.findIndex(0, n, object, nodeInsertPoint);
    }

    void findInsertPointInRight(Object object, NodeInsertPoint nodeInsertPoint) {
        int n;
        int n2 = this.rightMostIndex();
        if (n2 <= (n = this.midPoint())) {
            String string = "Erroneous call to findInsertPointInRight(). rightMostIndex() = " + n2 + ", midPoint() = " + n + ".";
            throw new OptimisticDepthException(string);
        }
        this.findIndex(n + 1, n2, object, nodeInsertPoint);
    }

    public void setRightChild(GBSNode gBSNode) {
        this._rightChild = gBSNode;
    }

    void clearRightChild() {
        this._rightChild = null;
    }

    public void setLeftChild(GBSNode gBSNode) {
        this._leftChild = gBSNode;
    }

    void clearLeftChild() {
        this._leftChild = null;
    }

    public void setChildren(GBSNode gBSNode, GBSNode gBSNode2) {
        this._leftChild = gBSNode;
        this._rightChild = gBSNode2;
    }

    public int searchLeft(SearchComparator searchComparator, Object object) {
        int n = -1;
        int n2 = this.middleIndex();
        n = searchComparator.type() == 1 ? this.findEqual(searchComparator, 0, n2, object) : this.findGreater(searchComparator, 0, n2, object);
        return n;
    }

    public int searchRight(SearchComparator searchComparator, Object object) {
        int n;
        int n2 = -1;
        int n3 = this.middleIndex();
        if (n3 > (n = this.rightMostIndex())) {
            String string = "bot = " + n3 + ", right = " + n;
            throw new OptimisticDepthException(string);
        }
        n2 = searchComparator.type() == 1 ? this.findEqual(searchComparator, n3, n, object) : this.findGreater(searchComparator, n3, n, object);
        return n2;
    }

    int searchAll(SearchComparator searchComparator, Object object) {
        int n = -1;
        n = searchComparator.type() == 1 ? this.findEqual(searchComparator, 0, this.rightMostIndex(), object) : this.findGreater(searchComparator, 0, this.rightMostIndex(), object);
        return n;
    }

    private int findEqual(SearchComparator searchComparator, int n, int n2, Object object) {
        int n3 = GBSNode.numKeys(n, n2);
        int n4 = -1;
        n4 = n3 < 4 ? this.sequentialSearchEqual(searchComparator, n, n2, object) : this.binarySearchEqual(searchComparator, n, n2, object);
        return n4;
    }

    private int sequentialSearchEqual(SearchComparator searchComparator, int n, int n2, Object object) {
        int n3 = -1;
        for (int i = n; i <= n2; ++i) {
            int n4 = searchComparator.compare(object, this._nodeKey[i]);
            if (n4 != 0) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private int binarySearchEqual(SearchComparator searchComparator, int n, int n2, Object object) {
        int n3 = -1;
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = searchComparator.compare(object, this._nodeKey[n4]);
            if (n5 < 0) {
                n2 = n4 - 1;
                continue;
            }
            if (n5 > 0) {
                n = n4 + 1;
                continue;
            }
            n3 = n4;
            break;
        }
        return n3;
    }

    private int findGreater(SearchComparator searchComparator, int n, int n2, Object object) {
        int n3 = GBSNode.numKeys(n, n2);
        int n4 = -1;
        n4 = n3 < 4 ? this.sequentialSearchGreater(searchComparator, n, n2, object) : this.binarySearchGreater(searchComparator, n, n2, object);
        return n4;
    }

    private int sequentialSearchGreater(SearchComparator searchComparator, int n, int n2, Object object) {
        int n3 = -1;
        for (int i = n; i <= n2; ++i) {
            int n4 = searchComparator.compare(object, this._nodeKey[i]);
            if (n4 > 0) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private int binarySearchGreater(SearchComparator searchComparator, int n, int n2, Object object) {
        int n3 = -1;
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = searchComparator.compare(object, this._nodeKey[n4]);
            if (n5 < 0) {
                n2 = n4 - 1;
                n3 = n4;
                continue;
            }
            if (n5 <= 0) continue;
            n = n4 + 1;
        }
        return n3;
    }

    private void findIndex(int n, int n2, Object object, NodeInsertPoint nodeInsertPoint) {
        int n3 = GBSNode.numKeys(n, n2);
        if (n3 < 4) {
            this.sequentialFindIndex(n, n2, object, nodeInsertPoint);
        } else {
            this.binaryFindIndex(n, n2, object, nodeInsertPoint);
        }
    }

    private void sequentialFindIndex(int n, int n2, Object object, NodeInsertPoint nodeInsertPoint) {
        Comparator comparator = this.insertComparator();
        int n3 = 1;
        int n4 = this.rightMostIndex() + 1;
        for (int i = n; i <= n2; ++i) {
            int n5 = comparator.compare(object, this._nodeKey[i]);
            if (n5 > 0) continue;
            n4 = i;
            n3 = n5;
            break;
        }
        if (n3 != 0) {
            nodeInsertPoint.setInsertPoint(n4 - 1);
        } else {
            nodeInsertPoint.markDuplicate(n4);
        }
    }

    private void binaryFindIndex(int n, int n2, Object object, NodeInsertPoint nodeInsertPoint) {
        Comparator comparator = this.insertComparator();
        int n3 = 1;
        int n4 = n2 + 1;
        while (n <= n2) {
            int n5 = (n + n2) / 2;
            int n6 = comparator.compare(object, this._nodeKey[n5]);
            if (n6 <= 0) {
                n2 = n5 - 1;
                n4 = n5;
                n3 = n6;
                continue;
            }
            n = n5 + 1;
        }
        if (n3 != 0) {
            nodeInsertPoint.setInsertPoint(n4 - 1);
        } else {
            nodeInsertPoint.markDuplicate(n4);
        }
    }

    int findDeleteInRight(Object object) {
        int n;
        int n2 = -1;
        int n3 = this.rightMostIndex();
        if (n3 > (n = this.midPoint())) {
            n2 = this.findDelete(n, n3, object);
        }
        return n2;
    }

    int findDeleteInLeft(Object object) {
        int n = this.endPoint();
        return this.findDelete(0, n, object);
    }

    int findDelete(int n, int n2, Object object) {
        int n3 = GBSNode.numKeys(n, n2);
        int n4 = -1;
        n4 = n3 < 4 ? this.sequentialFindDelete(n, n2, object) : this.binaryFindDelete(n, n2, object);
        return n4;
    }

    private int sequentialFindDelete(int n, int n2, Object object) {
        Comparator comparator = this.deleteComparator();
        int n3 = -1;
        for (int i = n; i <= n2; ++i) {
            int n4 = comparator.compare(object, this._nodeKey[i]);
            if (n4 != 0) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    private int binaryFindDelete(int n, int n2, Object object) {
        Comparator comparator = this.insertComparator();
        int n3 = -1;
        while (n <= n2) {
            int n4 = (n + n2) / 2;
            int n5 = comparator.compare(object, this._nodeKey[n4]);
            if (n5 < 0) {
                n2 = n4 - 1;
                continue;
            }
            if (n5 > 0) {
                n = n4 + 1;
                continue;
            }
            n3 = n4;
            break;
        }
        return n3;
    }

    public Comparator insertComparator() {
        return this.index().insertComparator();
    }

    Comparator deleteComparator() {
        return this.index().deleteComparator();
    }

    private int numKeys() {
        return GBSNode.numKeys(0, this.rightMostIndex());
    }

    private static int numKeys(int n, int n2) {
        if (n > n2) {
            String string = "Lower bound greater than upper bound.  lower = " + n + ", upper = " + n2 + ".";
            throw new IllegalArgumentException(string);
        }
        return n2 - n + 1;
    }

    public int rightMostIndex() {
        int n = this.population() - 1;
        if (n == -1) {
            throw new OptimisticDepthException("Empty Node.");
        }
        return n;
    }

    public int topMostIndex() {
        return this.width() - 1;
    }

    public int middleIndex() {
        int n = this.midPoint();
        int n2 = this.rightMostIndex();
        if (n2 < this.midPoint()) {
            n = n2;
        }
        return n;
    }

    boolean lessThanHalfFull() {
        boolean bl = false;
        if (this.rightMostIndex() <= this.midPoint()) {
            bl = true;
        }
        return bl;
    }

    public Object rightMostKey() {
        return this._nodeKey[this.rightMostIndex()];
    }

    void addRightLeaf(Object object) {
        GBSNode gBSNode = this._index.getNode(object);
        if (this.rightChild() != null) {
            throw new RuntimeException("Help!");
        }
        this.setRightChild(gBSNode);
    }

    Object insertByLeftShift(int n, Object object) {
        Object object2 = this.leftMostKey();
        this.leftShift(n);
        this._nodeKey[n] = object;
        if (this.midPoint() > this.rightMostIndex()) {
            this._nodeKey[this.midPoint()] = this.rightMostKey();
        }
        return object2;
    }

    void deleteByLeftShift(int n) {
        this.overlayLeftShift(n);
        this._population = (short)(this._population - 1);
    }

    private void leftShift(int n) {
        for (int i = 0; i < n; ++i) {
            this._nodeKey[i] = this._nodeKey[i + 1];
        }
    }

    Object insertByRightShift(int n, Object object) {
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.rightMostKey();
            this.rightMove(n + 1);
            this._nodeKey[n + 1] = object;
        } else {
            this.rightShift(n + 1);
            this._nodeKey[n + 1] = object;
            this._population = (short)(this._population + 1);
            if (this.midPoint() > this.rightMostIndex()) {
                this._nodeKey[this.midPoint()] = this.rightMostKey();
            }
        }
        return object2;
    }

    public Object addLeftMostKey(Object object) {
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.rightMostKey();
            this.rightMove(0);
            this._nodeKey[0] = object;
        } else {
            this.rightShift(0);
            this._population = (short)(this._population + 1);
            this._nodeKey[0] = object;
            if (this.midPoint() > this.rightMostIndex()) {
                this._nodeKey[this.midPoint()] = this.rightMostKey();
            }
        }
        return object2;
    }

    Object addRightMostKey(Object object) {
        Object object2 = null;
        if (this.isFull()) {
            object2 = this.rightMostKey();
            this._nodeKey[this.rightMostIndex()] = object;
        } else {
            this._population = (short)(this._population + 1);
            this._nodeKey[this.rightMostIndex()] = object;
            if (this.midPoint() > this.rightMostIndex()) {
                this._nodeKey[this.midPoint()] = this.rightMostKey();
            }
        }
        return object2;
    }

    void addLeftMostKeyByDelete(int n, Object object) {
        this.overlayRightShift(n);
        this.overlayLeftMostKey(object);
    }

    void addRightMostKeyByDelete(int n, Object object) {
        this.overlayLeftShift(n);
        this.overlayRightMostKey(object);
    }

    void overlayLeftMostKey(Object object) {
        this._nodeKey[0] = object;
    }

    void overlayRightMostKey(Object object) {
        this._nodeKey[this.rightMostIndex()] = object;
    }

    void fillFromRight() {
        int n;
        int n2 = this.width() - this.population();
        int n3 = this.population();
        GBSNode gBSNode = this.rightChild();
        for (n = 0; n < n2; ++n) {
            this._nodeKey[n + n3] = gBSNode._nodeKey[n];
        }
        n = n2;
        if (gBSNode._population < n) {
            n = gBSNode._population;
        }
        this._population = (short)(this._population + n);
        gBSNode._population = (short)(gBSNode._population - n);
        for (int i = 0; i < n3; ++i) {
            gBSNode._nodeKey[i] = gBSNode._nodeKey[i + n2];
        }
    }

    void adjustMedian() {
        if (this.midPoint() > this.rightMostIndex()) {
            this._nodeKey[this.midPoint()] = this.rightMostKey();
        }
    }

    GBSNode rightMostChild() {
        GBSNode gBSNode = this;
        for (GBSNode gBSNode2 = this.rightChild(); gBSNode2 != null; gBSNode2 = gBSNode2.rightChild()) {
            gBSNode = gBSNode2;
        }
        return gBSNode;
    }

    private void rightShift(int n) {
        for (int i = this.rightMostIndex(); i >= n; --i) {
            this._nodeKey[i + 1] = this._nodeKey[i];
        }
    }

    private void rightMove(int n) {
        for (int i = this.rightMostIndex() - 1; i >= n; --i) {
            this._nodeKey[i + 1] = this._nodeKey[i];
        }
    }

    void overlayLeftShift(int n) {
        for (int i = n; i < this.rightMostIndex(); ++i) {
            this._nodeKey[i] = this._nodeKey[i + 1];
        }
    }

    private void overlayRightShift(int n) {
        for (int i = n; i > 0; --i) {
            this._nodeKey[i] = this._nodeKey[i - 1];
        }
    }

    GBSNode lowerPredecessor(NodeStack nodeStack) {
        GBSNode gBSNode;
        GBSNode gBSNode2 = gBSNode = this.leftChild();
        if (gBSNode != null) {
            nodeStack.push(2, this);
        }
        while (gBSNode != null) {
            if (gBSNode.rightChild() != null) {
                nodeStack.push(4, gBSNode);
            }
            gBSNode2 = gBSNode;
            gBSNode = gBSNode.rightChild();
        }
        return gBSNode2;
    }

    GBSNode lowerSuccessor(NodeStack nodeStack) {
        GBSNode gBSNode;
        GBSNode gBSNode2 = gBSNode = this.rightChild();
        if (gBSNode != null) {
            nodeStack.push(4, this);
        }
        while (gBSNode != null) {
            if (gBSNode.leftChild() != null) {
                nodeStack.push(2, gBSNode);
            }
            gBSNode2 = gBSNode;
            gBSNode = gBSNode.leftChild();
        }
        return gBSNode2;
    }

    GBSNode leftMostChild(InsertStack insertStack) {
        insertStack.start(this, "GBSNode.leftMostChild");
        GBSNode gBSNode = this;
        for (GBSNode gBSNode2 = this.leftChild(); gBSNode2 != null; gBSNode2 = gBSNode2.leftChild()) {
            insertStack.push(0, gBSNode2);
            gBSNode = gBSNode2;
        }
        return gBSNode;
    }

    public GBSNode testClone(GBSTree gBSTree) {
        GBSNode gBSNode = new GBSNode(gBSTree, this.leftMostKey());
        for (int i = 1; i < this.population(); ++i) {
            gBSNode._nodeKey[i] = this._nodeKey[i];
        }
        gBSNode._population = this._population;
        gBSNode.adjustMedian();
        return gBSNode;
    }

    public boolean validate() {
        boolean bl = true;
        if (this.population() > 1) {
            Comparator comparator = this.index().insertComparator();
            int n = 0;
            for (int i = 0; i < this.population() - 1; ++i) {
                n = comparator.compare(this._nodeKey[i], this._nodeKey[i + 1]);
                if (n < 0) continue;
                System.out.println("Entry " + i + " not less than entry " + i + 1);
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "width = " + this.width() + ", " + "midPoint = " + this.midPoint() + ", " + "population = " + this.population() + ", " + "rightMostIndex = " + this.rightMostIndex() + ", " + "balance = " + this.balance();
        stringBuffer.append(string);
        if (this._nodeKey != null) {
            stringBuffer.append("\n ");
            stringBuffer.append("middleKey = " + this.middleKey());
            if (this.population() != 0) {
                stringBuffer.append("\n");
                stringBuffer.append("{");
                for (int i = 0; i <= this.rightMostIndex(); ++i) {
                    stringBuffer.append("[" + i + "]: " + this._nodeKey[i]);
                    if (i == this.rightMostIndex()) continue;
                    stringBuffer.append(", ");
                }
                stringBuffer.append("}\n ");
            }
            if (this.leftChild() != null) {
                stringBuffer.append("Has left child.");
            } else {
                stringBuffer.append("Left child null.");
            }
            if (this.rightChild() != null) {
                stringBuffer.append("  Has right child.");
            } else {
                stringBuffer.append("  Right child null.");
            }
        }
        String string2 = stringBuffer.toString();
        return string2;
    }
}

