/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.expiry;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.expiry.Expirable;
import com.ibm.ws.sib.msgstore.expiry.ExpirableReference;
import com.ibm.ws.sib.msgstore.expiry.ExpiryIndex;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentation;
import com.ibm.ws.sib.msgstore.pmi.MSInstrumentor;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Expirer
implements AlarmListener,
MSInstrumentor {
    private static TraceComponent tc = SibTr.register((Class)Expirer.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    public static final String XML_EXPIRER = "Expirer";
    public static final String XML_STORED_EXCEPTION = "storedException";
    private static final int BATCH_SIZE = 20;
    private static final int CLEANUP_EVERY_N_CYCLES = 5;
    private static final int MAX_DIAG_LOG = 30;
    private ExpiryIndex expiryIndex = null;
    private Object lockObject = new Object();
    private Alarm expiryAlarm = null;
    private long interval = 0L;
    private boolean runEnabled = false;
    private boolean addEnabled = true;
    private MessageStoreImpl messageStore = null;
    private MSInstrumentation instrumentation = null;
    private JsMessagingEngine messagingEngine = null;
    private Exception lastException = null;
    private long lastExceptionTime = 0L;
    private long expirerStartTime = 0L;
    private long expirerStopTime = 0L;
    private long startTime = 0L;
    private boolean cleanupDeletedItems = false;
    private int diagIndex = 0;
    private long[] alarmTime = new long[30];
    private long[] logIndexSize = new long[30];
    private long[] logProcessed = new long[30];
    private long[] logExpired = new long[30];
    private long[] logRemain = new long[30];
    private long[] logGone = new long[30];
    private long[] logCleaned = new long[30];
    private int countForCleanup = 0;
    private ExternalLocalTransaction transaction = null;
    private int batchCount = 0;
    private int cleanupLimit = 5;

    public Expirer(MessageStoreImpl messageStoreImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.messageStore = messageStoreImpl;
        this.expiryIndex = new ExpiryIndex();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addExpirable(Expirable expirable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addExpirable", (Object)("objId=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetID())) + " addEnabled=" + this.addEnabled));
        }
        boolean bl = false;
        if (this.addEnabled && expirable != null) {
            long l = expirable.expirableGetExpiryTime();
            ExpirableReference expirableReference = new ExpirableReference(expirable);
            expirableReference.setExpiryTime(l);
            Object object = this.lockObject;
            synchronized (object) {
                if (expirable.expirableIsInStore()) {
                    bl = this.expiryIndex.put(expirableReference);
                    if (bl) {
                        boolean bl2 = false;
                        if (this.runEnabled && this.expiryIndex.size() == 1) {
                            this.scheduleAlarm(this.interval);
                            bl2 = true;
                        }
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Added: ET=" + expirableReference.getExpiryTime() + " objId=" + expirableReference.getID() + " scheduled=" + bl2));
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Duplicate expirable: ET=" + expirableReference.getExpiryTime() + " objId=" + expirableReference.getID()));
                        }
                        this.runEnabled = false;
                        Object[] objectArray = new Object[]{expirableReference.getExpiryTime() + " : " + expirableReference.getID()};
                        MessageStoreRuntimeException messageStoreRuntimeException = new MessageStoreRuntimeException("DUPLICATE_EXPIRABLE_SIMS2000", objectArray);
                        this.lastException = messageStoreRuntimeException;
                        this.lastExceptionTime = Expirer.timeNow();
                        throw messageStoreRuntimeException;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addExpirable", (Object)("reply=" + bl));
        }
        return bl;
    }

    public final boolean isRunning() {
        return this.runEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeExpirable(Expirable expirable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeExpirable", (Object)("objId=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetID())) + " ET=" + (expirable == null ? "null" : String.valueOf(expirable.expirableGetExpiryTime())) + " addEnabled=" + this.addEnabled));
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.addEnabled && expirable != null) {
            long l = expirable.expirableGetExpiryTime();
            ExpirableReference expirableReference = new ExpirableReference(expirable);
            expirableReference.setExpiryTime(l);
            Object object = this.lockObject;
            synchronized (object) {
                bl = this.expiryIndex.remove(expirableReference);
                if (bl && this.expiryIndex.size() <= 0 && this.expiryAlarm != null) {
                    this.expiryAlarm.cancel();
                    bl2 = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeExpirable", (Object)("reply=" + bl + " cancelled=" + bl2));
        }
        return bl;
    }

    public final int size() {
        int n = this.expiryIndex.size();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(long l, JsMessagingEngine jsMessagingEngine) {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"start", (Object)("interval=" + l + " indexSize=" + this.expiryIndex.size()));
        }
        this.messagingEngine = jsMessagingEngine;
        this.instrumentation = this.messageStore._getInstrumentation();
        this.instrumentation.registerInstrumentor(this, 32);
        if (l >= 0L) {
            this.interval = l;
        } else {
            object = this.messageStore.getProperty("expiryInterval", "1000");
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"start", (Object)("Value from property=<" + object + ">"));
            }
            try {
                this.interval = Long.parseLong(object.trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.lastException = numberFormatException;
                this.lastExceptionTime = Expirer.timeNow();
                SibTr.debug((TraceComponent)tc, (String)"start", (Object)("Unable to parse property: " + numberFormatException));
                this.interval = 1000L;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"start", (Object)("expiryInterval=" + this.interval));
        }
        if (this.interval < 1L) {
            this.runEnabled = false;
            this.addEnabled = false;
        } else if (this.expiryAlarm == null) {
            this.runEnabled = true;
            this.addEnabled = true;
            this.expirerStartTime = Expirer.timeNow();
            object = this.lockObject;
            synchronized (object) {
                if (this.expiryIndex.size() > 0) {
                    this.scheduleAlarm(this.interval);
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Expiry already started");
            }
            object = new MessageStoreRuntimeException("EXPIRY_THREAD_ALREADY_RUNNING_SIMS2004");
            this.lastException = object;
            this.lastExceptionTime = Expirer.timeNow();
            throw object;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start", (Object)("runEnabled=" + this.runEnabled + " addEnabled=" + this.addEnabled + " interval=" + this.interval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        Expirer expirer = this;
        synchronized (expirer) {
            this.addEnabled = false;
            if (this.runEnabled) {
                this.runEnabled = false;
                this.expirerStopTime = Expirer.timeNow();
            }
            if (this.expiryAlarm != null) {
                this.expiryAlarm.cancel();
                this.expiryAlarm = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object object) {
        if (this.messagingEngine != null) {
            SibTr.push((Object)this.messagingEngine);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)("Expiry=" + this.expiryIndex.size()));
        }
        boolean bl = false;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        try {
            Expirable expirable;
            ++this.countForCleanup;
            if (this.countForCleanup >= this.cleanupLimit) {
                this.countForCleanup = 0;
                this.cleanupDeletedItems = true;
            } else {
                this.cleanupDeletedItems = false;
            }
            this.startTime = System.currentTimeMillis();
            n = this.saveStartTime(this.startTime);
            this.expiryIndex.resetIterator();
            ExpirableReference expirableReference = this.expiryIndex.next();
            while (this.runEnabled && expirableReference != null && expirableReference.getExpiryTime() <= this.startTime) {
                ++l;
                expirable = (Expirable)expirableReference.get();
                if (expirable != null && expirable.expirableIsInStore()) {
                    if (this.transaction == null) {
                        this.transaction = this.messageStore.getTransactionFactory().createLocalTransaction();
                    }
                    if (expirable.expirableExpire(this.transaction)) {
                        ++l2;
                        this.remove(expirableReference, true);
                        ++this.batchCount;
                        if (this.batchCount >= 20) {
                            this.transaction.commit();
                            this.transaction = null;
                            this.batchCount = 0;
                        }
                    } else {
                        ++l5;
                    }
                } else if (this.remove(expirableReference, false)) {
                    ++l4;
                }
                expirableReference = this.expiryIndex.next();
            }
            if (this.cleanupDeletedItems) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Expiry cleanup in progress");
                }
                while (this.runEnabled && expirableReference != null) {
                    expirable = (Expirable)expirableReference.get();
                    if ((expirable == null || !expirable.expirableIsInStore()) && this.remove(expirableReference, false)) {
                        ++l3;
                    }
                    expirableReference = this.expiryIndex.next();
                }
                if (l3 < 10L && this.cleanupLimit < 100) {
                    this.cleanupLimit += 5;
                } else if (l3 > 1000L && this.cleanupLimit > 5) {
                    this.cleanupLimit = 5;
                } else if (l3 > 100L && this.cleanupLimit > 5) {
                    this.cleanupLimit -= 5;
                }
            }
            if (this.transaction != null) {
                if (this.batchCount == 0) {
                    this.transaction.rollback();
                } else {
                    this.transaction.commit();
                    this.batchCount = 0;
                }
                this.transaction = null;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.msgstore.expiry.Expirer.run", (String)"441", (Object)this);
            this.lastException = exception;
            this.lastExceptionTime = Expirer.timeNow();
            this.runEnabled = false;
            this.addEnabled = false;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"alarm", (Object)("Expiry stopping - interrupted: " + exception));
            }
            throw new MessageStoreRuntimeException("EXPIRY_DAEMON_TERMINATED_SIMS2001", new Object[]{exception}, exception);
        }
        long l6 = 0L;
        Object object2 = this.lockObject;
        synchronized (object2) {
            l6 = this.expiryIndex.size();
            if (this.runEnabled) {
                if (l6 > 0L) {
                    this.scheduleAlarm(this.interval);
                    bl = true;
                }
            } else {
                this.addEnabled = false;
            }
        }
        this.instrumentation.setCount(32, l6);
        this.logIndexSize[n] = l6;
        this.logProcessed[n] = l;
        this.logExpired[n] = l2;
        this.logGone[n] = l4;
        this.logRemain[n] = l5;
        this.logCleaned[n] = l3;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alarm", (Object)(" processed=" + l + " gone=" + l4 + " expired=" + l2 + " remain=" + l5 + " cleaned=" + l3 + " expiry=" + l6 + " cl=" + this.cleanupLimit + " alarmScheduled=" + bl));
        }
        if (this.messagingEngine != null) {
            SibTr.pop();
        }
    }

    private final boolean remove(ExpirableReference expirableReference, boolean bl) {
        boolean bl2 = this.expiryIndex.remove();
        if (bl2) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Removed (" + (bl ? "expired" : "gone") + ")" + " ET=" + expirableReference.getExpiryTime() + " objId=" + expirableReference.getID()));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Unable to remove from index:  ET=" + expirableReference.getExpiryTime() + " objId=" + expirableReference.getID()));
        }
        return bl2;
    }

    private int saveStartTime(long l) {
        int n = this.diagIndex;
        this.alarmTime[this.diagIndex++] = l;
        if (this.diagIndex >= 30) {
            this.diagIndex = 0;
        }
        return n;
    }

    private void scheduleAlarm(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("scheduleAlarm timeOut=" + l));
        }
        this.expiryAlarm = AlarmManager.createNonDeferrable((long)l, (AlarmListener)this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleAlarm");
        }
    }

    public static long timeNow() {
        return System.currentTimeMillis();
    }

    public void requestStatUpdate(int n) {
        switch (n) {
            case 32: {
                this.instrumentation.setCount(32, this.expiryIndex.size());
                break;
            }
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd @ HH:mm:ss.SSS");
        String string = simpleDateFormat.format(new Date());
        formattedWriter.newLine();
        formattedWriter.startTag(XML_EXPIRER);
        formattedWriter.indent();
        formattedWriter.newLine();
        formattedWriter.taggedValue("timeNow", (Object)string);
        formattedWriter.newLine();
        formattedWriter.taggedValue("interval", this.interval);
        formattedWriter.newLine();
        formattedWriter.taggedValue("addEnabled", (Object)new Boolean(this.addEnabled));
        formattedWriter.newLine();
        formattedWriter.taggedValue("runEnabled", (Object)new Boolean(this.runEnabled));
        formattedWriter.newLine();
        formattedWriter.taggedValue("cleanupFlag", (Object)new Boolean(this.cleanupDeletedItems));
        formattedWriter.newLine();
        formattedWriter.taggedValue("expirerStartTime", (Object)simpleDateFormat.format(new Date(this.expirerStartTime)));
        formattedWriter.newLine();
        formattedWriter.taggedValue("expirerStopTime", (Object)simpleDateFormat.format(new Date(this.expirerStopTime)));
        formattedWriter.newLine();
        formattedWriter.taggedValue("nextLogIndex", (long)this.diagIndex);
        formattedWriter.newLine();
        for (int i = 0; i < 30; ++i) {
            String string2 = "Cycle=" + i + (this.diagIndex == i ? ":*" : ": ") + simpleDateFormat.format(new Date(this.alarmTime[i])) + " size=" + this.logIndexSize[i] + " processed=" + this.logProcessed[i] + " expired=" + this.logExpired[i] + " remain=" + this.logRemain[i] + " gone=" + this.logGone[i] + " cleaned=" + this.logCleaned[i];
            formattedWriter.taggedValue("info", (Object)string2);
            formattedWriter.newLine();
        }
        formattedWriter.startTag(XML_STORED_EXCEPTION);
        if (this.lastException == null) {
            formattedWriter.write("No exceptions recorded");
        } else {
            formattedWriter.indent();
            formattedWriter.newLine();
            formattedWriter.taggedValue("time", (Object)new Date(this.lastExceptionTime));
            formattedWriter.outdent();
            formattedWriter.write((Throwable)this.lastException);
            formattedWriter.newLine();
        }
        formattedWriter.endTag(XML_STORED_EXCEPTION);
        formattedWriter.outdent();
        formattedWriter.newLine();
        formattedWriter.endTag(XML_EXPIRER);
    }
}

